/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.python.pydev.editor.hover.PyEditorTextHoverDescriptor;

public abstract class ConfigurationElementAttributeSorter {
    private String attName;

    public final void sort(Object[] elements, String attribute) {
        this.attName = attribute;
        Arrays.sort(elements, new ConfigurationElementAttributeComparator<Object>(elements, attribute));
    }

    public abstract IConfigurationElement getConfigurationElement(Object var1);

    private class ConfigurationElementAttributeComparator<O>
    implements Comparator<O> {
        public ConfigurationElementAttributeComparator(O[] elements, String attribute) {
            Assert.isNotNull(elements);
        }

        @Override
        public int compare(O object0, O object1) {
            if (object0 instanceof PyEditorTextHoverDescriptor && object1 instanceof PyEditorTextHoverDescriptor) {
                PyEditorTextHoverDescriptor descr0 = (PyEditorTextHoverDescriptor)object0;
                PyEditorTextHoverDescriptor descr1 = (PyEditorTextHoverDescriptor)object1;
                if (descr0.getPriority() != null && descr1.getPriority() != null) {
                    return descr0.getPriority().compareTo(descr1.getPriority());
                }
                IConfigurationElement e0 = ConfigurationElementAttributeSorter.this.getConfigurationElement(object0);
                IConfigurationElement e1 = ConfigurationElementAttributeSorter.this.getConfigurationElement(object1);
                if (e0 != null && e1 != null) {
                    String e0String = e0.getAttribute(ConfigurationElementAttributeSorter.this.attName);
                    String e1String = e1.getAttribute(ConfigurationElementAttributeSorter.this.attName);
                    if (e0String != null && e1String != null) {
                        Integer val0 = null;
                        Integer val1 = null;
                        try {
                            val0 = Integer.parseInt(e0String);
                            val1 = Integer.parseInt(e1String);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return e0String.compareTo(e1String);
                        }
                        if (val0 != null && val1 != null) {
                            return val0.compareTo(val1);
                        }
                    }
                }
            }
            return 0;
        }
    }
}

