/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.outline;

import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.ASTEntryWithChildren;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.model.ErrorDescription;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.outline.BaseParsedItem;
import org.python.pydev.shared_ui.outline.IParsedItem;

public class ParsedItem
extends BaseParsedItem {
    protected ASTEntryWithChildren astThis;
    protected ASTEntryWithChildren[] astChildrenEntries;
    private static final int QUALIFIER_PUBLIC = 0;
    private static final int QUALIFIER_PROTECTED = 1;
    private static final int QUALIFIER_PRIVATE = 2;

    public ParsedItem(ParsedItem parent, ASTEntryWithChildren root, ASTEntryWithChildren[] astChildren) {
        this(astChildren, null);
        this.parent = parent;
        this.astThis = root;
    }

    public int getBeginCol() {
        ASTEntryWithChildren astThis = this.getAstThis();
        if (astThis != null && astThis.node != null) {
            return astThis.node.beginColumn;
        }
        return -1;
    }

    public ParsedItem(ParsedItem parent, ErrorDescription errorDesc) {
        this.parent = parent;
        this.setErrorDesc(errorDesc);
    }

    public ParsedItem(ASTEntryWithChildren[] astChildren, ErrorDescription errorDesc) {
        this.astChildrenEntries = astChildren;
        this.setErrorDesc(errorDesc);
    }

    public void updateTo(IParsedItem item) {
        ParsedItem updateToItem = (ParsedItem)item;
        this.astThis = updateToItem.astThis;
        this.astChildrenEntries = updateToItem.astChildrenEntries;
        super.updateTo(item);
    }

    public int getBeginLine() {
        ASTEntryWithChildren astThis = this.getAstThis();
        if (astThis != null && astThis.node != null) {
            return astThis.node.beginLine;
        }
        return -1;
    }

    public ASTEntryWithChildren getAstThis() {
        return this.astThis;
    }

    public void setAstThis(ASTEntryWithChildren astThis) {
        this.setAstThis(astThis, null);
    }

    public void setAstThis(ASTEntryWithChildren astThis, ASTEntryWithChildren[] astChildrenEntries) {
        this.toStringCache = null;
        this.astThis = astThis;
        if (astChildrenEntries != null) {
            this.astChildrenEntries = astChildrenEntries;
            this.children = null;
        }
    }

    public ASTEntryWithChildren[] getAstChildrenEntries() {
        return this.astChildrenEntries;
    }

    private static int qualifierFromName(String name) {
        if (name.startsWith("__")) {
            if (!name.endsWith("__")) {
                return 2;
            }
            return 0;
        }
        if (name.startsWith("_")) {
            return 1;
        }
        return 0;
    }

    public Image getImage() {
        ImageCache imageCache = PydevPlugin.getImageCache();
        if (this.astThis == null) {
            return imageCache.get("icons/showerr_tsk.gif");
        }
        SimpleNode token = this.astThis.node;
        return ParsedItem.getImageForNode(imageCache, token, this.astThis.parent);
    }

    public static Image getImageForNode(ImageCache imageCache, SimpleNode token, ASTEntry parent) {
        if (token instanceof ClassDef) {
            String className = NodeUtils.getNameFromNameTok((NameTok)((NameTok)((ClassDef)token).name));
            switch (ParsedItem.qualifierFromName(className)) {
                case 1: {
                    return imageCache.getImageDecorated("icons/new/class_obj.gif", "icons/protected_obj.gif", 1);
                }
                case 2: {
                    return imageCache.getImageDecorated("icons/new/class_obj.gif", "icons/private_obj.gif", 1);
                }
            }
            return imageCache.get("icons/new/class_obj.gif");
        }
        if (token instanceof FunctionDef) {
            FunctionDef functionDefToken = (FunctionDef)token;
            String methodName = NodeUtils.getNameFromNameTok((NameTok)((NameTok)((FunctionDef)token).name));
            String qualifierIcon = null;
            switch (ParsedItem.qualifierFromName(methodName)) {
                case 2: {
                    qualifierIcon = "icons/private_obj.gif";
                    break;
                }
                case 1: {
                    qualifierIcon = "icons/protected_obj.gif";
                }
            }
            String decorationIcon = null;
            if (functionDefToken.decs != null) {
                decoratorsType[] decoratorsTypeArray = functionDefToken.decs;
                int n = functionDefToken.decs.length;
                int n2 = 0;
                while (n2 < n) {
                    decoratorsType decorator = decoratorsTypeArray[n2];
                    if (decorator.func instanceof Name) {
                        Name decoratorFuncName = (Name)decorator.func;
                        if (decoratorFuncName.id.equals("staticmethod")) {
                            decorationIcon = "icons/decoration_static_obj.png";
                        } else if (decoratorFuncName.id.equals("classmethod")) {
                            decorationIcon = "icons/decoration_class_obj.png";
                        }
                    }
                    ++n2;
                }
            }
            if (qualifierIcon != null) {
                return imageCache.getImageDecorated("icons/new/method_obj.gif", qualifierIcon, 1, decorationIcon, 0);
            }
            if (decorationIcon != null) {
                return imageCache.getImageDecorated("icons/new/method_obj.gif", decorationIcon, 0);
            }
            return imageCache.get("icons/new/method_obj.gif");
        }
        if (token instanceof Import) {
            return imageCache.get("icons/new/imp_obj.gif");
        }
        if (token instanceof If && NodeUtils.isIfMAinNode((If)((If)token))) {
            return imageCache.get("icons/mainfunction.gif");
        }
        if (token instanceof ImportFrom) {
            return imageCache.get("icons/new/imp_obj.gif");
        }
        if (token instanceof commentType) {
            return imageCache.get("icons/python_comment.png");
        }
        if (token instanceof Attribute || token instanceof Name || token instanceof NameTok) {
            String name = null;
            if (token instanceof Attribute) {
                Attribute attributeToken = (Attribute)token;
                name = NodeUtils.getNameFromNameTok((NameTok)((NameTok)attributeToken.attr));
            } else if (token instanceof Name) {
                Name nameToken = (Name)token;
                name = nameToken.id;
            } else {
                NameTok nameTokToken = (NameTok)token;
                name = NodeUtils.getNameFromNameTok((NameTok)nameTokToken);
            }
            String image = name.startsWith("__") ? (name.endsWith("__") ? "icons/new/attrpub_obj.gif" : "icons/field_private_obj.gif") : (name.startsWith("_") ? "icons/field_protected_obj.gif" : "icons/new/attrpub_obj.gif");
            if (parent != null && parent.node != null && parent.node instanceof ClassDef) {
                return imageCache.getImageDecorated(image, "icons/decoration_class_obj.png");
            }
            return imageCache.get(image);
        }
        return imageCache.get("icons/showerr_tsk.gif");
    }

    public IParsedItem[] getChildren() {
        if (this.children != null) {
            return this.children;
        }
        if (this.astChildrenEntries == null) {
            this.astChildrenEntries = new ASTEntryWithChildren[0];
        }
        ArrayList<ParsedItem> items = new ArrayList<ParsedItem>();
        if (this.parent == null && this.errorDesc != null && this.errorDesc.message != null) {
            items.add(new ParsedItem(this, this.errorDesc));
        }
        ASTEntryWithChildren[] aSTEntryWithChildrenArray = this.astChildrenEntries;
        int n = this.astChildrenEntries.length;
        int n2 = 0;
        while (n2 < n) {
            ASTEntryWithChildren c = aSTEntryWithChildrenArray[n2];
            items.add(new ParsedItem(this, c, c.getChildren()));
            ++n2;
        }
        this.children = (IParsedItem[])items.toArray(new ParsedItem[items.size()]);
        return this.children;
    }

    protected String calcToString() {
        if (this.errorDesc != null && this.errorDesc.message != null) {
            return this.errorDesc.message;
        }
        if (this.astThis == null) {
            return "null";
        }
        if (this.astThis.node instanceof If && NodeUtils.isIfMAinNode((If)((If)this.astThis.node))) {
            return "__main__";
        }
        if (this.astThis.node instanceof Import) {
            aliasType[] imports = ((Import)this.astThis.node).names;
            FastStringBuffer retVal = new FastStringBuffer();
            int i = 0;
            while (i < imports.length) {
                aliasType aliasType2 = imports[i];
                if (aliasType2.asname != null) {
                    retVal.append(((NameTok)aliasType2.asname).id);
                    retVal.append(" = ");
                }
                retVal.append(((NameTok)aliasType2.name).id);
                retVal.append(", ");
                ++i;
            }
            retVal.deleteLast();
            retVal.deleteLast();
            return retVal.toString();
        }
        if (this.astThis.node instanceof ImportFrom) {
            ImportFrom importToken = (ImportFrom)this.astThis.node;
            StringBuffer modules = new StringBuffer();
            int i = 0;
            while (i < importToken.names.length) {
                aliasType aliasType3 = importToken.names[i];
                if (aliasType3.asname != null) {
                    modules.append(((NameTok)aliasType3.asname).id);
                    modules.append(" = ");
                }
                modules.append(((NameTok)aliasType3.name).id);
                modules.append(",");
                ++i;
            }
            if (modules.length() == 0) {
                modules.append("*,");
            }
            modules.deleteCharAt(modules.length() - 1);
            return String.valueOf(modules.toString()) + " (" + ((NameTok)importToken.module).id + ")";
        }
        if (this.astThis.node instanceof commentType) {
            commentType type = (commentType)this.astThis.node;
            String rep = type.id.trim();
            rep = (String)StringUtils.split((String)rep, (char)'\n').get(0);
            rep = (String)StringUtils.split((String)rep, (char)'\r').get(0);
            rep = rep.substring(1);
            rep = StringUtils.rightTrim((String)rep, (char)'-');
            return StringUtils.leftTrim((String)rep, (char)'-');
        }
        return NodeUtils.getFullRepresentationString((SimpleNode)this.astThis.node);
    }

    public int getClassRanking() {
        int rank = this.astThis == null || this.errorDesc != null && this.errorDesc.message != null ? -2 : (this.astThis.node instanceof ImportFrom ? 0 : (this.astThis.node instanceof Import ? 1 : (this.astThis.node instanceof commentType ? -1 : 10)));
        return rank;
    }

    public int compareTo(Object o) {
        int rank;
        if (!(o instanceof ParsedItem)) {
            return 0;
        }
        ParsedItem item = (ParsedItem)((Object)o);
        int myRank = this.getClassRanking();
        if (myRank == (rank = item.getClassRanking())) {
            if (rank == -1) {
                return this.astThis.node.beginLine < item.astThis.node.beginLine ? -1 : 1;
            }
            return this.toString().compareTo(item.toString());
        }
        return myRank < rank ? -1 : 1;
    }

    public boolean sameNodeType(IParsedItem newItem) {
        ASTEntryWithChildren astThisOld = this.getAstThis();
        ASTEntryWithChildren astThisNew = ((ParsedItem)newItem).getAstThis();
        return astThisOld == null || astThisNew == null || astThisOld.node == null || astThisNew.node == null || astThisOld.node.getClass() == astThisNew.node.getClass();
    }

    public void updateShallow(IParsedItem newItem) {
        this.setAstThis(((ParsedItem)newItem).getAstThis());
        this.setErrorDesc(newItem.getErrorDesc());
    }
}

