/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.python.pydev.navigator.ui.PydevPackageExplorer;
import org.python.pydev.plugin.PydevPlugin;

public class PySetupCustomFilters
extends Action
implements IViewActionDelegate {
    public static final String CUSTOM_FILTERS_PREFERENCE_NAME = "org.python.pydev.CUSTOM_PACKAGE_EXPLORER_FILTERS";
    private IViewPart view;

    public void init(IViewPart view) {
        this.view = view;
    }

    public void run(IAction action) {
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                IInputValidator validator = null;
                IPreferenceStore prefs = PydevPlugin.getDefault().getPreferenceStore();
                InputDialog dialog = new InputDialog(display.getActiveShell(), "Custom Filters", "Enter the filters (separated by comma. E.g.: \"__init__.py, *.xyz\").\n\nNote 1: Only * and ? may be used for custom matching.\n\nNote 2: it'll only take effect if the 'Pydev: Hide custom specified filters'\nis active in the menu: customize view > filters.", prefs.getString(PySetupCustomFilters.CUSTOM_FILTERS_PREFERENCE_NAME), validator);
                dialog.setBlockOnOpen(true);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    prefs.setValue(PySetupCustomFilters.CUSTOM_FILTERS_PREFERENCE_NAME, dialog.getValue());
                    PydevPackageExplorer p = (PydevPackageExplorer)PySetupCustomFilters.this.view;
                    p.getCommonViewer().refresh();
                }
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

