/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.navigator.actions.Helpers;

public class PyMoveResourceAction
extends MoveResourceAction {
    private ISelectionProvider provider;
    private ArrayList<IResource> selected;

    public PyMoveResourceAction(Shell shell, ISelectionProvider selectionProvider) {
        super(shell);
        this.provider = selectionProvider;
    }

    public boolean isEnabled() {
        this.fillSelection();
        return this.selected != null && this.selected.size() > 0;
    }

    private boolean fillSelection() {
        IStructuredSelection sSelection;
        this.selected = new ArrayList();
        ISelection selection = this.provider.getSelection();
        if (!selection.isEmpty() && (sSelection = (IStructuredSelection)selection).size() >= 1) {
            for (Object element : sSelection) {
                IAdaptable adaptable;
                IResource resource;
                if (element instanceof IAdaptable && (resource = (IResource)(adaptable = (IAdaptable)element).getAdapter(IResource.class)) != null) {
                    this.selected.add(resource);
                    continue;
                }
                this.selected = null;
                return false;
            }
        }
        return true;
    }

    protected List<IResource> getSelectedResources() {
        return this.selected;
    }

    public IStructuredSelection getStructuredSelection() {
        return new StructuredSelection(this.selected);
    }

    private IPath pyQueryDestinationResource() {
        String title = this.selected.size() == 1 ? "Choose destination for ''" + this.selected.get(0).getName() + "'':" : "Choose destination for " + this.selected.size() + " selected resources:";
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.shellProvider.getShell(), this.selected.get(0).getParent(), true, title);
        dialog.setTitle("Move Resources");
        dialog.setValidator((ISelectionValidator)this);
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null && result.length == 1) {
            return (IPath)result[0];
        }
        return null;
    }

    public void run() {
        if (!this.fillSelection()) {
            return;
        }
        Helpers.checkValidateState();
        try {
            this.operation = this.createOperation();
            this.operation.setModelProviderIds(this.getModelProviderIds());
            IPath destination = this.pyQueryDestinationResource();
            if (destination == null) {
                return;
            }
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IContainer container = (IContainer)root.findMember(destination);
            if (container == null) {
                return;
            }
            this.runOperation(this.getResources(this.selected), container);
        }
        finally {
            this.operation = null;
        }
    }

    protected void runOperation(IResource[] resources, IContainer destination) {
        super.runOperation(resources, destination);
        if (this.destinations.size() > 0) {
            PythonPathHelper.updatePyPath(resources, destination, 1);
        }
    }
}

