/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.python.pydev.core.log.Log;
import org.python.pydev.editorinput.PySourceLocatorBase;
import org.python.pydev.navigator.PythonModelProvider;
import org.python.pydev.navigator.elements.IWrappedResource;
import org.python.pydev.navigator.ui.PydevPackageExplorer;

public class PyPackageStateSaver {
    private PythonModelProvider provider;
    private Viewer viewer;
    private IMemento memento;

    public PyPackageStateSaver(PythonModelProvider provider, Viewer viewer, IMemento memento) {
        this.provider = provider;
        this.viewer = viewer;
        this.memento = memento;
    }

    public void restoreState() {
        try {
            IMemento[] selected;
            IMemento[] expanded;
            if (!(this.viewer instanceof PydevPackageExplorer.PydevCommonViewer) || this.memento == null) {
                return;
            }
            PydevPackageExplorer.PydevCommonViewer treeViewer = (PydevPackageExplorer.PydevCommonViewer)this.viewer;
            if (!treeViewer.availableToRestoreMemento) {
                return;
            }
            IMemento[] iMementoArray = expanded = this.memento.getChildren("expanded");
            int n = expanded.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento m = iMementoArray[n2];
                Object resource = this.getResourceFromPath(m);
                if (resource != null) {
                    treeViewer.expandToLevel(resource, 1);
                }
                ++n2;
            }
            ArrayList<TreePath> paths = new ArrayList<TreePath>();
            IMemento[] iMementoArray2 = selected = this.memento.getChildren("selected");
            int n3 = selected.length;
            int n4 = 0;
            while (n4 < n3) {
                IMemento m = iMementoArray2[n4];
                Object resource = this.getResourceFromPath(m);
                if (resource != null) {
                    treeViewer.expandToLevel(resource, 1);
                    paths.add(new TreePath(this.getCompletPath(resource).toArray()));
                }
                ++n4;
            }
            treeViewer.setSelection((ISelection)new TreeSelection(paths.toArray(new TreePath[0])), true);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    private ArrayList<Object> getCompletPath(Object resource) {
        int max = 100;
        int i = 0;
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.add(0, resource);
        while (true) {
            if (++i > max) {
                Log.log((String)("Could not get the structure for: " + resource));
                return new ArrayList<Object>();
            }
            if (resource instanceof IProject || resource instanceof IWorkspaceRoot || resource instanceof IWorkingSet) break;
            if (resource instanceof IWrappedResource) {
                IWrappedResource w = (IWrappedResource)resource;
                if ((resource = w.getParentElement()) == null) break;
                ret.add(0, resource);
                continue;
            }
            if (!(resource instanceof IResource)) continue;
            IResource r = (IResource)resource;
            if ((resource = r.getParent()) == null) break;
            ret.add(0, resource);
        }
        return ret;
    }

    private Object getResourceFromPath(IMemento m) {
        IPath path = Path.fromPortableString((String)m.getID());
        IFile resource = new PySourceLocatorBase().getFileForLocation(path, null);
        if (resource == null || !resource.exists()) {
            resource = new PySourceLocatorBase().getContainerForLocation(path, null);
        }
        if (resource != null && resource.exists()) {
            return this.provider.getResourceInPythonModel((IResource)resource);
        }
        return null;
    }

    public void saveState() {
        try {
            TreePath[] expandedTreePaths;
            if (!(this.viewer instanceof PydevPackageExplorer.PydevCommonViewer)) {
                return;
            }
            PydevPackageExplorer.PydevCommonViewer treeViewer = (PydevPackageExplorer.PydevCommonViewer)this.viewer;
            TreePath[] treePathArray = expandedTreePaths = treeViewer.getExpandedTreePaths();
            int n = expandedTreePaths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                this.save(path, "expanded");
                ++n2;
            }
            ISelection selection = this.viewer.getSelection();
            if (selection instanceof ITreeSelection) {
                TreePath[] paths;
                ITreeSelection treeSelection = (ITreeSelection)selection;
                TreePath[] treePathArray2 = paths = treeSelection.getPaths();
                int n3 = paths.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreePath path = treePathArray2[n4];
                    this.save(path, "selected");
                    ++n4;
                }
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    private void save(TreePath treePath, String type) {
        IPath path;
        IAdaptable adaptable;
        IResource resource;
        Object object;
        if (treePath != null && (object = treePath.getLastSegment()) instanceof IAdaptable && (resource = (IResource)(adaptable = (IAdaptable)object).getAdapter(IResource.class)) != null && (path = resource.getLocation()) != null) {
            this.memento.createChild(type, path.toPortableString());
        }
    }
}

