/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.saveactions;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.python.pydev.core.SystemUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.preferences.PyScopedPreferences;
import org.python.pydev.editor.saveactions.PydevDateFieldNameEditor;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_ui.field_editors.LabelFieldEditor;
import org.python.pydev.shared_ui.field_editors.LinkFieldEditor;
import org.python.pydev.shared_ui.field_editors.ScopedFieldEditorPreferencePage;
import org.python.pydev.shared_ui.field_editors.ScopedPreferencesFieldEditor;
import org.python.pydev.shared_ui.tooltips.presenter.AbstractTooltipInformationPresenter;
import org.python.pydev.shared_ui.tooltips.presenter.ToolTipPresenterHandler;

public class PydevSaveActionsPrefPage
extends ScopedFieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private StringFieldEditor dateFormatEditor;
    private PydevDateFieldNameEditor fieldNameEditor;
    private BooleanFieldEditor enableDateFieldActionEditor;
    private LinkFieldEditor dateFormatHelpLinkEditor;
    private static final String enableDateFieldActionEditorTooltipFormat = "Parses the file being saved for a module level\nfield with name and value as defined by the custom\nname and date format below and updates it to the\ncurrent date.";
    private ToolTipPresenterHandler tooltipPresenter;
    private BooleanFieldEditor sortImportsOnSave;
    public static final String SAVE_ACTIONS_ONLY_ON_WORKSPACE_FILES = "SAVE_ACTIONS_ONLY_ON_WORKSPACE_FILES";
    public static final boolean DEFAULT_SAVE_ACTIONS_ONLY_ON_WORKSPACE_FILES = true;
    public static final String FORMAT_BEFORE_SAVING = "FORMAT_BEFORE_SAVING";
    public static final boolean DEFAULT_FORMAT_BEFORE_SAVING = false;
    public static final String ENABLE_DATE_FIELD_ACTION = "ENABLE_DATE_FIELD_ACTION";
    public static final boolean DEFAULT_ENABLE_DATE_FIELD_ACTION = false;
    public static final String DATE_FIELD_FORMAT = "DATE_FIELD_FORMAT";
    public static final String DEFAULT_DATE_FIELD_FORMAT = "yyyy-MM-dd";
    public static final String DATE_FIELD_NAME = "DATE_FIELD_NAME";
    public static final String DEFAULT_DATE_FIELD_NAME = "__updated__";
    public static final String SORT_IMPORTS_ON_SAVE = "SORT_IMPORTS_ON_SAVE";
    public static final boolean DEFAULT_SORT_IMPORTS_ON_SAVE = false;

    public PydevSaveActionsPrefPage() {
        super(1);
        IPreferenceStore store = PydevPlugin.getDefault().getPreferenceStore();
        this.setDescription("Save actions are run whenever a file is saved.\n");
        this.setPreferenceStore(store);
    }

    protected void createFieldEditors() {
        AbstractTooltipInformationPresenter presenter = new AbstractTooltipInformationPresenter(){

            protected void onUpdatePresentation(String hoverInfo, TextPresentation presentation) {
            }

            protected void onHandleClick(Object data) {
            }
        };
        Composite p = this.getFieldEditorParent();
        this.addField((FieldEditor)new BooleanFieldEditor(SAVE_ACTIONS_ONLY_ON_WORKSPACE_FILES, "Apply save actions only to files in the workspace?", p));
        this.addField((FieldEditor)new BooleanFieldEditor(FORMAT_BEFORE_SAVING, "Auto-format editor contents before saving?", p));
        this.addField((FieldEditor)new LinkFieldEditor("link_formatpreferences", "Note: config in <a>code formatting preferences</a>", p, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String id = "org.python.pydev.plugin.pyCodeFormatterPage";
                IWorkbenchPreferenceContainer workbenchPreferenceContainer = (IWorkbenchPreferenceContainer)PydevSaveActionsPrefPage.this.getContainer();
                workbenchPreferenceContainer.openPage(id, null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        }));
        this.sortImportsOnSave = new BooleanFieldEditor(SORT_IMPORTS_ON_SAVE, "Sort imports on save?", p);
        this.addField((FieldEditor)this.sortImportsOnSave);
        this.addField((FieldEditor)new LinkFieldEditor("link_importpreferences", "Note: config in <a>code style: imports preferences</a>", p, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String id = "org.python.pydev.ui.importsconf.ImportsPreferencesPage";
                IWorkbenchPreferenceContainer workbenchPreferenceContainer = (IWorkbenchPreferenceContainer)PydevSaveActionsPrefPage.this.getContainer();
                workbenchPreferenceContainer.openPage(id, null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        }));
        this.tooltipPresenter = new ToolTipPresenterHandler(p.getShell(), (DefaultInformationControl.IInformationPresenter)presenter, "Tip: Click link to open SimpleDateFormat Java docs online.");
        IPreferenceStore prefStore = this.getPreferenceStore();
        String fieldName = prefStore.getString(DATE_FIELD_NAME);
        String enableDateFieldActionEditorTooltip = String.format(enableDateFieldActionEditorTooltipFormat, fieldName);
        this.enableDateFieldActionEditor = new BooleanFieldEditor(ENABLE_DATE_FIELD_ACTION, "Update date field?", p);
        this.enableDateFieldActionEditor.getDescriptionControl(p).setToolTipText(enableDateFieldActionEditorTooltip);
        this.addField((FieldEditor)this.enableDateFieldActionEditor);
        this.fieldNameEditor = new PydevDateFieldNameEditor(DATE_FIELD_NAME, "Date field name:", PydevDateFieldNameEditor.UNLIMITED, p);
        this.fieldNameEditor.getTextControl(p).setToolTipText(String.format("Default is %s", DEFAULT_DATE_FIELD_NAME));
        this.fieldNameEditor.setEmptyStringAllowed(false);
        this.fieldNameEditor.setEnabled(prefStore.getBoolean(ENABLE_DATE_FIELD_ACTION), p);
        this.addField((FieldEditor)this.fieldNameEditor);
        this.dateFormatEditor = new StringFieldEditor(DATE_FIELD_FORMAT, "Date field format:", StringFieldEditor.UNLIMITED, p);
        this.dateFormatEditor.getTextControl(p).setToolTipText("Uses Java's SimpleDateFormat tokens.");
        this.dateFormatEditor.setEmptyStringAllowed(false);
        this.dateFormatEditor.setEnabled(prefStore.getBoolean(ENABLE_DATE_FIELD_ACTION), p);
        this.addField((FieldEditor)this.dateFormatEditor);
        this.dateFormatHelpLinkEditor = new LinkFieldEditor("link_dateFormat", "<a>Supported tokens</a>", p, (SelectionListener)new PydevSaveActionsPageLinkListener(), "All tokens from Java's SimpleDateFormat class\nare supported. The most common ones are:\n\ny\t\tYear\nM\t\tMonth in year\nd\t\tDay in month\nE\t\tDay name in week\nH\t\tHour in day (0-23)\nh\t\tHour in am/pm (1-12)\nm\t\tMinute in hour\ns\t\tSecond in minute\n\nEnclose literal characters in single quotes.", this.tooltipPresenter);
        this.addField((FieldEditor)this.dateFormatHelpLinkEditor);
        this.addField((FieldEditor)new LabelFieldEditor("__dummy__", "I.e.: __updated__=\"2010-01-01\" will be synched on save.", p));
        this.addField((FieldEditor)new ScopedPreferencesFieldEditor(p, "org.python.pydev", (ScopedFieldEditorPreferencePage)this));
    }

    public void init(IWorkbench workbench) {
    }

    public static boolean getDateFieldActionEnabled(PyEdit pyEdit) {
        return PyScopedPreferences.getBoolean(ENABLE_DATE_FIELD_ACTION, pyEdit);
    }

    public static boolean getSortImportsOnSave(PyEdit pyEdit) {
        return PyScopedPreferences.getBoolean(SORT_IMPORTS_ON_SAVE, pyEdit);
    }

    public static boolean getFormatBeforeSaving(PyEdit pyEdit) {
        return PyScopedPreferences.getBoolean(FORMAT_BEFORE_SAVING, pyEdit);
    }

    public static String getDateFieldName(PyEdit pyEdit) {
        return PyScopedPreferences.getString(DATE_FIELD_NAME, pyEdit, DEFAULT_DATE_FIELD_NAME);
    }

    public static String getDateFieldFormat(PyEdit pyEdit) {
        return PyScopedPreferences.getString(DATE_FIELD_FORMAT, pyEdit, DEFAULT_DATE_FIELD_FORMAT);
    }

    public static boolean getAutoformatOnlyWorkspaceFiles(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getBoolean(SAVE_ACTIONS_ONLY_ON_WORKSPACE_FILES, projectAdaptable);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.updateDateFieldStringEditorState();
    }

    private void updateDateFieldStringEditorState() {
        boolean val = this.enableDateFieldActionEditor.getBooleanValue();
        Composite p = this.getFieldEditorParent();
        this.dateFormatEditor.setEnabled(val, p);
        this.fieldNameEditor.setEnabled(val, p);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (this.enableDateFieldActionEditor.equals(event.getSource())) {
            this.updateDateFieldStringEditorState();
        }
        this.setValid(this.dateFormatEditor.isValid() && this.fieldNameEditor.isValid());
        this.updatePageButtons();
    }

    private void updatePageButtons() {
        boolean valid = this.isValid();
        Button defaultButton = this.getShell().getDefaultButton();
        if (!valid) {
            this.getApplyButton().setEnabled(false);
            if (defaultButton != null) {
                defaultButton.setEnabled(false);
            }
        } else {
            this.getApplyButton().setEnabled(true);
            if (defaultButton != null) {
                defaultButton.setEnabled(true);
            }
        }
    }

    private class PydevSaveActionsPageLinkListener
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            try {
                URL url = new URL("http://docs.oracle.com/javase/7/docs/api/java/text/SimpleDateFormat.html");
                SystemUtils.openWebpageInEclipse((URL)url, (String)"SimpleDateFormat Java Docs");
            }
            catch (MalformedURLException e1) {
                Log.log((Throwable)e1);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

