/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.hover;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.python.pydev.core.IPythonPartitions;
import org.python.pydev.editor.PyInformationPresenter;
import org.python.pydev.editor.codefolding.MarkerAnnotationAndPosition;
import org.python.pydev.editor.codefolding.PySourceViewer;
import org.python.pydev.editor.hover.AbstractPyEditorTextHover;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class PyMarkerTextHover
extends AbstractPyEditorTextHover {
    public static String ID = "org.python.pydev.editor.hover.pyMarkerTextHover";

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        FastStringBuffer buf = new FastStringBuffer();
        if (textViewer instanceof PySourceViewer) {
            PySourceViewer s = (PySourceViewer)textViewer;
            this.getMarkerHover(hoverRegion, s, buf);
        }
        return buf.toString();
    }

    @Override
    public boolean isContentTypeSupported(String contentType) {
        boolean pythonCommentOrMultiline = IPythonPartitions.NON_DEFAULT_TYPES_AS_SET.contains(contentType);
        return !pythonCommentOrMultiline;
    }

    private void getMarkerHover(IRegion hoverRegion, PySourceViewer s, FastStringBuffer buf) {
        Iterator<MarkerAnnotationAndPosition> it = s.getMarkerIterator();
        while (it.hasNext()) {
            MarkerAnnotationAndPosition marker = it.next();
            try {
                Object msg;
                if (marker.position == null) continue;
                int cStart = marker.position.offset;
                int cEnd = cStart + marker.position.length;
                int offset = hoverRegion.getOffset();
                if (cStart > offset || cEnd < offset) continue;
                if (buf.length() > 0) {
                    buf.append(PyInformationPresenter.LINE_DELIM);
                }
                if ("PyDev breakpoint".equals(msg = marker.markerAnnotation.getMarker().getAttribute("message"))) continue;
                buf.appendObject(msg);
            }
            catch (CoreException coreException) {}
        }
    }
}

