/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.hover;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.UIJob;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.hover.PyEditorTextHoverDescriptor;
import org.python.pydev.editor.hover.PyHoverPreferencesPage;
import org.python.pydev.editor.hover.PydevCombiningHover;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.StatusInfo;
import org.python.pydev.plugin.preferences.IPreferenceConfigurationBlock;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.ui.EmulatedNativeCheckBoxLabelProvider;
import org.python.pydev.ui.ScrolledPageContent;
import org.python.pydev.ui.TableLayoutComposite;
import org.python.pydev.utils.Messages;
import org.python.pydev.utils.PyEditorMessages;
import org.python.pydev.utils.SWTUtil;
import org.python.pydev.utils.StatusUtil;

public class PyEditorHoverConfigurationBlock
implements IPreferenceConfigurationBlock {
    private static final String DELIMITER = PyEditorMessages.PyEditorHoverConfigurationBlock_delimiter;
    private static final int ENABLED_PROP = 0;
    private static final int PRIORITY_PROP = 1;
    private static final int MODIFIER_PROP = 2;
    private static final int PREEMPT_PROP = 3;
    private String priorityHelpStr = " (Lowest number is highest priority)";
    private Text fModifierEditor;
    private Table fHoverTable;
    private CheckboxTableViewer fHoverTableViewer;
    private TableColumn fNameColumn;
    TableColumn fModifierColumn;
    private TableColumn fPriorityColumn;
    TableColumn fPreemptColumn;
    private int[] fColWidths = new int[]{35, 15, 35, 15};
    private Map<TableColumn, Integer> fColWidthsMap = new HashMap<TableColumn, Integer>();
    private Text fDescription;
    private StyleRange priorityHelpRange = null;
    private PreferencePage fMainPreferencePage;
    public static StatusInfo fStatus;
    private Button fCombineHovers;
    private Text fCombiningHoverModifierEditor;
    private Button fDebugShowVars;
    private Button fUseFirstHover;
    private Label fCombiningHoverLabel;
    private Button fUseHoverDivider;
    private Composite fComp;
    private GridData fDisabledLabelGridData;
    private Composite fButtonComp;
    private PyEditorTextHoverDescriptor[] fHoverDescs;
    private PyEditorTextHoverDescriptor fCombiningHover;
    private Label fModifierFieldLabel;
    private StyledText fTableLabel;

    public PyEditorHoverConfigurationBlock(PreferencePage mainPreferencePage) {
        Assert.isNotNull((Object)mainPreferencePage);
        this.fMainPreferencePage = mainPreferencePage;
    }

    @Override
    public Control createControl(Composite parent) {
        this.priorityHelpRange = new StyleRange(PyEditorMessages.PyEditorHoverConfigurationBlock_hoverPreferences.length(), this.priorityHelpStr.length(), parent.getDisplay().getSystemColor(9), null);
        this.fComp = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fComp);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.fComp);
        this.fButtonComp = new Composite(this.fComp, 2048);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.fButtonComp);
        this.fUseFirstHover = new Button(this.fButtonComp, 2064);
        this.fUseFirstHover.setText("Use highest priority Hover");
        GridDataFactory.fillDefaults().applyTo((Control)this.fUseFirstHover);
        this.fCombineHovers = new Button(this.fButtonComp, 2064);
        this.fCombineHovers.setText("Combine Hovers");
        GridDataFactory.fillDefaults().applyTo((Control)this.fCombineHovers);
        this.fCombineHovers.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PyEditorHoverConfigurationBlock.this.fCombiningHoverModifierEditor.setEnabled(PyEditorHoverConfigurationBlock.this.fCombineHovers.getSelection());
                PyEditorHoverConfigurationBlock.this.fCombiningHoverLabel.setEnabled(PyEditorHoverConfigurationBlock.this.fCombineHovers.getSelection());
                PyEditorHoverConfigurationBlock.this.showColumn(PyEditorHoverConfigurationBlock.this.fPreemptColumn, PyEditorHoverConfigurationBlock.this.fCombineHovers.getSelection());
                PyEditorHoverConfigurationBlock.this.showColumn(PyEditorHoverConfigurationBlock.this.fModifierColumn, !PyEditorHoverConfigurationBlock.this.fCombineHovers.getSelection());
                PyEditorHoverConfigurationBlock.this.fModifierFieldLabel.setEnabled(!PyEditorHoverConfigurationBlock.this.fCombineHovers.getSelection());
            }
        });
        this.fCombiningHoverLabel = new Label(this.fComp, 8);
        this.fCombiningHoverLabel.setText("Combined Hovers Key Modifier:");
        this.fCombiningHoverModifierEditor = new Text(this.fComp, 2048);
        this.fCombiningHoverModifierEditor.addKeyListener((KeyListener)new KeyModifierListener(this.fCombiningHoverModifierEditor));
        this.fCombiningHoverModifierEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PyEditorHoverConfigurationBlock.this.handleModifierModified(PyEditorHoverConfigurationBlock.this.fCombiningHoverModifierEditor);
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fCombiningHoverModifierEditor);
        ScrolledPageContent scrolled = new ScrolledPageContent(parent, 768);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        Composite hoverComposite = new Composite((Composite)scrolled, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        hoverComposite.setLayout((Layout)layout);
        this.addFiller(hoverComposite);
        this.fTableLabel = new StyledText(hoverComposite, 0);
        this.fTableLabel.setEditable(false);
        this.fTableLabel.setEnabled(false);
        this.fTableLabel.setBackground(this.fTableLabel.getDisplay().getSystemColor(22));
        this.fTableLabel.setText(PyEditorMessages.PyEditorHoverConfigurationBlock_hoverPreferences);
        GridData gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fTableLabel.setLayoutData((Object)gd);
        TableLayoutComposite layouter = new TableLayoutComposite(hoverComposite, 0);
        this.addColumnLayoutData(layouter, this.fColWidths);
        this.fHoverTable = new Table((Composite)layouter, 66340);
        this.fHoverTable.setHeaderVisible(true);
        this.fHoverTable.setLinesVisible(true);
        gd = new GridData(768);
        gd.heightHint = SWTUtil.getTableHeightHint(this.fHoverTable, 10);
        gd.horizontalSpan = 2;
        gd.widthHint = new PixelConverter((Control)parent).convertWidthInCharsToPixels(100);
        layouter.setLayoutData(gd);
        this.fHoverTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PyEditorHoverConfigurationBlock.this.handleHoverListSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        TableLayout tableLayout = new TableLayout();
        this.fHoverTable.setLayout((Layout)tableLayout);
        this.fHoverTableViewer = new CheckboxTableViewer(this.fHoverTable);
        TableViewerColumn nameColumnViewer = new TableViewerColumn((TableViewer)this.fHoverTableViewer, 0);
        nameColumnViewer.setLabelProvider((CellLabelProvider)new PyEditorTextHoverDescriptorLabelProvider((ColumnViewer)this.fHoverTableViewer));
        this.fNameColumn = nameColumnViewer.getColumn();
        this.fNameColumn.setText(PyEditorMessages.PyEditorHoverConfigurationBlock_nameColumnTitle);
        this.fNameColumn.setResizable(true);
        TableViewerColumn priorityViewerColumn = new TableViewerColumn((TableViewer)this.fHoverTableViewer, 0);
        priorityViewerColumn.setEditingSupport((EditingSupport)new HoverTableEditingSupport((TableViewer)this.fHoverTableViewer, 1));
        priorityViewerColumn.setLabelProvider((CellLabelProvider)new PyEditorTextHoverDescriptorLabelProvider((ColumnViewer)this.fHoverTableViewer));
        this.fPriorityColumn = priorityViewerColumn.getColumn();
        this.fPriorityColumn.setText(PyEditorMessages.PyEditorHoverConfigurationBlock_priorityColumnTitle);
        this.fPriorityColumn.setResizable(true);
        TableViewerColumn modifierColumnViewer = new TableViewerColumn((TableViewer)this.fHoverTableViewer, 0);
        modifierColumnViewer.setLabelProvider((CellLabelProvider)new PyEditorTextHoverDescriptorLabelProvider((ColumnViewer)this.fHoverTableViewer));
        this.fModifierColumn = modifierColumnViewer.getColumn();
        this.fModifierColumn.setText(PyEditorMessages.PyEditorHoverConfigurationBlock_modifierColumnTitle);
        this.fModifierColumn.setResizable(true);
        TableViewerColumn preemptViewerColumn = new TableViewerColumn((TableViewer)this.fHoverTableViewer, 0);
        preemptViewerColumn.setEditingSupport((EditingSupport)new HoverTableEditingSupport((TableViewer)this.fHoverTableViewer, 3));
        preemptViewerColumn.setLabelProvider((CellLabelProvider)new PyEditorTextHoverDescriptorLabelProvider((ColumnViewer)this.fHoverTableViewer));
        this.fPreemptColumn = preemptViewerColumn.getColumn();
        this.fPreemptColumn.setText(PyEditorMessages.PyEditorHoverConfigurationBlock_preemptColumnTitle);
        this.fPreemptColumn.setResizable(true);
        this.fHoverTableViewer.setUseHashlookup(true);
        this.fHoverTableViewer.setContentProvider((IContentProvider)new PyEditorTextHoverDescriptorContentProvider());
        this.fHoverTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                String id = ((PyEditorTextHoverDescriptor)event.getElement()).getId();
                if (id == null) {
                    return;
                }
                PyEditorTextHoverDescriptor[] descriptors = PyEditorHoverConfigurationBlock.this.fHoverDescs;
                PyEditorTextHoverDescriptor hover = null;
                int i = 0;
                int length = PyEditorHoverConfigurationBlock.this.fHoverDescs.length;
                while (i < length) {
                    if (id.equals(descriptors[i].getId())) {
                        hover = PyEditorHoverConfigurationBlock.this.fHoverDescs[i];
                        hover.setIsEnabled(event.getChecked());
                        PyEditorHoverConfigurationBlock.this.fModifierEditor.setEnabled(event.getChecked());
                        PyEditorHoverConfigurationBlock.this.fHoverTableViewer.setSelection((ISelection)new StructuredSelection((Object)descriptors[i]));
                    }
                    ++i;
                }
                PyEditorHoverConfigurationBlock.this.handleHoverListSelection();
                PyEditorHoverConfigurationBlock.this.updateStatus(hover);
            }
        });
        this.fHoverTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((PyEditorTextHoverDescriptor)e1).getPriority().compareTo(((PyEditorTextHoverDescriptor)e2).getPriority());
            }
        });
        this.fModifierFieldLabel = new Label(hoverComposite, 16384);
        this.fModifierFieldLabel.setText(PyEditorMessages.PyEditorHoverConfigurationBlock_keyModifier);
        this.fModifierEditor = new Text(hoverComposite, 2048);
        gd = new GridData(256);
        this.fModifierEditor.setLayoutData((Object)gd);
        this.fModifierEditor.addKeyListener((KeyListener)new KeyModifierListener(this.fModifierEditor));
        this.fModifierEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PyEditorHoverConfigurationBlock.this.handleModifierModified(PyEditorHoverConfigurationBlock.this.fModifierEditor);
            }
        });
        Label label = new Label(hoverComposite, 16384);
        label.setText(PyEditorMessages.PyEditorHoverConfigurationBlock_description);
        gd = new GridData(2);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fDescription = new Text(hoverComposite, 18506);
        SWTUtil.fixReadonlyTextBackground(this.fDescription);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.fDescription.setLayoutData((Object)gd);
        this.fDebugShowVars = new Button(parent, 32);
        this.fDebugShowVars.setText("Show variables values while debugging");
        this.fDebugShowVars.setSelection(PyHoverPreferencesPage.getShowValuesWhileDebuggingOnHover());
        this.fUseHoverDivider = new Button(parent, 32);
        this.fUseHoverDivider.setText("Add divider between contributions when combining hovers");
        this.fUseHoverDivider.setSelection(PyHoverPreferencesPage.getUseHoverDelimiters());
        scrolled.setContent((Control)hoverComposite);
        Point size = hoverComposite.computeSize(-1, -1);
        scrolled.setMinSize(size.x, size.y);
        Dialog.applyDialogFont((Control)scrolled);
        return this.fComp;
    }

    private void addColumnLayoutData(TableLayoutComposite layouter, int[] widths) {
        layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(widths[0], true));
        layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(widths[1], true));
        layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(widths[2], true));
        layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(widths[3], true));
    }

    private PyEditorTextHoverDescriptor[] getContributedHovers() {
        return PydevPlugin.getDefault().getPyEditorTextHoverDescriptors();
    }

    @Override
    public void initialize() {
        new UIJob("Show/Hide Column"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                PyEditorHoverConfigurationBlock.this.showColumn(PyEditorHoverConfigurationBlock.this.fPreemptColumn, PyHoverPreferencesPage.getCombineHoverInfo());
                PyEditorHoverConfigurationBlock.this.showColumn(PyEditorHoverConfigurationBlock.this.fModifierColumn, !PyHoverPreferencesPage.getCombineHoverInfo());
                PyEditorHoverConfigurationBlock.this.fModifierFieldLabel.setEnabled(!PyEditorHoverConfigurationBlock.this.fCombineHovers.getSelection());
                return Status.OK_STATUS;
            }
        }.schedule();
        this.doInit(true);
    }

    private void doInit(boolean refreshHovers) {
        if (refreshHovers) {
            this.fHoverDescs = this.getContributedHovers();
            this.fCombiningHover = PydevPlugin.getCombiningHoverDescriptor();
        }
        this.fHoverTableViewer.setInput((Object)this.fHoverDescs);
        this.fHoverTableViewer.refresh();
        this.initializeFields();
    }

    void initializeFields() {
        this.fModifierEditor.setEnabled(false);
        this.fCombineHovers.setSelection(PyHoverPreferencesPage.getCombineHoverInfo());
        this.fUseFirstHover.setSelection(!PyHoverPreferencesPage.getCombineHoverInfo());
        this.fCombiningHoverModifierEditor.setEnabled(PyHoverPreferencesPage.getCombineHoverInfo());
        this.fCombiningHoverLabel.setEnabled(PyHoverPreferencesPage.getCombineHoverInfo());
        int i = 0;
        while (i < this.fHoverDescs.length) {
            this.fHoverTable.getItem(i).setChecked(this.fHoverDescs[i].isEnabled());
            ++i;
        }
        this.fHoverTableViewer.refresh();
        this.fCombiningHoverModifierEditor.setText(this.fCombiningHover.fModifierString);
    }

    @Override
    public void performOk() {
        Integer modifierMask = 0;
        Integer priority = 0;
        Boolean preempt = false;
        PyEditorTextHoverDescriptor[] hoverDescripters = (PyEditorTextHoverDescriptor[])this.fHoverTableViewer.getInput();
        this.sortHoverDescriptors();
        if (hoverDescripters != this.fHoverDescs) {
            Log.log((String)"Expecting hoverDescripters to be == fHoverDescs");
        }
        int i = 0;
        while (i < hoverDescripters.length) {
            PyEditorTextHoverDescriptor hoverDesc = this.fHoverDescs[i];
            String modifier = hoverDesc.fModifierString;
            if (modifier == null || modifier.length() == 0) {
                modifier = "0";
            }
            modifierMask = hoverDesc.fStateMask;
            priority = hoverDesc.getPriority();
            preempt = hoverDesc.isPreempt();
            Boolean enable = hoverDesc.isEnabled();
            String hoverDescId = hoverDesc.getId();
            PydevPrefs.getPreferenceStore().setValue("PYDEV_TEXT_HOVER_MODIFIER_" + hoverDescId, modifier);
            PydevPrefs.getPreferenceStore().setValue("PYDEV_TEXT_HOVER_MODIFIER_MASK_" + hoverDescId, modifierMask.intValue());
            PydevPrefs.getPreferenceStore().setValue("PYDEV_TEXT_HOVER_PRORITY_" + hoverDescId, priority.intValue());
            PydevPrefs.getPreferenceStore().setValue("PYDEV_TEXT_HOVER_PREEMPT_" + hoverDescId, preempt.booleanValue());
            PydevPrefs.getPreferenceStore().setValue("PYDEV_TEXT_HOVER_ENABLE_" + hoverDescId, enable.booleanValue());
            ++i;
        }
        PydevPrefs.getPreferenceStore().setValue("PYDEV_TEXT_HOVER_MODIFIER_" + this.fCombiningHover.getId(), this.fCombiningHover.getModifierString());
        PydevPrefs.getPreferenceStore().setValue("PYDEV_TEXT_HOVER_MODIFIER_MASK_" + this.fCombiningHover.getId(), this.fCombiningHover.fStateMask);
        PydevPrefs.getPreferenceStore().setValue("PYDEV_TEXT_HOVER_ENABLE_" + this.fCombiningHover.getId(), PyHoverPreferencesPage.getCombineHoverInfo());
        PydevPlugin.getDefault().getPreferenceStore().setValue("COMBINE_HOVER_INFO", this.fCombineHovers.getSelection());
        PydevPlugin.getDefault().getPreferenceStore().setValue("SHOW_DEBUG_VARIABLES_VALUES_ON_HOVER", this.fDebugShowVars.getSelection());
        PydevPlugin.getDefault().getPreferenceStore().setValue("USE_HOVER_DIVIDER", this.fUseHoverDivider.getSelection());
        PydevPlugin.getDefault().resetPyEditorTextHoverDescriptors();
        PydevCombiningHover.installTextHovers();
    }

    private void sortHoverDescriptors() {
        Arrays.sort(this.fHoverDescs, new Comparator<PyEditorTextHoverDescriptor>(){

            @Override
            public int compare(PyEditorTextHoverDescriptor o1, PyEditorTextHoverDescriptor o2) {
                return o1.getPriority().compareTo(o2.getPriority());
            }
        });
    }

    @Override
    public void performCancel() {
        PydevPlugin.getDefault().resetPyEditorTextHoverDescriptors();
    }

    @Override
    public void performDefaults() {
        this.restoreFromPreferences();
        this.doInit(false);
        this.initializeFields();
        this.updateStatus(null);
        this.setcheckStates();
        if (!this.fHoverTableViewer.getSelection().isEmpty()) {
            this.handleHoverListSelection();
        }
    }

    private void setcheckStates() {
        PyEditorTextHoverDescriptor[] pyEditorTextHoverDescriptorArray = this.fHoverDescs;
        int n = this.fHoverDescs.length;
        int n2 = 0;
        while (n2 < n) {
            PyEditorTextHoverDescriptor hover = pyEditorTextHoverDescriptorArray[n2];
            this.fHoverTableViewer.setChecked((Object)hover, hover.isEnabled());
            ++n2;
        }
    }

    public int computeStateMask(String modifiers) {
        if (modifiers == null) {
            return -1;
        }
        if (modifiers.length() == 0) {
            return 0;
        }
        int stateMask = 0;
        StringTokenizer modifierTokenizer = new StringTokenizer(modifiers, ",;.:+-* ");
        while (modifierTokenizer.hasMoreTokens()) {
            int modifier = PyAction.findLocalizedModifier(modifierTokenizer.nextToken());
            if (modifier == 0 || (stateMask & modifier) == modifier) {
                return -1;
            }
            stateMask |= modifier;
        }
        return stateMask;
    }

    private void restoreFromPreferences() {
        int i = 0;
        while (i < this.fHoverDescs.length) {
            String modifierString = PydevPrefs.getPreferenceStore().getDefaultString("PYDEV_TEXT_HOVER_MODIFIER_" + this.fHoverDescs[i].getId());
            if ("0".equals(modifierString)) {
                modifierString = "";
            }
            this.fHoverDescs[i].fModifierString = modifierString;
            this.fHoverDescs[i].fStateMask = this.computeStateMask(modifierString);
            if (this.fHoverDescs[i].fStateMask == -1) {
                try {
                    this.fHoverDescs[i].fStateMask = Integer.parseInt(PydevPrefs.getPreferenceStore().getString("PYDEV_TEXT_HOVER_MODIFIER_MASK_" + this.fHoverDescs[i].getId()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.fHoverDescs[i].fStateMask = -1;
                }
            }
            this.fHoverDescs[i].setIsEnabled(PydevPlugin.getDefault().getPreferenceStore().getDefaultBoolean("PYDEV_TEXT_HOVER_ENABLE_" + this.fHoverDescs[i].getId()));
            this.fHoverDescs[i].setPriority(PydevPlugin.getDefault().getPreferenceStore().getDefaultInt("PYDEV_TEXT_HOVER_PRORITY_" + this.fHoverDescs[i].getId()));
            this.fHoverDescs[i].setIsPreempt(PydevPlugin.getDefault().getPreferenceStore().getDefaultBoolean("PYDEV_TEXT_HOVER_PREEMPT_" + this.fHoverDescs[i].getId()));
            this.fHoverTableViewer.refresh();
            this.sortHoverDescriptors();
            ++i;
        }
        String modifierString = PydevPrefs.getPreferenceStore().getDefaultString("PYDEV_TEXT_HOVER_MODIFIER_" + this.fCombiningHover.getId());
        if ("0".equals(modifierString)) {
            modifierString = "";
        }
        this.fCombiningHover.fModifierString = modifierString;
        this.fCombiningHover.fStateMask = PyEditorTextHoverDescriptor.computeStateMask(modifierString);
        if (this.fCombiningHover.fStateMask == -1) {
            try {
                this.fCombiningHover.fStateMask = Integer.parseInt(PydevPrefs.getPreferenceStore().getString("PYDEV_TEXT_HOVER_MODIFIER_MASK_" + this.fCombiningHover.getId()));
            }
            catch (NumberFormatException numberFormatException) {
                this.fCombiningHover.fStateMask = -1;
            }
            int stateMask = this.fCombiningHover.fStateMask;
            this.fCombiningHover.fModifierString = stateMask == -1 ? "" : PyAction.getModifierString(stateMask);
        }
    }

    private void handleModifierModified(Text source) {
        String modifiers;
        int i = this.fHoverTable.getSelectionIndex();
        PyEditorTextHoverDescriptor hover = null;
        Text editor = source;
        if (source == this.fCombiningHoverModifierEditor) {
            hover = PydevPlugin.getCombiningHoverDescriptor();
        } else {
            if (i < 0) {
                return;
            }
            hover = this.fHoverDescs[i];
        }
        hover.fModifierString = modifiers = editor.getText();
        hover.fStateMask = PyEditorTextHoverDescriptor.computeStateMask(modifiers);
        if (!this.fHoverTableViewer.isCellEditorActive() && i >= 0) {
            this.fHoverTableViewer.refresh((Object)this.fHoverDescs[i]);
        }
        this.updateStatus(hover);
    }

    private void handleSetPriority(Integer priority) {
        int i = this.fHoverTable.getSelectionIndex();
        if (i == -1) {
            return;
        }
        PyEditorTextHoverDescriptor hover = this.fHoverDescs[i];
        hover.setPriority(priority);
        this.fHoverTableViewer.update((Object)this.fHoverDescs[i], null);
        this.sortHoverDescriptors();
        this.fHoverTableViewer.refresh();
        this.updateStatus(hover);
    }

    public void handleSetPreempt(Boolean preempt) {
        int i = this.fHoverTable.getSelectionIndex();
        if (i == -1) {
            return;
        }
        PyEditorTextHoverDescriptor hover = this.fHoverDescs[i];
        hover.setIsPreempt(preempt);
        this.fHoverTableViewer.refresh(((IStructuredSelection)this.fHoverTableViewer.getSelection()).getFirstElement());
        this.updateStatus(hover);
    }

    private void handleHoverListSelection() {
        int i = this.fHoverTable.getSelectionIndex();
        if (i == -1) {
            if (this.fHoverTable.getSelectionCount() == 0) {
                this.fModifierEditor.setEnabled(false);
            }
            return;
        }
        PyEditorTextHoverDescriptor hover = this.fHoverDescs[i];
        boolean enabled = hover.isEnabled();
        this.fModifierEditor.setEnabled(enabled && !this.fCombineHovers.getSelection());
        this.fModifierEditor.setText(hover.fModifierString);
        String description = this.fHoverDescs[i].getDescription();
        if (description == null) {
            description = "";
        }
        this.fDescription.setText(description);
    }

    IStatus getStatus() {
        if (fStatus == null) {
            fStatus = new StatusInfo();
        }
        return fStatus;
    }

    private void updateStatus(PyEditorTextHoverDescriptor hover) {
        fStatus = hover != null && hover.isEnabled() && hover.fStateMask == -1 ? new StatusInfo(4, Messages.format(PyEditorMessages.PyEditorHoverConfigurationBlock_modifierIsNotValid, hover.fModifierString)) : new StatusInfo();
        int i = 0;
        HashMap<Integer, String> stateMasks = new HashMap<Integer, String>(this.fHoverDescs.length);
        while (fStatus.isOK() && i < this.fHoverDescs.length) {
            if (this.fHoverDescs[i].isEnabled()) {
                String label = this.fHoverDescs[i].getLabel();
                Integer stateMask = new Integer(this.fHoverDescs[i].fStateMask);
                if (this.fHoverDescs[i].fStateMask == -1) {
                    fStatus = new StatusInfo(4, Messages.format(PyEditorMessages.PyEditorHoverConfigurationBlock_modifierIsNotValidForHover, new String[]{this.fHoverDescs[i].fModifierString, label}));
                } else {
                    stateMasks.put(stateMask, label);
                }
            }
            ++i;
        }
        this.fMainPreferencePage.setValid(fStatus.isOK());
        StatusUtil.applyToStatusLine((DialogPage)this.fMainPreferencePage, fStatus);
    }

    private void addFiller(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    @Override
    public void dispose() {
    }

    public void showColumn(TableColumn column, boolean show) {
        if (column.getWidth() != 0) {
            this.fColWidthsMap.put(column, column.getWidth());
        }
        if (this.fColWidthsMap.get(column) != null) {
            column.setWidth(show ? this.fColWidthsMap.get(column) : 0);
        }
    }

    private class HoverTableEditingSupport
    extends EditingSupport {
        private int column;
        CellEditor editor;
        private TableViewer viewer;

        public HoverTableEditingSupport(TableViewer viewer, int column) {
            super((ColumnViewer)viewer);
            this.viewer = viewer;
            this.column = column;
        }

        protected CellEditor getCellEditor(Object element) {
            if (this.column == 1) {
                this.editor = new TextCellEditor((Composite)this.viewer.getTable());
                this.editor.setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        boolean valid = true;
                        if (!"".equals(value)) {
                            try {
                                int val = Integer.parseInt((String)value);
                                if (val <= 0) {
                                    valid = false;
                                }
                            }
                            catch (ClassCastException | NumberFormatException runtimeException) {
                                valid = false;
                            }
                        }
                        HoverTableEditingSupport.this.editor.getControl().setBackground(valid ? null : Display.getDefault().getSystemColor(3));
                        return valid ? null : "positive integer required";
                    }
                });
                ((Text)((TextCellEditor)this.editor).getControl()).selectAll();
            } else if (this.column == 3) {
                this.editor = new CheckboxCellEditor((Composite)this.viewer.getTable());
            }
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            PyEditorTextHoverDescriptor descr = (PyEditorTextHoverDescriptor)element;
            if (descr != null) {
                switch (this.column) {
                    case 1: {
                        PyEditorHoverConfigurationBlock.this.fTableLabel.setText(String.valueOf(PyEditorMessages.PyEditorHoverConfigurationBlock_hoverPreferences) + PyEditorHoverConfigurationBlock.this.priorityHelpStr);
                        PyEditorHoverConfigurationBlock.this.fTableLabel.setStyleRange(PyEditorHoverConfigurationBlock.this.priorityHelpRange);
                        PyEditorHoverConfigurationBlock.this.fTableLabel.getParent().layout();
                        return String.valueOf(descr.getPriority());
                    }
                    case 3: {
                        return descr.isPreempt();
                    }
                }
            }
            return "";
        }

        protected void setValue(Object element, Object value) {
            switch (this.column) {
                case 1: {
                    ((PyEditorTextHoverDescriptor)element).setPriority(Integer.parseInt((String)value));
                    PyEditorHoverConfigurationBlock.this.handleSetPriority(Integer.parseInt((String)value));
                    PyEditorHoverConfigurationBlock.this.fTableLabel.setText(PyEditorMessages.PyEditorHoverConfigurationBlock_hoverPreferences);
                    PyEditorHoverConfigurationBlock.this.fTableLabel.setStyleRange(null);
                    PyEditorHoverConfigurationBlock.this.fTableLabel.getParent().layout();
                    break;
                }
                case 3: {
                    ((PyEditorTextHoverDescriptor)element).setIsPreempt(((PyEditorTextHoverDescriptor)element).isPreempt() == false);
                    PyEditorHoverConfigurationBlock.this.handleSetPreempt((Boolean)value);
                }
            }
            this.editor.dispose();
        }
    }

    private class KeyModifierListener
    implements KeyListener {
        private Text editor;
        private boolean isModifierCandidate;

        private KeyModifierListener(Text editor) {
            this.editor = editor;
        }

        public void keyPressed(KeyEvent e) {
            this.isModifierCandidate = e.keyCode > 0 && e.character == '\u0000' && e.stateMask == 0;
        }

        public void keyReleased(KeyEvent e) {
            if (this.isModifierCandidate && e.stateMask > 0 && e.stateMask == e.stateMask && e.character == '\u0000') {
                boolean needsPostfixDelimiter;
                String text = this.editor.getText();
                Point selection = this.editor.getSelection();
                int i = selection.x - 1;
                while (i > -1 && Character.isWhitespace(text.charAt(i))) {
                    --i;
                }
                boolean needsPrefixDelimiter = i > -1 && !String.valueOf(text.charAt(i)).equals(DELIMITER);
                i = selection.y;
                while (i < text.length() && Character.isWhitespace(text.charAt(i))) {
                    ++i;
                }
                boolean bl = needsPostfixDelimiter = i < text.length() && !String.valueOf(text.charAt(i)).equals(DELIMITER);
                String insertString = needsPrefixDelimiter && needsPostfixDelimiter ? Messages.format(PyEditorMessages.PyEditorHoverConfigurationBlock_insertDelimiterAndModifierAndDelimiter, new String[]{Action.findModifierString((int)e.stateMask)}) : (needsPrefixDelimiter ? Messages.format(PyEditorMessages.PyEditorHoverConfigurationBlock_insertDelimiterAndModifier, new String[]{Action.findModifierString((int)e.stateMask)}) : (needsPostfixDelimiter ? Messages.format(PyEditorMessages.PyEditorHoverConfigurationBlock_insertModifierAndDelimiter, new String[]{Action.findModifierString((int)e.stateMask)}) : Action.findModifierString((int)e.stateMask)));
                if (insertString != null) {
                    this.editor.insert(insertString);
                }
            }
        }
    }

    private class PyEditorTextHoverDescriptorContentProvider
    implements IStructuredContentProvider {
        private PyEditorTextHoverDescriptorContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object element) {
            return (Object[])element;
        }
    }

    private class PyEditorTextHoverDescriptorLabelProvider
    extends EmulatedNativeCheckBoxLabelProvider {
        public PyEditorTextHoverDescriptorLabelProvider(ColumnViewer viewer) {
            super(viewer);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void update(ViewerCell cell) {
            switch (cell.getColumnIndex()) {
                case 0: {
                    cell.setText(((PyEditorTextHoverDescriptor)cell.getElement()).getLabel());
                    break;
                }
                case 1: {
                    cell.setText(String.valueOf(((PyEditorTextHoverDescriptor)cell.getElement()).getPriority()));
                    break;
                }
                case 2: {
                    TableItem item = (TableItem)PyEditorHoverConfigurationBlock.this.fHoverTableViewer.testFindItem(cell.getElement());
                    int index = PyEditorHoverConfigurationBlock.this.fHoverTable.indexOf(item);
                    cell.setText(((PyEditorHoverConfigurationBlock)PyEditorHoverConfigurationBlock.this).fHoverDescs[index].fModifierString);
                    break;
                }
                case 3: {
                    cell.setImage(this.getImage(cell.getElement()));
                    break;
                }
            }
        }

        @Override
        protected boolean isChecked(Object element) {
            return ((PyEditorTextHoverDescriptor)element).isPreempt();
        }
    }
}

