/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.hover;

import java.io.IOException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.docutils.PyStringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.PyInformationPresenter;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.prettyprinterv2.IPrettyPrinterPrefs;
import org.python.pydev.parser.prettyprinterv2.PrettyPrinterPrefsV2;
import org.python.pydev.parser.prettyprinterv2.PrettyPrinterV2;
import org.python.pydev.parser.visitors.NodeUtils;

public abstract class AbstractPyEditorTextHover
implements ITextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    protected ITextSelection textSelection;
    protected PyInformationPresenter informationPresenter = new PyInformationPresenter();
    protected PyInformationControl informationControl;
    protected Integer hoverControlPreferredWidth;
    protected Integer hoverControlWidth = null;

    public abstract boolean isContentTypeSupported(String var1);

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                String tooltipAffordanceString = null;
                try {
                    tooltipAffordanceString = EditorsUI.getTooltipAffordanceString();
                }
                catch (Throwable throwable) {}
                AbstractPyEditorTextHover.this.informationControl = new PyInformationControl(parent, tooltipAffordanceString, (DefaultInformationControl.IInformationPresenter)AbstractPyEditorTextHover.this.informationPresenter);
                return AbstractPyEditorTextHover.this.informationControl;
            }
        };
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        this.textSelection = (ITextSelection)textViewer.getSelectionProvider().getSelection();
        return new Region(offset, 0);
    }

    public static String printAst(PyEdit edit, SimpleNode astToPrint) {
        String str = null;
        if (astToPrint != null) {
            IIndentPrefs indentPrefs = edit != null ? edit.getIndentPrefs() : DefaultIndentPrefs.get(null);
            Str docStr = NodeUtils.getNodeDocStringNode((SimpleNode)astToPrint);
            if (docStr != null) {
                docStr.s = PyStringUtils.fixWhitespaceColumnsToLeftFromDocstring((String)docStr.s, (String)indentPrefs.getIndentationString());
            }
            PrettyPrinterPrefsV2 prefsV2 = PrettyPrinterV2.createDefaultPrefs((IGrammarVersionProvider)edit, (IIndentPrefs)indentPrefs, (String)PyInformationPresenter.LINE_DELIM);
            PrettyPrinterV2 prettyPrinterV2 = new PrettyPrinterV2((IPrettyPrinterPrefs)prefsV2);
            try {
                str = prettyPrinterV2.print(astToPrint);
            }
            catch (IOException e) {
                Log.log((Throwable)e);
            }
        }
        return str;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        return this.getHoverInfo(textViewer, hoverRegion);
    }

    public void addInformationPresenterControlListener(ControlListener listener) {
        if (this.informationPresenter != null) {
            this.informationPresenter.addResizeCallback(listener);
        }
    }

    public void setHoverControlPreferredWidth(int width) {
        this.hoverControlPreferredWidth = width;
    }

    public Integer getHoverControlPreferredWidth() {
        return this.hoverControlPreferredWidth;
    }

    public final class PyInformationControl
    extends DefaultInformationControl
    implements IInformationControlExtension3 {
        private PyInformationControl(Shell parent, String statusFieldText, DefaultInformationControl.IInformationPresenter presenter) {
            super(parent, statusFieldText, presenter);
        }
    }
}

