/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist.docstrings;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.editor.correctionassist.docstrings.DocstringsPrefPage;
import org.python.pydev.editor.correctionassist.heuristics.IAssistProps;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.proposals.PyCompletionProposal;

public class AssistDocString
implements IAssistProps {
    private final String docStringStyle;

    public AssistDocString() {
        this(null);
    }

    public AssistDocString(String docStringStyle) {
        this.docStringStyle = docStringStyle;
    }

    @Override
    public List<ICompletionProposal> getProps(PySelection ps, ImageCache imageCache, File f, IPythonNature nature, PyEdit edit, int offset) throws BadLocationException {
        ArrayList<ICompletionProposal> l = new ArrayList<ICompletionProposal>();
        Tuple tuple = ps.getInsideParentesisToks(false);
        if (tuple == null) {
            if (ps.isInClassLine()) {
                tuple = new Tuple(new ArrayList(), (Object)offset);
            } else {
                return l;
            }
        }
        List params = (List)tuple.o1;
        int lineOfOffset = ps.getLineOfOffset(((Integer)tuple.o2).intValue());
        String initial = PySelection.getIndentationFromLine((String)ps.getCursorLineContents());
        String delimiter = PyAction.getDelimiter(ps.getDoc());
        String indentation = edit != null ? edit.getIndentPrefs().getIndentationString() : DefaultIndentPrefs.get((IAdaptable)nature).getIndentationString();
        String inAndIndent = String.valueOf(delimiter) + initial + indentation;
        FastStringBuffer buf = new FastStringBuffer();
        String docStringMarker = DocstringsPrefPage.getDocstringMarker();
        buf.append(String.valueOf(inAndIndent) + docStringMarker);
        buf.append(inAndIndent);
        int newOffset = buf.length();
        if (ps.isInFunctionLine(true)) {
            String preferredDocstringStyle = this.docStringStyle;
            if (preferredDocstringStyle == null) {
                preferredDocstringStyle = DocstringsPrefPage.getPreferredDocstringStyle();
            }
            for (String paramName : params) {
                if (!PySelection.isIdentifier((String)paramName)) continue;
                buf.append(inAndIndent).append(preferredDocstringStyle).append("param ").append(paramName).append(":");
                if (!DocstringsPrefPage.getTypeTagShouldBeGenerated(paramName)) continue;
                buf.append(inAndIndent).append(preferredDocstringStyle).append("type ").append(paramName).append(":");
            }
        }
        buf.append(inAndIndent).append(docStringMarker);
        String comp = buf.toString();
        int offsetPosToAdd = ps.getEndLineOffset(lineOfOffset);
        Image image = null;
        if (imageCache != null) {
            image = imageCache.get("icons/template.gif");
        }
        l.add((ICompletionProposal)new PyCompletionProposal(comp, offsetPosToAdd, 0, newOffset, image, "Make docstring", null, null, 10){

            public void apply(IDocument document) {
                PySelection ps = new PySelection(document, this.fReplacementOffset);
                int iNextLine = ps.getCursorLine() + 1;
                String nextLine = ps.getLine(iNextLine);
                if (nextLine.trim().equals("pass")) {
                    ps.deleteLine(iNextLine);
                }
                super.apply(document);
            }
        });
        return l;
    }

    @Override
    public boolean isValid(PySelection ps, String sel, PyEdit edit, int offset) {
        return ps.isInFunctionLine(true) || ps.isInClassLine();
    }
}

