/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited.visitors;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.IModule;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.editor.codecompletion.revisited.visitors.AssignDefinition;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.codecompletion.revisited.visitors.KeywordParameterDefinition;
import org.python.pydev.editor.codecompletion.revisited.visitors.ListCompDefinition;
import org.python.pydev.editor.codecompletion.revisited.visitors.LocalScope;
import org.python.pydev.editor.codecompletion.revisited.visitors.StopVisitingException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Comprehension;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Global;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.ListComp;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.Subscript;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.jython.ast.comprehensionType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.structure.FastStack;

public class FindDefinitionModelVisitor
extends AbstractVisitor {
    private String tokenToFind;
    public List<Definition> definitions = new ArrayList<Definition>();
    private FastStack<SimpleNode> defsStack = new FastStack(20);
    private FastStack<Set<String>> globalDeclarationsStack = new FastStack(20);
    private WeakReference<IModule> module;
    public String moduleImported;
    private int line;
    private int col;
    private boolean foundAsDefinition = false;
    private Definition definitionFound;
    private Stack<Call> call = new Stack();
    private static final StopVisitingException STOP_VISITING_EXCEPTION = new StopVisitingException();

    public FindDefinitionModelVisitor(String token, int line, int col, IModule module) {
        this.tokenToFind = token;
        this.module = new WeakReference<IModule>(module);
        this.line = line;
        this.col = col;
        this.moduleName = module.getName();
        this.globalDeclarationsStack.push(new HashSet());
    }

    public Object visitImportFrom(ImportFrom node) throws Exception {
        String modRep = NodeUtils.getRepresentationString((SimpleNode)node.module);
        if (NodeUtils.isWithin((int)this.line, (int)this.col, (SimpleNode)node.module)) {
            int startingCol;
            int endingCol = startingCol = node.module.beginColumn;
            while (endingCol < this.col) {
                ++endingCol;
            }
            int lastChar = endingCol - startingCol;
            this.moduleImported = modRep.substring(0, lastChar);
            int i = lastChar;
            while (i < modRep.length()) {
                if (!Character.isJavaIdentifierPart(modRep.charAt(i))) break;
                ++i;
            }
            this.moduleImported = String.valueOf(this.moduleImported) + modRep.substring(lastChar, i);
        } else {
            aliasType[] aliasTypeArray = node.names;
            int n = node.names.length;
            int n2 = 0;
            while (n2 < n) {
                aliasType alias = aliasTypeArray[n2];
                if (NodeUtils.isWithin((int)this.line, (int)this.col, (SimpleNode)alias.name)) {
                    this.moduleImported = String.valueOf(modRep) + "." + NodeUtils.getRepresentationString((SimpleNode)alias.name);
                }
                ++n2;
            }
        }
        return super.visitImportFrom(node);
    }

    protected Object unhandled_node(SimpleNode node) throws Exception {
        return null;
    }

    public void traverse(SimpleNode node) throws Exception {
        node.traverse((VisitorIF)this);
    }

    public Object visitClassDef(ClassDef node) throws Exception {
        this.globalDeclarationsStack.push(new HashSet());
        this.defsStack.push((Object)node);
        node.traverse((VisitorIF)this);
        this.defsStack.pop();
        this.globalDeclarationsStack.pop();
        this.checkDeclaration((SimpleNode)node, (NameTok)node.name);
        return null;
    }

    public Object visitFunctionDef(FunctionDef node) throws Exception {
        this.globalDeclarationsStack.push(new HashSet());
        this.defsStack.push((Object)node);
        if (node.args != null) {
            exprType arg;
            int n;
            int n2;
            exprType[] exprTypeArray;
            if (node.args.args != null) {
                exprTypeArray = node.args.args;
                n2 = node.args.args.length;
                n = 0;
                while (n < n2) {
                    arg = exprTypeArray[n];
                    if (arg instanceof Name) {
                        this.checkParam((Name)arg);
                    }
                    ++n;
                }
            }
            if (node.args.kwonlyargs != null) {
                exprTypeArray = node.args.kwonlyargs;
                n2 = node.args.kwonlyargs.length;
                n = 0;
                while (n < n2) {
                    arg = exprTypeArray[n];
                    if (arg instanceof Name) {
                        this.checkParam((Name)arg);
                    }
                    ++n;
                }
            }
        }
        node.traverse((VisitorIF)this);
        this.defsStack.pop();
        this.globalDeclarationsStack.pop();
        this.checkDeclaration((SimpleNode)node, (NameTok)node.name);
        return null;
    }

    private void checkParam(Name name) {
        String rep = NodeUtils.getRepresentationString((SimpleNode)name);
        if (rep.equals(this.tokenToFind) && this.line == name.beginLine && this.col >= name.beginColumn && this.col <= name.beginColumn + rep.length()) {
            this.foundAsDefinition = true;
            LocalScope scope = new LocalScope(this.defsStack);
            Iterator<Definition> it = this.definitions.iterator();
            while (it.hasNext()) {
                Definition d = it.next();
                if (d.scope.equals(scope)) continue;
                it.remove();
            }
            this.definitionFound = new Definition(this.line, name.beginColumn, rep, (SimpleNode)name, scope, (IModule)this.module.get());
            this.definitions.add(this.definitionFound);
        }
    }

    public Object visitCall(Call node) throws Exception {
        this.call.push(node);
        Object r = super.visitCall(node);
        this.call.pop();
        return r;
    }

    public Object visitNameTok(NameTok node) throws Exception {
        String rep;
        if (node.ctx == 3 && this.line == node.beginLine && this.call.size() > 0 && PySelection.isInside((int)this.col, (int)node.beginColumn, (int)(rep = NodeUtils.getRepresentationString((SimpleNode)node)).length())) {
            this.foundAsDefinition = true;
            LocalScope scope = new LocalScope(this.defsStack);
            Iterator<Definition> it = this.definitions.iterator();
            while (it.hasNext()) {
                Definition d = it.next();
                if (d.scope.equals(scope)) continue;
                it.remove();
            }
            this.definitions.clear();
            this.definitionFound = new KeywordParameterDefinition(this.line, node.beginColumn, rep, (SimpleNode)node, (ILocalScope)scope, (IModule)this.module.get(), this.call.peek());
            this.definitions.add(this.definitionFound);
            throw STOP_VISITING_EXCEPTION;
        }
        return null;
    }

    private void checkDeclaration(SimpleNode node, NameTok name) {
        String rep = NodeUtils.getRepresentationString((SimpleNode)node);
        if (rep.equals(this.tokenToFind) && (this.line == -1 && this.col == -1 || this.line == name.beginLine && this.col >= name.beginColumn && this.col <= name.beginColumn + rep.length())) {
            this.foundAsDefinition = true;
            LocalScope scope = new LocalScope(this.defsStack);
            Iterator<Definition> it = this.definitions.iterator();
            while (it.hasNext()) {
                Definition d = it.next();
                if (d.scope.equals(scope)) continue;
                it.remove();
            }
            this.definitionFound = new Definition(name.beginLine, name.beginColumn, rep, node, scope, (IModule)this.module.get());
            this.definitions.add(this.definitionFound);
        }
    }

    public Object visitGlobal(Global node) throws Exception {
        NameTokType[] nameTokTypeArray = node.names;
        int n = node.names.length;
        int n2 = 0;
        while (n2 < n) {
            NameTokType n3 = nameTokTypeArray[n2];
            ((Set)this.globalDeclarationsStack.peek()).add(NodeUtils.getFullRepresentationString((SimpleNode)n3));
            ++n2;
        }
        return null;
    }

    public Object visitModule(Module node) throws Exception {
        this.defsStack.push((Object)node);
        return super.visitModule(node);
    }

    public Object visitAssign(Assign node) throws Exception {
        return this.visitAssign(node, -1);
    }

    public Object visitAssign(Assign node, int unpackPos) throws Exception {
        LocalScope scope = new LocalScope(this.defsStack);
        scope.setFoundAtASTNode((ISimpleNode)node);
        if (this.foundAsDefinition && !((Object)scope).equals(this.definitionFound.scope)) {
            return null;
        }
        int i = 0;
        while (i < node.targets.length) {
            exprType target = node.targets[i];
            if (!(target instanceof Subscript)) {
                if (target instanceof Tuple) {
                    Tuple targetTuple = (Tuple)target;
                    if (node.value instanceof Tuple) {
                        Tuple valueTuple = (Tuple)node.value;
                        this.checkTupleAssignTarget(targetTuple, valueTuple.elts, false);
                    } else if (node.value instanceof org.python.pydev.parser.jython.ast.List) {
                        org.python.pydev.parser.jython.ast.List valueList = (org.python.pydev.parser.jython.ast.List)node.value;
                        this.checkTupleAssignTarget(targetTuple, valueList.elts, false);
                    } else {
                        this.checkTupleAssignTarget(targetTuple, new exprType[]{node.value}, true);
                    }
                } else {
                    String rep = NodeUtils.getFullRepresentationString((SimpleNode)target);
                    if (this.tokenToFind.equals(rep)) {
                        exprType nodeValue = node.value;
                        String value = NodeUtils.getFullRepresentationString((SimpleNode)nodeValue);
                        if (value == null) {
                            value = "";
                        }
                        int line = NodeUtils.getLineDefinition((SimpleNode)target);
                        int col = NodeUtils.getColDefinition((SimpleNode)target);
                        AssignDefinition definition = new AssignDefinition(value, rep, i, node, line, col, scope, (IModule)this.module.get(), nodeValue, unpackPos);
                        for (Set globals : this.globalDeclarationsStack) {
                            if (!globals.contains(rep)) continue;
                            definition.foundAsGlobal = true;
                        }
                        this.definitions.add(definition);
                    }
                }
            }
            ++i;
        }
        return super.visitAssign(node);
    }

    public Object visitListComp(ListComp node) throws Exception {
        block9: {
            exprType[] eltsFromCompoundObject;
            LocalScope scope;
            exprType elt;
            block10: {
                comprehensionType comprehensionType2;
                elt = node.elt;
                elt = this.fixMissingAttribute(elt);
                if (this.line != elt.beginLine) break block9;
                scope = new LocalScope(this.defsStack);
                scope.setFoundAtASTNode((ISimpleNode)node);
                if (this.foundAsDefinition && !((Object)scope).equals(this.definitionFound.scope)) {
                    return super.visitListComp(node);
                }
                if (!this.tokenToFind.equals(NodeUtils.getRepresentationString((SimpleNode)elt))) break block10;
                if (node.generators == null || node.generators.length != 1 || !((comprehensionType2 = node.generators[0]) instanceof Comprehension)) break block9;
                Comprehension comprehension = (Comprehension)comprehensionType2;
                if (comprehension.iter == null || !this.tokenToFind.equals(NodeUtils.getRepresentationString((SimpleNode)comprehension.target))) break block9;
                exprType[] elts = NodeUtils.getEltsFromCompoundObject((SimpleNode)comprehension.iter);
                String rep = "";
                if (elts != null && elts.length > 0) {
                    rep = NodeUtils.getRepresentationString((SimpleNode)elts[0]);
                }
                ListCompDefinition definition = new ListCompDefinition(rep, this.tokenToFind, node, this.line, this.col, scope, (IModule)this.module.get());
                this.definitions.add(definition);
                break block9;
            }
            if ((elt instanceof Tuple || elt instanceof List) && (eltsFromCompoundObject = NodeUtils.getEltsFromCompoundObject((SimpleNode)elt)) != null) {
                int length = eltsFromCompoundObject.length;
                int i = 0;
                while (i < length) {
                    comprehensionType comprehensionType3;
                    exprType eltFromCompound = this.fixMissingAttribute(eltsFromCompoundObject[i]);
                    if (this.tokenToFind.equals(NodeUtils.getRepresentationString((SimpleNode)eltFromCompound)) && node.generators != null && node.generators.length == 1 && (comprehensionType3 = node.generators[0]) instanceof Comprehension) {
                        exprType[] targetElts;
                        exprType target;
                        Comprehension comprehension = (Comprehension)comprehensionType3;
                        if (comprehension.iter != null && (target = comprehension.target) != null && (targetElts = NodeUtils.getEltsFromCompoundObject((SimpleNode)target)) != null) {
                            int j = 0;
                            while (j < targetElts.length) {
                                exprType targetElt = targetElts[j];
                                if (this.tokenToFind.equals(NodeUtils.getRepresentationString((SimpleNode)targetElt))) {
                                    exprType[] elts = NodeUtils.getEltsFromCompoundObject((SimpleNode)comprehension.iter);
                                    String rep = "";
                                    if (elts != null && elts.length > j) {
                                        rep = NodeUtils.getRepresentationString((SimpleNode)elts[j]);
                                    }
                                    ListCompDefinition definition = new ListCompDefinition(rep, this.tokenToFind, node, this.line, this.col, scope, (IModule)this.module.get());
                                    this.definitions.add(definition);
                                }
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        return super.visitListComp(node);
    }

    private exprType fixMissingAttribute(exprType elt) {
        if (elt instanceof Attribute) {
            Attribute attribute = (Attribute)elt;
            String rep = NodeUtils.getRepresentationString((SimpleNode)attribute.attr);
            if (rep == null || rep.startsWith("!")) {
                elt = attribute.value;
            }
        }
        return elt;
    }

    private void checkTupleAssignTarget(Tuple targetTuple, exprType[] valueElts, boolean unpackElements) throws Exception {
        if (valueElts == null || valueElts.length == 0) {
            return;
        }
        int i = 0;
        while (i < targetTuple.elts.length) {
            int j = i;
            if (j >= valueElts.length) {
                j = valueElts.length - 1;
            }
            Assign assign = new Assign(new exprType[]{targetTuple.elts[i]}, valueElts[j]);
            assign.beginLine = targetTuple.beginLine;
            assign.beginColumn = targetTuple.beginColumn;
            if (unpackElements) {
                this.visitAssign(assign, i);
            } else {
                this.visitAssign(assign);
            }
            ++i;
        }
    }
}

