/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.ide.IDE;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.ModulesKeyForZip;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.IPythonModuleResolver;
import org.python.pydev.editor.codecompletion.revisited.ModulesFoundStructure;
import org.python.pydev.plugin.PyStructureConfigHelpers;
import org.python.pydev.plugin.nature.IPythonPathHelper;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.OrderedMap;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;
import org.python.pydev.utils.PyFileListing;

public final class PythonPathHelper
implements IPythonPathHelper {
    private volatile List<String> pythonpath = Collections.unmodifiableList(new ArrayList());
    private List<IPath> searchPaths = Collections.unmodifiableList(new ArrayList());
    private transient IPythonModuleResolver[] pythonModuleResolvers;
    private final Object pythonModuleResolversLock = new Object();
    public static final int OPERATION_MOVE = 1;
    public static final int OPERATION_COPY = 2;
    public static final int OPERATION_DELETE = 3;

    public static String getDefaultPathStr(String str) {
        return StringUtils.replaceAllSlashes((String)str.trim());
    }

    public static PyFileListing getModulesBelow(File root, IProgressMonitor monitor) {
        if (!root.exists()) {
            return null;
        }
        if (root.isDirectory()) {
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    if (pathname.isFile()) {
                        return PythonPathHelper.isValidFileMod(FileUtils.getFileAbsolutePath((File)pathname));
                    }
                    if (pathname.isDirectory()) {
                        return PythonPathHelper.isFolderWithInit(pathname);
                    }
                    return false;
                }
            };
            return PyFileListing.getPyFilesBelow(root, filter, monitor, true);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static ModulesFoundStructure.ZipContents getFromZip(File root, IProgressMonitor monitor) {
        String fileName = root.getName();
        if (!root.isFile()) return null;
        if (!FileTypesPreferencesPage.isValidZipFile(fileName)) return null;
        ModulesFoundStructure.ZipContents zipContents = new ModulesFoundStructure.ZipContents(root);
        zipContents.zipContentsType = ModulesFoundStructure.ZipContents.ZIP_CONTENTS_TYPE_PY_ZIP;
        try {
            String zipFileName = root.getName();
            try (ZipFile zipFile = new ZipFile(root);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                int i = 0;
                FastStringBuffer buffer = new FastStringBuffer();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!entry.isDirectory()) {
                        if (PythonPathHelper.isValidFileMod(name) || name.endsWith(".class")) {
                            if (name.endsWith(".class")) {
                                zipContents.zipContentsType = ModulesFoundStructure.ZipContents.ZIP_CONTENTS_TYPE_JAR;
                            }
                            if (i % 15 == 0) {
                                if (monitor.isCanceled()) {
                                    return null;
                                }
                                buffer.clear();
                                monitor.setTaskName(buffer.append("Found in ").append(zipFileName).append(" module ").append(name).toString());
                                monitor.worked(1);
                            }
                            if (PythonPathHelper.isValidInitFile(name)) {
                                zipContents.pyInitFilesLowerWithoutExtension.add(StringUtils.stripExtension((String)name).toLowerCase());
                            }
                            zipContents.pyFilesLowerToRegular.put(name.toLowerCase(), name);
                        }
                    } else {
                        zipContents.pyfoldersLower.add(name.toLowerCase());
                    }
                    ++i;
                }
            }
            zipContents.consolidatePythonpathInfo(monitor);
            return zipContents;
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return null;
    }

    public static boolean isValidSourceFile(String path) {
        return PythonPathHelper.isValidSourceFile(path, FileTypesPreferencesPage.getDottedValidSourceFiles());
    }

    public static boolean isValidSourceFile(String path, String[] dottedValidSourceFiles) {
        int len = dottedValidSourceFiles.length;
        int i = 0;
        while (i < len) {
            if (path.endsWith(dottedValidSourceFiles[i])) {
                return true;
            }
            ++i;
        }
        return path.endsWith(".pypredef");
    }

    public static boolean isValidSourceFile(IFile file) {
        String ext = file.getFileExtension();
        if (ext == null) {
            return false;
        }
        ext = ext.toLowerCase();
        String[] validSourceFiles = FileTypesPreferencesPage.getValidSourceFiles();
        int len = validSourceFiles.length;
        int i = 0;
        while (i < len) {
            String end = validSourceFiles[i];
            if (ext.equals(end)) {
                return true;
            }
            ++i;
        }
        return ext.equals(".pypredef");
    }

    public static boolean isValidFileMod(String path) {
        boolean ret = false;
        if (PythonPathHelper.isValidSourceFile(path)) {
            ret = true;
        } else if (FileTypesPreferencesPage.isValidDll(path)) {
            ret = true;
        }
        return ret;
    }

    @Override
    public String resolveModule(String absoluteModuleLocation, IProject project) {
        return this.resolveModule(absoluteModuleLocation, false, this.getPythonpath(), project);
    }

    public String resolveModule(String absoluteModuleLocation, boolean requireFileToExist, IProject project) {
        return this.resolveModule(absoluteModuleLocation, requireFileToExist, this.getPythonpath(), project);
    }

    public String resolveModule(String absoluteModuleLocation, boolean requireFileToExist, List<String> baseLocations, IProject project) {
        IPath modulePath = Path.fromOSString((String)absoluteModuleLocation);
        if (requireFileToExist && !modulePath.toFile().exists()) {
            return null;
        }
        IPythonModuleResolver[] pythonModuleResolvers = this.getPythonModuleResolvers();
        if (pythonModuleResolvers.length > 0) {
            ArrayList<IPath> convertedBasePaths = new ArrayList<IPath>();
            for (String searchPath : baseLocations) {
                convertedBasePaths.add(Path.fromOSString((String)searchPath));
            }
            IPythonModuleResolver[] iPythonModuleResolverArray = pythonModuleResolvers;
            int n = pythonModuleResolvers.length;
            int n2 = 0;
            while (n2 < n) {
                IPythonModuleResolver resolver = iPythonModuleResolverArray[n2];
                String resolved = resolver.resolveModule(project, modulePath, convertedBasePaths);
                if (resolved != null) {
                    if (resolved.isEmpty()) {
                        return null;
                    }
                    return resolved;
                }
                ++n2;
            }
        }
        absoluteModuleLocation = FileUtils.getFileAbsolutePath((String)absoluteModuleLocation);
        String fullPathWithoutExtension = PythonPathHelper.isValidSourceFile(absoluteModuleLocation = PythonPathHelper.getDefaultPathStr(absoluteModuleLocation)) || FileTypesPreferencesPage.isValidDll(absoluteModuleLocation) ? FullRepIterable.headAndTail((String)absoluteModuleLocation)[0] : absoluteModuleLocation;
        File moduleFile = new File(absoluteModuleLocation);
        boolean isFile = moduleFile.isFile();
        for (String pathEntry : baseLocations) {
            String element = PythonPathHelper.getDefaultPathStr(pathEntry);
            if (!absoluteModuleLocation.startsWith(element)) continue;
            int len = element.length();
            String s = absoluteModuleLocation.substring(len);
            String sWithoutExtension = fullPathWithoutExtension.substring(len);
            if (s.startsWith("/")) {
                s = s.substring(1);
            }
            if (sWithoutExtension.startsWith("/")) {
                sWithoutExtension = sWithoutExtension.substring(1);
            }
            if (!PythonPathHelper.isValidModuleLastPart(sWithoutExtension)) continue;
            if ((s = s.replaceAll("/", ".")).indexOf(".") != -1) {
                int i;
                File root = new File(element);
                if (!root.exists()) continue;
                List temp = StringUtils.dotSplit((String)s);
                String[] modulesParts = temp.toArray(new String[temp.size()]);
                if (modulesParts.length > 1 && isFile) {
                    String[] t = new String[modulesParts.length - 1];
                    i = 0;
                    while (i < modulesParts.length - 1) {
                        t[i] = modulesParts[i];
                        ++i;
                    }
                    t[t.length - 1] = String.valueOf(t[t.length - 1]) + "." + modulesParts[modulesParts.length - 1];
                    modulesParts = t;
                }
                boolean isValid = true;
                i = 0;
                while (i < modulesParts.length && root != null) {
                    root = new File(String.valueOf(FileUtils.getFileAbsolutePath((File)root)) + "/" + modulesParts[i]);
                    if (PythonPathHelper.isValidFileMod(modulesParts[i])) {
                        if (root.exists() && root.isFile()) {
                            break;
                        }
                    } else if (!PythonPathHelper.isFolderWithInit(root)) {
                        isValid = false;
                        break;
                    }
                    ++i;
                }
                if (!isValid) continue;
                if (isFile) {
                    s = PythonPathHelper.stripExtension(s);
                } else if (!moduleFile.exists() && PythonPathHelper.isValidFileMod(s)) {
                    s = PythonPathHelper.stripExtension(s);
                }
                return s;
            }
            if (!isFile && moduleFile.isDirectory() && !PythonPathHelper.isFolderWithInit(moduleFile)) {
                return null;
            }
            return s;
        }
        if (!requireFileToExist) {
            for (String element : baseLocations) {
                if (!fullPathWithoutExtension.startsWith(element = PythonPathHelper.getDefaultPathStr(element))) continue;
                String s = fullPathWithoutExtension.substring(element.length());
                if (s.startsWith("/")) {
                    s = s.substring(1);
                }
                if (!PythonPathHelper.isValidModuleLastPart(s)) continue;
                s = s.replaceAll("/", ".");
                return s;
            }
        }
        return null;
    }

    public static String stripExtension(String s) {
        if (s != null) {
            return StringUtils.stripExtension((String)s);
        }
        return null;
    }

    public static boolean isFolderWithInit(File root) {
        return PythonPathHelper.getFolderInit(root) != null;
    }

    public static File getFolderInit(File root) {
        String[] validInitFiles = FileTypesPreferencesPage.getValidInitFiles();
        int len = validInitFiles.length;
        int i = 0;
        while (i < len) {
            String init = validInitFiles[i];
            File f = new File(root, init);
            if (f.exists()) {
                return f;
            }
            ++i;
        }
        return null;
    }

    public static IFile getFolderInit(IContainer root) {
        String[] validInitFiles = FileTypesPreferencesPage.getValidInitFiles();
        int len = validInitFiles.length;
        int i = 0;
        while (i < len) {
            String init = validInitFiles[i];
            IFile f = root.getFile((IPath)new Path(init));
            if (f.exists()) {
                return f;
            }
            ++i;
        }
        return null;
    }

    public static boolean isValidInitFile(String path) {
        String[] validInitFiles = FileTypesPreferencesPage.getValidInitFiles();
        int len = validInitFiles.length;
        int i = 0;
        while (i < len) {
            String init = validInitFiles[i];
            if (path.endsWith(init)) {
                char c;
                int index = path.length() - init.length() - 1;
                return index < 0 || (c = path.charAt(index)) == '/' || c == '\\';
            }
            ++i;
        }
        return false;
    }

    public static boolean isValidModuleLastPart(String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '-' || c == ' ' || c == '.' || c == '+') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setPythonPath(List<String> newPythonpath) {
        this.pythonpath = Collections.unmodifiableList(new ArrayList<String>(newPythonpath));
        this.fixSearchPaths();
    }

    private void fixSearchPaths() {
        List<String> pathStrings = this.getPythonpath();
        ArrayList<IPath> searchPaths = new ArrayList<IPath>(pathStrings.size());
        for (String searchPath : pathStrings) {
            searchPaths.add(Path.fromOSString((String)searchPath));
        }
        this.searchPaths = Collections.unmodifiableList(searchPaths);
    }

    @Override
    public void setPythonPath(String string) {
        this.setPythonPath(PythonPathHelper.parsePythonPathFromStr(string, new ArrayList<String>()));
    }

    public static List<String> parsePythonPathFromStr(String string, List<String> lPath) {
        if (lPath == null) {
            lPath = new ArrayList<String>();
        }
        String[] strings = string.split("\\|");
        int i = 0;
        while (i < strings.length) {
            String defaultPathStr = PythonPathHelper.getDefaultPathStr(strings[i]);
            if (defaultPathStr != null && defaultPathStr.trim().length() > 0) {
                File file = new File(defaultPathStr);
                if (file.exists()) {
                    String path = FileUtils.getFileAbsolutePath((File)file);
                    lPath.add(path);
                } else {
                    lPath.add(defaultPathStr);
                }
            }
            ++i;
        }
        return lPath;
    }

    @Override
    public List<String> getPythonpath() {
        return this.pythonpath;
    }

    @Override
    public ModulesFoundStructure getModulesFoundStructure(IProgressMonitor monitor) {
        return this.getModulesFoundStructure(null, monitor);
    }

    public ModulesFoundStructure getModulesFoundStructure(IProject project, IProgressMonitor monitor) {
        IPythonModuleResolver[] pythonModuleResolvers;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((pythonModuleResolvers = this.getPythonModuleResolvers()).length > 0) {
            List<IPath> searchPaths = this.searchPaths;
            IPythonModuleResolver[] iPythonModuleResolverArray = pythonModuleResolvers;
            int n = pythonModuleResolvers.length;
            int n2 = 0;
            while (n2 < n) {
                IPythonModuleResolver finder = iPythonModuleResolverArray[n2];
                Collection<IPath> modulesAndZips = finder.findAllModules(project, monitor);
                if (modulesAndZips != null) {
                    ModulesFoundStructure modulesFoundStructure = new ModulesFoundStructure();
                    for (IPath moduleOrZip : modulesAndZips) {
                        File moduleOrZipFile = moduleOrZip.toFile();
                        if (FileTypesPreferencesPage.isValidZipFile(moduleOrZip.toOSString())) {
                            ModulesFoundStructure.ZipContents zipContents = PythonPathHelper.getFromZip(moduleOrZipFile, monitor);
                            if (zipContents == null) continue;
                            modulesFoundStructure.zipContents.add(zipContents);
                            continue;
                        }
                        String qualifiedName = finder.resolveModule(project, moduleOrZip, searchPaths);
                        if (qualifiedName == null || qualifiedName.isEmpty()) continue;
                        modulesFoundStructure.regularModules.put(moduleOrZipFile, qualifiedName);
                    }
                    return modulesFoundStructure;
                }
                ++n2;
            }
        }
        ModulesFoundStructure ret = new ModulesFoundStructure();
        List<String> pythonpathList = this.getPythonpath();
        FastStringBuffer tempBuf = new FastStringBuffer();
        for (String element : pythonpathList) {
            if (monitor.isCanceled()) break;
            File root = new File(element);
            PyFileListing below = PythonPathHelper.getModulesBelow(root, monitor);
            if (below != null) {
                for (PyFileListing.PyFileInfo pyFileInfo : below.getFoundPyFileInfos()) {
                    File file = pyFileInfo.getFile();
                    String modName = pyFileInfo.getModuleName(tempBuf);
                    if (!PythonPathHelper.isValidModuleLastPart(FullRepIterable.getLastPart((String)modName))) continue;
                    ret.regularModules.put(file, modName);
                }
                continue;
            }
            ModulesFoundStructure.ZipContents zipContents = PythonPathHelper.getFromZip(root, monitor);
            if (zipContents == null) continue;
            ret.zipContents.add(zipContents);
        }
        return ret;
    }

    public void loadFromFile(File pythonpatHelperFile) throws IOException {
        String fileContents = FileUtils.getFileContents((File)pythonpatHelperFile);
        if (fileContents == null || fileContents.trim().length() == 0) {
            throw new IOException("No loaded contents from: " + pythonpatHelperFile);
        }
        this.setPythonPath(StringUtils.split((String)fileContents, (char)'\n'));
    }

    public void saveToFile(File pythonpatHelperFile) {
        FileUtils.writeStrToFile((String)StringUtils.join((String)"\n", this.pythonpath), (File)pythonpatHelperFile);
    }

    public static boolean canAddAstInfoForSourceModule(ModulesKey key) {
        if (key.file != null && key.file.exists()) {
            if (PythonPathHelper.isValidSourceFile(key.file.getName())) {
                return true;
            }
            boolean isZipModule = key instanceof ModulesKeyForZip;
            if (isZipModule) {
                ModulesKeyForZip modulesKeyForZip = (ModulesKeyForZip)key;
                if (PythonPathHelper.isValidSourceFile(modulesKeyForZip.zipModulePath)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean markAsPyDevFileIfDetected(IFile file) {
        block6: {
            String editorID;
            block5: {
                String name = file.getName();
                if (name == null || name.indexOf(46) != -1) {
                    return false;
                }
                editorID = file.getPersistentProperty(IDE.EDITOR_KEY);
                if (editorID != null) break block5;
                InputStream contents = file.getContents(true);
                InputStreamReader inputStreamReader = new InputStreamReader(new BufferedInputStream(contents));
                if (FileUtils.hasPythonShebang((Reader)inputStreamReader)) {
                    IDE.setDefaultEditor((IFile)file, (String)"org.python.pydev.editor.PythonEditor");
                    return true;
                }
            }
            try {
                return "org.python.pydev.editor.PythonEditor".equals(editorID);
            }
            catch (Exception e) {
                if (!file.exists()) break block6;
                Log.log((Throwable)e);
            }
        }
        return false;
    }

    private static OrderedMap<String, String> getResourcePythonPathMap(Map<IProject, OrderedMap<String, String>> projectSourcePathMapsCache, IResource resource) {
        IProject project = resource.getProject();
        OrderedMap sourceMap = projectSourcePathMapsCache.get(project);
        if (sourceMap == null) {
            IPythonPathNature pythonPathNature = PythonNature.getPythonPathNature(project);
            if (pythonPathNature == null) {
                sourceMap = new OrderedMap();
            } else {
                try {
                    sourceMap = pythonPathNature.getProjectSourcePathResolvedToUnresolvedMap();
                }
                catch (CoreException e) {
                    sourceMap = new OrderedMap();
                    Log.log((Throwable)e);
                }
            }
            projectSourcePathMapsCache.put(project, (OrderedMap<String, String>)sourceMap);
        }
        return sourceMap;
    }

    public static void updatePyPath(IResource[] copiedResources, IContainer destination, int operation) {
        try {
            HashMap<IProject, OrderedMap<String, String>> projectSourcePathMapsCache = new HashMap<IProject, OrderedMap<String, String>>();
            ArrayList<String> addToDestProjects = new ArrayList<String>();
            HashSet<IProject> changed = new HashSet<IProject>();
            IResource[] iResourceArray = copiedResources;
            int n = copiedResources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFolder) {
                    OrderedMap<String, String> sourceMap = PythonPathHelper.getResourcePythonPathMap(projectSourcePathMapsCache, resource);
                    Set keySet = sourceMap.keySet();
                    Iterator it = keySet.iterator();
                    while (it.hasNext()) {
                        String next = (String)it.next();
                        IPath existingInPath = Path.fromPortableString((String)next);
                        if (!resource.getFullPath().isPrefixOf(existingInPath)) continue;
                        if (operation == 1 || operation == 3) {
                            it.remove();
                            changed.add(resource.getProject());
                        }
                        if (operation != 2 && operation != 1) continue;
                        String addToNewProjectPath = destination.getFullPath().append(existingInPath.removeFirstSegments(resource.getFullPath().segmentCount() - 1)).toPortableString();
                        addToDestProjects.add(addToNewProjectPath);
                    }
                }
                ++n2;
            }
            if (operation != 3) {
                OrderedMap<String, String> destSourceMap = PythonPathHelper.getResourcePythonPathMap(projectSourcePathMapsCache, (IResource)destination);
                IProject destProject = destination.getProject();
                for (String addToNewProjectPath : addToDestProjects) {
                    String destActualPath = PyStructureConfigHelpers.convertToProjectRelativePath(destProject.getFullPath().toPortableString(), addToNewProjectPath);
                    destSourceMap.put((Object)addToNewProjectPath, (Object)destActualPath);
                    changed.add(destProject);
                }
            }
            for (IProject project : changed) {
                OrderedMap<String, String> sourceMap = PythonPathHelper.getResourcePythonPathMap(projectSourcePathMapsCache, (IResource)project);
                PythonNature nature = PythonNature.getPythonNature(project);
                if (nature == null) continue;
                nature.getPythonPathNature().setProjectSourcePath(StringUtils.join((String)"|", (Collection)sourceMap.values()));
                nature.rebuildPath();
            }
        }
        catch (Exception e) {
            Log.log((int)4, (String)"Unexpected error setting project properties", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPythonModuleResolver[] getPythonModuleResolvers() {
        if (this.pythonModuleResolvers != null) {
            return this.pythonModuleResolvers;
        }
        Object object = this.pythonModuleResolversLock;
        synchronized (object) {
            if (this.pythonModuleResolvers != null) {
                return this.pythonModuleResolvers;
            }
            ArrayList<IPythonModuleResolver> tempPythonModuleResolvers = new ArrayList<IPythonModuleResolver>();
            List resolvers = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_python_module_resolver");
            for (Object resolver : resolvers) {
                if (!(resolver instanceof IPythonModuleResolver)) continue;
                tempPythonModuleResolvers.add((IPythonModuleResolver)resolver);
            }
            this.pythonModuleResolvers = tempPythonModuleResolvers.toArray(new IPythonModuleResolver[0]);
            return this.pythonModuleResolvers;
        }
    }
}

