/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.autoedit;

import org.eclipse.core.runtime.IAdaptable;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.ITabChangedListener;
import org.python.pydev.editor.autoedit.AbstractIndentPrefs;
import org.python.pydev.editor.autoedit.TestIndentPrefs;
import org.python.pydev.editor.preferences.PyScopedPreferences;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.callbacks.ListenerList;

public class DefaultIndentPrefs
extends AbstractIndentPrefs {
    private String indentString = null;
    private String lastIndentString = null;
    private boolean lastUseSpaces;
    private int lastTabWidth;
    private final IAdaptable projectAdaptable;
    private static IIndentPrefs indentPrefs;
    private ListenerList<ITabChangedListener> listenerList = new ListenerList(ITabChangedListener.class);
    Boolean lastGuessTabSubstitution = null;

    public void addTabChangedListener(ITabChangedListener listener) {
        this.listenerList.add((Object)listener);
    }

    public static synchronized void set(IIndentPrefs indentPrefs) {
        DefaultIndentPrefs.indentPrefs = indentPrefs;
    }

    public static IIndentPrefs get(IAdaptable projectAdaptable) {
        if (indentPrefs != null) {
            return indentPrefs;
        }
        if (SharedCorePlugin.inTestMode()) {
            return new TestIndentPrefs(true, 4);
        }
        return new DefaultIndentPrefs(projectAdaptable);
    }

    public DefaultIndentPrefs(IAdaptable projectAdaptable) {
        this.projectAdaptable = projectAdaptable;
        this.lastUseSpaces = this.getBoolFromPreferences("SUBSTITUTE_TABS");
        this.regenerateIndentString();
    }

    public boolean getUseSpaces(boolean considerForceTabs) {
        boolean boolFromPreferences = this.getBoolFromPreferences("SUBSTITUTE_TABS");
        if (this.lastUseSpaces != boolFromPreferences) {
            this.lastUseSpaces = boolFromPreferences;
            this.regenerateIndentString();
        }
        if (considerForceTabs && this.getForceTabs()) {
            return false;
        }
        return this.lastUseSpaces;
    }

    @Override
    public void setForceTabs(boolean forceTabs) {
        super.setForceTabs(forceTabs);
        this.regenerateIndentString();
    }

    public int getTabWidth() {
        if (this.lastTabWidth != this.getIntFromPreferences("TAB_WIDTH", 1)) {
            this.lastTabWidth = this.getIntFromPreferences("TAB_WIDTH", 1);
            this.regenerateIndentString();
        }
        return this.lastTabWidth;
    }

    public boolean getGuessTabSubstitution() {
        boolean curr = this.getBoolFromPreferences("GUESS_TAB_SUBSTITUTION");
        if (this.lastGuessTabSubstitution != null && this.lastGuessTabSubstitution != curr) {
            this.regenerateIndentString();
        }
        this.lastGuessTabSubstitution = curr;
        return curr;
    }

    public void regenerateIndentString() {
        this.indentString = super.getIndentationString();
        if (this.lastIndentString == null || !this.lastIndentString.equals(this.indentString)) {
            ITabChangedListener[] listeners;
            this.lastIndentString = this.indentString;
            ITabChangedListener[] iTabChangedListenerArray = listeners = (ITabChangedListener[])this.listenerList.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                ITabChangedListener iTabChangedListener = iTabChangedListenerArray[n2];
                iTabChangedListener.onTabSettingsChanged((IIndentPrefs)this);
                ++n2;
            }
        }
    }

    @Override
    public String getIndentationString() {
        return this.indentString;
    }

    public boolean getAutoParentesis() {
        return this.getBoolFromPreferences("AUTO_PAR");
    }

    public boolean getAutoLink() {
        return this.getBoolFromPreferences("AUTO_LINK");
    }

    public boolean getIndentToParLevel() {
        return this.getBoolFromPreferences("AUTO_INDENT_TO_PAR_LEVEL");
    }

    public boolean getAutoColon() {
        return this.getBoolFromPreferences("AUTO_COLON");
    }

    public boolean getAutoBraces() {
        return this.getBoolFromPreferences("AUTO_BRACES");
    }

    public boolean getAutoWriteImport() {
        return this.getBoolFromPreferences("AUTO_WRITE_IMPORT_STR");
    }

    public boolean getSmartIndentPar() {
        return this.getBoolFromPreferences("SMART_INDENT_PAR");
    }

    public boolean getAutoAddSelf() {
        return this.getBoolFromPreferences("AUTO_ADD_SELF");
    }

    public boolean getAutoDedentElse() {
        return this.getBoolFromPreferences("AUTO_DEDENT_ELSE");
    }

    public int getIndentAfterParWidth() {
        return this.getIntFromPreferences("AUTO_INDENT_AFTER_PAR_WIDTH", 1);
    }

    public boolean getSmartLineMove() {
        return this.getBoolFromPreferences("SMART_LINE_MOVE");
    }

    public boolean getAutoLiterals() {
        return this.getBoolFromPreferences("AUTO_LITERALS");
    }

    public boolean getTabStopInComment() {
        return this.getBoolFromPreferences("TAB_STOP_IN_COMMENT");
    }

    private boolean getBoolFromPreferences(String pref) {
        return PyScopedPreferences.getBoolean(pref, this.projectAdaptable);
    }

    private int getIntFromPreferences(String pref, int minVal) {
        return PyScopedPreferences.getInt(pref, this.projectAdaptable, minVal);
    }
}

