/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.actions.PyConvertSpaceToTab;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class PyConvertTabToSpace
extends PyConvertSpaceToTab {
    private static PySelection ps;

    @Override
    public void run(IAction action) {
        try {
            if (!this.canModifyEditor()) {
                return;
            }
            ITextEditor textEditor = this.getTextEditor();
            ps = new PySelection(textEditor);
            ps.selectAll(false);
            PyConvertTabToSpace.perform(textEditor);
            textEditor.selectAndReveal(ps.getLineOffset(), 0);
        }
        catch (Exception e) {
            PyConvertTabToSpace.beep(e);
        }
    }

    public static boolean perform(ITextEditor textEditor) {
        return PyConvertTabToSpace.perform(ps, textEditor);
    }

    public static boolean perform(PySelection ps, ITextEditor textEditor) {
        FastStringBuffer strbuf = new FastStringBuffer();
        ps.selectCompleteLine();
        try {
            IDocument doc = ps.getDoc();
            String tabSpace = PyConvertTabToSpace.getTabSpace(textEditor);
            int endLineIndex = ps.getEndLineIndex();
            String endLineDelim = ps.getEndLineDelim();
            int i = ps.getStartLineIndex();
            while (i <= endLineIndex) {
                IRegion lineInformation = doc.getLineInformation(i);
                String line = doc.get(lineInformation.getOffset(), lineInformation.getLength());
                strbuf.append(String.valueOf(line.replaceAll("\t", tabSpace)) + (i < endLineIndex ? endLineDelim : ""));
                ++i;
            }
            doc.replace(ps.getStartLine().getOffset(), ps.getSelLength(), strbuf.toString());
            return true;
        }
        catch (Exception e) {
            PyConvertTabToSpace.beep(e);
            return false;
        }
    }
}

