/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.util.ArrayList;
import org.eclipse.core.runtime.Preferences;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.actions.AbstractBlockCommentAction;
import org.python.pydev.editor.actions.PyFormatStd;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class PyAddBlockComment
extends AbstractBlockCommentAction {
    private boolean defaultClassNameBehaviour;
    private boolean defaultFunctionNameBehaviour;
    private PyFormatStd.FormatStd std;

    public PyAddBlockComment(PyFormatStd.FormatStd std) {
        this.std = std;
    }

    public PyAddBlockComment() {
        this(null);
    }

    PyAddBlockComment(PyFormatStd.FormatStd std, int defaultCols, boolean alignLeft, boolean classNameBehaviour, boolean functionNameBehaviour) {
        super(defaultCols, alignLeft);
        this.std = std;
        this.defaultClassNameBehaviour = classNameBehaviour;
        this.defaultFunctionNameBehaviour = functionNameBehaviour;
    }

    @Override
    protected void revealSelEndLine(PySelection ps) {
        this.getTextEditor().selectAndReveal(ps.getEndLine().getOffset(), 0);
    }

    protected boolean getUseClassNameBehaviour() {
        if (SharedCorePlugin.inTestMode()) {
            return this.defaultClassNameBehaviour;
        }
        Preferences prefs = PydevPlugin.getDefault().getPluginPreferences();
        return prefs.getBoolean("MULTI_BLOCK_COMMENT_SHOW_ONLY_CLASS_NAME");
    }

    protected boolean getUseFunctionNameBehaviour() {
        if (SharedCorePlugin.inTestMode()) {
            return this.defaultFunctionNameBehaviour;
        }
        Preferences prefs = PydevPlugin.getDefault().getPluginPreferences();
        return prefs.getBoolean("MULTI_BLOCK_COMMENT_SHOW_ONLY_FUNCTION_NAME");
    }

    @Override
    public Tuple<Integer, Integer> perform(PySelection ps) {
        FastStringBuffer strbuf = new FastStringBuffer();
        FastStringBuffer tempBuffer = new FastStringBuffer();
        ps.selectCompleteLine();
        try {
            String endLineDelim = ps.getEndLineDelim();
            int startLineIndex = ps.getStartLineIndex();
            int endLineIndex = ps.getEndLineIndex();
            boolean classBehaviour = false;
            if (startLineIndex == endLineIndex && this.getUseClassNameBehaviour() && ps.isInClassLine()) {
                classBehaviour = true;
            }
            boolean functionBehaviour = false;
            if (startLineIndex == endLineIndex && this.getUseFunctionNameBehaviour() && ps.isInFunctionLine(false)) {
                functionBehaviour = true;
            }
            if (classBehaviour || functionBehaviour) {
                int tokLen;
                int classIndex;
                String line = ps.getLine(startLineIndex);
                if (classBehaviour) {
                    classIndex = line.indexOf("class ");
                    tokLen = 6;
                } else {
                    classIndex = line.indexOf("def ");
                    tokLen = 4;
                }
                String fullCommentLine = this.getFullCommentLine(classIndex, tempBuffer);
                String spacesBefore = classIndex > 0 ? line.substring(0, classIndex) : "";
                strbuf.append(String.valueOf(spacesBefore) + "#").append(fullCommentLine).append(endLineDelim);
                String initialLine = line;
                line = line.substring(classIndex + tokLen);
                FastStringBuffer className = new FastStringBuffer();
                int i = 0;
                while (i < line.length()) {
                    char cN = line.charAt(i);
                    if (!Character.isJavaIdentifierPart(cN)) break;
                    className.append(cN);
                    ++i;
                }
                strbuf.append(spacesBefore);
                strbuf.append("# ");
                strbuf.append(className);
                strbuf.append(endLineDelim);
                strbuf.append(spacesBefore);
                strbuf.append("#").append(fullCommentLine);
                strbuf.append(endLineDelim);
                strbuf.append(initialLine);
            } else {
                PyFormatStd.FormatStd std;
                ArrayList<String> lines = new ArrayList<String>();
                int minCharsBefore = Integer.MAX_VALUE;
                int i = startLineIndex;
                while (i <= endLineIndex) {
                    String line = ps.getLine(i);
                    minCharsBefore = Math.min(minCharsBefore, PySelection.getFirstCharPosition((String)line));
                    lines.add(line);
                    ++i;
                }
                String firstLine = (String)lines.get(0);
                String lastLine = (String)lines.get(lines.size() - 1);
                String strBefore = firstLine.substring(0, minCharsBefore);
                String fullCommentLine = this.getFullCommentLine(this.getLenOfStrConsideringTabEditorLen(strBefore), tempBuffer.clear());
                strbuf.append(strBefore).append("#").append(fullCommentLine).append(endLineDelim);
                String spacesInStartComment = null;
                PyFormatStd.FormatStd formatStd = std = this.std != null ? this.std : PyFormatStd.getFormat(this.getPyEdit());
                if (std.spacesInStartComment != 0) {
                    spacesInStartComment = std.spacesInStartComment < 0 ? StringUtils.createSpaceString((int)1) : StringUtils.createSpaceString((int)std.spacesInStartComment);
                }
                int i2 = startLineIndex;
                while (i2 <= endLineIndex) {
                    String line = ps.getLine(i2);
                    strbuf.append(line.substring(0, minCharsBefore));
                    strbuf.append("#");
                    line = line.substring(minCharsBefore);
                    strbuf.append(spacesInStartComment);
                    strbuf.append(line);
                    strbuf.append(endLineDelim);
                    ++i2;
                }
                String strAfter = firstLine.substring(0, minCharsBefore);
                fullCommentLine = this.getFullCommentLine(this.getLenOfStrConsideringTabEditorLen(strAfter), tempBuffer.clear());
                strbuf.append(lastLine.substring(0, minCharsBefore)).append("#").append(fullCommentLine);
            }
            int startOffset = ps.getStartLine().getOffset();
            String str = strbuf.toString();
            ps.getDoc().replace(startOffset, ps.getSelLength(), str);
            return new Tuple((Object)(startOffset + str.length()), (Object)0);
        }
        catch (Exception e) {
            e.printStackTrace();
            PyAddBlockComment.beep(e);
            return null;
        }
    }

    @Override
    protected String getPreferencesNameForChar() {
        return "MULTI_BLOCK_COMMENT_CHAR";
    }

    protected String getFullCommentLine(int subtract, FastStringBuffer buffer) {
        Tuple<Integer, Character> colsAndChar = this.getColsAndChar();
        int cols = (Integer)colsAndChar.o1 - subtract;
        char c = ((Character)colsAndChar.o2).charValue();
        buffer.clear();
        int i = 0;
        while (i < cols - 1) {
            buffer.append(c);
            ++i;
        }
        return buffer.toString();
    }
}

