/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.editor.DialogNotifier;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_ui.utils.RunInUiThread;

public class PydevShowBrowserMessage {
    public static final String PYDEV_FUNDING_SHOW_AT_TIME = "PYDEV_FUNDING_SHOW_AT_TIME";
    private static boolean shownInSession = false;
    public static final long ONE_DAY_IN_MILLIS = 86400000L;

    public static void show() {
        boolean show;
        if (shownInSession) {
            return;
        }
        shownInSession = true;
        if (SharedCorePlugin.inTestMode()) {
            return;
        }
        String hide = System.getProperty("pydev.funding.hide");
        if (hide != null && (hide.equals("1") || hide.equals("true"))) {
            return;
        }
        IPreferenceStore preferenceStore = PydevPrefs.getPreferenceStore();
        long showAtTime = preferenceStore.getLong(PYDEV_FUNDING_SHOW_AT_TIME);
        if (showAtTime == 0L) {
            preferenceStore.setValue(PYDEV_FUNDING_SHOW_AT_TIME, System.currentTimeMillis() + 259200000L);
            show = false;
        } else {
            show = System.currentTimeMillis() >= showAtTime;
        }
        if (show) {
            boolean runNowIfInUiThread = false;
            RunInUiThread.async((Runnable)new Runnable(){

                @Override
                public void run() {
                    Display disp = Display.getCurrent();
                    Shell shell = disp.getActiveShell();
                    if (shell == null) {
                        shell = new Shell(disp);
                    }
                    DialogNotifier notifier = new DialogNotifier(shell);
                    notifier.open();
                }
            }, (boolean)runNowIfInUiThread);
        }
    }
}

