/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.builder.PyDevBuilderPrefPage;
import org.python.pydev.builder.PyDevBuilderVisitor;
import org.python.pydev.builder.PyDevDeltaCounter;
import org.python.pydev.builder.PydevGrouperVisitor;
import org.python.pydev.builder.VisitorMemo;
import org.python.pydev.builder.pycremover.PycHandlerBuilderVisitor;
import org.python.pydev.builder.pylint.PyLintVisitor;
import org.python.pydev.builder.syntaxchecker.PySyntaxChecker;
import org.python.pydev.builder.todo.PyTodoVisitor;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.FileUtilsFileBuffer;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.PyCodeCompletionVisitor;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.utils.PyFileListing;

public class PyDevBuilder
extends IncrementalProjectBuilder {
    private static final boolean DEBUG = false;

    public List<PyDevBuilderVisitor> getVisitors() {
        ArrayList<PyDevBuilderVisitor> list = new ArrayList<PyDevBuilderVisitor>();
        list.add(new PyTodoVisitor());
        list.add(new PyLintVisitor());
        list.add(new PyCodeCompletionVisitor());
        list.add(new PycHandlerBuilderVisitor());
        list.add(new PySyntaxChecker());
        list.addAll(ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_builder"));
        return list;
    }

    public ISchedulingRule getRule() {
        return null;
    }

    public ISchedulingRule getRule(int kind, Map<String, String> args) {
        return null;
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        if (!PyDevBuilderPrefPage.usePydevBuilders()) {
            return null;
        }
        if (kind == 6 || kind == 15) {
            this.performFullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.performFullBuild(monitor);
            } else {
                VisitorMemo memo = new VisitorMemo();
                memo.put("IS_FULL_BUILD", false);
                PyDevDeltaCounter counterVisitor = new PyDevDeltaCounter();
                counterVisitor.memo = memo;
                delta.accept((IResourceDeltaVisitor)counterVisitor);
                List<PyDevBuilderVisitor> visitors = this.getVisitors();
                Collections.sort(visitors);
                PydevGrouperVisitor grouperVisitor = new PydevGrouperVisitor(visitors, monitor, counterVisitor.getNVisited());
                grouperVisitor.memo = memo;
                try {
                    Throwable throwable = null;
                    Object var10_12 = null;
                    try (AutoCloseable closeable = this.withStartEndVisitingNotifications(visitors, monitor, false, null);){
                        try {
                            delta.accept((IResourceDeltaVisitor)grouperVisitor);
                        }
                        catch (Exception e) {
                            Log.log((Throwable)e);
                        }
                        try {
                            grouperVisitor.finishDelayedVisits();
                        }
                        catch (Exception e) {
                            Log.log((Throwable)e);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e1) {
                    Log.log((Throwable)e1);
                }
            }
        }
        return null;
    }

    private void performFullBuild(IProgressMonitor monitor) throws CoreException {
        block23: {
            PythonNature nature;
            IProject project = this.getProject();
            if (project != null && (nature = PythonNature.getPythonNature(project)) != null && nature.startRequests()) {
                nature.updateMtime();
                try {
                    IPythonPathNature pythonPathNature = nature.getPythonPathNature();
                    pythonPathNature.getProjectSourcePath(false);
                    ArrayList<IFile> resourcesToParse = new ArrayList<IFile>();
                    List<PyDevBuilderVisitor> visitors = this.getVisitors();
                    try {
                        Throwable throwable = null;
                        Object var8_10 = null;
                        try (AutoCloseable closable = this.withStartEndVisitingNotifications(visitors, monitor, true, nature);){
                            monitor.beginTask("Building...", visitors.size() * 100 + 30);
                            IResource[] members = project.members();
                            if (members == null) break block23;
                            int len = members.length;
                            int i = 0;
                            while (i < len) {
                                try {
                                    IResource member = members[i];
                                    if (member != null) {
                                        if (member.getType() == 1) {
                                            this.addToResourcesToParse(resourcesToParse, (IFile)member, nature);
                                        } else if (member.getType() == 2) {
                                            List<IFile> files = PyFileListing.getAllIFilesBelow((IContainer)((IFolder)member));
                                            for (IFile file : files) {
                                                if (file == null) continue;
                                                this.addToResourcesToParse(resourcesToParse, file, nature);
                                            }
                                        }
                                    }
                                }
                                catch (Exception exception) {}
                                ++i;
                            }
                            monitor.worked(30);
                            this.buildResources(resourcesToParse, monitor, visitors);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e1) {
                        Log.log((Throwable)e1);
                    }
                }
                finally {
                    nature.endRequests();
                }
            }
        }
        monitor.done();
    }

    private AutoCloseable withStartEndVisitingNotifications(final List<PyDevBuilderVisitor> visitors, final IProgressMonitor monitor, boolean isFullBuild, IPythonNature nature) {
        for (PyDevBuilderVisitor visitor : visitors) {
            try {
                visitor.visitingWillStart(monitor, isFullBuild, nature);
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
        }
        return new AutoCloseable(){

            @Override
            public void close() throws Exception {
                for (PyDevBuilderVisitor visitor : visitors) {
                    try {
                        visitor.visitingEnded(monitor);
                    }
                    catch (Throwable e) {
                        Log.log((Throwable)e);
                    }
                }
            }
        };
    }

    private void addToResourcesToParse(List<IFile> resourcesToParse, IFile member, IPythonNature nature) {
        String fileExtension = member.getFileExtension();
        if (fileExtension != null && PythonPathHelper.isValidSourceFile("." + fileExtension)) {
            resourcesToParse.add(member);
        }
    }

    public void buildResources(List<IFile> resourcesToParse, IProgressMonitor monitor, List<PyDevBuilderVisitor> visitors) {
        double inc = (double)(visitors.size() * 100) / (double)resourcesToParse.size();
        double total = 0.0;
        int totalResources = resourcesToParse.size();
        int i = 0;
        FastStringBuffer bufferToCreateString = new FastStringBuffer();
        boolean loggedMisconfiguration = false;
        long lastProgressTime = 0L;
        Object memoSharedProjectState = null;
        Iterator<IFile> iter = resourcesToParse.iterator();
        while (iter.hasNext() && !monitor.isCanceled()) {
            String moduleName;
            ++i;
            total += inc;
            IFile r = iter.next();
            PythonPathHelper.markAsPyDevFileIfDetected(r);
            PythonNature nature = PythonNature.getPythonNature((IResource)r);
            if (nature == null || !nature.startRequests()) continue;
            try {
                moduleName = nature.resolveModuleOnlyInProjectSources((IResource)r, true);
                if (moduleName == null) {
                    continue;
                }
            }
            catch (Exception e1) {
                if (loggedMisconfiguration) continue;
                loggedMisconfiguration = true;
                Log.log((Throwable)e1);
                continue;
            }
            {
                VisitorMemo memo = new VisitorMemo();
                memo.setSharedProjectState(memoSharedProjectState);
                memo.put("IS_FULL_BUILD", true);
                ICallback0 doc = FileUtilsFileBuffer.getDocOnCallbackFromResource((IResource)r);
                memo.put("DOCUMENT_TIME", System.currentTimeMillis());
                PyDevBuilderVisitor.setModuleNameInCache(memo, (IResource)r, moduleName);
                Iterator<PyDevBuilderVisitor> it = visitors.iterator();
                while (it.hasNext() && !monitor.isCanceled()) {
                    try {
                        PyDevBuilderVisitor visitor = it.next();
                        visitor.memo = memo;
                        long currentTimeMillis = System.currentTimeMillis();
                        if (currentTimeMillis - lastProgressTime > 300L) {
                            PyDevBuilder.communicateProgress(monitor, totalResources, i, (IResource)r, visitor, bufferToCreateString);
                            lastProgressTime = currentTimeMillis;
                        }
                        visitor.visitAddedResource((IResource)r, (ICallback0<IDocument>)doc, monitor);
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
                if (total > 1.0) {
                    monitor.worked((int)total);
                    total -= (double)((int)total);
                }
                memoSharedProjectState = memo.getSharedProjectState();
                continue;
            }
            finally {
                nature.endRequests();
            }
        }
    }

    public static void communicateProgress(IProgressMonitor monitor, int totalResources, int i, IResource r, PyDevBuilderVisitor visitor, FastStringBuffer bufferToCreateString) {
        if (monitor != null) {
            bufferToCreateString.clear();
            bufferToCreateString.append("PyDev: Analyzing ");
            bufferToCreateString.append(i);
            bufferToCreateString.append(" of ");
            bufferToCreateString.append(totalResources);
            bufferToCreateString.append(" (");
            bufferToCreateString.append(r.getName());
            bufferToCreateString.append(")");
            String name = bufferToCreateString.toString();
            monitor.subTask(name);
        }
    }
}

