/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.utils.ArrayUtils;

public class PyMarkerUtils {
    public static void replaceMarkers(List<MarkerInfo> lst, IResource resource, String markerType, boolean removeUserEditable, IProgressMonitor monitor) {
        ArrayList<HashMap> lMap = new ArrayList<HashMap>(lst.size());
        for (MarkerInfo markerInfo : lst) {
            try {
                HashMap asMap = markerInfo.getAsMap();
                if (asMap == null) continue;
                lMap.add(asMap);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        PyMarkerUtils.replaceMarkers(lMap.toArray(new Map[lMap.size()]), resource, markerType, removeUserEditable, monitor);
    }

    public static void replaceMarkers(final Map<String, Object>[] lst, final IResource resource, final String markerType, final boolean removeUserEditable, IProgressMonitor monitor) {
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (!resource.exists()) {
                    return;
                }
                try {
                    if (removeUserEditable) {
                        resource.deleteMarkers(markerType, true, 0);
                    } else {
                        Object[] existingMarkers = resource.findMarkers(markerType, false, 0);
                        existingMarkers = ArrayUtils.filter((Object[])existingMarkers, (ICallback)new ICallback<Boolean, IMarker>(){

                            public Boolean call(IMarker marker) {
                                return !marker.getAttribute("userEditable", true);
                            }
                        }).toArray(new IMarker[0]);
                        ResourcesPlugin.getWorkspace().deleteMarkers((IMarker[])existingMarkers);
                    }
                }
                catch (Exception e1) {
                    Log.log((Throwable)e1);
                }
                try {
                    Map[] mapArray = lst;
                    int n = lst.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Map asMap = mapArray[n2];
                        IMarker marker = resource.createMarker(markerType);
                        marker.setAttributes(asMap);
                        ++n2;
                    }
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
        };
        try {
            resource.getWorkspace().run(r, ResourcesPlugin.getWorkspace().getRuleFactory().markerRule(resource), 1, monitor);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public static void removeMarkers(IResource resource, String markerType) {
        if (resource == null) {
            return;
        }
        try {
            resource.deleteMarkers(markerType, false, 0);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public static Position getMarkerPosition(IDocument document, IMarker marker, IAnnotationModel model) {
        int line;
        int end;
        Position ret;
        if (model instanceof AbstractMarkerAnnotationModel && (ret = ((AbstractMarkerAnnotationModel)model).getMarkerPosition(marker)) != null) {
            return ret;
        }
        int start = MarkerUtilities.getCharStart((IMarker)marker);
        if (start > (end = MarkerUtilities.getCharEnd((IMarker)marker))) {
            end = start + end;
            start = end - start;
            end -= start;
        }
        if (start == -1 && end == -1 && (line = MarkerUtilities.getLineNumber((IMarker)marker)) > 0 && document != null) {
            try {
                end = start = document.getLineOffset(line - 1);
            }
            catch (BadLocationException badLocationException) {}
        }
        if (start > -1 && end > -1) {
            return new Position(start, end - start);
        }
        return null;
    }

    public static IResource getResourceForTextEditor(ITextEditor textEditor) {
        IEditorInput input = textEditor.getEditorInput();
        IResource resource = (IResource)input.getAdapter(IFile.class);
        if (resource == null) {
            resource = (IResource)input.getAdapter(IResource.class);
        }
        if (resource == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return resource;
    }

    public static class MarkerInfo {
        public IDocument doc;
        public String message;
        public String markerType;
        public int severity;
        public boolean userEditable;
        public boolean isTransient;
        public int lineStart;
        public int colStart;
        public int lineEnd;
        public int absoluteStart = -1;
        public int absoluteEnd = -1;
        public int colEnd;
        public Map<String, Object> additionalInfo;

        public MarkerInfo(IDocument doc, String message, String markerType, int severity, boolean userEditable, boolean isTransient, int lineStart, int colStart, int lineEnd, int colEnd, Map<String, Object> additionalInfo) {
            this.doc = doc;
            this.message = message;
            this.markerType = markerType;
            this.severity = severity;
            this.userEditable = userEditable;
            this.isTransient = isTransient;
            this.lineStart = lineStart;
            this.colStart = colStart;
            this.lineEnd = lineEnd;
            this.colEnd = colEnd;
            this.additionalInfo = additionalInfo;
        }

        public MarkerInfo(IDocument doc, String message, String markerType, int severity, boolean userEditable, boolean isTransient, int line, int absoluteStart, int absoluteEnd, Map<String, Object> additionalInfo) {
            this.doc = doc;
            this.message = message;
            this.markerType = markerType;
            this.severity = severity;
            this.userEditable = userEditable;
            this.isTransient = isTransient;
            this.lineStart = line;
            this.lineEnd = line;
            this.absoluteStart = absoluteStart;
            this.absoluteEnd = absoluteEnd;
            this.additionalInfo = additionalInfo;
        }

        private HashMap<String, Object> getAsMap() {
            if (this.lineStart < 0) {
                this.lineStart = 0;
            }
            if (this.absoluteStart == -1 || this.absoluteEnd == -1) {
                IRegion start;
                try {
                    start = this.doc.getLineInformation(this.lineStart);
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
                catch (Exception e) {
                    Log.log((int)4, (String)("Could not get line: " + this.lineStart + " to add message: " + this.message), (Throwable)e);
                    return null;
                }
                try {
                    this.absoluteStart = start.getOffset() + this.colStart;
                    if (this.lineEnd >= 0 && this.colEnd >= 0) {
                        IRegion end = this.doc.getLineInformation(this.lineEnd);
                        this.absoluteEnd = end.getOffset() + this.colEnd;
                    } else {
                        String line = this.doc.get(start.getOffset(), start.getLength());
                        int i = line.indexOf(35);
                        FastStringBuffer buffer = i != -1 ? new FastStringBuffer(line.substring(0, i), 0) : new FastStringBuffer(line, 0);
                        while (buffer.length() > 0 && Character.isWhitespace(buffer.lastChar())) {
                            buffer.deleteLast();
                        }
                        this.absoluteEnd = start.getOffset() + buffer.length();
                    }
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
                catch (Exception e) {
                    Log.log((int)1, (String)("Problem creating map for:" + this.toString()), (Throwable)e);
                    return null;
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("message", this.message);
            map.put("lineNumber", this.lineStart);
            map.put("charStart", this.absoluteStart);
            map.put("charEnd", this.absoluteEnd);
            map.put("severity", this.severity);
            map.put("userEditable", this.userEditable);
            map.put("transient", this.isTransient);
            if (this.additionalInfo != null) {
                map.putAll(this.additionalInfo);
            }
            return map;
        }

        public String toString() {
            StringBuffer retValue = new StringBuffer();
            retValue.append("MarkerInfo (\n").append("doc = ").append(this.doc).append("\n").append("message = ").append(this.message).append("\n").append("markerType = ").append(this.markerType).append("\n").append("severity = ").append(this.severity).append("\n").append("userEditable = ").append(this.userEditable).append("\n").append("isTransient = ").append(this.isTransient).append("\n").append("lineStart = ").append(this.lineStart).append("\n").append("colStart = ").append(this.colStart).append("\n").append("lineEnd = ").append(this.lineEnd).append("\n").append("absoluteStart = ").append(this.absoluteStart).append("\n").append("absoluteEnd = ").append(this.absoluteEnd).append("\n").append("colEnd = ").append(this.colEnd).append("\n").append("additionalInfo = ").append(this.additionalInfo).append("\n").append(")");
            return retValue.toString();
        }
    }
}

