/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.utils;

import org.eclipse.swt.graphics.RGB;
import org.python.pydev.shared_core.log.Log;

public final class ColorParse {
    public static RGB parseRGB(String value, RGB defaultColor) {
        try {
            if (value != null) {
                if (value.startsWith("#") && value.length() >= 7) {
                    int r = Integer.parseInt(value.substring(1, 3), 16);
                    int g = Integer.parseInt(value.substring(3, 5), 16);
                    int b = Integer.parseInt(value.substring(5, 7), 16);
                    if (r < 0) {
                        r = 0;
                    }
                    if (g < 0) {
                        g = 0;
                    }
                    if (b < 0) {
                        b = 0;
                    }
                    if (r > 255) {
                        r = 255;
                    }
                    if (g > 255) {
                        g = 255;
                    }
                    if (b > 255) {
                        b = 255;
                    }
                    return new RGB(r, g, b);
                }
                String[] s = value.split("\\,");
                if (s.length >= 3) {
                    int r = Integer.parseInt(s[0]);
                    int g = Integer.parseInt(s[1]);
                    int b = Integer.parseInt(s[2]);
                    return new RGB(r, g, b);
                }
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return defaultColor;
    }
}

