/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.tooltips.presenter;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenKeeperExtension;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.text.IWidgetTokenOwnerExtension;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_ui.bindings.KeyBindingHelper;
import org.python.pydev.shared_ui.tooltips.presenter.IInformationPresenterAsTooltip;
import org.python.pydev.shared_ui.tooltips.presenter.IInformationPresenterControlManager;
import org.python.pydev.shared_ui.tooltips.presenter.ITooltipInformationProvider;
import org.python.pydev.shared_ui.tooltips.presenter.InformationPresenterHelpers;

public final class InformationPresenterControlManager
extends AbstractInformationControlManager
implements IWidgetTokenKeeper,
IWidgetTokenKeeperExtension,
IInformationPresenterControlManager {
    private final String tooltipAffordanceString;
    public static final int WIDGET_PRIORITY = 5;
    private Control fControl;
    private ITooltipInformationProvider fProvider;
    private KeySequence fActivateEditorBinding;
    private Shell fInitiallyActiveShell;
    private Control fFocusControl;
    private boolean onHide;

    public InformationPresenterControlManager(DefaultInformationControl.IInformationPresenter presenter, String tooltipAffordanceString) {
        super((IInformationControlCreator)new InformationPresenterHelpers.TooltipInformationControlCreator(presenter));
        this.tooltipAffordanceString = tooltipAffordanceString;
        if (presenter instanceof IInformationPresenterAsTooltip) {
            IInformationPresenterAsTooltip presenterAsTooltip = (IInformationPresenterAsTooltip)presenter;
            presenterAsTooltip.setInformationPresenterControlManager(this);
        }
        this.setCloser(new Closer());
        this.takesFocusWhenVisible(true);
        ((InformationPresenterHelpers.TooltipInformationControlCreator)this.fInformationControlCreator).setInformationPresenterControlManager(this);
    }

    @Override
    public void setInformationProvider(ITooltipInformationProvider provider) {
        this.fProvider = provider;
    }

    public ITooltipInformationProvider getInformationProvider() {
        return this.fProvider;
    }

    protected void computeInformation() {
        if (this.fProvider == null) {
            return;
        }
        Object info = this.fProvider.getInformation(this.fControl);
        Point point = this.fProvider.getPosition(this.fControl);
        this.setInformation(info, new Rectangle(point.x, point.y, 0, 0));
    }

    public void uninstall() {
        this.dispose();
    }

    protected void showInformationControl(Rectangle subjectArea) {
        if (this.fControl instanceof IWidgetTokenOwnerExtension && this.fControl instanceof IWidgetTokenOwner) {
            IWidgetTokenOwnerExtension extension = (IWidgetTokenOwnerExtension)this.fControl;
            if (extension.requestWidgetToken((IWidgetTokenKeeper)this, 5)) {
                super.showInformationControl(subjectArea);
            }
        } else if (this.fControl instanceof IWidgetTokenOwner) {
            IWidgetTokenOwner owner = (IWidgetTokenOwner)this.fControl;
            if (owner.requestWidgetToken((IWidgetTokenKeeper)this)) {
                super.showInformationControl(subjectArea);
            }
        } else {
            super.showInformationControl(subjectArea);
        }
    }

    public void hideInformationControl() {
        this.hideInformationControl(false, true);
    }

    @Override
    public void hideInformationControl(boolean activateEditor, boolean restoreFocus) {
        if (this.onHide) {
            return;
        }
        this.onHide = true;
        try {
            try {
                super.hideInformationControl();
            }
            finally {
                if (this.fControl instanceof IWidgetTokenOwner) {
                    IWidgetTokenOwner owner = (IWidgetTokenOwner)this.fControl;
                    owner.releaseWidgetToken((IWidgetTokenKeeper)this);
                }
            }
            this.disposeInformationControl();
            if (this.fInitiallyActiveShell != null && !this.fInitiallyActiveShell.isDisposed()) {
                if (restoreFocus) {
                    this.fInitiallyActiveShell.setActive();
                }
                this.fInitiallyActiveShell = null;
            }
            if (this.fFocusControl != null && !this.fFocusControl.isDisposed()) {
                if (restoreFocus) {
                    this.fFocusControl.setFocus();
                }
                this.fFocusControl = null;
            }
            if (activateEditor) {
                KeyBindingHelper.executeCommand("org.eclipse.ui.window.activateEditor");
            }
        }
        finally {
            this.onHide = false;
        }
    }

    protected void handleInformationControlDisposed() {
        try {
            super.handleInformationControlDisposed();
        }
        finally {
            if (this.fControl instanceof IWidgetTokenOwner) {
                IWidgetTokenOwner owner = (IWidgetTokenOwner)this.fControl;
                owner.releaseWidgetToken((IWidgetTokenKeeper)this);
            }
        }
    }

    public boolean requestWidgetToken(IWidgetTokenOwner owner) {
        return false;
    }

    public boolean requestWidgetToken(IWidgetTokenOwner owner, int priority) {
        return false;
    }

    public boolean setFocus(IWidgetTokenOwner owner) {
        return false;
    }

    @Override
    public void setActivateEditorBinding(KeySequence activateEditorBinding) {
        this.fActivateEditorBinding = activateEditorBinding;
    }

    @Override
    public void setInitiallyActiveShell(Shell activeShell) {
        Display display;
        this.fInitiallyActiveShell = activeShell;
        this.fFocusControl = null;
        if (activeShell != null && (display = activeShell.getDisplay()) != null) {
            this.fFocusControl = display.getFocusControl();
        }
    }

    public String getTooltipAffordanceString() {
        if (this.tooltipAffordanceString != null) {
            return this.tooltipAffordanceString;
        }
        String defaultStr = "ESC to close, ENTER activate link.";
        if (this.fActivateEditorBinding != null) {
            return StringUtils.format((String)"%s to activate editor, %s", (Object[])new Object[]{this.fActivateEditorBinding.toString(), defaultStr});
        }
        return defaultStr;
    }

    class Closer
    implements AbstractInformationControlManager.IInformationControlCloser,
    ControlListener,
    MouseListener,
    FocusListener,
    KeyListener,
    MouseMoveListener,
    Listener {
        private Control fSubjectControl;
        private InformationPresenterHelpers.PyInformationControl fInformationControlToClose;
        private boolean fIsActive = false;
        private Rectangle fShellTooltipArea;
        private Display fDisplay;

        Closer() {
        }

        public void setSubjectControl(Control control) {
            this.fSubjectControl = control;
        }

        public void setInformationControl(IInformationControl control) {
            Assert.isTrue((control == null || control instanceof InformationPresenterHelpers.PyInformationControl ? 1 : 0) != 0);
            this.fInformationControlToClose = (InformationPresenterHelpers.PyInformationControl)control;
        }

        public void start(Rectangle informationArea) {
            this.fShellTooltipArea = this.fInformationControlToClose.getShellTooltipBounds();
            if (this.fIsActive) {
                return;
            }
            this.fIsActive = true;
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.addControlListener((ControlListener)this);
                this.fSubjectControl.addMouseListener((MouseListener)this);
                this.fSubjectControl.addMouseMoveListener((MouseMoveListener)this);
                this.fSubjectControl.addFocusListener((FocusListener)this);
                this.fSubjectControl.addKeyListener((KeyListener)this);
                this.fDisplay = this.fSubjectControl.getDisplay();
                if (!this.fDisplay.isDisposed()) {
                    this.fDisplay.addFilter(26, (Listener)this);
                    this.fDisplay.addFilter(37, (Listener)this);
                    this.fDisplay.addFilter(16, (Listener)this);
                    this.fDisplay.addFilter(3, (Listener)this);
                    this.fDisplay.addFilter(4, (Listener)this);
                    this.fDisplay.addFilter(5, (Listener)this);
                    this.fDisplay.addFilter(6, (Listener)this);
                    this.fDisplay.addFilter(7, (Listener)this);
                    this.fDisplay.addFilter(1, (Listener)this);
                }
            }
            if (this.fInformationControlToClose != null) {
                this.fInformationControlToClose.addFocusListener(this);
            }
        }

        public void stop() {
            if (!this.fIsActive) {
                return;
            }
            this.fIsActive = false;
            if (this.fInformationControlToClose != null) {
                this.fInformationControlToClose.removeFocusListener(this);
            }
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.removeControlListener((ControlListener)this);
                this.fSubjectControl.removeMouseMoveListener((MouseMoveListener)this);
                this.fSubjectControl.removeMouseListener((MouseListener)this);
                this.fSubjectControl.removeFocusListener((FocusListener)this);
                this.fSubjectControl.removeKeyListener((KeyListener)this);
            }
            if (this.fDisplay != null && !this.fDisplay.isDisposed()) {
                this.fDisplay.removeFilter(26, (Listener)this);
                this.fDisplay.removeFilter(37, (Listener)this);
                this.fDisplay.removeFilter(16, (Listener)this);
                this.fDisplay.removeFilter(3, (Listener)this);
                this.fDisplay.removeFilter(4, (Listener)this);
                this.fDisplay.removeFilter(5, (Listener)this);
                this.fDisplay.removeFilter(6, (Listener)this);
                this.fDisplay.removeFilter(7, (Listener)this);
                this.fDisplay.removeFilter(1, (Listener)this);
            }
            this.fDisplay = null;
        }

        public void controlResized(ControlEvent e) {
            InformationPresenterControlManager.this.hideInformationControl();
        }

        public void controlMoved(ControlEvent e) {
            InformationPresenterControlManager.this.hideInformationControl();
        }

        public void mouseDown(MouseEvent e) {
            InformationPresenterControlManager.this.hideInformationControl();
        }

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
            InformationPresenterControlManager.this.hideInformationControl();
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            Display d = this.fSubjectControl.getDisplay();
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (Closer.this.fInformationControlToClose == null || !Closer.this.fInformationControlToClose.isFocusControl()) {
                        InformationPresenterControlManager.this.hideInformationControl();
                    }
                }
            });
        }

        public void keyPressed(KeyEvent e) {
            InformationPresenterControlManager.this.hideInformationControl();
        }

        public void keyReleased(KeyEvent e) {
        }

        public void mouseMove(MouseEvent e) {
            if (InformationPresenterControlManager.this.fInformationControl != null && InformationPresenterControlManager.this.fInformationControl.isFocusControl() && !this.inKeepUpZone(e.x, e.y, this.fSubjectControl, this.fSubjectControl.getDisplay())) {
                InformationPresenterControlManager.this.hideInformationControl();
            }
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 3: 
                case 4: 
                case 16: 
                case 26: 
                case 37: {
                    IInformationControl iControl = InformationPresenterControlManager.this.fInformationControl;
                    if (iControl == null || iControl.isFocusControl()) break;
                    InformationPresenterControlManager.this.hideInformationControl();
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    this.handleMouseMove(event);
                    break;
                }
                case 1: {
                    if (event.keyCode == 27) {
                        InformationPresenterControlManager.this.hideInformationControl();
                        break;
                    }
                    if (InformationPresenterControlManager.this.fActivateEditorBinding == null || !KeyBindingHelper.matchesKeybinding(event.keyCode, event.stateMask, InformationPresenterControlManager.this.fActivateEditorBinding)) break;
                    InformationPresenterControlManager.this.hideInformationControl(true, true);
                }
            }
        }

        private void handleMouseMove(Event event) {
            if (!(event.widget instanceof Control)) {
                return;
            }
            Control control = (Control)event.widget;
            Display display = control.getDisplay();
            if (!this.inKeepUpZone(event.x, event.y, control, display)) {
                InformationPresenterControlManager.this.hideInformationControl();
            }
        }

        private boolean inKeepUpZone(int x, int y, Control control, Display display) {
            if (display.isDisposed()) {
                return true;
            }
            Point point = display.map(control, null, x, y);
            int margin = 20;
            Rectangle bounds = Geometry.copy((Rectangle)this.fShellTooltipArea);
            Geometry.expand((Rectangle)bounds, (int)margin, (int)margin, (int)margin, (int)margin);
            return bounds.contains(point.x, point.y);
        }
    }
}

