/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.search;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_ui.search.AbstractSearchIndexQuery;

public abstract class SearchIndexResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private AbstractSearchIndexQuery query;
    private final Match[] EMPTY_ARR = new Match[0];
    private static final Set<Class<?>> warned = new HashSet();

    public SearchIndexResult(AbstractSearchIndexQuery searchIndexQuery) {
        this.query = searchIndexQuery;
    }

    public String getLabel() {
        return this.query.getResultLabel(this.getMatchCount());
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        return SearchPluginImages.DESC_OBJ_TSEARCH_DPDN;
    }

    public ISearchQuery getQuery() {
        return this.query;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        return this.getMatches(file);
    }

    public IFile getFile(Object element) {
        if (element instanceof IFile) {
            return (IFile)element;
        }
        if (element != null) {
            Class<?> class1 = element.getClass();
            warned.add(class1);
            Log.log((String)("Unable to get file from: " + element + " - " + class1));
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        IEditorInput ei = editor.getEditorInput();
        if (ei instanceof IFileEditorInput) {
            IFileEditorInput fi = (IFileEditorInput)ei;
            return match.getElement().equals(fi.getFile());
        }
        return false;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput ei = editor.getEditorInput();
        if (ei instanceof IFileEditorInput) {
            IFileEditorInput fi = (IFileEditorInput)ei;
            return this.getMatches(fi.getFile());
        }
        return this.EMPTY_ARR;
    }
}

