/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_ui.search.StringMatcherWithIndexSemantics;

public abstract class AbstractSearchResultsViewerFilter
extends ViewerFilter {
    protected final IMatcher stringMatcher;
    private static Object[] EMPTY = new Object[0];
    private Map<Object, Boolean> foundAnyCache = new HashMap<Object, Boolean>();
    private Map<Object, Object[]> cache = new HashMap<Object, Object[]>();

    public AbstractSearchResultsViewerFilter(String text, boolean wholeWord) {
        this.stringMatcher = AbstractSearchResultsViewerFilter.createMatcher(text, wholeWord);
    }

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        Object[] filtered = this.cache.get(parent);
        if (filtered == null) {
            Boolean foundAny = this.foundAnyCache.get(parent);
            filtered = foundAny != null && foundAny == false ? EMPTY : super.filter(viewer, parent, elements);
            this.cache.put(parent, filtered);
        }
        return filtered;
    }

    public final boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.isElementVisible(viewer, element);
    }

    private boolean computeAnyVisible(Viewer viewer, Object[] elements) {
        boolean elementFound = false;
        int i = 0;
        while (i < elements.length && !elementFound) {
            Object element = elements[i];
            elementFound = this.isElementVisible(viewer, element);
            ++i;
        }
        return elementFound;
    }

    private boolean isAnyVisible(Viewer viewer, Object parent, Object[] elements) {
        Object[] filtered = this.cache.get(parent);
        if (filtered != null) {
            return filtered.length > 0;
        }
        Boolean foundAny = this.foundAnyCache.get(parent);
        if (foundAny == null) {
            foundAny = this.computeAnyVisible(viewer, elements) ? Boolean.TRUE : Boolean.FALSE;
            this.foundAnyCache.put(parent, foundAny);
        }
        return foundAny;
    }

    public boolean isElementSelectable(Object element) {
        return element != null;
    }

    public boolean isElementVisible(Viewer viewer, Object element) {
        return this.isParentMatch(viewer, element) || this.isLeafMatch(viewer, element);
    }

    protected boolean isParentMatch(Viewer viewer, Object element) {
        Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element);
        if (children != null && children.length > 0) {
            return this.isAnyVisible(viewer, element, children);
        }
        return false;
    }

    public abstract boolean isLeafMatch(Viewer var1, Object var2);

    public static IMatcher createMatcher(String text, boolean wholeWord) {
        List split = StringUtils.split((String)text, (char)',');
        ArrayList<StringMatcherWithIndexSemantics> includes = new ArrayList<StringMatcherWithIndexSemantics>(split.size());
        ArrayList<StringMatcherWithIndexSemantics> excludes = new ArrayList<StringMatcherWithIndexSemantics>(split.size());
        for (String string : split) {
            StringMatcherWithIndexSemantics matcher;
            if ((string = string.trim()).length() <= 0) continue;
            if (string.startsWith("!")) {
                matcher = new StringMatcherWithIndexSemantics(string.substring(1), true, wholeWord);
                excludes.add(matcher);
                continue;
            }
            matcher = new StringMatcherWithIndexSemantics(string, true, wholeWord);
            includes.add(matcher);
        }
        return new IncludeExcludeMatcher(includes.toArray(new StringMatcherWithIndexSemantics[0]), excludes.toArray(new StringMatcherWithIndexSemantics[0]));
    }

    public static boolean filterMatches(String text, IMatcher stringMatcher) {
        return stringMatcher.match(text);
    }

    public void clearCache() {
        this.cache.clear();
        this.foundAnyCache.clear();
    }

    public static interface IMatcher {
        public boolean match(String var1);
    }

    public static class IncludeExcludeMatcher
    implements IMatcher {
        private final int strategy;
        private final StringMatcherWithIndexSemantics[] includes;
        private final StringMatcherWithIndexSemantics[] excludes;
        private static final int ACCEPT_ALL = 0;
        private static final int ONLY_INCLUDES = 1;
        private static final int ONLY_EXCLUDES = 2;
        private static final int EXCLUDE_AND_INCLUDES = 3;

        public IncludeExcludeMatcher(StringMatcherWithIndexSemantics[] includes, StringMatcherWithIndexSemantics[] excludes) {
            this.includes = includes;
            this.excludes = excludes;
            this.strategy = includes.length == 0 && excludes.length == 0 ? 0 : (includes.length > 0 && excludes.length == 0 ? 1 : (includes.length == 0 && excludes.length > 0 ? 2 : 3));
        }

        @Override
        public boolean match(String text) {
            int includesLen = this.includes.length;
            int excludesLen = this.excludes.length;
            switch (this.strategy) {
                case 0: {
                    return true;
                }
                case 1: {
                    int i = 0;
                    while (i < includesLen) {
                        StringMatcherWithIndexSemantics s = this.includes[i];
                        if (s.match(text)) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
                case 2: {
                    int i = 0;
                    while (i < excludesLen) {
                        StringMatcherWithIndexSemantics s = this.excludes[i];
                        if (s.match(text)) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                case 3: {
                    int i = 0;
                    while (i < includesLen) {
                        StringMatcherWithIndexSemantics s = this.includes[i];
                        if (s.match(text)) {
                            i = 0;
                            while (i < excludesLen) {
                                s = this.excludes[i];
                                if (s.match(text)) {
                                    return false;
                                }
                                ++i;
                            }
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
            }
            throw new RuntimeException("Invalid strategy: " + this.strategy);
        }
    }
}

