/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.views.navigator.NavigatorDragAdapter;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.structure.TreeNode;
import org.python.pydev.shared_core.structure.TreeNodeContentProvider;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.dialogs.DialogHelpers;
import org.python.pydev.shared_ui.search.AbstractSearchIndexQuery;
import org.python.pydev.shared_ui.search.AbstractSearchResultsViewerFilter;
import org.python.pydev.shared_ui.search.DecoratingFileSearchLabelProvider;
import org.python.pydev.shared_ui.search.GroupByAction;
import org.python.pydev.shared_ui.search.ICustomLineElement;
import org.python.pydev.shared_ui.search.ICustomMatch;
import org.python.pydev.shared_ui.search.ICustomModule;
import org.python.pydev.shared_ui.search.ISearchIndexContentProvider;
import org.python.pydev.shared_ui.search.NewTextSearchActionGroup;
import org.python.pydev.shared_ui.search.SearchIndexLabelProvider;
import org.python.pydev.shared_ui.search.SearchMessages;
import org.python.pydev.shared_ui.search.replace.ReplaceAction;
import org.python.pydev.shared_ui.swt.StyledLink;

public abstract class AbstractSearchIndexResultPage
extends AbstractTextSearchViewPage {
    protected ISearchIndexContentProvider fContentProvider;
    protected Text filterText;
    protected WorkbenchJob refreshJob;
    protected GroupByAction[] fGroupByActions;
    protected ActionGroup fActionGroup;
    protected int groupWithConfiguration = 5;
    private static String STORE_GROUP_WITH = "group_with";
    protected static final String[] SHOW_IN_TARGETS = new String[]{"org.eclipse.ui.views.ResourceNavigator"};
    protected static final IShowInTargetList SHOW_IN_TARGET_LIST = new IShowInTargetList(){

        public String[] getShowInTargetIds() {
            return SHOW_IN_TARGETS;
        }
    };

    public AbstractSearchIndexResultPage() {
        super(2);
    }

    public int getGroupWithConfiguration() {
        return this.groupWithConfiguration;
    }

    public void setGroupWithConfiguration(int groupWithConfiguration) {
        this.groupWithConfiguration = groupWithConfiguration;
        this.updateGroupWith(this.getViewer());
    }

    public void restoreState(IMemento memento) {
        super.restoreState(memento);
        if (memento != null) {
            Integer value = memento.getInteger(STORE_GROUP_WITH);
            if (value != null) {
                this.groupWithConfiguration = value;
                this.updateGroupWith(this.getViewer());
            }
            GroupByAction[] groupByActionArray = this.fGroupByActions;
            int n = this.fGroupByActions.length;
            int n2 = 0;
            while (n2 < n) {
                GroupByAction act = groupByActionArray[n2];
                act.updateImage();
                ++n2;
            }
        }
    }

    private void updateGroupWith(StructuredViewer viewer) {
        IContentProvider contentProvider;
        if (viewer != null && (contentProvider = viewer.getContentProvider()) instanceof ISearchIndexContentProvider) {
            ISearchIndexContentProvider searchIndexTreeContentProvider = (ISearchIndexContentProvider)contentProvider;
            searchIndexTreeContentProvider.setGroupWith(this.groupWithConfiguration);
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putInteger(STORE_GROUP_WITH, this.groupWithConfiguration);
    }

    protected void textChanged() {
        if (this.refreshJob != null) {
            this.refreshJob.cancel();
        }
        this.getRefreshJob().schedule(650L);
    }

    protected WorkbenchJob getRefreshJob() {
        if (this.refreshJob == null) {
            this.refreshJob = new WorkbenchJob("Refresh Filter"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (AbstractSearchIndexResultPage.this.filterText != null && !AbstractSearchIndexResultPage.this.filterText.isDisposed()) {
                        String text = AbstractSearchIndexResultPage.this.filterText.getText().trim();
                        AbstractTextSearchResult input = AbstractSearchIndexResultPage.this.getInput();
                        if (input != null) {
                            if (!text.isEmpty()) {
                                ViewerFilter[] filters = new ViewerFilter[]{AbstractSearchIndexResultPage.this.createFilterFilter(text, false)};
                                AbstractSearchIndexResultPage.this.getViewer().setFilters(filters);
                                TreeViewer viewer = (TreeViewer)AbstractSearchIndexResultPage.this.getViewer();
                                viewer.expandAll();
                            } else {
                                AbstractSearchIndexResultPage.this.getViewer().setFilters(new ViewerFilter[0]);
                            }
                        }
                    }
                    AbstractSearchIndexResultPage.this.getViewPart().updateLabel();
                    return Status.OK_STATUS;
                }
            };
            this.refreshJob.setSystem(true);
        }
        return this.refreshJob;
    }

    protected abstract AbstractSearchResultsViewerFilter createFilterFilter(String var1, boolean var2);

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        SearchIndexLabelProvider innerLabelProvider = this.createSearchIndexLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingFileSearchLabelProvider(innerLabelProvider));
        viewer.setContentProvider((IContentProvider)this.createTreeContentProvider(viewer));
        viewer.setComparator((ViewerComparator)new DecoratorIgnoringViewerSorter((ILabelProvider)innerLabelProvider));
        this.fContentProvider = (ISearchIndexContentProvider)viewer.getContentProvider();
        this.addDragAdapters((StructuredViewer)viewer);
        this.updateGroupWith((StructuredViewer)viewer);
    }

    protected SearchIndexLabelProvider createSearchIndexLabelProvider() {
        return new SearchIndexLabelProvider(this);
    }

    protected abstract TreeNodeContentProvider createTreeContentProvider(TreeViewer var1);

    protected void showMatch(Match match, int offset, int length, boolean activate) throws PartInitException {
        IFile file = (IFile)match.getElement();
        IWorkbenchPage page = this.getSite().getPage();
        if (offset >= 0 && length != 0) {
            this.openAndSelect(page, file, offset, length, activate);
        } else {
            this.open(page, file, activate);
        }
    }

    protected void handleOpen(OpenEvent event) {
        Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (this.getDisplayedMatchCount(firstElement) == 0) {
            try {
                IAdaptable iAdaptable;
                IFile file;
                if (firstElement instanceof IAdaptable && (file = (IFile)(iAdaptable = (IAdaptable)firstElement).getAdapter(IFile.class)) != null) {
                    this.open(this.getSite().getPage(), file, false);
                }
            }
            catch (PartInitException e) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Open File", (String)"Opening the file failed.", (IStatus)e.getStatus());
            }
            return;
        }
        super.handleOpen(event);
    }

    protected void configureTableViewer(TableViewer viewer) {
        throw new RuntimeException("Table layout is unsupported.");
    }

    public StructuredViewer getViewer() {
        return super.getViewer();
    }

    public void setElementLimit(Integer elementLimit) {
        super.setElementLimit(elementLimit);
    }

    private void addDragAdapters(StructuredViewer viewer) {
        Transfer[] transfers = new Transfer[]{ResourceTransfer.getInstance()};
        int ops = 5;
        viewer.addDragSupport(ops, transfers, (DragSourceListener)new NavigatorDragAdapter((ISelectionProvider)viewer));
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        this.fActionGroup.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
        this.fActionGroup.fillContextMenu(mgr);
        AbstractSearchIndexQuery query = (AbstractSearchIndexQuery)this.getInput().getQuery();
        if (query.getSearchString().length() > 0) {
            IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
            if (!selection.isEmpty()) {
                ReplaceAction replaceSelection = new ReplaceAction(this.getSite().getShell(), this.getInput(), selection.toArray(), true);
                replaceSelection.setText(SearchMessages.ReplaceAction_label_selected);
                mgr.appendToGroup("group.reorganize", (IAction)replaceSelection);
            }
            ICallback<Boolean, Match> skipMatch = new ICallback<Boolean, Match>(){

                public Boolean call(Match match) {
                    StructuredViewer viewer = AbstractSearchIndexResultPage.this.getViewer();
                    ViewerFilter[] filters = viewer.getFilters();
                    if (filters == null || filters.length == 0) {
                        return false;
                    }
                    ViewerFilter[] viewerFilterArray = filters;
                    int n = filters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractSearchResultsViewerFilter searchResultsViewerFilter;
                        ViewerFilter viewerFilter = viewerFilterArray[n2];
                        if (viewerFilter instanceof AbstractSearchResultsViewerFilter && (searchResultsViewerFilter = (AbstractSearchResultsViewerFilter)viewerFilter).isLeafMatch((Viewer)viewer, match)) {
                            return false;
                        }
                        ++n2;
                    }
                    return true;
                }
            };
            ReplaceAction replaceAll = new ReplaceAction(this.getSite().getShell(), this.getInput(), null, true, skipMatch);
            replaceAll.setText(SearchMessages.ReplaceAction_label_all);
            mgr.appendToGroup("group.reorganize", (IAction)replaceAll);
        }
    }

    public void setViewPart(ISearchResultViewPart part) {
        super.setViewPart(part);
        this.fActionGroup = new NewTextSearchActionGroup((IViewPart)part);
    }

    protected void fillToolbar(IToolBarManager tbm) {
        super.fillToolbar(tbm);
        GroupByAction[] groupByActionArray = this.fGroupByActions;
        int n = this.fGroupByActions.length;
        int n2 = 0;
        while (n2 < n) {
            GroupByAction a = groupByActionArray[n2];
            String id = "group.properties." + ((Object)((Object)a)).hashCode();
            a.setId(id);
            tbm.add((IAction)a);
            ++n2;
        }
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            ViewerFilter[] filters;
            ViewerFilter[] viewerFilterArray = filters = this.getViewer().getFilters();
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter viewerFilter = viewerFilterArray[n2];
                if (viewerFilter instanceof AbstractSearchResultsViewerFilter) {
                    AbstractSearchResultsViewerFilter searchResultsViewerFilter = (AbstractSearchResultsViewerFilter)viewerFilter;
                    searchResultsViewerFilter.clearCache();
                }
                ++n2;
            }
            this.fContentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
            WorkbenchJob r = this.refreshJob;
            if (r != null) {
                r.cancel();
            }
            this.filterText.setText("");
            this.getViewer().setFilters(new ViewerFilter[0]);
        }
    }

    public Object getUIState() {
        return new Tuple(super.getUIState(), (Object)this.filterText.getText());
    }

    public void setInput(ISearchResult newSearch, Object viewState) {
        String filter = "";
        if (viewState instanceof Tuple) {
            Tuple tuple = (Tuple)viewState;
            filter = (String)tuple.o2;
            viewState = tuple.o1;
        }
        StructuredViewer viewer = this.getViewer();
        Control control = viewer.getControl();
        control.setRedraw(false);
        try {
            viewer.setFilters(new ViewerFilter[0]);
            try {
                super.setInput(newSearch, viewState);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                super.setInput(newSearch, null);
            }
            this.filterText.setText(filter);
            this.textChanged();
        }
        finally {
            control.setRedraw(true);
        }
    }

    public void dispose() {
        this.fActionGroup.dispose();
        if (this.filterText != null) {
            this.filterText.dispose();
            this.filterText = null;
        }
        if (this.refreshJob != null) {
            this.refreshJob.cancel();
            this.refreshJob = null;
        }
        super.dispose();
    }

    public Object getAdapter(Class<?> adapter) {
        if (IShowInTargetList.class.equals(adapter)) {
            return SHOW_IN_TARGET_LIST;
        }
        if (adapter == IShowInSource.class) {
            ISelectionProvider selectionProvider = this.getSite().getSelectionProvider();
            if (selectionProvider == null) {
                return null;
            }
            ISelection selection = selectionProvider.getSelection();
            if (selection instanceof IStructuredSelection) {
                StructuredSelection structuredSelection = (StructuredSelection)selection;
                final HashSet newSelection = new HashSet(structuredSelection.size());
                for (Object element : structuredSelection) {
                    if (element instanceof ICustomLineElement) {
                        element = ((ICustomLineElement)element).getParent();
                    }
                    newSelection.add(element);
                }
                return new IShowInSource(){

                    public ShowInContext getShowInContext() {
                        return new ShowInContext(null, (ISelection)new StructuredSelection(new ArrayList(newSelection)));
                    }
                };
            }
            return null;
        }
        return null;
    }

    public String getLabel() {
        StructuredViewer viewer = this.getViewer();
        if (viewer instanceof TreeViewer) {
            AbstractTextSearchResult result;
            int count = 0;
            TreeViewer tv = (TreeViewer)viewer;
            AbstractTextSearchResult input = this.getInput();
            if (input != null) {
                ViewerFilter[] filters = tv.getFilters();
                if (filters != null && filters.length > 0) {
                    Object[] elements = input.getElements();
                    int j = 0;
                    while (j < elements.length) {
                        Match[] matches;
                        Object element = elements[j];
                        Match[] matchArray = matches = input.getMatches(element);
                        int n = matches.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Match match = matchArray[n2];
                            int i = 0;
                            while (i < filters.length) {
                                AbstractSearchResultsViewerFilter searchResultsViewerFilter;
                                ViewerFilter vf = filters[i];
                                if (vf instanceof AbstractSearchResultsViewerFilter && (searchResultsViewerFilter = (AbstractSearchResultsViewerFilter)vf).isLeafMatch((Viewer)viewer, match)) {
                                    ++count;
                                }
                                ++i;
                            }
                            ++n2;
                        }
                        ++j;
                    }
                } else {
                    count = input.getMatchCount();
                }
            }
            if ((result = this.getInput()) == null) {
                return "";
            }
            ISearchQuery query = result.getQuery();
            if (query instanceof AbstractSearchIndexQuery) {
                AbstractSearchIndexQuery searchIndexQuery = (AbstractSearchIndexQuery)query;
                return searchIndexQuery.getResultLabel(count);
            }
        }
        return super.getLabel();
    }

    public int getDisplayedMatchCount(Object element) {
        if (element instanceof TreeNode) {
            element = ((TreeNode)element).data;
        }
        if (element instanceof ICustomLineElement) {
            ICustomLineElement lineEntry = (ICustomLineElement)element;
            return lineEntry.getNumberOfMatches(this.getInput());
        }
        return 0;
    }

    public Match[] getDisplayedMatches(Object element) {
        if (element instanceof TreeNode) {
            element = ((TreeNode)element).data;
        }
        if (element instanceof ICustomModule) {
            ICustomModule customModule = (ICustomModule)element;
            element = customModule.getModuleLineElement();
        }
        if (element instanceof ICustomLineElement) {
            ICustomLineElement lineEntry = (ICustomLineElement)element;
            return lineEntry.getMatches(this.getInput());
        }
        return new Match[0];
    }

    protected void evaluateChangedElements(Match[] matches, Set changedElements) {
        int i = 0;
        while (i < matches.length) {
            changedElements.add(((ICustomMatch)matches[i]).getLineElement());
            ++i;
        }
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        this.createFilterControl(parent);
        TreeViewer ret = new TreeViewer(parent, 770){
            long currentTimeMillis;
            boolean inExpandAll;
            {
                this.inExpandAll = false;
            }

            public void expandAll() {
                this.currentTimeMillis = System.currentTimeMillis();
                Control control = this.getControl();
                control.setRedraw(false);
                try {
                    try {
                        this.inExpandAll = true;
                        super.expandAll();
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        Log.log((String)"Aborted expand operation because it took more than 5 seconds.");
                        this.inExpandAll = false;
                        control.setRedraw(true);
                    }
                }
                finally {
                    this.inExpandAll = false;
                    control.setRedraw(true);
                }
            }

            protected void internalExpandToLevel(Widget widget, int level) {
                if (this.inExpandAll && System.currentTimeMillis() - this.currentTimeMillis > 5000L) {
                    throw new OperationCanceledException();
                }
                super.internalExpandToLevel(widget, level);
            }

            public void collapseAll() {
                Control control = this.getControl();
                control.setRedraw(false);
                try {
                    super.collapseAll();
                }
                finally {
                    control.setRedraw(true);
                }
            }
        };
        this.fixViewerLayout(ret.getControl());
        return ret;
    }

    protected TableViewer createTableViewer(Composite parent) {
        this.createFilterControl(parent);
        TableViewer ret = super.createTableViewer(parent);
        this.fixViewerLayout(ret.getControl());
        return ret;
    }

    private void fixViewerLayout(Control control) {
        GridData layoutData = new GridData(1808);
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalSpan = 3;
        control.setLayoutData((Object)layoutData);
    }

    private void createFilterControl(Composite parent) {
        GridLayout layout = new GridLayout(3, false);
        parent.setLayout((Layout)layout);
        Label label = new Label(parent, 0);
        label.setText(this.getFilterText());
        this.filterText = new Text(parent, 2052);
        GridData layoutData = new GridData(4, 0, true, false);
        this.filterText.setLayoutData((Object)layoutData);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractSearchIndexResultPage.this.textChanged();
            }
        });
        StyledLink.MultiStyledLink link = new StyledLink.MultiStyledLink(parent, 0);
        link.setText("<a> ? </a>");
        final String filterHelp = this.getFilterHelp();
        link.getLink(0).addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DialogHelpers.openInfo("", filterHelp);
            }
        });
        link.getLink(0).setToolTipText(filterHelp);
    }

    protected abstract String getFilterHelp();

    protected abstract String getFilterText();

    public static class DecoratorIgnoringViewerSorter
    extends ViewerComparator {
        private final ILabelProvider fLabelProvider;

        public DecoratorIgnoringViewerSorter(ILabelProvider labelProvider) {
            this.fLabelProvider = labelProvider;
        }

        public int category(Object element) {
            if (element instanceof IContainer) {
                return 1;
            }
            return 2;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof ICustomLineElement && e2 instanceof ICustomLineElement) {
                ICustomLineElement m1 = (ICustomLineElement)e1;
                ICustomLineElement m2 = (ICustomLineElement)e2;
                return m1.getOffset() - m2.getOffset();
            }
            String name1 = this.fLabelProvider.getText(e1);
            String name2 = this.fLabelProvider.getText(e2);
            if (name1 == null) {
                name1 = "";
            }
            if (name2 == null) {
                name2 = "";
            }
            return this.getComparator().compare(name1, name2);
        }
    }
}

