/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.proposals;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_ui.proposals.IPyCompletionProposal;

public class PyCompletionProposal
implements ICompletionProposal,
IPyCompletionProposal,
ICompletionProposalExtension4 {
    protected String fDisplayString;
    protected String fReplacementString;
    protected int fReplacementOffset;
    protected int fReplacementLength;
    protected int fCursorPosition;
    protected Image fImage;
    protected IContextInformation fContextInformation;
    protected String fAdditionalProposalInfo;
    protected int priority;
    public static final int ON_APPLY_DEFAULT = 1;
    public static final int ON_APPLY_JUST_SHOW_CTX_INFO = 2;
    public static final int ON_APPLY_SHOW_CTX_INFO_AND_ADD_PARAMETETRS = 3;
    public int onApplyAction = 1;
    public String fArgs;
    public static final int BEHAVIOR_OVERRIDES = 0;
    public static final int BEHAVIOR_COEXISTS = 1;
    public static final int BEHAVIOR_IS_OVERRIDEN = 2;

    public PyCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, int priority) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, null, null, null, null, priority);
    }

    public PyCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, priority, 1, "");
    }

    public PyCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority, int onApplyAction, String args) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
        this.fImage = image;
        if (displayString == null) {
            displayString = replacementString;
        }
        this.fDisplayString = displayString;
        this.fContextInformation = contextInformation;
        this.fAdditionalProposalInfo = additionalProposalInfo;
        this.priority = priority;
        this.onApplyAction = onApplyAction;
        this.fArgs = args;
    }

    public void apply(IDocument document) {
        switch (this.onApplyAction) {
            case 2: {
                break;
            }
            case 1: {
                try {
                    document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
                }
                catch (BadLocationException badLocationException) {}
                break;
            }
            case 3: {
                try {
                    if (this.fArgs.length() <= 0) break;
                    String args = this.fArgs.substring(1, this.fArgs.length() - 1);
                    document.replace(this.fReplacementOffset + this.fReplacementLength, 0, args);
                }
                catch (BadLocationException x) {
                    Log.log((Throwable)x);
                }
                break;
            }
            default: {
                throw new RuntimeException("Unexpected apply mode:" + this.onApplyAction);
            }
        }
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public Point getSelection(IDocument document) {
        if (this.onApplyAction == 2) {
            return null;
        }
        if (this.onApplyAction == 1) {
            return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
        }
        if (this.onApplyAction == 3) {
            return new Point(this.fReplacementOffset + this.fCursorPosition - 1, 0);
        }
        throw new RuntimeException("Unexpected apply mode:" + this.onApplyAction);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public Image getImage() {
        return this.fImage;
    }

    public final String getDisplayString() {
        return this.fDisplayString;
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }

    public int hashCode() {
        return this.getDisplayString().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PyCompletionProposal)) {
            return false;
        }
        PyCompletionProposal c = (PyCompletionProposal)obj;
        return this.getDisplayString().equals(c.getDisplayString());
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public boolean isAutoInsertable() {
        return this.onApplyAction == 2 || this.onApplyAction == 3;
    }

    public int getOverrideBehavior(ICompletionProposal curr) {
        return 0;
    }
}

