/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.editor_input;

import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.editors.text.ILocationProviderExtension;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.python.pydev.shared_ui.editor_input.EditorInputUtils;
import org.python.pydev.shared_ui.editor_input.PyEditorInputFactory;

public class PydevFileEditorInput
implements IPathEditorInput,
ILocationProvider,
ILocationProviderExtension,
IURIEditorInput,
IPersistableElement {
    File fFile;
    private WorkbenchAdapter fWorkbenchAdapter = new WorkbenchAdapter();

    public PydevFileEditorInput(File file) {
        this.fFile = file;
        this.fWorkbenchAdapter = new WorkbenchAdapter();
    }

    public boolean exists() {
        return this.fFile.exists();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.fFile.getName();
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        return this.fFile.getAbsolutePath();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isInstance(this)) {
            return (T)this;
        }
        if (IWorkbenchAdapter.class.equals(adapter)) {
            return (T)this.fWorkbenchAdapter;
        }
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IPath getPath(Object element) {
        if (element instanceof PydevFileEditorInput) {
            PydevFileEditorInput input = (PydevFileEditorInput)element;
            return Path.fromOSString((String)input.fFile.getAbsolutePath());
        }
        return null;
    }

    public IPath getPath() {
        return Path.fromOSString((String)this.fFile.getAbsolutePath());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IEditorInput)) {
            return false;
        }
        File file = EditorInputUtils.getFile((IEditorInput)o);
        return this.fFile.equals(file);
    }

    public int hashCode() {
        return this.fFile.hashCode();
    }

    public File getFile() {
        return this.fFile;
    }

    public URI getURI(Object element) {
        if (element instanceof IURIEditorInput) {
            IURIEditorInput editorInput = (IURIEditorInput)element;
            return editorInput.getURI();
        }
        return null;
    }

    public URI getURI() {
        return this.fFile.toURI();
    }

    public void saveState(IMemento memento) {
        PyEditorInputFactory.saveState(memento, this);
    }

    public String getFactoryId() {
        return "org.python.pydev.editorinput.pyEditorInputFactory";
    }

    private static class WorkbenchAdapter
    implements IWorkbenchAdapter {
        private WorkbenchAdapter() {
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return ((PydevFileEditorInput)o).getName();
        }

        public Object getParent(Object o) {
            return null;
        }
    }
}

