/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.editor_input;

import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.python.pydev.shared_ui.editor_input.PydevFileEditorInput;

public class EditorInputUtils {
    public static File getFile(IEditorInput o) {
        if (o == null) {
            return null;
        }
        IFile file = (IFile)o.getAdapter(IFile.class);
        if (file != null) {
            URI locationURI = file.getLocationURI();
            if (locationURI == null) {
                return null;
            }
            return new File(locationURI);
        }
        URI uri = (URI)o.getAdapter(URI.class);
        if (uri != null) {
            return new File(uri);
        }
        if (o instanceof PydevFileEditorInput) {
            PydevFileEditorInput input = (PydevFileEditorInput)o;
            return input.fFile;
        }
        if (o instanceof IPathEditorInput) {
            IPathEditorInput input = (IPathEditorInput)o;
            return new File(input.getPath().toOSString());
        }
        try {
            if (o instanceof IURIEditorInput) {
                IURIEditorInput iuriEditorInput = (IURIEditorInput)o;
                return new File(iuriEditorInput.getURI());
            }
        }
        catch (Throwable throwable) {}
        return null;
    }
}

