/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.python.pydev.shared_core.callbacks.CallbackWithListeners;
import org.python.pydev.shared_core.callbacks.ICallbackWithListeners;
import org.python.pydev.shared_core.string.StringMatcher;
import org.python.pydev.shared_ui.utils.IViewWithControls;

public class TreeSelectionDialog
extends ElementTreeSelectionDialog
implements IViewWithControls {
    private ILabelProvider labelProvider;
    protected DefaultFilterMatcher fFilterMatcher = new DefaultFilterMatcher();
    protected ITreeContentProvider contentProvider;
    protected String initialFilter = "";
    public final ICallbackWithListeners onControlCreated = new CallbackWithListeners();
    public final ICallbackWithListeners onControlDisposed = new CallbackWithListeners();
    protected boolean updateInThread = true;
    private int fWidth = 60;
    protected Text text;
    protected UpdateJob updateJob;
    private final Object lock = new Object();

    protected void doFilterUpdate(IProgressMonitor monitor) {
        if (this.text != null && !this.text.isDisposed()) {
            this.setFilter(this.text.getText(), monitor, true);
            this.onFinishUpdateJob();
        }
    }

    protected void onFinishUpdateJob() {
    }

    public TreeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.labelProvider = labelProvider;
        this.contentProvider = contentProvider;
    }

    public void setInitialFilter(String initialFilter) {
        this.initialFilter = initialFilter;
    }

    protected int getDefaultMargins() {
        return 2;
    }

    protected int getDefaultSpacing() {
        return 2;
    }

    protected Control createDialogArea(Composite parent) {
        Control composite = super.createDialogArea(parent);
        if (composite instanceof Composite) {
            this.updateCompositeLayout((Composite)composite);
        }
        TreeViewer treeViewer = this.getTreeViewer();
        treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return TreeSelectionDialog.this.matchItemToShowInTree(element);
            }
        });
        treeViewer.setAutoExpandLevel(-1);
        treeViewer.expandAll();
        if (this.initialFilter.length() > 0) {
            this.text.setText(this.initialFilter);
            this.text.setSelection(this.initialFilter.length());
            this.setFilter(this.initialFilter, (IProgressMonitor)new NullProgressMonitor(), true);
        }
        this.notifyViewCreated();
        this.onControlCreated.call((Object)this.text);
        this.onControlCreated.call((Object)this.getTreeViewer());
        return composite;
    }

    protected void notifyViewCreated() {
    }

    public int open() {
        try {
            int n = super.open();
            return n;
        }
        finally {
            this.onControlDisposed.call((Object)this.text);
            this.onControlDisposed.call((Object)this.getTreeViewer());
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control composite = super.createButtonBar(parent);
        if (composite instanceof Composite) {
            this.updateCompositeLayout((Composite)composite);
        }
        return composite;
    }

    private void updateCompositeLayout(Composite composite) {
        Layout l = composite.getLayout();
        if (l instanceof GridLayout) {
            GridLayout layout = (GridLayout)l;
            layout.marginHeight = this.convertVerticalDLUsToPixels(this.getDefaultMargins());
            layout.marginWidth = this.convertHorizontalDLUsToPixels(this.getDefaultMargins());
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(this.getDefaultSpacing());
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(this.getDefaultSpacing());
            composite.setLayout((Layout)layout);
        }
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control t = controlArray[n2];
            if (t instanceof Composite) {
                this.updateCompositeLayout((Composite)t);
            }
            ++n2;
        }
    }

    protected Label createMessageArea(Composite composite) {
        Label label = super.createMessageArea(composite);
        this.text = new Text(composite, 2048);
        this.text.setFont(composite.getFont());
        GridData data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        this.text.setLayoutData((Object)data);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                if (TreeSelectionDialog.this.updateInThread) {
                    if (TreeSelectionDialog.this.updateJob != null) {
                        TreeSelectionDialog.this.updateJob.cancel();
                    }
                    TreeSelectionDialog.this.updateJob = new UpdateJob();
                    TreeSelectionDialog.this.updateJob.start();
                } else {
                    TreeSelectionDialog.this.doFilterUpdate((IProgressMonitor)new NullProgressMonitor());
                }
            }
        };
        this.text.addListener(24, listener);
        this.text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 || e.keyCode == 0x1000006) {
                    Tree tree = TreeSelectionDialog.this.getTreeViewer().getTree();
                    tree.setFocus();
                    TreeSelectionDialog.this.updateSelectionIfNothingSelected(tree);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setFilter(String text, IProgressMonitor monitor, boolean updateFilterMatcher) {
        Object object = this.lock;
        synchronized (object) {
            if (monitor.isCanceled()) {
                return;
            }
            if (updateFilterMatcher) {
                if (this.fFilterMatcher.lastPattern.equals(text)) {
                    return;
                }
                this.fFilterMatcher.setFilter(text);
                if (monitor.isCanceled()) {
                    return;
                }
            }
            TreeViewer treeViewer = this.getTreeViewer();
            Tree tree = treeViewer.getTree();
            tree.setRedraw(false);
            tree.getParent().setRedraw(false);
            try {
                if (monitor.isCanceled()) {
                    return;
                }
                treeViewer.refresh();
                if (monitor.isCanceled()) {
                    return;
                }
                treeViewer.expandAll();
            }
            finally {
                tree.setRedraw(true);
                tree.getParent().setRedraw(true);
            }
            return;
        }
    }

    private List<Object> getAllChildren(Object element) {
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] children = this.contentProvider.getChildren(element);
        if (children == null) {
            return list;
        }
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            list.add(object);
            list.addAll(this.getAllChildren(object));
            ++n2;
        }
        return list;
    }

    protected void computeResult() {
        this.doFinalUpdateBeforeComputeResult();
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        ArrayList<Object> list = selection.toList();
        if (list.size() > 0) {
            this.setResult(list);
        } else {
            TreeItem[] items = this.getTreeViewer().getTree().getItems();
            if (items.length == 1) {
                list = new ArrayList<Object>();
                list.add(items[0].getData());
                this.setResult(list);
            }
        }
    }

    protected void doFinalUpdateBeforeComputeResult() {
        if (this.updateInThread) {
            UpdateJob j = this.updateJob;
            if (j != null) {
                this.updateJob.cancel();
            }
            this.doFilterUpdate((IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected boolean matchItemToShowInTree(Object element) {
        return this.fFilterMatcher.match(element);
    }

    protected void updateSelectionIfNothingSelected(Tree tree) {
        TreeItem[] items;
        TreeItem[] sel = tree.getSelection();
        if ((sel == null || sel.length == 0) && (items = tree.getItems()) != null && items.length > 0) {
            tree.setSelection(items[0]);
        }
    }

    public boolean isHelpAvailable() {
        return false;
    }

    @Override
    public ICallbackWithListeners getOnControlCreated() {
        return this.onControlCreated;
    }

    @Override
    public ICallbackWithListeners getOnControlDisposed() {
        return this.onControlDisposed;
    }

    protected class DefaultFilterMatcher {
        public StringMatcher fMatcher;
        public String lastPattern;

        public DefaultFilterMatcher() {
            this.setFilter("");
        }

        public void setFilter(String pattern) {
            this.setFilter(pattern, true, false);
        }

        private void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
            this.fMatcher = pattern.endsWith(" ") ? new StringMatcher(pattern.substring(0, pattern.length() - 1), ignoreCase, ignoreWildCards) : new StringMatcher(String.valueOf(pattern) + '*', ignoreCase, ignoreWildCards);
            this.lastPattern = pattern;
        }

        public boolean match(Object element) {
            boolean match = this.fMatcher.match(TreeSelectionDialog.this.labelProvider.getText(element));
            if (match) {
                return true;
            }
            List allChildren = TreeSelectionDialog.this.getAllChildren(element);
            for (Object object : allChildren) {
                if (!this.fMatcher.match(TreeSelectionDialog.this.labelProvider.getText(object))) continue;
                return true;
            }
            return false;
        }
    }

    protected class UpdateJob
    extends Thread {
        IProgressMonitor monitor = new NullProgressMonitor();

        public UpdateJob() {
            this.setPriority(1);
            this.setName("TreeSelectionDialog: UpdateJob");
        }

        @Override
        public void run() {
            try {
                UpdateJob.sleep(300L);
            }
            catch (InterruptedException interruptedException) {}
            if (!this.monitor.isCanceled()) {
                Display display = Display.getDefault();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!UpdateJob.this.monitor.isCanceled()) {
                            TreeSelectionDialog.this.doFilterUpdate(UpdateJob.this.monitor);
                        }
                    }
                });
            }
        }

        public void cancel() {
            this.monitor.setCanceled(true);
        }
    }
}

