/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.bindings;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.keys.IBindingService;
import org.python.pydev.shared_core.log.Log;

public class BindKeysHelper {
    private final ContextManager contextManager = new ContextManager();
    private final BindingManager localChangeManager = new BindingManager(this.contextManager, new CommandManager());
    private final IBindingService bindingService;
    private final String contextId;
    private final Set<Object> initialState = new HashSet<Object>();

    public BindKeysHelper(String contextId) {
        Binding[] bindings;
        Assert.isNotNull((Object)contextId);
        this.contextId = contextId;
        HashSet<String> activeContextIds = new HashSet<String>();
        activeContextIds.add(contextId);
        this.contextManager.setActiveContextIds(activeContextIds);
        IWorkbench workbench = PlatformUI.getWorkbench();
        this.bindingService = (IBindingService)workbench.getService(IBindingService.class);
        IContextService contextService = (IContextService)workbench.getService(IContextService.class);
        Context context = contextService.getContext(contextId);
        if (context == null || !context.isDefined()) {
            throw new RuntimeException("The context: " + contextId + " does not exist.");
        }
        Scheme activeScheme = this.bindingService.getActiveScheme();
        Scheme[] definedSchemes = this.bindingService.getDefinedSchemes();
        try {
            int i = 0;
            while (i < definedSchemes.length) {
                Scheme scheme = definedSchemes[i];
                Scheme copy = this.localChangeManager.getScheme(scheme.getId());
                copy.define(scheme.getName(), scheme.getDescription(), scheme.getParentId());
                ++i;
            }
            this.localChangeManager.setActiveScheme(activeScheme);
        }
        catch (NotDefinedException notDefinedException) {
            throw new Error("There is a programmer error in the bind keys helper");
        }
        this.localChangeManager.setLocale(this.bindingService.getLocale());
        this.localChangeManager.setPlatform(this.bindingService.getPlatform());
        Binding[] bindingArray = bindings = this.bindingService.getBindings();
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            Binding binding = bindingArray[n2];
            this.initialState.add(binding);
            ++n2;
        }
        this.localChangeManager.setBindings(bindings);
    }

    public void addUserBindings(KeySequence keySequence, ParameterizedCommand command) throws Exception {
        Scheme activeScheme = this.bindingService.getActiveScheme();
        String schemeId = activeScheme.getId();
        this.localChangeManager.addBinding((Binding)new KeyBinding(keySequence, command, schemeId, this.contextId, null, null, null, 1));
    }

    public void removeUserBindingsWithFilter(IFilter iFilter) {
        Binding[] bindings = this.localChangeManager.getBindings();
        int i = 0;
        while (i < bindings.length) {
            Binding binding = bindings[i];
            if (binding.getContextId().equals(this.contextId) && iFilter.removeBinding(binding)) {
                this.localChangeManager.removeBinding(binding);
            }
            ++i;
        }
    }

    public void saveIfChanged() {
        try {
            Binding[] newBindings = this.localChangeManager.getBindings();
            HashSet<Binding> newState = new HashSet<Binding>();
            Binding[] bindingArray = newBindings;
            int n = newBindings.length;
            int n2 = 0;
            while (n2 < n) {
                Binding binding = bindingArray[n2];
                newState.add(binding);
                ++n2;
            }
            if (newState.equals(this.initialState)) {
                return;
            }
            this.bindingService.savePreferences(this.localChangeManager.getActiveScheme(), newBindings);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public static interface IFilter {
        public boolean removeBinding(Binding var1);
    }
}

