/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.FontData;
import org.python.pydev.shared_core.structure.Tuple;

public class FontUtils {
    private static Tuple<String, Integer> getCodeFontNameAndHeight(int usage) throws IllegalArgumentException {
        int fontHeight;
        String fontName;
        block15: {
            block14: {
                fontName = "Courier New";
                fontHeight = 10;
                if (!Platform.getOS().equals("macosx")) break block14;
                switch (usage) {
                    case 0: {
                        fontName = "Monaco";
                        fontHeight = 11;
                        break block15;
                    }
                    case 1: {
                        fontName = "Courier";
                        fontHeight = 11;
                        break block15;
                    }
                    case 2: {
                        fontName = "Monaco";
                        fontHeight = 9;
                        break block15;
                    }
                    case 3: {
                        fontName = "Monaco";
                        fontHeight = 11;
                        break block15;
                    }
                    case 4: {
                        fontName = "Monaco";
                        fontHeight = 9;
                        break block15;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid usage. See IFontUsage for valid values.");
                    }
                }
            }
            switch (usage) {
                case 0: {
                    fontName = "Courier New";
                    fontHeight = 10;
                    break;
                }
                case 1: {
                    fontName = "Courier New";
                    fontHeight = 8;
                    break;
                }
                case 2: {
                    fontName = "Courier New";
                    fontHeight = 10;
                    break;
                }
                case 3: {
                    fontName = "Courier New";
                    fontHeight = 9;
                    break;
                }
                case 4: {
                    fontName = "Courier New";
                    fontHeight = 8;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid usage. See IFontUsage for valid values.");
                }
            }
        }
        return new Tuple((Object)fontName, (Object)fontHeight);
    }

    public static FontData getFontData(int usage, boolean useDefaultJFaceFontIfPossible) {
        return FontUtils.getFontData(usage, 0, useDefaultJFaceFontIfPossible);
    }

    public static FontData getFontData(int usage, int style, boolean useDefaultJFaceFontIfPossible) {
        FontData[] textFontData;
        if (useDefaultJFaceFontIfPossible && (textFontData = JFaceResources.getTextFont().getFontData()).length == 1) {
            return textFontData[0];
        }
        Tuple<String, Integer> codeFontDetails = FontUtils.getCodeFontNameAndHeight(usage);
        String fontName = (String)codeFontDetails.o1;
        int base = (Integer)codeFontDetails.o2;
        return new FontData(fontName, base, style);
    }
}

