/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class ObjectsInternPool {
    private static final Map<String, WeakReference<String>> weakHashMap = new WeakHashMap<String, WeakReference<String>>();
    public static final Object lock = new Object();

    private ObjectsInternPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String intern(String o) {
        if (o == null) {
            return null;
        }
        Object object = lock;
        synchronized (object) {
            WeakReference<String> w = weakHashMap.get(o);
            if (w == null) {
                o = new String(o);
                weakHashMap.put(o, new WeakReference<String>(o));
                return o;
            }
            String ret = (String)w.get();
            if (ret == null && o != null) {
                o = new String(o);
                weakHashMap.put(o, new WeakReference<String>(o));
                return o;
            }
            return ret;
        }
    }

    public static String internUnsynched(String o) {
        if (o == null) {
            return null;
        }
        WeakReference<String> w = weakHashMap.get(o);
        if (w == null) {
            o = new String(o);
            weakHashMap.put(o, new WeakReference<String>(o));
            return o;
        }
        String ret = (String)w.get();
        if (ret == null && o != null) {
            o = new String(o);
            weakHashMap.put(o, new WeakReference<String>(o));
            return o;
        }
        return ret;
    }

    public static String internLocal(ObjectsPoolMap mapWithInternedStrings, String string) {
        String existing = (String)mapWithInternedStrings.get(string);
        if (existing != null) {
            return existing;
        }
        mapWithInternedStrings.put(string, string);
        return string;
    }

    public static final class ObjectsPoolMap
    extends HashMap<String, String> {
        private static final long serialVersionUID = 1L;
    }
}

