/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.visitors;

import com.python.pydev.analysis.visitors.Found;
import com.python.pydev.analysis.visitors.Scope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.python.pydev.core.IToken;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.TryExcept;
import org.python.pydev.parser.jython.ast.excepthandlerType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.FastStack;
import org.python.pydev.shared_core.structure.Tuple;

public final class ScopeItems {
    private final Map<String, List<Found>> m = new HashMap<String, List<Found>>();
    public Map<String, Tuple<IToken, Found>> namesToIgnore = new HashMap<String, Tuple<IToken, Found>>();
    public int ifSubScope = 0;
    public FastStack<TryExceptInfo> tryExceptSubScope = new FastStack(10);
    private int scopeId;
    private int scopeType;

    public TryExceptInfo getTryExceptImportError() {
        for (TryExceptInfo except : this.getCurrTryExceptNodes()) {
            excepthandlerType[] excepthandlerTypeArray = except.except.handlers;
            int n = except.except.handlers.length;
            int n2 = 0;
            while (n2 < n) {
                String rep;
                excepthandlerType handler = excepthandlerTypeArray[n2];
                if (handler.type != null && (rep = NodeUtils.getRepresentationString((SimpleNode)handler.type)) != null && rep.equals("ImportError")) {
                    return except;
                }
                ++n2;
            }
        }
        return null;
    }

    public ScopeItems(int scopeId, int scopeType) {
        this.scopeId = scopeId;
        this.scopeType = scopeType;
    }

    public Found getLastAppearance(String rep) {
        List<Found> foundItems = this.m.get(rep);
        if (foundItems == null || foundItems.size() == 0) {
            return null;
        }
        return foundItems.get(foundItems.size() - 1);
    }

    public void setAllUsed() {
        for (List<Found> list : this.m.values()) {
            int len = list.size();
            int i = 0;
            while (i < len) {
                list.get(i).setUsed(true);
                ++i;
            }
        }
    }

    public Collection<List<Found>> getAll() {
        return this.m.values();
    }

    public List<Found> getAll(String rep) {
        List<Found> r = this.m.get(rep);
        if (r == null) {
            return new ArrayList<Found>(0);
        }
        return r;
    }

    public void put(String rep, Found found) {
        List<Found> foundItems = this.m.get(rep);
        if (foundItems == null) {
            foundItems = new ArrayList<Found>();
            this.m.put(rep, foundItems);
        }
        foundItems.add(found);
    }

    public void addIfSubScope() {
        ++this.ifSubScope;
    }

    public void removeIfSubScope() {
        --this.ifSubScope;
    }

    public void addTryExceptSubScope(TryExcept node) {
        this.tryExceptSubScope.push((Object)new TryExceptInfo(node));
    }

    public void removeTryExceptSubScope() {
        this.tryExceptSubScope.pop();
    }

    public FastStack<TryExceptInfo> getCurrTryExceptNodes() {
        return this.tryExceptSubScope;
    }

    public boolean getIsInSubSubScope() {
        return this.ifSubScope != 0 || this.tryExceptSubScope.size() != 0;
    }

    public boolean getIsInIfSubScope() {
        return this.ifSubScope != 0;
    }

    public int getScopeId() {
        return this.scopeId;
    }

    public int getScopeType() {
        return this.scopeType;
    }

    public String toString() {
        FastStringBuffer buffer = new FastStringBuffer();
        buffer.append("ScopeItem (type:");
        buffer.append(Scope.getScopeTypeStr(this.scopeType));
        buffer.append(")\n");
        for (Map.Entry<String, List<Found>> entry : this.m.entrySet()) {
            buffer.append(entry.getKey());
            buffer.append(": contains ");
            buffer.append(entry.getValue().toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public List<Tuple<String, Found>> getUsedItems() {
        ArrayList<Tuple<String, Found>> found = new ArrayList<Tuple<String, Found>>();
        for (Map.Entry<String, List<Found>> entry : this.m.entrySet()) {
            for (Found f : entry.getValue()) {
                if (!f.isUsed()) continue;
                found.add((Tuple<String, Found>)new Tuple((Object)entry.getKey(), (Object)f));
            }
        }
        return found;
    }

    public static class TryExceptInfo {
        public TryExcept except;
        private Map<String, List<Found>> importsMapInTryExcept = new HashMap<String, List<Found>>();

        public TryExceptInfo(TryExcept except) {
            this.except = except;
        }

        public void addFoundImportToTryExcept(Found found) {
            if (!found.isImport()) {
                return;
            }
            String rep = found.getSingle().generator.getRepresentation();
            List<Found> importsListInTryExcept = this.importsMapInTryExcept.get(rep);
            if (importsListInTryExcept == null) {
                importsListInTryExcept = new ArrayList<Found>();
                this.importsMapInTryExcept.put(rep, importsListInTryExcept);
            } else if (importsListInTryExcept.size() > 0) {
                importsListInTryExcept.get(importsListInTryExcept.size() - 1).setUsed(true);
            }
            importsListInTryExcept.add(found);
        }
    }
}

