/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.system_info_builder;

import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalSystemInterpreterInfo;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ISystemModulesManager;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.ModulesFoundStructure;
import org.python.pydev.editor.codecompletion.revisited.ModulesManager;
import org.python.pydev.editor.codecompletion.revisited.PyPublicTreeMap;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.codecompletion.revisited.SystemModulesManager;
import org.python.pydev.logging.DebugSettings;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.ui.pythonpathconf.IInterpreterInfoBuilder;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

public class InterpreterInfoBuilder
implements IInterpreterInfoBuilder {
    public IInterpreterInfoBuilder.BuilderResult syncInfoToPythonPath(IProgressMonitor monitor, IPythonNature nature) {
        PythonPathHelper pythonPathHelper = (PythonPathHelper)nature.getAstManager().getModulesManager().getPythonPathHelper();
        if (pythonPathHelper == null) {
            return IInterpreterInfoBuilder.BuilderResult.OK;
        }
        try {
            AbstractAdditionalDependencyInfo additionalInfo = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject(nature);
            IModulesManager modulesManager = nature.getAstManager().getModulesManager();
            return this.syncInfoToPythonPath(monitor, pythonPathHelper, additionalInfo, modulesManager, null);
        }
        catch (MisconfigurationException e) {
            Log.log((Throwable)e);
            return IInterpreterInfoBuilder.BuilderResult.OK;
        }
    }

    public IInterpreterInfoBuilder.BuilderResult syncInfoToPythonPath(IProgressMonitor monitor, InterpreterInfo info) {
        AbstractAdditionalDependencyInfo additionalInfo;
        PythonPathHelper pythonPathHelper = new PythonPathHelper();
        pythonPathHelper.setPythonPath(info.libs);
        ISystemModulesManager modulesManager = info.getModulesManager();
        IInterpreterManager manager = modulesManager.getInterpreterManager();
        try {
            additionalInfo = AdditionalSystemInterpreterInfo.getAdditionalSystemInfo(manager, info.getExecutableOrJar());
        }
        catch (MisconfigurationException e) {
            Log.log((Throwable)e);
            return IInterpreterInfoBuilder.BuilderResult.OK;
        }
        return this.syncInfoToPythonPath(monitor, pythonPathHelper, additionalInfo, (IModulesManager)modulesManager, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IInterpreterInfoBuilder.BuilderResult syncInfoToPythonPath(IProgressMonitor monitor, PythonPathHelper pythonPathHelper, AbstractAdditionalDependencyInfo additionalInfo, IModulesManager modulesManager, InterpreterInfo info) {
        IInterpreterInfoBuilder.BuilderResult ret;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (DebugSettings.DEBUG_INTERPRETER_AUTO_UPDATE) {
            Log.toLogFile((Object)this, (String)"--- Start run");
        }
        if ((ret = this.checkEarlyReturn(monitor, info)) != IInterpreterInfoBuilder.BuilderResult.OK) {
            return ret;
        }
        ModulesFoundStructure modulesFound = pythonPathHelper.getModulesFoundStructure(null, monitor);
        ret = this.checkEarlyReturn(monitor, info);
        if (ret != IInterpreterInfoBuilder.BuilderResult.OK) {
            return ret;
        }
        PyPublicTreeMap keysFound = ModulesManager.buildKeysFromModulesFound((IProgressMonitor)monitor, (ModulesFoundStructure)modulesFound);
        if (DebugSettings.DEBUG_INTERPRETER_AUTO_UPDATE) {
            Log.toLogFile((Object)this, (String)StringUtils.format((String)"Found: %s modules", (Object[])new Object[]{keysFound.size()}));
        }
        if ((ret = this.checkEarlyReturn(monitor, info)) != IInterpreterInfoBuilder.BuilderResult.OK) {
            return ret;
        }
        try {
            Object builtins;
            if (info != null && (builtins = info.getBuiltins()) != null) {
                int i = 0;
                while (i < ((String[])builtins).length) {
                    String name = builtins[i];
                    ModulesKey k = new ModulesKey(name, null);
                    keysFound.put((Object)k, (Object)k);
                    ++i;
                }
            }
            builtins = additionalInfo.updateKeysLock;
            synchronized (builtins) {
                Tuple diffModules = modulesManager.diffModules((AbstractMap)keysFound);
                if (((List)diffModules.o1).size() > 0 || ((List)diffModules.o2).size() > 0) {
                    if (DebugSettings.DEBUG_INTERPRETER_AUTO_UPDATE) {
                        Log.toLogFile((Object)this, (String)StringUtils.format((String)"Diff modules. Added: %s Removed: %s", (Object[])new Object[]{diffModules.o1, diffModules.o2}));
                    }
                    if (modulesManager instanceof SystemModulesManager) {
                        ((SystemModulesManager)modulesManager).updateKeysAndSave(keysFound);
                    } else {
                        for (ModulesKey newEntry : (List)diffModules.o1) {
                            modulesManager.addModule(newEntry);
                        }
                        modulesManager.removeModules((Collection)diffModules.o2);
                    }
                }
                additionalInfo.updateKeysIfNeededAndSave((PyPublicTreeMap<ModulesKey, ModulesKey>)keysFound, info, monitor);
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        if (DebugSettings.DEBUG_INTERPRETER_AUTO_UPDATE) {
            Log.toLogFile((Object)this, (String)"--- End Run");
        }
        return IInterpreterInfoBuilder.BuilderResult.OK;
    }

    private IInterpreterInfoBuilder.BuilderResult checkEarlyReturn(IProgressMonitor monitor, InterpreterInfo info) {
        if (monitor.isCanceled()) {
            if (DebugSettings.DEBUG_INTERPRETER_AUTO_UPDATE) {
                Log.toLogFile((Object)this, (String)"Cancelled");
            }
            return IInterpreterInfoBuilder.BuilderResult.ABORTED;
        }
        if (info != null && !info.getLoadFinished()) {
            if (DebugSettings.DEBUG_INTERPRETER_AUTO_UPDATE) {
                Log.toLogFile((Object)this, (String)"Load not finished (rescheduling)");
            }
            Log.log((String)"The interpreter sync was cancelled (scheduling for checking the integrity later on again).\nTo prevent any scheduling (at the cost of possible index corruptions),\nuncheck the setting at Preferences > PyDev > Interpreters.");
            return IInterpreterInfoBuilder.BuilderResult.MUST_SYNCH_LATER;
        }
        return IInterpreterInfoBuilder.BuilderResult.OK;
    }
}

