/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.builder;

import com.python.pydev.analysis.builder.AnalysisBuilderRunnable;
import com.python.pydev.analysis.builder.AnalysisBuilderRunnableForRemove;
import com.python.pydev.analysis.builder.IAnalysisBuilderRunnable;
import com.python.pydev.analysis.builder.KeyForAnalysisRunnable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.builder.PyDevBuilderPrefPage;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.logging.DebugSettings;
import org.python.pydev.shared_core.cache.LRUCache;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.structure.Tuple;

public class AnalysisBuilderRunnableFactory {
    private static volatile Map<KeyForAnalysisRunnable, IAnalysisBuilderRunnable> availableThreads;
    private static volatile LRUCache<KeyForAnalysisRunnable, Tuple<Long, Long>> analysisTimeCache;
    private static final Object lock;
    private static final int DELTA_TO_CONSIDER_SAME = 500;

    static {
        analysisTimeCache = new LRUCache(100);
        lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<KeyForAnalysisRunnable, IAnalysisBuilderRunnable> getAvailableThreads() {
        Object object = lock;
        synchronized (object) {
            if (availableThreads == null) {
                availableThreads = new HashMap<KeyForAnalysisRunnable, IAnalysisBuilderRunnable>();
            }
            return availableThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeFromThreads(KeyForAnalysisRunnable key, IAnalysisBuilderRunnable runnable) {
        Object object = lock;
        synchronized (object) {
            Map<KeyForAnalysisRunnable, IAnalysisBuilderRunnable> available = AnalysisBuilderRunnableFactory.getAvailableThreads();
            IAnalysisBuilderRunnable analysisBuilderThread = available.get(key);
            if (analysisBuilderThread == runnable) {
                available.remove(key);
            }
        }
    }

    private static void logCreate(String moduleName, IAnalysisBuilderRunnable analysisBuilderThread, String factory) {
        if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
            Log.toLogFile((Object)analysisBuilderThread, (String)("Created new builder: " + analysisBuilderThread + " for:" + moduleName + " -- " + analysisBuilderThread.getAnalysisCauseStr() + " -- " + factory));
        }
    }

    private static void logStop(IAnalysisBuilderRunnable oldAnalysisBuilderThread, String creation) {
        if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
            Log.toLogFile((Object)oldAnalysisBuilderThread, (String)("Stopping previous builder: " + oldAnalysisBuilderThread + " (" + oldAnalysisBuilderThread.getModuleName() + " -- " + oldAnalysisBuilderThread.getAnalysisCauseStr() + ") to create new. " + creation));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyForAnalysisRunnable areNatureAndProjectAndTimeOK(IPythonNature nature, String moduleName, long documentTime, Map<KeyForAnalysisRunnable, IAnalysisBuilderRunnable> available, long resourceModificationStamp, int analysisCause) {
        Object object = lock;
        synchronized (object) {
            KeyForAnalysisRunnable analysisKey;
            block10: {
                long oldResourceTime;
                long oldDocTime;
                IAnalysisBuilderRunnable oldAnalysisBuilderThread;
                block9: {
                    IProject project;
                    block8: {
                        block7: {
                            if (nature != null) break block7;
                            return null;
                        }
                        project = nature.getProject();
                        if (project != null && project.isOpen()) break block8;
                        return null;
                    }
                    analysisKey = new KeyForAnalysisRunnable(project.getName(), moduleName, analysisCause);
                    oldAnalysisBuilderThread = available.get(analysisKey);
                    if (oldAnalysisBuilderThread == null || AnalysisBuilderRunnableFactory.checkTimesOk(oldAnalysisBuilderThread, oldAnalysisBuilderThread.getDocumentTime(), documentTime, oldAnalysisBuilderThread.getResourceModificationStamp(), resourceModificationStamp)) break block9;
                    return null;
                }
                Tuple lastTime = (Tuple)analysisTimeCache.getObj((Object)analysisKey);
                if (lastTime == null || AnalysisBuilderRunnableFactory.checkTimesOk(oldAnalysisBuilderThread, oldDocTime = ((Long)lastTime.o1).longValue(), documentTime, oldResourceTime = ((Long)lastTime.o2).longValue(), resourceModificationStamp)) break block10;
                return null;
            }
            analysisTimeCache.add((Object)analysisKey, (Object)new Tuple((Object)documentTime, (Object)resourceModificationStamp));
            return analysisKey;
        }
    }

    private static boolean checkTimesOk(IAnalysisBuilderRunnable oldAnalysisBuilderThread, long oldDocTime, long documentTime, long oldResourceStamp, long resourceStamp) {
        if (oldAnalysisBuilderThread != null && oldDocTime > documentTime - 500L) {
            if (oldResourceStamp != resourceStamp) {
                if (oldResourceStamp == -1L || resourceStamp == -1L) {
                    return true;
                }
                if (resourceStamp > oldResourceStamp) {
                    return true;
                }
            }
            if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                Log.toLogFile((Object)oldAnalysisBuilderThread, (String)AnalysisBuilderRunnableFactory.createExistinTimeHigherMessage(oldDocTime, documentTime, oldResourceStamp, resourceStamp));
            }
            return false;
        }
        return true;
    }

    private static String createExistinTimeHigherMessage(long oldTime, long documentTime, long oldResourceTime, long resourceTime) {
        return "The document time from an existing is higher than a new one, so, leave it be... " + oldTime + " > " + documentTime + " - " + 500 + " (delta to consider equal) -- resource stamp (old, new): " + oldResourceTime + ", " + resourceTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IAnalysisBuilderRunnable createRunnable(IDocument document, IResource resource, ICallback<IModule, Integer> module, boolean isFullBuild, String moduleName, boolean forceAnalysis, int analysisCause, IPythonNature nature, long documentTime, long resourceModificationStamp) {
        Object object = lock;
        synchronized (object) {
            KeyForAnalysisRunnable analysisKey;
            Map<KeyForAnalysisRunnable, IAnalysisBuilderRunnable> available;
            block7: {
                available = AnalysisBuilderRunnableFactory.getAvailableThreads();
                analysisKey = AnalysisBuilderRunnableFactory.areNatureAndProjectAndTimeOK(nature, moduleName, documentTime, available, resourceModificationStamp, analysisCause);
                if (analysisKey != null) break block7;
                return null;
            }
            IAnalysisBuilderRunnable oldAnalysisBuilderThread = available.get(analysisKey);
            if (oldAnalysisBuilderThread != null) {
                oldAnalysisBuilderThread.stopAnalysis();
                AnalysisBuilderRunnableFactory.logStop(oldAnalysisBuilderThread, "Factory: changed");
                if (!forceAnalysis && (forceAnalysis = oldAnalysisBuilderThread.getForceAnalysis()) && DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                    Log.toLogFile((Object)oldAnalysisBuilderThread, (String)"Now forcing analysis because old one, which didn't finish was forced!");
                }
                if (!forceAnalysis && PyDevBuilderPrefPage.getAnalyzeOnlyActiveEditor() && analysisCause == 1 && oldAnalysisBuilderThread.getAnalysisCause() != 1) {
                    forceAnalysis = true;
                }
            }
            AnalysisBuilderRunnable analysisBuilderThread = new AnalysisBuilderRunnable(document, resource, module, isFullBuild, moduleName, forceAnalysis, analysisCause, oldAnalysisBuilderThread, nature, documentTime, analysisKey, resourceModificationStamp);
            AnalysisBuilderRunnableFactory.logCreate(moduleName, analysisBuilderThread, "Factory: changed");
            available.put(analysisKey, analysisBuilderThread);
            return analysisBuilderThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IAnalysisBuilderRunnable createRunnable(String moduleName, IPythonNature nature, boolean fullBuild, boolean forceAnalysis, int analysisCause, long documentTime, long resourceModificationStamp) {
        Object object = lock;
        synchronized (object) {
            KeyForAnalysisRunnable analysisKey;
            Map<KeyForAnalysisRunnable, IAnalysisBuilderRunnable> available;
            block5: {
                available = AnalysisBuilderRunnableFactory.getAvailableThreads();
                analysisKey = AnalysisBuilderRunnableFactory.areNatureAndProjectAndTimeOK(nature, moduleName, documentTime, available, resourceModificationStamp, analysisCause);
                if (analysisKey != null) break block5;
                return null;
            }
            IAnalysisBuilderRunnable oldAnalysisBuilderThread = available.get(analysisKey);
            if (oldAnalysisBuilderThread != null) {
                oldAnalysisBuilderThread.stopAnalysis();
                AnalysisBuilderRunnableFactory.logStop(oldAnalysisBuilderThread, "Factory: remove");
            }
            AnalysisBuilderRunnableForRemove analysisBuilderThread = new AnalysisBuilderRunnableForRemove(moduleName, nature, fullBuild, oldAnalysisBuilderThread, forceAnalysis, analysisCause, documentTime, analysisKey, resourceModificationStamp);
            AnalysisBuilderRunnableFactory.logCreate(moduleName, analysisBuilderThread, "Factory: remove");
            available.put(analysisKey, analysisBuilderThread);
            return analysisBuilderThread;
        }
    }
}

