/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.builder;

import com.python.pydev.analysis.builder.AnalysisBuilderRunnableFactory;
import com.python.pydev.analysis.builder.IAnalysisBuilderRunnable;
import com.python.pydev.analysis.builder.KeyForAnalysisRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.logging.DebugSettings;

public abstract class AbstractAnalysisBuilderRunnable
implements IAnalysisBuilderRunnable {
    protected IProgressMonitor monitorSetExternally;
    protected final IProgressMonitor internalCancelMonitor = new NullProgressMonitor(){

        public final boolean isCanceled() {
            if (super.isCanceled()) {
                return true;
            }
            IProgressMonitor ext = AbstractAnalysisBuilderRunnable.this.monitorSetExternally;
            return ext != null && ext.isCanceled();
        }
    };
    protected final String moduleName;
    protected final boolean isFullBuild;
    protected final boolean forceAnalysis;
    protected final int analysisCause;
    protected final KeyForAnalysisRunnable key;
    private final Object lock = new Object();
    protected IPythonNature nature;
    protected volatile boolean runFinished = false;
    private IAnalysisBuilderRunnable oldAnalysisBuilderThread;
    private long documentTime;
    private long resourceModificationStamp;
    private static final OperationCanceledException operationCanceledException = new OperationCanceledException();

    public void setMonitor(IProgressMonitor monitor) {
        this.monitorSetExternally = monitor;
    }

    public AbstractAnalysisBuilderRunnable(boolean isFullBuild, String moduleName, boolean forceAnalysis, int analysisCause, IAnalysisBuilderRunnable oldAnalysisBuilderThread, IPythonNature nature, long documentTime, KeyForAnalysisRunnable key, long resourceModificationStamp) {
        this.isFullBuild = isFullBuild;
        this.moduleName = moduleName;
        this.forceAnalysis = forceAnalysis;
        this.analysisCause = analysisCause;
        this.oldAnalysisBuilderThread = oldAnalysisBuilderThread;
        this.nature = nature;
        this.documentTime = documentTime;
        this.key = key;
        this.resourceModificationStamp = resourceModificationStamp;
    }

    @Override
    public long getDocumentTime() {
        return this.documentTime;
    }

    @Override
    public long getResourceModificationStamp() {
        return this.resourceModificationStamp;
    }

    @Override
    public int getAnalysisCause() {
        return this.analysisCause;
    }

    @Override
    public boolean getForceAnalysis() {
        return this.forceAnalysis;
    }

    @Override
    public synchronized boolean getRunFinished() {
        return this.runFinished;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public String getAnalysisCauseStr() {
        String analysisCauseStr = this.analysisCause == 1 ? "Builder" : (this.analysisCause == 2 ? "Parser" : "Unknown?");
        return analysisCauseStr;
    }

    protected void logOperationCancelled() {
        if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
            Log.toLogFile((Object)this, (String)("OperationCanceledException: cancelled by new runnable -- " + this.moduleName + ". Cancelled was from: " + this.getAnalysisCauseStr()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            try {
                try {
                    if (this.oldAnalysisBuilderThread != null) {
                        if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                            Log.toLogFile((Object)this, (String)"Waiting for other to be finished...");
                        }
                        this.oldAnalysisBuilderThread.stopAnalysis();
                        int attempts = 0;
                        while (!this.oldAnalysisBuilderThread.getRunFinished()) {
                            ++attempts;
                            Object object = this.lock;
                            synchronized (object) {
                                try {
                                    Thread.sleep(50L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                        if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                            Log.toLogFile((Object)this, (String)("Starting analysis after attempts: " + attempts));
                        }
                    }
                    this.oldAnalysisBuilderThread = null;
                    if (!this.internalCancelMonitor.isCanceled()) {
                        this.doAnalysis();
                    } else {
                        this.logOperationCancelled();
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
            }
            catch (Exception e) {
                block32: {
                    Log.log((Throwable)e);
                    try {
                        try {
                            AnalysisBuilderRunnableFactory.removeFromThreads(this.key, this);
                        }
                        catch (Throwable e2) {
                            Log.log((Throwable)e2);
                            this.runFinished = true;
                            break block32;
                        }
                    }
                    catch (Throwable throwable) {
                        this.runFinished = true;
                        throw throwable;
                    }
                    this.runFinished = true;
                }
                this.dispose();
            }
        }
        finally {
            block34: {
                try {
                    try {
                        AnalysisBuilderRunnableFactory.removeFromThreads(this.key, this);
                    }
                    catch (Throwable e) {
                        Log.log((Throwable)e);
                        this.runFinished = true;
                        break block34;
                    }
                }
                catch (Throwable throwable) {
                    this.runFinished = true;
                    throw throwable;
                }
                this.runFinished = true;
            }
            this.dispose();
        }
    }

    protected void dispose() {
        this.nature = null;
        this.oldAnalysisBuilderThread = null;
    }

    protected abstract void doAnalysis();

    @Override
    public synchronized void stopAnalysis() {
        this.internalCancelMonitor.setCanceled(true);
    }

    protected void checkStop() {
        if (this.internalCancelMonitor.isCanceled()) {
            throw operationCanceledException;
        }
    }
}

