/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo;

import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.IReferenceSearches;
import com.python.pydev.analysis.system_info_builder.InterpreterInfoBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.ModulesKeyForZip;
import org.python.pydev.core.cache.CompleteIndexKey;
import org.python.pydev.core.cache.DiskCache;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.ModulesKeyForJava;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.index.IndexApi;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.OrderedMap;
import org.python.pydev.shared_ui.utils.AsynchronousProgressMonitorWrapper;

public class ReferenceSearchesLucene
implements IReferenceSearches {
    private static final Object lock = new Object();
    private static final Map<File, IndexApi> indexDirToApi = new HashMap<File, IndexApi>();
    private static final boolean DEBUG = false;
    private WeakReference<AbstractAdditionalDependencyInfo> abstractAdditionalDependencyInfo;
    private IndexApi indexApi;
    private final Map<IProject, Long> projectToLastMtime = new HashMap<IProject, Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeAll() {
        Object object = lock;
        synchronized (object) {
            try {
                Set<Map.Entry<File, IndexApi>> entrySet = indexDirToApi.entrySet();
                for (Map.Entry<File, IndexApi> entry : entrySet) {
                    try {
                        entry.getValue().dispose();
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
            }
            finally {
                indexDirToApi.clear();
            }
        }
    }

    public ReferenceSearchesLucene(AbstractAdditionalDependencyInfo abstractAdditionalDependencyInfo) {
        this.abstractAdditionalDependencyInfo = new WeakReference<AbstractAdditionalDependencyInfo>(abstractAdditionalDependencyInfo);
    }

    @Override
    public void dispose() {
        if (this.indexApi != null) {
            this.indexApi = null;
        }
    }

    @Override
    public synchronized List<ModulesKey> search(IProject project, OrderedMap<String, Set<String>> fieldNameToValues, IProgressMonitor monitor) throws OperationCanceledException {
        try {
            if (!(monitor instanceof AsynchronousProgressMonitorWrapper)) {
                monitor = new AsynchronousProgressMonitorWrapper(monitor);
            }
            List<ModulesKey> list = this.internalSearch(project, fieldNameToValues, monitor);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List<ModulesKey> internalSearch(IProject project, OrderedMap<String, Set<String>> fieldNameToValues, IProgressMonitor monitor) throws OperationCanceledException {
        final ArrayList<ModulesKey> ret = new ArrayList<ModulesKey>();
        PythonNature nature = PythonNature.getPythonNature((IProject)project);
        if (nature == null) {
            Log.log((String)("Project :" + project + " does not have Python nature configured."));
            return ret;
        }
        AbstractAdditionalDependencyInfo abstractAdditionalDependencyInfo = (AbstractAdditionalDependencyInfo)this.abstractAdditionalDependencyInfo.get();
        if (abstractAdditionalDependencyInfo == null) {
            Log.log((String)"AbstractAdditionalDependencyInfo already collected!");
            return ret;
        }
        Long lastMtime = this.projectToLastMtime.get(project);
        if (lastMtime == null) {
            lastMtime = 0L;
        }
        long currMtime = nature.getMtime();
        if (lastMtime != currMtime) {
            this.projectToLastMtime.put(project, currMtime);
            Object timer = null;
            new InterpreterInfoBuilder().syncInfoToPythonPath(monitor, (IPythonNature)nature);
        }
        boolean mustCommitChange = false;
        String name = "Search modules with token in: " + abstractAdditionalDependencyInfo.getUIRepresentation();
        monitor.beginTask(name, 7);
        monitor.setTaskName(name);
        DiskCache completeIndex = abstractAdditionalDependencyInfo.completeIndex;
        boolean applyAllDeletes = false;
        if (this.indexApi == null) {
            String folderToPersist = completeIndex.getFolderToPersist();
            Object object = lock;
            synchronized (object) {
                File indexDir = new File(folderToPersist, "lc");
                this.indexApi = indexDirToApi.get(indexDir);
                if (this.indexApi == null) {
                    try {
                        this.indexApi = new IndexApi(indexDir, applyAllDeletes);
                        indexDirToApi.put(indexDir, this.indexApi);
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                        return ret;
                    }
                }
            }
        }
        Object object = this.indexApi.getLock();
        synchronized (object) {
            Object keyIndexModule;
            final HashMap indexMap = new HashMap();
            Object visitor = new IndexApi.IDocumentsVisitor(){

                public void visit(IndexApi.DocumentInfo documentInfo) {
                    ModulesKey keyFromIO = ModulesKey.fromIO((String)documentInfo.get("modules_key"));
                    String modifiedTime = documentInfo.get("mod_time");
                    indexMap.put(keyFromIO, new CompleteIndexKey(keyFromIO, Long.parseLong(modifiedTime)));
                }
            };
            try {
                this.indexApi.visitAllDocs(visitor, new String[]{"modules_key", "mod_time"});
            }
            catch (IOException e) {
                Log.log((Throwable)e);
            }
            this.incrementAndCheckProgress("Visited current index", monitor);
            HashSet<CompleteIndexKey> docsToRemove = new HashSet<CompleteIndexKey>();
            HashSet<CompleteIndexKey> modulesToAdd = new HashSet<CompleteIndexKey>();
            HashMap<File, Set<CompleteIndexKey>> zipModulesToAdd = new HashMap<File, Set<CompleteIndexKey>>();
            abstractAdditionalDependencyInfo.waitForIntegrityCheck();
            final Map currentKeys = completeIndex.keys();
            for (Map.Entry entryInIndex : indexMap.entrySet()) {
                boolean indexIsZip;
                ModulesKey keyCurrentModule;
                boolean currentIsZip22;
                boolean changed;
                CompleteIndexKey indexModule = (CompleteIndexKey)entryInIndex.getValue();
                CompleteIndexKey currentModule = (CompleteIndexKey)currentKeys.get(indexModule);
                if (currentModule == null || currentModule.key == null || currentModule.key.file == null) {
                    docsToRemove.add(indexModule);
                    continue;
                }
                boolean bl = changed = currentModule.lastModified != indexModule.lastModified;
                if (!changed && !(changed = (currentIsZip22 = (keyCurrentModule = currentModule.key) instanceof ModulesKeyForZip) ^ (indexIsZip = (keyIndexModule = indexModule.key) instanceof ModulesKeyForZip))) {
                    boolean bl2 = changed = !currentModule.key.file.equals(indexModule.key.file);
                }
                if (!changed) continue;
                docsToRemove.add(indexModule);
                this.add(modulesToAdd, zipModulesToAdd, currentModule);
            }
            this.incrementAndCheckProgress("Updating for removal", monitor);
            for (Map.Entry currentEntry : currentKeys.entrySet()) {
                ModulesKey modulesKey;
                CompleteIndexKey completeIndexKey = (CompleteIndexKey)currentEntry.getValue();
                if (indexMap.containsKey(completeIndexKey.key) || (modulesKey = completeIndexKey.key) instanceof ModulesKeyForJava || modulesKey.file == null || !modulesKey.file.isFile()) continue;
                if (modulesKey instanceof ModulesKeyForZip) {
                    ModulesKeyForZip modulesKeyForZip = (ModulesKeyForZip)modulesKey;
                    if (!modulesKeyForZip.isFile) continue;
                }
                this.add(modulesToAdd, zipModulesToAdd, completeIndexKey);
            }
            this.incrementAndCheckProgress("Updating for addition", monitor);
            HashMap fieldToValuesToRemove = new HashMap();
            ArrayList<String> lstToRemove = new ArrayList<String>(docsToRemove.size());
            FastStringBuffer tempBuf = new FastStringBuffer();
            Iterator it = docsToRemove.iterator();
            while (it.hasNext()) {
                ((CompleteIndexKey)it.next()).key.toIO(tempBuf.clear());
                lstToRemove.add(tempBuf.toString());
            }
            this.incrementAndCheckProgress("Removing outdated entries", monitor);
            if (lstToRemove.size() > 0) {
                fieldToValuesToRemove.put("modules_key", lstToRemove);
                try {
                    mustCommitChange = true;
                    this.indexApi.removeDocs(fieldToValuesToRemove);
                }
                catch (IOException e) {
                    Log.log((Throwable)e);
                }
            }
            this.incrementAndCheckProgress("Indexing new entries", monitor);
            if (modulesToAdd.size() > 0) {
                mustCommitChange = true;
                for (CompleteIndexKey key : modulesToAdd) {
                    File f = key.key.file;
                    if (!f.exists()) continue;
                    try {
                        keyIndexModule = null;
                        Object currentIsZip22 = null;
                        try (BufferedReader reader = new BufferedReader(new FileReader(f));){
                            this.indexApi.index(this.createFieldsToIndex(key, tempBuf), (Reader)reader, "contents");
                        }
                        catch (Throwable currentIsZip22) {
                            if (keyIndexModule == null) {
                                keyIndexModule = currentIsZip22;
                            } else if (keyIndexModule != currentIsZip22) {
                                ((Throwable)keyIndexModule).addSuppressed(currentIsZip22);
                            }
                            throw keyIndexModule;
                        }
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
            }
            Set entrySet = zipModulesToAdd.entrySet();
            for (Map.Entry entry : entrySet) {
                File f = (File)entry.getKey();
                if (!f.exists()) continue;
                try {
                    Throwable currentIsZip22 = null;
                    Object var29_47 = null;
                    try (ZipFile zipFile = new ZipFile(f, 1);){
                        Set value = (Set)entry.getValue();
                        for (CompleteIndexKey completeIndexKey2 : value) {
                            ModulesKeyForZip forZip = (ModulesKeyForZip)completeIndexKey2.key;
                            Throwable throwable = null;
                            Object var36_56 = null;
                            try (InputStream inputStream = zipFile.getInputStream(zipFile.getEntry(forZip.zipModulePath));){
                                InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                                mustCommitChange = true;
                                this.indexApi.index(this.createFieldsToIndex(completeIndexKey2, tempBuf), (Reader)reader, "contents");
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (currentIsZip22 == null) {
                            currentIsZip22 = throwable;
                        } else if (currentIsZip22 != throwable) {
                            currentIsZip22.addSuppressed(throwable);
                        }
                        throw currentIsZip22;
                    }
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
            this.incrementAndCheckProgress("Committing result", monitor);
            if (mustCommitChange) {
                try {
                    this.indexApi.commit();
                }
                catch (IOException e) {
                    Log.log((Throwable)e);
                }
            }
            this.incrementAndCheckProgress("Searching index", monitor);
            try {
                visitor = new IndexApi.IDocumentsVisitor(){

                    public void visit(IndexApi.DocumentInfo documentInfo) {
                        try {
                            ModulesKey fromIO;
                            CompleteIndexKey existing;
                            String modKey = documentInfo.get("modules_key");
                            String modTime = documentInfo.get("mod_time");
                            if (modKey != null && modTime != null && (existing = (CompleteIndexKey)currentKeys.get(new CompleteIndexKey(fromIO = ModulesKey.fromIO((String)modKey)))) != null && existing.lastModified == Long.parseLong(modTime)) {
                                ret.add(existing.key);
                            }
                        }
                        catch (Exception e) {
                            Log.log((Throwable)e);
                        }
                    }
                };
                this.indexApi.searchWildcard(fieldNameToValues, applyAllDeletes, visitor, null, new String[]{"modules_key", "mod_time"});
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        return ret;
    }

    private void incrementAndCheckProgress(String msg, IProgressMonitor monitor) throws OperationCanceledException {
        monitor.worked(1);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public Map<String, String> createFieldsToIndex(CompleteIndexKey key, FastStringBuffer buf) {
        key.key.toIO(buf.clear());
        HashMap<String, String> fieldsToIndex = new HashMap<String, String>();
        fieldsToIndex.put("modules_key", buf.toString());
        fieldsToIndex.put("module_name", key.key.name);
        fieldsToIndex.put("mod_time", String.valueOf(key.lastModified));
        return fieldsToIndex;
    }

    public void add(Set<CompleteIndexKey> modulesToAdd, Map<File, Set<CompleteIndexKey>> zipModulesToAdd, CompleteIndexKey currentModule) {
        if (currentModule.key instanceof ModulesKeyForZip) {
            Set<CompleteIndexKey> set = zipModulesToAdd.get(currentModule.key.file);
            if (set == null) {
                set = new HashSet<CompleteIndexKey>();
                zipModulesToAdd.put(currentModule.key.file, set);
            }
            set.add(currentModule);
        } else {
            modulesToAdd.add(currentModule);
        }
    }
}

