/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.actions;

import com.python.pydev.analysis.AnalysisPlugin;
import com.python.pydev.analysis.actions.AdditionalInfoAndIInfo;
import com.python.pydev.analysis.actions.NameIInfoLabelProvider;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalSystemInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.IInfo;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.string.FastStringBuffer;

public final class ModuleIInfoLabelProvider
extends LabelProvider {
    public String getText(Object element) {
        if (element instanceof AdditionalInfoAndIInfo) {
            AdditionalInfoAndIInfo additional = (AdditionalInfoAndIInfo)element;
            element = additional.info;
            String suffix = null;
            try {
                if (additional.additionalInfo instanceof AdditionalProjectInterpreterInfo) {
                    AdditionalProjectInterpreterInfo projectInterpreterInfo = (AdditionalProjectInterpreterInfo)additional.additionalInfo;
                    suffix = projectInterpreterInfo.getProject().getName();
                } else if (additional.additionalInfo instanceof AdditionalSystemInterpreterInfo) {
                    AdditionalSystemInterpreterInfo systemInterpreterInfo = (AdditionalSystemInterpreterInfo)additional.additionalInfo;
                    suffix = systemInterpreterInfo.getManager().getDefaultInterpreterInfo(false).getName();
                }
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
            String iInfoText = this.getIInfoText((IInfo)element, suffix);
            return iInfoText;
        }
        if (element instanceof String) {
            return (String)element;
        }
        return this.getIInfoText((IInfo)element, null);
    }

    private String getIInfoText(IInfo info, String suffix) {
        int pathLen;
        String path = info.getPath();
        if (path != null && (pathLen = path.length()) > 0) {
            int suffixLen = suffix != null ? suffix.length() + 5 : 0;
            FastStringBuffer buf = new FastStringBuffer(info.getDeclaringModuleName(), pathLen + 5 + suffixLen).append("/").append(path);
            if (suffix != null) {
                return buf.append("   (").append(suffix).append(")").toString();
            }
            return buf.toString();
        }
        String declaringModuleName = info.getDeclaringModuleName();
        if (suffix != null) {
            return new FastStringBuffer(declaringModuleName, suffix.length() + 6).append("   (").append(suffix).append(")").toString();
        }
        return declaringModuleName;
    }

    public Image getImage(Object element) {
        IInfo info = NameIInfoLabelProvider.getInfo(element);
        if (info == null) {
            return null;
        }
        return AnalysisPlugin.getImageForTypeInfo(info);
    }
}

