/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.coderefactoring.extractmethod.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.text.ITextSelection;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.refactoring.ast.adapters.AbstractScopeNode;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.ast.adapters.SimpleAdapter;

public class ParameterReturnDeduce {
    private List<String> parameters;
    private Collection<String> returns;
    private AbstractScopeNode<?> scopeAdapter;
    private ITextSelection selection;
    private ModuleAdapter moduleAdapter;

    public ParameterReturnDeduce(AbstractScopeNode<?> scope, ITextSelection selection, ModuleAdapter moduleAdapter) {
        this.scopeAdapter = scope;
        this.selection = selection;
        this.parameters = new ArrayList<String>();
        this.returns = new LinkedHashSet<String>();
        this.moduleAdapter = moduleAdapter;
        this.deduce();
    }

    private void deduce() {
        ModuleAdapter module = this.scopeAdapter.getModule();
        List<SimpleAdapter> selected = module.getWithinSelection(this.selection, this.scopeAdapter.getUsedVariables());
        ArrayList<SimpleAdapter> before = new ArrayList<SimpleAdapter>();
        ArrayList<SimpleAdapter> after = new ArrayList<SimpleAdapter>();
        this.extractBeforeAfterVariables(selected, before, after);
        this.deduceParameters(before, selected);
        this.deduceReturns(after, selected);
    }

    private void deduceParameters(List<SimpleAdapter> before, List<SimpleAdapter> selected) {
        HashSet<String> globalVariableNames = new HashSet<String>(this.moduleAdapter.getGlobalVariableNames());
        for (SimpleAdapter adapter : before) {
            String id;
            Name variable;
            Object astNode = adapter.getASTNode();
            if (astNode instanceof Name) {
                variable = (Name)astNode;
                id = variable.id;
            } else {
                if (!(astNode instanceof NameTok)) continue;
                variable = (NameTok)astNode;
                id = variable.id;
            }
            if (globalVariableNames.contains(id) && !this.isStored(id, before) || id.equals("True") || id.equals("False") || id.equals("None") || !this.isUsed(id, selected) || this.parameters.contains(id)) continue;
            this.parameters.add(id);
        }
    }

    private void deduceReturns(List<SimpleAdapter> after, List<SimpleAdapter> selected) {
        for (SimpleAdapter adapter : after) {
            String id;
            Name variable;
            Object astNode = adapter.getASTNode();
            if (astNode instanceof Name) {
                variable = (Name)astNode;
                id = variable.id;
            } else {
                if (!(astNode instanceof NameTok)) continue;
                variable = (NameTok)astNode;
                id = variable.id;
            }
            if (!this.isStored(id, selected)) continue;
            this.returns.add(id);
        }
    }

    private void extractBeforeAfterVariables(List<SimpleAdapter> selectedVariables, List<SimpleAdapter> before, List<SimpleAdapter> after) {
        List<SimpleAdapter> scopeVariables = this.scopeAdapter.getUsedVariables();
        if (selectedVariables.isEmpty()) {
            return;
        }
        SimpleAdapter firstSelectedVariable = selectedVariables.get(0);
        SimpleAdapter lastSelectedVariable = selectedVariables.get(selectedVariables.size() - 1);
        for (SimpleAdapter adapter : scopeVariables) {
            if (this.isBeforeSelectedLine(firstSelectedVariable, adapter) || this.isBeforeOnSameLine(firstSelectedVariable, adapter)) {
                before.add(adapter);
                continue;
            }
            if (!this.isAfterSelectedLine(lastSelectedVariable, adapter) && !this.isAfterOnSameLine(lastSelectedVariable, adapter)) continue;
            after.add(adapter);
        }
    }

    private boolean isAfterOnSameLine(SimpleAdapter lastSelectedVariable, SimpleAdapter adapter) {
        return adapter.getNodeFirstLine() == lastSelectedVariable.getNodeFirstLine() && adapter.getNodeIndent() > lastSelectedVariable.getNodeIndent();
    }

    private boolean isAfterSelectedLine(SimpleAdapter lastSelectedVariable, SimpleAdapter adapter) {
        return adapter.getNodeFirstLine() > lastSelectedVariable.getNodeFirstLine();
    }

    private boolean isBeforeOnSameLine(SimpleAdapter firstSelectedVariable, SimpleAdapter adapter) {
        return adapter.getNodeFirstLine() == firstSelectedVariable.getNodeFirstLine() && adapter.getNodeIndent() < firstSelectedVariable.getNodeIndent();
    }

    private boolean isBeforeSelectedLine(SimpleAdapter firstSelectedVariable, SimpleAdapter adapter) {
        return adapter.getNodeFirstLine() < firstSelectedVariable.getNodeFirstLine();
    }

    private boolean isUsed(String var, List<SimpleAdapter> scopeVariables) {
        for (SimpleAdapter adapter : scopeVariables) {
            Object astNode = adapter.getASTNode();
            if (!(astNode instanceof Name)) continue;
            Name scopeVar = (Name)astNode;
            if (scopeVar.ctx != 1 && scopeVar.ctx != 4 || !scopeVar.id.equals(var)) continue;
            return true;
        }
        return false;
    }

    private boolean isStored(String var, List<SimpleAdapter> scopeVariables) {
        boolean isStored = false;
        for (SimpleAdapter adapter : scopeVariables) {
            Name scopeVar;
            Object astNode = adapter.getASTNode();
            if (astNode instanceof Name) {
                scopeVar = (Name)astNode;
                if (scopeVar.id.equals(var)) {
                    isStored = scopeVar.ctx != 1 && scopeVar.ctx != 4;
                }
            } else if (astNode instanceof NameTok) {
                scopeVar = (NameTok)astNode;
                if (scopeVar.id.equals(var)) {
                    isStored = true;
                }
            } else if (astNode instanceof Import) {
                Import importNode = (Import)astNode;
                isStored = this.checkNames(var, importNode.names);
            } else if (astNode instanceof ImportFrom) {
                ImportFrom importFrom = (ImportFrom)astNode;
                isStored = this.checkNames(var, importFrom.names);
            }
            if (isStored) break;
        }
        return isStored;
    }

    private boolean checkNames(String var, aliasType[] names) {
        boolean isStored = false;
        if (names != null) {
            aliasType[] aliasTypeArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                aliasType alias = aliasTypeArray[n2];
                if (alias.asname != null) {
                    isStored = this.nameMatches(var, alias.asname);
                } else if (alias.name != null) {
                    isStored = this.nameMatches(var, alias.name);
                }
                ++n2;
            }
        }
        return isStored;
    }

    private boolean nameMatches(String var, NameTokType asname) {
        return ((NameTok)asname).id.equals(var);
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public List<String> getReturns() {
        return new ArrayList<String>(this.returns);
    }
}

