/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast.adapters.offsetstrategy;

import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.jython.ISpecialStr;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.factory.AdapterPrefs;
import org.python.pydev.parser.visitors.FindLastLineVisitor;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.refactoring.ast.adapters.IASTNodeAdapter;
import org.python.pydev.refactoring.ast.adapters.offsetstrategy.AbstractOffsetStrategy;

public class BeginOffset
extends AbstractOffsetStrategy {
    public BeginOffset(IASTNodeAdapter<? extends SimpleNode> adapter, IDocument doc, AdapterPrefs adapterPrefs) {
        super(adapter, doc, adapterPrefs);
    }

    @Override
    protected int getLine() {
        int startLine;
        Object node = this.adapter.getASTNode();
        if (this.nodeHelper.isClassDef(node)) {
            ClassDef classNode = (ClassDef)node;
            Str strNode = NodeUtils.getNodeDocStringNode(node);
            if (strNode != null) {
                return NodeUtils.getLineEnd((SimpleNode)strNode);
            }
            FindLastLineVisitor findLastLineVisitor = new FindLastLineVisitor();
            try {
                classNode.name.accept((VisitorIF)findLastLineVisitor);
                if (classNode.bases != null) {
                    exprType[] exprTypeArray = classNode.bases;
                    int n = classNode.bases.length;
                    int n2 = 0;
                    while (n2 < n) {
                        exprType n3 = exprTypeArray[n2];
                        n3.accept((VisitorIF)findLastLineVisitor);
                        ++n2;
                    }
                }
                SimpleNode lastNode = findLastLineVisitor.getLastNode();
                ISpecialStr lastSpecialStr = findLastLineVisitor.getLastSpecialStr();
                if (lastSpecialStr != null && (lastSpecialStr.toString().equals(":") || lastSpecialStr.toString().equals(")"))) {
                    return lastSpecialStr.getBeginLine();
                }
                return lastNode.beginLine;
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        if ((startLine = this.adapter.getNodeFirstLine() - 1) < 0) {
            startLine = 0;
        }
        return startLine;
    }
}

