/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython.ast;

import java.util.Arrays;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.jython.ast.exprType;

public final class Dict
extends exprType {
    public exprType[] keys;
    public exprType[] values;

    public Dict(exprType[] keys, exprType[] values) {
        this.keys = keys;
        this.values = values;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.keys);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dict other = (Dict)obj;
        if (!Arrays.equals(this.keys, other.keys)) {
            return false;
        }
        return Arrays.equals(this.values, other.values);
    }

    @Override
    public Dict createCopy() {
        return this.createCopy(true);
    }

    @Override
    public Dict createCopy(boolean copyComments) {
        commentType commentType2;
        exprType[] new1;
        exprType[] new0;
        if (this.keys != null) {
            new0 = new exprType[this.keys.length];
            int i = 0;
            while (i < this.keys.length) {
                new0[i] = (exprType)(this.keys[i] != null ? this.keys[i].createCopy(copyComments) : null);
                ++i;
            }
        } else {
            new0 = this.keys;
        }
        if (this.values != null) {
            new1 = new exprType[this.values.length];
            int i = 0;
            while (i < this.values.length) {
                new1[i] = (exprType)(this.values[i] != null ? this.values[i].createCopy(copyComments) : null);
                ++i;
            }
        } else {
            new1 = this.values;
        }
        Dict temp = new Dict(new0, new1);
        temp.beginLine = this.beginLine;
        temp.beginColumn = this.beginColumn;
        if (this.specialsBefore != null && copyComments) {
            for (Object o : this.specialsBefore) {
                if (!(o instanceof commentType)) continue;
                commentType2 = (commentType)o;
                temp.getSpecialsBefore().add(commentType2.createCopy(copyComments));
            }
        }
        if (this.specialsAfter != null && copyComments) {
            for (Object o : this.specialsAfter) {
                if (!(o instanceof commentType)) continue;
                commentType2 = (commentType)o;
                temp.getSpecialsAfter().add(commentType2.createCopy(copyComments));
            }
        }
        return temp;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("Dict[");
        sb.append("keys=");
        sb.append(this.dumpThis(this.keys));
        sb.append(", ");
        sb.append("values=");
        sb.append(this.dumpThis(this.values));
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitDict(this);
    }

    @Override
    public void traverse(VisitorIF visitor) throws Exception {
        int i;
        if (this.keys != null) {
            i = 0;
            while (i < this.keys.length) {
                if (this.keys[i] != null) {
                    this.keys[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.values != null) {
            i = 0;
            while (i < this.values.length) {
                if (this.values[i] != null) {
                    this.values[i].accept(visitor);
                }
                ++i;
            }
        }
    }
}

