/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython.ast;

import java.util.Arrays;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.boolopType;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.jython.ast.exprType;

public final class BoolOp
extends exprType
implements boolopType {
    public int op;
    public exprType[] values;

    public BoolOp(int op, exprType[] values) {
        this.op = op;
        this.values = values;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.op;
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoolOp other = (BoolOp)obj;
        if (this.op != other.op) {
            return false;
        }
        return Arrays.equals(this.values, other.values);
    }

    @Override
    public BoolOp createCopy() {
        return this.createCopy(true);
    }

    @Override
    public BoolOp createCopy(boolean copyComments) {
        commentType commentType2;
        exprType[] new0;
        if (this.values != null) {
            new0 = new exprType[this.values.length];
            int i = 0;
            while (i < this.values.length) {
                new0[i] = (exprType)(this.values[i] != null ? this.values[i].createCopy(copyComments) : null);
                ++i;
            }
        } else {
            new0 = this.values;
        }
        BoolOp temp = new BoolOp(this.op, new0);
        temp.beginLine = this.beginLine;
        temp.beginColumn = this.beginColumn;
        if (this.specialsBefore != null && copyComments) {
            for (Object o : this.specialsBefore) {
                if (!(o instanceof commentType)) continue;
                commentType2 = (commentType)o;
                temp.getSpecialsBefore().add(commentType2.createCopy(copyComments));
            }
        }
        if (this.specialsAfter != null && copyComments) {
            for (Object o : this.specialsAfter) {
                if (!(o instanceof commentType)) continue;
                commentType2 = (commentType)o;
                temp.getSpecialsAfter().add(commentType2.createCopy(copyComments));
            }
        }
        return temp;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("BoolOp[");
        sb.append("op=");
        sb.append(this.dumpThis(this.op, boolopType.boolopTypeNames));
        sb.append(", ");
        sb.append("values=");
        sb.append(this.dumpThis(this.values));
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitBoolOp(this);
    }

    @Override
    public void traverse(VisitorIF visitor) throws Exception {
        if (this.values != null) {
            int i = 0;
            while (i < this.values.length) {
                if (this.values[i] != null) {
                    this.values[i].accept(visitor);
                }
                ++i;
            }
        }
    }
}

