eval('/*\n * Copyright (c) 2013 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */\n/*global require, define, window, brackets, navigator */\n\n/**\n * The bootstrapping module for brackets. This module sets up the require\n * configuration and loads the brackets module.\n */\nrequire.config({\n    paths: {\n        "text"              : "thirdparty/text/text",\n        "i18n"              : "thirdparty/i18n/i18n",\n\n        // The file system implementation. Change this value to use different\n        // implementations (e.g. cloud-based storage).\n        "fileSystemImpl"    : "filesystem/impls/appshell/AppshellFileSystem"\n    },\n    map: {\n        "*": {\n            "thirdparty/CodeMirror2": "thirdparty/CodeMirror"\n        }\n    }\n});\n\nif (window.location.search.indexOf("testEnvironment") > -1) {\n    require.config({\n        paths: {\n            "preferences/PreferencesImpl": "../test/TestPreferencesImpl"\n        },\n        locale: "en" // force English (US)\n    });\n} else {\n    /**\n     * hack for r.js optimization, move locale to another config call\n     *\n     * Use custom brackets property until CEF sets the correct navigator.language\n     * NOTE: When we change to navigator.language here, we also should change to\n     * navigator.language in ExtensionLoader (when making require contexts for each\n     * extension).\n     */\n    require.config({\n        locale: window.localStorage.getItem("locale") || (typeof (brackets) !== "undefined" ? brackets.app.language : navigator.language)\n    });\n}\n\ndefine(\'main\',[\'require\'],function (require) {\n    "use strict";\n\n    // Load compatibility shims--these need to load early, be careful moving this\n    require(["utils/Compatibility"], function () {\n        // Load the brackets module. This is a self-running module that loads and runs the entire application.\n        require(["brackets"]);\n    });\n});\n\n//# sourceURL=/main.js'),eval('/*\n * Copyright (c) 2014 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */\n/*global define */\n\n/**\n * Compatibility shims for running Brackets in various environments, browsers.\n */\ndefine(\'utils/Compatibility\',[],function () {\n    "use strict";\n\n    // [IE10] String.prototype missing trimRight() and trimLeft()\n    if (!String.prototype.trimRight) {\n        String.prototype.trimRight = function () { return this.replace(/\\s+$/, ""); };\n    }\n    if (!String.prototype.trimLeft) {\n        String.prototype.trimLeft = function () { return this.replace(/^\\s+/, ""); };\n    }\n\n    // Feature detection for Error.stack. Not all browsers expose it\n    // and Brackets assumes it will be a non-null string.\n    if (typeof (new Error()).stack === "undefined") {\n        Error.prototype.stack = "";\n    }\n\n});\n\n//# sourceURL=/utils/Compatibility.js'),eval('// path-utils.js - version 0.1\n// Copyright (c) 2011, Kin Blas\n// All rights reserved.\n// \n// Redistribution and use in source and binary forms, with or without\n// modification, are permitted provided that the following conditions are met:\n//     * Redistributions of source code must retain the above copyright\n//       notice, this list of conditions and the following disclaimer.\n//     * Redistributions in binary form must reproduce the above copyright\n//       notice, this list of conditions and the following disclaimer in the\n//       documentation and/or other materials provided with the distribution.\n//     * Neither the name of the <organization> nor the\n//       names of its contributors may be used to endorse or promote products\n//       derived from this software without specific prior written permission.\n// \n// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND\n// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\n// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\n// DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY\n// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES\n// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;\n// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND\n// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS\n// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n\n(function(l){function m(a){return function(e){return b.parseUrl(e)[a]}}var b={urlParseRE:/^(((([^:\\/#\\?]+:)?(?:(\\/\\/)((?:(([^:@\\/#\\?]+)(?:\\:([^:@\\/#\\?]+))?)@)?(([^:\\/#\\?\\]\\[]+|\\[[^\\/\\]@#?]+\\])(?:\\:([0-9]+))?))?)?)?((\\/?(?:[^\\/\\?#]+\\/+)*)([^\\?#\\.]*(?:\\.[^\\?#\\.]+)*(\\.[^\\?#\\.]+)|[^\\?#]*)))?(\\?[^#]+)?)(#.*)?/,parsedUrlPropNames:"href,hrefNoHash,hrefNoSearch,domain,protocol,doubleSlash,authority,userinfo,username,password,host,hostname,port,pathname,directory,filename,filenameExtension,search,hash".split(","),\ndefaultPorts:{http:"80",https:"443",ftp:"20",ftps:"990"},parseUrl:function(a){if(a&&typeof a==="object")return a;var a=b.urlParseRE.exec(a||"")||[],e=b.parsedUrlPropNames,c=e.length,f={},d;for(d=0;d<c;d++)f[e[d]]=a[d]||"";return f},port:function(a){a=b.parseUrl(a);return a.port||b.defaultPorts[a.protocol]},isSameDomain:function(a,e){return b.parseUrl(a).domain===b.parseUrl(e).domain},isRelativeUrl:function(a){return b.parseUrl(a).protocol===""},isAbsoluteUrl:function(a){return b.parseUrl(a).protocol!==\n""},makePathAbsolute:function(a,e){if(a&&a.charAt(0)==="/")return a;for(var a=a||"",c=(e=e?e.replace(/^\\/|(\\/[^\\/]*|[^\\/]+)$/g,""):"")?e.split("/"):[],b=a.split("/"),d=0;d<b.length;d++){var j=b[d];switch(j){case ".":break;case "..":c.length&&c.pop();break;default:c.push(j)}}return"/"+c.join("/")},makePathRelative:function(a,b){for(var b=b?b.replace(/^\\/|\\/?[^\\/]*$/g,""):"",a=a?a.replace(/^\\//,""):"",c=b?b.split("/"):[],f=a.split("/"),d=[],j=c.length,g=false,i=0;i<j;i++)(g=g||f[0]!==c[i])?d.push(".."):\nf.shift();return d.concat(f).join("/")},makeUrlAbsolute:function(a,e){if(!b.isRelativeUrl(a))return a;var c=b.parseUrl(a),f=b.parseUrl(e),d=c.protocol||f.protocol,g=c.protocol?c.doubleSlash:c.doubleSlash||f.doubleSlash,h=c.authority||f.authority,i=c.pathname!=="",k=b.makePathAbsolute(c.pathname||f.filename,f.pathname);return d+g+h+k+(c.search||!i&&f.search||"")+c.hash}},g,h,k=b.parsedUrlPropNames,n=k.length;for(g=0;g<n;g++)h=k[g],b[h]||(b[h]=m(h));l.PathUtils=b})(window);\n\n//# sourceURL=/thirdparty/path-utils/path-utils.min.js'),define("thirdparty/path-utils/path-utils.min",function(){}),eval("/* ============================================================\n * bootstrap-dropdown.js v2.3.1\n * http://twitter.github.com/bootstrap/javascript.html#dropdowns\n * ============================================================\n * Copyright 2012 Twitter, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n * ============================================================ */\n\n\n!function ($) {\n\n  \"use strict\"; // jshint ;_;\n\n\n /* DROPDOWN CLASS DEFINITION\n  * ========================= */\n\n  var toggle = '[data-toggle=dropdown]'\n    , Dropdown = function (element) {\n        var $el = $(element).on('click.dropdown.data-api', this.toggle)\n        $('html').on('click.dropdown.data-api', function () {\n          $el.parent().removeClass('open')\n        })\n      }\n\n  Dropdown.prototype = {\n\n    constructor: Dropdown\n\n  , toggle: function (e) {\n      var $this = $(this)\n        , $parent\n        , isActive\n\n      if ($this.is('.disabled, :disabled')) return\n\n      $parent = getParent($this)\n\n      isActive = $parent.hasClass('open')\n\n      clearMenus()\n\n      if (!isActive) {\n        $parent.toggleClass('open')\n      }\n\n      $this.focus()\n\n      return false\n    }\n\n  , keydown: function (e) {\n      var $this\n        , $items\n        , $active\n        , $parent\n        , isActive\n        , index\n\n      if (!/(38|40|27)/.test(e.keyCode)) return\n\n      $this = $(this)\n\n      e.preventDefault()\n      e.stopPropagation()\n\n      if ($this.is('.disabled, :disabled')) return\n\n      $parent = getParent($this)\n\n      isActive = $parent.hasClass('open')\n\n      if (!isActive || (isActive && e.keyCode == 27)) {\n        if (e.which == 27) $parent.find(toggle).focus()\n        return $this.click()\n      }\n\n      $items = $('[role=menu] li:not(.divider):visible a', $parent)\n\n      if (!$items.length) return\n\n      index = $items.index($items.filter(':focus'))\n\n      if (e.keyCode == 38 && index > 0) index--                                        // up\n      if (e.keyCode == 40 && index < $items.length - 1) index++                        // down\n      if (!~index) index = 0\n\n      $items\n        .eq(index)\n        .focus()\n    }\n\n  }\n\n  function clearMenus() {\n    $(toggle).each(function () {\n      getParent($(this)).removeClass('open')\n    })\n  }\n\n  function getParent($this) {\n    var selector = $this.attr('data-target')\n      , $parent\n\n    if (!selector) {\n      selector = $this.attr('href')\n      selector = selector && /#/.test(selector) && selector.replace(/.*(?=#[^\\s]*$)/, '') //strip for ie7\n    }\n\n    $parent = selector && $(selector)\n\n    if (!$parent || !$parent.length) $parent = $this.parent()\n\n    return $parent\n  }\n\n\n  /* DROPDOWN PLUGIN DEFINITION\n   * ========================== */\n\n  var old = $.fn.dropdown\n\n  $.fn.dropdown = function (option) {\n    return this.each(function () {\n      var $this = $(this)\n        , data = $this.data('dropdown')\n      if (!data) $this.data('dropdown', (data = new Dropdown(this)))\n      if (typeof option == 'string') data[option].call($this)\n    })\n  }\n\n  $.fn.dropdown.Constructor = Dropdown\n\n\n /* DROPDOWN NO CONFLICT\n  * ==================== */\n\n  $.fn.dropdown.noConflict = function () {\n    $.fn.dropdown = old\n    return this\n  }\n\n\n  /* APPLY TO STANDARD DROPDOWN ELEMENTS\n   * =================================== */\n\n  $(document)\n    .on('click.dropdown.data-api', clearMenus)\n    .on('click.dropdown.data-api', '.dropdown form', function (e) { e.stopPropagation() })\n    .on('click.dropdown-menu', function (e) { e.stopPropagation() })\n    .on('click.dropdown.data-api'  , toggle, Dropdown.prototype.toggle)\n    .on('keydown.dropdown.data-api', toggle + ', [role=menu]' , Dropdown.prototype.keydown)\n\n}(window.jQuery);\n\n//# sourceURL=/widgets/bootstrap-dropdown.js"),define("widgets/bootstrap-dropdown",function(){}),eval("/* =========================================================\n * bootstrap-modal.js v2.3.1\n * http://twitter.github.com/bootstrap/javascript.html#modals\n * =========================================================\n * Copyright 2012 Twitter, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n * ========================================================= */\n\n\n!function ($) {\n\n  \"use strict\"; // jshint ;_;\n\n\n /* MODAL CLASS DEFINITION\n  * ====================== */\n\n  var Modal = function (element, options) {\n    this.options = options\n    this.$element = $(element)\n      .delegate('[data-dismiss=\"modal\"]', 'click.dismiss.modal', $.proxy(this.hide, this))\n    this.options.remote && this.$element.find('.modal-body').load(this.options.remote)\n  }\n\n  Modal.prototype = {\n\n      constructor: Modal\n\n    , toggle: function () {\n        return this[!this.isShown ? 'show' : 'hide']()\n      }\n\n    , show: function () {\n        var that = this\n          , e = $.Event('show')\n\n        this.$element.trigger(e)\n\n        if (this.isShown || e.isDefaultPrevented()) return\n\n        this.isShown = true\n\n        this.escape()\n\n        this.backdrop(function () {\n          var transition = $.support.transition && that.$element.hasClass('fade')\n\n          if (!that.$element.parent().length) {\n            that.$element.appendTo(this.options.selector) //don't move modals dom position\n          }\n\n          that.$element.show()\n\n          if (transition) {\n            that.$element[0].offsetWidth // force reflow\n          }\n\n          that.$element\n            .addClass('in')\n            .attr('aria-hidden', false)\n\n          that.enforceFocus()\n\n          transition ?\n            that.$element.one($.support.transition.end, function () { that.$element.focus().trigger('shown') }) :\n            that.$element.focus().trigger('shown')\n\n        })\n      }\n\n    , hide: function (e) {\n        e && e.preventDefault()\n\n        var that = this\n\n        e = $.Event('hide')\n\n        this.$element.trigger(e)\n\n        if (!this.isShown || e.isDefaultPrevented()) return\n\n        this.isShown = false\n\n        this.escape()\n\n        $(document).off('focusin.modal')\n\n        this.$element\n          .removeClass('in')\n          .attr('aria-hidden', true)\n\n        $.support.transition && this.$element.hasClass('fade') ?\n          this.hideWithTransition() :\n          this.hideModal()\n      }\n\n    , enforceFocus: function () {\n        var that = this\n        $(document).on('focusin.modal', function (e) {\n          if (that.$element[0] !== e.target && !that.$element.has(e.target).length) {\n            that.$element.focus()\n          }\n        })\n      }\n\n    , escape: function () {\n        var that = this\n        if (this.isShown && this.options.keyboard) {\n          this.$element.on('keyup.dismiss.modal', function ( e ) {\n            e.which == 27 && that.hide()\n          })\n        } else if (!this.isShown) {\n          this.$element.off('keyup.dismiss.modal')\n        }\n      }\n\n    , hideWithTransition: function () {\n        var that = this\n          , timeout = setTimeout(function () {\n              that.$element.off($.support.transition.end)\n              that.hideModal()\n            }, 500)\n\n        this.$element.one($.support.transition.end, function () {\n          clearTimeout(timeout)\n          that.hideModal()\n        })\n      }\n\n    , hideModal: function () {\n        var that = this\n        this.$element.hide()\n        this.backdrop(function () {\n          that.removeBackdrop()\n          that.$element.trigger('hidden')\n        })\n      }\n\n    , removeBackdrop: function () {\n        this.$backdrop && this.$backdrop.remove()\n        this.$backdrop = null\n      }\n\n    , backdrop: function (callback) {\n        var that = this\n          , animate = this.$element.hasClass('fade') ? 'fade' : ''\n\n        if (this.isShown && this.options.backdrop) {\n          var doAnimate = $.support.transition && animate\n\n          this.$backdrop = $('<div class=\"modal-backdrop ' + animate + '\" />')\n            .appendTo(this.options.selector)\n\n          this.$backdrop.click(\n            this.options.backdrop == 'static' ?\n              $.proxy(this.$element[0].focus, this.$element[0])\n            : $.proxy(this.hide, this)\n          )\n\n          if (doAnimate) this.$backdrop[0].offsetWidth // force reflow\n\n          this.$backdrop.addClass('in')\n\n          if (!callback) return\n\n          doAnimate ?\n            this.$backdrop.one($.support.transition.end, callback) :\n            callback()\n\n        } else if (!this.isShown && this.$backdrop) {\n          this.$backdrop.removeClass('in')\n\n          $.support.transition && this.$element.hasClass('fade')?\n            this.$backdrop.one($.support.transition.end, callback) :\n            callback()\n\n        } else if (callback) {\n          callback()\n        }\n      }\n  }\n\n\n /* MODAL PLUGIN DEFINITION\n  * ======================= */\n\n  var old = $.fn.modal\n\n  $.fn.modal = function (option) {\n    return this.each(function () {\n      var $this = $(this)\n        , data = $this.data('modal')\n        , options = $.extend({}, $.fn.modal.defaults, $this.data(), typeof option == 'object' && option)\n      if (!data) $this.data('modal', (data = new Modal(this, options)))\n      if (typeof option == 'string') data[option]()\n      else if (options.show) data.show()\n    })\n  }\n\n  $.fn.modal.defaults = {\n      backdrop: true\n    , keyboard: true\n    , show: true\n    , selector: \"body\"\n  }\n\n  $.fn.modal.Constructor = Modal\n\n\n /* MODAL NO CONFLICT\n  * ================= */\n\n  $.fn.modal.noConflict = function () {\n    $.fn.modal = old\n    return this\n  }\n\n\n /* MODAL DATA-API\n  * ============== */\n\n  $(document).on('click.modal.data-api', '[data-toggle=\"modal\"]', function (e) {\n    var $this = $(this)\n      , href = $this.attr('href')\n      , $target = $($this.attr('data-target') || (href && href.replace(/.*(?=#[^\\s]+$)/, ''))) //strip for ie7\n      , option = $target.data('modal') ? 'toggle' : $.extend({ remote:!/#/.test(href) && href }, $target.data(), $this.data())\n\n    e.preventDefault()\n\n    $target\n      .modal(option)\n      .one('hide', function () {\n        $this.focus()\n      })\n  })\n\n}(window.jQuery);\n\n//# sourceURL=/widgets/bootstrap-modal.js"),define("widgets/bootstrap-modal",function(){}),eval("/* ==========================================================\n * bootstrap-twipsy.js v1.4.0\n * http://twitter.github.com/bootstrap/javascript.html#twipsy\n * Adapted from the original jQuery.tipsy by Jason Frame\n * Adjusted for Brackets\n * ==========================================================\n * Copyright 2011 Twitter, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n * ========================================================== */\n\n\n!function( $ ) {\n\n  \"use strict\"\n\n  /***** [changed for Brackets] *****/\n  // Undefined until the focus state changed once\n  var _windowHasFocus;\n\n  $(window)\n    .focus(function _onWindowGainedFocus() {\n      _windowHasFocus = true;\n    })\n    .blur(function _onWindowLostFocus() {\n      _windowHasFocus = false;\n    });\n  /***** [/changed for Brackets] *****/\n\n /* CSS TRANSITION SUPPORT (https://gist.github.com/373874)\n  * ======================================================= */\n\n  var transitionEnd\n\n  $(document).ready(function () {\n\n    $.support.transition = (function () {\n\n      var transitionEnd = (function () {\n\n        var el = document.createElement('bootstrap')\n          , transEndEventNames = {\n               'WebkitTransition' : 'webkitTransitionEnd'\n            ,  'MozTransition'    : 'transitionend'\n            ,  'OTransition'      : 'oTransitionEnd'\n            ,  'msTransition'     : 'MSTransitionEnd'\n            ,  'transition'       : 'transitionend'\n            }\n          , name\n\n        for (name in transEndEventNames){\n          if (el.style[name] !== undefined) {\n            return transEndEventNames[name]\n          }\n        }\n\n      }())\n\n      return transitionEnd && {\n        end: transitionEnd\n      }\n\n    })()\n\n    // set CSS transition event type\n    if ( $.support.transition ) {\n      transitionEnd = $.support.transition.end\n    }\n\n  })\n\n\n /* TWIPSY PUBLIC CLASS DEFINITION\n  * ============================== */\n\n  var Twipsy = function ( element, options ) {\n    this.$element = $(element)\n    this.options = options\n    this.enabled = true\n    /***** [changed for Brackets] *****/\n    this.autoHideTimeout = null;\n    /***** [/changed for Brackets] *****/\n    this.fixTitle()\n  }\n\n  Twipsy.prototype = {\n\n    show: function() {\n      /***** [changed for Brackets: moved some variables to updatePosition()] *****/\n      var $tip\n        , that = this;\n      /***** [/changed for Brackets] *****/\n\n      if (this.hasContent() && this.enabled) {\n        $tip = this.tip()\n        this.setContent()\n\n        if (this.options.animate) {\n          $tip.addClass('fade')\n        }\n\n        $tip\n          .remove()\n          .css({ top: 0, left: 0, display: 'block' })\n          .prependTo(document.body)\n\n/***** [changed for Brackets] *****/\n        this.updatePosition();\n\n        $(window).off(\"resize\", this.resizeHandler);\n        this.resizeHandler = function(e) {\n          that.updatePosition();\n        };\n        $(window).on(\"resize\", this.resizeHandler);\n\n        if (this.options.autoHideDelay) {\n          var startAutoHide = function () {\n            window.clearTimeout(that.autoHideTimeout);\n            that.autoHideTimeout = window.setTimeout(function () {\n              that.hide();\n            }, that.options.autoHideDelay);\n          }\n          if (_windowHasFocus) {\n            startAutoHide();\n          } else {\n            $(window).one(\"focus\", startAutoHide);\n          }\n        }\n\n        $tip.addClass('in');\n      }\n    }\n\n  , updatePosition: function () {\n      var pos\n        , actualWidth\n        , actualHeight\n        , paddingLeft\n        , paddingRight\n        , surplusRight\n        , shiftArrow\n        , placement\n        , $tip\n        , $arrow\n        , tp\n        , that = this\n\n      $tip = this.tip()\n\n      pos = $.extend({}, this.$element.offset(), {\n        width: this.$element[0].offsetWidth\n      , height: this.$element[0].offsetHeight\n      })\n\n      paddingLeft  = parseInt(this.$element.css(\"padding-left\"),  10);\n      paddingRight = parseInt(this.$element.css(\"padding-right\"), 10);\n\n      pos.left += paddingLeft;\n      pos.width -= (paddingLeft + paddingRight);\n\n      actualWidth = $tip[0].offsetWidth\n      actualHeight = $tip[0].offsetHeight\n\n      placement = maybeCall(this.options.placement, this, [ $tip[0], this.$element[0] ])\n      // Add the placement class so the arrow's margin can be determined\n      $tip.addClass(placement)\n\n      switch (placement) {\n        case 'below':\n          tp = {top: pos.top + pos.height + this.options.offset, left: pos.left + pos.width / 2 - actualWidth / 2}\n          break\n        case 'above':\n          tp = {top: pos.top - actualHeight - this.options.offset, left: pos.left + pos.width / 2 - actualWidth / 2}\n          break\n        case 'left':\n          /***** [changed for Brackets] *****/\n          tp = {top: pos.top + pos.height + 20 - actualHeight, left: pos.left - actualWidth - this.options.offset}\n          break\n        case 'right':\n          /***** [changed for Brackets] *****/\n          tp = {top: pos.top + pos.height + 20 - actualHeight, left: pos.left + pos.width + this.options.offset}\n          break\n      }\n\n      shiftArrow = 0;\n\n      surplusRight = (tp.left + actualWidth - $(document.body).width());\n      if (surplusRight > 0) {\n        shiftArrow = surplusRight;\n        tp.left -= surplusRight;\n      } else if (tp.left < 0) {\n        shiftArrow = tp.left;\n        tp.left = 0;\n      }\n\n      if (surplusRight > 0) {\n        $arrow = $tip.find(\".tooltip-arrow\");\n        if (! this.defaultMargin) {\n          this.defaultMargin = parseInt($arrow.css(\"margin-left\"), 10);\n        }\n        $arrow.css(\"margin-left\", this.defaultMargin + shiftArrow);\n      }\n\n      $tip.css(tp);\n    }\n/***** [/changed for Brackets] *****/\n\n  , setContent: function () {\n      var $tip = this.tip()\n      $tip.find('.tooltip-inner')[this.options.html ? 'html' : 'text'](this.getTitle())\n      $tip[0].className = 'tooltip'\n    }\n\n  , hide: function() {\n      var that = this\n        , $tip = this.tip()\n\n      $tip.removeClass('in')\n\n      function removeElement () {\n        $tip.remove()\n      }\n\n      $.support.transition && this.$tip.hasClass('fade') ?\n        $tip.bind(transitionEnd, removeElement) :\n        removeElement()\n\n      /***** [changed for Brackets] *****/\n      window.clearTimeout(this.autoHideTimeout);\n      $(window).off(\"resize\", this.resizeHandler)\n      /***** [/changed for Brackets] *****/\n    }\n\n  , fixTitle: function() {\n      var $e = this.$element\n      if ($e.attr('title') || typeof($e.attr('data-original-title')) != 'string') {\n        $e.attr('data-original-title', $e.attr('title') || '').removeAttr('title')\n      }\n    }\n\n  , hasContent: function () {\n      return this.getTitle()\n    }\n\n  , getTitle: function() {\n      var title\n        , $e = this.$element\n        , o = this.options\n\n        this.fixTitle()\n\n        if (typeof o.title == 'string') {\n          title = $e.attr(o.title == 'title' ? 'data-original-title' : o.title)\n        } else if (typeof o.title == 'function') {\n          title = o.title.call($e[0])\n        }\n\n        title = ('' + title).replace(/(^\\s*|\\s*$)/, \"\")\n\n        return title || o.fallback\n    }\n\n  , tip: function() {\n      return this.$tip = this.$tip || $('<div class=\"tooltip\" />').html(this.options.template)\n    }\n\n  , validate: function() {\n      if (!this.$element[0].parentNode) {\n        this.hide()\n        this.$element = null\n        this.options = null\n      }\n    }\n\n  , enable: function() {\n      this.enabled = true\n    }\n\n  , disable: function() {\n      this.enabled = false\n    }\n\n  , toggleEnabled: function() {\n      this.enabled = !this.enabled\n    }\n\n  , toggle: function () {\n      this[this.tip().hasClass('in') ? 'hide' : 'show']()\n    }\n\n  }\n\n\n /* TWIPSY PRIVATE METHODS\n  * ====================== */\n\n   function maybeCall ( thing, ctx, args ) {\n     return typeof thing == 'function' ? thing.apply(ctx, args) : thing\n   }\n\n /* TWIPSY PLUGIN DEFINITION\n  * ======================== */\n\n  $.fn.twipsy = function (options) {\n    $.fn.twipsy.initWith.call(this, options, Twipsy, 'twipsy')\n    return this\n  }\n\n  $.fn.twipsy.initWith = function (options, Constructor, name) {\n    var twipsy\n      , binder\n      , eventIn\n      , eventOut\n\n    if (options === true) {\n      return this.data(name)\n    } else if (typeof options == 'string') {\n      twipsy = this.data(name)\n      if (twipsy) {\n        twipsy[options]()\n      }\n      return this\n    }\n\n    options = $.extend({}, $.fn[name].defaults, options)\n\n    function get(ele) {\n      var twipsy = $.data(ele, name)\n\n      if (!twipsy) {\n        twipsy = new Constructor(ele, $.fn.twipsy.elementOptions(ele, options))\n        $.data(ele, name, twipsy)\n      }\n\n      return twipsy\n    }\n\n    function enter() {\n      var twipsy = get(this)\n      twipsy.hoverState = 'in'\n\n      if (options.delayIn == 0) {\n        twipsy.show()\n      } else {\n        twipsy.fixTitle()\n        setTimeout(function() {\n          if (twipsy.hoverState == 'in') {\n            twipsy.show()\n          }\n        }, options.delayIn)\n      }\n    }\n\n    function leave() {\n      var twipsy = get(this)\n      twipsy.hoverState = 'out'\n      if (options.delayOut == 0) {\n        twipsy.hide()\n      } else {\n        setTimeout(function() {\n          if (twipsy.hoverState == 'out') {\n            twipsy.hide()\n          }\n        }, options.delayOut)\n      }\n    }\n\n    if (!options.live) {\n      this.each(function() {\n        get(this)\n      })\n    }\n\n    if (options.trigger != 'manual') {\n      binder   = options.live ? 'live' : 'bind'\n      eventIn  = options.trigger == 'hover' ? 'mouseenter' : 'focus'\n      eventOut = options.trigger == 'hover' ? 'mouseleave' : 'blur'\n      this[binder](eventIn, enter)[binder](eventOut, leave)\n    }\n\n    return this\n  }\n\n  $.fn.twipsy.Twipsy = Twipsy\n\n  $.fn.twipsy.defaults = {\n    animate: true\n  , delayIn: 0\n  , delayOut: 0\n  , fallback: ''\n  , placement: 'above'\n  , html: false\n  , live: false\n  , offset: 0\n  , title: 'title'\n  , trigger: 'hover'\n  , template: '<div class=\"tooltip-arrow\"></div><div class=\"tooltip-inner\"></div>'\n  }\n\n  $.fn.twipsy.rejectAttrOptions = [ 'title' ]\n\n  $.fn.twipsy.elementOptions = function(ele, options) {\n    var data = $(ele).data()\n      , rejects = $.fn.twipsy.rejectAttrOptions\n      , i = rejects.length\n\n    while (i--) {\n      delete data[rejects[i]]\n    }\n\n    return $.extend({}, options, data)\n  }\n\n}( window.jQuery || window.ender );\n\n//# sourceURL=/widgets/bootstrap-twipsy-mod.js"),
define("widgets/bootstrap-twipsy-mod",function(){}),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n// This is CodeMirror (http://codemirror.net), a code editor\n// implemented in JavaScript on top of the browser\'s DOM.\n//\n// You can find some technical background for some of the code below\n// at http://marijnhaverbeke.nl/blog/#cm-internals .\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    module.exports = mod();\n  else if (typeof define == "function" && define.amd) // AMD\n    return define(\'thirdparty/CodeMirror/lib/codemirror\',[], mod);\n  else // Plain browser env\n    this.CodeMirror = mod();\n})(function() {\n  "use strict";\n\n  // BROWSER SNIFFING\n\n  // Kludges for bugs and behavior differences that can\'t be feature\n  // detected are enabled based on userAgent etc sniffing.\n\n  var gecko = /gecko\\/\\d/i.test(navigator.userAgent);\n  var ie_upto10 = /MSIE \\d/.test(navigator.userAgent);\n  var ie_11up = /Trident\\/(?:[7-9]|\\d{2,})\\..*rv:(\\d+)/.exec(navigator.userAgent);\n  var ie = ie_upto10 || ie_11up;\n  var ie_version = ie && (ie_upto10 ? document.documentMode || 6 : ie_11up[1]);\n  var webkit = /WebKit\\//.test(navigator.userAgent);\n  var qtwebkit = webkit && /Qt\\/\\d+\\.\\d+/.test(navigator.userAgent);\n  var chrome = /Chrome\\//.test(navigator.userAgent);\n  var presto = /Opera\\//.test(navigator.userAgent);\n  var safari = /Apple Computer/.test(navigator.vendor);\n  var mac_geMountainLion = /Mac OS X 1\\d\\D([8-9]|\\d\\d)\\D/.test(navigator.userAgent);\n  var phantom = /PhantomJS/.test(navigator.userAgent);\n\n  var ios = /AppleWebKit/.test(navigator.userAgent) && /Mobile\\/\\w+/.test(navigator.userAgent);\n  // This is woefully incomplete. Suggestions for alternative methods welcome.\n  var mobile = ios || /Android|webOS|BlackBerry|Opera Mini|Opera Mobi|IEMobile/i.test(navigator.userAgent);\n  var mac = ios || /Mac/.test(navigator.platform);\n  var windows = /win/i.test(navigator.platform);\n\n  var presto_version = presto && navigator.userAgent.match(/Version\\/(\\d*\\.\\d*)/);\n  if (presto_version) presto_version = Number(presto_version[1]);\n  if (presto_version && presto_version >= 15) { presto = false; webkit = true; }\n  // Some browsers use the wrong event properties to signal cmd/ctrl on OS X\n  var flipCtrlCmd = mac && (qtwebkit || presto && (presto_version == null || presto_version < 12.11));\n  var captureRightClick = gecko || (ie && ie_version >= 9);\n\n  // Optimize some code when these features are not used.\n  var sawReadOnlySpans = false, sawCollapsedSpans = false;\n\n  // EDITOR CONSTRUCTOR\n\n  // A CodeMirror instance represents an editor. This is the object\n  // that user code is usually dealing with.\n\n  function CodeMirror(place, options) {\n    if (!(this instanceof CodeMirror)) return new CodeMirror(place, options);\n\n    this.options = options = options ? copyObj(options) : {};\n    // Determine effective options based on given values and defaults.\n    copyObj(defaults, options, false);\n    setGuttersForLineNumbers(options);\n\n    var doc = options.value;\n    if (typeof doc == "string") doc = new Doc(doc, options.mode, null, options.lineSeparator);\n    this.doc = doc;\n\n    var input = new CodeMirror.inputStyles[options.inputStyle](this);\n    var display = this.display = new Display(place, doc, input);\n    display.wrapper.CodeMirror = this;\n    updateGutters(this);\n    themeChanged(this);\n    if (options.lineWrapping)\n      this.display.wrapper.className += " CodeMirror-wrap";\n    if (options.autofocus && !mobile) display.input.focus();\n    initScrollbars(this);\n\n    this.state = {\n      keyMaps: [],  // stores maps added by addKeyMap\n      overlays: [], // highlighting overlays, as added by addOverlay\n      modeGen: 0,   // bumped when mode/overlay changes, used to invalidate highlighting info\n      overwrite: false,\n      delayingBlurEvent: false,\n      focused: false,\n      suppressEdits: false, // used to disable editing during key handlers when in readOnly mode\n      pasteIncoming: false, cutIncoming: false, // help recognize paste/cut edits in input.poll\n      selectingText: false,\n      draggingText: false,\n      highlight: new Delayed(), // stores highlight worker timeout\n      keySeq: null,  // Unfinished key sequence\n      specialChars: null\n    };\n\n    var cm = this;\n\n    // Override magic textarea content restore that IE sometimes does\n    // on our hidden textarea on reload\n    if (ie && ie_version < 11) setTimeout(function() { cm.display.input.reset(true); }, 20);\n\n    registerEventHandlers(this);\n    ensureGlobalHandlers();\n\n    startOperation(this);\n    this.curOp.forceUpdate = true;\n    attachDoc(this, doc);\n\n    if ((options.autofocus && !mobile) || cm.hasFocus())\n      setTimeout(bind(onFocus, this), 20);\n    else\n      onBlur(this);\n\n    for (var opt in optionHandlers) if (optionHandlers.hasOwnProperty(opt))\n      optionHandlers[opt](this, options[opt], Init);\n    maybeUpdateLineNumberWidth(this);\n    if (options.finishInit) options.finishInit(this);\n    for (var i = 0; i < initHooks.length; ++i) initHooks[i](this);\n    endOperation(this);\n    // Suppress optimizelegibility in Webkit, since it breaks text\n    // measuring on line wrapping boundaries.\n    if (webkit && options.lineWrapping &&\n        getComputedStyle(display.lineDiv).textRendering == "optimizelegibility")\n      display.lineDiv.style.textRendering = "auto";\n  }\n\n  // DISPLAY CONSTRUCTOR\n\n  // The display handles the DOM integration, both for input reading\n  // and content drawing. It holds references to DOM nodes and\n  // display-related state.\n\n  function Display(place, doc, input) {\n    var d = this;\n    this.input = input;\n\n    // Covers bottom-right square when both scrollbars are present.\n    d.scrollbarFiller = elt("div", null, "CodeMirror-scrollbar-filler");\n    d.scrollbarFiller.setAttribute("cm-not-content", "true");\n    // Covers bottom of gutter when coverGutterNextToScrollbar is on\n    // and h scrollbar is present.\n    d.gutterFiller = elt("div", null, "CodeMirror-gutter-filler");\n    d.gutterFiller.setAttribute("cm-not-content", "true");\n    // Will contain the actual code, positioned to cover the viewport.\n    d.lineDiv = elt("div", null, "CodeMirror-code");\n    // Elements are added to these to represent selection and cursors.\n    d.selectionDiv = elt("div", null, null, "position: relative; z-index: 1");\n    d.cursorDiv = elt("div", null, "CodeMirror-cursors");\n    // A visibility: hidden element used to find the size of things.\n    d.measure = elt("div", null, "CodeMirror-measure");\n    // When lines outside of the viewport are measured, they are drawn in this.\n    d.lineMeasure = elt("div", null, "CodeMirror-measure");\n    // Wraps everything that needs to exist inside the vertically-padded coordinate system\n    d.lineSpace = elt("div", [d.measure, d.lineMeasure, d.selectionDiv, d.cursorDiv, d.lineDiv],\n                      null, "position: relative; outline: none");\n    // Moved around its parent to cover visible view.\n    d.mover = elt("div", [elt("div", [d.lineSpace], "CodeMirror-lines")], null, "position: relative");\n    // Set to the height of the document, allowing scrolling.\n    d.sizer = elt("div", [d.mover], "CodeMirror-sizer");\n    d.sizerWidth = null;\n    // Behavior of elts with overflow: auto and padding is\n    // inconsistent across browsers. This is used to ensure the\n    // scrollable area is big enough.\n    d.heightForcer = elt("div", null, null, "position: absolute; height: " + scrollerGap + "px; width: 1px;");\n    // Will contain the gutters, if any.\n    d.gutters = elt("div", null, "CodeMirror-gutters");\n    d.lineGutter = null;\n    // Actual scrollable element.\n    d.scroller = elt("div", [d.sizer, d.heightForcer, d.gutters], "CodeMirror-scroll");\n    d.scroller.setAttribute("tabIndex", "-1");\n    // The element in which the editor lives.\n    d.wrapper = elt("div", [d.scrollbarFiller, d.gutterFiller, d.scroller], "CodeMirror");\n\n    // Work around IE7 z-index bug (not perfect, hence IE7 not really being supported)\n    if (ie && ie_version < 8) { d.gutters.style.zIndex = -1; d.scroller.style.paddingRight = 0; }\n    if (!webkit && !(gecko && mobile)) d.scroller.draggable = true;\n\n    if (place) {\n      if (place.appendChild) place.appendChild(d.wrapper);\n      else place(d.wrapper);\n    }\n\n    // Current rendered range (may be bigger than the view window).\n    d.viewFrom = d.viewTo = doc.first;\n    d.reportedViewFrom = d.reportedViewTo = doc.first;\n    // Information about the rendered lines.\n    d.view = [];\n    d.renderedView = null;\n    // Holds info about a single rendered line when it was rendered\n    // for measurement, while not in view.\n    d.externalMeasured = null;\n    // Empty space (in pixels) above the view\n    d.viewOffset = 0;\n    d.lastWrapHeight = d.lastWrapWidth = 0;\n    d.updateLineNumbers = null;\n\n    d.nativeBarWidth = d.barHeight = d.barWidth = 0;\n    d.scrollbarsClipped = false;\n\n    // Used to only resize the line number gutter when necessary (when\n    // the amount of lines crosses a boundary that makes its width change)\n    d.lineNumWidth = d.lineNumInnerWidth = d.lineNumChars = null;\n    // Set to true when a non-horizontal-scrolling line widget is\n    // added. As an optimization, line widget aligning is skipped when\n    // this is false.\n    d.alignWidgets = false;\n\n    d.cachedCharWidth = d.cachedTextHeight = d.cachedPaddingH = null;\n\n    // Tracks the maximum line length so that the horizontal scrollbar\n    // can be kept static when scrolling.\n    d.maxLine = null;\n    d.maxLineLength = 0;\n    d.maxLineChanged = false;\n\n    // Used for measuring wheel scrolling granularity\n    d.wheelDX = d.wheelDY = d.wheelStartX = d.wheelStartY = null;\n\n    // True when shift is held down.\n    d.shift = false;\n\n    // Used to track whether anything happened since the context menu\n    // was opened.\n    d.selForContextMenu = null;\n\n    d.activeTouch = null;\n\n    input.init(d);\n  }\n\n  // STATE UPDATES\n\n  // Used to get the editor into a consistent state again when options change.\n\n  function loadMode(cm) {\n    cm.doc.mode = CodeMirror.getMode(cm.options, cm.doc.modeOption);\n    resetModeState(cm);\n  }\n\n  function resetModeState(cm) {\n    cm.doc.iter(function(line) {\n      if (line.stateAfter) line.stateAfter = null;\n      if (line.styles) line.styles = null;\n    });\n    cm.doc.frontier = cm.doc.first;\n    startWorker(cm, 100);\n    cm.state.modeGen++;\n    if (cm.curOp) regChange(cm);\n  }\n\n  function wrappingChanged(cm) {\n    if (cm.options.lineWrapping) {\n      addClass(cm.display.wrapper, "CodeMirror-wrap");\n      cm.display.sizer.style.minWidth = "";\n      cm.display.sizerWidth = null;\n    } else {\n      rmClass(cm.display.wrapper, "CodeMirror-wrap");\n      findMaxLine(cm);\n    }\n    estimateLineHeights(cm);\n    regChange(cm);\n    clearCaches(cm);\n    setTimeout(function(){updateScrollbars(cm);}, 100);\n  }\n\n  // Returns a function that estimates the height of a line, to use as\n  // first approximation until the line becomes visible (and is thus\n  // properly measurable).\n  function estimateHeight(cm) {\n    var th = textHeight(cm.display), wrapping = cm.options.lineWrapping;\n    var perLine = wrapping && Math.max(5, cm.display.scroller.clientWidth / charWidth(cm.display) - 3);\n    return function(line) {\n      if (lineIsHidden(cm.doc, line)) return 0;\n\n      var widgetsHeight = 0;\n      if (line.widgets) for (var i = 0; i < line.widgets.length; i++) {\n        if (line.widgets[i].height) widgetsHeight += line.widgets[i].height;\n      }\n\n      if (wrapping)\n        return widgetsHeight + (Math.ceil(line.text.length / perLine) || 1) * th;\n      else\n        return widgetsHeight + th;\n    };\n  }\n\n  function estimateLineHeights(cm) {\n    var doc = cm.doc, est = estimateHeight(cm);\n    doc.iter(function(line) {\n      var estHeight = est(line);\n      if (estHeight != line.height) updateLineHeight(line, estHeight);\n    });\n  }\n\n  function themeChanged(cm) {\n    cm.display.wrapper.className = cm.display.wrapper.className.replace(/\\s*cm-s-\\S+/g, "") +\n      cm.options.theme.replace(/(^|\\s)\\s*/g, " cm-s-");\n    clearCaches(cm);\n  }\n\n  function guttersChanged(cm) {\n    updateGutters(cm);\n    regChange(cm);\n    setTimeout(function(){alignHorizontally(cm);}, 20);\n  }\n\n  // Rebuild the gutter elements, ensure the margin to the left of the\n  // code matches their width.\n  function updateGutters(cm) {\n    var gutters = cm.display.gutters, specs = cm.options.gutters;\n    removeChildren(gutters);\n    for (var i = 0; i < specs.length; ++i) {\n      var gutterClass = specs[i];\n      var gElt = gutters.appendChild(elt("div", null, "CodeMirror-gutter " + gutterClass));\n      if (gutterClass == "CodeMirror-linenumbers") {\n        cm.display.lineGutter = gElt;\n        gElt.style.width = (cm.display.lineNumWidth || 1) + "px";\n      }\n    }\n    gutters.style.display = i ? "" : "none";\n    updateGutterSpace(cm);\n  }\n\n  function updateGutterSpace(cm) {\n    var width = cm.display.gutters.offsetWidth;\n    cm.display.sizer.style.marginLeft = width + "px";\n  }\n\n  // Compute the character length of a line, taking into account\n  // collapsed ranges (see markText) that might hide parts, and join\n  // other lines onto it.\n  function lineLength(line) {\n    if (line.height == 0) return 0;\n    var len = line.text.length, merged, cur = line;\n    while (merged = collapsedSpanAtStart(cur)) {\n      var found = merged.find(0, true);\n      cur = found.from.line;\n      len += found.from.ch - found.to.ch;\n    }\n    cur = line;\n    while (merged = collapsedSpanAtEnd(cur)) {\n      var found = merged.find(0, true);\n      len -= cur.text.length - found.from.ch;\n      cur = found.to.line;\n      len += cur.text.length - found.to.ch;\n    }\n    return len;\n  }\n\n  // Find the longest line in the document.\n  function findMaxLine(cm) {\n    var d = cm.display, doc = cm.doc;\n    d.maxLine = getLine(doc, doc.first);\n    d.maxLineLength = lineLength(d.maxLine);\n    d.maxLineChanged = true;\n    doc.iter(function(line) {\n      var len = lineLength(line);\n      if (len > d.maxLineLength) {\n        d.maxLineLength = len;\n        d.maxLine = line;\n      }\n    });\n  }\n\n  // Make sure the gutters options contains the element\n  // "CodeMirror-linenumbers" when the lineNumbers option is true.\n  function setGuttersForLineNumbers(options) {\n    var found = indexOf(options.gutters, "CodeMirror-linenumbers");\n    if (found == -1 && options.lineNumbers) {\n      options.gutters = options.gutters.concat(["CodeMirror-linenumbers"]);\n    } else if (found > -1 && !options.lineNumbers) {\n      options.gutters = options.gutters.slice(0);\n      options.gutters.splice(found, 1);\n    }\n  }\n\n  // SCROLLBARS\n\n  // Prepare DOM reads needed to update the scrollbars. Done in one\n  // shot to minimize update/measure roundtrips.\n  function measureForScrollbars(cm) {\n    var d = cm.display, gutterW = d.gutters.offsetWidth;\n    var docH = Math.round(cm.doc.height + paddingVert(cm.display));\n    return {\n      clientHeight: d.scroller.clientHeight,\n      viewHeight: d.wrapper.clientHeight,\n      scrollWidth: d.scroller.scrollWidth, clientWidth: d.scroller.clientWidth,\n      viewWidth: d.wrapper.clientWidth,\n      barLeft: cm.options.fixedGutter ? gutterW : 0,\n      docHeight: docH,\n      scrollHeight: docH + scrollGap(cm) + d.barHeight,\n      nativeBarWidth: d.nativeBarWidth,\n      gutterWidth: gutterW\n    };\n  }\n\n  function NativeScrollbars(place, scroll, cm) {\n    this.cm = cm;\n    var vert = this.vert = elt("div", [elt("div", null, null, "min-width: 1px")], "CodeMirror-vscrollbar");\n    var horiz = this.horiz = elt("div", [elt("div", null, null, "height: 100%; min-height: 1px")], "CodeMirror-hscrollbar");\n    place(vert); place(horiz);\n\n    on(vert, "scroll", function() {\n      if (vert.clientHeight) scroll(vert.scrollTop, "vertical");\n    });\n    on(horiz, "scroll", function() {\n      if (horiz.clientWidth) scroll(horiz.scrollLeft, "horizontal");\n    });\n\n    this.checkedOverlay = false;\n    // Need to set a minimum width to see the scrollbar on IE7 (but must not set it on IE8).\n    if (ie && ie_version < 8) this.horiz.style.minHeight = this.vert.style.minWidth = "18px";\n  }\n\n  NativeScrollbars.prototype = copyObj({\n    update: function(measure) {\n      var needsH = measure.scrollWidth > measure.clientWidth + 1;\n      var needsV = measure.scrollHeight > measure.clientHeight + 1;\n      var sWidth = measure.nativeBarWidth;\n\n      if (needsV) {\n        this.vert.style.display = "block";\n        this.vert.style.bottom = needsH ? sWidth + "px" : "0";\n        var totalHeight = measure.viewHeight - (needsH ? sWidth : 0);\n        // A bug in IE8 can cause this value to be negative, so guard it.\n        this.vert.firstChild.style.height =\n          Math.max(0, measure.scrollHeight - measure.clientHeight + totalHeight) + "px";\n      } else {\n        this.vert.style.display = "";\n        this.vert.firstChild.style.height = "0";\n      }\n\n      if (needsH) {\n        this.horiz.style.display = "block";\n        this.horiz.style.right = needsV ? sWidth + "px" : "0";\n        this.horiz.style.left = measure.barLeft + "px";\n        var totalWidth = measure.viewWidth - measure.barLeft - (needsV ? sWidth : 0);\n        this.horiz.firstChild.style.width =\n          (measure.scrollWidth - measure.clientWidth + totalWidth) + "px";\n      } else {\n        this.horiz.style.display = "";\n        this.horiz.firstChild.style.width = "0";\n      }\n\n      if (!this.checkedOverlay && measure.clientHeight > 0) {\n        if (sWidth == 0) this.overlayHack();\n        this.checkedOverlay = true;\n      }\n\n      return {right: needsV ? sWidth : 0, bottom: needsH ? sWidth : 0};\n    },\n    setScrollLeft: function(pos) {\n      if (this.horiz.scrollLeft != pos) this.horiz.scrollLeft = pos;\n    },\n    setScrollTop: function(pos) {\n      if (this.vert.scrollTop != pos) this.vert.scrollTop = pos;\n    },\n    overlayHack: function() {\n      var w = mac && !mac_geMountainLion ? "12px" : "18px";\n      this.horiz.style.minHeight = this.vert.style.minWidth = w;\n      var self = this;\n      var barMouseDown = function(e) {\n        if (e_target(e) != self.vert && e_target(e) != self.horiz)\n          operation(self.cm, onMouseDown)(e);\n      };\n      on(this.vert, "mousedown", barMouseDown);\n      on(this.horiz, "mousedown", barMouseDown);\n    },\n    clear: function() {\n      var parent = this.horiz.parentNode;\n      parent.removeChild(this.horiz);\n      parent.removeChild(this.vert);\n    }\n  }, NativeScrollbars.prototype);\n\n  function NullScrollbars() {}\n\n  NullScrollbars.prototype = copyObj({\n    update: function() { return {bottom: 0, right: 0}; },\n    setScrollLeft: function() {},\n    setScrollTop: function() {},\n    clear: function() {}\n  }, NullScrollbars.prototype);\n\n  CodeMirror.scrollbarModel = {"native": NativeScrollbars, "null": NullScrollbars};\n\n  function initScrollbars(cm) {\n    if (cm.display.scrollbars) {\n      cm.display.scrollbars.clear();\n      if (cm.display.scrollbars.addClass)\n        rmClass(cm.display.wrapper, cm.display.scrollbars.addClass);\n    }\n\n    cm.display.scrollbars = new CodeMirror.scrollbarModel[cm.options.scrollbarStyle](function(node) {\n      cm.display.wrapper.insertBefore(node, cm.display.scrollbarFiller);\n      // Prevent clicks in the scrollbars from killing focus\n      on(node, "mousedown", function() {\n        if (cm.state.focused) setTimeout(function() { cm.display.input.focus(); }, 0);\n      });\n      node.setAttribute("cm-not-content", "true");\n    }, function(pos, axis) {\n      if (axis == "horizontal") setScrollLeft(cm, pos);\n      else setScrollTop(cm, pos);\n    }, cm);\n    if (cm.display.scrollbars.addClass)\n      addClass(cm.display.wrapper, cm.display.scrollbars.addClass);\n  }\n\n  function updateScrollbars(cm, measure) {\n    if (!measure) measure = measureForScrollbars(cm);\n    var startWidth = cm.display.barWidth, startHeight = cm.display.barHeight;\n    updateScrollbarsInner(cm, measure);\n    for (var i = 0; i < 4 && startWidth != cm.display.barWidth || startHeight != cm.display.barHeight; i++) {\n      if (startWidth != cm.display.barWidth && cm.options.lineWrapping)\n        updateHeightsInViewport(cm);\n      updateScrollbarsInner(cm, measureForScrollbars(cm));\n      startWidth = cm.display.barWidth; startHeight = cm.display.barHeight;\n    }\n  }\n\n  // Re-synchronize the fake scrollbars with the actual size of the\n  // content.\n  function updateScrollbarsInner(cm, measure) {\n    var d = cm.display;\n    var sizes = d.scrollbars.update(measure);\n\n    d.sizer.style.paddingRight = (d.barWidth = sizes.right) + "px";\n    d.sizer.style.paddingBottom = (d.barHeight = sizes.bottom) + "px";\n\n    if (sizes.right && sizes.bottom) {\n      d.scrollbarFiller.style.display = "block";\n      d.scrollbarFiller.style.height = sizes.bottom + "px";\n      d.scrollbarFiller.style.width = sizes.right + "px";\n    } else d.scrollbarFiller.style.display = "";\n    if (sizes.bottom && cm.options.coverGutterNextToScrollbar && cm.options.fixedGutter) {\n      d.gutterFiller.style.display = "block";\n      d.gutterFiller.style.height = sizes.bottom + "px";\n      d.gutterFiller.style.width = measure.gutterWidth + "px";\n    } else d.gutterFiller.style.display = "";\n  }\n\n  // Compute the lines that are visible in a given viewport (defaults\n  // the the current scroll position). viewport may contain top,\n  // height, and ensure (see op.scrollToPos) properties.\n  function visibleLines(display, doc, viewport) {\n    var top = viewport && viewport.top != null ? Math.max(0, viewport.top) : display.scroller.scrollTop;\n    top = Math.floor(top - paddingTop(display));\n    var bottom = viewport && viewport.bottom != null ? viewport.bottom : top + display.wrapper.clientHeight;\n\n    var from = lineAtHeight(doc, top), to = lineAtHeight(doc, bottom);\n    // Ensure is a {from: {line, ch}, to: {line, ch}} object, and\n    // forces those lines into the viewport (if possible).\n    if (viewport && viewport.ensure) {\n      var ensureFrom = viewport.ensure.from.line, ensureTo = viewport.ensure.to.line;\n      if (ensureFrom < from) {\n        from = ensureFrom;\n        to = lineAtHeight(doc, heightAtLine(getLine(doc, ensureFrom)) + display.wrapper.clientHeight);\n      } else if (Math.min(ensureTo, doc.lastLine()) >= to) {\n        from = lineAtHeight(doc, heightAtLine(getLine(doc, ensureTo)) - display.wrapper.clientHeight);\n        to = ensureTo;\n      }\n    }\n    return {from: from, to: Math.max(to, from + 1)};\n  }\n\n  // LINE NUMBERS\n\n  // Re-align line numbers and gutter marks to compensate for\n  // horizontal scrolling.\n  function alignHorizontally(cm) {\n    var display = cm.display, view = display.view;\n    if (!display.alignWidgets && (!display.gutters.firstChild || !cm.options.fixedGutter)) return;\n    var comp = compensateForHScroll(display) - display.scroller.scrollLeft + cm.doc.scrollLeft;\n    var gutterW = display.gutters.offsetWidth, left = comp + "px";\n    for (var i = 0; i < view.length; i++) if (!view[i].hidden) {\n      if (cm.options.fixedGutter && view[i].gutter)\n        view[i].gutter.style.left = left;\n      var align = view[i].alignable;\n      if (align) for (var j = 0; j < align.length; j++)\n        align[j].style.left = left;\n    }\n    if (cm.options.fixedGutter)\n      display.gutters.style.left = (comp + gutterW) + "px";\n  }\n\n  // Used to ensure that the line number gutter is still the right\n  // size for the current document size. Returns true when an update\n  // is needed.\n  function maybeUpdateLineNumberWidth(cm) {\n    if (!cm.options.lineNumbers) return false;\n    var doc = cm.doc, last = lineNumberFor(cm.options, doc.first + doc.size - 1), display = cm.display;\n    if (last.length != display.lineNumChars) {\n      var test = display.measure.appendChild(elt("div", [elt("div", last)],\n                                                 "CodeMirror-linenumber CodeMirror-gutter-elt"));\n      var innerW = test.firstChild.offsetWidth, padding = test.offsetWidth - innerW;\n      display.lineGutter.style.width = "";\n      display.lineNumInnerWidth = Math.max(innerW, display.lineGutter.offsetWidth - padding) + 1;\n      display.lineNumWidth = display.lineNumInnerWidth + padding;\n      display.lineNumChars = display.lineNumInnerWidth ? last.length : -1;\n      display.lineGutter.style.width = display.lineNumWidth + "px";\n      updateGutterSpace(cm);\n      return true;\n    }\n    return false;\n  }\n\n  function lineNumberFor(options, i) {\n    return String(options.lineNumberFormatter(i + options.firstLineNumber));\n  }\n\n  // Computes display.scroller.scrollLeft + display.gutters.offsetWidth,\n  // but using getBoundingClientRect to get a sub-pixel-accurate\n  // result.\n  function compensateForHScroll(display) {\n    return display.scroller.getBoundingClientRect().left - display.sizer.getBoundingClientRect().left;\n  }\n\n  // DISPLAY DRAWING\n\n  function DisplayUpdate(cm, viewport, force) {\n    var display = cm.display;\n\n    this.viewport = viewport;\n    // Store some values that we\'ll need later (but don\'t want to force a relayout for)\n    this.visible = visibleLines(display, cm.doc, viewport);\n    this.editorIsHidden = !display.wrapper.offsetWidth;\n    this.wrapperHeight = display.wrapper.clientHeight;\n    this.wrapperWidth = display.wrapper.clientWidth;\n    this.oldDisplayWidth = displayWidth(cm);\n    this.force = force;\n    this.dims = getDimensions(cm);\n    this.events = [];\n  }\n\n  DisplayUpdate.prototype.signal = function(emitter, type) {\n    if (hasHandler(emitter, type))\n      this.events.push(arguments);\n  };\n  DisplayUpdate.prototype.finish = function() {\n    for (var i = 0; i < this.events.length; i++)\n      signal.apply(null, this.events[i]);\n  };\n\n  function maybeClipScrollbars(cm) {\n    var display = cm.display;\n    if (!display.scrollbarsClipped && display.scroller.offsetWidth) {\n      display.nativeBarWidth = display.scroller.offsetWidth - display.scroller.clientWidth;\n      display.heightForcer.style.height = scrollGap(cm) + "px";\n      display.sizer.style.marginBottom = -display.nativeBarWidth + "px";\n      display.sizer.style.borderRightWidth = scrollGap(cm) + "px";\n      display.scrollbarsClipped = true;\n    }\n  }\n\n  // Does the actual updating of the line display. Bails out\n  // (returning false) when there is nothing to be done and forced is\n  // false.\n  function updateDisplayIfNeeded(cm, update) {\n    var display = cm.display, doc = cm.doc;\n\n    if (update.editorIsHidden) {\n      resetView(cm);\n      return false;\n    }\n\n    // Bail out if the visible area is already rendered and nothing changed.\n    if (!update.force &&\n        update.visible.from >= display.viewFrom && update.visible.to <= display.viewTo &&\n        (display.updateLineNumbers == null || display.updateLineNumbers >= display.viewTo) &&\n        display.renderedView == display.view && countDirtyView(cm) == 0)\n      return false;\n\n    if (maybeUpdateLineNumberWidth(cm)) {\n      resetView(cm);\n      update.dims = getDimensions(cm);\n    }\n\n    // Compute a suitable new viewport (from & to)\n    var end = doc.first + doc.size;\n    var from = Math.max(update.visible.from - cm.options.viewportMargin, doc.first);\n    var to = Math.min(end, update.visible.to + cm.options.viewportMargin);\n    if (display.viewFrom < from && from - display.viewFrom < 20) from = Math.max(doc.first, display.viewFrom);\n    if (display.viewTo > to && display.viewTo - to < 20) to = Math.min(end, display.viewTo);\n    if (sawCollapsedSpans) {\n      from = visualLineNo(cm.doc, from);\n      to = visualLineEndNo(cm.doc, to);\n    }\n\n    var different = from != display.viewFrom || to != display.viewTo ||\n      display.lastWrapHeight != update.wrapperHeight || display.lastWrapWidth != update.wrapperWidth;\n    adjustView(cm, from, to);\n\n    display.viewOffset = heightAtLine(getLine(cm.doc, display.viewFrom));\n    // Position the mover div to align with the current scroll position\n    cm.display.mover.style.top = display.viewOffset + "px";\n\n    var toUpdate = countDirtyView(cm);\n    if (!different && toUpdate == 0 && !update.force && display.renderedView == display.view &&\n        (display.updateLineNumbers == null || display.updateLineNumbers >= display.viewTo))\n      return false;\n\n    // For big changes, we hide the enclosing element during the\n    // update, since that speeds up the operations on most browsers.\n    var focused = activeElt();\n    if (toUpdate > 4) display.lineDiv.style.display = "none";\n    patchDisplay(cm, display.updateLineNumbers, update.dims);\n    if (toUpdate > 4) display.lineDiv.style.display = "";\n    display.renderedView = display.view;\n    // There might have been a widget with a focused element that got\n    // hidden or updated, if so re-focus it.\n    if (focused && activeElt() != focused && focused.offsetHeight) focused.focus();\n\n    // Prevent selection and cursors from interfering with the scroll\n    // width and height.\n    removeChildren(display.cursorDiv);\n    removeChildren(display.selectionDiv);\n    display.gutters.style.height = display.sizer.style.minHeight = 0;\n\n    if (different) {\n      display.lastWrapHeight = update.wrapperHeight;\n      display.lastWrapWidth = update.wrapperWidth;\n      startWorker(cm, 400);\n    }\n\n    display.updateLineNumbers = null;\n\n    return true;\n  }\n\n  function postUpdateDisplay(cm, update) {\n    var viewport = update.viewport;\n    for (var first = true;; first = false) {\n      if (!first || !cm.options.lineWrapping || update.oldDisplayWidth == displayWidth(cm)) {\n        // Clip forced viewport to actual scrollable area.\n        if (viewport && viewport.top != null)\n          viewport = {top: Math.min(cm.doc.height + paddingVert(cm.display) - displayHeight(cm), viewport.top)};\n        // Updated line heights might result in the drawn area not\n        // actually covering the viewport. Keep looping until it does.\n        update.visible = visibleLines(cm.display, cm.doc, viewport);\n        if (update.visible.from >= cm.display.viewFrom && update.visible.to <= cm.display.viewTo)\n          break;\n      }\n      if (!updateDisplayIfNeeded(cm, update)) break;\n      updateHeightsInViewport(cm);\n      var barMeasure = measureForScrollbars(cm);\n      updateSelection(cm);\n      setDocumentHeight(cm, barMeasure);\n      updateScrollbars(cm, barMeasure);\n    }\n\n    update.signal(cm, "update", cm);\n    if (cm.display.viewFrom != cm.display.reportedViewFrom || cm.display.viewTo != cm.display.reportedViewTo) {\n      update.signal(cm, "viewportChange", cm, cm.display.viewFrom, cm.display.viewTo);\n      cm.display.reportedViewFrom = cm.display.viewFrom; cm.display.reportedViewTo = cm.display.viewTo;\n    }\n  }\n\n  function updateDisplaySimple(cm, viewport) {\n    var update = new DisplayUpdate(cm, viewport);\n    if (updateDisplayIfNeeded(cm, update)) {\n      updateHeightsInViewport(cm);\n      postUpdateDisplay(cm, update);\n      var barMeasure = measureForScrollbars(cm);\n      updateSelection(cm);\n      setDocumentHeight(cm, barMeasure);\n      updateScrollbars(cm, barMeasure);\n      update.finish();\n    }\n  }\n\n  function setDocumentHeight(cm, measure) {\n    cm.display.sizer.style.minHeight = measure.docHeight + "px";\n    var total = measure.docHeight + cm.display.barHeight;\n    cm.display.heightForcer.style.top = total + "px";\n    cm.display.gutters.style.height = Math.max(total + scrollGap(cm), measure.clientHeight) + "px";\n  }\n\n  // Read the actual heights of the rendered lines, and update their\n  // stored heights to match.\n  function updateHeightsInViewport(cm) {\n    var display = cm.display;\n    var prevBottom = display.lineDiv.offsetTop;\n    for (var i = 0; i < display.view.length; i++) {\n      var cur = display.view[i], height;\n      if (cur.hidden) continue;\n      if (ie && ie_version < 8) {\n        var bot = cur.node.offsetTop + cur.node.offsetHeight;\n        height = bot - prevBottom;\n        prevBottom = bot;\n      } else {\n        var box = cur.node.getBoundingClientRect();\n        height = box.bottom - box.top;\n      }\n      var diff = cur.line.height - height;\n      if (height < 2) height = textHeight(display);\n      if (diff > .001 || diff < -.001) {\n        updateLineHeight(cur.line, height);\n        updateWidgetHeight(cur.line);\n        if (cur.rest) for (var j = 0; j < cur.rest.length; j++)\n          updateWidgetHeight(cur.rest[j]);\n      }\n    }\n  }\n\n  // Read and store the height of line widgets associated with the\n  // given line.\n  function updateWidgetHeight(line) {\n    if (line.widgets) for (var i = 0; i < line.widgets.length; ++i)\n      line.widgets[i].height = line.widgets[i].node.offsetHeight;\n  }\n\n  // Do a bulk-read of the DOM positions and sizes needed to draw the\n  // view, so that we don\'t interleave reading and writing to the DOM.\n  function getDimensions(cm) {\n    var d = cm.display, left = {}, width = {};\n    var gutterLeft = d.gutters.clientLeft;\n    for (var n = d.gutters.firstChild, i = 0; n; n = n.nextSibling, ++i) {\n      left[cm.options.gutters[i]] = n.offsetLeft + n.clientLeft + gutterLeft;\n      width[cm.options.gutters[i]] = n.clientWidth;\n    }\n    return {fixedPos: compensateForHScroll(d),\n            gutterTotalWidth: d.gutters.offsetWidth,\n            gutterLeft: left,\n            gutterWidth: width,\n            wrapperWidth: d.wrapper.clientWidth};\n  }\n\n  // Sync the actual display DOM structure with display.view, removing\n  // nodes for lines that are no longer in view, and creating the ones\n  // that are not there yet, and updating the ones that are out of\n  // date.\n  function patchDisplay(cm, updateNumbersFrom, dims) {\n    var display = cm.display, lineNumbers = cm.options.lineNumbers;\n    var container = display.lineDiv, cur = container.firstChild;\n\n    function rm(node) {\n      var next = node.nextSibling;\n      // Works around a throw-scroll bug in OS X Webkit\n      if (webkit && mac && cm.display.currentWheelTarget == node)\n        node.style.display = "none";\n      else\n        node.parentNode.removeChild(node);\n      return next;\n    }\n\n    var view = display.view, lineN = display.viewFrom;\n    // Loop over the elements in the view, syncing cur (the DOM nodes\n    // in display.lineDiv) with the view as we go.\n    for (var i = 0; i < view.length; i++) {\n      var lineView = view[i];\n      if (lineView.hidden) {\n      } else if (!lineView.node || lineView.node.parentNode != container) { // Not drawn yet\n        var node = buildLineElement(cm, lineView, lineN, dims);\n        container.insertBefore(node, cur);\n      } else { // Already drawn\n        while (cur != lineView.node) cur = rm(cur);\n        var updateNumber = lineNumbers && updateNumbersFrom != null &&\n          updateNumbersFrom <= lineN && lineView.lineNumber;\n        if (lineView.changes) {\n          if (indexOf(lineView.changes, "gutter") > -1) updateNumber = false;\n          updateLineForChanges(cm, lineView, lineN, dims);\n        }\n        if (updateNumber) {\n          removeChildren(lineView.lineNumber);\n          lineView.lineNumber.appendChild(document.createTextNode(lineNumberFor(cm.options, lineN)));\n        }\n        cur = lineView.node.nextSibling;\n      }\n      lineN += lineView.size;\n    }\n    while (cur) cur = rm(cur);\n  }\n\n  // When an aspect of a line changes, a string is added to\n  // lineView.changes. This updates the relevant part of the line\'s\n  // DOM structure.\n  function updateLineForChanges(cm, lineView, lineN, dims) {\n    for (var j = 0; j < lineView.changes.length; j++) {\n      var type = lineView.changes[j];\n      if (type == "text") updateLineText(cm, lineView);\n      else if (type == "gutter") updateLineGutter(cm, lineView, lineN, dims);\n      else if (type == "class") updateLineClasses(lineView);\n      else if (type == "widget") updateLineWidgets(cm, lineView, dims);\n    }\n    lineView.changes = null;\n  }\n\n  // Lines with gutter elements, widgets or a background class need to\n  // be wrapped, and have the extra elements added to the wrapper div\n  function ensureLineWrapped(lineView) {\n    if (lineView.node == lineView.text) {\n      lineView.node = elt("div", null, null, "position: relative");\n      if (lineView.text.parentNode)\n        lineView.text.parentNode.replaceChild(lineView.node, lineView.text);\n      lineView.node.appendChild(lineView.text);\n      if (ie && ie_version < 8) lineView.node.style.zIndex = 2;\n    }\n    return lineView.node;\n  }\n\n  function updateLineBackground(lineView) {\n    var cls = lineView.bgClass ? lineView.bgClass + " " + (lineView.line.bgClass || "") : lineView.line.bgClass;\n    if (cls) cls += " CodeMirror-linebackground";\n    if (lineView.background) {\n      if (cls) lineView.background.className = cls;\n      else { lineView.background.parentNode.removeChild(lineView.background); lineView.background = null; }\n    } else if (cls) {\n      var wrap = ensureLineWrapped(lineView);\n      lineView.background = wrap.insertBefore(elt("div", null, cls), wrap.firstChild);\n    }\n  }\n\n  // Wrapper around buildLineContent which will reuse the structure\n  // in display.externalMeasured when possible.\n  function getLineContent(cm, lineView) {\n    var ext = cm.display.externalMeasured;\n    if (ext && ext.line == lineView.line) {\n      cm.display.externalMeasured = null;\n      lineView.measure = ext.measure;\n      return ext.built;\n    }\n    return buildLineContent(cm, lineView);\n  }\n\n  // Redraw the line\'s text. Interacts with the background and text\n  // classes because the mode may output tokens that influence these\n  // classes.\n  function updateLineText(cm, lineView) {\n    var cls = lineView.text.className;\n    var built = getLineContent(cm, lineView);\n    if (lineView.text == lineView.node) lineView.node = built.pre;\n    lineView.text.parentNode.replaceChild(built.pre, lineView.text);\n    lineView.text = built.pre;\n    if (built.bgClass != lineView.bgClass || built.textClass != lineView.textClass) {\n      lineView.bgClass = built.bgClass;\n      lineView.textClass = built.textClass;\n      updateLineClasses(lineView);\n    } else if (cls) {\n      lineView.text.className = cls;\n    }\n  }\n\n  function updateLineClasses(lineView) {\n    updateLineBackground(lineView);\n    if (lineView.line.wrapClass)\n      ensureLineWrapped(lineView).className = lineView.line.wrapClass;\n    else if (lineView.node != lineView.text)\n      lineView.node.className = "";\n    var textClass = lineView.textClass ? lineView.textClass + " " + (lineView.line.textClass || "") : lineView.line.textClass;\n    lineView.text.className = textClass || "";\n  }\n\n  function updateLineGutter(cm, lineView, lineN, dims) {\n    if (lineView.gutter) {\n      lineView.node.removeChild(lineView.gutter);\n      lineView.gutter = null;\n    }\n    if (lineView.gutterBackground) {\n      lineView.node.removeChild(lineView.gutterBackground);\n      lineView.gutterBackground = null;\n    }\n    if (lineView.line.gutterClass) {\n      var wrap = ensureLineWrapped(lineView);\n      lineView.gutterBackground = elt("div", null, "CodeMirror-gutter-background " + lineView.line.gutterClass,\n                                      "left: " + (cm.options.fixedGutter ? dims.fixedPos : -dims.gutterTotalWidth) +\n                                      "px; width: " + dims.gutterTotalWidth + "px");\n      wrap.insertBefore(lineView.gutterBackground, lineView.text);\n    }\n    var markers = lineView.line.gutterMarkers;\n    if (cm.options.lineNumbers || markers) {\n      var wrap = ensureLineWrapped(lineView);\n      var gutterWrap = lineView.gutter = elt("div", null, "CodeMirror-gutter-wrapper", "left: " +\n                                             (cm.options.fixedGutter ? dims.fixedPos : -dims.gutterTotalWidth) + "px");\n      cm.display.input.setUneditable(gutterWrap);\n      wrap.insertBefore(gutterWrap, lineView.text);\n      if (lineView.line.gutterClass)\n        gutterWrap.className += " " + lineView.line.gutterClass;\n      if (cm.options.lineNumbers && (!markers || !markers["CodeMirror-linenumbers"]))\n        lineView.lineNumber = gutterWrap.appendChild(\n          elt("div", lineNumberFor(cm.options, lineN),\n              "CodeMirror-linenumber CodeMirror-gutter-elt",\n              "left: " + dims.gutterLeft["CodeMirror-linenumbers"] + "px; width: "\n              + cm.display.lineNumInnerWidth + "px"));\n      if (markers) for (var k = 0; k < cm.options.gutters.length; ++k) {\n        var id = cm.options.gutters[k], found = markers.hasOwnProperty(id) && markers[id];\n        if (found)\n          gutterWrap.appendChild(elt("div", [found], "CodeMirror-gutter-elt", "left: " +\n                                     dims.gutterLeft[id] + "px; width: " + dims.gutterWidth[id] + "px"));\n      }\n    }\n  }\n\n  function updateLineWidgets(cm, lineView, dims) {\n    if (lineView.alignable) lineView.alignable = null;\n    for (var node = lineView.node.firstChild, next; node; node = next) {\n      var next = node.nextSibling;\n      if (node.className == "CodeMirror-linewidget")\n        lineView.node.removeChild(node);\n    }\n    insertLineWidgets(cm, lineView, dims);\n  }\n\n  // Build a line\'s DOM representation from scratch\n  function buildLineElement(cm, lineView, lineN, dims) {\n    var built = getLineContent(cm, lineView);\n    lineView.text = lineView.node = built.pre;\n    if (built.bgClass) lineView.bgClass = built.bgClass;\n    if (built.textClass) lineView.textClass = built.textClass;\n\n    updateLineClasses(lineView);\n    updateLineGutter(cm, lineView, lineN, dims);\n    insertLineWidgets(cm, lineView, dims);\n    return lineView.node;\n  }\n\n  // A lineView may contain multiple logical lines (when merged by\n  // collapsed spans). The widgets for all of them need to be drawn.\n  function insertLineWidgets(cm, lineView, dims) {\n    insertLineWidgetsFor(cm, lineView.line, lineView, dims, true);\n    if (lineView.rest) for (var i = 0; i < lineView.rest.length; i++)\n      insertLineWidgetsFor(cm, lineView.rest[i], lineView, dims, false);\n  }\n\n  function insertLineWidgetsFor(cm, line, lineView, dims, allowAbove) {\n    if (!line.widgets) return;\n    var wrap = ensureLineWrapped(lineView);\n    for (var i = 0, ws = line.widgets; i < ws.length; ++i) {\n      var widget = ws[i], node = elt("div", [widget.node], "CodeMirror-linewidget");\n      if (!widget.handleMouseEvents) node.setAttribute("cm-ignore-events", "true");\n      positionLineWidget(widget, node, lineView, dims);\n      cm.display.input.setUneditable(node);\n      if (allowAbove && widget.above)\n        wrap.insertBefore(node, lineView.gutter || lineView.text);\n      else\n        wrap.appendChild(node);\n      signalLater(widget, "redraw");\n    }\n  }\n\n  function positionLineWidget(widget, node, lineView, dims) {\n    if (widget.noHScroll) {\n      (lineView.alignable || (lineView.alignable = [])).push(node);\n      var width = dims.wrapperWidth;\n      node.style.left = dims.fixedPos + "px";\n      if (!widget.coverGutter) {\n        width -= dims.gutterTotalWidth;\n        node.style.paddingLeft = dims.gutterTotalWidth + "px";\n      }\n      node.style.width = width + "px";\n    }\n    if (widget.coverGutter) {\n      node.style.zIndex = 5;\n      node.style.position = "relative";\n      if (!widget.noHScroll) node.style.marginLeft = -dims.gutterTotalWidth + "px";\n    }\n  }\n\n  // POSITION OBJECT\n\n  // A Pos instance represents a position within the text.\n  var Pos = CodeMirror.Pos = function(line, ch) {\n    if (!(this instanceof Pos)) return new Pos(line, ch);\n    this.line = line; this.ch = ch;\n  };\n\n  // Compare two positions, return 0 if they are the same, a negative\n  // number when a is less, and a positive number otherwise.\n  var cmp = CodeMirror.cmpPos = function(a, b) { return a.line - b.line || a.ch - b.ch; };\n\n  function copyPos(x) {return Pos(x.line, x.ch);}\n  function maxPos(a, b) { return cmp(a, b) < 0 ? b : a; }\n  function minPos(a, b) { return cmp(a, b) < 0 ? a : b; }\n\n  // INPUT HANDLING\n\n  function ensureFocus(cm) {\n    if (!cm.state.focused) { cm.display.input.focus(); onFocus(cm); }\n  }\n\n  function isReadOnly(cm) {\n    return cm.options.readOnly || cm.doc.cantEdit;\n  }\n\n  // This will be set to an array of strings when copying, so that,\n  // when pasting, we know what kind of selections the copied text\n  // was made out of.\n  var lastCopied = null;\n\n  function applyTextInput(cm, inserted, deleted, sel, origin) {\n    var doc = cm.doc;\n    cm.display.shift = false;\n    if (!sel) sel = doc.sel;\n\n    var paste = cm.state.pasteIncoming || origin == "paste";\n    var textLines = doc.splitLines(inserted), multiPaste = null;\n    // When pasing N lines into N selections, insert one line per selection\n    if (paste && sel.ranges.length > 1) {\n      if (lastCopied && lastCopied.join("\\n") == inserted) {\n        if (sel.ranges.length % lastCopied.length == 0) {\n          multiPaste = [];\n          for (var i = 0; i < lastCopied.length; i++)\n            multiPaste.push(doc.splitLines(lastCopied[i]));\n        }\n      } else if (textLines.length == sel.ranges.length) {\n        multiPaste = map(textLines, function(l) { return [l]; });\n      }\n    }\n\n    // Normal behavior is to insert the new text into every selection\n    for (var i = sel.ranges.length - 1; i >= 0; i--) {\n      var range = sel.ranges[i];\n      var from = range.from(), to = range.to();\n      if (range.empty()) {\n        if (deleted && deleted > 0) // Handle deletion\n          from = Pos(from.line, from.ch - deleted);\n        else if (cm.state.overwrite && !paste) // Handle overwrite\n          to = Pos(to.line, Math.min(getLine(doc, to.line).text.length, to.ch + lst(textLines).length));\n      }\n      var updateInput = cm.curOp.updateInput;\n      var changeEvent = {from: from, to: to, text: multiPaste ? multiPaste[i % multiPaste.length] : textLines,\n                         origin: origin || (paste ? "paste" : cm.state.cutIncoming ? "cut" : "+input")};\n      makeChange(cm.doc, changeEvent);\n      signalLater(cm, "inputRead", cm, changeEvent);\n    }\n    if (inserted && !paste)\n      triggerElectric(cm, inserted);\n\n    ensureCursorVisible(cm);\n    cm.curOp.updateInput = updateInput;\n    cm.curOp.typing = true;\n    cm.state.pasteIncoming = cm.state.cutIncoming = false;\n  }\n\n  function handlePaste(e, cm) {\n    var pasted = e.clipboardData && e.clipboardData.getData("text/plain");\n    if (pasted) {\n      e.preventDefault();\n      if (!isReadOnly(cm) && !cm.options.disableInput)\n        runInOp(cm, function() { applyTextInput(cm, pasted, 0, null, "paste"); });\n      return true;\n    }\n  }\n\n  function triggerElectric(cm, inserted) {\n    // When an \'electric\' character is inserted, immediately trigger a reindent\n    if (!cm.options.electricChars || !cm.options.smartIndent) return;\n    var sel = cm.doc.sel;\n\n    for (var i = sel.ranges.length - 1; i >= 0; i--) {\n      var range = sel.ranges[i];\n      if (range.head.ch > 100 || (i && sel.ranges[i - 1].head.line == range.head.line)) continue;\n      var mode = cm.getModeAt(range.head);\n      var indented = false;\n      if (mode.electricChars) {\n        for (var j = 0; j < mode.electricChars.length; j++)\n          if (inserted.indexOf(mode.electricChars.charAt(j)) > -1) {\n            indented = indentLine(cm, range.head.line, "smart");\n            break;\n          }\n      } else if (mode.electricInput) {\n        if (mode.electricInput.test(getLine(cm.doc, range.head.line).text.slice(0, range.head.ch)))\n          indented = indentLine(cm, range.head.line, "smart");\n      }\n      if (indented) signalLater(cm, "electricInput", cm, range.head.line);\n    }\n  }\n\n  function copyableRanges(cm) {\n    var text = [], ranges = [];\n    for (var i = 0; i < cm.doc.sel.ranges.length; i++) {\n      var line = cm.doc.sel.ranges[i].head.line;\n      var lineRange = {anchor: Pos(line, 0), head: Pos(line + 1, 0)};\n      ranges.push(lineRange);\n      text.push(cm.getRange(lineRange.anchor, lineRange.head));\n    }\n    return {text: text, ranges: ranges};\n  }\n\n  function disableBrowserMagic(field) {\n    field.setAttribute("autocorrect", "off");\n    field.setAttribute("autocapitalize", "off");\n    field.setAttribute("spellcheck", "false");\n  }\n\n  // TEXTAREA INPUT STYLE\n\n  function TextareaInput(cm) {\n    this.cm = cm;\n    // See input.poll and input.reset\n    this.prevInput = "";\n\n    // Flag that indicates whether we expect input to appear real soon\n    // now (after some event like \'keypress\' or \'input\') and are\n    // polling intensively.\n    this.pollingFast = false;\n    // Self-resetting timeout for the poller\n    this.polling = new Delayed();\n    // Tracks when input.reset has punted to just putting a short\n    // string into the textarea instead of the full selection.\n    this.inaccurateSelection = false;\n    // Used to work around IE issue with selection being forgotten when focus moves away from textarea\n    this.hasSelection = false;\n    this.composing = null;\n  };\n\n  function hiddenTextarea() {\n    var te = elt("textarea", null, null, "position: absolute; padding: 0; width: 1px; height: 1em; outline: none");\n    var div = elt("div", [te], null, "overflow: hidden; position: relative; width: 3px; height: 0px;");\n    // The textarea is kept positioned near the cursor to prevent the\n    // fact that it\'ll be scrolled into view on input from scrolling\n    // our fake cursor out of view. On webkit, when wrap=off, paste is\n    // very slow. So make the area wide instead.\n    if (webkit) te.style.width = "1000px";\n    else te.setAttribute("wrap", "off");\n    // If border: 0; -- iOS fails to open keyboard (issue #1287)\n    if (ios) te.style.border = "1px solid black";\n    disableBrowserMagic(te);\n    return div;\n  }\n\n  TextareaInput.prototype = copyObj({\n    init: function(display) {\n      var input = this, cm = this.cm;\n\n      // Wraps and hides input textarea\n      var div = this.wrapper = hiddenTextarea();\n      // The semihidden textarea that is focused when the editor is\n      // focused, and receives input.\n      var te = this.textarea = div.firstChild;\n      display.wrapper.insertBefore(div, display.wrapper.firstChild);\n\n      // Needed to hide big blue blinking cursor on Mobile Safari (doesn\'t seem to work in iOS 8 anymore)\n      if (ios) te.style.width = "0px";\n\n      on(te, "input", function() {\n        if (ie && ie_version >= 9 && input.hasSelection) input.hasSelection = null;\n        input.poll();\n      });\n\n      on(te, "paste", function(e) {\n        if (handlePaste(e, cm)) return true;\n\n        cm.state.pasteIncoming = true;\n        input.fastPoll();\n      });\n\n      function prepareCopyCut(e) {\n        if (cm.somethingSelected()) {\n          lastCopied = cm.getSelections();\n          if (input.inaccurateSelection) {\n            input.prevInput = "";\n            input.inaccurateSelection = false;\n            te.value = lastCopied.join("\\n");\n            selectInput(te);\n          }\n        } else if (!cm.options.lineWiseCopyCut) {\n          return;\n        } else {\n          var ranges = copyableRanges(cm);\n          lastCopied = ranges.text;\n          if (e.type == "cut") {\n            cm.setSelections(ranges.ranges, null, sel_dontScroll);\n          } else {\n            input.prevInput = "";\n            te.value = ranges.text.join("\\n");\n            selectInput(te);\n          }\n        }\n        if (e.type == "cut") cm.state.cutIncoming = true;\n      }\n      on(te, "cut", prepareCopyCut);\n      on(te, "copy", prepareCopyCut);\n\n      on(display.scroller, "paste", function(e) {\n        if (eventInWidget(display, e)) return;\n        cm.state.pasteIncoming = true;\n        input.focus();\n      });\n\n      // Prevent normal selection in the editor (we handle our own)\n      on(display.lineSpace, "selectstart", function(e) {\n        if (!eventInWidget(display, e)) e_preventDefault(e);\n      });\n\n      on(te, "compositionstart", function() {\n        var start = cm.getCursor("from");\n        input.composing = {\n          start: start,\n          range: cm.markText(start, cm.getCursor("to"), {className: "CodeMirror-composing"})\n        };\n      });\n      on(te, "compositionend", function() {\n        if (input.composing) {\n          input.poll();\n          input.composing.range.clear();\n          input.composing = null;\n        }\n      });\n    },\n\n    prepareSelection: function() {\n      // Redraw the selection and/or cursor\n      var cm = this.cm, display = cm.display, doc = cm.doc;\n      var result = prepareSelection(cm);\n\n      // Move the hidden textarea near the cursor to prevent scrolling artifacts\n      if (cm.options.moveInputWithCursor) {\n        var headPos = cursorCoords(cm, doc.sel.primary().head, "div");\n        var wrapOff = display.wrapper.getBoundingClientRect(), lineOff = display.lineDiv.getBoundingClientRect();\n        result.teTop = Math.max(0, Math.min(display.wrapper.clientHeight - 10,\n                                            headPos.top + lineOff.top - wrapOff.top));\n        result.teLeft = Math.max(0, Math.min(display.wrapper.clientWidth - 10,\n                                             headPos.left + lineOff.left - wrapOff.left));\n      }\n\n      return result;\n    },\n\n    showSelection: function(drawn) {\n      var cm = this.cm, display = cm.display;\n      removeChildrenAndAdd(display.cursorDiv, drawn.cursors);\n      removeChildrenAndAdd(display.selectionDiv, drawn.selection);\n      if (drawn.teTop != null) {\n        this.wrapper.style.top = drawn.teTop + "px";\n        this.wrapper.style.left = drawn.teLeft + "px";\n      }\n    },\n\n    // Reset the input to correspond to the selection (or to be empty,\n    // when not typing and nothing is selected)\n    reset: function(typing) {\n      if (this.contextMenuPending) return;\n      var minimal, selected, cm = this.cm, doc = cm.doc;\n      if (cm.somethingSelected()) {\n        this.prevInput = "";\n        var range = doc.sel.primary();\n        minimal = hasCopyEvent &&\n          (range.to().line - range.from().line > 100 || (selected = cm.getSelection()).length > 1000);\n        var content = minimal ? "-" : selected || cm.getSelection();\n        this.textarea.value = content;\n        if (cm.state.focused) selectInput(this.textarea);\n        if (ie && ie_version >= 9) this.hasSelection = content;\n      } else if (!typing) {\n        this.prevInput = this.textarea.value = "";\n        if (ie && ie_version >= 9) this.hasSelection = null;\n      }\n      this.inaccurateSelection = minimal;\n    },\n\n    getField: function() { return this.textarea; },\n\n    supportsTouch: function() { return false; },\n\n    focus: function() {\n      if (this.cm.options.readOnly != "nocursor" && (!mobile || activeElt() != this.textarea)) {\n        try { this.textarea.focus(); }\n        catch (e) {} // IE8 will throw if the textarea is display: none or not in DOM\n      }\n    },\n\n    blur: function() { this.textarea.blur(); },\n\n    resetPosition: function() {\n      this.wrapper.style.top = this.wrapper.style.left = 0;\n    },\n\n    receivedFocus: function() { this.slowPoll(); },\n\n    // Poll for input changes, using the normal rate of polling. This\n    // runs as long as the editor is focused.\n    slowPoll: function() {\n      var input = this;\n      if (input.pollingFast) return;\n      input.polling.set(this.cm.options.pollInterval, function() {\n        input.poll();\n        if (input.cm.state.focused) input.slowPoll();\n      });\n    },\n\n    // When an event has just come in that is likely to add or change\n    // something in the input textarea, we poll faster, to ensure that\n    // the change appears on the screen quickly.\n    fastPoll: function() {\n      var missed = false, input = this;\n      input.pollingFast = true;\n      function p() {\n        var changed = input.poll();\n        if (!changed && !missed) {missed = true; input.polling.set(60, p);}\n        else {input.pollingFast = false; input.slowPoll();}\n      }\n      input.polling.set(20, p);\n    },\n\n    // Read input from the textarea, and update the document to match.\n    // When something is selected, it is present in the textarea, and\n    // selected (unless it is huge, in which case a placeholder is\n    // used). When nothing is selected, the cursor sits after previously\n    // seen text (can be empty), which is stored in prevInput (we must\n    // not reset the textarea when typing, because that breaks IME).\n    poll: function() {\n      var cm = this.cm, input = this.textarea, prevInput = this.prevInput;\n      // Since this is called a *lot*, try to bail out as cheaply as\n      // possible when it is clear that nothing happened. hasSelection\n      // will be the case when there is a lot of text in the textarea,\n      // in which case reading its value would be expensive.\n      if (this.contextMenuPending || !cm.state.focused ||\n          (hasSelection(input) && !prevInput && !this.composing) ||\n          isReadOnly(cm) || cm.options.disableInput || cm.state.keySeq)\n        return false;\n\n      var text = input.value;\n      // If nothing changed, bail.\n      if (text == prevInput && !cm.somethingSelected()) return false;\n      // Work around nonsensical selection resetting in IE9/10, and\n      // inexplicable appearance of private area unicode characters on\n      // some key combos in Mac (#2689).\n      if (ie && ie_version >= 9 && this.hasSelection === text ||\n          mac && /[\\uf700-\\uf7ff]/.test(text)) {\n        cm.display.input.reset();\n        return false;\n      }\n\n      if (cm.doc.sel == cm.display.selForContextMenu) {\n        var first = text.charCodeAt(0);\n        if (first == 0x200b && !prevInput) prevInput = "\\u200b";\n        if (first == 0x21da) { this.reset(); return this.cm.execCommand("undo"); }\n      }\n      // Find the part of the input that is actually new\n      var same = 0, l = Math.min(prevInput.length, text.length);\n      while (same < l && prevInput.charCodeAt(same) == text.charCodeAt(same)) ++same;\n\n      var self = this;\n      runInOp(cm, function() {\n        applyTextInput(cm, text.slice(same), prevInput.length - same,\n                       null, self.composing ? "*compose" : null);\n\n        // Don\'t leave long text in the textarea, since it makes further polling slow\n        if (text.length > 1000 || text.indexOf("\\n") > -1) input.value = self.prevInput = "";\n        else self.prevInput = text;\n\n        if (self.composing) {\n          self.composing.range.clear();\n          self.composing.range = cm.markText(self.composing.start, cm.getCursor("to"),\n                                             {className: "CodeMirror-composing"});\n        }\n      });\n      return true;\n    },\n\n    ensurePolled: function() {\n      if (this.pollingFast && this.poll()) this.pollingFast = false;\n    },\n\n    onKeyPress: function() {\n      if (ie && ie_version >= 9) this.hasSelection = null;\n      this.fastPoll();\n    },\n\n    onContextMenu: function(e) {\n      var input = this, cm = input.cm, display = cm.display, te = input.textarea;\n      var pos = posFromMouse(cm, e), scrollPos = display.scroller.scrollTop;\n      if (!pos || presto) return; // Opera is difficult.\n\n      // Reset the current text selection only if the click is done outside of the selection\n      // and \'resetSelectionOnContextMenu\' option is true.\n      var reset = cm.options.resetSelectionOnContextMenu;\n      if (reset && cm.doc.sel.contains(pos) == -1)\n        operation(cm, setSelection)(cm.doc, simpleSelection(pos), sel_dontScroll);\n\n      var oldCSS = te.style.cssText;\n      input.wrapper.style.position = "absolute";\n      te.style.cssText = "position: fixed; width: 30px; height: 30px; top: " + (e.clientY - 5) +\n        "px; left: " + (e.clientX - 5) + "px; z-index: 1000; background: " +\n        (ie ? "rgba(255, 255, 255, .05)" : "transparent") +\n        "; outline: none; border-width: 0; outline: none; overflow: hidden; opacity: .05; filter: alpha(opacity=5);";\n      if (webkit) var oldScrollY = window.scrollY; // Work around Chrome issue (#2712)\n      display.input.focus();\n      if (webkit) window.scrollTo(null, oldScrollY);\n      display.input.reset();\n      // Adds "Select all" to context menu in FF\n      if (!cm.somethingSelected()) te.value = input.prevInput = " ";\n      input.contextMenuPending = true;\n      display.selForContextMenu = cm.doc.sel;\n      clearTimeout(display.detectingSelectAll);\n\n      // Select-all will be greyed out if there\'s nothing to select, so\n      // this adds a zero-width space so that we can later check whether\n      // it got selected.\n      function prepareSelectAllHack() {\n        if (te.selectionStart != null) {\n          var selected = cm.somethingSelected();\n          var extval = "\\u200b" + (selected ? te.value : "");\n          te.value = "\\u21da"; // Used to catch context-menu undo\n          te.value = extval;\n          input.prevInput = selected ? "" : "\\u200b";\n          te.selectionStart = 1; te.selectionEnd = extval.length;\n          // Re-set this, in case some other handler touched the\n          // selection in the meantime.\n          display.selForContextMenu = cm.doc.sel;\n        }\n      }\n      function rehide() {\n        input.contextMenuPending = false;\n        input.wrapper.style.position = "relative";\n        te.style.cssText = oldCSS;\n        if (ie && ie_version < 9) display.scrollbars.setScrollTop(display.scroller.scrollTop = scrollPos);\n\n        // Try to detect the user choosing select-all\n        if (te.selectionStart != null) {\n          if (!ie || (ie && ie_version < 9)) prepareSelectAllHack();\n          var i = 0, poll = function() {\n            if (display.selForContextMenu == cm.doc.sel && te.selectionStart == 0 &&\n                te.selectionEnd > 0 && input.prevInput == "\\u200b")\n              operation(cm, commands.selectAll)(cm);\n            else if (i++ < 10) display.detectingSelectAll = setTimeout(poll, 500);\n            else display.input.reset();\n          };\n          display.detectingSelectAll = setTimeout(poll, 200);\n        }\n      }\n\n      if (ie && ie_version >= 9) prepareSelectAllHack();\n      if (captureRightClick) {\n        e_stop(e);\n        var mouseup = function() {\n          off(window, "mouseup", mouseup);\n          setTimeout(rehide, 20);\n        };\n        on(window, "mouseup", mouseup);\n      } else {\n        setTimeout(rehide, 50);\n      }\n    },\n\n    setUneditable: nothing,\n\n    needsContentAttribute: false\n  }, TextareaInput.prototype);\n\n  // CONTENTEDITABLE INPUT STYLE\n\n  function ContentEditableInput(cm) {\n    this.cm = cm;\n    this.lastAnchorNode = this.lastAnchorOffset = this.lastFocusNode = this.lastFocusOffset = null;\n    this.polling = new Delayed();\n    this.gracePeriod = false;\n  }\n\n  ContentEditableInput.prototype = copyObj({\n    init: function(display) {\n      var input = this, cm = input.cm;\n      var div = input.div = display.lineDiv;\n      div.contentEditable = "true";\n      disableBrowserMagic(div);\n\n      on(div, "paste", function(e) { handlePaste(e, cm); })\n\n      on(div, "compositionstart", function(e) {\n        var data = e.data;\n        input.composing = {sel: cm.doc.sel, data: data, startData: data};\n        if (!data) return;\n        var prim = cm.doc.sel.primary();\n        var line = cm.getLine(prim.head.line);\n        var found = line.indexOf(data, Math.max(0, prim.head.ch - data.length));\n        if (found > -1 && found <= prim.head.ch)\n          input.composing.sel = simpleSelection(Pos(prim.head.line, found),\n                                                Pos(prim.head.line, found + data.length));\n      });\n      on(div, "compositionupdate", function(e) {\n        input.composing.data = e.data;\n      });\n      on(div, "compositionend", function(e) {\n        var ours = input.composing;\n        if (!ours) return;\n        if (e.data != ours.startData && !/\\u200b/.test(e.data))\n          ours.data = e.data;\n        // Need a small delay to prevent other code (input event,\n        // selection polling) from doing damage when fired right after\n        // compositionend.\n        setTimeout(function() {\n          if (!ours.handled)\n            input.applyComposition(ours);\n          if (input.composing == ours)\n            input.composing = null;\n        }, 50);\n      });\n\n      on(div, "touchstart", function() {\n        input.forceCompositionEnd();\n      });\n\n      on(div, "input", function() {\n        if (input.composing) return;\n        if (!input.pollContent())\n          runInOp(input.cm, function() {regChange(cm);});\n      });\n\n      function onCopyCut(e) {\n        if (cm.somethingSelected()) {\n          lastCopied = cm.getSelections();\n          if (e.type == "cut") cm.replaceSelection("", null, "cut");\n        } else if (!cm.options.lineWiseCopyCut) {\n          return;\n        } else {\n          var ranges = copyableRanges(cm);\n          lastCopied = ranges.text;\n          if (e.type == "cut") {\n            cm.operation(function() {\n              cm.setSelections(ranges.ranges, 0, sel_dontScroll);\n              cm.replaceSelection("", null, "cut");\n            });\n          }\n        }\n        // iOS exposes the clipboard API, but seems to discard content inserted into it\n        if (e.clipboardData && !ios) {\n          e.preventDefault();\n          e.clipboardData.clearData();\n          e.clipboardData.setData("text/plain", lastCopied.join("\\n"));\n        } else {\n          // Old-fashioned briefly-focus-a-textarea hack\n          var kludge = hiddenTextarea(), te = kludge.firstChild;\n          cm.display.lineSpace.insertBefore(kludge, cm.display.lineSpace.firstChild);\n          te.value = lastCopied.join("\\n");\n          var hadFocus = document.activeElement;\n          selectInput(te);\n          setTimeout(function() {\n            cm.display.lineSpace.removeChild(kludge);\n            hadFocus.focus();\n          }, 50);\n        }\n      }\n      on(div, "copy", onCopyCut);\n      on(div, "cut", onCopyCut);\n    },\n\n    prepareSelection: function() {\n      var result = prepareSelection(this.cm, false);\n      result.focus = this.cm.state.focused;\n      return result;\n    },\n\n    showSelection: function(info) {\n      if (!info || !this.cm.display.view.length) return;\n      if (info.focus) this.showPrimarySelection();\n      this.showMultipleSelections(info);\n    },\n\n    showPrimarySelection: function() {\n      var sel = window.getSelection(), prim = this.cm.doc.sel.primary();\n      var curAnchor = domToPos(this.cm, sel.anchorNode, sel.anchorOffset);\n      var curFocus = domToPos(this.cm, sel.focusNode, sel.focusOffset);\n      if (curAnchor && !curAnchor.bad && curFocus && !curFocus.bad &&\n          cmp(minPos(curAnchor, curFocus), prim.from()) == 0 &&\n          cmp(maxPos(curAnchor, curFocus), prim.to()) == 0)\n        return;\n\n      var start = posToDOM(this.cm, prim.from());\n      var end = posToDOM(this.cm, prim.to());\n      if (!start && !end) return;\n\n      var view = this.cm.display.view;\n      var old = sel.rangeCount && sel.getRangeAt(0);\n      if (!start) {\n        start = {node: view[0].measure.map[2], offset: 0};\n      } else if (!end) { // FIXME dangerously hacky\n        var measure = view[view.length - 1].measure;\n        var map = measure.maps ? measure.maps[measure.maps.length - 1] : measure.map;\n        end = {node: map[map.length - 1], offset: map[map.length - 2] - map[map.length - 3]};\n      }\n\n      try { var rng = range(start.node, start.offset, end.offset, end.node); }\n      catch(e) {} // Our model of the DOM might be outdated, in which case the range we try to set can be impossible\n      if (rng) {\n        sel.removeAllRanges();\n        sel.addRange(rng);\n        if (old && sel.anchorNode == null) sel.addRange(old);\n        else if (gecko) this.startGracePeriod();\n      }\n      this.rememberSelection();\n    },\n\n    startGracePeriod: function() {\n      var input = this;\n      clearTimeout(this.gracePeriod);\n      this.gracePeriod = setTimeout(function() {\n        input.gracePeriod = false;\n        if (input.selectionChanged())\n          input.cm.operation(function() { input.cm.curOp.selectionChanged = true; });\n      }, 20);\n    },\n\n    showMultipleSelections: function(info) {\n      removeChildrenAndAdd(this.cm.display.cursorDiv, info.cursors);\n      removeChildrenAndAdd(this.cm.display.selectionDiv, info.selection);\n    },\n\n    rememberSelection: function() {\n      var sel = window.getSelection();\n      this.lastAnchorNode = sel.anchorNode; this.lastAnchorOffset = sel.anchorOffset;\n      this.lastFocusNode = sel.focusNode; this.lastFocusOffset = sel.focusOffset;\n    },\n\n    selectionInEditor: function() {\n      var sel = window.getSelection();\n      if (!sel.rangeCount) return false;\n      var node = sel.getRangeAt(0).commonAncestorContainer;\n      return contains(this.div, node);\n    },\n\n    focus: function() {\n      if (this.cm.options.readOnly != "nocursor") this.div.focus();\n    },\n    blur: function() { this.div.blur(); },\n    getField: function() { return this.div; },\n\n    supportsTouch: function() { return true; },\n\n    receivedFocus: function() {\n      var input = this;\n      if (this.selectionInEditor())\n        this.pollSelection();\n      else\n        runInOp(this.cm, function() { input.cm.curOp.selectionChanged = true; });\n\n      function poll() {\n        if (input.cm.state.focused) {\n          input.pollSelection();\n          input.polling.set(input.cm.options.pollInterval, poll);\n        }\n      }\n      this.polling.set(this.cm.options.pollInterval, poll);\n    },\n\n    selectionChanged: function() {\n      var sel = window.getSelection();\n      return sel.anchorNode != this.lastAnchorNode || sel.anchorOffset != this.lastAnchorOffset ||\n        sel.focusNode != this.lastFocusNode || sel.focusOffset != this.lastFocusOffset;\n    },\n\n    pollSelection: function() {\n      if (!this.composing && !this.gracePeriod && this.selectionChanged()) {\n        var sel = window.getSelection(), cm = this.cm;\n        this.rememberSelection();\n        var anchor = domToPos(cm, sel.anchorNode, sel.anchorOffset);\n        var head = domToPos(cm, sel.focusNode, sel.focusOffset);\n        if (anchor && head) runInOp(cm, function() {\n          setSelection(cm.doc, simpleSelection(anchor, head), sel_dontScroll);\n          if (anchor.bad || head.bad) cm.curOp.selectionChanged = true;\n        });\n      }\n    },\n\n    pollContent: function() {\n      var cm = this.cm, display = cm.display, sel = cm.doc.sel.primary();\n      var from = sel.from(), to = sel.to();\n      if (from.line < display.viewFrom || to.line > display.viewTo - 1) return false;\n\n      var fromIndex;\n      if (from.line == display.viewFrom || (fromIndex = findViewIndex(cm, from.line)) == 0) {\n        var fromLine = lineNo(display.view[0].line);\n        var fromNode = display.view[0].node;\n      } else {\n        var fromLine = lineNo(display.view[fromIndex].line);\n        var fromNode = display.view[fromIndex - 1].node.nextSibling;\n      }\n      var toIndex = findViewIndex(cm, to.line);\n      if (toIndex == display.view.length - 1) {\n        var toLine = display.viewTo - 1;\n        var toNode = display.lineDiv.lastChild;\n      } else {\n        var toLine = lineNo(display.view[toIndex + 1].line) - 1;\n        var toNode = display.view[toIndex + 1].node.previousSibling;\n      }\n\n      var newText = cm.doc.splitLines(domTextBetween(cm, fromNode, toNode, fromLine, toLine));\n      var oldText = getBetween(cm.doc, Pos(fromLine, 0), Pos(toLine, getLine(cm.doc, toLine).text.length));\n      while (newText.length > 1 && oldText.length > 1) {\n        if (lst(newText) == lst(oldText)) { newText.pop(); oldText.pop(); toLine--; }\n        else if (newText[0] == oldText[0]) { newText.shift(); oldText.shift(); fromLine++; }\n        else break;\n      }\n\n      var cutFront = 0, cutEnd = 0;\n      var newTop = newText[0], oldTop = oldText[0], maxCutFront = Math.min(newTop.length, oldTop.length);\n      while (cutFront < maxCutFront && newTop.charCodeAt(cutFront) == oldTop.charCodeAt(cutFront))\n        ++cutFront;\n      var newBot = lst(newText), oldBot = lst(oldText);\n      var maxCutEnd = Math.min(newBot.length - (newText.length == 1 ? cutFront : 0),\n                               oldBot.length - (oldText.length == 1 ? cutFront : 0));\n      while (cutEnd < maxCutEnd &&\n             newBot.charCodeAt(newBot.length - cutEnd - 1) == oldBot.charCodeAt(oldBot.length - cutEnd - 1))\n        ++cutEnd;\n\n      newText[newText.length - 1] = newBot.slice(0, newBot.length - cutEnd);\n      newText[0] = newText[0].slice(cutFront);\n\n      var chFrom = Pos(fromLine, cutFront);\n      var chTo = Pos(toLine, oldText.length ? lst(oldText).length - cutEnd : 0);\n      if (newText.length > 1 || newText[0] || cmp(chFrom, chTo)) {\n        replaceRange(cm.doc, newText, chFrom, chTo, "+input");\n        return true;\n      }\n    },\n\n    ensurePolled: function() {\n      this.forceCompositionEnd();\n    },\n    reset: function() {\n      this.forceCompositionEnd();\n    },\n    forceCompositionEnd: function() {\n      if (!this.composing || this.composing.handled) return;\n      this.applyComposition(this.composing);\n      this.composing.handled = true;\n      this.div.blur();\n      this.div.focus();\n    },\n    applyComposition: function(composing) {\n      if (composing.data && composing.data != composing.startData)\n        operation(this.cm, applyTextInput)(this.cm, composing.data, 0, composing.sel);\n    },\n\n    setUneditable: function(node) {\n      node.setAttribute("contenteditable", "false");\n    },\n\n    onKeyPress: function(e) {\n      e.preventDefault();\n      operation(this.cm, applyTextInput)(this.cm, String.fromCharCode(e.charCode == null ? e.keyCode : e.charCode), 0);\n    },\n\n    onContextMenu: nothing,\n    resetPosition: nothing,\n\n    needsContentAttribute: true\n  }, ContentEditableInput.prototype);\n\n  function posToDOM(cm, pos) {\n    var view = findViewForLine(cm, pos.line);\n    if (!view || view.hidden) return null;\n    var line = getLine(cm.doc, pos.line);\n    var info = mapFromLineView(view, line, pos.line);\n\n    var order = getOrder(line), side = "left";\n    if (order) {\n      var partPos = getBidiPartAt(order, pos.ch);\n      side = partPos % 2 ? "right" : "left";\n    }\n    var result = nodeAndOffsetInLineMap(info.map, pos.ch, side);\n    result.offset = result.collapse == "right" ? result.end : result.start;\n    return result;\n  }\n\n  function badPos(pos, bad) { if (bad) pos.bad = true; return pos; }\n\n  function domToPos(cm, node, offset) {\n    var lineNode;\n    if (node == cm.display.lineDiv) {\n      lineNode = cm.display.lineDiv.childNodes[offset];\n      if (!lineNode) return badPos(cm.clipPos(Pos(cm.display.viewTo - 1)), true);\n      node = null; offset = 0;\n    } else {\n      for (lineNode = node;; lineNode = lineNode.parentNode) {\n        if (!lineNode || lineNode == cm.display.lineDiv) return null;\n        if (lineNode.parentNode && lineNode.parentNode == cm.display.lineDiv) break;\n      }\n    }\n    for (var i = 0; i < cm.display.view.length; i++) {\n      var lineView = cm.display.view[i];\n      if (lineView.node == lineNode)\n        return locateNodeInLineView(lineView, node, offset);\n    }\n  }\n\n  function locateNodeInLineView(lineView, node, offset) {\n    var wrapper = lineView.text.firstChild, bad = false;\n    if (!node || !contains(wrapper, node)) return badPos(Pos(lineNo(lineView.line), 0), true);\n    if (node == wrapper) {\n      bad = true;\n      node = wrapper.childNodes[offset];\n      offset = 0;\n      if (!node) {\n        var line = lineView.rest ? lst(lineView.rest) : lineView.line;\n        return badPos(Pos(lineNo(line), line.text.length), bad);\n      }\n    }\n\n    var textNode = node.nodeType == 3 ? node : null, topNode = node;\n    if (!textNode && node.childNodes.length == 1 && node.firstChild.nodeType == 3) {\n      textNode = node.firstChild;\n      if (offset) offset = textNode.nodeValue.length;\n    }\n    while (topNode.parentNode != wrapper) topNode = topNode.parentNode;\n    var measure = lineView.measure, maps = measure.maps;\n\n    function find(textNode, topNode, offset) {\n      for (var i = -1; i < (maps ? maps.length : 0); i++) {\n        var map = i < 0 ? measure.map : maps[i];\n        for (var j = 0; j < map.length; j += 3) {\n          var curNode = map[j + 2];\n          if (curNode == textNode || curNode == topNode) {\n            var line = lineNo(i < 0 ? lineView.line : lineView.rest[i]);\n            var ch = map[j] + offset;\n            if (offset < 0 || curNode != textNode) ch = map[j + (offset ? 1 : 0)];\n            return Pos(line, ch);\n          }\n        }\n      }\n    }\n    var found = find(textNode, topNode, offset);\n    if (found) return badPos(found, bad);\n\n    // FIXME this is all really shaky. might handle the few cases it needs to handle, but likely to cause problems\n    for (var after = topNode.nextSibling, dist = textNode ? textNode.nodeValue.length - offset : 0; after; after = after.nextSibling) {\n      found = find(after, after.firstChild, 0);\n      if (found)\n        return badPos(Pos(found.line, found.ch - dist), bad);\n      else\n        dist += after.textContent.length;\n    }\n    for (var before = topNode.previousSibling, dist = offset; before; before = before.previousSibling) {\n      found = find(before, before.firstChild, -1);\n      if (found)\n        return badPos(Pos(found.line, found.ch + dist), bad);\n      else\n        dist += after.textContent.length;\n    }\n  }\n\n  function domTextBetween(cm, from, to, fromLine, toLine) {\n    var text = "", closing = false, lineSep = cm.doc.lineSeparator();\n    function recognizeMarker(id) { return function(marker) { return marker.id == id; }; }\n    function walk(node) {\n      if (node.nodeType == 1) {\n        var cmText = node.getAttribute("cm-text");\n        if (cmText != null) {\n          if (cmText == "") cmText = node.textContent.replace(/\\u200b/g, "");\n          text += cmText;\n          return;\n        }\n        var markerID = node.getAttribute("cm-marker"), range;\n        if (markerID) {\n          var found = cm.findMarks(Pos(fromLine, 0), Pos(toLine + 1, 0), recognizeMarker(+markerID));\n          if (found.length && (range = found[0].find()))\n            text += getBetween(cm.doc, range.from, range.to).join(lineSep);\n          return;\n        }\n        if (node.getAttribute("contenteditable") == "false") return;\n        for (var i = 0; i < node.childNodes.length; i++)\n          walk(node.childNodes[i]);\n        if (/^(pre|div|p)$/i.test(node.nodeName))\n          closing = true;\n      } else if (node.nodeType == 3) {\n        var val = node.nodeValue;\n        if (!val) return;\n        if (closing) {\n          text += lineSep;\n          closing = false;\n        }\n        text += val;\n      }\n    }\n    for (;;) {\n      walk(from);\n      if (from == to) break;\n      from = from.nextSibling;\n    }\n    return text;\n  }\n\n  CodeMirror.inputStyles = {"textarea": TextareaInput, "contenteditable": ContentEditableInput};\n\n  // SELECTION / CURSOR\n\n  // Selection objects are immutable. A new one is created every time\n  // the selection changes. A selection is one or more non-overlapping\n  // (and non-touching) ranges, sorted, and an integer that indicates\n  // which one is the primary selection (the one that\'s scrolled into\n  // view, that getCursor returns, etc).\n  function Selection(ranges, primIndex) {\n    this.ranges = ranges;\n    this.primIndex = primIndex;\n  }\n\n  Selection.prototype = {\n    primary: function() { return this.ranges[this.primIndex]; },\n    equals: function(other) {\n      if (other == this) return true;\n      if (other.primIndex != this.primIndex || other.ranges.length != this.ranges.length) return false;\n      for (var i = 0; i < this.ranges.length; i++) {\n        var here = this.ranges[i], there = other.ranges[i];\n        if (cmp(here.anchor, there.anchor) != 0 || cmp(here.head, there.head) != 0) return false;\n      }\n      return true;\n    },\n    deepCopy: function() {\n      for (var out = [], i = 0; i < this.ranges.length; i++)\n        out[i] = new Range(copyPos(this.ranges[i].anchor), copyPos(this.ranges[i].head));\n      return new Selection(out, this.primIndex);\n    },\n    somethingSelected: function() {\n      for (var i = 0; i < this.ranges.length; i++)\n        if (!this.ranges[i].empty()) return true;\n      return false;\n    },\n    contains: function(pos, end) {\n      if (!end) end = pos;\n      for (var i = 0; i < this.ranges.length; i++) {\n        var range = this.ranges[i];\n        if (cmp(end, range.from()) >= 0 && cmp(pos, range.to()) <= 0)\n          return i;\n      }\n      return -1;\n    }\n  };\n\n  function Range(anchor, head) {\n    this.anchor = anchor; this.head = head;\n  }\n\n  Range.prototype = {\n    from: function() { return minPos(this.anchor, this.head); },\n    to: function() { return maxPos(this.anchor, this.head); },\n    empty: function() {\n      return this.head.line == this.anchor.line && this.head.ch == this.anchor.ch;\n    }\n  };\n\n  // Take an unsorted, potentially overlapping set of ranges, and\n  // build a selection out of it. \'Consumes\' ranges array (modifying\n  // it).\n  function normalizeSelection(ranges, primIndex) {\n    var prim = ranges[primIndex];\n    ranges.sort(function(a, b) { return cmp(a.from(), b.from()); });\n    primIndex = indexOf(ranges, prim);\n    for (var i = 1; i < ranges.length; i++) {\n      var cur = ranges[i], prev = ranges[i - 1];\n      if (cmp(prev.to(), cur.from()) >= 0) {\n        var from = minPos(prev.from(), cur.from()), to = maxPos(prev.to(), cur.to());\n        var inv = prev.empty() ? cur.from() == cur.head : prev.from() == prev.head;\n        if (i <= primIndex) --primIndex;\n        ranges.splice(--i, 2, new Range(inv ? to : from, inv ? from : to));\n      }\n    }\n    return new Selection(ranges, primIndex);\n  }\n\n  function simpleSelection(anchor, head) {\n    return new Selection([new Range(anchor, head || anchor)], 0);\n  }\n\n  // Most of the external API clips given positions to make sure they\n  // actually exist within the document.\n  function clipLine(doc, n) {return Math.max(doc.first, Math.min(n, doc.first + doc.size - 1));}\n  function clipPos(doc, pos) {\n    if (pos.line < doc.first) return Pos(doc.first, 0);\n    var last = doc.first + doc.size - 1;\n    if (pos.line > last) return Pos(last, getLine(doc, last).text.length);\n    return clipToLen(pos, getLine(doc, pos.line).text.length);\n  }\n  function clipToLen(pos, linelen) {\n    var ch = pos.ch;\n    if (ch == null || ch > linelen) return Pos(pos.line, linelen);\n    else if (ch < 0) return Pos(pos.line, 0);\n    else return pos;\n  }\n  function isLine(doc, l) {return l >= doc.first && l < doc.first + doc.size;}\n  function clipPosArray(doc, array) {\n    for (var out = [], i = 0; i < array.length; i++) out[i] = clipPos(doc, array[i]);\n    return out;\n  }\n\n  // SELECTION UPDATES\n\n  // The \'scroll\' parameter given to many of these indicated whether\n  // the new cursor position should be scrolled into view after\n  // modifying the selection.\n\n  // If shift is held or the extend flag is set, extends a range to\n  // include a given position (and optionally a second position).\n  // Otherwise, simply returns the range between the given positions.\n  // Used for cursor motion and such.\n  function extendRange(doc, range, head, other) {\n    if (doc.cm && doc.cm.display.shift || doc.extend) {\n      var anchor = range.anchor;\n      if (other) {\n        var posBefore = cmp(head, anchor) < 0;\n        if (posBefore != (cmp(other, anchor) < 0)) {\n          anchor = head;\n          head = other;\n        } else if (posBefore != (cmp(head, other) < 0)) {\n          head = other;\n        }\n      }\n      return new Range(anchor, head);\n    } else {\n      return new Range(other || head, head);\n    }\n  }\n\n  // Extend the primary selection range, discard the rest.\n  function extendSelection(doc, head, other, options) {\n    setSelection(doc, new Selection([extendRange(doc, doc.sel.primary(), head, other)], 0), options);\n  }\n\n  // Extend all selections (pos is an array of selections with length\n  // equal the number of selections)\n  function extendSelections(doc, heads, options) {\n    for (var out = [], i = 0; i < doc.sel.ranges.length; i++)\n      out[i] = extendRange(doc, doc.sel.ranges[i], heads[i], null);\n    var newSel = normalizeSelection(out, doc.sel.primIndex);\n    setSelection(doc, newSel, options);\n  }\n\n  // Updates a single range in the selection.\n  function replaceOneSelection(doc, i, range, options) {\n    var ranges = doc.sel.ranges.slice(0);\n    ranges[i] = range;\n    setSelection(doc, normalizeSelection(ranges, doc.sel.primIndex), options);\n  }\n\n  // Reset the selection to a single range.\n  function setSimpleSelection(doc, anchor, head, options) {\n    setSelection(doc, simpleSelection(anchor, head), options);\n  }\n\n  // Give beforeSelectionChange handlers a change to influence a\n  // selection update.\n  function filterSelectionChange(doc, sel) {\n    var obj = {\n      ranges: sel.ranges,\n      update: function(ranges) {\n        this.ranges = [];\n        for (var i = 0; i < ranges.length; i++)\n          this.ranges[i] = new Range(clipPos(doc, ranges[i].anchor),\n                                     clipPos(doc, ranges[i].head));\n      }\n    };\n    signal(doc, "beforeSelectionChange", doc, obj);\n    if (doc.cm) signal(doc.cm, "beforeSelectionChange", doc.cm, obj);\n    if (obj.ranges != sel.ranges) return normalizeSelection(obj.ranges, obj.ranges.length - 1);\n    else return sel;\n  }\n\n  function setSelectionReplaceHistory(doc, sel, options) {\n    var done = doc.history.done, last = lst(done);\n    if (last && last.ranges) {\n      done[done.length - 1] = sel;\n      setSelectionNoUndo(doc, sel, options);\n    } else {\n      setSelection(doc, sel, options);\n    }\n  }\n\n  // Set a new selection.\n  function setSelection(doc, sel, options) {\n    setSelectionNoUndo(doc, sel, options);\n    addSelectionToHistory(doc, doc.sel, doc.cm ? doc.cm.curOp.id : NaN, options);\n  }\n\n  function setSelectionNoUndo(doc, sel, options) {\n    if (hasHandler(doc, "beforeSelectionChange") || doc.cm && hasHandler(doc.cm, "beforeSelectionChange"))\n      sel = filterSelectionChange(doc, sel);\n\n    var bias = options && options.bias ||\n      (cmp(sel.primary().head, doc.sel.primary().head) < 0 ? -1 : 1);\n    setSelectionInner(doc, skipAtomicInSelection(doc, sel, bias, true));\n\n    if (!(options && options.scroll === false) && doc.cm)\n      ensureCursorVisible(doc.cm);\n  }\n\n  function setSelectionInner(doc, sel) {\n    if (sel.equals(doc.sel)) return;\n\n    doc.sel = sel;\n\n    if (doc.cm) {\n      doc.cm.curOp.updateInput = doc.cm.curOp.selectionChanged = true;\n      signalCursorActivity(doc.cm);\n    }\n    signalLater(doc, "cursorActivity", doc);\n  }\n\n  // Verify that the selection does not partially select any atomic\n  // marked ranges.\n  function reCheckSelection(doc) {\n    setSelectionInner(doc, skipAtomicInSelection(doc, doc.sel, null, false), sel_dontScroll);\n  }\n\n  // Return a selection that does not partially select any atomic\n  // ranges.\n  function skipAtomicInSelection(doc, sel, bias, mayClear) {\n    var out;\n    for (var i = 0; i < sel.ranges.length; i++) {\n      var range = sel.ranges[i];\n      var newAnchor = skipAtomic(doc, range.anchor, bias, mayClear);\n      var newHead = skipAtomic(doc, range.head, bias, mayClear);\n      if (out || newAnchor != range.anchor || newHead != range.head) {\n        if (!out) out = sel.ranges.slice(0, i);\n        out[i] = new Range(newAnchor, newHead);\n      }\n    }\n    return out ? normalizeSelection(out, sel.primIndex) : sel;\n  }\n\n  // Ensure a given position is not inside an atomic range.\n  function skipAtomic(doc, pos, bias, mayClear) {\n    var flipped = false, curPos = pos;\n    var dir = bias || 1;\n    doc.cantEdit = false;\n    search: for (;;) {\n      var line = getLine(doc, curPos.line);\n      if (line.markedSpans) {\n        for (var i = 0; i < line.markedSpans.length; ++i) {\n          var sp = line.markedSpans[i], m = sp.marker;\n          if ((sp.from == null || (m.inclusiveLeft ? sp.from <= curPos.ch : sp.from < curPos.ch)) &&\n              (sp.to == null || (m.inclusiveRight ? sp.to >= curPos.ch : sp.to > curPos.ch))) {\n            if (mayClear) {\n              signal(m, "beforeCursorEnter");\n              if (m.explicitlyCleared) {\n                if (!line.markedSpans) break;\n                else {--i; continue;}\n              }\n            }\n            if (!m.atomic) continue;\n            var newPos = m.find(dir < 0 ? -1 : 1);\n            if (cmp(newPos, curPos) == 0) {\n              newPos.ch += dir;\n              if (newPos.ch < 0) {\n                if (newPos.line > doc.first) newPos = clipPos(doc, Pos(newPos.line - 1));\n                else newPos = null;\n              } else if (newPos.ch > line.text.length) {\n                if (newPos.line < doc.first + doc.size - 1) newPos = Pos(newPos.line + 1, 0);\n                else newPos = null;\n              }\n              if (!newPos) {\n                if (flipped) {\n                  // Driven in a corner -- no valid cursor position found at all\n                  // -- try again *with* clearing, if we didn\'t already\n                  if (!mayClear) return skipAtomic(doc, pos, bias, true);\n                  // Otherwise, turn off editing until further notice, and return the start of the doc\n                  doc.cantEdit = true;\n                  return Pos(doc.first, 0);\n                }\n                flipped = true; newPos = pos; dir = -dir;\n              }\n            }\n            curPos = newPos;\n            continue search;\n          }\n        }\n      }\n      return curPos;\n    }\n  }\n\n  // SELECTION DRAWING\n\n  function updateSelection(cm) {\n    cm.display.input.showSelection(cm.display.input.prepareSelection());\n  }\n\n  function prepareSelection(cm, primary) {\n    var doc = cm.doc, result = {};\n    var curFragment = result.cursors = document.createDocumentFragment();\n    var selFragment = result.selection = document.createDocumentFragment();\n\n    for (var i = 0; i < doc.sel.ranges.length; i++) {\n      if (primary === false && i == doc.sel.primIndex) continue;\n      var range = doc.sel.ranges[i];\n      var collapsed = range.empty();\n      if (collapsed || cm.options.showCursorWhenSelecting)\n        drawSelectionCursor(cm, range.head, curFragment);\n      if (!collapsed)\n        drawSelectionRange(cm, range, selFragment);\n    }\n    return result;\n  }\n\n  // Draws a cursor for the given range\n  function drawSelectionCursor(cm, head, output) {\n    var pos = cursorCoords(cm, head, "div", null, null, !cm.options.singleCursorHeightPerLine);\n\n    var cursor = output.appendChild(elt("div", "\\u00a0", "CodeMirror-cursor"));\n    cursor.style.left = pos.left + "px";\n    cursor.style.top = pos.top + "px";\n    cursor.style.height = Math.max(0, pos.bottom - pos.top) * cm.options.cursorHeight + "px";\n\n    if (pos.other) {\n      // Secondary cursor, shown when on a \'jump\' in bi-directional text\n      var otherCursor = output.appendChild(elt("div", "\\u00a0", "CodeMirror-cursor CodeMirror-secondarycursor"));\n      otherCursor.style.display = "";\n      otherCursor.style.left = pos.other.left + "px";\n      otherCursor.style.top = pos.other.top + "px";\n      otherCursor.style.height = (pos.other.bottom - pos.other.top) * .85 + "px";\n    }\n  }\n\n  // Draws the given range as a highlighted selection\n  function drawSelectionRange(cm, range, output) {\n    var display = cm.display, doc = cm.doc;\n    var fragment = document.createDocumentFragment();\n    var padding = paddingH(cm.display), leftSide = padding.left;\n    var rightSide = Math.max(display.sizerWidth, displayWidth(cm) - display.sizer.offsetLeft) - padding.right;\n\n    function add(left, top, width, bottom) {\n      if (top < 0) top = 0;\n      top = Math.round(top);\n      bottom = Math.round(bottom);\n      fragment.appendChild(elt("div", null, "CodeMirror-selected", "position: absolute; left: " + left +\n                               "px; top: " + top + "px; width: " + (width == null ? rightSide - left : width) +\n                               "px; height: " + (bottom - top) + "px"));\n    }\n\n    function drawForLine(line, fromArg, toArg) {\n      var lineObj = getLine(doc, line);\n      var lineLen = lineObj.text.length;\n      var start, end;\n      function coords(ch, bias) {\n        return charCoords(cm, Pos(line, ch), "div", lineObj, bias);\n      }\n\n      iterateBidiSections(getOrder(lineObj), fromArg || 0, toArg == null ? lineLen : toArg, function(from, to, dir) {\n        var leftPos = coords(from, "left"), rightPos, left, right;\n        if (from == to) {\n          rightPos = leftPos;\n          left = right = leftPos.left;\n        } else {\n          rightPos = coords(to - 1, "right");\n          if (dir == "rtl") { var tmp = leftPos; leftPos = rightPos; rightPos = tmp; }\n          left = leftPos.left;\n          right = rightPos.right;\n        }\n        if (fromArg == null && from == 0) left = leftSide;\n        if (rightPos.top - leftPos.top > 3) { // Different lines, draw top part\n          add(left, leftPos.top, null, leftPos.bottom);\n          left = leftSide;\n          if (leftPos.bottom < rightPos.top) add(left, leftPos.bottom, null, rightPos.top);\n        }\n        if (toArg == null && to == lineLen) right = rightSide;\n        if (!start || leftPos.top < start.top || leftPos.top == start.top && leftPos.left < start.left)\n          start = leftPos;\n        if (!end || rightPos.bottom > end.bottom || rightPos.bottom == end.bottom && rightPos.right > end.right)\n          end = rightPos;\n        if (left < leftSide + 1) left = leftSide;\n        add(left, rightPos.top, right - left, rightPos.bottom);\n      });\n      return {start: start, end: end};\n    }\n\n    var sFrom = range.from(), sTo = range.to();\n    if (sFrom.line == sTo.line) {\n      drawForLine(sFrom.line, sFrom.ch, sTo.ch);\n    } else {\n      var fromLine = getLine(doc, sFrom.line), toLine = getLine(doc, sTo.line);\n      var singleVLine = visualLine(fromLine) == visualLine(toLine);\n      var leftEnd = drawForLine(sFrom.line, sFrom.ch, singleVLine ? fromLine.text.length + 1 : null).end;\n      var rightStart = drawForLine(sTo.line, singleVLine ? 0 : null, sTo.ch).start;\n      if (singleVLine) {\n        if (leftEnd.top < rightStart.top - 2) {\n          add(leftEnd.right, leftEnd.top, null, leftEnd.bottom);\n          add(leftSide, rightStart.top, rightStart.left, rightStart.bottom);\n        } else {\n          add(leftEnd.right, leftEnd.top, rightStart.left - leftEnd.right, leftEnd.bottom);\n        }\n      }\n      if (leftEnd.bottom < rightStart.top)\n        add(leftSide, leftEnd.bottom, null, rightStart.top);\n    }\n\n    output.appendChild(fragment);\n  }\n\n  // Cursor-blinking\n  function restartBlink(cm) {\n    if (!cm.state.focused) return;\n    var display = cm.display;\n    clearInterval(display.blinker);\n    var on = true;\n    display.cursorDiv.style.visibility = "";\n    if (cm.options.cursorBlinkRate > 0)\n      display.blinker = setInterval(function() {\n        display.cursorDiv.style.visibility = (on = !on) ? "" : "hidden";\n      }, cm.options.cursorBlinkRate);\n    else if (cm.options.cursorBlinkRate < 0)\n      display.cursorDiv.style.visibility = "hidden";\n  }\n\n  // HIGHLIGHT WORKER\n\n  function startWorker(cm, time) {\n    if (cm.doc.mode.startState && cm.doc.frontier < cm.display.viewTo)\n      cm.state.highlight.set(time, bind(highlightWorker, cm));\n  }\n\n  function highlightWorker(cm) {\n    var doc = cm.doc;\n    if (doc.frontier < doc.first) doc.frontier = doc.first;\n    if (doc.frontier >= cm.display.viewTo) return;\n    var end = +new Date + cm.options.workTime;\n    var state = copyState(doc.mode, getStateBefore(cm, doc.frontier));\n    var changedLines = [];\n\n    doc.iter(doc.frontier, Math.min(doc.first + doc.size, cm.display.viewTo + 500), function(line) {\n      if (doc.frontier >= cm.display.viewFrom) { // Visible\n        var oldStyles = line.styles, tooLong = line.text.length > cm.options.maxHighlightLength;\n        var highlighted = highlightLine(cm, line, tooLong ? copyState(doc.mode, state) : state, true);\n        line.styles = highlighted.styles;\n        var oldCls = line.styleClasses, newCls = highlighted.classes;\n        if (newCls) line.styleClasses = newCls;\n        else if (oldCls) line.styleClasses = null;\n        var ischange = !oldStyles || oldStyles.length != line.styles.length ||\n          oldCls != newCls && (!oldCls || !newCls || oldCls.bgClass != newCls.bgClass || oldCls.textClass != newCls.textClass);\n        for (var i = 0; !ischange && i < oldStyles.length; ++i) ischange = oldStyles[i] != line.styles[i];\n        if (ischange) changedLines.push(doc.frontier);\n        line.stateAfter = tooLong ? state : copyState(doc.mode, state);\n      } else {\n        if (line.text.length <= cm.options.maxHighlightLength)\n          processLine(cm, line.text, state);\n        line.stateAfter = doc.frontier % 5 == 0 ? copyState(doc.mode, state) : null;\n      }\n      ++doc.frontier;\n      if (+new Date > end) {\n        startWorker(cm, cm.options.workDelay);\n        return true;\n      }\n    });\n    if (changedLines.length) runInOp(cm, function() {\n      for (var i = 0; i < changedLines.length; i++)\n        regLineChange(cm, changedLines[i], "text");\n    });\n  }\n\n  // Finds the line to start with when starting a parse. Tries to\n  // find a line with a stateAfter, so that it can start with a\n  // valid state. If that fails, it returns the line with the\n  // smallest indentation, which tends to need the least context to\n  // parse correctly.\n  function findStartLine(cm, n, precise) {\n    var minindent, minline, doc = cm.doc;\n    var lim = precise ? -1 : n - (cm.doc.mode.innerMode ? 1000 : 100);\n    for (var search = n; search > lim; --search) {\n      if (search <= doc.first) return doc.first;\n      var line = getLine(doc, search - 1);\n      if (line.stateAfter && (!precise || search <= doc.frontier)) return search;\n      var indented = countColumn(line.text, null, cm.options.tabSize);\n      if (minline == null || minindent > indented) {\n        minline = search - 1;\n        minindent = indented;\n      }\n    }\n    return minline;\n  }\n\n  function getStateBefore(cm, n, precise) {\n    var doc = cm.doc, display = cm.display;\n    if (!doc.mode.startState) return true;\n    var pos = findStartLine(cm, n, precise), state = pos > doc.first && getLine(doc, pos-1).stateAfter;\n    if (!state) state = startState(doc.mode);\n    else state = copyState(doc.mode, state);\n    doc.iter(pos, n, function(line) {\n      processLine(cm, line.text, state);\n      var save = pos == n - 1 || pos % 5 == 0 || pos >= display.viewFrom && pos < display.viewTo;\n      line.stateAfter = save ? copyState(doc.mode, state) : null;\n      ++pos;\n    });\n    if (precise) doc.frontier = pos;\n    return state;\n  }\n\n  // POSITION MEASUREMENT\n\n  function paddingTop(display) {return display.lineSpace.offsetTop;}\n  function paddingVert(display) {return display.mover.offsetHeight - display.lineSpace.offsetHeight;}\n  function paddingH(display) {\n    if (display.cachedPaddingH) return display.cachedPaddingH;\n    var e = removeChildrenAndAdd(display.measure, elt("pre", "x"));\n    var style = window.getComputedStyle ? window.getComputedStyle(e) : e.currentStyle;\n    var data = {left: parseInt(style.paddingLeft), right: parseInt(style.paddingRight)};\n    if (!isNaN(data.left) && !isNaN(data.right)) display.cachedPaddingH = data;\n    return data;\n  }\n\n  function scrollGap(cm) { return scrollerGap - cm.display.nativeBarWidth; }\n  function displayWidth(cm) {\n    return cm.display.scroller.clientWidth - scrollGap(cm) - cm.display.barWidth;\n  }\n  function displayHeight(cm) {\n    return cm.display.scroller.clientHeight - scrollGap(cm) - cm.display.barHeight;\n  }\n\n  // Ensure the lineView.wrapping.heights array is populated. This is\n  // an array of bottom offsets for the lines that make up a drawn\n  // line. When lineWrapping is on, there might be more than one\n  // height.\n  function ensureLineHeights(cm, lineView, rect) {\n    var wrapping = cm.options.lineWrapping;\n    var curWidth = wrapping && displayWidth(cm);\n    if (!lineView.measure.heights || wrapping && lineView.measure.width != curWidth) {\n      var heights = lineView.measure.heights = [];\n      if (wrapping) {\n        lineView.measure.width = curWidth;\n        var rects = lineView.text.firstChild.getClientRects();\n        for (var i = 0; i < rects.length - 1; i++) {\n          var cur = rects[i], next = rects[i + 1];\n          if (Math.abs(cur.bottom - next.bottom) > 2)\n            heights.push((cur.bottom + next.top) / 2 - rect.top);\n        }\n      }\n      heights.push(rect.bottom - rect.top);\n    }\n  }\n\n  // Find a line map (mapping character offsets to text nodes) and a\n  // measurement cache for the given line number. (A line view might\n  // contain multiple lines when collapsed ranges are present.)\n  function mapFromLineView(lineView, line, lineN) {\n    if (lineView.line == line)\n      return {map: lineView.measure.map, cache: lineView.measure.cache};\n    for (var i = 0; i < lineView.rest.length; i++)\n      if (lineView.rest[i] == line)\n        return {map: lineView.measure.maps[i], cache: lineView.measure.caches[i]};\n    for (var i = 0; i < lineView.rest.length; i++)\n      if (lineNo(lineView.rest[i]) > lineN)\n        return {map: lineView.measure.maps[i], cache: lineView.measure.caches[i], before: true};\n  }\n\n  // Render a line into the hidden node display.externalMeasured. Used\n  // when measurement is needed for a line that\'s not in the viewport.\n  function updateExternalMeasurement(cm, line) {\n    line = visualLine(line);\n    var lineN = lineNo(line);\n    var view = cm.display.externalMeasured = new LineView(cm.doc, line, lineN);\n    view.lineN = lineN;\n    var built = view.built = buildLineContent(cm, view);\n    view.text = built.pre;\n    removeChildrenAndAdd(cm.display.lineMeasure, built.pre);\n    return view;\n  }\n\n  // Get a {top, bottom, left, right} box (in line-local coordinates)\n  // for a given character.\n  function measureChar(cm, line, ch, bias) {\n    return measureCharPrepared(cm, prepareMeasureForLine(cm, line), ch, bias);\n  }\n\n  // Find a line view that corresponds to the given line number.\n  function findViewForLine(cm, lineN) {\n    if (lineN >= cm.display.viewFrom && lineN < cm.display.viewTo)\n      return cm.display.view[findViewIndex(cm, lineN)];\n    var ext = cm.display.externalMeasured;\n    if (ext && lineN >= ext.lineN && lineN < ext.lineN + ext.size)\n      return ext;\n  }\n\n  // Measurement can be split in two steps, the set-up work that\n  // applies to the whole line, and the measurement of the actual\n  // character. Functions like coordsChar, that need to do a lot of\n  // measurements in a row, can thus ensure that the set-up work is\n  // only done once.\n  function prepareMeasureForLine(cm, line) {\n    var lineN = lineNo(line);\n    var view = findViewForLine(cm, lineN);\n    if (view && !view.text) {\n      view = null;\n    } else if (view && view.changes) {\n      updateLineForChanges(cm, view, lineN, getDimensions(cm));\n      cm.curOp.forceUpdate = true;\n    }\n    if (!view)\n      view = updateExternalMeasurement(cm, line);\n\n    var info = mapFromLineView(view, line, lineN);\n    return {\n      line: line, view: view, rect: null,\n      map: info.map, cache: info.cache, before: info.before,\n      hasHeights: false\n    };\n  }\n\n  // Given a prepared measurement object, measures the position of an\n  // actual character (or fetches it from the cache).\n  function measureCharPrepared(cm, prepared, ch, bias, varHeight) {\n    if (prepared.before) ch = -1;\n    var key = ch + (bias || ""), found;\n    if (prepared.cache.hasOwnProperty(key)) {\n      found = prepared.cache[key];\n    } else {\n      if (!prepared.rect)\n        prepared.rect = prepared.view.text.getBoundingClientRect();\n      if (!prepared.hasHeights) {\n        ensureLineHeights(cm, prepared.view, prepared.rect);\n        prepared.hasHeights = true;\n      }\n      found = measureCharInner(cm, prepared, ch, bias);\n      if (!found.bogus) prepared.cache[key] = found;\n    }\n    return {left: found.left, right: found.right,\n            top: varHeight ? found.rtop : found.top,\n            bottom: varHeight ? found.rbottom : found.bottom};\n  }\n\n  var nullRect = {left: 0, right: 0, top: 0, bottom: 0};\n\n  function nodeAndOffsetInLineMap(map, ch, bias) {\n    var node, start, end, collapse;\n    // First, search the line map for the text node corresponding to,\n    // or closest to, the target character.\n    for (var i = 0; i < map.length; i += 3) {\n      var mStart = map[i], mEnd = map[i + 1];\n      if (ch < mStart) {\n        start = 0; end = 1;\n        collapse = "left";\n      } else if (ch < mEnd) {\n        start = ch - mStart;\n        end = start + 1;\n      } else if (i == map.length - 3 || ch == mEnd && map[i + 3] > ch) {\n        end = mEnd - mStart;\n        start = end - 1;\n        if (ch >= mEnd) collapse = "right";\n      }\n      if (start != null) {\n        node = map[i + 2];\n        if (mStart == mEnd && bias == (node.insertLeft ? "left" : "right"))\n          collapse = bias;\n        if (bias == "left" && start == 0)\n          while (i && map[i - 2] == map[i - 3] && map[i - 1].insertLeft) {\n            node = map[(i -= 3) + 2];\n            collapse = "left";\n          }\n        if (bias == "right" && start == mEnd - mStart)\n          while (i < map.length - 3 && map[i + 3] == map[i + 4] && !map[i + 5].insertLeft) {\n            node = map[(i += 3) + 2];\n            collapse = "right";\n          }\n        break;\n      }\n    }\n    return {node: node, start: start, end: end, collapse: collapse, coverStart: mStart, coverEnd: mEnd};\n  }\n\n  function measureCharInner(cm, prepared, ch, bias) {\n    var place = nodeAndOffsetInLineMap(prepared.map, ch, bias);\n    var node = place.node, start = place.start, end = place.end, collapse = place.collapse;\n\n    var rect;\n    if (node.nodeType == 3) { // If it is a text node, use a range to retrieve the coordinates.\n      for (var i = 0; i < 4; i++) { // Retry a maximum of 4 times when nonsense rectangles are returned\n        while (start && isExtendingChar(prepared.line.text.charAt(place.coverStart + start))) --start;\n        while (place.coverStart + end < place.coverEnd && isExtendingChar(prepared.line.text.charAt(place.coverStart + end))) ++end;\n        if (ie && ie_version < 9 && start == 0 && end == place.coverEnd - place.coverStart) {\n          rect = node.parentNode.getBoundingClientRect();\n        } else if (ie && cm.options.lineWrapping) {\n          var rects = range(node, start, end).getClientRects();\n          if (rects.length)\n            rect = rects[bias == "right" ? rects.length - 1 : 0];\n          else\n            rect = nullRect;\n        } else {\n          rect = range(node, start, end).getBoundingClientRect() || nullRect;\n        }\n        if (rect.left || rect.right || start == 0) break;\n        end = start;\n        start = start - 1;\n        collapse = "right";\n      }\n      if (ie && ie_version < 11) rect = maybeUpdateRectForZooming(cm.display.measure, rect);\n    } else { // If it is a widget, simply get the box for the whole widget.\n      if (start > 0) collapse = bias = "right";\n      var rects;\n      if (cm.options.lineWrapping && (rects = node.getClientRects()).length > 1)\n        rect = rects[bias == "right" ? rects.length - 1 : 0];\n      else\n        rect = node.getBoundingClientRect();\n    }\n    if (ie && ie_version < 9 && !start && (!rect || !rect.left && !rect.right)) {\n      var rSpan = node.parentNode.getClientRects()[0];\n      if (rSpan)\n        rect = {left: rSpan.left, right: rSpan.left + charWidth(cm.display), top: rSpan.top, bottom: rSpan.bottom};\n      else\n        rect = nullRect;\n    }\n\n    var rtop = rect.top - prepared.rect.top, rbot = rect.bottom - prepared.rect.top;\n    var mid = (rtop + rbot) / 2;\n    var heights = prepared.view.measure.heights;\n    for (var i = 0; i < heights.length - 1; i++)\n      if (mid < heights[i]) break;\n    var top = i ? heights[i - 1] : 0, bot = heights[i];\n    var result = {left: (collapse == "right" ? rect.right : rect.left) - prepared.rect.left,\n                  right: (collapse == "left" ? rect.left : rect.right) - prepared.rect.left,\n                  top: top, bottom: bot};\n    if (!rect.left && !rect.right) result.bogus = true;\n    if (!cm.options.singleCursorHeightPerLine) { result.rtop = rtop; result.rbottom = rbot; }\n\n    return result;\n  }\n\n  // Work around problem with bounding client rects on ranges being\n  // returned incorrectly when zoomed on IE10 and below.\n  function maybeUpdateRectForZooming(measure, rect) {\n    if (!window.screen || screen.logicalXDPI == null ||\n        screen.logicalXDPI == screen.deviceXDPI || !hasBadZoomedRects(measure))\n      return rect;\n    var scaleX = screen.logicalXDPI / screen.deviceXDPI;\n    var scaleY = screen.logicalYDPI / screen.deviceYDPI;\n    return {left: rect.left * scaleX, right: rect.right * scaleX,\n            top: rect.top * scaleY, bottom: rect.bottom * scaleY};\n  }\n\n  function clearLineMeasurementCacheFor(lineView) {\n    if (lineView.measure) {\n      lineView.measure.cache = {};\n      lineView.measure.heights = null;\n      if (lineView.rest) for (var i = 0; i < lineView.rest.length; i++)\n        lineView.measure.caches[i] = {};\n    }\n  }\n\n  function clearLineMeasurementCache(cm) {\n    cm.display.externalMeasure = null;\n    removeChildren(cm.display.lineMeasure);\n    for (var i = 0; i < cm.display.view.length; i++)\n      clearLineMeasurementCacheFor(cm.display.view[i]);\n  }\n\n  function clearCaches(cm) {\n    clearLineMeasurementCache(cm);\n    cm.display.cachedCharWidth = cm.display.cachedTextHeight = cm.display.cachedPaddingH = null;\n    if (!cm.options.lineWrapping) cm.display.maxLineChanged = true;\n    cm.display.lineNumChars = null;\n  }\n\n  function pageScrollX() { return window.pageXOffset || (document.documentElement || document.body).scrollLeft; }\n  function pageScrollY() { return window.pageYOffset || (document.documentElement || document.body).scrollTop; }\n\n  // Converts a {top, bottom, left, right} box from line-local\n  // coordinates into another coordinate system. Context may be one of\n  // "line", "div" (display.lineDiv), "local"/null (editor), "window",\n  // or "page".\n  function intoCoordSystem(cm, lineObj, rect, context) {\n    if (lineObj.widgets) for (var i = 0; i < lineObj.widgets.length; ++i) if (lineObj.widgets[i].above) {\n      var size = widgetHeight(lineObj.widgets[i]);\n      rect.top += size; rect.bottom += size;\n    }\n    if (context == "line") return rect;\n    if (!context) context = "local";\n    var yOff = heightAtLine(lineObj);\n    if (context == "local") yOff += paddingTop(cm.display);\n    else yOff -= cm.display.viewOffset;\n    if (context == "page" || context == "window") {\n      var lOff = cm.display.lineSpace.getBoundingClientRect();\n      yOff += lOff.top + (context == "window" ? 0 : pageScrollY());\n      var xOff = lOff.left + (context == "window" ? 0 : pageScrollX());\n      rect.left += xOff; rect.right += xOff;\n    }\n    rect.top += yOff; rect.bottom += yOff;\n    return rect;\n  }\n\n  // Coverts a box from "div" coords to another coordinate system.\n  // Context may be "window", "page", "div", or "local"/null.\n  function fromCoordSystem(cm, coords, context) {\n    if (context == "div") return coords;\n    var left = coords.left, top = coords.top;\n    // First move into "page" coordinate system\n    if (context == "page") {\n      left -= pageScrollX();\n      top -= pageScrollY();\n    } else if (context == "local" || !context) {\n      var localBox = cm.display.sizer.getBoundingClientRect();\n      left += localBox.left;\n      top += localBox.top;\n    }\n\n    var lineSpaceBox = cm.display.lineSpace.getBoundingClientRect();\n    return {left: left - lineSpaceBox.left, top: top - lineSpaceBox.top};\n  }\n\n  function charCoords(cm, pos, context, lineObj, bias) {\n    if (!lineObj) lineObj = getLine(cm.doc, pos.line);\n    return intoCoordSystem(cm, lineObj, measureChar(cm, lineObj, pos.ch, bias), context);\n  }\n\n  // Returns a box for a given cursor position, which may have an\n  // \'other\' property containing the position of the secondary cursor\n  // on a bidi boundary.\n  function cursorCoords(cm, pos, context, lineObj, preparedMeasure, varHeight) {\n    lineObj = lineObj || getLine(cm.doc, pos.line);\n    if (!preparedMeasure) preparedMeasure = prepareMeasureForLine(cm, lineObj);\n    function get(ch, right) {\n      var m = measureCharPrepared(cm, preparedMeasure, ch, right ? "right" : "left", varHeight);\n      if (right) m.left = m.right; else m.right = m.left;\n      return intoCoordSystem(cm, lineObj, m, context);\n    }\n    function getBidi(ch, partPos) {\n      var part = order[partPos], right = part.level % 2;\n      if (ch == bidiLeft(part) && partPos && part.level < order[partPos - 1].level) {\n        part = order[--partPos];\n        ch = bidiRight(part) - (part.level % 2 ? 0 : 1);\n        right = true;\n      } else if (ch == bidiRight(part) && partPos < order.length - 1 && part.level < order[partPos + 1].level) {\n        part = order[++partPos];\n        ch = bidiLeft(part) - part.level % 2;\n        right = false;\n      }\n      if (right && ch == part.to && ch > part.from) return get(ch - 1);\n      return get(ch, right);\n    }\n    var order = getOrder(lineObj), ch = pos.ch;\n    if (!order) return get(ch);\n    var partPos = getBidiPartAt(order, ch);\n    var val = getBidi(ch, partPos);\n    if (bidiOther != null) val.other = getBidi(ch, bidiOther);\n    return val;\n  }\n\n  // Used to cheaply estimate the coordinates for a position. Used for\n  // intermediate scroll updates.\n  function estimateCoords(cm, pos) {\n    var left = 0, pos = clipPos(cm.doc, pos);\n    if (!cm.options.lineWrapping) left = charWidth(cm.display) * pos.ch;\n    var lineObj = getLine(cm.doc, pos.line);\n    var top = heightAtLine(lineObj) + paddingTop(cm.display);\n    return {left: left, right: left, top: top, bottom: top + lineObj.height};\n  }\n\n  // Positions returned by coordsChar contain some extra information.\n  // xRel is the relative x position of the input coordinates compared\n  // to the found position (so xRel > 0 means the coordinates are to\n  // the right of the character position, for example). When outside\n  // is true, that means the coordinates lie outside the line\'s\n  // vertical range.\n  function PosWithInfo(line, ch, outside, xRel) {\n    var pos = Pos(line, ch);\n    pos.xRel = xRel;\n    if (outside) pos.outside = true;\n    return pos;\n  }\n\n  // Compute the character position closest to the given coordinates.\n  // Input must be lineSpace-local ("div" coordinate system).\n  function coordsChar(cm, x, y) {\n    var doc = cm.doc;\n    y += cm.display.viewOffset;\n    if (y < 0) return PosWithInfo(doc.first, 0, true, -1);\n    var lineN = lineAtHeight(doc, y), last = doc.first + doc.size - 1;\n    if (lineN > last)\n      return PosWithInfo(doc.first + doc.size - 1, getLine(doc, last).text.length, true, 1);\n    if (x < 0) x = 0;\n\n    var lineObj = getLine(doc, lineN);\n    for (;;) {\n      var found = coordsCharInner(cm, lineObj, lineN, x, y);\n      var merged = collapsedSpanAtEnd(lineObj);\n      var mergedPos = merged && merged.find(0, true);\n      if (merged && (found.ch > mergedPos.from.ch || found.ch == mergedPos.from.ch && found.xRel > 0))\n        lineN = lineNo(lineObj = mergedPos.to.line);\n      else\n        return found;\n    }\n  }\n\n  function coordsCharInner(cm, lineObj, lineNo, x, y) {\n    var innerOff = y - heightAtLine(lineObj);\n    var wrongLine = false, adjust = 2 * cm.display.wrapper.clientWidth;\n    var preparedMeasure = prepareMeasureForLine(cm, lineObj);\n\n    function getX(ch) {\n      var sp = cursorCoords(cm, Pos(lineNo, ch), "line", lineObj, preparedMeasure);\n      wrongLine = true;\n      if (innerOff > sp.bottom) return sp.left - adjust;\n      else if (innerOff < sp.top) return sp.left + adjust;\n      else wrongLine = false;\n      return sp.left;\n    }\n\n    var bidi = getOrder(lineObj), dist = lineObj.text.length;\n    var from = lineLeft(lineObj), to = lineRight(lineObj);\n    var fromX = getX(from), fromOutside = wrongLine, toX = getX(to), toOutside = wrongLine;\n\n    if (x > toX) return PosWithInfo(lineNo, to, toOutside, 1);\n    // Do a binary search between these bounds.\n    for (;;) {\n      if (bidi ? to == from || to == moveVisually(lineObj, from, 1) : to - from <= 1) {\n        var ch = x < fromX || x - fromX <= toX - x ? from : to;\n        var xDiff = x - (ch == from ? fromX : toX);\n        while (isExtendingChar(lineObj.text.charAt(ch))) ++ch;\n        var pos = PosWithInfo(lineNo, ch, ch == from ? fromOutside : toOutside,\n                              xDiff < -1 ? -1 : xDiff > 1 ? 1 : 0);\n        return pos;\n      }\n      var step = Math.ceil(dist / 2), middle = from + step;\n      if (bidi) {\n        middle = from;\n        for (var i = 0; i < step; ++i) middle = moveVisually(lineObj, middle, 1);\n      }\n      var middleX = getX(middle);\n      if (middleX > x) {to = middle; toX = middleX; if (toOutside = wrongLine) toX += 1000; dist = step;}\n      else {from = middle; fromX = middleX; fromOutside = wrongLine; dist -= step;}\n    }\n  }\n\n  var measureText;\n  // Compute the default text height.\n  function textHeight(display) {\n    if (display.cachedTextHeight != null) return display.cachedTextHeight;\n    if (measureText == null) {\n      measureText = elt("pre");\n      // Measure a bunch of lines, for browsers that compute\n      // fractional heights.\n      for (var i = 0; i < 49; ++i) {\n        measureText.appendChild(document.createTextNode("x"));\n        measureText.appendChild(elt("br"));\n      }\n      measureText.appendChild(document.createTextNode("x"));\n    }\n    removeChildrenAndAdd(display.measure, measureText);\n    var height = measureText.offsetHeight / 50;\n    if (height > 3) display.cachedTextHeight = height;\n    removeChildren(display.measure);\n    return height || 1;\n  }\n\n  // Compute the default character width.\n  function charWidth(display) {\n    if (display.cachedCharWidth != null) return display.cachedCharWidth;\n    var anchor = elt("span", "xxxxxxxxxx");\n    var pre = elt("pre", [anchor]);\n    removeChildrenAndAdd(display.measure, pre);\n    var rect = anchor.getBoundingClientRect(), width = (rect.right - rect.left) / 10;\n    if (width > 2) display.cachedCharWidth = width;\n    return width || 10;\n  }\n\n  // OPERATIONS\n\n  // Operations are used to wrap a series of changes to the editor\n  // state in such a way that each change won\'t have to update the\n  // cursor and display (which would be awkward, slow, and\n  // error-prone). Instead, display updates are batched and then all\n  // combined and executed at once.\n\n  var operationGroup = null;\n\n  var nextOpId = 0;\n  // Start a new operation.\n  function startOperation(cm) {\n    cm.curOp = {\n      cm: cm,\n      viewChanged: false,      // Flag that indicates that lines might need to be redrawn\n      startHeight: cm.doc.height, // Used to detect need to update scrollbar\n      forceUpdate: false,      // Used to force a redraw\n      updateInput: null,       // Whether to reset the input textarea\n      typing: false,           // Whether this reset should be careful to leave existing text (for compositing)\n      changeObjs: null,        // Accumulated changes, for firing change events\n      cursorActivityHandlers: null, // Set of handlers to fire cursorActivity on\n      cursorActivityCalled: 0, // Tracks which cursorActivity handlers have been called already\n      selectionChanged: false, // Whether the selection needs to be redrawn\n      updateMaxLine: false,    // Set when the widest line needs to be determined anew\n      scrollLeft: null, scrollTop: null, // Intermediate scroll position, not pushed to DOM yet\n      scrollToPos: null,       // Used to scroll to a specific position\n      focus: false,\n      id: ++nextOpId           // Unique ID\n    };\n    if (operationGroup) {\n      operationGroup.ops.push(cm.curOp);\n    } else {\n      cm.curOp.ownsGroup = operationGroup = {\n        ops: [cm.curOp],\n        delayedCallbacks: []\n      };\n    }\n  }\n\n  function fireCallbacksForOps(group) {\n    // Calls delayed callbacks and cursorActivity handlers until no\n    // new ones appear\n    var callbacks = group.delayedCallbacks, i = 0;\n    do {\n      for (; i < callbacks.length; i++)\n        callbacks[i].call(null);\n      for (var j = 0; j < group.ops.length; j++) {\n        var op = group.ops[j];\n        if (op.cursorActivityHandlers)\n          while (op.cursorActivityCalled < op.cursorActivityHandlers.length)\n            op.cursorActivityHandlers[op.cursorActivityCalled++].call(null, op.cm);\n      }\n    } while (i < callbacks.length);\n  }\n\n  // Finish an operation, updating the display and signalling delayed events\n  function endOperation(cm) {\n    var op = cm.curOp, group = op.ownsGroup;\n    if (!group) return;\n\n    try { fireCallbacksForOps(group); }\n    finally {\n      operationGroup = null;\n      for (var i = 0; i < group.ops.length; i++)\n        group.ops[i].cm.curOp = null;\n      endOperations(group);\n    }\n  }\n\n  // The DOM updates done when an operation finishes are batched so\n  // that the minimum number of relayouts are required.\n  function endOperations(group) {\n    var ops = group.ops;\n    for (var i = 0; i < ops.length; i++) // Read DOM\n      endOperation_R1(ops[i]);\n    for (var i = 0; i < ops.length; i++) // Write DOM (maybe)\n      endOperation_W1(ops[i]);\n    for (var i = 0; i < ops.length; i++) // Read DOM\n      endOperation_R2(ops[i]);\n    for (var i = 0; i < ops.length; i++) // Write DOM (maybe)\n      endOperation_W2(ops[i]);\n    for (var i = 0; i < ops.length; i++) // Read DOM\n      endOperation_finish(ops[i]);\n  }\n\n  function endOperation_R1(op) {\n    var cm = op.cm, display = cm.display;\n    maybeClipScrollbars(cm);\n    if (op.updateMaxLine) findMaxLine(cm);\n\n    op.mustUpdate = op.viewChanged || op.forceUpdate || op.scrollTop != null ||\n      op.scrollToPos && (op.scrollToPos.from.line < display.viewFrom ||\n                         op.scrollToPos.to.line >= display.viewTo) ||\n      display.maxLineChanged && cm.options.lineWrapping;\n    op.update = op.mustUpdate &&\n      new DisplayUpdate(cm, op.mustUpdate && {top: op.scrollTop, ensure: op.scrollToPos}, op.forceUpdate);\n  }\n\n  function endOperation_W1(op) {\n    op.updatedDisplay = op.mustUpdate && updateDisplayIfNeeded(op.cm, op.update);\n  }\n\n  function endOperation_R2(op) {\n    var cm = op.cm, display = cm.display;\n    if (op.updatedDisplay) updateHeightsInViewport(cm);\n\n    op.barMeasure = measureForScrollbars(cm);\n\n    // If the max line changed since it was last measured, measure it,\n    // and ensure the document\'s width matches it.\n    // updateDisplay_W2 will use these properties to do the actual resizing\n    if (display.maxLineChanged && !cm.options.lineWrapping) {\n      op.adjustWidthTo = measureChar(cm, display.maxLine, display.maxLine.text.length).left + 3;\n      cm.display.sizerWidth = op.adjustWidthTo;\n      op.barMeasure.scrollWidth =\n        Math.max(display.scroller.clientWidth, display.sizer.offsetLeft + op.adjustWidthTo + scrollGap(cm) + cm.display.barWidth);\n      op.maxScrollLeft = Math.max(0, display.sizer.offsetLeft + op.adjustWidthTo - displayWidth(cm));\n    }\n\n    if (op.updatedDisplay || op.selectionChanged)\n      op.preparedSelection = display.input.prepareSelection();\n  }\n\n  function endOperation_W2(op) {\n    var cm = op.cm;\n\n    if (op.adjustWidthTo != null) {\n      cm.display.sizer.style.minWidth = op.adjustWidthTo + "px";\n      if (op.maxScrollLeft < cm.doc.scrollLeft)\n        setScrollLeft(cm, Math.min(cm.display.scroller.scrollLeft, op.maxScrollLeft), true);\n      cm.display.maxLineChanged = false;\n    }\n\n    if (op.preparedSelection)\n      cm.display.input.showSelection(op.preparedSelection);\n    if (op.updatedDisplay)\n      setDocumentHeight(cm, op.barMeasure);\n    if (op.updatedDisplay || op.startHeight != cm.doc.height)\n      updateScrollbars(cm, op.barMeasure);\n\n    if (op.selectionChanged) restartBlink(cm);\n\n    if (cm.state.focused && op.updateInput)\n      cm.display.input.reset(op.typing);\n    if (op.focus && op.focus == activeElt()) ensureFocus(op.cm);\n  }\n\n  function endOperation_finish(op) {\n    var cm = op.cm, display = cm.display, doc = cm.doc;\n\n    if (op.updatedDisplay) postUpdateDisplay(cm, op.update);\n\n    // Abort mouse wheel delta measurement, when scrolling explicitly\n    if (display.wheelStartX != null && (op.scrollTop != null || op.scrollLeft != null || op.scrollToPos))\n      display.wheelStartX = display.wheelStartY = null;\n\n    // Propagate the scroll position to the actual DOM scroller\n    if (op.scrollTop != null && (display.scroller.scrollTop != op.scrollTop || op.forceScroll)) {\n      doc.scrollTop = Math.max(0, Math.min(display.scroller.scrollHeight - display.scroller.clientHeight, op.scrollTop));\n      display.scrollbars.setScrollTop(doc.scrollTop);\n      display.scroller.scrollTop = doc.scrollTop;\n    }\n    if (op.scrollLeft != null && (display.scroller.scrollLeft != op.scrollLeft || op.forceScroll)) {\n      doc.scrollLeft = Math.max(0, Math.min(display.scroller.scrollWidth - displayWidth(cm), op.scrollLeft));\n      display.scrollbars.setScrollLeft(doc.scrollLeft);\n      display.scroller.scrollLeft = doc.scrollLeft;\n      alignHorizontally(cm);\n    }\n    // If we need to scroll a specific position into view, do so.\n    if (op.scrollToPos) {\n      var coords = scrollPosIntoView(cm, clipPos(doc, op.scrollToPos.from),\n                                     clipPos(doc, op.scrollToPos.to), op.scrollToPos.margin);\n      if (op.scrollToPos.isCursor && cm.state.focused) maybeScrollWindow(cm, coords);\n    }\n\n    // Fire events for markers that are hidden/unidden by editing or\n    // undoing\n    var hidden = op.maybeHiddenMarkers, unhidden = op.maybeUnhiddenMarkers;\n    if (hidden) for (var i = 0; i < hidden.length; ++i)\n      if (!hidden[i].lines.length) signal(hidden[i], "hide");\n    if (unhidden) for (var i = 0; i < unhidden.length; ++i)\n      if (unhidden[i].lines.length) signal(unhidden[i], "unhide");\n\n    if (display.wrapper.offsetHeight)\n      doc.scrollTop = cm.display.scroller.scrollTop;\n\n    // Fire change events, and delayed event handlers\n    if (op.changeObjs)\n      signal(cm, "changes", cm, op.changeObjs);\n    if (op.update)\n      op.update.finish();\n  }\n\n  // Run the given function in an operation\n  function runInOp(cm, f) {\n    if (cm.curOp) return f();\n    startOperation(cm);\n    try { return f(); }\n    finally { endOperation(cm); }\n  }\n  // Wraps a function in an operation. Returns the wrapped function.\n  function operation(cm, f) {\n    return function() {\n      if (cm.curOp) return f.apply(cm, arguments);\n      startOperation(cm);\n      try { return f.apply(cm, arguments); }\n      finally { endOperation(cm); }\n    };\n  }\n  // Used to add methods to editor and doc instances, wrapping them in\n  // operations.\n  function methodOp(f) {\n    return function() {\n      if (this.curOp) return f.apply(this, arguments);\n      startOperation(this);\n      try { return f.apply(this, arguments); }\n      finally { endOperation(this); }\n    };\n  }\n  function docMethodOp(f) {\n    return function() {\n      var cm = this.cm;\n      if (!cm || cm.curOp) return f.apply(this, arguments);\n      startOperation(cm);\n      try { return f.apply(this, arguments); }\n      finally { endOperation(cm); }\n    };\n  }\n\n  // VIEW TRACKING\n\n  // These objects are used to represent the visible (currently drawn)\n  // part of the document. A LineView may correspond to multiple\n  // logical lines, if those are connected by collapsed ranges.\n  function LineView(doc, line, lineN) {\n    // The starting line\n    this.line = line;\n    // Continuing lines, if any\n    this.rest = visualLineContinued(line);\n    // Number of logical lines in this visual line\n    this.size = this.rest ? lineNo(lst(this.rest)) - lineN + 1 : 1;\n    this.node = this.text = null;\n    this.hidden = lineIsHidden(doc, line);\n  }\n\n  // Create a range of LineView objects for the given lines.\n  function buildViewArray(cm, from, to) {\n    var array = [], nextPos;\n    for (var pos = from; pos < to; pos = nextPos) {\n      var view = new LineView(cm.doc, getLine(cm.doc, pos), pos);\n      nextPos = pos + view.size;\n      array.push(view);\n    }\n    return array;\n  }\n\n  // Updates the display.view data structure for a given change to the\n  // document. From and to are in pre-change coordinates. Lendiff is\n  // the amount of lines added or subtracted by the change. This is\n  // used for changes that span multiple lines, or change the way\n  // lines are divided into visual lines. regLineChange (below)\n  // registers single-line changes.\n  function regChange(cm, from, to, lendiff) {\n    if (from == null) from = cm.doc.first;\n    if (to == null) to = cm.doc.first + cm.doc.size;\n    if (!lendiff) lendiff = 0;\n\n    var display = cm.display;\n    if (lendiff && to < display.viewTo &&\n        (display.updateLineNumbers == null || display.updateLineNumbers > from))\n      display.updateLineNumbers = from;\n\n    cm.curOp.viewChanged = true;\n\n    if (from >= display.viewTo) { // Change after\n      if (sawCollapsedSpans && visualLineNo(cm.doc, from) < display.viewTo)\n        resetView(cm);\n    } else if (to <= display.viewFrom) { // Change before\n      if (sawCollapsedSpans && visualLineEndNo(cm.doc, to + lendiff) > display.viewFrom) {\n        resetView(cm);\n      } else {\n        display.viewFrom += lendiff;\n        display.viewTo += lendiff;\n      }\n    } else if (from <= display.viewFrom && to >= display.viewTo) { // Full overlap\n      resetView(cm);\n    } else if (from <= display.viewFrom) { // Top overlap\n      var cut = viewCuttingPoint(cm, to, to + lendiff, 1);\n      if (cut) {\n        display.view = display.view.slice(cut.index);\n        display.viewFrom = cut.lineN;\n        display.viewTo += lendiff;\n      } else {\n        resetView(cm);\n      }\n    } else if (to >= display.viewTo) { // Bottom overlap\n      var cut = viewCuttingPoint(cm, from, from, -1);\n      if (cut) {\n        display.view = display.view.slice(0, cut.index);\n        display.viewTo = cut.lineN;\n      } else {\n        resetView(cm);\n      }\n    } else { // Gap in the middle\n      var cutTop = viewCuttingPoint(cm, from, from, -1);\n      var cutBot = viewCuttingPoint(cm, to, to + lendiff, 1);\n      if (cutTop && cutBot) {\n        display.view = display.view.slice(0, cutTop.index)\n          .concat(buildViewArray(cm, cutTop.lineN, cutBot.lineN))\n          .concat(display.view.slice(cutBot.index));\n        display.viewTo += lendiff;\n      } else {\n        resetView(cm);\n      }\n    }\n\n    var ext = display.externalMeasured;\n    if (ext) {\n      if (to < ext.lineN)\n        ext.lineN += lendiff;\n      else if (from < ext.lineN + ext.size)\n        display.externalMeasured = null;\n    }\n  }\n\n  // Register a change to a single line. Type must be one of "text",\n  // "gutter", "class", "widget"\n  function regLineChange(cm, line, type) {\n    cm.curOp.viewChanged = true;\n    var display = cm.display, ext = cm.display.externalMeasured;\n    if (ext && line >= ext.lineN && line < ext.lineN + ext.size)\n      display.externalMeasured = null;\n\n    if (line < display.viewFrom || line >= display.viewTo) return;\n    var lineView = display.view[findViewIndex(cm, line)];\n    if (lineView.node == null) return;\n    var arr = lineView.changes || (lineView.changes = []);\n    if (indexOf(arr, type) == -1) arr.push(type);\n  }\n\n  // Clear the view.\n  function resetView(cm) {\n    cm.display.viewFrom = cm.display.viewTo = cm.doc.first;\n    cm.display.view = [];\n    cm.display.viewOffset = 0;\n  }\n\n  // Find the view element corresponding to a given line. Return null\n  // when the line isn\'t visible.\n  function findViewIndex(cm, n) {\n    if (n >= cm.display.viewTo) return null;\n    n -= cm.display.viewFrom;\n    if (n < 0) return null;\n    var view = cm.display.view;\n    for (var i = 0; i < view.length; i++) {\n      n -= view[i].size;\n      if (n < 0) return i;\n    }\n  }\n\n  function viewCuttingPoint(cm, oldN, newN, dir) {\n    var index = findViewIndex(cm, oldN), diff, view = cm.display.view;\n    if (!sawCollapsedSpans || newN == cm.doc.first + cm.doc.size)\n      return {index: index, lineN: newN};\n    for (var i = 0, n = cm.display.viewFrom; i < index; i++)\n      n += view[i].size;\n    if (n != oldN) {\n      if (dir > 0) {\n        if (index == view.length - 1) return null;\n        diff = (n + view[index].size) - oldN;\n        index++;\n      } else {\n        diff = n - oldN;\n      }\n      oldN += diff; newN += diff;\n    }\n    while (visualLineNo(cm.doc, newN) != newN) {\n      if (index == (dir < 0 ? 0 : view.length - 1)) return null;\n      newN += dir * view[index - (dir < 0 ? 1 : 0)].size;\n      index += dir;\n    }\n    return {index: index, lineN: newN};\n  }\n\n  // Force the view to cover a given range, adding empty view element\n  // or clipping off existing ones as needed.\n  function adjustView(cm, from, to) {\n    var display = cm.display, view = display.view;\n    if (view.length == 0 || from >= display.viewTo || to <= display.viewFrom) {\n      display.view = buildViewArray(cm, from, to);\n      display.viewFrom = from;\n    } else {\n      if (display.viewFrom > from)\n        display.view = buildViewArray(cm, from, display.viewFrom).concat(display.view);\n      else if (display.viewFrom < from)\n        display.view = display.view.slice(findViewIndex(cm, from));\n      display.viewFrom = from;\n      if (display.viewTo < to)\n        display.view = display.view.concat(buildViewArray(cm, display.viewTo, to));\n      else if (display.viewTo > to)\n        display.view = display.view.slice(0, findViewIndex(cm, to));\n    }\n    display.viewTo = to;\n  }\n\n  // Count the number of lines in the view whose DOM representation is\n  // out of date (or nonexistent).\n  function countDirtyView(cm) {\n    var view = cm.display.view, dirty = 0;\n    for (var i = 0; i < view.length; i++) {\n      var lineView = view[i];\n      if (!lineView.hidden && (!lineView.node || lineView.changes)) ++dirty;\n    }\n    return dirty;\n  }\n\n  // EVENT HANDLERS\n\n  // Attach the necessary event handlers when initializing the editor\n  function registerEventHandlers(cm) {\n    var d = cm.display;\n    on(d.scroller, "mousedown", operation(cm, onMouseDown));\n    // Older IE\'s will not fire a second mousedown for a double click\n    if (ie && ie_version < 11)\n      on(d.scroller, "dblclick", operation(cm, function(e) {\n        if (signalDOMEvent(cm, e)) return;\n        var pos = posFromMouse(cm, e);\n        if (!pos || clickInGutter(cm, e) || eventInWidget(cm.display, e)) return;\n        e_preventDefault(e);\n        var word = cm.findWordAt(pos);\n        extendSelection(cm.doc, word.anchor, word.head);\n      }));\n    else\n      on(d.scroller, "dblclick", function(e) { signalDOMEvent(cm, e) || e_preventDefault(e); });\n    // Some browsers fire contextmenu *after* opening the menu, at\n    // which point we can\'t mess with it anymore. Context menu is\n    // handled in onMouseDown for these browsers.\n    if (!captureRightClick) on(d.scroller, "contextmenu", function(e) {onContextMenu(cm, e);});\n\n    // Used to suppress mouse event handling when a touch happens\n    var touchFinished, prevTouch = {end: 0};\n    function finishTouch() {\n      if (d.activeTouch) {\n        touchFinished = setTimeout(function() {d.activeTouch = null;}, 1000);\n        prevTouch = d.activeTouch;\n        prevTouch.end = +new Date;\n      }\n    };\n    function isMouseLikeTouchEvent(e) {\n      if (e.touches.length != 1) return false;\n      var touch = e.touches[0];\n      return touch.radiusX <= 1 && touch.radiusY <= 1;\n    }\n    function farAway(touch, other) {\n      if (other.left == null) return true;\n      var dx = other.left - touch.left, dy = other.top - touch.top;\n      return dx * dx + dy * dy > 20 * 20;\n    }\n    on(d.scroller, "touchstart", function(e) {\n      if (!isMouseLikeTouchEvent(e)) {\n        clearTimeout(touchFinished);\n        var now = +new Date;\n        d.activeTouch = {start: now, moved: false,\n                         prev: now - prevTouch.end <= 300 ? prevTouch : null};\n        if (e.touches.length == 1) {\n          d.activeTouch.left = e.touches[0].pageX;\n          d.activeTouch.top = e.touches[0].pageY;\n        }\n      }\n    });\n    on(d.scroller, "touchmove", function() {\n      if (d.activeTouch) d.activeTouch.moved = true;\n    });\n    on(d.scroller, "touchend", function(e) {\n      var touch = d.activeTouch;\n      if (touch && !eventInWidget(d, e) && touch.left != null &&\n          !touch.moved && new Date - touch.start < 300) {\n        var pos = cm.coordsChar(d.activeTouch, "page"), range;\n        if (!touch.prev || farAway(touch, touch.prev)) // Single tap\n          range = new Range(pos, pos);\n        else if (!touch.prev.prev || farAway(touch, touch.prev.prev)) // Double tap\n          range = cm.findWordAt(pos);\n        else // Triple tap\n          range = new Range(Pos(pos.line, 0), clipPos(cm.doc, Pos(pos.line + 1, 0)));\n        cm.setSelection(range.anchor, range.head);\n        cm.focus();\n        e_preventDefault(e);\n      }\n      finishTouch();\n    });\n    on(d.scroller, "touchcancel", finishTouch);\n\n    // Sync scrolling between fake scrollbars and real scrollable\n    // area, ensure viewport is updated when scrolling.\n    on(d.scroller, "scroll", function() {\n      if (d.scroller.clientHeight) {\n        setScrollTop(cm, d.scroller.scrollTop);\n        setScrollLeft(cm, d.scroller.scrollLeft, true);\n        signal(cm, "scroll", cm);\n      }\n    });\n\n    // Listen to wheel events in order to try and update the viewport on time.\n    on(d.scroller, "mousewheel", function(e){onScrollWheel(cm, e);});\n    on(d.scroller, "DOMMouseScroll", function(e){onScrollWheel(cm, e);});\n\n    // Prevent wrapper from ever scrolling\n    on(d.wrapper, "scroll", function() { d.wrapper.scrollTop = d.wrapper.scrollLeft = 0; });\n\n    d.dragFunctions = {\n      enter: function(e) {if (!signalDOMEvent(cm, e)) e_stop(e);},\n      over: function(e) {if (!signalDOMEvent(cm, e)) { onDragOver(cm, e); e_stop(e); }},\n      start: function(e){onDragStart(cm, e);},\n      drop: operation(cm, onDrop),\n      leave: function() {clearDragCursor(cm);}\n    };\n\n    var inp = d.input.getField();\n    on(inp, "keyup", function(e) { onKeyUp.call(cm, e); });\n    on(inp, "keydown", operation(cm, onKeyDown));\n    on(inp, "keypress", operation(cm, onKeyPress));\n    on(inp, "focus", bind(onFocus, cm));\n    on(inp, "blur", bind(onBlur, cm));\n  }\n\n  function dragDropChanged(cm, value, old) {\n    var wasOn = old && old != CodeMirror.Init;\n    if (!value != !wasOn) {\n      var funcs = cm.display.dragFunctions;\n      var toggle = value ? on : off;\n      toggle(cm.display.scroller, "dragstart", funcs.start);\n      toggle(cm.display.scroller, "dragenter", funcs.enter);\n      toggle(cm.display.scroller, "dragover", funcs.over);\n      toggle(cm.display.scroller, "dragleave", funcs.leave);\n      toggle(cm.display.scroller, "drop", funcs.drop);\n    }\n  }\n\n  // Called when the window resizes\n  function onResize(cm) {\n    var d = cm.display;\n    if (d.lastWrapHeight == d.wrapper.clientHeight && d.lastWrapWidth == d.wrapper.clientWidth)\n      return;\n    // Might be a text scaling operation, clear size caches.\n    d.cachedCharWidth = d.cachedTextHeight = d.cachedPaddingH = null;\n    d.scrollbarsClipped = false;\n    cm.setSize();\n  }\n\n  // MOUSE EVENTS\n\n  // Return true when the given mouse event happened in a widget\n  function eventInWidget(display, e) {\n    for (var n = e_target(e); n != display.wrapper; n = n.parentNode) {\n      if (!n || (n.nodeType == 1 && n.getAttribute("cm-ignore-events") == "true") ||\n          (n.parentNode == display.sizer && n != display.mover))\n        return true;\n    }\n  }\n\n  // Given a mouse event, find the corresponding position. If liberal\n  // is false, it checks whether a gutter or scrollbar was clicked,\n  // and returns null if it was. forRect is used by rectangular\n  // selections, and tries to estimate a character position even for\n  // coordinates beyond the right of the text.\n  function posFromMouse(cm, e, liberal, forRect) {\n    var display = cm.display;\n    if (!liberal && e_target(e).getAttribute("cm-not-content") == "true") return null;\n\n    var x, y, space = display.lineSpace.getBoundingClientRect();\n    // Fails unpredictably on IE[67] when mouse is dragged around quickly.\n    try { x = e.clientX - space.left; y = e.clientY - space.top; }\n    catch (e) { return null; }\n    var coords = coordsChar(cm, x, y), line;\n    if (forRect && coords.xRel == 1 && (line = getLine(cm.doc, coords.line).text).length == coords.ch) {\n      var colDiff = countColumn(line, line.length, cm.options.tabSize) - line.length;\n      coords = Pos(coords.line, Math.max(0, Math.round((x - paddingH(cm.display).left) / charWidth(cm.display)) - colDiff));\n    }\n    return coords;\n  }\n\n  // A mouse down can be a single click, double click, triple click,\n  // start of selection drag, start of text drag, new cursor\n  // (ctrl-click), rectangle drag (alt-drag), or xwin\n  // middle-click-paste. Or it might be a click on something we should\n  // not interfere with, such as a scrollbar or widget.\n  function onMouseDown(e) {\n    var cm = this, display = cm.display;\n    if (display.activeTouch && display.input.supportsTouch() || signalDOMEvent(cm, e)) return;\n    display.shift = e.shiftKey;\n\n    if (eventInWidget(display, e)) {\n      if (!webkit) {\n        // Briefly turn off draggability, to allow widgets to do\n        // normal dragging things.\n        display.scroller.draggable = false;\n        setTimeout(function(){display.scroller.draggable = true;}, 100);\n      }\n      return;\n    }\n    if (clickInGutter(cm, e)) return;\n    var start = posFromMouse(cm, e);\n    window.focus();\n\n    switch (e_button(e)) {\n    case 1:\n      // #3261: make sure, that we\'re not starting a second selection\n      if (cm.state.selectingText)\n        cm.state.selectingText(e);\n      else if (start)\n        leftButtonDown(cm, e, start);\n      else if (e_target(e) == display.scroller)\n        e_preventDefault(e);\n      break;\n    case 2:\n      if (webkit) cm.state.lastMiddleDown = +new Date;\n      if (start) extendSelection(cm.doc, start);\n      setTimeout(function() {display.input.focus();}, 20);\n      e_preventDefault(e);\n      break;\n    case 3:\n      if (captureRightClick) onContextMenu(cm, e);\n      else delayBlurEvent(cm);\n      break;\n    }\n  }\n\n  var lastClick, lastDoubleClick;\n  function leftButtonDown(cm, e, start) {\n    if (ie) setTimeout(bind(ensureFocus, cm), 0);\n    else cm.curOp.focus = activeElt();\n\n    var now = +new Date, type;\n    if (lastDoubleClick && lastDoubleClick.time > now - 400 && cmp(lastDoubleClick.pos, start) == 0) {\n      type = "triple";\n    } else if (lastClick && lastClick.time > now - 400 && cmp(lastClick.pos, start) == 0) {\n      type = "double";\n      lastDoubleClick = {time: now, pos: start};\n    } else {\n      type = "single";\n      lastClick = {time: now, pos: start};\n    }\n\n    var sel = cm.doc.sel, modifier = mac ? e.metaKey : e.ctrlKey, contained;\n    if (cm.options.dragDrop && dragAndDrop && !isReadOnly(cm) &&\n        type == "single" && (contained = sel.contains(start)) > -1 &&\n        (cmp((contained = sel.ranges[contained]).from(), start) < 0 || start.xRel > 0) &&\n        (cmp(contained.to(), start) > 0 || start.xRel < 0))\n      leftButtonStartDrag(cm, e, start, modifier);\n    else\n      leftButtonSelect(cm, e, start, type, modifier);\n  }\n\n  // Start a text drag. When it ends, see if any dragging actually\n  // happen, and treat as a click if it didn\'t.\n  function leftButtonStartDrag(cm, e, start, modifier) {\n    var display = cm.display, startTime = +new Date;\n    var dragEnd = operation(cm, function(e2) {\n      if (webkit) display.scroller.draggable = false;\n      cm.state.draggingText = false;\n      off(document, "mouseup", dragEnd);\n      off(display.scroller, "drop", dragEnd);\n      if (Math.abs(e.clientX - e2.clientX) + Math.abs(e.clientY - e2.clientY) < 10) {\n        e_preventDefault(e2);\n        if (!modifier && +new Date - 200 < startTime)\n          extendSelection(cm.doc, start);\n        // Work around unexplainable focus problem in IE9 (#2127) and Chrome (#3081)\n        if (webkit || ie && ie_version == 9)\n          setTimeout(function() {document.body.focus(); display.input.focus();}, 20);\n        else\n          display.input.focus();\n      }\n    });\n    // Let the drag handler handle this.\n    if (webkit) display.scroller.draggable = true;\n    cm.state.draggingText = dragEnd;\n    // IE\'s approach to draggable\n    if (display.scroller.dragDrop) display.scroller.dragDrop();\n    on(document, "mouseup", dragEnd);\n    on(display.scroller, "drop", dragEnd);\n  }\n\n  // Normal selection, as opposed to text dragging.\n  function leftButtonSelect(cm, e, start, type, addNew) {\n    var display = cm.display, doc = cm.doc;\n    e_preventDefault(e);\n\n    var ourRange, ourIndex, startSel = doc.sel, ranges = startSel.ranges;\n    if (addNew && !e.shiftKey) {\n      ourIndex = doc.sel.contains(start);\n      if (ourIndex > -1)\n        ourRange = ranges[ourIndex];\n      else\n        ourRange = new Range(start, start);\n    } else {\n      ourRange = doc.sel.primary();\n      ourIndex = doc.sel.primIndex;\n    }\n\n    if (e.altKey) {\n      type = "rect";\n      if (!addNew) ourRange = new Range(start, start);\n      start = posFromMouse(cm, e, true, true);\n      ourIndex = -1;\n    } else if (type == "double") {\n      var word = cm.findWordAt(start);\n      if (cm.display.shift || doc.extend)\n        ourRange = extendRange(doc, ourRange, word.anchor, word.head);\n      else\n        ourRange = word;\n    } else if (type == "triple") {\n      var line = new Range(Pos(start.line, 0), clipPos(doc, Pos(start.line + 1, 0)));\n      if (cm.display.shift || doc.extend)\n        ourRange = extendRange(doc, ourRange, line.anchor, line.head);\n      else\n        ourRange = line;\n    } else {\n      ourRange = extendRange(doc, ourRange, start);\n    }\n\n    if (!addNew) {\n      ourIndex = 0;\n      setSelection(doc, new Selection([ourRange], 0), sel_mouse);\n      startSel = doc.sel;\n    } else if (ourIndex == -1) {\n      ourIndex = ranges.length;\n      setSelection(doc, normalizeSelection(ranges.concat([ourRange]), ourIndex),\n                   {scroll: false, origin: "*mouse"});\n    } else if (ranges.length > 1 && ranges[ourIndex].empty() && type == "single" && !e.shiftKey) {\n      setSelection(doc, normalizeSelection(ranges.slice(0, ourIndex).concat(ranges.slice(ourIndex + 1)), 0),\n                   {scroll: false, origin: "*mouse"});\n      startSel = doc.sel;\n    } else {\n      replaceOneSelection(doc, ourIndex, ourRange, sel_mouse);\n    }\n\n    var lastPos = start;\n    function extendTo(pos) {\n      if (cmp(lastPos, pos) == 0) return;\n      lastPos = pos;\n\n      if (type == "rect") {\n        var ranges = [], tabSize = cm.options.tabSize;\n        var startCol = countColumn(getLine(doc, start.line).text, start.ch, tabSize);\n        var posCol = countColumn(getLine(doc, pos.line).text, pos.ch, tabSize);\n        var left = Math.min(startCol, posCol), right = Math.max(startCol, posCol);\n        for (var line = Math.min(start.line, pos.line), end = Math.min(cm.lastLine(), Math.max(start.line, pos.line));\n             line <= end; line++) {\n          var text = getLine(doc, line).text, leftPos = findColumn(text, left, tabSize);\n          if (left == right)\n            ranges.push(new Range(Pos(line, leftPos), Pos(line, leftPos)));\n          else if (text.length > leftPos)\n            ranges.push(new Range(Pos(line, leftPos), Pos(line, findColumn(text, right, tabSize))));\n        }\n        if (!ranges.length) ranges.push(new Range(start, start));\n        setSelection(doc, normalizeSelection(startSel.ranges.slice(0, ourIndex).concat(ranges), ourIndex),\n                     {origin: "*mouse", scroll: false});\n        cm.scrollIntoView(pos);\n      } else {\n        var oldRange = ourRange;\n        var anchor = oldRange.anchor, head = pos;\n        if (type != "single") {\n          if (type == "double")\n            var range = cm.findWordAt(pos);\n          else\n            var range = new Range(Pos(pos.line, 0), clipPos(doc, Pos(pos.line + 1, 0)));\n          if (cmp(range.anchor, anchor) > 0) {\n            head = range.head;\n            anchor = minPos(oldRange.from(), range.anchor);\n          } else {\n            head = range.anchor;\n            anchor = maxPos(oldRange.to(), range.head);\n          }\n        }\n        var ranges = startSel.ranges.slice(0);\n        ranges[ourIndex] = new Range(clipPos(doc, anchor), head);\n        setSelection(doc, normalizeSelection(ranges, ourIndex), sel_mouse);\n      }\n    }\n\n    var editorSize = display.wrapper.getBoundingClientRect();\n    // Used to ensure timeout re-tries don\'t fire when another extend\n    // happened in the meantime (clearTimeout isn\'t reliable -- at\n    // least on Chrome, the timeouts still happen even when cleared,\n    // if the clear happens after their scheduled firing time).\n    var counter = 0;\n\n    function extend(e) {\n      var curCount = ++counter;\n      var cur = posFromMouse(cm, e, true, type == "rect");\n      if (!cur) return;\n      if (cmp(cur, lastPos) != 0) {\n        cm.curOp.focus = activeElt();\n        extendTo(cur);\n        var visible = visibleLines(display, doc);\n        if (cur.line >= visible.to || cur.line < visible.from)\n          setTimeout(operation(cm, function(){if (counter == curCount) extend(e);}), 150);\n      } else {\n        var outside = e.clientY < editorSize.top ? -20 : e.clientY > editorSize.bottom ? 20 : 0;\n        if (outside) setTimeout(operation(cm, function() {\n          if (counter != curCount) return;\n          display.scroller.scrollTop += outside;\n          extend(e);\n        }), 50);\n      }\n    }\n\n    function done(e) {\n      cm.state.selectingText = false;\n      counter = Infinity;\n      e_preventDefault(e);\n      display.input.focus();\n      off(document, "mousemove", move);\n      off(document, "mouseup", up);\n      doc.history.lastSelOrigin = null;\n    }\n\n    var move = operation(cm, function(e) {\n      if (!e_button(e)) done(e);\n      else extend(e);\n    });\n    var up = operation(cm, done);\n    cm.state.selectingText = up;\n    on(document, "mousemove", move);\n    on(document, "mouseup", up);\n  }\n\n  // Determines whether an event happened in the gutter, and fires the\n  // handlers for the corresponding event.\n  function gutterEvent(cm, e, type, prevent, signalfn) {\n    try { var mX = e.clientX, mY = e.clientY; }\n    catch(e) { return false; }\n    if (mX >= Math.floor(cm.display.gutters.getBoundingClientRect().right)) return false;\n    if (prevent) e_preventDefault(e);\n\n    var display = cm.display;\n    var lineBox = display.lineDiv.getBoundingClientRect();\n\n    if (mY > lineBox.bottom || !hasHandler(cm, type)) return e_defaultPrevented(e);\n    mY -= lineBox.top - display.viewOffset;\n\n    for (var i = 0; i < cm.options.gutters.length; ++i) {\n      var g = display.gutters.childNodes[i];\n      if (g && g.getBoundingClientRect().right >= mX) {\n        var line = lineAtHeight(cm.doc, mY);\n        var gutter = cm.options.gutters[i];\n        signalfn(cm, type, cm, line, gutter, e);\n        return e_defaultPrevented(e);\n      }\n    }\n  }\n\n  function clickInGutter(cm, e) {\n    return gutterEvent(cm, e, "gutterClick", true, signalLater);\n  }\n\n  // Kludge to work around strange IE behavior where it\'ll sometimes\n  // re-fire a series of drag-related events right after the drop (#1551)\n  var lastDrop = 0;\n\n  function onDrop(e) {\n    var cm = this;\n    clearDragCursor(cm);\n    if (signalDOMEvent(cm, e) || eventInWidget(cm.display, e))\n      return;\n    e_preventDefault(e);\n    if (ie) lastDrop = +new Date;\n    var pos = posFromMouse(cm, e, true), files = e.dataTransfer.files;\n    if (!pos || isReadOnly(cm)) return;\n    // Might be a file drop, in which case we simply extract the text\n    // and insert it.\n    if (files && files.length && window.FileReader && window.File) {\n      var n = files.length, text = Array(n), read = 0;\n      var loadFile = function(file, i) {\n        var reader = new FileReader;\n        reader.onload = operation(cm, function() {\n          text[i] = reader.result;\n          if (++read == n) {\n            pos = clipPos(cm.doc, pos);\n            var change = {from: pos, to: pos,\n                          text: cm.doc.splitLines(text.join(cm.doc.lineSeparator())),\n                          origin: "paste"};\n            makeChange(cm.doc, change);\n            setSelectionReplaceHistory(cm.doc, simpleSelection(pos, changeEnd(change)));\n          }\n        });\n        reader.readAsText(file);\n      };\n      for (var i = 0; i < n; ++i) loadFile(files[i], i);\n    } else { // Normal drop\n      // Don\'t do a replace if the drop happened inside of the selected text.\n      if (cm.state.draggingText && cm.doc.sel.contains(pos) > -1) {\n        cm.state.draggingText(e);\n        // Ensure the editor is re-focused\n        setTimeout(function() {cm.display.input.focus();}, 20);\n        return;\n      }\n      try {\n        var text = e.dataTransfer.getData("Text");\n        if (text) {\n          if (cm.state.draggingText && !(mac ? e.altKey : e.ctrlKey))\n            var selected = cm.listSelections();\n          setSelectionNoUndo(cm.doc, simpleSelection(pos, pos));\n          if (selected) for (var i = 0; i < selected.length; ++i)\n            replaceRange(cm.doc, "", selected[i].anchor, selected[i].head, "drag");\n          cm.replaceSelection(text, "around", "paste");\n          cm.display.input.focus();\n        }\n      }\n      catch(e){}\n    }\n  }\n\n  function onDragStart(cm, e) {\n    if (ie && (!cm.state.draggingText || +new Date - lastDrop < 100)) { e_stop(e); return; }\n    if (signalDOMEvent(cm, e) || eventInWidget(cm.display, e)) return;\n\n    e.dataTransfer.setData("Text", cm.getSelection());\n\n    // Use dummy image instead of default browsers image.\n    // Recent Safari (~6.0.2) have a tendency to segfault when this happens, so we don\'t do it there.\n    if (e.dataTransfer.setDragImage && !safari) {\n      var img = elt("img", null, null, "position: fixed; left: 0; top: 0;");\n      img.src = "data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==";\n      if (presto) {\n        img.width = img.height = 1;\n        cm.display.wrapper.appendChild(img);\n        // Force a relayout, or Opera won\'t use our image for some obscure reason\n        img._top = img.offsetTop;\n      }\n      e.dataTransfer.setDragImage(img, 0, 0);\n      if (presto) img.parentNode.removeChild(img);\n    }\n  }\n\n  function onDragOver(cm, e) {\n    var pos = posFromMouse(cm, e);\n    if (!pos) return;\n    var frag = document.createDocumentFragment();\n    drawSelectionCursor(cm, pos, frag);\n    if (!cm.display.dragCursor) {\n      cm.display.dragCursor = elt("div", null, "CodeMirror-cursors CodeMirror-dragcursors");\n      cm.display.lineSpace.insertBefore(cm.display.dragCursor, cm.display.cursorDiv);\n    }\n    removeChildrenAndAdd(cm.display.dragCursor, frag);\n  }\n\n  function clearDragCursor(cm) {\n    if (cm.display.dragCursor) {\n      cm.display.lineSpace.removeChild(cm.display.dragCursor);\n      cm.display.dragCursor = null;\n    }\n  }\n\n  // SCROLL EVENTS\n\n  // Sync the scrollable area and scrollbars, ensure the viewport\n  // covers the visible area.\n  function setScrollTop(cm, val) {\n    if (Math.abs(cm.doc.scrollTop - val) < 2) return;\n    cm.doc.scrollTop = val;\n    if (!gecko) updateDisplaySimple(cm, {top: val});\n    if (cm.display.scroller.scrollTop != val) cm.display.scroller.scrollTop = val;\n    cm.display.scrollbars.setScrollTop(val);\n    if (gecko) updateDisplaySimple(cm);\n    startWorker(cm, 100);\n  }\n  // Sync scroller and scrollbar, ensure the gutter elements are\n  // aligned.\n  function setScrollLeft(cm, val, isScroller) {\n    if (isScroller ? val == cm.doc.scrollLeft : Math.abs(cm.doc.scrollLeft - val) < 2) return;\n    val = Math.min(val, cm.display.scroller.scrollWidth - cm.display.scroller.clientWidth);\n    cm.doc.scrollLeft = val;\n    alignHorizontally(cm);\n    if (cm.display.scroller.scrollLeft != val) cm.display.scroller.scrollLeft = val;\n    cm.display.scrollbars.setScrollLeft(val);\n  }\n\n  // Since the delta values reported on mouse wheel events are\n  // unstandardized between browsers and even browser versions, and\n  // generally horribly unpredictable, this code starts by measuring\n  // the scroll effect that the first few mouse wheel events have,\n  // and, from that, detects the way it can convert deltas to pixel\n  // offsets afterwards.\n  //\n  // The reason we want to know the amount a wheel event will scroll\n  // is that it gives us a chance to update the display before the\n  // actual scrolling happens, reducing flickering.\n\n  var wheelSamples = 0, wheelPixelsPerUnit = null;\n  // Fill in a browser-detected starting value on browsers where we\n  // know one. These don\'t have to be accurate -- the result of them\n  // being wrong would just be a slight flicker on the first wheel\n  // scroll (if it is large enough).\n  if (ie) wheelPixelsPerUnit = -.53;\n  else if (gecko) wheelPixelsPerUnit = 15;\n  else if (chrome) wheelPixelsPerUnit = -.7;\n  else if (safari) wheelPixelsPerUnit = -1/3;\n\n  var wheelEventDelta = function(e) {\n    var dx = e.wheelDeltaX, dy = e.wheelDeltaY;\n    if (dx == null && e.detail && e.axis == e.HORIZONTAL_AXIS) dx = e.detail;\n    if (dy == null && e.detail && e.axis == e.VERTICAL_AXIS) dy = e.detail;\n    else if (dy == null) dy = e.wheelDelta;\n    return {x: dx, y: dy};\n  };\n  CodeMirror.wheelEventPixels = function(e) {\n    var delta = wheelEventDelta(e);\n    delta.x *= wheelPixelsPerUnit;\n    delta.y *= wheelPixelsPerUnit;\n    return delta;\n  };\n\n  function onScrollWheel(cm, e) {\n    var delta = wheelEventDelta(e), dx = delta.x, dy = delta.y;\n\n    var display = cm.display, scroll = display.scroller;\n    // Quit if there\'s nothing to scroll here\n    if (!(dx && scroll.scrollWidth > scroll.clientWidth ||\n          dy && scroll.scrollHeight > scroll.clientHeight)) return;\n\n    // Webkit browsers on OS X abort momentum scrolls when the target\n    // of the scroll event is removed from the scrollable element.\n    // This hack (see related code in patchDisplay) makes sure the\n    // element is kept around.\n    if (dy && mac && webkit) {\n      outer: for (var cur = e.target, view = display.view; cur != scroll; cur = cur.parentNode) {\n        for (var i = 0; i < view.length; i++) {\n          if (view[i].node == cur) {\n            cm.display.currentWheelTarget = cur;\n            break outer;\n          }\n        }\n      }\n    }\n\n    // On some browsers, horizontal scrolling will cause redraws to\n    // happen before the gutter has been realigned, causing it to\n    // wriggle around in a most unseemly way. When we have an\n    // estimated pixels/delta value, we just handle horizontal\n    // scrolling entirely here. It\'ll be slightly off from native, but\n    // better than glitching out.\n    if (dx && !gecko && !presto && wheelPixelsPerUnit != null) {\n      if (dy)\n        setScrollTop(cm, Math.max(0, Math.min(scroll.scrollTop + dy * wheelPixelsPerUnit, scroll.scrollHeight - scroll.clientHeight)));\n      setScrollLeft(cm, Math.max(0, Math.min(scroll.scrollLeft + dx * wheelPixelsPerUnit, scroll.scrollWidth - scroll.clientWidth)));\n      e_preventDefault(e);\n      display.wheelStartX = null; // Abort measurement, if in progress\n      return;\n    }\n\n    // \'Project\' the visible viewport to cover the area that is being\n    // scrolled into view (if we know enough to estimate it).\n    if (dy && wheelPixelsPerUnit != null) {\n      var pixels = dy * wheelPixelsPerUnit;\n      var top = cm.doc.scrollTop, bot = top + display.wrapper.clientHeight;\n      if (pixels < 0) top = Math.max(0, top + pixels - 50);\n      else bot = Math.min(cm.doc.height, bot + pixels + 50);\n      updateDisplaySimple(cm, {top: top, bottom: bot});\n    }\n\n    if (wheelSamples < 20) {\n      if (display.wheelStartX == null) {\n        display.wheelStartX = scroll.scrollLeft; display.wheelStartY = scroll.scrollTop;\n        display.wheelDX = dx; display.wheelDY = dy;\n        setTimeout(function() {\n          if (display.wheelStartX == null) return;\n          var movedX = scroll.scrollLeft - display.wheelStartX;\n          var movedY = scroll.scrollTop - display.wheelStartY;\n          var sample = (movedY && display.wheelDY && movedY / display.wheelDY) ||\n            (movedX && display.wheelDX && movedX / display.wheelDX);\n          display.wheelStartX = display.wheelStartY = null;\n          if (!sample) return;\n          wheelPixelsPerUnit = (wheelPixelsPerUnit * wheelSamples + sample) / (wheelSamples + 1);\n          ++wheelSamples;\n        }, 200);\n      } else {\n        display.wheelDX += dx; display.wheelDY += dy;\n      }\n    }\n  }\n\n  // KEY EVENTS\n\n  // Run a handler that was bound to a key.\n  function doHandleBinding(cm, bound, dropShift) {\n    if (typeof bound == "string") {\n      bound = commands[bound];\n      if (!bound) return false;\n    }\n    // Ensure previous input has been read, so that the handler sees a\n    // consistent view of the document\n    cm.display.input.ensurePolled();\n    var prevShift = cm.display.shift, done = false;\n    try {\n      if (isReadOnly(cm)) cm.state.suppressEdits = true;\n      if (dropShift) cm.display.shift = false;\n      done = bound(cm) != Pass;\n    } finally {\n      cm.display.shift = prevShift;\n      cm.state.suppressEdits = false;\n    }\n    return done;\n  }\n\n  function lookupKeyForEditor(cm, name, handle) {\n    for (var i = 0; i < cm.state.keyMaps.length; i++) {\n      var result = lookupKey(name, cm.state.keyMaps[i], handle, cm);\n      if (result) return result;\n    }\n    return (cm.options.extraKeys && lookupKey(name, cm.options.extraKeys, handle, cm))\n      || lookupKey(name, cm.options.keyMap, handle, cm);\n  }\n\n  var stopSeq = new Delayed;\n  function dispatchKey(cm, name, e, handle) {\n    var seq = cm.state.keySeq;\n    if (seq) {\n      if (isModifierKey(name)) return "handled";\n      stopSeq.set(50, function() {\n        if (cm.state.keySeq == seq) {\n          cm.state.keySeq = null;\n          cm.display.input.reset();\n        }\n      });\n      name = seq + " " + name;\n    }\n    var result = lookupKeyForEditor(cm, name, handle);\n\n    if (result == "multi")\n      cm.state.keySeq = name;\n    if (result == "handled")\n      signalLater(cm, "keyHandled", cm, name, e);\n\n    if (result == "handled" || result == "multi") {\n      e_preventDefault(e);\n      restartBlink(cm);\n    }\n\n    if (seq && !result && /\\\'$/.test(name)) {\n      e_preventDefault(e);\n      return true;\n    }\n    return !!result;\n  }\n\n  // Handle a key from the keydown event.\n  function handleKeyBinding(cm, e) {\n    var name = keyName(e, true);\n    if (!name) return false;\n\n    if (e.shiftKey && !cm.state.keySeq) {\n      // First try to resolve full name (including \'Shift-\'). Failing\n      // that, see if there is a cursor-motion command (starting with\n      // \'go\') bound to the keyname without \'Shift-\'.\n      return dispatchKey(cm, "Shift-" + name, e, function(b) {return doHandleBinding(cm, b, true);})\n          || dispatchKey(cm, name, e, function(b) {\n               if (typeof b == "string" ? /^go[A-Z]/.test(b) : b.motion)\n                 return doHandleBinding(cm, b);\n             });\n    } else {\n      return dispatchKey(cm, name, e, function(b) { return doHandleBinding(cm, b); });\n    }\n  }\n\n  // Handle a key from the keypress event\n  function handleCharBinding(cm, e, ch) {\n    return dispatchKey(cm, "\'" + ch + "\'", e,\n                       function(b) { return doHandleBinding(cm, b, true); });\n  }\n\n  var lastStoppedKey = null;\n  function onKeyDown(e) {\n    var cm = this;\n    cm.curOp.focus = activeElt();\n    if (signalDOMEvent(cm, e)) return;\n    // IE does strange things with escape.\n    if (ie && ie_version < 11 && e.keyCode == 27) e.returnValue = false;\n    var code = e.keyCode;\n    cm.display.shift = code == 16 || e.shiftKey;\n    var handled = handleKeyBinding(cm, e);\n    if (presto) {\n      lastStoppedKey = handled ? code : null;\n      // Opera has no cut event... we try to at least catch the key combo\n      if (!handled && code == 88 && !hasCopyEvent && (mac ? e.metaKey : e.ctrlKey))\n        cm.replaceSelection("", null, "cut");\n    }\n\n    // Turn mouse into crosshair when Alt is held on Mac.\n    if (code == 18 && !/\\bCodeMirror-crosshair\\b/.test(cm.display.lineDiv.className))\n      showCrossHair(cm);\n  }\n\n  function showCrossHair(cm) {\n    var lineDiv = cm.display.lineDiv;\n    addClass(lineDiv, "CodeMirror-crosshair");\n\n    function up(e) {\n      if (e.keyCode == 18 || !e.altKey) {\n        rmClass(lineDiv, "CodeMirror-crosshair");\n        off(document, "keyup", up);\n        off(document, "mouseover", up);\n      }\n    }\n    on(document, "keyup", up);\n    on(document, "mouseover", up);\n  }\n\n  function onKeyUp(e) {\n    if (e.keyCode == 16) this.doc.sel.shift = false;\n    signalDOMEvent(this, e);\n  }\n\n  function onKeyPress(e) {\n    var cm = this;\n    if (eventInWidget(cm.display, e) || signalDOMEvent(cm, e) || e.ctrlKey && !e.altKey || mac && e.metaKey) return;\n    var keyCode = e.keyCode, charCode = e.charCode;\n    if (presto && keyCode == lastStoppedKey) {lastStoppedKey = null; e_preventDefault(e); return;}\n    if ((presto && (!e.which || e.which < 10)) && handleKeyBinding(cm, e)) return;\n    var ch = String.fromCharCode(charCode == null ? keyCode : charCode);\n    if (handleCharBinding(cm, e, ch)) return;\n    cm.display.input.onKeyPress(e);\n  }\n\n  // FOCUS/BLUR EVENTS\n\n  function delayBlurEvent(cm) {\n    cm.state.delayingBlurEvent = true;\n    setTimeout(function() {\n      if (cm.state.delayingBlurEvent) {\n        cm.state.delayingBlurEvent = false;\n        onBlur(cm);\n      }\n    }, 100);\n  }\n\n  function onFocus(cm) {\n    if (cm.state.delayingBlurEvent) cm.state.delayingBlurEvent = false;\n\n    if (cm.options.readOnly == "nocursor") return;\n    if (!cm.state.focused) {\n      signal(cm, "focus", cm);\n      cm.state.focused = true;\n      addClass(cm.display.wrapper, "CodeMirror-focused");\n      // This test prevents this from firing when a context\n      // menu is closed (since the input reset would kill the\n      // select-all detection hack)\n      if (!cm.curOp && cm.display.selForContextMenu != cm.doc.sel) {\n        cm.display.input.reset();\n        if (webkit) setTimeout(function() { cm.display.input.reset(true); }, 20); // Issue #1730\n      }\n      cm.display.input.receivedFocus();\n    }\n    restartBlink(cm);\n  }\n  function onBlur(cm) {\n    if (cm.state.delayingBlurEvent) return;\n\n    if (cm.state.focused) {\n      signal(cm, "blur", cm);\n      cm.state.focused = false;\n      rmClass(cm.display.wrapper, "CodeMirror-focused");\n    }\n    clearInterval(cm.display.blinker);\n    setTimeout(function() {if (!cm.state.focused) cm.display.shift = false;}, 150);\n  }\n\n  // CONTEXT MENU HANDLING\n\n  // To make the context menu work, we need to briefly unhide the\n  // textarea (making it as unobtrusive as possible) to let the\n  // right-click take effect on it.\n  function onContextMenu(cm, e) {\n    if (eventInWidget(cm.display, e) || contextMenuInGutter(cm, e)) return;\n    cm.display.input.onContextMenu(e);\n  }\n\n  function contextMenuInGutter(cm, e) {\n    if (!hasHandler(cm, "gutterContextMenu")) return false;\n    return gutterEvent(cm, e, "gutterContextMenu", false, signal);\n  }\n\n  // UPDATING\n\n  // Compute the position of the end of a change (its \'to\' property\n  // refers to the pre-change end).\n  var changeEnd = CodeMirror.changeEnd = function(change) {\n    if (!change.text) return change.to;\n    return Pos(change.from.line + change.text.length - 1,\n               lst(change.text).length + (change.text.length == 1 ? change.from.ch : 0));\n  };\n\n  // Adjust a position to refer to the post-change position of the\n  // same text, or the end of the change if the change covers it.\n  function adjustForChange(pos, change) {\n    if (cmp(pos, change.from) < 0) return pos;\n    if (cmp(pos, change.to) <= 0) return changeEnd(change);\n\n    var line = pos.line + change.text.length - (change.to.line - change.from.line) - 1, ch = pos.ch;\n    if (pos.line == change.to.line) ch += changeEnd(change).ch - change.to.ch;\n    return Pos(line, ch);\n  }\n\n  function computeSelAfterChange(doc, change) {\n    var out = [];\n    for (var i = 0; i < doc.sel.ranges.length; i++) {\n      var range = doc.sel.ranges[i];\n      out.push(new Range(adjustForChange(range.anchor, change),\n                         adjustForChange(range.head, change)));\n    }\n    return normalizeSelection(out, doc.sel.primIndex);\n  }\n\n  function offsetPos(pos, old, nw) {\n    if (pos.line == old.line)\n      return Pos(nw.line, pos.ch - old.ch + nw.ch);\n    else\n      return Pos(nw.line + (pos.line - old.line), pos.ch);\n  }\n\n  // Used by replaceSelections to allow moving the selection to the\n  // start or around the replaced test. Hint may be "start" or "around".\n  function computeReplacedSel(doc, changes, hint) {\n    var out = [];\n    var oldPrev = Pos(doc.first, 0), newPrev = oldPrev;\n    for (var i = 0; i < changes.length; i++) {\n      var change = changes[i];\n      var from = offsetPos(change.from, oldPrev, newPrev);\n      var to = offsetPos(changeEnd(change), oldPrev, newPrev);\n      oldPrev = change.to;\n      newPrev = to;\n      if (hint == "around") {\n        var range = doc.sel.ranges[i], inv = cmp(range.head, range.anchor) < 0;\n        out[i] = new Range(inv ? to : from, inv ? from : to);\n      } else {\n        out[i] = new Range(from, from);\n      }\n    }\n    return new Selection(out, doc.sel.primIndex);\n  }\n\n  // Allow "beforeChange" event handlers to influence a change\n  function filterChange(doc, change, update) {\n    var obj = {\n      canceled: false,\n      from: change.from,\n      to: change.to,\n      text: change.text,\n      origin: change.origin,\n      cancel: function() { this.canceled = true; }\n    };\n    if (update) obj.update = function(from, to, text, origin) {\n      if (from) this.from = clipPos(doc, from);\n      if (to) this.to = clipPos(doc, to);\n      if (text) this.text = text;\n      if (origin !== undefined) this.origin = origin;\n    };\n    signal(doc, "beforeChange", doc, obj);\n    if (doc.cm) signal(doc.cm, "beforeChange", doc.cm, obj);\n\n    if (obj.canceled) return null;\n    return {from: obj.from, to: obj.to, text: obj.text, origin: obj.origin};\n  }\n\n  // Apply a change to a document, and add it to the document\'s\n  // history, and propagating it to all linked documents.\n  function makeChange(doc, change, ignoreReadOnly) {\n    if (doc.cm) {\n      if (!doc.cm.curOp) return operation(doc.cm, makeChange)(doc, change, ignoreReadOnly);\n      if (doc.cm.state.suppressEdits) return;\n    }\n\n    if (hasHandler(doc, "beforeChange") || doc.cm && hasHandler(doc.cm, "beforeChange")) {\n      change = filterChange(doc, change, true);\n      if (!change) return;\n    }\n\n    // Possibly split or suppress the update based on the presence\n    // of read-only spans in its range.\n    var split = sawReadOnlySpans && !ignoreReadOnly && removeReadOnlyRanges(doc, change.from, change.to);\n    if (split) {\n      for (var i = split.length - 1; i >= 0; --i)\n        makeChangeInner(doc, {from: split[i].from, to: split[i].to, text: i ? [""] : change.text});\n    } else {\n      makeChangeInner(doc, change);\n    }\n  }\n\n  function makeChangeInner(doc, change) {\n    if (change.text.length == 1 && change.text[0] == "" && cmp(change.from, change.to) == 0) return;\n    var selAfter = computeSelAfterChange(doc, change);\n    addChangeToHistory(doc, change, selAfter, doc.cm ? doc.cm.curOp.id : NaN);\n\n    makeChangeSingleDoc(doc, change, selAfter, stretchSpansOverChange(doc, change));\n    var rebased = [];\n\n    linkedDocs(doc, function(doc, sharedHist) {\n      if (!sharedHist && indexOf(rebased, doc.history) == -1) {\n        rebaseHist(doc.history, change);\n        rebased.push(doc.history);\n      }\n      makeChangeSingleDoc(doc, change, null, stretchSpansOverChange(doc, change));\n    });\n  }\n\n  // Revert a change stored in a document\'s history.\n  function makeChangeFromHistory(doc, type, allowSelectionOnly) {\n    if (doc.cm && doc.cm.state.suppressEdits) return;\n\n    var hist = doc.history, event, selAfter = doc.sel;\n    var source = type == "undo" ? hist.done : hist.undone, dest = type == "undo" ? hist.undone : hist.done;\n\n    // Verify that there is a useable event (so that ctrl-z won\'t\n    // needlessly clear selection events)\n    for (var i = 0; i < source.length; i++) {\n      event = source[i];\n      if (allowSelectionOnly ? event.ranges && !event.equals(doc.sel) : !event.ranges)\n        break;\n    }\n    if (i == source.length) return;\n    hist.lastOrigin = hist.lastSelOrigin = null;\n\n    for (;;) {\n      event = source.pop();\n      if (event.ranges) {\n        pushSelectionToHistory(event, dest);\n        if (allowSelectionOnly && !event.equals(doc.sel)) {\n          setSelection(doc, event, {clearRedo: false});\n          return;\n        }\n        selAfter = event;\n      }\n      else break;\n    }\n\n    // Build up a reverse change object to add to the opposite history\n    // stack (redo when undoing, and vice versa).\n    var antiChanges = [];\n    pushSelectionToHistory(selAfter, dest);\n    dest.push({changes: antiChanges, generation: hist.generation});\n    hist.generation = event.generation || ++hist.maxGeneration;\n\n    var filter = hasHandler(doc, "beforeChange") || doc.cm && hasHandler(doc.cm, "beforeChange");\n\n    for (var i = event.changes.length - 1; i >= 0; --i) {\n      var change = event.changes[i];\n      change.origin = type;\n      if (filter && !filterChange(doc, change, false)) {\n        source.length = 0;\n        return;\n      }\n\n      antiChanges.push(historyChangeFromChange(doc, change));\n\n      var after = i ? computeSelAfterChange(doc, change) : lst(source);\n      makeChangeSingleDoc(doc, change, after, mergeOldSpans(doc, change));\n      if (!i && doc.cm) doc.cm.scrollIntoView({from: change.from, to: changeEnd(change)});\n      var rebased = [];\n\n      // Propagate to the linked documents\n      linkedDocs(doc, function(doc, sharedHist) {\n        if (!sharedHist && indexOf(rebased, doc.history) == -1) {\n          rebaseHist(doc.history, change);\n          rebased.push(doc.history);\n        }\n        makeChangeSingleDoc(doc, change, null, mergeOldSpans(doc, change));\n      });\n    }\n  }\n\n  // Sub-views need their line numbers shifted when text is added\n  // above or below them in the parent document.\n  function shiftDoc(doc, distance) {\n    if (distance == 0) return;\n    doc.first += distance;\n    doc.sel = new Selection(map(doc.sel.ranges, function(range) {\n      return new Range(Pos(range.anchor.line + distance, range.anchor.ch),\n                       Pos(range.head.line + distance, range.head.ch));\n    }), doc.sel.primIndex);\n    if (doc.cm) {\n      regChange(doc.cm, doc.first, doc.first - distance, distance);\n      for (var d = doc.cm.display, l = d.viewFrom; l < d.viewTo; l++)\n        regLineChange(doc.cm, l, "gutter");\n    }\n  }\n\n  // More lower-level change function, handling only a single document\n  // (not linked ones).\n  function makeChangeSingleDoc(doc, change, selAfter, spans) {\n    if (doc.cm && !doc.cm.curOp)\n      return operation(doc.cm, makeChangeSingleDoc)(doc, change, selAfter, spans);\n\n    if (change.to.line < doc.first) {\n      shiftDoc(doc, change.text.length - 1 - (change.to.line - change.from.line));\n      return;\n    }\n    if (change.from.line > doc.lastLine()) return;\n\n    // Clip the change to the size of this doc\n    if (change.from.line < doc.first) {\n      var shift = change.text.length - 1 - (doc.first - change.from.line);\n      shiftDoc(doc, shift);\n      change = {from: Pos(doc.first, 0), to: Pos(change.to.line + shift, change.to.ch),\n                text: [lst(change.text)], origin: change.origin};\n    }\n    var last = doc.lastLine();\n    if (change.to.line > last) {\n      change = {from: change.from, to: Pos(last, getLine(doc, last).text.length),\n                text: [change.text[0]], origin: change.origin};\n    }\n\n    change.removed = getBetween(doc, change.from, change.to);\n\n    if (!selAfter) selAfter = computeSelAfterChange(doc, change);\n    if (doc.cm) makeChangeSingleDocInEditor(doc.cm, change, spans);\n    else updateDoc(doc, change, spans);\n    setSelectionNoUndo(doc, selAfter, sel_dontScroll);\n  }\n\n  // Handle the interaction of a change to a document with the editor\n  // that this document is part of.\n  function makeChangeSingleDocInEditor(cm, change, spans) {\n    var doc = cm.doc, display = cm.display, from = change.from, to = change.to;\n\n    var recomputeMaxLength = false, checkWidthStart = from.line;\n    if (!cm.options.lineWrapping) {\n      checkWidthStart = lineNo(visualLine(getLine(doc, from.line)));\n      doc.iter(checkWidthStart, to.line + 1, function(line) {\n        if (line == display.maxLine) {\n          recomputeMaxLength = true;\n          return true;\n        }\n      });\n    }\n\n    if (doc.sel.contains(change.from, change.to) > -1)\n      signalCursorActivity(cm);\n\n    updateDoc(doc, change, spans, estimateHeight(cm));\n\n    if (!cm.options.lineWrapping) {\n      doc.iter(checkWidthStart, from.line + change.text.length, function(line) {\n        var len = lineLength(line);\n        if (len > display.maxLineLength) {\n          display.maxLine = line;\n          display.maxLineLength = len;\n          display.maxLineChanged = true;\n          recomputeMaxLength = false;\n        }\n      });\n      if (recomputeMaxLength) cm.curOp.updateMaxLine = true;\n    }\n\n    // Adjust frontier, schedule worker\n    doc.frontier = Math.min(doc.frontier, from.line);\n    startWorker(cm, 400);\n\n    var lendiff = change.text.length - (to.line - from.line) - 1;\n    // Remember that these lines changed, for updating the display\n    if (change.full)\n      regChange(cm);\n    else if (from.line == to.line && change.text.length == 1 && !isWholeLineUpdate(cm.doc, change))\n      regLineChange(cm, from.line, "text");\n    else\n      regChange(cm, from.line, to.line + 1, lendiff);\n\n    var changesHandler = hasHandler(cm, "changes"), changeHandler = hasHandler(cm, "change");\n    if (changeHandler || changesHandler) {\n      var obj = {\n        from: from, to: to,\n        text: change.text,\n        removed: change.removed,\n        origin: change.origin\n      };\n      if (changeHandler) signalLater(cm, "change", cm, obj);\n      if (changesHandler) (cm.curOp.changeObjs || (cm.curOp.changeObjs = [])).push(obj);\n    }\n    cm.display.selForContextMenu = null;\n  }\n\n  function replaceRange(doc, code, from, to, origin) {\n    if (!to) to = from;\n    if (cmp(to, from) < 0) { var tmp = to; to = from; from = tmp; }\n    if (typeof code == "string") code = doc.splitLines(code);\n    makeChange(doc, {from: from, to: to, text: code, origin: origin});\n  }\n\n  // SCROLLING THINGS INTO VIEW\n\n  // If an editor sits on the top or bottom of the window, partially\n  // scrolled out of view, this ensures that the cursor is visible.\n  function maybeScrollWindow(cm, coords) {\n    if (signalDOMEvent(cm, "scrollCursorIntoView")) return;\n\n    var display = cm.display, box = display.sizer.getBoundingClientRect(), doScroll = null;\n    if (coords.top + box.top < 0) doScroll = true;\n    else if (coords.bottom + box.top > (window.innerHeight || document.documentElement.clientHeight)) doScroll = false;\n    if (doScroll != null && !phantom) {\n      var scrollNode = elt("div", "\\u200b", null, "position: absolute; top: " +\n                           (coords.top - display.viewOffset - paddingTop(cm.display)) + "px; height: " +\n                           (coords.bottom - coords.top + scrollGap(cm) + display.barHeight) + "px; left: " +\n                           coords.left + "px; width: 2px;");\n      cm.display.lineSpace.appendChild(scrollNode);\n      scrollNode.scrollIntoView(doScroll);\n      cm.display.lineSpace.removeChild(scrollNode);\n    }\n  }\n\n  // Scroll a given position into view (immediately), verifying that\n  // it actually became visible (as line heights are accurately\n  // measured, the position of something may \'drift\' during drawing).\n  function scrollPosIntoView(cm, pos, end, margin) {\n    if (margin == null) margin = 0;\n    for (var limit = 0; limit < 5; limit++) {\n      var changed = false, coords = cursorCoords(cm, pos);\n      var endCoords = !end || end == pos ? coords : cursorCoords(cm, end);\n      var scrollPos = calculateScrollPos(cm, Math.min(coords.left, endCoords.left),\n                                         Math.min(coords.top, endCoords.top) - margin,\n                                         Math.max(coords.left, endCoords.left),\n                                         Math.max(coords.bottom, endCoords.bottom) + margin);\n      var startTop = cm.doc.scrollTop, startLeft = cm.doc.scrollLeft;\n      if (scrollPos.scrollTop != null) {\n        setScrollTop(cm, scrollPos.scrollTop);\n        if (Math.abs(cm.doc.scrollTop - startTop) > 1) changed = true;\n      }\n      if (scrollPos.scrollLeft != null) {\n        setScrollLeft(cm, scrollPos.scrollLeft);\n        if (Math.abs(cm.doc.scrollLeft - startLeft) > 1) changed = true;\n      }\n      if (!changed) break;\n    }\n    return coords;\n  }\n\n  // Scroll a given set of coordinates into view (immediately).\n  function scrollIntoView(cm, x1, y1, x2, y2) {\n    var scrollPos = calculateScrollPos(cm, x1, y1, x2, y2);\n    if (scrollPos.scrollTop != null) setScrollTop(cm, scrollPos.scrollTop);\n    if (scrollPos.scrollLeft != null) setScrollLeft(cm, scrollPos.scrollLeft);\n  }\n\n  // Calculate a new scroll position needed to scroll the given\n  // rectangle into view. Returns an object with scrollTop and\n  // scrollLeft properties. When these are undefined, the\n  // vertical/horizontal position does not need to be adjusted.\n  function calculateScrollPos(cm, x1, y1, x2, y2) {\n    var display = cm.display, snapMargin = textHeight(cm.display);\n    if (y1 < 0) y1 = 0;\n    var screentop = cm.curOp && cm.curOp.scrollTop != null ? cm.curOp.scrollTop : display.scroller.scrollTop;\n    var screen = displayHeight(cm), result = {};\n    if (y2 - y1 > screen) y2 = y1 + screen;\n    var docBottom = cm.doc.height + paddingVert(display);\n    var atTop = y1 < snapMargin, atBottom = y2 > docBottom - snapMargin;\n    if (y1 < screentop) {\n      result.scrollTop = atTop ? 0 : y1;\n    } else if (y2 > screentop + screen) {\n      var newTop = Math.min(y1, (atBottom ? docBottom : y2) - screen);\n      if (newTop != screentop) result.scrollTop = newTop;\n    }\n\n    var screenleft = cm.curOp && cm.curOp.scrollLeft != null ? cm.curOp.scrollLeft : display.scroller.scrollLeft;\n    var screenw = displayWidth(cm) - (cm.options.fixedGutter ? display.gutters.offsetWidth : 0);\n    var tooWide = x2 - x1 > screenw;\n    if (tooWide) x2 = x1 + screenw;\n    if (x1 < 10)\n      result.scrollLeft = 0;\n    else if (x1 < screenleft)\n      result.scrollLeft = Math.max(0, x1 - (tooWide ? 0 : 10));\n    else if (x2 > screenw + screenleft - 3)\n      result.scrollLeft = x2 + (tooWide ? 0 : 10) - screenw;\n    return result;\n  }\n\n  // Store a relative adjustment to the scroll position in the current\n  // operation (to be applied when the operation finishes).\n  function addToScrollPos(cm, left, top) {\n    if (left != null || top != null) resolveScrollToPos(cm);\n    if (left != null)\n      cm.curOp.scrollLeft = (cm.curOp.scrollLeft == null ? cm.doc.scrollLeft : cm.curOp.scrollLeft) + left;\n    if (top != null)\n      cm.curOp.scrollTop = (cm.curOp.scrollTop == null ? cm.doc.scrollTop : cm.curOp.scrollTop) + top;\n  }\n\n  // Make sure that at the end of the operation the current cursor is\n  // shown.\n  function ensureCursorVisible(cm) {\n    resolveScrollToPos(cm);\n    var cur = cm.getCursor(), from = cur, to = cur;\n    if (!cm.options.lineWrapping) {\n      from = cur.ch ? Pos(cur.line, cur.ch - 1) : cur;\n      to = Pos(cur.line, cur.ch + 1);\n    }\n    cm.curOp.scrollToPos = {from: from, to: to, margin: cm.options.cursorScrollMargin, isCursor: true};\n  }\n\n  // When an operation has its scrollToPos property set, and another\n  // scroll action is applied before the end of the operation, this\n  // \'simulates\' scrolling that position into view in a cheap way, so\n  // that the effect of intermediate scroll commands is not ignored.\n  function resolveScrollToPos(cm) {\n    var range = cm.curOp.scrollToPos;\n    if (range) {\n      cm.curOp.scrollToPos = null;\n      var from = estimateCoords(cm, range.from), to = estimateCoords(cm, range.to);\n      var sPos = calculateScrollPos(cm, Math.min(from.left, to.left),\n                                    Math.min(from.top, to.top) - range.margin,\n                                    Math.max(from.right, to.right),\n                                    Math.max(from.bottom, to.bottom) + range.margin);\n      cm.scrollTo(sPos.scrollLeft, sPos.scrollTop);\n    }\n  }\n\n  // API UTILITIES\n\n  // Indent the given line. The how parameter can be "smart",\n  // "add"/null, "subtract", or "prev". When aggressive is false\n  // (typically set to true for forced single-line indents), empty\n  // lines are not indented, and places where the mode returns Pass\n  // are left alone.\n  function indentLine(cm, n, how, aggressive) {\n    var doc = cm.doc, state;\n    if (how == null) how = "add";\n    if (how == "smart") {\n      // Fall back to "prev" when the mode doesn\'t have an indentation\n      // method.\n      if (!doc.mode.indent) how = "prev";\n      else state = getStateBefore(cm, n);\n    }\n\n    var tabSize = cm.options.tabSize;\n    var line = getLine(doc, n), curSpace = countColumn(line.text, null, tabSize);\n    if (line.stateAfter) line.stateAfter = null;\n    var curSpaceString = line.text.match(/^\\s*/)[0], indentation;\n    if (!aggressive && !/\\S/.test(line.text)) {\n      indentation = 0;\n      how = "not";\n    } else if (how == "smart") {\n      indentation = doc.mode.indent(state, line.text.slice(curSpaceString.length), line.text);\n      if (indentation == Pass || indentation > 150) {\n        if (!aggressive) return;\n        how = "prev";\n      }\n    }\n    if (how == "prev") {\n      if (n > doc.first) indentation = countColumn(getLine(doc, n-1).text, null, tabSize);\n      else indentation = 0;\n    } else if (how == "add") {\n      indentation = curSpace + cm.options.indentUnit;\n    } else if (how == "subtract") {\n      indentation = curSpace - cm.options.indentUnit;\n    } else if (typeof how == "number") {\n      indentation = curSpace + how;\n    }\n    indentation = Math.max(0, indentation);\n\n    var indentString = "", pos = 0;\n    if (cm.options.indentWithTabs)\n      for (var i = Math.floor(indentation / tabSize); i; --i) {pos += tabSize; indentString += "\\t";}\n    if (pos < indentation) indentString += spaceStr(indentation - pos);\n\n    if (indentString != curSpaceString) {\n      replaceRange(doc, indentString, Pos(n, 0), Pos(n, curSpaceString.length), "+input");\n      line.stateAfter = null;\n      return true;\n    } else {\n      // Ensure that, if the cursor was in the whitespace at the start\n      // of the line, it is moved to the end of that space.\n      for (var i = 0; i < doc.sel.ranges.length; i++) {\n        var range = doc.sel.ranges[i];\n        if (range.head.line == n && range.head.ch < curSpaceString.length) {\n          var pos = Pos(n, curSpaceString.length);\n          replaceOneSelection(doc, i, new Range(pos, pos));\n          break;\n        }\n      }\n    }\n  }\n\n  // Utility for applying a change to a line by handle or number,\n  // returning the number and optionally registering the line as\n  // changed.\n  function changeLine(doc, handle, changeType, op) {\n    var no = handle, line = handle;\n    if (typeof handle == "number") line = getLine(doc, clipLine(doc, handle));\n    else no = lineNo(handle);\n    if (no == null) return null;\n    if (op(line, no) && doc.cm) regLineChange(doc.cm, no, changeType);\n    return line;\n  }\n\n  // Helper for deleting text near the selection(s), used to implement\n  // backspace, delete, and similar functionality.\n  function deleteNearSelection(cm, compute) {\n    var ranges = cm.doc.sel.ranges, kill = [];\n    // Build up a set of ranges to kill first, merging overlapping\n    // ranges.\n    for (var i = 0; i < ranges.length; i++) {\n      var toKill = compute(ranges[i]);\n      while (kill.length && cmp(toKill.from, lst(kill).to) <= 0) {\n        var replaced = kill.pop();\n        if (cmp(replaced.from, toKill.from) < 0) {\n          toKill.from = replaced.from;\n          break;\n        }\n      }\n      kill.push(toKill);\n    }\n    // Next, remove those actual ranges.\n    runInOp(cm, function() {\n      for (var i = kill.length - 1; i >= 0; i--)\n        replaceRange(cm.doc, "", kill[i].from, kill[i].to, "+delete");\n      ensureCursorVisible(cm);\n    });\n  }\n\n  // Used for horizontal relative motion. Dir is -1 or 1 (left or\n  // right), unit can be "char", "column" (like char, but doesn\'t\n  // cross line boundaries), "word" (across next word), or "group" (to\n  // the start of next group of word or non-word-non-whitespace\n  // chars). The visually param controls whether, in right-to-left\n  // text, direction 1 means to move towards the next index in the\n  // string, or towards the character to the right of the current\n  // position. The resulting position will have a hitSide=true\n  // property if it reached the end of the document.\n  function findPosH(doc, pos, dir, unit, visually) {\n    var line = pos.line, ch = pos.ch, origDir = dir;\n    var lineObj = getLine(doc, line);\n    var possible = true;\n    function findNextLine() {\n      var l = line + dir;\n      if (l < doc.first || l >= doc.first + doc.size) return (possible = false);\n      line = l;\n      return lineObj = getLine(doc, l);\n    }\n    function moveOnce(boundToLine) {\n      var next = (visually ? moveVisually : moveLogically)(lineObj, ch, dir, true);\n      if (next == null) {\n        if (!boundToLine && findNextLine()) {\n          if (visually) ch = (dir < 0 ? lineRight : lineLeft)(lineObj);\n          else ch = dir < 0 ? lineObj.text.length : 0;\n        } else return (possible = false);\n      } else ch = next;\n      return true;\n    }\n\n    if (unit == "char") moveOnce();\n    else if (unit == "column") moveOnce(true);\n    else if (unit == "word" || unit == "group") {\n      var sawType = null, group = unit == "group";\n      var helper = doc.cm && doc.cm.getHelper(pos, "wordChars");\n      for (var first = true;; first = false) {\n        if (dir < 0 && !moveOnce(!first)) break;\n        var cur = lineObj.text.charAt(ch) || "\\n";\n        var type = isWordChar(cur, helper) ? "w"\n          : group && cur == "\\n" ? "n"\n          : !group || /\\s/.test(cur) ? null\n          : "p";\n        if (group && !first && !type) type = "s";\n        if (sawType && sawType != type) {\n          if (dir < 0) {dir = 1; moveOnce();}\n          break;\n        }\n\n        if (type) sawType = type;\n        if (dir > 0 && !moveOnce(!first)) break;\n      }\n    }\n    var result = skipAtomic(doc, Pos(line, ch), origDir, true);\n    if (!possible) result.hitSide = true;\n    return result;\n  }\n\n  // For relative vertical movement. Dir may be -1 or 1. Unit can be\n  // "page" or "line". The resulting position will have a hitSide=true\n  // property if it reached the end of the document.\n  function findPosV(cm, pos, dir, unit) {\n    var doc = cm.doc, x = pos.left, y;\n    if (unit == "page") {\n      var pageSize = Math.min(cm.display.wrapper.clientHeight, window.innerHeight || document.documentElement.clientHeight);\n      y = pos.top + dir * (pageSize - (dir < 0 ? 1.5 : .5) * textHeight(cm.display));\n    } else if (unit == "line") {\n      y = dir > 0 ? pos.bottom + 3 : pos.top - 3;\n    }\n    for (;;) {\n      var target = coordsChar(cm, x, y);\n      if (!target.outside) break;\n      if (dir < 0 ? y <= 0 : y >= doc.height) { target.hitSide = true; break; }\n      y += dir * 5;\n    }\n    return target;\n  }\n\n  // EDITOR METHODS\n\n  // The publicly visible API. Note that methodOp(f) means\n  // \'wrap f in an operation, performed on its `this` parameter\'.\n\n  // This is not the complete set of editor methods. Most of the\n  // methods defined on the Doc type are also injected into\n  // CodeMirror.prototype, for backwards compatibility and\n  // convenience.\n\n  CodeMirror.prototype = {\n    constructor: CodeMirror,\n    focus: function(){window.focus(); this.display.input.focus();},\n\n    setOption: function(option, value) {\n      var options = this.options, old = options[option];\n      if (options[option] == value && option != "mode") return;\n      options[option] = value;\n      if (optionHandlers.hasOwnProperty(option))\n        operation(this, optionHandlers[option])(this, value, old);\n    },\n\n    getOption: function(option) {return this.options[option];},\n    getDoc: function() {return this.doc;},\n\n    addKeyMap: function(map, bottom) {\n      this.state.keyMaps[bottom ? "push" : "unshift"](getKeyMap(map));\n    },\n    removeKeyMap: function(map) {\n      var maps = this.state.keyMaps;\n      for (var i = 0; i < maps.length; ++i)\n        if (maps[i] == map || maps[i].name == map) {\n          maps.splice(i, 1);\n          return true;\n        }\n    },\n\n    addOverlay: methodOp(function(spec, options) {\n      var mode = spec.token ? spec : CodeMirror.getMode(this.options, spec);\n      if (mode.startState) throw new Error("Overlays may not be stateful.");\n      this.state.overlays.push({mode: mode, modeSpec: spec, opaque: options && options.opaque});\n      this.state.modeGen++;\n      regChange(this);\n    }),\n    removeOverlay: methodOp(function(spec) {\n      var overlays = this.state.overlays;\n      for (var i = 0; i < overlays.length; ++i) {\n        var cur = overlays[i].modeSpec;\n        if (cur == spec || typeof spec == "string" && cur.name == spec) {\n          overlays.splice(i, 1);\n          this.state.modeGen++;\n          regChange(this);\n          return;\n        }\n      }\n    }),\n\n    indentLine: methodOp(function(n, dir, aggressive) {\n      if (typeof dir != "string" && typeof dir != "number") {\n        if (dir == null) dir = this.options.smartIndent ? "smart" : "prev";\n        else dir = dir ? "add" : "subtract";\n      }\n      if (isLine(this.doc, n)) indentLine(this, n, dir, aggressive);\n    }),\n    indentSelection: methodOp(function(how) {\n      var ranges = this.doc.sel.ranges, end = -1;\n      for (var i = 0; i < ranges.length; i++) {\n        var range = ranges[i];\n        if (!range.empty()) {\n          var from = range.from(), to = range.to();\n          var start = Math.max(end, from.line);\n          end = Math.min(this.lastLine(), to.line - (to.ch ? 0 : 1)) + 1;\n          for (var j = start; j < end; ++j)\n            indentLine(this, j, how);\n          var newRanges = this.doc.sel.ranges;\n          if (from.ch == 0 && ranges.length == newRanges.length && newRanges[i].from().ch > 0)\n            replaceOneSelection(this.doc, i, new Range(from, newRanges[i].to()), sel_dontScroll);\n        } else if (range.head.line > end) {\n          indentLine(this, range.head.line, how, true);\n          end = range.head.line;\n          if (i == this.doc.sel.primIndex) ensureCursorVisible(this);\n        }\n      }\n    }),\n\n    // Fetch the parser token for a given character. Useful for hacks\n    // that want to inspect the mode state (say, for completion).\n    getTokenAt: function(pos, precise) {\n      return takeToken(this, pos, precise);\n    },\n\n    getLineTokens: function(line, precise) {\n      return takeToken(this, Pos(line), precise, true);\n    },\n\n    getTokenTypeAt: function(pos) {\n      pos = clipPos(this.doc, pos);\n      var styles = getLineStyles(this, getLine(this.doc, pos.line));\n      var before = 0, after = (styles.length - 1) / 2, ch = pos.ch;\n      var type;\n      if (ch == 0) type = styles[2];\n      else for (;;) {\n        var mid = (before + after) >> 1;\n        if ((mid ? styles[mid * 2 - 1] : 0) >= ch) after = mid;\n        else if (styles[mid * 2 + 1] < ch) before = mid + 1;\n        else { type = styles[mid * 2 + 2]; break; }\n      }\n      var cut = type ? type.indexOf("cm-overlay ") : -1;\n      return cut < 0 ? type : cut == 0 ? null : type.slice(0, cut - 1);\n    },\n\n    getModeAt: function(pos) {\n      var mode = this.doc.mode;\n      if (!mode.innerMode) return mode;\n      return CodeMirror.innerMode(mode, this.getTokenAt(pos).state).mode;\n    },\n\n    getHelper: function(pos, type) {\n      return this.getHelpers(pos, type)[0];\n    },\n\n    getHelpers: function(pos, type) {\n      var found = [];\n      if (!helpers.hasOwnProperty(type)) return found;\n      var help = helpers[type], mode = this.getModeAt(pos);\n      if (typeof mode[type] == "string") {\n        if (help[mode[type]]) found.push(help[mode[type]]);\n      } else if (mode[type]) {\n        for (var i = 0; i < mode[type].length; i++) {\n          var val = help[mode[type][i]];\n          if (val) found.push(val);\n        }\n      } else if (mode.helperType && help[mode.helperType]) {\n        found.push(help[mode.helperType]);\n      } else if (help[mode.name]) {\n        found.push(help[mode.name]);\n      }\n      for (var i = 0; i < help._global.length; i++) {\n        var cur = help._global[i];\n        if (cur.pred(mode, this) && indexOf(found, cur.val) == -1)\n          found.push(cur.val);\n      }\n      return found;\n    },\n\n    getStateAfter: function(line, precise) {\n      var doc = this.doc;\n      line = clipLine(doc, line == null ? doc.first + doc.size - 1: line);\n      return getStateBefore(this, line + 1, precise);\n    },\n\n    cursorCoords: function(start, mode) {\n      var pos, range = this.doc.sel.primary();\n      if (start == null) pos = range.head;\n      else if (typeof start == "object") pos = clipPos(this.doc, start);\n      else pos = start ? range.from() : range.to();\n      return cursorCoords(this, pos, mode || "page");\n    },\n\n    charCoords: function(pos, mode) {\n      return charCoords(this, clipPos(this.doc, pos), mode || "page");\n    },\n\n    coordsChar: function(coords, mode) {\n      coords = fromCoordSystem(this, coords, mode || "page");\n      return coordsChar(this, coords.left, coords.top);\n    },\n\n    lineAtHeight: function(height, mode) {\n      height = fromCoordSystem(this, {top: height, left: 0}, mode || "page").top;\n      return lineAtHeight(this.doc, height + this.display.viewOffset);\n    },\n    heightAtLine: function(line, mode) {\n      var end = false, lineObj;\n      if (typeof line == "number") {\n        var last = this.doc.first + this.doc.size - 1;\n        if (line < this.doc.first) line = this.doc.first;\n        else if (line > last) { line = last; end = true; }\n        lineObj = getLine(this.doc, line);\n      } else {\n        lineObj = line;\n      }\n      return intoCoordSystem(this, lineObj, {top: 0, left: 0}, mode || "page").top +\n        (end ? this.doc.height - heightAtLine(lineObj) : 0);\n    },\n\n    defaultTextHeight: function() { return textHeight(this.display); },\n    defaultCharWidth: function() { return charWidth(this.display); },\n\n    setGutterMarker: methodOp(function(line, gutterID, value) {\n      return changeLine(this.doc, line, "gutter", function(line) {\n        var markers = line.gutterMarkers || (line.gutterMarkers = {});\n        markers[gutterID] = value;\n        if (!value && isEmpty(markers)) line.gutterMarkers = null;\n        return true;\n      });\n    }),\n\n    clearGutter: methodOp(function(gutterID) {\n      var cm = this, doc = cm.doc, i = doc.first;\n      doc.iter(function(line) {\n        if (line.gutterMarkers && line.gutterMarkers[gutterID]) {\n          line.gutterMarkers[gutterID] = null;\n          regLineChange(cm, i, "gutter");\n          if (isEmpty(line.gutterMarkers)) line.gutterMarkers = null;\n        }\n        ++i;\n      });\n    }),\n\n    lineInfo: function(line) {\n      if (typeof line == "number") {\n        if (!isLine(this.doc, line)) return null;\n        var n = line;\n        line = getLine(this.doc, line);\n        if (!line) return null;\n      } else {\n        var n = lineNo(line);\n        if (n == null) return null;\n      }\n      return {line: n, handle: line, text: line.text, gutterMarkers: line.gutterMarkers,\n              textClass: line.textClass, bgClass: line.bgClass, wrapClass: line.wrapClass,\n              widgets: line.widgets};\n    },\n\n    getViewport: function() { return {from: this.display.viewFrom, to: this.display.viewTo};},\n\n    addWidget: function(pos, node, scroll, vert, horiz) {\n      var display = this.display;\n      pos = cursorCoords(this, clipPos(this.doc, pos));\n      var top = pos.bottom, left = pos.left;\n      node.style.position = "absolute";\n      node.setAttribute("cm-ignore-events", "true");\n      this.display.input.setUneditable(node);\n      display.sizer.appendChild(node);\n      if (vert == "over") {\n        top = pos.top;\n      } else if (vert == "above" || vert == "near") {\n        var vspace = Math.max(display.wrapper.clientHeight, this.doc.height),\n        hspace = Math.max(display.sizer.clientWidth, display.lineSpace.clientWidth);\n        // Default to positioning above (if specified and possible); otherwise default to positioning below\n        if ((vert == \'above\' || pos.bottom + node.offsetHeight > vspace) && pos.top > node.offsetHeight)\n          top = pos.top - node.offsetHeight;\n        else if (pos.bottom + node.offsetHeight <= vspace)\n          top = pos.bottom;\n        if (left + node.offsetWidth > hspace)\n          left = hspace - node.offsetWidth;\n      }\n      node.style.top = top + "px";\n      node.style.left = node.style.right = "";\n      if (horiz == "right") {\n        left = display.sizer.clientWidth - node.offsetWidth;\n        node.style.right = "0px";\n      } else {\n        if (horiz == "left") left = 0;\n        else if (horiz == "middle") left = (display.sizer.clientWidth - node.offsetWidth) / 2;\n        node.style.left = left + "px";\n      }\n      if (scroll)\n        scrollIntoView(this, left, top, left + node.offsetWidth, top + node.offsetHeight);\n    },\n\n    triggerOnKeyDown: methodOp(onKeyDown),\n    triggerOnKeyPress: methodOp(onKeyPress),\n    triggerOnKeyUp: onKeyUp,\n\n    execCommand: function(cmd) {\n      if (commands.hasOwnProperty(cmd))\n        return commands[cmd].call(null, this);\n    },\n\n    triggerElectric: methodOp(function(text) { triggerElectric(this, text); }),\n\n    findPosH: function(from, amount, unit, visually) {\n      var dir = 1;\n      if (amount < 0) { dir = -1; amount = -amount; }\n      for (var i = 0, cur = clipPos(this.doc, from); i < amount; ++i) {\n        cur = findPosH(this.doc, cur, dir, unit, visually);\n        if (cur.hitSide) break;\n      }\n      return cur;\n    },\n\n    moveH: methodOp(function(dir, unit) {\n      var cm = this;\n      cm.extendSelectionsBy(function(range) {\n        if (cm.display.shift || cm.doc.extend || range.empty())\n          return findPosH(cm.doc, range.head, dir, unit, cm.options.rtlMoveVisually);\n        else\n          return dir < 0 ? range.from() : range.to();\n      }, sel_move);\n    }),\n\n    deleteH: methodOp(function(dir, unit) {\n      var sel = this.doc.sel, doc = this.doc;\n      if (sel.somethingSelected())\n        doc.replaceSelection("", null, "+delete");\n      else\n        deleteNearSelection(this, function(range) {\n          var other = findPosH(doc, range.head, dir, unit, false);\n          return dir < 0 ? {from: other, to: range.head} : {from: range.head, to: other};\n        });\n    }),\n\n    findPosV: function(from, amount, unit, goalColumn) {\n      var dir = 1, x = goalColumn;\n      if (amount < 0) { dir = -1; amount = -amount; }\n      for (var i = 0, cur = clipPos(this.doc, from); i < amount; ++i) {\n        var coords = cursorCoords(this, cur, "div");\n        if (x == null) x = coords.left;\n        else coords.left = x;\n        cur = findPosV(this, coords, dir, unit);\n        if (cur.hitSide) break;\n      }\n      return cur;\n    },\n\n    moveV: methodOp(function(dir, unit) {\n      var cm = this, doc = this.doc, goals = [];\n      var collapse = !cm.display.shift && !doc.extend && doc.sel.somethingSelected();\n      doc.extendSelectionsBy(function(range) {\n        if (collapse)\n          return dir < 0 ? range.from() : range.to();\n        var headPos = cursorCoords(cm, range.head, "div");\n        if (range.goalColumn != null) headPos.left = range.goalColumn;\n        goals.push(headPos.left);\n        var pos = findPosV(cm, headPos, dir, unit);\n        if (unit == "page" && range == doc.sel.primary())\n          addToScrollPos(cm, null, charCoords(cm, pos, "div").top - headPos.top);\n        return pos;\n      }, sel_move);\n      if (goals.length) for (var i = 0; i < doc.sel.ranges.length; i++)\n        doc.sel.ranges[i].goalColumn = goals[i];\n    }),\n\n    // Find the word at the given position (as returned by coordsChar).\n    findWordAt: function(pos) {\n      var doc = this.doc, line = getLine(doc, pos.line).text;\n      var start = pos.ch, end = pos.ch;\n      if (line) {\n        var helper = this.getHelper(pos, "wordChars");\n        if ((pos.xRel < 0 || end == line.length) && start) --start; else ++end;\n        var startChar = line.charAt(start);\n        var check = isWordChar(startChar, helper)\n          ? function(ch) { return isWordChar(ch, helper); }\n          : /\\s/.test(startChar) ? function(ch) {return /\\s/.test(ch);}\n          : function(ch) {return !/\\s/.test(ch) && !isWordChar(ch);};\n        while (start > 0 && check(line.charAt(start - 1))) --start;\n        while (end < line.length && check(line.charAt(end))) ++end;\n      }\n      return new Range(Pos(pos.line, start), Pos(pos.line, end));\n    },\n\n    toggleOverwrite: function(value) {\n      if (value != null && value == this.state.overwrite) return;\n      if (this.state.overwrite = !this.state.overwrite)\n        addClass(this.display.cursorDiv, "CodeMirror-overwrite");\n      else\n        rmClass(this.display.cursorDiv, "CodeMirror-overwrite");\n\n      signal(this, "overwriteToggle", this, this.state.overwrite);\n    },\n    hasFocus: function() { return this.display.input.getField() == activeElt(); },\n\n    scrollTo: methodOp(function(x, y) {\n      if (x != null || y != null) resolveScrollToPos(this);\n      if (x != null) this.curOp.scrollLeft = x;\n      if (y != null) this.curOp.scrollTop = y;\n    }),\n    getScrollInfo: function() {\n      var scroller = this.display.scroller;\n      return {left: scroller.scrollLeft, top: scroller.scrollTop,\n              height: scroller.scrollHeight - scrollGap(this) - this.display.barHeight,\n              width: scroller.scrollWidth - scrollGap(this) - this.display.barWidth,\n              clientHeight: displayHeight(this), clientWidth: displayWidth(this)};\n    },\n\n    scrollIntoView: methodOp(function(range, margin) {\n      if (range == null) {\n        range = {from: this.doc.sel.primary().head, to: null};\n        if (margin == null) margin = this.options.cursorScrollMargin;\n      } else if (typeof range == "number") {\n        range = {from: Pos(range, 0), to: null};\n      } else if (range.from == null) {\n        range = {from: range, to: null};\n      }\n      if (!range.to) range.to = range.from;\n      range.margin = margin || 0;\n\n      if (range.from.line != null) {\n        resolveScrollToPos(this);\n        this.curOp.scrollToPos = range;\n      } else {\n        var sPos = calculateScrollPos(this, Math.min(range.from.left, range.to.left),\n                                      Math.min(range.from.top, range.to.top) - range.margin,\n                                      Math.max(range.from.right, range.to.right),\n                                      Math.max(range.from.bottom, range.to.bottom) + range.margin);\n        this.scrollTo(sPos.scrollLeft, sPos.scrollTop);\n      }\n    }),\n\n    setSize: methodOp(function(width, height) {\n      var cm = this;\n      function interpret(val) {\n        return typeof val == "number" || /^\\d+$/.test(String(val)) ? val + "px" : val;\n      }\n      if (width != null) cm.display.wrapper.style.width = interpret(width);\n      if (height != null) cm.display.wrapper.style.height = interpret(height);\n      if (cm.options.lineWrapping) clearLineMeasurementCache(this);\n      var lineNo = cm.display.viewFrom;\n      cm.doc.iter(lineNo, cm.display.viewTo, function(line) {\n        if (line.widgets) for (var i = 0; i < line.widgets.length; i++)\n          if (line.widgets[i].noHScroll) { regLineChange(cm, lineNo, "widget"); break; }\n        ++lineNo;\n      });\n      cm.curOp.forceUpdate = true;\n      signal(cm, "refresh", this);\n    }),\n\n    operation: function(f){return runInOp(this, f);},\n\n    refresh: methodOp(function() {\n      var oldHeight = this.display.cachedTextHeight;\n      regChange(this);\n      this.curOp.forceUpdate = true;\n      clearCaches(this);\n      this.scrollTo(this.doc.scrollLeft, this.doc.scrollTop);\n      updateGutterSpace(this);\n      if (oldHeight == null || Math.abs(oldHeight - textHeight(this.display)) > .5)\n        estimateLineHeights(this);\n      signal(this, "refresh", this);\n    }),\n\n    swapDoc: methodOp(function(doc) {\n      var old = this.doc;\n      old.cm = null;\n      attachDoc(this, doc);\n      clearCaches(this);\n      this.display.input.reset();\n      this.scrollTo(doc.scrollLeft, doc.scrollTop);\n      this.curOp.forceScroll = true;\n      signalLater(this, "swapDoc", this, old);\n      return old;\n    }),\n\n    getInputField: function(){return this.display.input.getField();},\n    getWrapperElement: function(){return this.display.wrapper;},\n    getScrollerElement: function(){return this.display.scroller;},\n    getGutterElement: function(){return this.display.gutters;}\n  };\n  eventMixin(CodeMirror);\n\n  // OPTION DEFAULTS\n\n  // The default configuration options.\n  var defaults = CodeMirror.defaults = {};\n  // Functions to run when options are changed.\n  var optionHandlers = CodeMirror.optionHandlers = {};\n\n  function option(name, deflt, handle, notOnInit) {\n    CodeMirror.defaults[name] = deflt;\n    if (handle) optionHandlers[name] =\n      notOnInit ? function(cm, val, old) {if (old != Init) handle(cm, val, old);} : handle;\n  }\n\n  // Passed to option handlers when there is no old value.\n  var Init = CodeMirror.Init = {toString: function(){return "CodeMirror.Init";}};\n\n  // These two are, on init, called from the constructor because they\n  // have to be initialized before the editor can start at all.\n  option("value", "", function(cm, val) {\n    cm.setValue(val);\n  }, true);\n  option("mode", null, function(cm, val) {\n    cm.doc.modeOption = val;\n    loadMode(cm);\n  }, true);\n\n  option("indentUnit", 2, loadMode, true);\n  option("indentWithTabs", false);\n  option("smartIndent", true);\n  option("tabSize", 4, function(cm) {\n    resetModeState(cm);\n    clearCaches(cm);\n    regChange(cm);\n  }, true);\n  option("lineSeparator", null, function(cm, val) {\n    cm.doc.lineSep = val;\n    if (!val) return;\n    var newBreaks = [], lineNo = cm.doc.first;\n    cm.doc.iter(function(line) {\n      for (var pos = 0;;) {\n        var found = line.text.indexOf(val, pos);\n        if (found == -1) break;\n        pos = found + val.length;\n        newBreaks.push(Pos(lineNo, found));\n      }\n      lineNo++;\n    });\n    for (var i = newBreaks.length - 1; i >= 0; i--)\n      replaceRange(cm.doc, val, newBreaks[i], Pos(newBreaks[i].line, newBreaks[i].ch + val.length))\n  });\n  option("specialChars", /[\\t\\u0000-\\u0019\\u00ad\\u200b-\\u200f\\u2028\\u2029\\ufeff]/g, function(cm, val, old) {\n    cm.state.specialChars = new RegExp(val.source + (val.test("\\t") ? "" : "|\\t"), "g");\n    if (old != CodeMirror.Init) cm.refresh();\n  });\n  option("specialCharPlaceholder", defaultSpecialCharPlaceholder, function(cm) {cm.refresh();}, true);\n  option("electricChars", true);\n  option("inputStyle", mobile ? "contenteditable" : "textarea", function() {\n    throw new Error("inputStyle can not (yet) be changed in a running editor"); // FIXME\n  }, true);\n  option("rtlMoveVisually", !windows);\n  option("wholeLineUpdateBefore", true);\n\n  option("theme", "default", function(cm) {\n    themeChanged(cm);\n    guttersChanged(cm);\n  }, true);\n  option("keyMap", "default", function(cm, val, old) {\n    var next = getKeyMap(val);\n    var prev = old != CodeMirror.Init && getKeyMap(old);\n    if (prev && prev.detach) prev.detach(cm, next);\n    if (next.attach) next.attach(cm, prev || null);\n  });\n  option("extraKeys", null);\n\n  option("lineWrapping", false, wrappingChanged, true);\n  option("gutters", [], function(cm) {\n    setGuttersForLineNumbers(cm.options);\n    guttersChanged(cm);\n  }, true);\n  option("fixedGutter", true, function(cm, val) {\n    cm.display.gutters.style.left = val ? compensateForHScroll(cm.display) + "px" : "0";\n    cm.refresh();\n  }, true);\n  option("coverGutterNextToScrollbar", false, function(cm) {updateScrollbars(cm);}, true);\n  option("scrollbarStyle", "native", function(cm) {\n    initScrollbars(cm);\n    updateScrollbars(cm);\n    cm.display.scrollbars.setScrollTop(cm.doc.scrollTop);\n    cm.display.scrollbars.setScrollLeft(cm.doc.scrollLeft);\n  }, true);\n  option("lineNumbers", false, function(cm) {\n    setGuttersForLineNumbers(cm.options);\n    guttersChanged(cm);\n  }, true);\n  option("firstLineNumber", 1, guttersChanged, true);\n  option("lineNumberFormatter", function(integer) {return integer;}, guttersChanged, true);\n  option("showCursorWhenSelecting", false, updateSelection, true);\n\n  option("resetSelectionOnContextMenu", true);\n  option("lineWiseCopyCut", true);\n\n  option("readOnly", false, function(cm, val) {\n    if (val == "nocursor") {\n      onBlur(cm);\n      cm.display.input.blur();\n      cm.display.disabled = true;\n    } else {\n      cm.display.disabled = false;\n      if (!val) cm.display.input.reset();\n    }\n  });\n  option("disableInput", false, function(cm, val) {if (!val) cm.display.input.reset();}, true);\n  option("dragDrop", true, dragDropChanged);\n\n  option("cursorBlinkRate", 530);\n  option("cursorScrollMargin", 0);\n  option("cursorHeight", 1, updateSelection, true);\n  option("singleCursorHeightPerLine", true, updateSelection, true);\n  option("workTime", 100);\n  option("workDelay", 100);\n  option("flattenSpans", true, resetModeState, true);\n  option("addModeClass", false, resetModeState, true);\n  option("pollInterval", 100);\n  option("undoDepth", 200, function(cm, val){cm.doc.history.undoDepth = val;});\n  option("historyEventDelay", 1250);\n  option("viewportMargin", 10, function(cm){cm.refresh();}, true);\n  option("maxHighlightLength", 10000, resetModeState, true);\n  option("moveInputWithCursor", true, function(cm, val) {\n    if (!val) cm.display.input.resetPosition();\n  });\n\n  option("tabindex", null, function(cm, val) {\n    cm.display.input.getField().tabIndex = val || "";\n  });\n  option("autofocus", null);\n\n  // MODE DEFINITION AND QUERYING\n\n  // Known modes, by name and by MIME\n  var modes = CodeMirror.modes = {}, mimeModes = CodeMirror.mimeModes = {};\n\n  // Extra arguments are stored as the mode\'s dependencies, which is\n  // used by (legacy) mechanisms like loadmode.js to automatically\n  // load a mode. (Preferred mechanism is the require/define calls.)\n  CodeMirror.defineMode = function(name, mode) {\n    if (!CodeMirror.defaults.mode && name != "null") CodeMirror.defaults.mode = name;\n    if (arguments.length > 2)\n      mode.dependencies = Array.prototype.slice.call(arguments, 2);\n    modes[name] = mode;\n  };\n\n  CodeMirror.defineMIME = function(mime, spec) {\n    mimeModes[mime] = spec;\n  };\n\n  // Given a MIME type, a {name, ...options} config object, or a name\n  // string, return a mode config object.\n  CodeMirror.resolveMode = function(spec) {\n    if (typeof spec == "string" && mimeModes.hasOwnProperty(spec)) {\n      spec = mimeModes[spec];\n    } else if (spec && typeof spec.name == "string" && mimeModes.hasOwnProperty(spec.name)) {\n      var found = mimeModes[spec.name];\n      if (typeof found == "string") found = {name: found};\n      spec = createObj(found, spec);\n      spec.name = found.name;\n    } else if (typeof spec == "string" && /^[\\w\\-]+\\/[\\w\\-]+\\+xml$/.test(spec)) {\n      return CodeMirror.resolveMode("application/xml");\n    }\n    if (typeof spec == "string") return {name: spec};\n    else return spec || {name: "null"};\n  };\n\n  // Given a mode spec (anything that resolveMode accepts), find and\n  // initialize an actual mode object.\n  CodeMirror.getMode = function(options, spec) {\n    var spec = CodeMirror.resolveMode(spec);\n    var mfactory = modes[spec.name];\n    if (!mfactory) return CodeMirror.getMode(options, "text/plain");\n    var modeObj = mfactory(options, spec);\n    if (modeExtensions.hasOwnProperty(spec.name)) {\n      var exts = modeExtensions[spec.name];\n      for (var prop in exts) {\n        if (!exts.hasOwnProperty(prop)) continue;\n        if (modeObj.hasOwnProperty(prop)) modeObj["_" + prop] = modeObj[prop];\n        modeObj[prop] = exts[prop];\n      }\n    }\n    modeObj.name = spec.name;\n    if (spec.helperType) modeObj.helperType = spec.helperType;\n    if (spec.modeProps) for (var prop in spec.modeProps)\n      modeObj[prop] = spec.modeProps[prop];\n\n    return modeObj;\n  };\n\n  // Minimal default mode.\n  CodeMirror.defineMode("null", function() {\n    return {token: function(stream) {stream.skipToEnd();}};\n  });\n  CodeMirror.defineMIME("text/plain", "null");\n\n  // This can be used to attach properties to mode objects from\n  // outside the actual mode definition.\n  var modeExtensions = CodeMirror.modeExtensions = {};\n  CodeMirror.extendMode = function(mode, properties) {\n    var exts = modeExtensions.hasOwnProperty(mode) ? modeExtensions[mode] : (modeExtensions[mode] = {});\n    copyObj(properties, exts);\n  };\n\n  // EXTENSIONS\n\n  CodeMirror.defineExtension = function(name, func) {\n    CodeMirror.prototype[name] = func;\n  };\n  CodeMirror.defineDocExtension = function(name, func) {\n    Doc.prototype[name] = func;\n  };\n  CodeMirror.defineOption = option;\n\n  var initHooks = [];\n  CodeMirror.defineInitHook = function(f) {initHooks.push(f);};\n\n  var helpers = CodeMirror.helpers = {};\n  CodeMirror.registerHelper = function(type, name, value) {\n    if (!helpers.hasOwnProperty(type)) helpers[type] = CodeMirror[type] = {_global: []};\n    helpers[type][name] = value;\n  };\n  CodeMirror.registerGlobalHelper = function(type, name, predicate, value) {\n    CodeMirror.registerHelper(type, name, value);\n    helpers[type]._global.push({pred: predicate, val: value});\n  };\n\n  // MODE STATE HANDLING\n\n  // Utility functions for working with state. Exported because nested\n  // modes need to do this for their inner modes.\n\n  var copyState = CodeMirror.copyState = function(mode, state) {\n    if (state === true) return state;\n    if (mode.copyState) return mode.copyState(state);\n    var nstate = {};\n    for (var n in state) {\n      var val = state[n];\n      if (val instanceof Array) val = val.concat([]);\n      nstate[n] = val;\n    }\n    return nstate;\n  };\n\n  var startState = CodeMirror.startState = function(mode, a1, a2) {\n    return mode.startState ? mode.startState(a1, a2) : true;\n  };\n\n  // Given a mode and a state (for that mode), find the inner mode and\n  // state at the position that the state refers to.\n  CodeMirror.innerMode = function(mode, state) {\n    while (mode.innerMode) {\n      var info = mode.innerMode(state);\n      if (!info || info.mode == mode) break;\n      state = info.state;\n      mode = info.mode;\n    }\n    return info || {mode: mode, state: state};\n  };\n\n  // STANDARD COMMANDS\n\n  // Commands are parameter-less actions that can be performed on an\n  // editor, mostly used for keybindings.\n  var commands = CodeMirror.commands = {\n    selectAll: function(cm) {cm.setSelection(Pos(cm.firstLine(), 0), Pos(cm.lastLine()), sel_dontScroll);},\n    singleSelection: function(cm) {\n      cm.setSelection(cm.getCursor("anchor"), cm.getCursor("head"), sel_dontScroll);\n    },\n    killLine: function(cm) {\n      deleteNearSelection(cm, function(range) {\n        if (range.empty()) {\n          var len = getLine(cm.doc, range.head.line).text.length;\n          if (range.head.ch == len && range.head.line < cm.lastLine())\n            return {from: range.head, to: Pos(range.head.line + 1, 0)};\n          else\n            return {from: range.head, to: Pos(range.head.line, len)};\n        } else {\n          return {from: range.from(), to: range.to()};\n        }\n      });\n    },\n    deleteLine: function(cm) {\n      deleteNearSelection(cm, function(range) {\n        return {from: Pos(range.from().line, 0),\n                to: clipPos(cm.doc, Pos(range.to().line + 1, 0))};\n      });\n    },\n    delLineLeft: function(cm) {\n      deleteNearSelection(cm, function(range) {\n        return {from: Pos(range.from().line, 0), to: range.from()};\n      });\n    },\n    delWrappedLineLeft: function(cm) {\n      deleteNearSelection(cm, function(range) {\n        var top = cm.charCoords(range.head, "div").top + 5;\n        var leftPos = cm.coordsChar({left: 0, top: top}, "div");\n        return {from: leftPos, to: range.from()};\n      });\n    },\n    delWrappedLineRight: function(cm) {\n      deleteNearSelection(cm, function(range) {\n        var top = cm.charCoords(range.head, "div").top + 5;\n        var rightPos = cm.coordsChar({left: cm.display.lineDiv.offsetWidth + 100, top: top}, "div");\n        return {from: range.from(), to: rightPos };\n      });\n    },\n    undo: function(cm) {cm.undo();},\n    redo: function(cm) {cm.redo();},\n    undoSelection: function(cm) {cm.undoSelection();},\n    redoSelection: function(cm) {cm.redoSelection();},\n    goDocStart: function(cm) {cm.extendSelection(Pos(cm.firstLine(), 0));},\n    goDocEnd: function(cm) {cm.extendSelection(Pos(cm.lastLine()));},\n    goLineStart: function(cm) {\n      cm.extendSelectionsBy(function(range) { return lineStart(cm, range.head.line); },\n                            {origin: "+move", bias: 1});\n    },\n    goLineStartSmart: function(cm) {\n      cm.extendSelectionsBy(function(range) {\n        return lineStartSmart(cm, range.head);\n      }, {origin: "+move", bias: 1});\n    },\n    goLineEnd: function(cm) {\n      cm.extendSelectionsBy(function(range) { return lineEnd(cm, range.head.line); },\n                            {origin: "+move", bias: -1});\n    },\n    goLineRight: function(cm) {\n      cm.extendSelectionsBy(function(range) {\n        var top = cm.charCoords(range.head, "div").top + 5;\n        return cm.coordsChar({left: cm.display.lineDiv.offsetWidth + 100, top: top}, "div");\n      }, sel_move);\n    },\n    goLineLeft: function(cm) {\n      cm.extendSelectionsBy(function(range) {\n        var top = cm.charCoords(range.head, "div").top + 5;\n        return cm.coordsChar({left: 0, top: top}, "div");\n      }, sel_move);\n    },\n    goLineLeftSmart: function(cm) {\n      cm.extendSelectionsBy(function(range) {\n        var top = cm.charCoords(range.head, "div").top + 5;\n        var pos = cm.coordsChar({left: 0, top: top}, "div");\n        if (pos.ch < cm.getLine(pos.line).search(/\\S/)) return lineStartSmart(cm, range.head);\n        return pos;\n      }, sel_move);\n    },\n    goLineUp: function(cm) {cm.moveV(-1, "line");},\n    goLineDown: function(cm) {cm.moveV(1, "line");},\n    goPageUp: function(cm) {cm.moveV(-1, "page");},\n    goPageDown: function(cm) {cm.moveV(1, "page");},\n    goCharLeft: function(cm) {cm.moveH(-1, "char");},\n    goCharRight: function(cm) {cm.moveH(1, "char");},\n    goColumnLeft: function(cm) {cm.moveH(-1, "column");},\n    goColumnRight: function(cm) {cm.moveH(1, "column");},\n    goWordLeft: function(cm) {cm.moveH(-1, "word");},\n    goGroupRight: function(cm) {cm.moveH(1, "group");},\n    goGroupLeft: function(cm) {cm.moveH(-1, "group");},\n    goWordRight: function(cm) {cm.moveH(1, "word");},\n    delCharBefore: function(cm) {cm.deleteH(-1, "char");},\n    delCharAfter: function(cm) {cm.deleteH(1, "char");},\n    delWordBefore: function(cm) {cm.deleteH(-1, "word");},\n    delWordAfter: function(cm) {cm.deleteH(1, "word");},\n    delGroupBefore: function(cm) {cm.deleteH(-1, "group");},\n    delGroupAfter: function(cm) {cm.deleteH(1, "group");},\n    indentAuto: function(cm) {cm.indentSelection("smart");},\n    indentMore: function(cm) {cm.indentSelection("add");},\n    indentLess: function(cm) {cm.indentSelection("subtract");},\n    insertTab: function(cm) {cm.replaceSelection("\\t");},\n    insertSoftTab: function(cm) {\n      var spaces = [], ranges = cm.listSelections(), tabSize = cm.options.tabSize;\n      for (var i = 0; i < ranges.length; i++) {\n        var pos = ranges[i].from();\n        var col = countColumn(cm.getLine(pos.line), pos.ch, tabSize);\n        spaces.push(new Array(tabSize - col % tabSize + 1).join(" "));\n      }\n      cm.replaceSelections(spaces);\n    },\n    defaultTab: function(cm) {\n      if (cm.somethingSelected()) cm.indentSelection("add");\n      else cm.execCommand("insertTab");\n    },\n    transposeChars: function(cm) {\n      runInOp(cm, function() {\n        var ranges = cm.listSelections(), newSel = [];\n        for (var i = 0; i < ranges.length; i++) {\n          var cur = ranges[i].head, line = getLine(cm.doc, cur.line).text;\n          if (line) {\n            if (cur.ch == line.length) cur = new Pos(cur.line, cur.ch - 1);\n            if (cur.ch > 0) {\n              cur = new Pos(cur.line, cur.ch + 1);\n              cm.replaceRange(line.charAt(cur.ch - 1) + line.charAt(cur.ch - 2),\n                              Pos(cur.line, cur.ch - 2), cur, "+transpose");\n            } else if (cur.line > cm.doc.first) {\n              var prev = getLine(cm.doc, cur.line - 1).text;\n              if (prev)\n                cm.replaceRange(line.charAt(0) + cm.doc.lineSeparator() +\n                                prev.charAt(prev.length - 1),\n                                Pos(cur.line - 1, prev.length - 1), Pos(cur.line, 1), "+transpose");\n            }\n          }\n          newSel.push(new Range(cur, cur));\n        }\n        cm.setSelections(newSel);\n      });\n    },\n    newlineAndIndent: function(cm) {\n      runInOp(cm, function() {\n        var len = cm.listSelections().length;\n        for (var i = 0; i < len; i++) {\n          var range = cm.listSelections()[i];\n          cm.replaceRange(cm.doc.lineSeparator(), range.anchor, range.head, "+input");\n          cm.indentLine(range.from().line + 1, null, true);\n          ensureCursorVisible(cm);\n        }\n      });\n    },\n    toggleOverwrite: function(cm) {cm.toggleOverwrite();}\n  };\n\n\n  // STANDARD KEYMAPS\n\n  var keyMap = CodeMirror.keyMap = {};\n\n  keyMap.basic = {\n    "Left": "goCharLeft", "Right": "goCharRight", "Up": "goLineUp", "Down": "goLineDown",\n    "End": "goLineEnd", "Home": "goLineStartSmart", "PageUp": "goPageUp", "PageDown": "goPageDown",\n    "Delete": "delCharAfter", "Backspace": "delCharBefore", "Shift-Backspace": "delCharBefore",\n    "Tab": "defaultTab", "Shift-Tab": "indentAuto",\n    "Enter": "newlineAndIndent", "Insert": "toggleOverwrite",\n    "Esc": "singleSelection"\n  };\n  // Note that the save and find-related commands aren\'t defined by\n  // default. User code or addons can define them. Unknown commands\n  // are simply ignored.\n  keyMap.pcDefault = {\n    "Ctrl-A": "selectAll", "Ctrl-D": "deleteLine", "Ctrl-Z": "undo", "Shift-Ctrl-Z": "redo", "Ctrl-Y": "redo",\n    "Ctrl-Home": "goDocStart", "Ctrl-End": "goDocEnd", "Ctrl-Up": "goLineUp", "Ctrl-Down": "goLineDown",\n    "Ctrl-Left": "goGroupLeft", "Ctrl-Right": "goGroupRight", "Alt-Left": "goLineStart", "Alt-Right": "goLineEnd",\n    "Ctrl-Backspace": "delGroupBefore", "Ctrl-Delete": "delGroupAfter", "Ctrl-S": "save", "Ctrl-F": "find",\n    "Ctrl-G": "findNext", "Shift-Ctrl-G": "findPrev", "Shift-Ctrl-F": "replace", "Shift-Ctrl-R": "replaceAll",\n    "Ctrl-[": "indentLess", "Ctrl-]": "indentMore",\n    "Ctrl-U": "undoSelection", "Shift-Ctrl-U": "redoSelection", "Alt-U": "redoSelection",\n    fallthrough: "basic"\n  };\n  // Very basic readline/emacs-style bindings, which are standard on Mac.\n  keyMap.emacsy = {\n    "Ctrl-F": "goCharRight", "Ctrl-B": "goCharLeft", "Ctrl-P": "goLineUp", "Ctrl-N": "goLineDown",\n    "Alt-F": "goWordRight", "Alt-B": "goWordLeft", "Ctrl-A": "goLineStart", "Ctrl-E": "goLineEnd",\n    "Ctrl-V": "goPageDown", "Shift-Ctrl-V": "goPageUp", "Ctrl-D": "delCharAfter", "Ctrl-H": "delCharBefore",\n    "Alt-D": "delWordAfter", "Alt-Backspace": "delWordBefore", "Ctrl-K": "killLine", "Ctrl-T": "transposeChars"\n  };\n  keyMap.macDefault = {\n    "Cmd-A": "selectAll", "Cmd-D": "deleteLine", "Cmd-Z": "undo", "Shift-Cmd-Z": "redo", "Cmd-Y": "redo",\n    "Cmd-Home": "goDocStart", "Cmd-Up": "goDocStart", "Cmd-End": "goDocEnd", "Cmd-Down": "goDocEnd", "Alt-Left": "goGroupLeft",\n    "Alt-Right": "goGroupRight", "Cmd-Left": "goLineLeft", "Cmd-Right": "goLineRight", "Alt-Backspace": "delGroupBefore",\n    "Ctrl-Alt-Backspace": "delGroupAfter", "Alt-Delete": "delGroupAfter", "Cmd-S": "save", "Cmd-F": "find",\n    "Cmd-G": "findNext", "Shift-Cmd-G": "findPrev", "Cmd-Alt-F": "replace", "Shift-Cmd-Alt-F": "replaceAll",\n    "Cmd-[": "indentLess", "Cmd-]": "indentMore", "Cmd-Backspace": "delWrappedLineLeft", "Cmd-Delete": "delWrappedLineRight",\n    "Cmd-U": "undoSelection", "Shift-Cmd-U": "redoSelection", "Ctrl-Up": "goDocStart", "Ctrl-Down": "goDocEnd",\n    fallthrough: ["basic", "emacsy"]\n  };\n  keyMap["default"] = mac ? keyMap.macDefault : keyMap.pcDefault;\n\n  // KEYMAP DISPATCH\n\n  function normalizeKeyName(name) {\n    var parts = name.split(/-(?!$)/), name = parts[parts.length - 1];\n    var alt, ctrl, shift, cmd;\n    for (var i = 0; i < parts.length - 1; i++) {\n      var mod = parts[i];\n      if (/^(cmd|meta|m)$/i.test(mod)) cmd = true;\n      else if (/^a(lt)?$/i.test(mod)) alt = true;\n      else if (/^(c|ctrl|control)$/i.test(mod)) ctrl = true;\n      else if (/^s(hift)$/i.test(mod)) shift = true;\n      else throw new Error("Unrecognized modifier name: " + mod);\n    }\n    if (alt) name = "Alt-" + name;\n    if (ctrl) name = "Ctrl-" + name;\n    if (cmd) name = "Cmd-" + name;\n    if (shift) name = "Shift-" + name;\n    return name;\n  }\n\n  // This is a kludge to keep keymaps mostly working as raw objects\n  // (backwards compatibility) while at the same time support features\n  // like normalization and multi-stroke key bindings. It compiles a\n  // new normalized keymap, and then updates the old object to reflect\n  // this.\n  CodeMirror.normalizeKeyMap = function(keymap) {\n    var copy = {};\n    for (var keyname in keymap) if (keymap.hasOwnProperty(keyname)) {\n      var value = keymap[keyname];\n      if (/^(name|fallthrough|(de|at)tach)$/.test(keyname)) continue;\n      if (value == "...") { delete keymap[keyname]; continue; }\n\n      var keys = map(keyname.split(" "), normalizeKeyName);\n      for (var i = 0; i < keys.length; i++) {\n        var val, name;\n        if (i == keys.length - 1) {\n          name = keys.join(" ");\n          val = value;\n        } else {\n          name = keys.slice(0, i + 1).join(" ");\n          val = "...";\n        }\n        var prev = copy[name];\n        if (!prev) copy[name] = val;\n        else if (prev != val) throw new Error("Inconsistent bindings for " + name);\n      }\n      delete keymap[keyname];\n    }\n    for (var prop in copy) keymap[prop] = copy[prop];\n    return keymap;\n  };\n\n  var lookupKey = CodeMirror.lookupKey = function(key, map, handle, context) {\n    map = getKeyMap(map);\n    var found = map.call ? map.call(key, context) : map[key];\n    if (found === false) return "nothing";\n    if (found === "...") return "multi";\n    if (found != null && handle(found)) return "handled";\n\n    if (map.fallthrough) {\n      if (Object.prototype.toString.call(map.fallthrough) != "[object Array]")\n        return lookupKey(key, map.fallthrough, handle, context);\n      for (var i = 0; i < map.fallthrough.length; i++) {\n        var result = lookupKey(key, map.fallthrough[i], handle, context);\n        if (result) return result;\n      }\n    }\n  };\n\n  // Modifier key presses don\'t count as \'real\' key presses for the\n  // purpose of keymap fallthrough.\n  var isModifierKey = CodeMirror.isModifierKey = function(value) {\n    var name = typeof value == "string" ? value : keyNames[value.keyCode];\n    return name == "Ctrl" || name == "Alt" || name == "Shift" || name == "Mod";\n  };\n\n  // Look up the name of a key as indicated by an event object.\n  var keyName = CodeMirror.keyName = function(event, noShift) {\n    if (presto && event.keyCode == 34 && event["char"]) return false;\n    var base = keyNames[event.keyCode], name = base;\n    if (name == null || event.altGraphKey) return false;\n    if (event.altKey && base != "Alt") name = "Alt-" + name;\n    if ((flipCtrlCmd ? event.metaKey : event.ctrlKey) && base != "Ctrl") name = "Ctrl-" + name;\n    if ((flipCtrlCmd ? event.ctrlKey : event.metaKey) && base != "Cmd") name = "Cmd-" + name;\n    if (!noShift && event.shiftKey && base != "Shift") name = "Shift-" + name;\n    return name;\n  };\n\n  function getKeyMap(val) {\n    return typeof val == "string" ? keyMap[val] : val;\n  }\n\n  // FROMTEXTAREA\n\n  CodeMirror.fromTextArea = function(textarea, options) {\n    options = options ? copyObj(options) : {};\n    options.value = textarea.value;\n    if (!options.tabindex && textarea.tabIndex)\n      options.tabindex = textarea.tabIndex;\n    if (!options.placeholder && textarea.placeholder)\n      options.placeholder = textarea.placeholder;\n    // Set autofocus to true if this textarea is focused, or if it has\n    // autofocus and no other element is focused.\n    if (options.autofocus == null) {\n      var hasFocus = activeElt();\n      options.autofocus = hasFocus == textarea ||\n        textarea.getAttribute("autofocus") != null && hasFocus == document.body;\n    }\n\n    function save() {textarea.value = cm.getValue();}\n    if (textarea.form) {\n      on(textarea.form, "submit", save);\n      // Deplorable hack to make the submit method do the right thing.\n      if (!options.leaveSubmitMethodAlone) {\n        var form = textarea.form, realSubmit = form.submit;\n        try {\n          var wrappedSubmit = form.submit = function() {\n            save();\n            form.submit = realSubmit;\n            form.submit();\n            form.submit = wrappedSubmit;\n          };\n        } catch(e) {}\n      }\n    }\n\n    options.finishInit = function(cm) {\n      cm.save = save;\n      cm.getTextArea = function() { return textarea; };\n      cm.toTextArea = function() {\n        cm.toTextArea = isNaN; // Prevent this from being ran twice\n        save();\n        textarea.parentNode.removeChild(cm.getWrapperElement());\n        textarea.style.display = "";\n        if (textarea.form) {\n          off(textarea.form, "submit", save);\n          if (typeof textarea.form.submit == "function")\n            textarea.form.submit = realSubmit;\n        }\n      };\n    };\n\n    textarea.style.display = "none";\n    var cm = CodeMirror(function(node) {\n      textarea.parentNode.insertBefore(node, textarea.nextSibling);\n    }, options);\n    return cm;\n  };\n\n  // STRING STREAM\n\n  // Fed to the mode parsers, provides helper functions to make\n  // parsers more succinct.\n\n  var StringStream = CodeMirror.StringStream = function(string, tabSize) {\n    this.pos = this.start = 0;\n    this.string = string;\n    this.tabSize = tabSize || 8;\n    this.lastColumnPos = this.lastColumnValue = 0;\n    this.lineStart = 0;\n  };\n\n  StringStream.prototype = {\n    eol: function() {return this.pos >= this.string.length;},\n    sol: function() {return this.pos == this.lineStart;},\n    peek: function() {return this.string.charAt(this.pos) || undefined;},\n    next: function() {\n      if (this.pos < this.string.length)\n        return this.string.charAt(this.pos++);\n    },\n    eat: function(match) {\n      var ch = this.string.charAt(this.pos);\n      if (typeof match == "string") var ok = ch == match;\n      else var ok = ch && (match.test ? match.test(ch) : match(ch));\n      if (ok) {++this.pos; return ch;}\n    },\n    eatWhile: function(match) {\n      var start = this.pos;\n      while (this.eat(match)){}\n      return this.pos > start;\n    },\n    eatSpace: function() {\n      var start = this.pos;\n      while (/[\\s\\u00a0]/.test(this.string.charAt(this.pos))) ++this.pos;\n      return this.pos > start;\n    },\n    skipToEnd: function() {this.pos = this.string.length;},\n    skipTo: function(ch) {\n      var found = this.string.indexOf(ch, this.pos);\n      if (found > -1) {this.pos = found; return true;}\n    },\n    backUp: function(n) {this.pos -= n;},\n    column: function() {\n      if (this.lastColumnPos < this.start) {\n        this.lastColumnValue = countColumn(this.string, this.start, this.tabSize, this.lastColumnPos, this.lastColumnValue);\n        this.lastColumnPos = this.start;\n      }\n      return this.lastColumnValue - (this.lineStart ? countColumn(this.string, this.lineStart, this.tabSize) : 0);\n    },\n    indentation: function() {\n      return countColumn(this.string, null, this.tabSize) -\n        (this.lineStart ? countColumn(this.string, this.lineStart, this.tabSize) : 0);\n    },\n    match: function(pattern, consume, caseInsensitive) {\n      if (typeof pattern == "string") {\n        var cased = function(str) {return caseInsensitive ? str.toLowerCase() : str;};\n        var substr = this.string.substr(this.pos, pattern.length);\n        if (cased(substr) == cased(pattern)) {\n          if (consume !== false) this.pos += pattern.length;\n          return true;\n        }\n      } else {\n        var match = this.string.slice(this.pos).match(pattern);\n        if (match && match.index > 0) return null;\n        if (match && consume !== false) this.pos += match[0].length;\n        return match;\n      }\n    },\n    current: function(){return this.string.slice(this.start, this.pos);},\n    hideFirstChars: function(n, inner) {\n      this.lineStart += n;\n      try { return inner(); }\n      finally { this.lineStart -= n; }\n    }\n  };\n\n  // TEXTMARKERS\n\n  // Created with markText and setBookmark methods. A TextMarker is a\n  // handle that can be used to clear or find a marked position in the\n  // document. Line objects hold arrays (markedSpans) containing\n  // {from, to, marker} object pointing to such marker objects, and\n  // indicating that such a marker is present on that line. Multiple\n  // lines may point to the same marker when it spans across lines.\n  // The spans will have null for their from/to properties when the\n  // marker continues beyond the start/end of the line. Markers have\n  // links back to the lines they currently touch.\n\n  var nextMarkerId = 0;\n\n  var TextMarker = CodeMirror.TextMarker = function(doc, type) {\n    this.lines = [];\n    this.type = type;\n    this.doc = doc;\n    this.id = ++nextMarkerId;\n  };\n  eventMixin(TextMarker);\n\n  // Clear the marker.\n  TextMarker.prototype.clear = function() {\n    if (this.explicitlyCleared) return;\n    var cm = this.doc.cm, withOp = cm && !cm.curOp;\n    if (withOp) startOperation(cm);\n    if (hasHandler(this, "clear")) {\n      var found = this.find();\n      if (found) signalLater(this, "clear", found.from, found.to);\n    }\n    var min = null, max = null;\n    for (var i = 0; i < this.lines.length; ++i) {\n      var line = this.lines[i];\n      var span = getMarkedSpanFor(line.markedSpans, this);\n      if (cm && !this.collapsed) regLineChange(cm, lineNo(line), "text");\n      else if (cm) {\n        if (span.to != null) max = lineNo(line);\n        if (span.from != null) min = lineNo(line);\n      }\n      line.markedSpans = removeMarkedSpan(line.markedSpans, span);\n      if (span.from == null && this.collapsed && !lineIsHidden(this.doc, line) && cm)\n        updateLineHeight(line, textHeight(cm.display));\n    }\n    if (cm && this.collapsed && !cm.options.lineWrapping) for (var i = 0; i < this.lines.length; ++i) {\n      var visual = visualLine(this.lines[i]), len = lineLength(visual);\n      if (len > cm.display.maxLineLength) {\n        cm.display.maxLine = visual;\n        cm.display.maxLineLength = len;\n        cm.display.maxLineChanged = true;\n      }\n    }\n\n    if (min != null && cm && this.collapsed) regChange(cm, min, max + 1);\n    this.lines.length = 0;\n    this.explicitlyCleared = true;\n    if (this.atomic && this.doc.cantEdit) {\n      this.doc.cantEdit = false;\n      if (cm) reCheckSelection(cm.doc);\n    }\n    if (cm) signalLater(cm, "markerCleared", cm, this);\n    if (withOp) endOperation(cm);\n    if (this.parent) this.parent.clear();\n  };\n\n  // Find the position of the marker in the document. Returns a {from,\n  // to} object by default. Side can be passed to get a specific side\n  // -- 0 (both), -1 (left), or 1 (right). When lineObj is true, the\n  // Pos objects returned contain a line object, rather than a line\n  // number (used to prevent looking up the same line twice).\n  TextMarker.prototype.find = function(side, lineObj) {\n    if (side == null && this.type == "bookmark") side = 1;\n    var from, to;\n    for (var i = 0; i < this.lines.length; ++i) {\n      var line = this.lines[i];\n      var span = getMarkedSpanFor(line.markedSpans, this);\n      if (span.from != null) {\n        from = Pos(lineObj ? line : lineNo(line), span.from);\n        if (side == -1) return from;\n      }\n      if (span.to != null) {\n        to = Pos(lineObj ? line : lineNo(line), span.to);\n        if (side == 1) return to;\n      }\n    }\n    return from && {from: from, to: to};\n  };\n\n  // Signals that the marker\'s widget changed, and surrounding layout\n  // should be recomputed.\n  TextMarker.prototype.changed = function() {\n    var pos = this.find(-1, true), widget = this, cm = this.doc.cm;\n    if (!pos || !cm) return;\n    runInOp(cm, function() {\n      var line = pos.line, lineN = lineNo(pos.line);\n      var view = findViewForLine(cm, lineN);\n      if (view) {\n        clearLineMeasurementCacheFor(view);\n        cm.curOp.selectionChanged = cm.curOp.forceUpdate = true;\n      }\n      cm.curOp.updateMaxLine = true;\n      if (!lineIsHidden(widget.doc, line) && widget.height != null) {\n        var oldHeight = widget.height;\n        widget.height = null;\n        var dHeight = widgetHeight(widget) - oldHeight;\n        if (dHeight)\n          updateLineHeight(line, line.height + dHeight);\n      }\n    });\n  };\n\n  TextMarker.prototype.attachLine = function(line) {\n    if (!this.lines.length && this.doc.cm) {\n      var op = this.doc.cm.curOp;\n      if (!op.maybeHiddenMarkers || indexOf(op.maybeHiddenMarkers, this) == -1)\n        (op.maybeUnhiddenMarkers || (op.maybeUnhiddenMarkers = [])).push(this);\n    }\n    this.lines.push(line);\n  };\n  TextMarker.prototype.detachLine = function(line) {\n    this.lines.splice(indexOf(this.lines, line), 1);\n    if (!this.lines.length && this.doc.cm) {\n      var op = this.doc.cm.curOp;\n      (op.maybeHiddenMarkers || (op.maybeHiddenMarkers = [])).push(this);\n    }\n  };\n\n  // Collapsed markers have unique ids, in order to be able to order\n  // them, which is needed for uniquely determining an outer marker\n  // when they overlap (they may nest, but not partially overlap).\n  var nextMarkerId = 0;\n\n  // Create a marker, wire it up to the right lines, and\n  function markText(doc, from, to, options, type) {\n    // Shared markers (across linked documents) are handled separately\n    // (markTextShared will call out to this again, once per\n    // document).\n    if (options && options.shared) return markTextShared(doc, from, to, options, type);\n    // Ensure we are in an operation.\n    if (doc.cm && !doc.cm.curOp) return operation(doc.cm, markText)(doc, from, to, options, type);\n\n    var marker = new TextMarker(doc, type), diff = cmp(from, to);\n    if (options) copyObj(options, marker, false);\n    // Don\'t connect empty markers unless clearWhenEmpty is false\n    if (diff > 0 || diff == 0 && marker.clearWhenEmpty !== false)\n      return marker;\n    if (marker.replacedWith) {\n      // Showing up as a widget implies collapsed (widget replaces text)\n      marker.collapsed = true;\n      marker.widgetNode = elt("span", [marker.replacedWith], "CodeMirror-widget");\n      if (!options.handleMouseEvents) marker.widgetNode.setAttribute("cm-ignore-events", "true");\n      if (options.insertLeft) marker.widgetNode.insertLeft = true;\n    }\n    if (marker.collapsed) {\n      if (conflictingCollapsedRange(doc, from.line, from, to, marker) ||\n          from.line != to.line && conflictingCollapsedRange(doc, to.line, from, to, marker))\n        throw new Error("Inserting collapsed marker partially overlapping an existing one");\n      sawCollapsedSpans = true;\n    }\n\n    if (marker.addToHistory)\n      addChangeToHistory(doc, {from: from, to: to, origin: "markText"}, doc.sel, NaN);\n\n    var curLine = from.line, cm = doc.cm, updateMaxLine;\n    doc.iter(curLine, to.line + 1, function(line) {\n      if (cm && marker.collapsed && !cm.options.lineWrapping && visualLine(line) == cm.display.maxLine)\n        updateMaxLine = true;\n      if (marker.collapsed && curLine != from.line) updateLineHeight(line, 0);\n      addMarkedSpan(line, new MarkedSpan(marker,\n                                         curLine == from.line ? from.ch : null,\n                                         curLine == to.line ? to.ch : null));\n      ++curLine;\n    });\n    // lineIsHidden depends on the presence of the spans, so needs a second pass\n    if (marker.collapsed) doc.iter(from.line, to.line + 1, function(line) {\n      if (lineIsHidden(doc, line)) updateLineHeight(line, 0);\n    });\n\n    if (marker.clearOnEnter) on(marker, "beforeCursorEnter", function() { marker.clear(); });\n\n    if (marker.readOnly) {\n      sawReadOnlySpans = true;\n      if (doc.history.done.length || doc.history.undone.length)\n        doc.clearHistory();\n    }\n    if (marker.collapsed) {\n      marker.id = ++nextMarkerId;\n      marker.atomic = true;\n    }\n    if (cm) {\n      // Sync editor state\n      if (updateMaxLine) cm.curOp.updateMaxLine = true;\n      if (marker.collapsed)\n        regChange(cm, from.line, to.line + 1);\n      else if (marker.className || marker.title || marker.startStyle || marker.endStyle || marker.css)\n        for (var i = from.line; i <= to.line; i++) regLineChange(cm, i, "text");\n      if (marker.atomic) reCheckSelection(cm.doc);\n      signalLater(cm, "markerAdded", cm, marker);\n    }\n    return marker;\n  }\n\n  // SHARED TEXTMARKERS\n\n  // A shared marker spans multiple linked documents. It is\n  // implemented as a meta-marker-object controlling multiple normal\n  // markers.\n  var SharedTextMarker = CodeMirror.SharedTextMarker = function(markers, primary) {\n    this.markers = markers;\n    this.primary = primary;\n    for (var i = 0; i < markers.length; ++i)\n      markers[i].parent = this;\n  };\n  eventMixin(SharedTextMarker);\n\n  SharedTextMarker.prototype.clear = function() {\n    if (this.explicitlyCleared) return;\n    this.explicitlyCleared = true;\n    for (var i = 0; i < this.markers.length; ++i)\n      this.markers[i].clear();\n    signalLater(this, "clear");\n  };\n  SharedTextMarker.prototype.find = function(side, lineObj) {\n    return this.primary.find(side, lineObj);\n  };\n\n  function markTextShared(doc, from, to, options, type) {\n    options = copyObj(options);\n    options.shared = false;\n    var markers = [markText(doc, from, to, options, type)], primary = markers[0];\n    var widget = options.widgetNode;\n    linkedDocs(doc, function(doc) {\n      if (widget) options.widgetNode = widget.cloneNode(true);\n      markers.push(markText(doc, clipPos(doc, from), clipPos(doc, to), options, type));\n      for (var i = 0; i < doc.linked.length; ++i)\n        if (doc.linked[i].isParent) return;\n      primary = lst(markers);\n    });\n    return new SharedTextMarker(markers, primary);\n  }\n\n  function findSharedMarkers(doc) {\n    return doc.findMarks(Pos(doc.first, 0), doc.clipPos(Pos(doc.lastLine())),\n                         function(m) { return m.parent; });\n  }\n\n  function copySharedMarkers(doc, markers) {\n    for (var i = 0; i < markers.length; i++) {\n      var marker = markers[i], pos = marker.find();\n      var mFrom = doc.clipPos(pos.from), mTo = doc.clipPos(pos.to);\n      if (cmp(mFrom, mTo)) {\n        var subMark = markText(doc, mFrom, mTo, marker.primary, marker.primary.type);\n        marker.markers.push(subMark);\n        subMark.parent = marker;\n      }\n    }\n  }\n\n  function detachSharedMarkers(markers) {\n    for (var i = 0; i < markers.length; i++) {\n      var marker = markers[i], linked = [marker.primary.doc];;\n      linkedDocs(marker.primary.doc, function(d) { linked.push(d); });\n      for (var j = 0; j < marker.markers.length; j++) {\n        var subMarker = marker.markers[j];\n        if (indexOf(linked, subMarker.doc) == -1) {\n          subMarker.parent = null;\n          marker.markers.splice(j--, 1);\n        }\n      }\n    }\n  }\n\n  // TEXTMARKER SPANS\n\n  function MarkedSpan(marker, from, to) {\n    this.marker = marker;\n    this.from = from; this.to = to;\n  }\n\n  // Search an array of spans for a span matching the given marker.\n  function getMarkedSpanFor(spans, marker) {\n    if (spans) for (var i = 0; i < spans.length; ++i) {\n      var span = spans[i];\n      if (span.marker == marker) return span;\n    }\n  }\n  // Remove a span from an array, returning undefined if no spans are\n  // left (we don\'t store arrays for lines without spans).\n  function removeMarkedSpan(spans, span) {\n    for (var r, i = 0; i < spans.length; ++i)\n      if (spans[i] != span) (r || (r = [])).push(spans[i]);\n    return r;\n  }\n  // Add a span to a line.\n  function addMarkedSpan(line, span) {\n    line.markedSpans = line.markedSpans ? line.markedSpans.concat([span]) : [span];\n    span.marker.attachLine(line);\n  }\n\n  // Used for the algorithm that adjusts markers for a change in the\n  // document. These functions cut an array of spans at a given\n  // character position, returning an array of remaining chunks (or\n  // undefined if nothing remains).\n  function markedSpansBefore(old, startCh, isInsert) {\n    if (old) for (var i = 0, nw; i < old.length; ++i) {\n      var span = old[i], marker = span.marker;\n      var startsBefore = span.from == null || (marker.inclusiveLeft ? span.from <= startCh : span.from < startCh);\n      if (startsBefore || span.from == startCh && marker.type == "bookmark" && (!isInsert || !span.marker.insertLeft)) {\n        var endsAfter = span.to == null || (marker.inclusiveRight ? span.to >= startCh : span.to > startCh);\n        (nw || (nw = [])).push(new MarkedSpan(marker, span.from, endsAfter ? null : span.to));\n      }\n    }\n    return nw;\n  }\n  function markedSpansAfter(old, endCh, isInsert) {\n    if (old) for (var i = 0, nw; i < old.length; ++i) {\n      var span = old[i], marker = span.marker;\n      var endsAfter = span.to == null || (marker.inclusiveRight ? span.to >= endCh : span.to > endCh);\n      if (endsAfter || span.from == endCh && marker.type == "bookmark" && (!isInsert || span.marker.insertLeft)) {\n        var startsBefore = span.from == null || (marker.inclusiveLeft ? span.from <= endCh : span.from < endCh);\n        (nw || (nw = [])).push(new MarkedSpan(marker, startsBefore ? null : span.from - endCh,\n                                              span.to == null ? null : span.to - endCh));\n      }\n    }\n    return nw;\n  }\n\n  // Given a change object, compute the new set of marker spans that\n  // cover the line in which the change took place. Removes spans\n  // entirely within the change, reconnects spans belonging to the\n  // same marker that appear on both sides of the change, and cuts off\n  // spans partially within the change. Returns an array of span\n  // arrays with one element for each line in (after) the change.\n  function stretchSpansOverChange(doc, change) {\n    if (change.full) return null;\n    var oldFirst = isLine(doc, change.from.line) && getLine(doc, change.from.line).markedSpans;\n    var oldLast = isLine(doc, change.to.line) && getLine(doc, change.to.line).markedSpans;\n    if (!oldFirst && !oldLast) return null;\n\n    var startCh = change.from.ch, endCh = change.to.ch, isInsert = cmp(change.from, change.to) == 0;\n    // Get the spans that \'stick out\' on both sides\n    var first = markedSpansBefore(oldFirst, startCh, isInsert);\n    var last = markedSpansAfter(oldLast, endCh, isInsert);\n\n    // Next, merge those two ends\n    var sameLine = change.text.length == 1, offset = lst(change.text).length + (sameLine ? startCh : 0);\n    if (first) {\n      // Fix up .to properties of first\n      for (var i = 0; i < first.length; ++i) {\n        var span = first[i];\n        if (span.to == null) {\n          var found = getMarkedSpanFor(last, span.marker);\n          if (!found) span.to = startCh;\n          else if (sameLine) span.to = found.to == null ? null : found.to + offset;\n        }\n      }\n    }\n    if (last) {\n      // Fix up .from in last (or move them into first in case of sameLine)\n      for (var i = 0; i < last.length; ++i) {\n        var span = last[i];\n        if (span.to != null) span.to += offset;\n        if (span.from == null) {\n          var found = getMarkedSpanFor(first, span.marker);\n          if (!found) {\n            span.from = offset;\n            if (sameLine) (first || (first = [])).push(span);\n          }\n        } else {\n          span.from += offset;\n          if (sameLine) (first || (first = [])).push(span);\n        }\n      }\n    }\n    // Make sure we didn\'t create any zero-length spans\n    if (first) first = clearEmptySpans(first);\n    if (last && last != first) last = clearEmptySpans(last);\n\n    var newMarkers = [first];\n    if (!sameLine) {\n      // Fill gap with whole-line-spans\n      var gap = change.text.length - 2, gapMarkers;\n      if (gap > 0 && first)\n        for (var i = 0; i < first.length; ++i)\n          if (first[i].to == null)\n            (gapMarkers || (gapMarkers = [])).push(new MarkedSpan(first[i].marker, null, null));\n      for (var i = 0; i < gap; ++i)\n        newMarkers.push(gapMarkers);\n      newMarkers.push(last);\n    }\n    return newMarkers;\n  }\n\n  // Remove spans that are empty and don\'t have a clearWhenEmpty\n  // option of false.\n  function clearEmptySpans(spans) {\n    for (var i = 0; i < spans.length; ++i) {\n      var span = spans[i];\n      if (span.from != null && span.from == span.to && span.marker.clearWhenEmpty !== false)\n        spans.splice(i--, 1);\n    }\n    if (!spans.length) return null;\n    return spans;\n  }\n\n  // Used for un/re-doing changes from the history. Combines the\n  // result of computing the existing spans with the set of spans that\n  // existed in the history (so that deleting around a span and then\n  // undoing brings back the span).\n  function mergeOldSpans(doc, change) {\n    var old = getOldSpans(doc, change);\n    var stretched = stretchSpansOverChange(doc, change);\n    if (!old) return stretched;\n    if (!stretched) return old;\n\n    for (var i = 0; i < old.length; ++i) {\n      var oldCur = old[i], stretchCur = stretched[i];\n      if (oldCur && stretchCur) {\n        spans: for (var j = 0; j < stretchCur.length; ++j) {\n          var span = stretchCur[j];\n          for (var k = 0; k < oldCur.length; ++k)\n            if (oldCur[k].marker == span.marker) continue spans;\n          oldCur.push(span);\n        }\n      } else if (stretchCur) {\n        old[i] = stretchCur;\n      }\n    }\n    return old;\n  }\n\n  // Used to \'clip\' out readOnly ranges when making a change.\n  function removeReadOnlyRanges(doc, from, to) {\n    var markers = null;\n    doc.iter(from.line, to.line + 1, function(line) {\n      if (line.markedSpans) for (var i = 0; i < line.markedSpans.length; ++i) {\n        var mark = line.markedSpans[i].marker;\n        if (mark.readOnly && (!markers || indexOf(markers, mark) == -1))\n          (markers || (markers = [])).push(mark);\n      }\n    });\n    if (!markers) return null;\n    var parts = [{from: from, to: to}];\n    for (var i = 0; i < markers.length; ++i) {\n      var mk = markers[i], m = mk.find(0);\n      for (var j = 0; j < parts.length; ++j) {\n        var p = parts[j];\n        if (cmp(p.to, m.from) < 0 || cmp(p.from, m.to) > 0) continue;\n        var newParts = [j, 1], dfrom = cmp(p.from, m.from), dto = cmp(p.to, m.to);\n        if (dfrom < 0 || !mk.inclusiveLeft && !dfrom)\n          newParts.push({from: p.from, to: m.from});\n        if (dto > 0 || !mk.inclusiveRight && !dto)\n          newParts.push({from: m.to, to: p.to});\n        parts.splice.apply(parts, newParts);\n        j += newParts.length - 1;\n      }\n    }\n    return parts;\n  }\n\n  // Connect or disconnect spans from a line.\n  function detachMarkedSpans(line) {\n    var spans = line.markedSpans;\n    if (!spans) return;\n    for (var i = 0; i < spans.length; ++i)\n      spans[i].marker.detachLine(line);\n    line.markedSpans = null;\n  }\n  function attachMarkedSpans(line, spans) {\n    if (!spans) return;\n    for (var i = 0; i < spans.length; ++i)\n      spans[i].marker.attachLine(line);\n    line.markedSpans = spans;\n  }\n\n  // Helpers used when computing which overlapping collapsed span\n  // counts as the larger one.\n  function extraLeft(marker) { return marker.inclusiveLeft ? -1 : 0; }\n  function extraRight(marker) { return marker.inclusiveRight ? 1 : 0; }\n\n  // Returns a number indicating which of two overlapping collapsed\n  // spans is larger (and thus includes the other). Falls back to\n  // comparing ids when the spans cover exactly the same range.\n  function compareCollapsedMarkers(a, b) {\n    var lenDiff = a.lines.length - b.lines.length;\n    if (lenDiff != 0) return lenDiff;\n    var aPos = a.find(), bPos = b.find();\n    var fromCmp = cmp(aPos.from, bPos.from) || extraLeft(a) - extraLeft(b);\n    if (fromCmp) return -fromCmp;\n    var toCmp = cmp(aPos.to, bPos.to) || extraRight(a) - extraRight(b);\n    if (toCmp) return toCmp;\n    return b.id - a.id;\n  }\n\n  // Find out whether a line ends or starts in a collapsed span. If\n  // so, return the marker for that span.\n  function collapsedSpanAtSide(line, start) {\n    var sps = sawCollapsedSpans && line.markedSpans, found;\n    if (sps) for (var sp, i = 0; i < sps.length; ++i) {\n      sp = sps[i];\n      if (sp.marker.collapsed && (start ? sp.from : sp.to) == null &&\n          (!found || compareCollapsedMarkers(found, sp.marker) < 0))\n        found = sp.marker;\n    }\n    return found;\n  }\n  function collapsedSpanAtStart(line) { return collapsedSpanAtSide(line, true); }\n  function collapsedSpanAtEnd(line) { return collapsedSpanAtSide(line, false); }\n\n  // Test whether there exists a collapsed span that partially\n  // overlaps (covers the start or end, but not both) of a new span.\n  // Such overlap is not allowed.\n  function conflictingCollapsedRange(doc, lineNo, from, to, marker) {\n    var line = getLine(doc, lineNo);\n    var sps = sawCollapsedSpans && line.markedSpans;\n    if (sps) for (var i = 0; i < sps.length; ++i) {\n      var sp = sps[i];\n      if (!sp.marker.collapsed) continue;\n      var found = sp.marker.find(0);\n      var fromCmp = cmp(found.from, from) || extraLeft(sp.marker) - extraLeft(marker);\n      var toCmp = cmp(found.to, to) || extraRight(sp.marker) - extraRight(marker);\n      if (fromCmp >= 0 && toCmp <= 0 || fromCmp <= 0 && toCmp >= 0) continue;\n      if (fromCmp <= 0 && (cmp(found.to, from) > 0 || (sp.marker.inclusiveRight && marker.inclusiveLeft)) ||\n          fromCmp >= 0 && (cmp(found.from, to) < 0 || (sp.marker.inclusiveLeft && marker.inclusiveRight)))\n        return true;\n    }\n  }\n\n  // A visual line is a line as drawn on the screen. Folding, for\n  // example, can cause multiple logical lines to appear on the same\n  // visual line. This finds the start of the visual line that the\n  // given line is part of (usually that is the line itself).\n  function visualLine(line) {\n    var merged;\n    while (merged = collapsedSpanAtStart(line))\n      line = merged.find(-1, true).line;\n    return line;\n  }\n\n  // Returns an array of logical lines that continue the visual line\n  // started by the argument, or undefined if there are no such lines.\n  function visualLineContinued(line) {\n    var merged, lines;\n    while (merged = collapsedSpanAtEnd(line)) {\n      line = merged.find(1, true).line;\n      (lines || (lines = [])).push(line);\n    }\n    return lines;\n  }\n\n  // Get the line number of the start of the visual line that the\n  // given line number is part of.\n  function visualLineNo(doc, lineN) {\n    var line = getLine(doc, lineN), vis = visualLine(line);\n    if (line == vis) return lineN;\n    return lineNo(vis);\n  }\n  // Get the line number of the start of the next visual line after\n  // the given line.\n  function visualLineEndNo(doc, lineN) {\n    if (lineN > doc.lastLine()) return lineN;\n    var line = getLine(doc, lineN), merged;\n    if (!lineIsHidden(doc, line)) return lineN;\n    while (merged = collapsedSpanAtEnd(line))\n      line = merged.find(1, true).line;\n    return lineNo(line) + 1;\n  }\n\n  // Compute whether a line is hidden. Lines count as hidden when they\n  // are part of a visual line that starts with another line, or when\n  // they are entirely covered by collapsed, non-widget span.\n  function lineIsHidden(doc, line) {\n    var sps = sawCollapsedSpans && line.markedSpans;\n    if (sps) for (var sp, i = 0; i < sps.length; ++i) {\n      sp = sps[i];\n      if (!sp.marker.collapsed) continue;\n      if (sp.from == null) return true;\n      if (sp.marker.widgetNode) continue;\n      if (sp.from == 0 && sp.marker.inclusiveLeft && lineIsHiddenInner(doc, line, sp))\n        return true;\n    }\n  }\n  function lineIsHiddenInner(doc, line, span) {\n    if (span.to == null) {\n      var end = span.marker.find(1, true);\n      return lineIsHiddenInner(doc, end.line, getMarkedSpanFor(end.line.markedSpans, span.marker));\n    }\n    if (span.marker.inclusiveRight && span.to == line.text.length)\n      return true;\n    for (var sp, i = 0; i < line.markedSpans.length; ++i) {\n      sp = line.markedSpans[i];\n      if (sp.marker.collapsed && !sp.marker.widgetNode && sp.from == span.to &&\n          (sp.to == null || sp.to != span.from) &&\n          (sp.marker.inclusiveLeft || span.marker.inclusiveRight) &&\n          lineIsHiddenInner(doc, line, sp)) return true;\n    }\n  }\n\n  // LINE WIDGETS\n\n  // Line widgets are block elements displayed above or below a line.\n\n  var LineWidget = CodeMirror.LineWidget = function(doc, node, options) {\n    if (options) for (var opt in options) if (options.hasOwnProperty(opt))\n      this[opt] = options[opt];\n    this.doc = doc;\n    this.node = node;\n  };\n  eventMixin(LineWidget);\n\n  function adjustScrollWhenAboveVisible(cm, line, diff) {\n    if (heightAtLine(line) < ((cm.curOp && cm.curOp.scrollTop) || cm.doc.scrollTop))\n      addToScrollPos(cm, null, diff);\n  }\n\n  LineWidget.prototype.clear = function() {\n    var cm = this.doc.cm, ws = this.line.widgets, line = this.line, no = lineNo(line);\n    if (no == null || !ws) return;\n    for (var i = 0; i < ws.length; ++i) if (ws[i] == this) ws.splice(i--, 1);\n    if (!ws.length) line.widgets = null;\n    var height = widgetHeight(this);\n    updateLineHeight(line, Math.max(0, line.height - height));\n    if (cm) runInOp(cm, function() {\n      adjustScrollWhenAboveVisible(cm, line, -height);\n      regLineChange(cm, no, "widget");\n    });\n  };\n  LineWidget.prototype.changed = function() {\n    var oldH = this.height, cm = this.doc.cm, line = this.line;\n    this.height = null;\n    var diff = widgetHeight(this) - oldH;\n    if (!diff) return;\n    updateLineHeight(line, line.height + diff);\n    if (cm) runInOp(cm, function() {\n      cm.curOp.forceUpdate = true;\n      adjustScrollWhenAboveVisible(cm, line, diff);\n    });\n  };\n\n  function widgetHeight(widget) {\n    if (widget.height != null) return widget.height;\n    var cm = widget.doc.cm;\n    if (!cm) return 0;\n    if (!contains(document.body, widget.node)) {\n      var parentStyle = "position: relative;";\n      if (widget.coverGutter)\n        parentStyle += "margin-left: -" + cm.display.gutters.offsetWidth + "px;";\n      if (widget.noHScroll)\n        parentStyle += "width: " + cm.display.wrapper.clientWidth + "px;";\n      removeChildrenAndAdd(cm.display.measure, elt("div", [widget.node], null, parentStyle));\n    }\n    return widget.height = widget.node.offsetHeight;\n  }\n\n  function addLineWidget(doc, handle, node, options) {\n    var widget = new LineWidget(doc, node, options);\n    var cm = doc.cm;\n    if (cm && widget.noHScroll) cm.display.alignWidgets = true;\n    changeLine(doc, handle, "widget", function(line) {\n      var widgets = line.widgets || (line.widgets = []);\n      if (widget.insertAt == null) widgets.push(widget);\n      else widgets.splice(Math.min(widgets.length - 1, Math.max(0, widget.insertAt)), 0, widget);\n      widget.line = line;\n      if (cm && !lineIsHidden(doc, line)) {\n        var aboveVisible = heightAtLine(line) < doc.scrollTop;\n        updateLineHeight(line, line.height + widgetHeight(widget));\n        if (aboveVisible) addToScrollPos(cm, null, widget.height);\n        cm.curOp.forceUpdate = true;\n      }\n      return true;\n    });\n    return widget;\n  }\n\n  // LINE DATA STRUCTURE\n\n  // Line objects. These hold state related to a line, including\n  // highlighting info (the styles array).\n  var Line = CodeMirror.Line = function(text, markedSpans, estimateHeight) {\n    this.text = text;\n    attachMarkedSpans(this, markedSpans);\n    this.height = estimateHeight ? estimateHeight(this) : 1;\n  };\n  eventMixin(Line);\n  Line.prototype.lineNo = function() { return lineNo(this); };\n\n  // Change the content (text, markers) of a line. Automatically\n  // invalidates cached information and tries to re-estimate the\n  // line\'s height.\n  function updateLine(line, text, markedSpans, estimateHeight) {\n    line.text = text;\n    if (line.stateAfter) line.stateAfter = null;\n    if (line.styles) line.styles = null;\n    if (line.order != null) line.order = null;\n    detachMarkedSpans(line);\n    attachMarkedSpans(line, markedSpans);\n    var estHeight = estimateHeight ? estimateHeight(line) : 1;\n    if (estHeight != line.height) updateLineHeight(line, estHeight);\n  }\n\n  // Detach a line from the document tree and its markers.\n  function cleanUpLine(line) {\n    line.parent = null;\n    detachMarkedSpans(line);\n  }\n\n  function extractLineClasses(type, output) {\n    if (type) for (;;) {\n      var lineClass = type.match(/(?:^|\\s+)line-(background-)?(\\S+)/);\n      if (!lineClass) break;\n      type = type.slice(0, lineClass.index) + type.slice(lineClass.index + lineClass[0].length);\n      var prop = lineClass[1] ? "bgClass" : "textClass";\n      if (output[prop] == null)\n        output[prop] = lineClass[2];\n      else if (!(new RegExp("(?:^|\\s)" + lineClass[2] + "(?:$|\\s)")).test(output[prop]))\n        output[prop] += " " + lineClass[2];\n    }\n    return type;\n  }\n\n  function callBlankLine(mode, state) {\n    if (mode.blankLine) return mode.blankLine(state);\n    if (!mode.innerMode) return;\n    var inner = CodeMirror.innerMode(mode, state);\n    if (inner.mode.blankLine) return inner.mode.blankLine(inner.state);\n  }\n\n  function readToken(mode, stream, state, inner) {\n    for (var i = 0; i < 10; i++) {\n      if (inner) inner[0] = CodeMirror.innerMode(mode, state).mode;\n      var style = mode.token(stream, state);\n      if (stream.pos > stream.start) return style;\n    }\n    throw new Error("Mode " + mode.name + " failed to advance stream.");\n  }\n\n  // Utility for getTokenAt and getLineTokens\n  function takeToken(cm, pos, precise, asArray) {\n    function getObj(copy) {\n      return {start: stream.start, end: stream.pos,\n              string: stream.current(),\n              type: style || null,\n              state: copy ? copyState(doc.mode, state) : state};\n    }\n\n    var doc = cm.doc, mode = doc.mode, style;\n    pos = clipPos(doc, pos);\n    var line = getLine(doc, pos.line), state = getStateBefore(cm, pos.line, precise);\n    var stream = new StringStream(line.text, cm.options.tabSize), tokens;\n    if (asArray) tokens = [];\n    while ((asArray || stream.pos < pos.ch) && !stream.eol()) {\n      stream.start = stream.pos;\n      style = readToken(mode, stream, state);\n      if (asArray) tokens.push(getObj(true));\n    }\n    return asArray ? tokens : getObj();\n  }\n\n  // Run the given mode\'s parser over a line, calling f for each token.\n  function runMode(cm, text, mode, state, f, lineClasses, forceToEnd) {\n    var flattenSpans = mode.flattenSpans;\n    if (flattenSpans == null) flattenSpans = cm.options.flattenSpans;\n    var curStart = 0, curStyle = null;\n    var stream = new StringStream(text, cm.options.tabSize), style;\n    var inner = cm.options.addModeClass && [null];\n    if (text == "") extractLineClasses(callBlankLine(mode, state), lineClasses);\n    while (!stream.eol()) {\n      if (stream.pos > cm.options.maxHighlightLength) {\n        flattenSpans = false;\n        if (forceToEnd) processLine(cm, text, state, stream.pos);\n        stream.pos = text.length;\n        style = null;\n      } else {\n        style = extractLineClasses(readToken(mode, stream, state, inner), lineClasses);\n      }\n      if (inner) {\n        var mName = inner[0].name;\n        if (mName) style = "m-" + (style ? mName + " " + style : mName);\n      }\n      if (!flattenSpans || curStyle != style) {\n        while (curStart < stream.start) {\n          curStart = Math.min(stream.start, curStart + 50000);\n          f(curStart, curStyle);\n        }\n        curStyle = style;\n      }\n      stream.start = stream.pos;\n    }\n    while (curStart < stream.pos) {\n      // Webkit seems to refuse to render text nodes longer than 57444 characters\n      var pos = Math.min(stream.pos, curStart + 50000);\n      f(pos, curStyle);\n      curStart = pos;\n    }\n  }\n\n  // Compute a style array (an array starting with a mode generation\n  // -- for invalidation -- followed by pairs of end positions and\n  // style strings), which is used to highlight the tokens on the\n  // line.\n  function highlightLine(cm, line, state, forceToEnd) {\n    // A styles array always starts with a number identifying the\n    // mode/overlays that it is based on (for easy invalidation).\n    var st = [cm.state.modeGen], lineClasses = {};\n    // Compute the base array of styles\n    runMode(cm, line.text, cm.doc.mode, state, function(end, style) {\n      st.push(end, style);\n    }, lineClasses, forceToEnd);\n\n    // Run overlays, adjust style array.\n    for (var o = 0; o < cm.state.overlays.length; ++o) {\n      var overlay = cm.state.overlays[o], i = 1, at = 0;\n      runMode(cm, line.text, overlay.mode, true, function(end, style) {\n        var start = i;\n        // Ensure there\'s a token end at the current position, and that i points at it\n        while (at < end) {\n          var i_end = st[i];\n          if (i_end > end)\n            st.splice(i, 1, end, st[i+1], i_end);\n          i += 2;\n          at = Math.min(end, i_end);\n        }\n        if (!style) return;\n        if (overlay.opaque) {\n          st.splice(start, i - start, end, "cm-overlay " + style);\n          i = start + 2;\n        } else {\n          for (; start < i; start += 2) {\n            var cur = st[start+1];\n            st[start+1] = (cur ? cur + " " : "") + "cm-overlay " + style;\n          }\n        }\n      }, lineClasses);\n    }\n\n    return {styles: st, classes: lineClasses.bgClass || lineClasses.textClass ? lineClasses : null};\n  }\n\n  function getLineStyles(cm, line, updateFrontier) {\n    if (!line.styles || line.styles[0] != cm.state.modeGen) {\n      var state = getStateBefore(cm, lineNo(line));\n      var result = highlightLine(cm, line, line.text.length > cm.options.maxHighlightLength ? copyState(cm.doc.mode, state) : state);\n      line.stateAfter = state;\n      line.styles = result.styles;\n      if (result.classes) line.styleClasses = result.classes;\n      else if (line.styleClasses) line.styleClasses = null;\n      if (updateFrontier === cm.doc.frontier) cm.doc.frontier++;\n    }\n    return line.styles;\n  }\n\n  // Lightweight form of highlight -- proceed over this line and\n  // update state, but don\'t save a style array. Used for lines that\n  // aren\'t currently visible.\n  function processLine(cm, text, state, startAt) {\n    var mode = cm.doc.mode;\n    var stream = new StringStream(text, cm.options.tabSize);\n    stream.start = stream.pos = startAt || 0;\n    if (text == "") callBlankLine(mode, state);\n    while (!stream.eol()) {\n      readToken(mode, stream, state);\n      stream.start = stream.pos;\n    }\n  }\n\n  // Convert a style as returned by a mode (either null, or a string\n  // containing one or more styles) to a CSS style. This is cached,\n  // and also looks for line-wide styles.\n  var styleToClassCache = {}, styleToClassCacheWithMode = {};\n  function interpretTokenStyle(style, options) {\n    if (!style || /^\\s*$/.test(style)) return null;\n    var cache = options.addModeClass ? styleToClassCacheWithMode : styleToClassCache;\n    return cache[style] ||\n      (cache[style] = style.replace(/\\S+/g, "cm-$&"));\n  }\n\n  // Render the DOM representation of the text of a line. Also builds\n  // up a \'line map\', which points at the DOM nodes that represent\n  // specific stretches of text, and is used by the measuring code.\n  // The returned object contains the DOM node, this map, and\n  // information about line-wide styles that were set by the mode.\n  function buildLineContent(cm, lineView) {\n    // The padding-right forces the element to have a \'border\', which\n    // is needed on Webkit to be able to get line-level bounding\n    // rectangles for it (in measureChar).\n    var content = elt("span", null, null, webkit ? "padding-right: .1px" : null);\n    var builder = {pre: elt("pre", [content], "CodeMirror-line"), content: content,\n                   col: 0, pos: 0, cm: cm,\n                   splitSpaces: (ie || webkit) && cm.getOption("lineWrapping")};\n    lineView.measure = {};\n\n    // Iterate over the logical lines that make up this visual line.\n    for (var i = 0; i <= (lineView.rest ? lineView.rest.length : 0); i++) {\n      var line = i ? lineView.rest[i - 1] : lineView.line, order;\n      builder.pos = 0;\n      builder.addToken = buildToken;\n      // Optionally wire in some hacks into the token-rendering\n      // algorithm, to deal with browser quirks.\n      if (hasBadBidiRects(cm.display.measure) && (order = getOrder(line)))\n        builder.addToken = buildTokenBadBidi(builder.addToken, order);\n      builder.map = [];\n      var allowFrontierUpdate = lineView != cm.display.externalMeasured && lineNo(line);\n      insertLineContent(line, builder, getLineStyles(cm, line, allowFrontierUpdate));\n      if (line.styleClasses) {\n        if (line.styleClasses.bgClass)\n          builder.bgClass = joinClasses(line.styleClasses.bgClass, builder.bgClass || "");\n        if (line.styleClasses.textClass)\n          builder.textClass = joinClasses(line.styleClasses.textClass, builder.textClass || "");\n      }\n\n      // Ensure at least a single node is present, for measuring.\n      if (builder.map.length == 0)\n        builder.map.push(0, 0, builder.content.appendChild(zeroWidthElement(cm.display.measure)));\n\n      // Store the map and a cache object for the current logical line\n      if (i == 0) {\n        lineView.measure.map = builder.map;\n        lineView.measure.cache = {};\n      } else {\n        (lineView.measure.maps || (lineView.measure.maps = [])).push(builder.map);\n        (lineView.measure.caches || (lineView.measure.caches = [])).push({});\n      }\n    }\n\n    // See issue #2901\n    if (webkit && /\\bcm-tab\\b/.test(builder.content.lastChild.className))\n      builder.content.className = "cm-tab-wrap-hack";\n\n    signal(cm, "renderLine", cm, lineView.line, builder.pre);\n    if (builder.pre.className)\n      builder.textClass = joinClasses(builder.pre.className, builder.textClass || "");\n\n    return builder;\n  }\n\n  function defaultSpecialCharPlaceholder(ch) {\n    var token = elt("span", "\\u2022", "cm-invalidchar");\n    token.title = "\\\\u" + ch.charCodeAt(0).toString(16);\n    token.setAttribute("aria-label", token.title);\n    return token;\n  }\n\n  // Build up the DOM representation for a single token, and add it to\n  // the line map. Takes care to render special characters separately.\n  function buildToken(builder, text, style, startStyle, endStyle, title, css) {\n    if (!text) return;\n    var displayText = builder.splitSpaces ? text.replace(/ {3,}/g, splitSpaces) : text;\n    var special = builder.cm.state.specialChars, mustWrap = false;\n    if (!special.test(text)) {\n      builder.col += text.length;\n      var content = document.createTextNode(displayText);\n      builder.map.push(builder.pos, builder.pos + text.length, content);\n      if (ie && ie_version < 9) mustWrap = true;\n      builder.pos += text.length;\n    } else {\n      var content = document.createDocumentFragment(), pos = 0;\n      while (true) {\n        special.lastIndex = pos;\n        var m = special.exec(text);\n        var skipped = m ? m.index - pos : text.length - pos;\n        if (skipped) {\n          var txt = document.createTextNode(displayText.slice(pos, pos + skipped));\n          if (ie && ie_version < 9) content.appendChild(elt("span", [txt]));\n          else content.appendChild(txt);\n          builder.map.push(builder.pos, builder.pos + skipped, txt);\n          builder.col += skipped;\n          builder.pos += skipped;\n        }\n        if (!m) break;\n        pos += skipped + 1;\n        if (m[0] == "\\t") {\n          var tabSize = builder.cm.options.tabSize, tabWidth = tabSize - builder.col % tabSize;\n          var txt = content.appendChild(elt("span", spaceStr(tabWidth), "cm-tab"));\n          txt.setAttribute("role", "presentation");\n          txt.setAttribute("cm-text", "\\t");\n          builder.col += tabWidth;\n        } else if (m[0] == "\\r" || m[0] == "\\n") {\n          var txt = content.appendChild(elt("span", m[0] == "\\r" ? "\\u240d" : "\\u2424", "cm-invalidchar"));\n          txt.setAttribute("cm-text", m[0]);\n          builder.col += 1;\n        } else {\n          var txt = builder.cm.options.specialCharPlaceholder(m[0]);\n          txt.setAttribute("cm-text", m[0]);\n          if (ie && ie_version < 9) content.appendChild(elt("span", [txt]));\n          else content.appendChild(txt);\n          builder.col += 1;\n        }\n        builder.map.push(builder.pos, builder.pos + 1, txt);\n        builder.pos++;\n      }\n    }\n    if (style || startStyle || endStyle || mustWrap || css) {\n      var fullStyle = style || "";\n      if (startStyle) fullStyle += startStyle;\n      if (endStyle) fullStyle += endStyle;\n      var token = elt("span", [content], fullStyle, css);\n      if (title) token.title = title;\n      return builder.content.appendChild(token);\n    }\n    builder.content.appendChild(content);\n  }\n\n  function splitSpaces(old) {\n    var out = " ";\n    for (var i = 0; i < old.length - 2; ++i) out += i % 2 ? " " : "\\u00a0";\n    out += " ";\n    return out;\n  }\n\n  // Work around nonsense dimensions being reported for stretches of\n  // right-to-left text.\n  function buildTokenBadBidi(inner, order) {\n    return function(builder, text, style, startStyle, endStyle, title, css) {\n      style = style ? style + " cm-force-border" : "cm-force-border";\n      var start = builder.pos, end = start + text.length;\n      for (;;) {\n        // Find the part that overlaps with the start of this text\n        for (var i = 0; i < order.length; i++) {\n          var part = order[i];\n          if (part.to > start && part.from <= start) break;\n        }\n        if (part.to >= end) return inner(builder, text, style, startStyle, endStyle, title, css);\n        inner(builder, text.slice(0, part.to - start), style, startStyle, null, title, css);\n        startStyle = null;\n        text = text.slice(part.to - start);\n        start = part.to;\n      }\n    };\n  }\n\n  function buildCollapsedSpan(builder, size, marker, ignoreWidget) {\n    var widget = !ignoreWidget && marker.widgetNode;\n    if (widget) builder.map.push(builder.pos, builder.pos + size, widget);\n    if (!ignoreWidget && builder.cm.display.input.needsContentAttribute) {\n      if (!widget)\n        widget = builder.content.appendChild(document.createElement("span"));\n      widget.setAttribute("cm-marker", marker.id);\n    }\n    if (widget) {\n      builder.cm.display.input.setUneditable(widget);\n      builder.content.appendChild(widget);\n    }\n    builder.pos += size;\n  }\n\n  // Outputs a number of spans to make up a line, taking highlighting\n  // and marked text into account.\n  function insertLineContent(line, builder, styles) {\n    var spans = line.markedSpans, allText = line.text, at = 0;\n    if (!spans) {\n      for (var i = 1; i < styles.length; i+=2)\n        builder.addToken(builder, allText.slice(at, at = styles[i]), interpretTokenStyle(styles[i+1], builder.cm.options));\n      return;\n    }\n\n    var len = allText.length, pos = 0, i = 1, text = "", style, css;\n    var nextChange = 0, spanStyle, spanEndStyle, spanStartStyle, title, collapsed;\n    for (;;) {\n      if (nextChange == pos) { // Update current marker set\n        spanStyle = spanEndStyle = spanStartStyle = title = css = "";\n        collapsed = null; nextChange = Infinity;\n        var foundBookmarks = [];\n        for (var j = 0; j < spans.length; ++j) {\n          var sp = spans[j], m = sp.marker;\n          if (m.type == "bookmark" && sp.from == pos && m.widgetNode) {\n            foundBookmarks.push(m);\n          } else if (sp.from <= pos && (sp.to == null || sp.to > pos || m.collapsed && sp.to == pos && sp.from == pos)) {\n            if (sp.to != null && sp.to != pos && nextChange > sp.to) {\n              nextChange = sp.to;\n              spanEndStyle = "";\n            }\n            if (m.className) spanStyle += " " + m.className;\n            if (m.css) css = m.css;\n            if (m.startStyle && sp.from == pos) spanStartStyle += " " + m.startStyle;\n            if (m.endStyle && sp.to == nextChange) spanEndStyle += " " + m.endStyle;\n            if (m.title && !title) title = m.title;\n            if (m.collapsed && (!collapsed || compareCollapsedMarkers(collapsed.marker, m) < 0))\n              collapsed = sp;\n          } else if (sp.from > pos && nextChange > sp.from) {\n            nextChange = sp.from;\n          }\n        }\n        if (collapsed && (collapsed.from || 0) == pos) {\n          buildCollapsedSpan(builder, (collapsed.to == null ? len + 1 : collapsed.to) - pos,\n                             collapsed.marker, collapsed.from == null);\n          if (collapsed.to == null) return;\n          if (collapsed.to == pos) collapsed = false;\n        }\n        if (!collapsed && foundBookmarks.length) for (var j = 0; j < foundBookmarks.length; ++j)\n          buildCollapsedSpan(builder, 0, foundBookmarks[j]);\n      }\n      if (pos >= len) break;\n\n      var upto = Math.min(len, nextChange);\n      while (true) {\n        if (text) {\n          var end = pos + text.length;\n          if (!collapsed) {\n            var tokenText = end > upto ? text.slice(0, upto - pos) : text;\n            builder.addToken(builder, tokenText, style ? style + spanStyle : spanStyle,\n                             spanStartStyle, pos + tokenText.length == nextChange ? spanEndStyle : "", title, css);\n          }\n          if (end >= upto) {text = text.slice(upto - pos); pos = upto; break;}\n          pos = end;\n          spanStartStyle = "";\n        }\n        text = allText.slice(at, at = styles[i++]);\n        style = interpretTokenStyle(styles[i++], builder.cm.options);\n      }\n    }\n  }\n\n  // DOCUMENT DATA STRUCTURE\n\n  // By default, updates that start and end at the beginning of a line\n  // are treated specially, in order to make the association of line\n  // widgets and marker elements with the text behave more intuitive.\n  function isWholeLineUpdate(doc, change) {\n    return change.from.ch == 0 && change.to.ch == 0 && lst(change.text) == "" &&\n      (!doc.cm || doc.cm.options.wholeLineUpdateBefore);\n  }\n\n  // Perform a change on the document data structure.\n  function updateDoc(doc, change, markedSpans, estimateHeight) {\n    function spansFor(n) {return markedSpans ? markedSpans[n] : null;}\n    function update(line, text, spans) {\n      updateLine(line, text, spans, estimateHeight);\n      signalLater(line, "change", line, change);\n    }\n    function linesFor(start, end) {\n      for (var i = start, result = []; i < end; ++i)\n        result.push(new Line(text[i], spansFor(i), estimateHeight));\n      return result;\n    }\n\n    var from = change.from, to = change.to, text = change.text;\n    var firstLine = getLine(doc, from.line), lastLine = getLine(doc, to.line);\n    var lastText = lst(text), lastSpans = spansFor(text.length - 1), nlines = to.line - from.line;\n\n    // Adjust the line structure\n    if (change.full) {\n      doc.insert(0, linesFor(0, text.length));\n      doc.remove(text.length, doc.size - text.length);\n    } else if (isWholeLineUpdate(doc, change)) {\n      // This is a whole-line replace. Treated specially to make\n      // sure line objects move the way they are supposed to.\n      var added = linesFor(0, text.length - 1);\n      update(lastLine, lastLine.text, lastSpans);\n      if (nlines) doc.remove(from.line, nlines);\n      if (added.length) doc.insert(from.line, added);\n    } else if (firstLine == lastLine) {\n      if (text.length == 1) {\n        update(firstLine, firstLine.text.slice(0, from.ch) + lastText + firstLine.text.slice(to.ch), lastSpans);\n      } else {\n        var added = linesFor(1, text.length - 1);\n        added.push(new Line(lastText + firstLine.text.slice(to.ch), lastSpans, estimateHeight));\n        update(firstLine, firstLine.text.slice(0, from.ch) + text[0], spansFor(0));\n        doc.insert(from.line + 1, added);\n      }\n    } else if (text.length == 1) {\n      update(firstLine, firstLine.text.slice(0, from.ch) + text[0] + lastLine.text.slice(to.ch), spansFor(0));\n      doc.remove(from.line + 1, nlines);\n    } else {\n      update(firstLine, firstLine.text.slice(0, from.ch) + text[0], spansFor(0));\n      update(lastLine, lastText + lastLine.text.slice(to.ch), lastSpans);\n      var added = linesFor(1, text.length - 1);\n      if (nlines > 1) doc.remove(from.line + 1, nlines - 1);\n      doc.insert(from.line + 1, added);\n    }\n\n    signalLater(doc, "change", doc, change);\n  }\n\n  // The document is represented as a BTree consisting of leaves, with\n  // chunk of lines in them, and branches, with up to ten leaves or\n  // other branch nodes below them. The top node is always a branch\n  // node, and is the document object itself (meaning it has\n  // additional methods and properties).\n  //\n  // All nodes have parent links. The tree is used both to go from\n  // line numbers to line objects, and to go from objects to numbers.\n  // It also indexes by height, and is used to convert between height\n  // and line object, and to find the total height of the document.\n  //\n  // See also http://marijnhaverbeke.nl/blog/codemirror-line-tree.html\n\n  function LeafChunk(lines) {\n    this.lines = lines;\n    this.parent = null;\n    for (var i = 0, height = 0; i < lines.length; ++i) {\n      lines[i].parent = this;\n      height += lines[i].height;\n    }\n    this.height = height;\n  }\n\n  LeafChunk.prototype = {\n    chunkSize: function() { return this.lines.length; },\n    // Remove the n lines at offset \'at\'.\n    removeInner: function(at, n) {\n      for (var i = at, e = at + n; i < e; ++i) {\n        var line = this.lines[i];\n        this.height -= line.height;\n        cleanUpLine(line);\n        signalLater(line, "delete");\n      }\n      this.lines.splice(at, n);\n    },\n    // Helper used to collapse a small branch into a single leaf.\n    collapse: function(lines) {\n      lines.push.apply(lines, this.lines);\n    },\n    // Insert the given array of lines at offset \'at\', count them as\n    // having the given height.\n    insertInner: function(at, lines, height) {\n      this.height += height;\n      this.lines = this.lines.slice(0, at).concat(lines).concat(this.lines.slice(at));\n      for (var i = 0; i < lines.length; ++i) lines[i].parent = this;\n    },\n    // Used to iterate over a part of the tree.\n    iterN: function(at, n, op) {\n      for (var e = at + n; at < e; ++at)\n        if (op(this.lines[at])) return true;\n    }\n  };\n\n  function BranchChunk(children) {\n    this.children = children;\n    var size = 0, height = 0;\n    for (var i = 0; i < children.length; ++i) {\n      var ch = children[i];\n      size += ch.chunkSize(); height += ch.height;\n      ch.parent = this;\n    }\n    this.size = size;\n    this.height = height;\n    this.parent = null;\n  }\n\n  BranchChunk.prototype = {\n    chunkSize: function() { return this.size; },\n    removeInner: function(at, n) {\n      this.size -= n;\n      for (var i = 0; i < this.children.length; ++i) {\n        var child = this.children[i], sz = child.chunkSize();\n        if (at < sz) {\n          var rm = Math.min(n, sz - at), oldHeight = child.height;\n          child.removeInner(at, rm);\n          this.height -= oldHeight - child.height;\n          if (sz == rm) { this.children.splice(i--, 1); child.parent = null; }\n          if ((n -= rm) == 0) break;\n          at = 0;\n        } else at -= sz;\n      }\n      // If the result is smaller than 25 lines, ensure that it is a\n      // single leaf node.\n      if (this.size - n < 25 &&\n          (this.children.length > 1 || !(this.children[0] instanceof LeafChunk))) {\n        var lines = [];\n        this.collapse(lines);\n        this.children = [new LeafChunk(lines)];\n        this.children[0].parent = this;\n      }\n    },\n    collapse: function(lines) {\n      for (var i = 0; i < this.children.length; ++i) this.children[i].collapse(lines);\n    },\n    insertInner: function(at, lines, height) {\n      this.size += lines.length;\n      this.height += height;\n      for (var i = 0; i < this.children.length; ++i) {\n        var child = this.children[i], sz = child.chunkSize();\n        if (at <= sz) {\n          child.insertInner(at, lines, height);\n          if (child.lines && child.lines.length > 50) {\n            while (child.lines.length > 50) {\n              var spilled = child.lines.splice(child.lines.length - 25, 25);\n              var newleaf = new LeafChunk(spilled);\n              child.height -= newleaf.height;\n              this.children.splice(i + 1, 0, newleaf);\n              newleaf.parent = this;\n            }\n            this.maybeSpill();\n          }\n          break;\n        }\n        at -= sz;\n      }\n    },\n    // When a node has grown, check whether it should be split.\n    maybeSpill: function() {\n      if (this.children.length <= 10) return;\n      var me = this;\n      do {\n        var spilled = me.children.splice(me.children.length - 5, 5);\n        var sibling = new BranchChunk(spilled);\n        if (!me.parent) { // Become the parent node\n          var copy = new BranchChunk(me.children);\n          copy.parent = me;\n          me.children = [copy, sibling];\n          me = copy;\n        } else {\n          me.size -= sibling.size;\n          me.height -= sibling.height;\n          var myIndex = indexOf(me.parent.children, me);\n          me.parent.children.splice(myIndex + 1, 0, sibling);\n        }\n        sibling.parent = me.parent;\n      } while (me.children.length > 10);\n      me.parent.maybeSpill();\n    },\n    iterN: function(at, n, op) {\n      for (var i = 0; i < this.children.length; ++i) {\n        var child = this.children[i], sz = child.chunkSize();\n        if (at < sz) {\n          var used = Math.min(n, sz - at);\n          if (child.iterN(at, used, op)) return true;\n          if ((n -= used) == 0) break;\n          at = 0;\n        } else at -= sz;\n      }\n    }\n  };\n\n  var nextDocId = 0;\n  var Doc = CodeMirror.Doc = function(text, mode, firstLine, lineSep) {\n    if (!(this instanceof Doc)) return new Doc(text, mode, firstLine, lineSep);\n    if (firstLine == null) firstLine = 0;\n\n    BranchChunk.call(this, [new LeafChunk([new Line("", null)])]);\n    this.first = firstLine;\n    this.scrollTop = this.scrollLeft = 0;\n    this.cantEdit = false;\n    this.cleanGeneration = 1;\n    this.frontier = firstLine;\n    var start = Pos(firstLine, 0);\n    this.sel = simpleSelection(start);\n    this.history = new History(null);\n    this.id = ++nextDocId;\n    this.modeOption = mode;\n    this.lineSep = lineSep;\n\n    if (typeof text == "string") text = this.splitLines(text);\n    updateDoc(this, {from: start, to: start, text: text});\n    setSelection(this, simpleSelection(start), sel_dontScroll);\n  };\n\n  Doc.prototype = createObj(BranchChunk.prototype, {\n    constructor: Doc,\n    // Iterate over the document. Supports two forms -- with only one\n    // argument, it calls that for each line in the document. With\n    // three, it iterates over the range given by the first two (with\n    // the second being non-inclusive).\n    iter: function(from, to, op) {\n      if (op) this.iterN(from - this.first, to - from, op);\n      else this.iterN(this.first, this.first + this.size, from);\n    },\n\n    // Non-public interface for adding and removing lines.\n    insert: function(at, lines) {\n      var height = 0;\n      for (var i = 0; i < lines.length; ++i) height += lines[i].height;\n      this.insertInner(at - this.first, lines, height);\n    },\n    remove: function(at, n) { this.removeInner(at - this.first, n); },\n\n    // From here, the methods are part of the public interface. Most\n    // are also available from CodeMirror (editor) instances.\n\n    getValue: function(lineSep) {\n      var lines = getLines(this, this.first, this.first + this.size);\n      if (lineSep === false) return lines;\n      return lines.join(lineSep || this.lineSeparator());\n    },\n    setValue: docMethodOp(function(code) {\n      var top = Pos(this.first, 0), last = this.first + this.size - 1;\n      makeChange(this, {from: top, to: Pos(last, getLine(this, last).text.length),\n                        text: this.splitLines(code), origin: "setValue", full: true}, true);\n      setSelection(this, simpleSelection(top));\n    }),\n    replaceRange: function(code, from, to, origin) {\n      from = clipPos(this, from);\n      to = to ? clipPos(this, to) : from;\n      replaceRange(this, code, from, to, origin);\n    },\n    getRange: function(from, to, lineSep) {\n      var lines = getBetween(this, clipPos(this, from), clipPos(this, to));\n      if (lineSep === false) return lines;\n      return lines.join(lineSep || this.lineSeparator());\n    },\n\n    getLine: function(line) {var l = this.getLineHandle(line); return l && l.text;},\n\n    getLineHandle: function(line) {if (isLine(this, line)) return getLine(this, line);},\n    getLineNumber: function(line) {return lineNo(line);},\n\n    getLineHandleVisualStart: function(line) {\n      if (typeof line == "number") line = getLine(this, line);\n      return visualLine(line);\n    },\n\n    lineCount: function() {return this.size;},\n    firstLine: function() {return this.first;},\n    lastLine: function() {return this.first + this.size - 1;},\n\n    clipPos: function(pos) {return clipPos(this, pos);},\n\n    getCursor: function(start) {\n      var range = this.sel.primary(), pos;\n      if (start == null || start == "head") pos = range.head;\n      else if (start == "anchor") pos = range.anchor;\n      else if (start == "end" || start == "to" || start === false) pos = range.to();\n      else pos = range.from();\n      return pos;\n    },\n    listSelections: function() { return this.sel.ranges; },\n    somethingSelected: function() {return this.sel.somethingSelected();},\n\n    setCursor: docMethodOp(function(line, ch, options) {\n      setSimpleSelection(this, clipPos(this, typeof line == "number" ? Pos(line, ch || 0) : line), null, options);\n    }),\n    setSelection: docMethodOp(function(anchor, head, options) {\n      setSimpleSelection(this, clipPos(this, anchor), clipPos(this, head || anchor), options);\n    }),\n    extendSelection: docMethodOp(function(head, other, options) {\n      extendSelection(this, clipPos(this, head), other && clipPos(this, other), options);\n    }),\n    extendSelections: docMethodOp(function(heads, options) {\n      extendSelections(this, clipPosArray(this, heads, options));\n    }),\n    extendSelectionsBy: docMethodOp(function(f, options) {\n      extendSelections(this, map(this.sel.ranges, f), options);\n    }),\n    setSelections: docMethodOp(function(ranges, primary, options) {\n      if (!ranges.length) return;\n      for (var i = 0, out = []; i < ranges.length; i++)\n        out[i] = new Range(clipPos(this, ranges[i].anchor),\n                           clipPos(this, ranges[i].head));\n      if (primary == null) primary = Math.min(ranges.length - 1, this.sel.primIndex);\n      setSelection(this, normalizeSelection(out, primary), options);\n    }),\n    addSelection: docMethodOp(function(anchor, head, options) {\n      var ranges = this.sel.ranges.slice(0);\n      ranges.push(new Range(clipPos(this, anchor), clipPos(this, head || anchor)));\n      setSelection(this, normalizeSelection(ranges, ranges.length - 1), options);\n    }),\n\n    getSelection: function(lineSep) {\n      var ranges = this.sel.ranges, lines;\n      for (var i = 0; i < ranges.length; i++) {\n        var sel = getBetween(this, ranges[i].from(), ranges[i].to());\n        lines = lines ? lines.concat(sel) : sel;\n      }\n      if (lineSep === false) return lines;\n      else return lines.join(lineSep || this.lineSeparator());\n    },\n    getSelections: function(lineSep) {\n      var parts = [], ranges = this.sel.ranges;\n      for (var i = 0; i < ranges.length; i++) {\n        var sel = getBetween(this, ranges[i].from(), ranges[i].to());\n        if (lineSep !== false) sel = sel.join(lineSep || this.lineSeparator());\n        parts[i] = sel;\n      }\n      return parts;\n    },\n    replaceSelection: function(code, collapse, origin) {\n      var dup = [];\n      for (var i = 0; i < this.sel.ranges.length; i++)\n        dup[i] = code;\n      this.replaceSelections(dup, collapse, origin || "+input");\n    },\n    replaceSelections: docMethodOp(function(code, collapse, origin) {\n      var changes = [], sel = this.sel;\n      for (var i = 0; i < sel.ranges.length; i++) {\n        var range = sel.ranges[i];\n        changes[i] = {from: range.from(), to: range.to(), text: this.splitLines(code[i]), origin: origin};\n      }\n      var newSel = collapse && collapse != "end" && computeReplacedSel(this, changes, collapse);\n      for (var i = changes.length - 1; i >= 0; i--)\n        makeChange(this, changes[i]);\n      if (newSel) setSelectionReplaceHistory(this, newSel);\n      else if (this.cm) ensureCursorVisible(this.cm);\n    }),\n    undo: docMethodOp(function() {makeChangeFromHistory(this, "undo");}),\n    redo: docMethodOp(function() {makeChangeFromHistory(this, "redo");}),\n    undoSelection: docMethodOp(function() {makeChangeFromHistory(this, "undo", true);}),\n    redoSelection: docMethodOp(function() {makeChangeFromHistory(this, "redo", true);}),\n\n    setExtending: function(val) {this.extend = val;},\n    getExtending: function() {return this.extend;},\n\n    historySize: function() {\n      var hist = this.history, done = 0, undone = 0;\n      for (var i = 0; i < hist.done.length; i++) if (!hist.done[i].ranges) ++done;\n      for (var i = 0; i < hist.undone.length; i++) if (!hist.undone[i].ranges) ++undone;\n      return {undo: done, redo: undone};\n    },\n    clearHistory: function() {this.history = new History(this.history.maxGeneration);},\n\n    markClean: function() {\n      this.cleanGeneration = this.changeGeneration(true);\n    },\n    changeGeneration: function(forceSplit) {\n      if (forceSplit)\n        this.history.lastOp = this.history.lastSelOp = this.history.lastOrigin = null;\n      return this.history.generation;\n    },\n    isClean: function (gen) {\n      return this.history.generation == (gen || this.cleanGeneration);\n    },\n\n    getHistory: function() {\n      return {done: copyHistoryArray(this.history.done),\n              undone: copyHistoryArray(this.history.undone)};\n    },\n    setHistory: function(histData) {\n      var hist = this.history = new History(this.history.maxGeneration);\n      hist.done = copyHistoryArray(histData.done.slice(0), null, true);\n      hist.undone = copyHistoryArray(histData.undone.slice(0), null, true);\n    },\n\n    addLineClass: docMethodOp(function(handle, where, cls) {\n      return changeLine(this, handle, where == "gutter" ? "gutter" : "class", function(line) {\n        var prop = where == "text" ? "textClass"\n                 : where == "background" ? "bgClass"\n                 : where == "gutter" ? "gutterClass" : "wrapClass";\n        if (!line[prop]) line[prop] = cls;\n        else if (classTest(cls).test(line[prop])) return false;\n        else line[prop] += " " + cls;\n        return true;\n      });\n    }),\n    removeLineClass: docMethodOp(function(handle, where, cls) {\n      return changeLine(this, handle, where == "gutter" ? "gutter" : "class", function(line) {\n        var prop = where == "text" ? "textClass"\n                 : where == "background" ? "bgClass"\n                 : where == "gutter" ? "gutterClass" : "wrapClass";\n        var cur = line[prop];\n        if (!cur) return false;\n        else if (cls == null) line[prop] = null;\n        else {\n          var found = cur.match(classTest(cls));\n          if (!found) return false;\n          var end = found.index + found[0].length;\n          line[prop] = cur.slice(0, found.index) + (!found.index || end == cur.length ? "" : " ") + cur.slice(end) || null;\n        }\n        return true;\n      });\n    }),\n\n    addLineWidget: docMethodOp(function(handle, node, options) {\n      return addLineWidget(this, handle, node, options);\n    }),\n    removeLineWidget: function(widget) { widget.clear(); },\n\n    markText: function(from, to, options) {\n      return markText(this, clipPos(this, from), clipPos(this, to), options, "range");\n    },\n    setBookmark: function(pos, options) {\n      var realOpts = {replacedWith: options && (options.nodeType == null ? options.widget : options),\n                      insertLeft: options && options.insertLeft,\n                      clearWhenEmpty: false, shared: options && options.shared,\n                      handleMouseEvents: options && options.handleMouseEvents};\n      pos = clipPos(this, pos);\n      return markText(this, pos, pos, realOpts, "bookmark");\n    },\n    findMarksAt: function(pos) {\n      pos = clipPos(this, pos);\n      var markers = [], spans = getLine(this, pos.line).markedSpans;\n      if (spans) for (var i = 0; i < spans.length; ++i) {\n        var span = spans[i];\n        if ((span.from == null || span.from <= pos.ch) &&\n            (span.to == null || span.to >= pos.ch))\n          markers.push(span.marker.parent || span.marker);\n      }\n      return markers;\n    },\n    findMarks: function(from, to, filter) {\n      from = clipPos(this, from); to = clipPos(this, to);\n      var found = [], lineNo = from.line;\n      this.iter(from.line, to.line + 1, function(line) {\n        var spans = line.markedSpans;\n        if (spans) for (var i = 0; i < spans.length; i++) {\n          var span = spans[i];\n          if (!(lineNo == from.line && from.ch > span.to ||\n                span.from == null && lineNo != from.line||\n                lineNo == to.line && span.from > to.ch) &&\n              (!filter || filter(span.marker)))\n            found.push(span.marker.parent || span.marker);\n        }\n        ++lineNo;\n      });\n      return found;\n    },\n    getAllMarks: function() {\n      var markers = [];\n      this.iter(function(line) {\n        var sps = line.markedSpans;\n        if (sps) for (var i = 0; i < sps.length; ++i)\n          if (sps[i].from != null) markers.push(sps[i].marker);\n      });\n      return markers;\n    },\n\n    posFromIndex: function(off) {\n      var ch, lineNo = this.first;\n      this.iter(function(line) {\n        var sz = line.text.length + 1;\n        if (sz > off) { ch = off; return true; }\n        off -= sz;\n        ++lineNo;\n      });\n      return clipPos(this, Pos(lineNo, ch));\n    },\n    indexFromPos: function (coords) {\n      coords = clipPos(this, coords);\n      var index = coords.ch;\n      if (coords.line < this.first || coords.ch < 0) return 0;\n      this.iter(this.first, coords.line, function (line) {\n        index += line.text.length + 1;\n      });\n      return index;\n    },\n\n    copy: function(copyHistory) {\n      var doc = new Doc(getLines(this, this.first, this.first + this.size),\n                        this.modeOption, this.first, this.lineSep);\n      doc.scrollTop = this.scrollTop; doc.scrollLeft = this.scrollLeft;\n      doc.sel = this.sel;\n      doc.extend = false;\n      if (copyHistory) {\n        doc.history.undoDepth = this.history.undoDepth;\n        doc.setHistory(this.getHistory());\n      }\n      return doc;\n    },\n\n    linkedDoc: function(options) {\n      if (!options) options = {};\n      var from = this.first, to = this.first + this.size;\n      if (options.from != null && options.from > from) from = options.from;\n      if (options.to != null && options.to < to) to = options.to;\n      var copy = new Doc(getLines(this, from, to), options.mode || this.modeOption, from, this.lineSep);\n      if (options.sharedHist) copy.history = this.history;\n      (this.linked || (this.linked = [])).push({doc: copy, sharedHist: options.sharedHist});\n      copy.linked = [{doc: this, isParent: true, sharedHist: options.sharedHist}];\n      copySharedMarkers(copy, findSharedMarkers(this));\n      return copy;\n    },\n    unlinkDoc: function(other) {\n      if (other instanceof CodeMirror) other = other.doc;\n      if (this.linked) for (var i = 0; i < this.linked.length; ++i) {\n        var link = this.linked[i];\n        if (link.doc != other) continue;\n        this.linked.splice(i, 1);\n        other.unlinkDoc(this);\n        detachSharedMarkers(findSharedMarkers(this));\n        break;\n      }\n      // If the histories were shared, split them again\n      if (other.history == this.history) {\n        var splitIds = [other.id];\n        linkedDocs(other, function(doc) {splitIds.push(doc.id);}, true);\n        other.history = new History(null);\n        other.history.done = copyHistoryArray(this.history.done, splitIds);\n        other.history.undone = copyHistoryArray(this.history.undone, splitIds);\n      }\n    },\n    iterLinkedDocs: function(f) {linkedDocs(this, f);},\n\n    getMode: function() {return this.mode;},\n    getEditor: function() {return this.cm;},\n\n    splitLines: function(str) {\n      if (this.lineSep) return str.split(this.lineSep);\n      return splitLinesAuto(str);\n    },\n    lineSeparator: function() { return this.lineSep || "\\n"; }\n  });\n\n  // Public alias.\n  Doc.prototype.eachLine = Doc.prototype.iter;\n\n  // Set up methods on CodeMirror\'s prototype to redirect to the editor\'s document.\n  var dontDelegate = "iter insert remove copy getEditor constructor".split(" ");\n  for (var prop in Doc.prototype) if (Doc.prototype.hasOwnProperty(prop) && indexOf(dontDelegate, prop) < 0)\n    CodeMirror.prototype[prop] = (function(method) {\n      return function() {return method.apply(this.doc, arguments);};\n    })(Doc.prototype[prop]);\n\n  eventMixin(Doc);\n\n  // Call f for all linked documents.\n  function linkedDocs(doc, f, sharedHistOnly) {\n    function propagate(doc, skip, sharedHist) {\n      if (doc.linked) for (var i = 0; i < doc.linked.length; ++i) {\n        var rel = doc.linked[i];\n        if (rel.doc == skip) continue;\n        var shared = sharedHist && rel.sharedHist;\n        if (sharedHistOnly && !shared) continue;\n        f(rel.doc, shared);\n        propagate(rel.doc, doc, shared);\n      }\n    }\n    propagate(doc, null, true);\n  }\n\n  // Attach a document to an editor.\n  function attachDoc(cm, doc) {\n    if (doc.cm) throw new Error("This document is already in use.");\n    cm.doc = doc;\n    doc.cm = cm;\n    estimateLineHeights(cm);\n    loadMode(cm);\n    if (!cm.options.lineWrapping) findMaxLine(cm);\n    cm.options.mode = doc.modeOption;\n    regChange(cm);\n  }\n\n  // LINE UTILITIES\n\n  // Find the line object corresponding to the given line number.\n  function getLine(doc, n) {\n    n -= doc.first;\n    if (n < 0 || n >= doc.size) throw new Error("There is no line " + (n + doc.first) + " in the document.");\n    for (var chunk = doc; !chunk.lines;) {\n      for (var i = 0;; ++i) {\n        var child = chunk.children[i], sz = child.chunkSize();\n        if (n < sz) { chunk = child; break; }\n        n -= sz;\n      }\n    }\n    return chunk.lines[n];\n  }\n\n  // Get the part of a document between two positions, as an array of\n  // strings.\n  function getBetween(doc, start, end) {\n    var out = [], n = start.line;\n    doc.iter(start.line, end.line + 1, function(line) {\n      var text = line.text;\n      if (n == end.line) text = text.slice(0, end.ch);\n      if (n == start.line) text = text.slice(start.ch);\n      out.push(text);\n      ++n;\n    });\n    return out;\n  }\n  // Get the lines between from and to, as array of strings.\n  function getLines(doc, from, to) {\n    var out = [];\n    doc.iter(from, to, function(line) { out.push(line.text); });\n    return out;\n  }\n\n  // Update the height of a line, propagating the height change\n  // upwards to parent nodes.\n  function updateLineHeight(line, height) {\n    var diff = height - line.height;\n    if (diff) for (var n = line; n; n = n.parent) n.height += diff;\n  }\n\n  // Given a line object, find its line number by walking up through\n  // its parent links.\n  function lineNo(line) {\n    if (line.parent == null) return null;\n    var cur = line.parent, no = indexOf(cur.lines, line);\n    for (var chunk = cur.parent; chunk; cur = chunk, chunk = chunk.parent) {\n      for (var i = 0;; ++i) {\n        if (chunk.children[i] == cur) break;\n        no += chunk.children[i].chunkSize();\n      }\n    }\n    return no + cur.first;\n  }\n\n  // Find the line at the given vertical position, using the height\n  // information in the document tree.\n  function lineAtHeight(chunk, h) {\n    var n = chunk.first;\n    outer: do {\n      for (var i = 0; i < chunk.children.length; ++i) {\n        var child = chunk.children[i], ch = child.height;\n        if (h < ch) { chunk = child; continue outer; }\n        h -= ch;\n        n += child.chunkSize();\n      }\n      return n;\n    } while (!chunk.lines);\n    for (var i = 0; i < chunk.lines.length; ++i) {\n      var line = chunk.lines[i], lh = line.height;\n      if (h < lh) break;\n      h -= lh;\n    }\n    return n + i;\n  }\n\n\n  // Find the height above the given line.\n  function heightAtLine(lineObj) {\n    lineObj = visualLine(lineObj);\n\n    var h = 0, chunk = lineObj.parent;\n    for (var i = 0; i < chunk.lines.length; ++i) {\n      var line = chunk.lines[i];\n      if (line == lineObj) break;\n      else h += line.height;\n    }\n    for (var p = chunk.parent; p; chunk = p, p = chunk.parent) {\n      for (var i = 0; i < p.children.length; ++i) {\n        var cur = p.children[i];\n        if (cur == chunk) break;\n        else h += cur.height;\n      }\n    }\n    return h;\n  }\n\n  // Get the bidi ordering for the given line (and cache it). Returns\n  // false for lines that are fully left-to-right, and an array of\n  // BidiSpan objects otherwise.\n  function getOrder(line) {\n    var order = line.order;\n    if (order == null) order = line.order = bidiOrdering(line.text);\n    return order;\n  }\n\n  // HISTORY\n\n  function History(startGen) {\n    // Arrays of change events and selections. Doing something adds an\n    // event to done and clears undo. Undoing moves events from done\n    // to undone, redoing moves them in the other direction.\n    this.done = []; this.undone = [];\n    this.undoDepth = Infinity;\n    // Used to track when changes can be merged into a single undo\n    // event\n    this.lastModTime = this.lastSelTime = 0;\n    this.lastOp = this.lastSelOp = null;\n    this.lastOrigin = this.lastSelOrigin = null;\n    // Used by the isClean() method\n    this.generation = this.maxGeneration = startGen || 1;\n  }\n\n  // Create a history change event from an updateDoc-style change\n  // object.\n  function historyChangeFromChange(doc, change) {\n    var histChange = {from: copyPos(change.from), to: changeEnd(change), text: getBetween(doc, change.from, change.to)};\n    attachLocalSpans(doc, histChange, change.from.line, change.to.line + 1);\n    linkedDocs(doc, function(doc) {attachLocalSpans(doc, histChange, change.from.line, change.to.line + 1);}, true);\n    return histChange;\n  }\n\n  // Pop all selection events off the end of a history array. Stop at\n  // a change event.\n  function clearSelectionEvents(array) {\n    while (array.length) {\n      var last = lst(array);\n      if (last.ranges) array.pop();\n      else break;\n    }\n  }\n\n  // Find the top change event in the history. Pop off selection\n  // events that are in the way.\n  function lastChangeEvent(hist, force) {\n    if (force) {\n      clearSelectionEvents(hist.done);\n      return lst(hist.done);\n    } else if (hist.done.length && !lst(hist.done).ranges) {\n      return lst(hist.done);\n    } else if (hist.done.length > 1 && !hist.done[hist.done.length - 2].ranges) {\n      hist.done.pop();\n      return lst(hist.done);\n    }\n  }\n\n  // Register a change in the history. Merges changes that are within\n  // a single operation, ore are close together with an origin that\n  // allows merging (starting with "+") into a single event.\n  function addChangeToHistory(doc, change, selAfter, opId) {\n    var hist = doc.history;\n    hist.undone.length = 0;\n    var time = +new Date, cur;\n\n    if ((hist.lastOp == opId ||\n         hist.lastOrigin == change.origin && change.origin &&\n         ((change.origin.charAt(0) == "+" && doc.cm && hist.lastModTime > time - doc.cm.options.historyEventDelay) ||\n          change.origin.charAt(0) == "*")) &&\n        (cur = lastChangeEvent(hist, hist.lastOp == opId))) {\n      // Merge this change into the last event\n      var last = lst(cur.changes);\n      if (cmp(change.from, change.to) == 0 && cmp(change.from, last.to) == 0) {\n        // Optimized case for simple insertion -- don\'t want to add\n        // new changesets for every character typed\n        last.to = changeEnd(change);\n      } else {\n        // Add new sub-event\n        cur.changes.push(historyChangeFromChange(doc, change));\n      }\n    } else {\n      // Can not be merged, start a new event.\n      var before = lst(hist.done);\n      if (!before || !before.ranges)\n        pushSelectionToHistory(doc.sel, hist.done);\n      cur = {changes: [historyChangeFromChange(doc, change)],\n             generation: hist.generation};\n      hist.done.push(cur);\n      while (hist.done.length > hist.undoDepth) {\n        hist.done.shift();\n        if (!hist.done[0].ranges) hist.done.shift();\n      }\n    }\n    hist.done.push(selAfter);\n    hist.generation = ++hist.maxGeneration;\n    hist.lastModTime = hist.lastSelTime = time;\n    hist.lastOp = hist.lastSelOp = opId;\n    hist.lastOrigin = hist.lastSelOrigin = change.origin;\n\n    if (!last) signal(doc, "historyAdded");\n  }\n\n  function selectionEventCanBeMerged(doc, origin, prev, sel) {\n    var ch = origin.charAt(0);\n    return ch == "*" ||\n      ch == "+" &&\n      prev.ranges.length == sel.ranges.length &&\n      prev.somethingSelected() == sel.somethingSelected() &&\n      new Date - doc.history.lastSelTime <= (doc.cm ? doc.cm.options.historyEventDelay : 500);\n  }\n\n  // Called whenever the selection changes, sets the new selection as\n  // the pending selection in the history, and pushes the old pending\n  // selection into the \'done\' array when it was significantly\n  // different (in number of selected ranges, emptiness, or time).\n  function addSelectionToHistory(doc, sel, opId, options) {\n    var hist = doc.history, origin = options && options.origin;\n\n    // A new event is started when the previous origin does not match\n    // the current, or the origins don\'t allow matching. Origins\n    // starting with * are always merged, those starting with + are\n    // merged when similar and close together in time.\n    if (opId == hist.lastSelOp ||\n        (origin && hist.lastSelOrigin == origin &&\n         (hist.lastModTime == hist.lastSelTime && hist.lastOrigin == origin ||\n          selectionEventCanBeMerged(doc, origin, lst(hist.done), sel))))\n      hist.done[hist.done.length - 1] = sel;\n    else\n      pushSelectionToHistory(sel, hist.done);\n\n    hist.lastSelTime = +new Date;\n    hist.lastSelOrigin = origin;\n    hist.lastSelOp = opId;\n    if (options && options.clearRedo !== false)\n      clearSelectionEvents(hist.undone);\n  }\n\n  function pushSelectionToHistory(sel, dest) {\n    var top = lst(dest);\n    if (!(top && top.ranges && top.equals(sel)))\n      dest.push(sel);\n  }\n\n  // Used to store marked span information in the history.\n  function attachLocalSpans(doc, change, from, to) {\n    var existing = change["spans_" + doc.id], n = 0;\n    doc.iter(Math.max(doc.first, from), Math.min(doc.first + doc.size, to), function(line) {\n      if (line.markedSpans)\n        (existing || (existing = change["spans_" + doc.id] = {}))[n] = line.markedSpans;\n      ++n;\n    });\n  }\n\n  // When un/re-doing restores text containing marked spans, those\n  // that have been explicitly cleared should not be restored.\n  function removeClearedSpans(spans) {\n    if (!spans) return null;\n    for (var i = 0, out; i < spans.length; ++i) {\n      if (spans[i].marker.explicitlyCleared) { if (!out) out = spans.slice(0, i); }\n      else if (out) out.push(spans[i]);\n    }\n    return !out ? spans : out.length ? out : null;\n  }\n\n  // Retrieve and filter the old marked spans stored in a change event.\n  function getOldSpans(doc, change) {\n    var found = change["spans_" + doc.id];\n    if (!found) return null;\n    for (var i = 0, nw = []; i < change.text.length; ++i)\n      nw.push(removeClearedSpans(found[i]));\n    return nw;\n  }\n\n  // Used both to provide a JSON-safe object in .getHistory, and, when\n  // detaching a document, to split the history in two\n  function copyHistoryArray(events, newGroup, instantiateSel) {\n    for (var i = 0, copy = []; i < events.length; ++i) {\n      var event = events[i];\n      if (event.ranges) {\n        copy.push(instantiateSel ? Selection.prototype.deepCopy.call(event) : event);\n        continue;\n      }\n      var changes = event.changes, newChanges = [];\n      copy.push({changes: newChanges});\n      for (var j = 0; j < changes.length; ++j) {\n        var change = changes[j], m;\n        newChanges.push({from: change.from, to: change.to, text: change.text});\n        if (newGroup) for (var prop in change) if (m = prop.match(/^spans_(\\d+)$/)) {\n          if (indexOf(newGroup, Number(m[1])) > -1) {\n            lst(newChanges)[prop] = change[prop];\n            delete change[prop];\n          }\n        }\n      }\n    }\n    return copy;\n  }\n\n  // Rebasing/resetting history to deal with externally-sourced changes\n\n  function rebaseHistSelSingle(pos, from, to, diff) {\n    if (to < pos.line) {\n      pos.line += diff;\n    } else if (from < pos.line) {\n      pos.line = from;\n      pos.ch = 0;\n    }\n  }\n\n  // Tries to rebase an array of history events given a change in the\n  // document. If the change touches the same lines as the event, the\n  // event, and everything \'behind\' it, is discarded. If the change is\n  // before the event, the event\'s positions are updated. Uses a\n  // copy-on-write scheme for the positions, to avoid having to\n  // reallocate them all on every rebase, but also avoid problems with\n  // shared position objects being unsafely updated.\n  function rebaseHistArray(array, from, to, diff) {\n    for (var i = 0; i < array.length; ++i) {\n      var sub = array[i], ok = true;\n      if (sub.ranges) {\n        if (!sub.copied) { sub = array[i] = sub.deepCopy(); sub.copied = true; }\n        for (var j = 0; j < sub.ranges.length; j++) {\n          rebaseHistSelSingle(sub.ranges[j].anchor, from, to, diff);\n          rebaseHistSelSingle(sub.ranges[j].head, from, to, diff);\n        }\n        continue;\n      }\n      for (var j = 0; j < sub.changes.length; ++j) {\n        var cur = sub.changes[j];\n        if (to < cur.from.line) {\n          cur.from = Pos(cur.from.line + diff, cur.from.ch);\n          cur.to = Pos(cur.to.line + diff, cur.to.ch);\n        } else if (from <= cur.to.line) {\n          ok = false;\n          break;\n        }\n      }\n      if (!ok) {\n        array.splice(0, i + 1);\n        i = 0;\n      }\n    }\n  }\n\n  function rebaseHist(hist, change) {\n    var from = change.from.line, to = change.to.line, diff = change.text.length - (to - from) - 1;\n    rebaseHistArray(hist.done, from, to, diff);\n    rebaseHistArray(hist.undone, from, to, diff);\n  }\n\n  // EVENT UTILITIES\n\n  // Due to the fact that we still support jurassic IE versions, some\n  // compatibility wrappers are needed.\n\n  var e_preventDefault = CodeMirror.e_preventDefault = function(e) {\n    if (e.preventDefault) e.preventDefault();\n    else e.returnValue = false;\n  };\n  var e_stopPropagation = CodeMirror.e_stopPropagation = function(e) {\n    if (e.stopPropagation) e.stopPropagation();\n    else e.cancelBubble = true;\n  };\n  function e_defaultPrevented(e) {\n    return e.defaultPrevented != null ? e.defaultPrevented : e.returnValue == false;\n  }\n  var e_stop = CodeMirror.e_stop = function(e) {e_preventDefault(e); e_stopPropagation(e);};\n\n  function e_target(e) {return e.target || e.srcElement;}\n  function e_button(e) {\n    var b = e.which;\n    if (b == null) {\n      if (e.button & 1) b = 1;\n      else if (e.button & 2) b = 3;\n      else if (e.button & 4) b = 2;\n    }\n    if (mac && e.ctrlKey && b == 1) b = 3;\n    return b;\n  }\n\n  // EVENT HANDLING\n\n  // Lightweight event framework. on/off also work on DOM nodes,\n  // registering native DOM handlers.\n\n  var on = CodeMirror.on = function(emitter, type, f) {\n    if (emitter.addEventListener)\n      emitter.addEventListener(type, f, false);\n    else if (emitter.attachEvent)\n      emitter.attachEvent("on" + type, f);\n    else {\n      var map = emitter._handlers || (emitter._handlers = {});\n      var arr = map[type] || (map[type] = []);\n      arr.push(f);\n    }\n  };\n\n  var off = CodeMirror.off = function(emitter, type, f) {\n    if (emitter.removeEventListener)\n      emitter.removeEventListener(type, f, false);\n    else if (emitter.detachEvent)\n      emitter.detachEvent("on" + type, f);\n    else {\n      var arr = emitter._handlers && emitter._handlers[type];\n      if (!arr) return;\n      for (var i = 0; i < arr.length; ++i)\n        if (arr[i] == f) { arr.splice(i, 1); break; }\n    }\n  };\n\n  var signal = CodeMirror.signal = function(emitter, type /*, values...*/) {\n    var arr = emitter._handlers && emitter._handlers[type];\n    if (!arr) return;\n    var args = Array.prototype.slice.call(arguments, 2);\n    for (var i = 0; i < arr.length; ++i) arr[i].apply(null, args);\n  };\n\n  var orphanDelayedCallbacks = null;\n\n  // Often, we want to signal events at a point where we are in the\n  // middle of some work, but don\'t want the handler to start calling\n  // other methods on the editor, which might be in an inconsistent\n  // state or simply not expect any other events to happen.\n  // signalLater looks whether there are any handlers, and schedules\n  // them to be executed when the last operation ends, or, if no\n  // operation is active, when a timeout fires.\n  function signalLater(emitter, type /*, values...*/) {\n    var arr = emitter._handlers && emitter._handlers[type];\n    if (!arr) return;\n    var args = Array.prototype.slice.call(arguments, 2), list;\n    if (operationGroup) {\n      list = operationGroup.delayedCallbacks;\n    } else if (orphanDelayedCallbacks) {\n      list = orphanDelayedCallbacks;\n    } else {\n      list = orphanDelayedCallbacks = [];\n      setTimeout(fireOrphanDelayed, 0);\n    }\n    function bnd(f) {return function(){f.apply(null, args);};};\n    for (var i = 0; i < arr.length; ++i)\n      list.push(bnd(arr[i]));\n  }\n\n  function fireOrphanDelayed() {\n    var delayed = orphanDelayedCallbacks;\n    orphanDelayedCallbacks = null;\n    for (var i = 0; i < delayed.length; ++i) delayed[i]();\n  }\n\n  // The DOM events that CodeMirror handles can be overridden by\n  // registering a (non-DOM) handler on the editor for the event name,\n  // and preventDefault-ing the event in that handler.\n  function signalDOMEvent(cm, e, override) {\n    if (typeof e == "string")\n      e = {type: e, preventDefault: function() { this.defaultPrevented = true; }};\n    signal(cm, override || e.type, cm, e);\n    return e_defaultPrevented(e) || e.codemirrorIgnore;\n  }\n\n  function signalCursorActivity(cm) {\n    var arr = cm._handlers && cm._handlers.cursorActivity;\n    if (!arr) return;\n    var set = cm.curOp.cursorActivityHandlers || (cm.curOp.cursorActivityHandlers = []);\n    for (var i = 0; i < arr.length; ++i) if (indexOf(set, arr[i]) == -1)\n      set.push(arr[i]);\n  }\n\n  function hasHandler(emitter, type) {\n    var arr = emitter._handlers && emitter._handlers[type];\n    return arr && arr.length > 0;\n  }\n\n  // Add on and off methods to a constructor\'s prototype, to make\n  // registering events on such objects more convenient.\n  function eventMixin(ctor) {\n    ctor.prototype.on = function(type, f) {on(this, type, f);};\n    ctor.prototype.off = function(type, f) {off(this, type, f);};\n  }\n\n  // MISC UTILITIES\n\n  // Number of pixels added to scroller and sizer to hide scrollbar\n  var scrollerGap = 30;\n\n  // Returned or thrown by various protocols to signal \'I\'m not\n  // handling this\'.\n  var Pass = CodeMirror.Pass = {toString: function(){return "CodeMirror.Pass";}};\n\n  // Reused option objects for setSelection & friends\n  var sel_dontScroll = {scroll: false}, sel_mouse = {origin: "*mouse"}, sel_move = {origin: "+move"};\n\n  function Delayed() {this.id = null;}\n  Delayed.prototype.set = function(ms, f) {\n    clearTimeout(this.id);\n    this.id = setTimeout(f, ms);\n  };\n\n  // Counts the column offset in a string, taking tabs into account.\n  // Used mostly to find indentation.\n  var countColumn = CodeMirror.countColumn = function(string, end, tabSize, startIndex, startValue) {\n    if (end == null) {\n      end = string.search(/[^\\s\\u00a0]/);\n      if (end == -1) end = string.length;\n    }\n    for (var i = startIndex || 0, n = startValue || 0;;) {\n      var nextTab = string.indexOf("\\t", i);\n      if (nextTab < 0 || nextTab >= end)\n        return n + (end - i);\n      n += nextTab - i;\n      n += tabSize - (n % tabSize);\n      i = nextTab + 1;\n    }\n  };\n\n  // The inverse of countColumn -- find the offset that corresponds to\n  // a particular column.\n  var findColumn = CodeMirror.findColumn = function(string, goal, tabSize) {\n    for (var pos = 0, col = 0;;) {\n      var nextTab = string.indexOf("\\t", pos);\n      if (nextTab == -1) nextTab = string.length;\n      var skipped = nextTab - pos;\n      if (nextTab == string.length || col + skipped >= goal)\n        return pos + Math.min(skipped, goal - col);\n      col += nextTab - pos;\n      col += tabSize - (col % tabSize);\n      pos = nextTab + 1;\n      if (col >= goal) return pos;\n    }\n  }\n\n  var spaceStrs = [""];\n  function spaceStr(n) {\n    while (spaceStrs.length <= n)\n      spaceStrs.push(lst(spaceStrs) + " ");\n    return spaceStrs[n];\n  }\n\n  function lst(arr) { return arr[arr.length-1]; }\n\n  var selectInput = function(node) { node.select(); };\n  if (ios) // Mobile Safari apparently has a bug where select() is broken.\n    selectInput = function(node) { node.selectionStart = 0; node.selectionEnd = node.value.length; };\n  else if (ie) // Suppress mysterious IE10 errors\n    selectInput = function(node) { try { node.select(); } catch(_e) {} };\n\n  function indexOf(array, elt) {\n    for (var i = 0; i < array.length; ++i)\n      if (array[i] == elt) return i;\n    return -1;\n  }\n  function map(array, f) {\n    var out = [];\n    for (var i = 0; i < array.length; i++) out[i] = f(array[i], i);\n    return out;\n  }\n\n  function nothing() {}\n\n  function createObj(base, props) {\n    var inst;\n    if (Object.create) {\n      inst = Object.create(base);\n    } else {\n      nothing.prototype = base;\n      inst = new nothing();\n    }\n    if (props) copyObj(props, inst);\n    return inst;\n  };\n\n  function copyObj(obj, target, overwrite) {\n    if (!target) target = {};\n    for (var prop in obj)\n      if (obj.hasOwnProperty(prop) && (overwrite !== false || !target.hasOwnProperty(prop)))\n        target[prop] = obj[prop];\n    return target;\n  }\n\n  function bind(f) {\n    var args = Array.prototype.slice.call(arguments, 1);\n    return function(){return f.apply(null, args);};\n  }\n\n  var nonASCIISingleCaseWordChar = /[\\u00df\\u0587\\u0590-\\u05f4\\u0600-\\u06ff\\u3040-\\u309f\\u30a0-\\u30ff\\u3400-\\u4db5\\u4e00-\\u9fcc\\uac00-\\ud7af]/;\n  var isWordCharBasic = CodeMirror.isWordChar = function(ch) {\n    return /\\w/.test(ch) || ch > "\\x80" &&\n      (ch.toUpperCase() != ch.toLowerCase() || nonASCIISingleCaseWordChar.test(ch));\n  };\n  function isWordChar(ch, helper) {\n    if (!helper) return isWordCharBasic(ch);\n    if (helper.source.indexOf("\\\\w") > -1 && isWordCharBasic(ch)) return true;\n    return helper.test(ch);\n  }\n\n  function isEmpty(obj) {\n    for (var n in obj) if (obj.hasOwnProperty(n) && obj[n]) return false;\n    return true;\n  }\n\n  // Extending unicode characters. A series of a non-extending char +\n  // any number of extending chars is treated as a single unit as far\n  // as editing and measuring is concerned. This is not fully correct,\n  // since some scripts/fonts/browsers also treat other configurations\n  // of code points as a group.\n  var extendingChars = /[\\u0300-\\u036f\\u0483-\\u0489\\u0591-\\u05bd\\u05bf\\u05c1\\u05c2\\u05c4\\u05c5\\u05c7\\u0610-\\u061a\\u064b-\\u065e\\u0670\\u06d6-\\u06dc\\u06de-\\u06e4\\u06e7\\u06e8\\u06ea-\\u06ed\\u0711\\u0730-\\u074a\\u07a6-\\u07b0\\u07eb-\\u07f3\\u0816-\\u0819\\u081b-\\u0823\\u0825-\\u0827\\u0829-\\u082d\\u0900-\\u0902\\u093c\\u0941-\\u0948\\u094d\\u0951-\\u0955\\u0962\\u0963\\u0981\\u09bc\\u09be\\u09c1-\\u09c4\\u09cd\\u09d7\\u09e2\\u09e3\\u0a01\\u0a02\\u0a3c\\u0a41\\u0a42\\u0a47\\u0a48\\u0a4b-\\u0a4d\\u0a51\\u0a70\\u0a71\\u0a75\\u0a81\\u0a82\\u0abc\\u0ac1-\\u0ac5\\u0ac7\\u0ac8\\u0acd\\u0ae2\\u0ae3\\u0b01\\u0b3c\\u0b3e\\u0b3f\\u0b41-\\u0b44\\u0b4d\\u0b56\\u0b57\\u0b62\\u0b63\\u0b82\\u0bbe\\u0bc0\\u0bcd\\u0bd7\\u0c3e-\\u0c40\\u0c46-\\u0c48\\u0c4a-\\u0c4d\\u0c55\\u0c56\\u0c62\\u0c63\\u0cbc\\u0cbf\\u0cc2\\u0cc6\\u0ccc\\u0ccd\\u0cd5\\u0cd6\\u0ce2\\u0ce3\\u0d3e\\u0d41-\\u0d44\\u0d4d\\u0d57\\u0d62\\u0d63\\u0dca\\u0dcf\\u0dd2-\\u0dd4\\u0dd6\\u0ddf\\u0e31\\u0e34-\\u0e3a\\u0e47-\\u0e4e\\u0eb1\\u0eb4-\\u0eb9\\u0ebb\\u0ebc\\u0ec8-\\u0ecd\\u0f18\\u0f19\\u0f35\\u0f37\\u0f39\\u0f71-\\u0f7e\\u0f80-\\u0f84\\u0f86\\u0f87\\u0f90-\\u0f97\\u0f99-\\u0fbc\\u0fc6\\u102d-\\u1030\\u1032-\\u1037\\u1039\\u103a\\u103d\\u103e\\u1058\\u1059\\u105e-\\u1060\\u1071-\\u1074\\u1082\\u1085\\u1086\\u108d\\u109d\\u135f\\u1712-\\u1714\\u1732-\\u1734\\u1752\\u1753\\u1772\\u1773\\u17b7-\\u17bd\\u17c6\\u17c9-\\u17d3\\u17dd\\u180b-\\u180d\\u18a9\\u1920-\\u1922\\u1927\\u1928\\u1932\\u1939-\\u193b\\u1a17\\u1a18\\u1a56\\u1a58-\\u1a5e\\u1a60\\u1a62\\u1a65-\\u1a6c\\u1a73-\\u1a7c\\u1a7f\\u1b00-\\u1b03\\u1b34\\u1b36-\\u1b3a\\u1b3c\\u1b42\\u1b6b-\\u1b73\\u1b80\\u1b81\\u1ba2-\\u1ba5\\u1ba8\\u1ba9\\u1c2c-\\u1c33\\u1c36\\u1c37\\u1cd0-\\u1cd2\\u1cd4-\\u1ce0\\u1ce2-\\u1ce8\\u1ced\\u1dc0-\\u1de6\\u1dfd-\\u1dff\\u200c\\u200d\\u20d0-\\u20f0\\u2cef-\\u2cf1\\u2de0-\\u2dff\\u302a-\\u302f\\u3099\\u309a\\ua66f-\\ua672\\ua67c\\ua67d\\ua6f0\\ua6f1\\ua802\\ua806\\ua80b\\ua825\\ua826\\ua8c4\\ua8e0-\\ua8f1\\ua926-\\ua92d\\ua947-\\ua951\\ua980-\\ua982\\ua9b3\\ua9b6-\\ua9b9\\ua9bc\\uaa29-\\uaa2e\\uaa31\\uaa32\\uaa35\\uaa36\\uaa43\\uaa4c\\uaab0\\uaab2-\\uaab4\\uaab7\\uaab8\\uaabe\\uaabf\\uaac1\\uabe5\\uabe8\\uabed\\udc00-\\udfff\\ufb1e\\ufe00-\\ufe0f\\ufe20-\\ufe26\\uff9e\\uff9f]/;\n  function isExtendingChar(ch) { return ch.charCodeAt(0) >= 768 && extendingChars.test(ch); }\n\n  // DOM UTILITIES\n\n  function elt(tag, content, className, style) {\n    var e = document.createElement(tag);\n    if (className) e.className = className;\n    if (style) e.style.cssText = style;\n    if (typeof content == "string") e.appendChild(document.createTextNode(content));\n    else if (content) for (var i = 0; i < content.length; ++i) e.appendChild(content[i]);\n    return e;\n  }\n\n  var range;\n  if (document.createRange) range = function(node, start, end, endNode) {\n    var r = document.createRange();\n    r.setEnd(endNode || node, end);\n    r.setStart(node, start);\n    return r;\n  };\n  else range = function(node, start, end) {\n    var r = document.body.createTextRange();\n    try { r.moveToElementText(node.parentNode); }\n    catch(e) { return r; }\n    r.collapse(true);\n    r.moveEnd("character", end);\n    r.moveStart("character", start);\n    return r;\n  };\n\n  function removeChildren(e) {\n    for (var count = e.childNodes.length; count > 0; --count)\n      e.removeChild(e.firstChild);\n    return e;\n  }\n\n  function removeChildrenAndAdd(parent, e) {\n    return removeChildren(parent).appendChild(e);\n  }\n\n  var contains = CodeMirror.contains = function(parent, child) {\n    if (child.nodeType == 3) // Android browser always returns false when child is a textnode\n      child = child.parentNode;\n    if (parent.contains)\n      return parent.contains(child);\n    do {\n      if (child.nodeType == 11) child = child.host;\n      if (child == parent) return true;\n    } while (child = child.parentNode);\n  };\n\n  function activeElt() {\n    var activeElement = document.activeElement;\n    while (activeElement && activeElement.root && activeElement.root.activeElement)\n      activeElement = activeElement.root.activeElement;\n    return activeElement;\n  }\n  // Older versions of IE throws unspecified error when touching\n  // document.activeElement in some cases (during loading, in iframe)\n  if (ie && ie_version < 11) activeElt = function() {\n    try { return document.activeElement; }\n    catch(e) { return document.body; }\n  };\n\n  function classTest(cls) { return new RegExp("(^|\\\\s)" + cls + "(?:$|\\\\s)\\\\s*"); }\n  var rmClass = CodeMirror.rmClass = function(node, cls) {\n    var current = node.className;\n    var match = classTest(cls).exec(current);\n    if (match) {\n      var after = current.slice(match.index + match[0].length);\n      node.className = current.slice(0, match.index) + (after ? match[1] + after : "");\n    }\n  };\n  var addClass = CodeMirror.addClass = function(node, cls) {\n    var current = node.className;\n    if (!classTest(cls).test(current)) node.className += (current ? " " : "") + cls;\n  };\n  function joinClasses(a, b) {\n    var as = a.split(" ");\n    for (var i = 0; i < as.length; i++)\n      if (as[i] && !classTest(as[i]).test(b)) b += " " + as[i];\n    return b;\n  }\n\n  // WINDOW-WIDE EVENTS\n\n  // These must be handled carefully, because naively registering a\n  // handler for each editor will cause the editors to never be\n  // garbage collected.\n\n  function forEachCodeMirror(f) {\n    if (!document.body.getElementsByClassName) return;\n    var byClass = document.body.getElementsByClassName("CodeMirror");\n    for (var i = 0; i < byClass.length; i++) {\n      var cm = byClass[i].CodeMirror;\n      if (cm) f(cm);\n    }\n  }\n\n  var globalsRegistered = false;\n  function ensureGlobalHandlers() {\n    if (globalsRegistered) return;\n    registerGlobalHandlers();\n    globalsRegistered = true;\n  }\n  function registerGlobalHandlers() {\n    // When the window resizes, we need to refresh active editors.\n    var resizeTimer;\n    on(window, "resize", function() {\n      if (resizeTimer == null) resizeTimer = setTimeout(function() {\n        resizeTimer = null;\n        forEachCodeMirror(onResize);\n      }, 100);\n    });\n    // When the window loses focus, we want to show the editor as blurred\n    on(window, "blur", function() {\n      forEachCodeMirror(onBlur);\n    });\n  }\n\n  // FEATURE DETECTION\n\n  // Detect drag-and-drop\n  var dragAndDrop = function() {\n    // There is *some* kind of drag-and-drop support in IE6-8, but I\n    // couldn\'t get it to work yet.\n    if (ie && ie_version < 9) return false;\n    var div = elt(\'div\');\n    return "draggable" in div || "dragDrop" in div;\n  }();\n\n  var zwspSupported;\n  function zeroWidthElement(measure) {\n    if (zwspSupported == null) {\n      var test = elt("span", "\\u200b");\n      removeChildrenAndAdd(measure, elt("span", [test, document.createTextNode("x")]));\n      if (measure.firstChild.offsetHeight != 0)\n        zwspSupported = test.offsetWidth <= 1 && test.offsetHeight > 2 && !(ie && ie_version < 8);\n    }\n    var node = zwspSupported ? elt("span", "\\u200b") :\n      elt("span", "\\u00a0", null, "display: inline-block; width: 1px; margin-right: -1px");\n    node.setAttribute("cm-text", "");\n    return node;\n  }\n\n  // Feature-detect IE\'s crummy client rect reporting for bidi text\n  var badBidiRects;\n  function hasBadBidiRects(measure) {\n    if (badBidiRects != null) return badBidiRects;\n    var txt = removeChildrenAndAdd(measure, document.createTextNode("A\\u062eA"));\n    var r0 = range(txt, 0, 1).getBoundingClientRect();\n    if (!r0 || r0.left == r0.right) return false; // Safari returns null in some cases (#2780)\n    var r1 = range(txt, 1, 2).getBoundingClientRect();\n    return badBidiRects = (r1.right - r0.right < 3);\n  }\n\n  // See if "".split is the broken IE version, if so, provide an\n  // alternative way to split lines.\n  var splitLinesAuto = CodeMirror.splitLines = "\\n\\nb".split(/\\n/).length != 3 ? function(string) {\n    var pos = 0, result = [], l = string.length;\n    while (pos <= l) {\n      var nl = string.indexOf("\\n", pos);\n      if (nl == -1) nl = string.length;\n      var line = string.slice(pos, string.charAt(nl - 1) == "\\r" ? nl - 1 : nl);\n      var rt = line.indexOf("\\r");\n      if (rt != -1) {\n        result.push(line.slice(0, rt));\n        pos += rt + 1;\n      } else {\n        result.push(line);\n        pos = nl + 1;\n      }\n    }\n    return result;\n  } : function(string){return string.split(/\\r\\n?|\\n/);};\n\n  var hasSelection = window.getSelection ? function(te) {\n    try { return te.selectionStart != te.selectionEnd; }\n    catch(e) { return false; }\n  } : function(te) {\n    try {var range = te.ownerDocument.selection.createRange();}\n    catch(e) {}\n    if (!range || range.parentElement() != te) return false;\n    return range.compareEndPoints("StartToEnd", range) != 0;\n  };\n\n  var hasCopyEvent = (function() {\n    var e = elt("div");\n    if ("oncopy" in e) return true;\n    e.setAttribute("oncopy", "return;");\n    return typeof e.oncopy == "function";\n  })();\n\n  var badZoomedRects = null;\n  function hasBadZoomedRects(measure) {\n    if (badZoomedRects != null) return badZoomedRects;\n    var node = removeChildrenAndAdd(measure, elt("span", "x"));\n    var normal = node.getBoundingClientRect();\n    var fromRange = range(node, 0, 1).getBoundingClientRect();\n    return badZoomedRects = Math.abs(normal.left - fromRange.left) > 1;\n  }\n\n  // KEY NAMES\n\n  var keyNames = {3: "Enter", 8: "Backspace", 9: "Tab", 13: "Enter", 16: "Shift", 17: "Ctrl", 18: "Alt",\n                  19: "Pause", 20: "CapsLock", 27: "Esc", 32: "Space", 33: "PageUp", 34: "PageDown", 35: "End",\n                  36: "Home", 37: "Left", 38: "Up", 39: "Right", 40: "Down", 44: "PrintScrn", 45: "Insert",\n                  46: "Delete", 59: ";", 61: "=", 91: "Mod", 92: "Mod", 93: "Mod", 107: "=", 109: "-", 127: "Delete",\n                  173: "-", 186: ";", 187: "=", 188: ",", 189: "-", 190: ".", 191: "/", 192: "`", 219: "[", 220: "\\\\",\n                  221: "]", 222: "\'", 63232: "Up", 63233: "Down", 63234: "Left", 63235: "Right", 63272: "Delete",\n                  63273: "Home", 63275: "End", 63276: "PageUp", 63277: "PageDown", 63302: "Insert"};\n  CodeMirror.keyNames = keyNames;\n  (function() {\n    // Number keys\n    for (var i = 0; i < 10; i++) keyNames[i + 48] = keyNames[i + 96] = String(i);\n    // Alphabetic keys\n    for (var i = 65; i <= 90; i++) keyNames[i] = String.fromCharCode(i);\n    // Function keys\n    for (var i = 1; i <= 12; i++) keyNames[i + 111] = keyNames[i + 63235] = "F" + i;\n  })();\n\n  // BIDI HELPERS\n\n  function iterateBidiSections(order, from, to, f) {\n    if (!order) return f(from, to, "ltr");\n    var found = false;\n    for (var i = 0; i < order.length; ++i) {\n      var part = order[i];\n      if (part.from < to && part.to > from || from == to && part.to == from) {\n        f(Math.max(part.from, from), Math.min(part.to, to), part.level == 1 ? "rtl" : "ltr");\n        found = true;\n      }\n    }\n    if (!found) f(from, to, "ltr");\n  }\n\n  function bidiLeft(part) { return part.level % 2 ? part.to : part.from; }\n  function bidiRight(part) { return part.level % 2 ? part.from : part.to; }\n\n  function lineLeft(line) { var order = getOrder(line); return order ? bidiLeft(order[0]) : 0; }\n  function lineRight(line) {\n    var order = getOrder(line);\n    if (!order) return line.text.length;\n    return bidiRight(lst(order));\n  }\n\n  function lineStart(cm, lineN) {\n    var line = getLine(cm.doc, lineN);\n    var visual = visualLine(line);\n    if (visual != line) lineN = lineNo(visual);\n    var order = getOrder(visual);\n    var ch = !order ? 0 : order[0].level % 2 ? lineRight(visual) : lineLeft(visual);\n    return Pos(lineN, ch);\n  }\n  function lineEnd(cm, lineN) {\n    var merged, line = getLine(cm.doc, lineN);\n    while (merged = collapsedSpanAtEnd(line)) {\n      line = merged.find(1, true).line;\n      lineN = null;\n    }\n    var order = getOrder(line);\n    var ch = !order ? line.text.length : order[0].level % 2 ? lineLeft(line) : lineRight(line);\n    return Pos(lineN == null ? lineNo(line) : lineN, ch);\n  }\n  function lineStartSmart(cm, pos) {\n    var start = lineStart(cm, pos.line);\n    var line = getLine(cm.doc, start.line);\n    var order = getOrder(line);\n    if (!order || order[0].level == 0) {\n      var firstNonWS = Math.max(0, line.text.search(/\\S/));\n      var inWS = pos.line == start.line && pos.ch <= firstNonWS && pos.ch;\n      return Pos(start.line, inWS ? 0 : firstNonWS);\n    }\n    return start;\n  }\n\n  function compareBidiLevel(order, a, b) {\n    var linedir = order[0].level;\n    if (a == linedir) return true;\n    if (b == linedir) return false;\n    return a < b;\n  }\n  var bidiOther;\n  function getBidiPartAt(order, pos) {\n    bidiOther = null;\n    for (var i = 0, found; i < order.length; ++i) {\n      var cur = order[i];\n      if (cur.from < pos && cur.to > pos) return i;\n      if ((cur.from == pos || cur.to == pos)) {\n        if (found == null) {\n          found = i;\n        } else if (compareBidiLevel(order, cur.level, order[found].level)) {\n          if (cur.from != cur.to) bidiOther = found;\n          return i;\n        } else {\n          if (cur.from != cur.to) bidiOther = i;\n          return found;\n        }\n      }\n    }\n    return found;\n  }\n\n  function moveInLine(line, pos, dir, byUnit) {\n    if (!byUnit) return pos + dir;\n    do pos += dir;\n    while (pos > 0 && isExtendingChar(line.text.charAt(pos)));\n    return pos;\n  }\n\n  // This is needed in order to move \'visually\' through bi-directional\n  // text -- i.e., pressing left should make the cursor go left, even\n  // when in RTL text. The tricky part is the \'jumps\', where RTL and\n  // LTR text touch each other. This often requires the cursor offset\n  // to move more than one unit, in order to visually move one unit.\n  function moveVisually(line, start, dir, byUnit) {\n    var bidi = getOrder(line);\n    if (!bidi) return moveLogically(line, start, dir, byUnit);\n    var pos = getBidiPartAt(bidi, start), part = bidi[pos];\n    var target = moveInLine(line, start, part.level % 2 ? -dir : dir, byUnit);\n\n    for (;;) {\n      if (target > part.from && target < part.to) return target;\n      if (target == part.from || target == part.to) {\n        if (getBidiPartAt(bidi, target) == pos) return target;\n        part = bidi[pos += dir];\n        return (dir > 0) == part.level % 2 ? part.to : part.from;\n      } else {\n        part = bidi[pos += dir];\n        if (!part) return null;\n        if ((dir > 0) == part.level % 2)\n          target = moveInLine(line, part.to, -1, byUnit);\n        else\n          target = moveInLine(line, part.from, 1, byUnit);\n      }\n    }\n  }\n\n  function moveLogically(line, start, dir, byUnit) {\n    var target = start + dir;\n    if (byUnit) while (target > 0 && isExtendingChar(line.text.charAt(target))) target += dir;\n    return target < 0 || target > line.text.length ? null : target;\n  }\n\n  // Bidirectional ordering algorithm\n  // See http://unicode.org/reports/tr9/tr9-13.html for the algorithm\n  // that this (partially) implements.\n\n  // One-char codes used for character types:\n  // L (L):   Left-to-Right\n  // R (R):   Right-to-Left\n  // r (AL):  Right-to-Left Arabic\n  // 1 (EN):  European Number\n  // + (ES):  European Number Separator\n  // % (ET):  European Number Terminator\n  // n (AN):  Arabic Number\n  // , (CS):  Common Number Separator\n  // m (NSM): Non-Spacing Mark\n  // b (BN):  Boundary Neutral\n  // s (B):   Paragraph Separator\n  // t (S):   Segment Separator\n  // w (WS):  Whitespace\n  // N (ON):  Other Neutrals\n\n  // Returns null if characters are ordered as they appear\n  // (left-to-right), or an array of sections ({from, to, level}\n  // objects) in the order in which they occur visually.\n  var bidiOrdering = (function() {\n    // Character types for codepoints 0 to 0xff\n    var lowTypes = "bbbbbbbbbtstwsbbbbbbbbbbbbbbssstwNN%%%NNNNNN,N,N1111111111NNNNNNNLLLLLLLLLLLLLLLLLLLLLLLLLLNNNNNNLLLLLLLLLLLLLLLLLLLLLLLLLLNNNNbbbbbbsbbbbbbbbbbbbbbbbbbbbbbbbbb,N%%%%NNNNLNNNNN%%11NLNNN1LNNNNNLLLLLLLLLLLLLLLLLLLLLLLNLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLN";\n    // Character types for codepoints 0x600 to 0x6ff\n    var arabicTypes = "rrrrrrrrrrrr,rNNmmmmmmrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrmmmmmmmmmmmmmmrrrrrrrnnnnnnnnnn%nnrrrmrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrmmmmmmmmmmmmmmmmmmmNmmmm";\n    function charType(code) {\n      if (code <= 0xf7) return lowTypes.charAt(code);\n      else if (0x590 <= code && code <= 0x5f4) return "R";\n      else if (0x600 <= code && code <= 0x6ed) return arabicTypes.charAt(code - 0x600);\n      else if (0x6ee <= code && code <= 0x8ac) return "r";\n      else if (0x2000 <= code && code <= 0x200b) return "w";\n      else if (code == 0x200c) return "b";\n      else return "L";\n    }\n\n    var bidiRE = /[\\u0590-\\u05f4\\u0600-\\u06ff\\u0700-\\u08ac]/;\n    var isNeutral = /[stwN]/, isStrong = /[LRr]/, countsAsLeft = /[Lb1n]/, countsAsNum = /[1n]/;\n    // Browsers seem to always treat the boundaries of block elements as being L.\n    var outerType = "L";\n\n    function BidiSpan(level, from, to) {\n      this.level = level;\n      this.from = from; this.to = to;\n    }\n\n    return function(str) {\n      if (!bidiRE.test(str)) return false;\n      var len = str.length, types = [];\n      for (var i = 0, type; i < len; ++i)\n        types.push(type = charType(str.charCodeAt(i)));\n\n      // W1. Examine each non-spacing mark (NSM) in the level run, and\n      // change the type of the NSM to the type of the previous\n      // character. If the NSM is at the start of the level run, it will\n      // get the type of sor.\n      for (var i = 0, prev = outerType; i < len; ++i) {\n        var type = types[i];\n        if (type == "m") types[i] = prev;\n        else prev = type;\n      }\n\n      // W2. Search backwards from each instance of a European number\n      // until the first strong type (R, L, AL, or sor) is found. If an\n      // AL is found, change the type of the European number to Arabic\n      // number.\n      // W3. Change all ALs to R.\n      for (var i = 0, cur = outerType; i < len; ++i) {\n        var type = types[i];\n        if (type == "1" && cur == "r") types[i] = "n";\n        else if (isStrong.test(type)) { cur = type; if (type == "r") types[i] = "R"; }\n      }\n\n      // W4. A single European separator between two European numbers\n      // changes to a European number. A single common separator between\n      // two numbers of the same type changes to that type.\n      for (var i = 1, prev = types[0]; i < len - 1; ++i) {\n        var type = types[i];\n        if (type == "+" && prev == "1" && types[i+1] == "1") types[i] = "1";\n        else if (type == "," && prev == types[i+1] &&\n                 (prev == "1" || prev == "n")) types[i] = prev;\n        prev = type;\n      }\n\n      // W5. A sequence of European terminators adjacent to European\n      // numbers changes to all European numbers.\n      // W6. Otherwise, separators and terminators change to Other\n      // Neutral.\n      for (var i = 0; i < len; ++i) {\n        var type = types[i];\n        if (type == ",") types[i] = "N";\n        else if (type == "%") {\n          for (var end = i + 1; end < len && types[end] == "%"; ++end) {}\n          var replace = (i && types[i-1] == "!") || (end < len && types[end] == "1") ? "1" : "N";\n          for (var j = i; j < end; ++j) types[j] = replace;\n          i = end - 1;\n        }\n      }\n\n      // W7. Search backwards from each instance of a European number\n      // until the first strong type (R, L, or sor) is found. If an L is\n      // found, then change the type of the European number to L.\n      for (var i = 0, cur = outerType; i < len; ++i) {\n        var type = types[i];\n        if (cur == "L" && type == "1") types[i] = "L";\n        else if (isStrong.test(type)) cur = type;\n      }\n\n      // N1. A sequence of neutrals takes the direction of the\n      // surrounding strong text if the text on both sides has the same\n      // direction. European and Arabic numbers act as if they were R in\n      // terms of their influence on neutrals. Start-of-level-run (sor)\n      // and end-of-level-run (eor) are used at level run boundaries.\n      // N2. Any remaining neutrals take the embedding direction.\n      for (var i = 0; i < len; ++i) {\n        if (isNeutral.test(types[i])) {\n          for (var end = i + 1; end < len && isNeutral.test(types[end]); ++end) {}\n          var before = (i ? types[i-1] : outerType) == "L";\n          var after = (end < len ? types[end] : outerType) == "L";\n          var replace = before || after ? "L" : "R";\n          for (var j = i; j < end; ++j) types[j] = replace;\n          i = end - 1;\n        }\n      }\n\n      // Here we depart from the documented algorithm, in order to avoid\n      // building up an actual levels array. Since there are only three\n      // levels (0, 1, 2) in an implementation that doesn\'t take\n      // explicit embedding into account, we can build up the order on\n      // the fly, without following the level-based algorithm.\n      var order = [], m;\n      for (var i = 0; i < len;) {\n        if (countsAsLeft.test(types[i])) {\n          var start = i;\n          for (++i; i < len && countsAsLeft.test(types[i]); ++i) {}\n          order.push(new BidiSpan(0, start, i));\n        } else {\n          var pos = i, at = order.length;\n          for (++i; i < len && types[i] != "L"; ++i) {}\n          for (var j = pos; j < i;) {\n            if (countsAsNum.test(types[j])) {\n              if (pos < j) order.splice(at, 0, new BidiSpan(1, pos, j));\n              var nstart = j;\n              for (++j; j < i && countsAsNum.test(types[j]); ++j) {}\n              order.splice(at, 0, new BidiSpan(2, nstart, j));\n              pos = j;\n            } else ++j;\n          }\n          if (pos < i) order.splice(at, 0, new BidiSpan(1, pos, i));\n        }\n      }\n      if (order[0].level == 1 && (m = str.match(/^\\s+/))) {\n        order[0].from = m[0].length;\n        order.unshift(new BidiSpan(0, 0, m[0].length));\n      }\n      if (lst(order).level == 1 && (m = str.match(/\\s+$/))) {\n        lst(order).to -= m[0].length;\n        order.push(new BidiSpan(0, len - m[0].length, len));\n      }\n      if (order[0].level == 2)\n        order.unshift(new BidiSpan(1, order[0].to, order[0].to));\n      if (order[0].level != lst(order).level)\n        order.push(new BidiSpan(order[0].level, len, len));\n\n      return order;\n    };\n  })();\n\n  // THE END\n\n  CodeMirror.version = "5.6.1";\n\n  return CodeMirror;\n});\n\n//# sourceURL=/thirdparty/CodeMirror/lib/codemirror.js'),
eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/edit/closebrackets\',["../../lib/codemirror"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  var defaults = {\n    pairs: "()[]{}\'\'\\"\\"",\n    triples: "",\n    explode: "[]{}"\n  };\n\n  var Pos = CodeMirror.Pos;\n\n  CodeMirror.defineOption("autoCloseBrackets", false, function(cm, val, old) {\n    if (old && old != CodeMirror.Init) {\n      cm.removeKeyMap(keyMap);\n      cm.state.closeBrackets = null;\n    }\n    if (val) {\n      cm.state.closeBrackets = val;\n      cm.addKeyMap(keyMap);\n    }\n  });\n\n  function getOption(conf, name) {\n    if (name == "pairs" && typeof conf == "string") return conf;\n    if (typeof conf == "object" && conf[name] != null) return conf[name];\n    return defaults[name];\n  }\n\n  var bind = defaults.pairs + "`";\n  var keyMap = {Backspace: handleBackspace, Enter: handleEnter};\n  for (var i = 0; i < bind.length; i++)\n    keyMap["\'" + bind.charAt(i) + "\'"] = handler(bind.charAt(i));\n\n  function handler(ch) {\n    return function(cm) { return handleChar(cm, ch); };\n  }\n\n  function getConfig(cm) {\n    var deflt = cm.state.closeBrackets;\n    if (!deflt) return null;\n    var mode = cm.getModeAt(cm.getCursor());\n    return mode.closeBrackets || deflt;\n  }\n\n  function handleBackspace(cm) {\n    var conf = getConfig(cm);\n    if (!conf || cm.getOption("disableInput")) return CodeMirror.Pass;\n\n    var pairs = getOption(conf, "pairs");\n    var ranges = cm.listSelections();\n    for (var i = 0; i < ranges.length; i++) {\n      if (!ranges[i].empty()) return CodeMirror.Pass;\n      var around = charsAround(cm, ranges[i].head);\n      if (!around || pairs.indexOf(around) % 2 != 0) return CodeMirror.Pass;\n    }\n    for (var i = ranges.length - 1; i >= 0; i--) {\n      var cur = ranges[i].head;\n      cm.replaceRange("", Pos(cur.line, cur.ch - 1), Pos(cur.line, cur.ch + 1));\n    }\n  }\n\n  function handleEnter(cm) {\n    var conf = getConfig(cm);\n    var explode = conf && getOption(conf, "explode");\n    if (!explode || cm.getOption("disableInput")) return CodeMirror.Pass;\n\n    var ranges = cm.listSelections();\n    for (var i = 0; i < ranges.length; i++) {\n      if (!ranges[i].empty()) return CodeMirror.Pass;\n      var around = charsAround(cm, ranges[i].head);\n      if (!around || explode.indexOf(around) % 2 != 0) return CodeMirror.Pass;\n    }\n    cm.operation(function() {\n      cm.replaceSelection("\\n\\n", null);\n      cm.execCommand("goCharLeft");\n      ranges = cm.listSelections();\n      for (var i = 0; i < ranges.length; i++) {\n        var line = ranges[i].head.line;\n        cm.indentLine(line, null, true);\n        cm.indentLine(line + 1, null, true);\n      }\n    });\n  }\n\n  function handleChar(cm, ch) {\n    var conf = getConfig(cm);\n    if (!conf || cm.getOption("disableInput")) return CodeMirror.Pass;\n\n    var pairs = getOption(conf, "pairs");\n    var pos = pairs.indexOf(ch);\n    if (pos == -1) return CodeMirror.Pass;\n    var triples = getOption(conf, "triples");\n\n    var identical = pairs.charAt(pos + 1) == ch;\n    var ranges = cm.listSelections();\n    var opening = pos % 2 == 0;\n\n    var type, next;\n    for (var i = 0; i < ranges.length; i++) {\n      var range = ranges[i], cur = range.head, curType;\n      var next = cm.getRange(cur, Pos(cur.line, cur.ch + 1));\n      if (opening && !range.empty()) {\n        curType = "surround";\n      } else if ((identical || !opening) && next == ch) {\n        if (triples.indexOf(ch) >= 0 && cm.getRange(cur, Pos(cur.line, cur.ch + 3)) == ch + ch + ch)\n          curType = "skipThree";\n        else\n          curType = "skip";\n      } else if (identical && cur.ch > 1 && triples.indexOf(ch) >= 0 &&\n                 cm.getRange(Pos(cur.line, cur.ch - 2), cur) == ch + ch &&\n                 (cur.ch <= 2 || cm.getRange(Pos(cur.line, cur.ch - 3), Pos(cur.line, cur.ch - 2)) != ch)) {\n        curType = "addFour";\n      } else if (identical) {\n        if (!CodeMirror.isWordChar(next) && enteringString(cm, cur, ch)) curType = "both";\n        else return CodeMirror.Pass;\n      } else if (opening && (cm.getLine(cur.line).length == cur.ch ||\n                             isClosingBracket(next, pairs) ||\n                             /\\s/.test(next))) {\n        curType = "both";\n      } else {\n        return CodeMirror.Pass;\n      }\n      if (!type) type = curType;\n      else if (type != curType) return CodeMirror.Pass;\n    }\n\n    var left = pos % 2 ? pairs.charAt(pos - 1) : ch;\n    var right = pos % 2 ? ch : pairs.charAt(pos + 1);\n    cm.operation(function() {\n      if (type == "skip") {\n        cm.execCommand("goCharRight");\n      } else if (type == "skipThree") {\n        for (var i = 0; i < 3; i++)\n          cm.execCommand("goCharRight");\n      } else if (type == "surround") {\n        var sels = cm.getSelections();\n        for (var i = 0; i < sels.length; i++)\n          sels[i] = left + sels[i] + right;\n        cm.replaceSelections(sels, "around");\n      } else if (type == "both") {\n        cm.replaceSelection(left + right, null);\n        cm.triggerElectric(left + right);\n        cm.execCommand("goCharLeft");\n      } else if (type == "addFour") {\n        cm.replaceSelection(left + left + left + left, "before");\n        cm.execCommand("goCharRight");\n      }\n    });\n  }\n\n  function isClosingBracket(ch, pairs) {\n    var pos = pairs.lastIndexOf(ch);\n    return pos > -1 && pos % 2 == 1;\n  }\n\n  function charsAround(cm, pos) {\n    var str = cm.getRange(Pos(pos.line, pos.ch - 1),\n                          Pos(pos.line, pos.ch + 1));\n    return str.length == 2 ? str : null;\n  }\n\n  // Project the token type that will exists after the given char is\n  // typed, and use it to determine whether it would cause the start\n  // of a string token.\n  function enteringString(cm, pos, ch) {\n    var line = cm.getLine(pos.line);\n    var token = cm.getTokenAt(pos);\n    if (/\\bstring2?\\b/.test(token.type)) return false;\n    var stream = new CodeMirror.StringStream(line.slice(0, pos.ch) + ch + line.slice(pos.ch), 4);\n    stream.pos = stream.start = token.start;\n    for (;;) {\n      var type1 = cm.getMode().token(stream, token.state);\n      if (stream.pos >= pos.ch + 1) return /\\bstring2?\\b/.test(type1);\n      stream.start = stream.pos;\n    }\n  }\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/edit/closebrackets.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/fold/xml-fold\',["../../lib/codemirror"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  "use strict";\n\n  var Pos = CodeMirror.Pos;\n  function cmp(a, b) { return a.line - b.line || a.ch - b.ch; }\n\n  var nameStartChar = "A-Z_a-z\\\\u00C0-\\\\u00D6\\\\u00D8-\\\\u00F6\\\\u00F8-\\\\u02FF\\\\u0370-\\\\u037D\\\\u037F-\\\\u1FFF\\\\u200C-\\\\u200D\\\\u2070-\\\\u218F\\\\u2C00-\\\\u2FEF\\\\u3001-\\\\uD7FF\\\\uF900-\\\\uFDCF\\\\uFDF0-\\\\uFFFD";\n  var nameChar = nameStartChar + "\\-\\:\\.0-9\\\\u00B7\\\\u0300-\\\\u036F\\\\u203F-\\\\u2040";\n  var xmlTagStart = new RegExp("<(/?)([" + nameStartChar + "][" + nameChar + "]*)", "g");\n\n  function Iter(cm, line, ch, range) {\n    this.line = line; this.ch = ch;\n    this.cm = cm; this.text = cm.getLine(line);\n    this.min = range ? range.from : cm.firstLine();\n    this.max = range ? range.to - 1 : cm.lastLine();\n  }\n\n  function tagAt(iter, ch) {\n    var type = iter.cm.getTokenTypeAt(Pos(iter.line, ch));\n    return type && /\\btag\\b/.test(type);\n  }\n\n  function nextLine(iter) {\n    if (iter.line >= iter.max) return;\n    iter.ch = 0;\n    iter.text = iter.cm.getLine(++iter.line);\n    return true;\n  }\n  function prevLine(iter) {\n    if (iter.line <= iter.min) return;\n    iter.text = iter.cm.getLine(--iter.line);\n    iter.ch = iter.text.length;\n    return true;\n  }\n\n  function toTagEnd(iter) {\n    for (;;) {\n      var gt = iter.text.indexOf(">", iter.ch);\n      if (gt == -1) { if (nextLine(iter)) continue; else return; }\n      if (!tagAt(iter, gt + 1)) { iter.ch = gt + 1; continue; }\n      var lastSlash = iter.text.lastIndexOf("/", gt);\n      var selfClose = lastSlash > -1 && !/\\S/.test(iter.text.slice(lastSlash + 1, gt));\n      iter.ch = gt + 1;\n      return selfClose ? "selfClose" : "regular";\n    }\n  }\n  function toTagStart(iter) {\n    for (;;) {\n      var lt = iter.ch ? iter.text.lastIndexOf("<", iter.ch - 1) : -1;\n      if (lt == -1) { if (prevLine(iter)) continue; else return; }\n      if (!tagAt(iter, lt + 1)) { iter.ch = lt; continue; }\n      xmlTagStart.lastIndex = lt;\n      iter.ch = lt;\n      var match = xmlTagStart.exec(iter.text);\n      if (match && match.index == lt) return match;\n    }\n  }\n\n  function toNextTag(iter) {\n    for (;;) {\n      xmlTagStart.lastIndex = iter.ch;\n      var found = xmlTagStart.exec(iter.text);\n      if (!found) { if (nextLine(iter)) continue; else return; }\n      if (!tagAt(iter, found.index + 1)) { iter.ch = found.index + 1; continue; }\n      iter.ch = found.index + found[0].length;\n      return found;\n    }\n  }\n  function toPrevTag(iter) {\n    for (;;) {\n      var gt = iter.ch ? iter.text.lastIndexOf(">", iter.ch - 1) : -1;\n      if (gt == -1) { if (prevLine(iter)) continue; else return; }\n      if (!tagAt(iter, gt + 1)) { iter.ch = gt; continue; }\n      var lastSlash = iter.text.lastIndexOf("/", gt);\n      var selfClose = lastSlash > -1 && !/\\S/.test(iter.text.slice(lastSlash + 1, gt));\n      iter.ch = gt + 1;\n      return selfClose ? "selfClose" : "regular";\n    }\n  }\n\n  function findMatchingClose(iter, tag) {\n    var stack = [];\n    for (;;) {\n      var next = toNextTag(iter), end, startLine = iter.line, startCh = iter.ch - (next ? next[0].length : 0);\n      if (!next || !(end = toTagEnd(iter))) return;\n      if (end == "selfClose") continue;\n      if (next[1]) { // closing tag\n        for (var i = stack.length - 1; i >= 0; --i) if (stack[i] == next[2]) {\n          stack.length = i;\n          break;\n        }\n        if (i < 0 && (!tag || tag == next[2])) return {\n          tag: next[2],\n          from: Pos(startLine, startCh),\n          to: Pos(iter.line, iter.ch)\n        };\n      } else { // opening tag\n        stack.push(next[2]);\n      }\n    }\n  }\n  function findMatchingOpen(iter, tag) {\n    var stack = [];\n    for (;;) {\n      var prev = toPrevTag(iter);\n      if (!prev) return;\n      if (prev == "selfClose") { toTagStart(iter); continue; }\n      var endLine = iter.line, endCh = iter.ch;\n      var start = toTagStart(iter);\n      if (!start) return;\n      if (start[1]) { // closing tag\n        stack.push(start[2]);\n      } else { // opening tag\n        for (var i = stack.length - 1; i >= 0; --i) if (stack[i] == start[2]) {\n          stack.length = i;\n          break;\n        }\n        if (i < 0 && (!tag || tag == start[2])) return {\n          tag: start[2],\n          from: Pos(iter.line, iter.ch),\n          to: Pos(endLine, endCh)\n        };\n      }\n    }\n  }\n\n  CodeMirror.registerHelper("fold", "xml", function(cm, start) {\n    var iter = new Iter(cm, start.line, 0);\n    for (;;) {\n      var openTag = toNextTag(iter), end;\n      if (!openTag || iter.line != start.line || !(end = toTagEnd(iter))) return;\n      if (!openTag[1] && end != "selfClose") {\n        var start = Pos(iter.line, iter.ch);\n        var close = findMatchingClose(iter, openTag[2]);\n        return close && {from: start, to: close.from};\n      }\n    }\n  });\n  CodeMirror.findMatchingTag = function(cm, pos, range) {\n    var iter = new Iter(cm, pos.line, pos.ch, range);\n    if (iter.text.indexOf(">") == -1 && iter.text.indexOf("<") == -1) return;\n    var end = toTagEnd(iter), to = end && Pos(iter.line, iter.ch);\n    var start = end && toTagStart(iter);\n    if (!end || !start || cmp(iter, pos) > 0) return;\n    var here = {from: Pos(iter.line, iter.ch), to: to, tag: start[2]};\n    if (end == "selfClose") return {open: here, close: null, at: "open"};\n\n    if (start[1]) { // closing tag\n      return {open: findMatchingOpen(iter, start[2]), close: here, at: "close"};\n    } else { // opening tag\n      iter = new Iter(cm, to.line, to.ch, range);\n      return {open: here, close: findMatchingClose(iter, start[2]), at: "open"};\n    }\n  };\n\n  CodeMirror.findEnclosingTag = function(cm, pos, range) {\n    var iter = new Iter(cm, pos.line, pos.ch, range);\n    for (;;) {\n      var open = findMatchingOpen(iter);\n      if (!open) break;\n      var forward = new Iter(cm, pos.line, pos.ch, range);\n      var close = findMatchingClose(forward, open.tag);\n      if (close) return {open: open, close: close};\n    }\n  };\n\n  // Used by addon/edit/closetag.js\n  CodeMirror.scanForClosingTag = function(cm, pos, name, end) {\n    var iter = new Iter(cm, pos.line, pos.ch, end ? {from: 0, to: end} : null);\n    return findMatchingClose(iter, name);\n  };\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/fold/xml-fold.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n/**\n * Tag-closer extension for CodeMirror.\n *\n * This extension adds an "autoCloseTags" option that can be set to\n * either true to get the default behavior, or an object to further\n * configure its behavior.\n *\n * These are supported options:\n *\n * `whenClosing` (default true)\n *   Whether to autoclose when the \'/\' of a closing tag is typed.\n * `whenOpening` (default true)\n *   Whether to autoclose the tag when the final \'>\' of an opening\n *   tag is typed.\n * `dontCloseTags` (default is empty tags for HTML, none for XML)\n *   An array of tag names that should not be autoclosed.\n * `indentTags` (default is block tags for HTML, none for XML)\n *   An array of tag names that should, when opened, cause a\n *   blank line to be added inside the tag, and the blank line and\n *   closing line to be indented.\n *\n * See demos/closetag.html for a usage example.\n */\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"), require("../fold/xml-fold"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/edit/closetag\',["../../lib/codemirror", "../fold/xml-fold"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  CodeMirror.defineOption("autoCloseTags", false, function(cm, val, old) {\n    if (old != CodeMirror.Init && old)\n      cm.removeKeyMap("autoCloseTags");\n    if (!val) return;\n    var map = {name: "autoCloseTags"};\n    if (typeof val != "object" || val.whenClosing)\n      map["\'/\'"] = function(cm) { return autoCloseSlash(cm); };\n    if (typeof val != "object" || val.whenOpening)\n      map["\'>\'"] = function(cm) { return autoCloseGT(cm); };\n    cm.addKeyMap(map);\n  });\n\n  var htmlDontClose = ["area", "base", "br", "col", "command", "embed", "hr", "img", "input", "keygen", "link", "meta", "param",\n                       "source", "track", "wbr"];\n  var htmlIndent = ["applet", "blockquote", "body", "button", "div", "dl", "fieldset", "form", "frameset", "h1", "h2", "h3", "h4",\n                    "h5", "h6", "head", "html", "iframe", "layer", "legend", "object", "ol", "p", "select", "table", "ul"];\n\n  function autoCloseGT(cm) {\n    if (cm.getOption("disableInput")) return CodeMirror.Pass;\n    var ranges = cm.listSelections(), replacements = [];\n    for (var i = 0; i < ranges.length; i++) {\n      if (!ranges[i].empty()) return CodeMirror.Pass;\n      var pos = ranges[i].head, tok = cm.getTokenAt(pos);\n      var inner = CodeMirror.innerMode(cm.getMode(), tok.state), state = inner.state;\n      if (inner.mode.name != "xml" || !state.tagName) return CodeMirror.Pass;\n\n      var opt = cm.getOption("autoCloseTags"), html = inner.mode.configuration == "html";\n      var dontCloseTags = (typeof opt == "object" && opt.dontCloseTags) || (html && htmlDontClose);\n      var indentTags = (typeof opt == "object" && opt.indentTags) || (html && htmlIndent);\n\n      var tagName = state.tagName;\n      if (tok.end > pos.ch) tagName = tagName.slice(0, tagName.length - tok.end + pos.ch);\n      var lowerTagName = tagName.toLowerCase();\n      // Don\'t process the \'>\' at the end of an end-tag or self-closing tag\n      if (!tagName ||\n          tok.type == "string" && (tok.end != pos.ch || !/[\\"\\\']/.test(tok.string.charAt(tok.string.length - 1)) || tok.string.length == 1) ||\n          tok.type == "tag" && state.type == "closeTag" ||\n          tok.string.indexOf("/") == (tok.string.length - 1) || // match something like <someTagName />\n          dontCloseTags && indexOf(dontCloseTags, lowerTagName) > -1 ||\n          closingTagExists(cm, tagName, pos, state, true))\n        return CodeMirror.Pass;\n\n      var indent = indentTags && indexOf(indentTags, lowerTagName) > -1;\n      replacements[i] = {indent: indent,\n                         text: ">" + (indent ? "\\n\\n" : "") + "</" + tagName + ">",\n                         newPos: indent ? CodeMirror.Pos(pos.line + 1, 0) : CodeMirror.Pos(pos.line, pos.ch + 1)};\n    }\n\n    for (var i = ranges.length - 1; i >= 0; i--) {\n      var info = replacements[i];\n      cm.replaceRange(info.text, ranges[i].head, ranges[i].anchor, "+insert");\n      var sel = cm.listSelections().slice(0);\n      sel[i] = {head: info.newPos, anchor: info.newPos};\n      cm.setSelections(sel);\n      if (info.indent) {\n        cm.indentLine(info.newPos.line, null, true);\n        cm.indentLine(info.newPos.line + 1, null, true);\n      }\n    }\n  }\n\n  function autoCloseCurrent(cm, typingSlash) {\n    var ranges = cm.listSelections(), replacements = [];\n    var head = typingSlash ? "/" : "</";\n    for (var i = 0; i < ranges.length; i++) {\n      if (!ranges[i].empty()) return CodeMirror.Pass;\n      var pos = ranges[i].head, tok = cm.getTokenAt(pos);\n      var inner = CodeMirror.innerMode(cm.getMode(), tok.state), state = inner.state;\n      if (typingSlash && (tok.type == "string" || tok.string.charAt(0) != "<" ||\n                          tok.start != pos.ch - 1))\n        return CodeMirror.Pass;\n      // Kludge to get around the fact that we are not in XML mode\n      // when completing in JS/CSS snippet in htmlmixed mode. Does not\n      // work for other XML embedded languages (there is no general\n      // way to go from a mixed mode to its current XML state).\n      var replacement;\n      if (inner.mode.name != "xml") {\n        if (cm.getMode().name == "htmlmixed" && inner.mode.name == "javascript")\n          replacement = head + "script";\n        else if (cm.getMode().name == "htmlmixed" && inner.mode.name == "css")\n          replacement = head + "style";\n        else\n          return CodeMirror.Pass;\n      } else {\n        if (!state.context || !state.context.tagName ||\n            closingTagExists(cm, state.context.tagName, pos, state))\n          return CodeMirror.Pass;\n        replacement = head + state.context.tagName;\n      }\n      if (cm.getLine(pos.line).charAt(tok.end) != ">") replacement += ">";\n      replacements[i] = replacement;\n    }\n    cm.replaceSelections(replacements);\n    ranges = cm.listSelections();\n    for (var i = 0; i < ranges.length; i++)\n      if (i == ranges.length - 1 || ranges[i].head.line < ranges[i + 1].head.line)\n        cm.indentLine(ranges[i].head.line);\n  }\n\n  function autoCloseSlash(cm) {\n    if (cm.getOption("disableInput")) return CodeMirror.Pass;\n    return autoCloseCurrent(cm, true);\n  }\n\n  CodeMirror.commands.closeTag = function(cm) { return autoCloseCurrent(cm); };\n\n  function indexOf(collection, elt) {\n    if (collection.indexOf) return collection.indexOf(elt);\n    for (var i = 0, e = collection.length; i < e; ++i)\n      if (collection[i] == elt) return i;\n    return -1;\n  }\n\n  // If xml-fold is loaded, we use its functionality to try and verify\n  // whether a given tag is actually unclosed.\n  function closingTagExists(cm, tagName, pos, state, newTag) {\n    if (!CodeMirror.scanForClosingTag) return false;\n    var end = Math.min(cm.lastLine() + 1, pos.line + 500);\n    var nextClose = CodeMirror.scanForClosingTag(cm, pos, null, end);\n    if (!nextClose || nextClose.tag != tagName) return false;\n    var cx = state.context;\n    // If the immediate wrapping context contains onCx instances of\n    // the same tag, a closing tag only exists if there are at least\n    // that many closing tags of that type following.\n    for (var onCx = newTag ? 1 : 0; cx && cx.tagName == tagName; cx = cx.prev) ++onCx;\n    pos = nextClose.to;\n    for (var i = 1; i < onCx; i++) {\n      var next = CodeMirror.scanForClosingTag(cm, pos, null, end);\n      if (!next || next.tag != tagName) return false;\n      pos = next.to;\n    }\n    return true;\n  }\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/edit/closetag.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/edit/matchbrackets\',["../../lib/codemirror"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  var ie_lt8 = /MSIE \\d/.test(navigator.userAgent) &&\n    (document.documentMode == null || document.documentMode < 8);\n\n  var Pos = CodeMirror.Pos;\n\n  var matching = {"(": ")>", ")": "(<", "[": "]>", "]": "[<", "{": "}>", "}": "{<"};\n\n  function findMatchingBracket(cm, where, strict, config) {\n    var line = cm.getLineHandle(where.line), pos = where.ch - 1;\n    var match = (pos >= 0 && matching[line.text.charAt(pos)]) || matching[line.text.charAt(++pos)];\n    if (!match) return null;\n    var dir = match.charAt(1) == ">" ? 1 : -1;\n    if (strict && (dir > 0) != (pos == where.ch)) return null;\n    var style = cm.getTokenTypeAt(Pos(where.line, pos + 1));\n\n    var found = scanForBracket(cm, Pos(where.line, pos + (dir > 0 ? 1 : 0)), dir, style || null, config);\n    if (found == null) return null;\n    return {from: Pos(where.line, pos), to: found && found.pos,\n            match: found && found.ch == match.charAt(0), forward: dir > 0};\n  }\n\n  // bracketRegex is used to specify which type of bracket to scan\n  // should be a regexp, e.g. /[[\\]]/\n  //\n  // Note: If "where" is on an open bracket, then this bracket is ignored.\n  //\n  // Returns false when no bracket was found, null when it reached\n  // maxScanLines and gave up\n  function scanForBracket(cm, where, dir, style, config) {\n    var maxScanLen = (config && config.maxScanLineLength) || 10000;\n    var maxScanLines = (config && config.maxScanLines) || 1000;\n\n    var stack = [];\n    var re = config && config.bracketRegex ? config.bracketRegex : /[(){}[\\]]/;\n    var lineEnd = dir > 0 ? Math.min(where.line + maxScanLines, cm.lastLine() + 1)\n                          : Math.max(cm.firstLine() - 1, where.line - maxScanLines);\n    for (var lineNo = where.line; lineNo != lineEnd; lineNo += dir) {\n      var line = cm.getLine(lineNo);\n      if (!line) continue;\n      var pos = dir > 0 ? 0 : line.length - 1, end = dir > 0 ? line.length : -1;\n      if (line.length > maxScanLen) continue;\n      if (lineNo == where.line) pos = where.ch - (dir < 0 ? 1 : 0);\n      for (; pos != end; pos += dir) {\n        var ch = line.charAt(pos);\n        if (re.test(ch) && (style === undefined || cm.getTokenTypeAt(Pos(lineNo, pos + 1)) == style)) {\n          var match = matching[ch];\n          if ((match.charAt(1) == ">") == (dir > 0)) stack.push(ch);\n          else if (!stack.length) return {pos: Pos(lineNo, pos), ch: ch};\n          else stack.pop();\n        }\n      }\n    }\n    return lineNo - dir == (dir > 0 ? cm.lastLine() : cm.firstLine()) ? false : null;\n  }\n\n  function matchBrackets(cm, autoclear, config) {\n    // Disable brace matching in long lines, since it\'ll cause hugely slow updates\n    var maxHighlightLen = cm.state.matchBrackets.maxHighlightLineLength || 1000;\n    var marks = [], ranges = cm.listSelections();\n    for (var i = 0; i < ranges.length; i++) {\n      var match = ranges[i].empty() && findMatchingBracket(cm, ranges[i].head, false, config);\n      if (match && cm.getLine(match.from.line).length <= maxHighlightLen) {\n        var style = match.match ? "CodeMirror-matchingbracket" : "CodeMirror-nonmatchingbracket";\n        marks.push(cm.markText(match.from, Pos(match.from.line, match.from.ch + 1), {className: style}));\n        if (match.to && cm.getLine(match.to.line).length <= maxHighlightLen)\n          marks.push(cm.markText(match.to, Pos(match.to.line, match.to.ch + 1), {className: style}));\n      }\n    }\n\n    if (marks.length) {\n      // Kludge to work around the IE bug from issue #1193, where text\n      // input stops going to the textare whever this fires.\n      if (ie_lt8 && cm.state.focused) cm.focus();\n\n      var clear = function() {\n        cm.operation(function() {\n          for (var i = 0; i < marks.length; i++) marks[i].clear();\n        });\n      };\n      if (autoclear) setTimeout(clear, 800);\n      else return clear;\n    }\n  }\n\n  var currentlyHighlighted = null;\n  function doMatchBrackets(cm) {\n    cm.operation(function() {\n      if (currentlyHighlighted) {currentlyHighlighted(); currentlyHighlighted = null;}\n      currentlyHighlighted = matchBrackets(cm, false, cm.state.matchBrackets);\n    });\n  }\n\n  CodeMirror.defineOption("matchBrackets", false, function(cm, val, old) {\n    if (old && old != CodeMirror.Init)\n      cm.off("cursorActivity", doMatchBrackets);\n    if (val) {\n      cm.state.matchBrackets = typeof val == "object" ? val : {};\n      cm.on("cursorActivity", doMatchBrackets);\n    }\n  });\n\n  CodeMirror.defineExtension("matchBrackets", function() {matchBrackets(this, true);});\n  CodeMirror.defineExtension("findMatchingBracket", function(pos, strict, config){\n    return findMatchingBracket(this, pos, strict, config);\n  });\n  CodeMirror.defineExtension("scanForBracket", function(pos, dir, style, config){\n    return scanForBracket(this, pos, dir, style, config);\n  });\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/edit/matchbrackets.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"), require("../fold/xml-fold"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/edit/matchtags\',["../../lib/codemirror", "../fold/xml-fold"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  "use strict";\n\n  CodeMirror.defineOption("matchTags", false, function(cm, val, old) {\n    if (old && old != CodeMirror.Init) {\n      cm.off("cursorActivity", doMatchTags);\n      cm.off("viewportChange", maybeUpdateMatch);\n      clear(cm);\n    }\n    if (val) {\n      cm.state.matchBothTags = typeof val == "object" && val.bothTags;\n      cm.on("cursorActivity", doMatchTags);\n      cm.on("viewportChange", maybeUpdateMatch);\n      doMatchTags(cm);\n    }\n  });\n\n  function clear(cm) {\n    if (cm.state.tagHit) cm.state.tagHit.clear();\n    if (cm.state.tagOther) cm.state.tagOther.clear();\n    cm.state.tagHit = cm.state.tagOther = null;\n  }\n\n  function doMatchTags(cm) {\n    cm.state.failedTagMatch = false;\n    cm.operation(function() {\n      clear(cm);\n      if (cm.somethingSelected()) return;\n      var cur = cm.getCursor(), range = cm.getViewport();\n      range.from = Math.min(range.from, cur.line); range.to = Math.max(cur.line + 1, range.to);\n      var match = CodeMirror.findMatchingTag(cm, cur, range);\n      if (!match) return;\n      if (cm.state.matchBothTags) {\n        var hit = match.at == "open" ? match.open : match.close;\n        if (hit) cm.state.tagHit = cm.markText(hit.from, hit.to, {className: "CodeMirror-matchingtag"});\n      }\n      var other = match.at == "close" ? match.open : match.close;\n      if (other)\n        cm.state.tagOther = cm.markText(other.from, other.to, {className: "CodeMirror-matchingtag"});\n      else\n        cm.state.failedTagMatch = true;\n    });\n  }\n\n  function maybeUpdateMatch(cm) {\n    if (cm.state.failedTagMatch) doMatchTags(cm);\n  }\n\n  CodeMirror.commands.toMatchingTag = function(cm) {\n    var found = CodeMirror.findMatchingTag(cm, cm.getCursor());\n    if (found) {\n      var other = found.at == "close" ? found.open : found.close;\n      if (other) cm.extendSelection(other.to, other.from);\n    }\n  };\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/edit/matchtags.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/mode/multiplex\',["../../lib/codemirror"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n"use strict";\n\nCodeMirror.multiplexingMode = function(outer /*, others */) {\n  // Others should be {open, close, mode [, delimStyle] [, innerStyle]} objects\n  var others = Array.prototype.slice.call(arguments, 1);\n\n  function indexOf(string, pattern, from, returnEnd) {\n    if (typeof pattern == "string") {\n      var found = string.indexOf(pattern, from);\n      return returnEnd && found > -1 ? found + pattern.length : found;\n    }\n    var m = pattern.exec(from ? string.slice(from) : string);\n    return m ? m.index + from + (returnEnd ? m[0].length : 0) : -1;\n  }\n\n  return {\n    startState: function() {\n      return {\n        outer: CodeMirror.startState(outer),\n        innerActive: null,\n        inner: null\n      };\n    },\n\n    copyState: function(state) {\n      return {\n        outer: CodeMirror.copyState(outer, state.outer),\n        innerActive: state.innerActive,\n        inner: state.innerActive && CodeMirror.copyState(state.innerActive.mode, state.inner)\n      };\n    },\n\n    token: function(stream, state) {\n      if (!state.innerActive) {\n        var cutOff = Infinity, oldContent = stream.string;\n        for (var i = 0; i < others.length; ++i) {\n          var other = others[i];\n          var found = indexOf(oldContent, other.open, stream.pos);\n          if (found == stream.pos) {\n            if (!other.parseDelimiters) stream.match(other.open);\n            state.innerActive = other;\n            state.inner = CodeMirror.startState(other.mode, outer.indent ? outer.indent(state.outer, "") : 0);\n            return other.delimStyle;\n          } else if (found != -1 && found < cutOff) {\n            cutOff = found;\n          }\n        }\n        if (cutOff != Infinity) stream.string = oldContent.slice(0, cutOff);\n        var outerToken = outer.token(stream, state.outer);\n        if (cutOff != Infinity) stream.string = oldContent;\n        return outerToken;\n      } else {\n        var curInner = state.innerActive, oldContent = stream.string;\n        if (!curInner.close && stream.sol()) {\n          state.innerActive = state.inner = null;\n          return this.token(stream, state);\n        }\n        var found = curInner.close ? indexOf(oldContent, curInner.close, stream.pos, curInner.parseDelimiters) : -1;\n        if (found == stream.pos && !curInner.parseDelimiters) {\n          stream.match(curInner.close);\n          state.innerActive = state.inner = null;\n          return curInner.delimStyle;\n        }\n        if (found > -1) stream.string = oldContent.slice(0, found);\n        var innerToken = curInner.mode.token(stream, state.inner);\n        if (found > -1) stream.string = oldContent;\n\n        if (found == stream.pos && curInner.parseDelimiters)\n          state.innerActive = state.inner = null;\n\n        if (curInner.innerStyle) {\n          if (innerToken) innerToken = innerToken + \' \' + curInner.innerStyle;\n          else innerToken = curInner.innerStyle;\n        }\n\n        return innerToken;\n      }\n    },\n\n    indent: function(state, textAfter) {\n      var mode = state.innerActive ? state.innerActive.mode : outer;\n      if (!mode.indent) return CodeMirror.Pass;\n      return mode.indent(state.innerActive ? state.inner : state.outer, textAfter);\n    },\n\n    blankLine: function(state) {\n      var mode = state.innerActive ? state.innerActive.mode : outer;\n      if (mode.blankLine) {\n        mode.blankLine(state.innerActive ? state.inner : state.outer);\n      }\n      if (!state.innerActive) {\n        for (var i = 0; i < others.length; ++i) {\n          var other = others[i];\n          if (other.open === "\\n") {\n            state.innerActive = other;\n            state.inner = CodeMirror.startState(other.mode, mode.indent ? mode.indent(state.outer, "") : 0);\n          }\n        }\n      } else if (state.innerActive.close === "\\n") {\n        state.innerActive = state.inner = null;\n      }\n    },\n\n    electricChars: outer.electricChars,\n\n    innerMode: function(state) {\n      return state.inner ? {state: state.inner, mode: state.innerActive.mode} : {state: state.outer, mode: outer};\n    }\n  };\n};\n\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/mode/multiplex.js'),
eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n// Utility function that allows modes to be combined. The mode given\n// as the base argument takes care of most of the normal mode\n// functionality, but a second (typically simple) mode is used, which\n// can override the style of text. Both modes get to parse all of the\n// text, but when both assign a non-null style to a piece of code, the\n// overlay wins, unless the combine argument was true and not overridden,\n// or state.overlay.combineTokens was true, in which case the styles are\n// combined.\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/mode/overlay\',["../../lib/codemirror"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n"use strict";\n\nCodeMirror.overlayMode = function(base, overlay, combine) {\n  return {\n    startState: function() {\n      return {\n        base: CodeMirror.startState(base),\n        overlay: CodeMirror.startState(overlay),\n        basePos: 0, baseCur: null,\n        overlayPos: 0, overlayCur: null,\n        streamSeen: null\n      };\n    },\n    copyState: function(state) {\n      return {\n        base: CodeMirror.copyState(base, state.base),\n        overlay: CodeMirror.copyState(overlay, state.overlay),\n        basePos: state.basePos, baseCur: null,\n        overlayPos: state.overlayPos, overlayCur: null\n      };\n    },\n\n    token: function(stream, state) {\n      if (stream != state.streamSeen ||\n          Math.min(state.basePos, state.overlayPos) < stream.start) {\n        state.streamSeen = stream;\n        state.basePos = state.overlayPos = stream.start;\n      }\n\n      if (stream.start == state.basePos) {\n        state.baseCur = base.token(stream, state.base);\n        state.basePos = stream.pos;\n      }\n      if (stream.start == state.overlayPos) {\n        stream.pos = stream.start;\n        state.overlayCur = overlay.token(stream, state.overlay);\n        state.overlayPos = stream.pos;\n      }\n      stream.pos = Math.min(state.basePos, state.overlayPos);\n\n      // state.overlay.combineTokens always takes precedence over combine,\n      // unless set to null\n      if (state.overlayCur == null) return state.baseCur;\n      else if (state.baseCur != null &&\n               state.overlay.combineTokens ||\n               combine && state.overlay.combineTokens == null)\n        return state.baseCur + " " + state.overlayCur;\n      else return state.overlayCur;\n    },\n\n    indent: base.indent && function(state, textAfter) {\n      return base.indent(state.base, textAfter);\n    },\n    electricChars: base.electricChars,\n\n    innerMode: function(state) { return {state: state.base, mode: base}; },\n\n    blankLine: function(state) {\n      if (base.blankLine) base.blankLine(state.base);\n      if (overlay.blankLine) overlay.blankLine(state.overlay);\n    }\n  };\n};\n\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/mode/overlay.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/mode/simple\',["../../lib/codemirror"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  "use strict";\n\n  CodeMirror.defineSimpleMode = function(name, states) {\n    CodeMirror.defineMode(name, function(config) {\n      return CodeMirror.simpleMode(config, states);\n    });\n  };\n\n  CodeMirror.simpleMode = function(config, states) {\n    ensureState(states, "start");\n    var states_ = {}, meta = states.meta || {}, hasIndentation = false;\n    for (var state in states) if (state != meta && states.hasOwnProperty(state)) {\n      var list = states_[state] = [], orig = states[state];\n      for (var i = 0; i < orig.length; i++) {\n        var data = orig[i];\n        list.push(new Rule(data, states));\n        if (data.indent || data.dedent) hasIndentation = true;\n      }\n    }\n    var mode = {\n      startState: function() {\n        return {state: "start", pending: null,\n                local: null, localState: null,\n                indent: hasIndentation ? [] : null};\n      },\n      copyState: function(state) {\n        var s = {state: state.state, pending: state.pending,\n                 local: state.local, localState: null,\n                 indent: state.indent && state.indent.slice(0)};\n        if (state.localState)\n          s.localState = CodeMirror.copyState(state.local.mode, state.localState);\n        if (state.stack)\n          s.stack = state.stack.slice(0);\n        for (var pers = state.persistentStates; pers; pers = pers.next)\n          s.persistentStates = {mode: pers.mode,\n                                spec: pers.spec,\n                                state: pers.state == state.localState ? s.localState : CodeMirror.copyState(pers.mode, pers.state),\n                                next: s.persistentStates};\n        return s;\n      },\n      token: tokenFunction(states_, config),\n      innerMode: function(state) { return state.local && {mode: state.local.mode, state: state.localState}; },\n      indent: indentFunction(states_, meta)\n    };\n    if (meta) for (var prop in meta) if (meta.hasOwnProperty(prop))\n      mode[prop] = meta[prop];\n    return mode;\n  };\n\n  function ensureState(states, name) {\n    if (!states.hasOwnProperty(name))\n      throw new Error("Undefined state " + name + "in simple mode");\n  }\n\n  function toRegex(val, caret) {\n    if (!val) return /(?:)/;\n    var flags = "";\n    if (val instanceof RegExp) {\n      if (val.ignoreCase) flags = "i";\n      val = val.source;\n    } else {\n      val = String(val);\n    }\n    return new RegExp((caret === false ? "" : "^") + "(?:" + val + ")", flags);\n  }\n\n  function asToken(val) {\n    if (!val) return null;\n    if (typeof val == "string") return val.replace(/\\./g, " ");\n    var result = [];\n    for (var i = 0; i < val.length; i++)\n      result.push(val[i] && val[i].replace(/\\./g, " "));\n    return result;\n  }\n\n  function Rule(data, states) {\n    if (data.next || data.push) ensureState(states, data.next || data.push);\n    this.regex = toRegex(data.regex);\n    this.token = asToken(data.token);\n    this.data = data;\n  }\n\n  function tokenFunction(states, config) {\n    return function(stream, state) {\n      if (state.pending) {\n        var pend = state.pending.shift();\n        if (state.pending.length == 0) state.pending = null;\n        stream.pos += pend.text.length;\n        return pend.token;\n      }\n\n      if (state.local) {\n        if (state.local.end && stream.match(state.local.end)) {\n          var tok = state.local.endToken || null;\n          state.local = state.localState = null;\n          return tok;\n        } else {\n          var tok = state.local.mode.token(stream, state.localState), m;\n          if (state.local.endScan && (m = state.local.endScan.exec(stream.current())))\n            stream.pos = stream.start + m.index;\n          return tok;\n        }\n      }\n\n      var curState = states[state.state];\n      for (var i = 0; i < curState.length; i++) {\n        var rule = curState[i];\n        var matches = (!rule.data.sol || stream.sol()) && stream.match(rule.regex);\n        if (matches) {\n          if (rule.data.next) {\n            state.state = rule.data.next;\n          } else if (rule.data.push) {\n            (state.stack || (state.stack = [])).push(state.state);\n            state.state = rule.data.push;\n          } else if (rule.data.pop && state.stack && state.stack.length) {\n            state.state = state.stack.pop();\n          }\n\n          if (rule.data.mode)\n            enterLocalMode(config, state, rule.data.mode, rule.token);\n          if (rule.data.indent)\n            state.indent.push(stream.indentation() + config.indentUnit);\n          if (rule.data.dedent)\n            state.indent.pop();\n          if (matches.length > 2) {\n            state.pending = [];\n            for (var j = 2; j < matches.length; j++)\n              if (matches[j])\n                state.pending.push({text: matches[j], token: rule.token[j - 1]});\n            stream.backUp(matches[0].length - (matches[1] ? matches[1].length : 0));\n            return rule.token[0];\n          } else if (rule.token && rule.token.join) {\n            return rule.token[0];\n          } else {\n            return rule.token;\n          }\n        }\n      }\n      stream.next();\n      return null;\n    };\n  }\n\n  function cmp(a, b) {\n    if (a === b) return true;\n    if (!a || typeof a != "object" || !b || typeof b != "object") return false;\n    var props = 0;\n    for (var prop in a) if (a.hasOwnProperty(prop)) {\n      if (!b.hasOwnProperty(prop) || !cmp(a[prop], b[prop])) return false;\n      props++;\n    }\n    for (var prop in b) if (b.hasOwnProperty(prop)) props--;\n    return props == 0;\n  }\n\n  function enterLocalMode(config, state, spec, token) {\n    var pers;\n    if (spec.persistent) for (var p = state.persistentStates; p && !pers; p = p.next)\n      if (spec.spec ? cmp(spec.spec, p.spec) : spec.mode == p.mode) pers = p;\n    var mode = pers ? pers.mode : spec.mode || CodeMirror.getMode(config, spec.spec);\n    var lState = pers ? pers.state : CodeMirror.startState(mode);\n    if (spec.persistent && !pers)\n      state.persistentStates = {mode: mode, spec: spec.spec, state: lState, next: state.persistentStates};\n\n    state.localState = lState;\n    state.local = {mode: mode,\n                   end: spec.end && toRegex(spec.end),\n                   endScan: spec.end && spec.forceEnd !== false && toRegex(spec.end, false),\n                   endToken: token && token.join ? token[token.length - 1] : token};\n  }\n\n  function indexOf(val, arr) {\n    for (var i = 0; i < arr.length; i++) if (arr[i] === val) return true;\n  }\n\n  function indentFunction(states, meta) {\n    return function(state, textAfter, line) {\n      if (state.local && state.local.mode.indent)\n        return state.local.mode.indent(state.localState, textAfter, line);\n      if (state.indent == null || state.local || meta.dontIndentStates && indexOf(state.state, meta.dontIndentStates) > -1)\n        return CodeMirror.Pass;\n\n      var pos = state.indent.length - 1, rules = states[state.state];\n      scan: for (;;) {\n        for (var i = 0; i < rules.length; i++) {\n          var rule = rules[i];\n          if (rule.data.dedent && rule.data.dedentIfLineStart !== false) {\n            var m = rule.regex.exec(textAfter);\n            if (m && m[0]) {\n              pos--;\n              if (rule.next || rule.push) rules = states[rule.next || rule.push];\n              textAfter = textAfter.slice(m[0].length);\n              continue scan;\n            }\n          }\n        }\n        break;\n      }\n      return pos < 0 ? 0 : state.indent[pos];\n    };\n  }\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/mode/simple.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/scroll/scrollpastend\',["../../lib/codemirror"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  "use strict";\n\n  CodeMirror.defineOption("scrollPastEnd", false, function(cm, val, old) {\n    if (old && old != CodeMirror.Init) {\n      cm.off("change", onChange);\n      cm.off("refresh", updateBottomMargin);\n      cm.display.lineSpace.parentNode.style.paddingBottom = "";\n      cm.state.scrollPastEndPadding = null;\n    }\n    if (val) {\n      cm.on("change", onChange);\n      cm.on("refresh", updateBottomMargin);\n      updateBottomMargin(cm);\n    }\n  });\n\n  function onChange(cm, change) {\n    if (CodeMirror.changeEnd(change).line == cm.lastLine())\n      updateBottomMargin(cm);\n  }\n\n  function updateBottomMargin(cm) {\n    var padding = "";\n    if (cm.lineCount() > 1) {\n      var totalH = cm.display.scroller.clientHeight - 30,\n          lastLineH = cm.getLineHandle(cm.lastLine()).height;\n      padding = (totalH - lastLineH) + "px";\n    }\n    if (cm.state.scrollPastEndPadding != padding) {\n      cm.state.scrollPastEndPadding = padding;\n      cm.display.lineSpace.parentNode.style.paddingBottom = padding;\n      cm.setSize();\n    }\n  }\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/scroll/scrollpastend.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n// Highlighting text that matches the selection\n//\n// Defines an option highlightSelectionMatches, which, when enabled,\n// will style strings that match the selection throughout the\n// document.\n//\n// The option can be set to true to simply enable it, or to a\n// {minChars, style, wordsOnly, showToken, delay} object to explicitly\n// configure it. minChars is the minimum amount of characters that should be\n// selected for the behavior to occur, and style is the token style to\n// apply to the matches. This will be prefixed by "cm-" to create an\n// actual CSS class name. If wordsOnly is enabled, the matches will be\n// highlighted only if the selected text is a word. showToken, when enabled,\n// will cause the current token to be highlighted when nothing is selected.\n// delay is used to specify how much time to wait, in milliseconds, before\n// highlighting the matches.\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/search/match-highlighter\',["../../lib/codemirror"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  "use strict";\n\n  var DEFAULT_MIN_CHARS = 2;\n  var DEFAULT_TOKEN_STYLE = "matchhighlight";\n  var DEFAULT_DELAY = 100;\n  var DEFAULT_WORDS_ONLY = false;\n\n  function State(options) {\n    if (typeof options == "object") {\n      this.minChars = options.minChars;\n      this.style = options.style;\n      this.showToken = options.showToken;\n      this.delay = options.delay;\n      this.wordsOnly = options.wordsOnly;\n    }\n    if (this.style == null) this.style = DEFAULT_TOKEN_STYLE;\n    if (this.minChars == null) this.minChars = DEFAULT_MIN_CHARS;\n    if (this.delay == null) this.delay = DEFAULT_DELAY;\n    if (this.wordsOnly == null) this.wordsOnly = DEFAULT_WORDS_ONLY;\n    this.overlay = this.timeout = null;\n  }\n\n  CodeMirror.defineOption("highlightSelectionMatches", false, function(cm, val, old) {\n    if (old && old != CodeMirror.Init) {\n      var over = cm.state.matchHighlighter.overlay;\n      if (over) cm.removeOverlay(over);\n      clearTimeout(cm.state.matchHighlighter.timeout);\n      cm.state.matchHighlighter = null;\n      cm.off("cursorActivity", cursorActivity);\n    }\n    if (val) {\n      cm.state.matchHighlighter = new State(val);\n      highlightMatches(cm);\n      cm.on("cursorActivity", cursorActivity);\n    }\n  });\n\n  function cursorActivity(cm) {\n    var state = cm.state.matchHighlighter;\n    clearTimeout(state.timeout);\n    state.timeout = setTimeout(function() {highlightMatches(cm);}, state.delay);\n  }\n\n  function highlightMatches(cm) {\n    cm.operation(function() {\n      var state = cm.state.matchHighlighter;\n      if (state.overlay) {\n        cm.removeOverlay(state.overlay);\n        state.overlay = null;\n      }\n      if (!cm.somethingSelected() && state.showToken) {\n        var re = state.showToken === true ? /[\\w$]/ : state.showToken;\n        var cur = cm.getCursor(), line = cm.getLine(cur.line), start = cur.ch, end = start;\n        while (start && re.test(line.charAt(start - 1))) --start;\n        while (end < line.length && re.test(line.charAt(end))) ++end;\n        if (start < end)\n          cm.addOverlay(state.overlay = makeOverlay(line.slice(start, end), re, state.style));\n        return;\n      }\n      var from = cm.getCursor("from"), to = cm.getCursor("to");\n      if (from.line != to.line) return;\n      if (state.wordsOnly && !isWord(cm, from, to)) return;\n      var selection = cm.getRange(from, to).replace(/^\\s+|\\s+$/g, "");\n      if (selection.length >= state.minChars)\n        cm.addOverlay(state.overlay = makeOverlay(selection, false, state.style));\n    });\n  }\n\n  function isWord(cm, from, to) {\n    var str = cm.getRange(from, to);\n    if (str.match(/^\\w+$/) !== null) {\n        if (from.ch > 0) {\n            var pos = {line: from.line, ch: from.ch - 1};\n            var chr = cm.getRange(pos, from);\n            if (chr.match(/\\W/) === null) return false;\n        }\n        if (to.ch < cm.getLine(from.line).length) {\n            var pos = {line: to.line, ch: to.ch + 1};\n            var chr = cm.getRange(to, pos);\n            if (chr.match(/\\W/) === null) return false;\n        }\n        return true;\n    } else return false;\n  }\n\n  function boundariesAround(stream, re) {\n    return (!stream.start || !re.test(stream.string.charAt(stream.start - 1))) &&\n      (stream.pos == stream.string.length || !re.test(stream.string.charAt(stream.pos)));\n  }\n\n  function makeOverlay(query, hasBoundary, style) {\n    return {token: function(stream) {\n      if (stream.match(query) &&\n          (!hasBoundary || boundariesAround(stream, hasBoundary)))\n        return style;\n      stream.next();\n      stream.skipTo(query.charAt(0)) || stream.skipToEnd();\n    }};\n  }\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/search/match-highlighter.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/search/searchcursor\',["../../lib/codemirror"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  "use strict";\n  var Pos = CodeMirror.Pos;\n\n  function SearchCursor(doc, query, pos, caseFold) {\n    this.atOccurrence = false; this.doc = doc;\n    if (caseFold == null && typeof query == "string") caseFold = false;\n\n    pos = pos ? doc.clipPos(pos) : Pos(0, 0);\n    this.pos = {from: pos, to: pos};\n\n    // The matches method is filled in based on the type of query.\n    // It takes a position and a direction, and returns an object\n    // describing the next occurrence of the query, or null if no\n    // more matches were found.\n    if (typeof query != "string") { // Regexp match\n      if (!query.global) query = new RegExp(query.source, query.ignoreCase ? "ig" : "g");\n      this.matches = function(reverse, pos) {\n        if (reverse) {\n          query.lastIndex = 0;\n          var line = doc.getLine(pos.line).slice(0, pos.ch), cutOff = 0, match, start;\n          for (;;) {\n            query.lastIndex = cutOff;\n            var newMatch = query.exec(line);\n            if (!newMatch) break;\n            match = newMatch;\n            start = match.index;\n            cutOff = match.index + (match[0].length || 1);\n            if (cutOff == line.length) break;\n          }\n          var matchLen = (match && match[0].length) || 0;\n          if (!matchLen) {\n            if (start == 0 && line.length == 0) {match = undefined;}\n            else if (start != doc.getLine(pos.line).length) {\n              matchLen++;\n            }\n          }\n        } else {\n          query.lastIndex = pos.ch;\n          var line = doc.getLine(pos.line), match = query.exec(line);\n          var matchLen = (match && match[0].length) || 0;\n          var start = match && match.index;\n          if (start + matchLen != line.length && !matchLen) matchLen = 1;\n        }\n        if (match && matchLen)\n          return {from: Pos(pos.line, start),\n                  to: Pos(pos.line, start + matchLen),\n                  match: match};\n      };\n    } else { // String query\n      var origQuery = query;\n      if (caseFold) query = query.toLowerCase();\n      var fold = caseFold ? function(str){return str.toLowerCase();} : function(str){return str;};\n      var target = query.split("\\n");\n      // Different methods for single-line and multi-line queries\n      if (target.length == 1) {\n        if (!query.length) {\n          // Empty string would match anything and never progress, so\n          // we define it to match nothing instead.\n          this.matches = function() {};\n        } else {\n          this.matches = function(reverse, pos) {\n            if (reverse) {\n              var orig = doc.getLine(pos.line).slice(0, pos.ch), line = fold(orig);\n              var match = line.lastIndexOf(query);\n              if (match > -1) {\n                match = adjustPos(orig, line, match);\n                return {from: Pos(pos.line, match), to: Pos(pos.line, match + origQuery.length)};\n              }\n             } else {\n               var orig = doc.getLine(pos.line).slice(pos.ch), line = fold(orig);\n               var match = line.indexOf(query);\n               if (match > -1) {\n                 match = adjustPos(orig, line, match) + pos.ch;\n                 return {from: Pos(pos.line, match), to: Pos(pos.line, match + origQuery.length)};\n               }\n            }\n          };\n        }\n      } else {\n        var origTarget = origQuery.split("\\n");\n        this.matches = function(reverse, pos) {\n          var last = target.length - 1;\n          if (reverse) {\n            if (pos.line - (target.length - 1) < doc.firstLine()) return;\n            if (fold(doc.getLine(pos.line).slice(0, origTarget[last].length)) != target[target.length - 1]) return;\n            var to = Pos(pos.line, origTarget[last].length);\n            for (var ln = pos.line - 1, i = last - 1; i >= 1; --i, --ln)\n              if (target[i] != fold(doc.getLine(ln))) return;\n            var line = doc.getLine(ln), cut = line.length - origTarget[0].length;\n            if (fold(line.slice(cut)) != target[0]) return;\n            return {from: Pos(ln, cut), to: to};\n          } else {\n            if (pos.line + (target.length - 1) > doc.lastLine()) return;\n            var line = doc.getLine(pos.line), cut = line.length - origTarget[0].length;\n            if (fold(line.slice(cut)) != target[0]) return;\n            var from = Pos(pos.line, cut);\n            for (var ln = pos.line + 1, i = 1; i < last; ++i, ++ln)\n              if (target[i] != fold(doc.getLine(ln))) return;\n            if (fold(doc.getLine(ln).slice(0, origTarget[last].length)) != target[last]) return;\n            return {from: from, to: Pos(ln, origTarget[last].length)};\n          }\n        };\n      }\n    }\n  }\n\n  SearchCursor.prototype = {\n    findNext: function() {return this.find(false);},\n    findPrevious: function() {return this.find(true);},\n\n    find: function(reverse) {\n      var self = this, pos = this.doc.clipPos(reverse ? this.pos.from : this.pos.to);\n      function savePosAndFail(line) {\n        var pos = Pos(line, 0);\n        self.pos = {from: pos, to: pos};\n        self.atOccurrence = false;\n        return false;\n      }\n\n      for (;;) {\n        if (this.pos = this.matches(reverse, pos)) {\n          this.atOccurrence = true;\n          return this.pos.match || true;\n        }\n        if (reverse) {\n          if (!pos.line) return savePosAndFail(0);\n          pos = Pos(pos.line-1, this.doc.getLine(pos.line-1).length);\n        }\n        else {\n          var maxLine = this.doc.lineCount();\n          if (pos.line == maxLine - 1) return savePosAndFail(maxLine);\n          pos = Pos(pos.line + 1, 0);\n        }\n      }\n    },\n\n    from: function() {if (this.atOccurrence) return this.pos.from;},\n    to: function() {if (this.atOccurrence) return this.pos.to;},\n\n    replace: function(newText, origin) {\n      if (!this.atOccurrence) return;\n      var lines = CodeMirror.splitLines(newText);\n      this.doc.replaceRange(lines, this.pos.from, this.pos.to, origin);\n      this.pos.to = Pos(this.pos.from.line + lines.length - 1,\n                        lines[lines.length - 1].length + (lines.length == 1 ? this.pos.from.ch : 0));\n    }\n  };\n\n  // Maps a position in a case-folded line back to a position in the original line\n  // (compensating for codepoints increasing in number during folding)\n  function adjustPos(orig, folded, pos) {\n    if (orig.length == folded.length) return pos;\n    for (var pos1 = Math.min(pos, orig.length);;) {\n      var len1 = orig.slice(0, pos1).toLowerCase().length;\n      if (len1 < pos) ++pos1;\n      else if (len1 > pos) --pos1;\n      else return pos1;\n    }\n  }\n\n  CodeMirror.defineExtension("getSearchCursor", function(query, pos, caseFold) {\n    return new SearchCursor(this.doc, query, pos, caseFold);\n  });\n  CodeMirror.defineDocExtension("getSearchCursor", function(query, pos, caseFold) {\n    return new SearchCursor(this, query, pos, caseFold);\n  });\n\n  CodeMirror.defineExtension("selectMatches", function(query, caseFold) {\n    var ranges = [];\n    var cur = this.getSearchCursor(query, this.getCursor("from"), caseFold);\n    while (cur.findNext()) {\n      if (CodeMirror.cmpPos(cur.to(), this.getCursor("to")) > 0) break;\n      ranges.push({anchor: cur.from(), head: cur.to()});\n    }\n    if (ranges.length)\n      this.setSelections(ranges, 0);\n  });\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/search/searchcursor.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n// Because sometimes you need to style the cursor\'s line.\n//\n// Adds an option \'styleActiveLine\' which, when enabled, gives the\n// active line\'s wrapping <div> the CSS class "CodeMirror-activeline",\n// and gives its background <div> the class "CodeMirror-activeline-background".\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/selection/active-line\',["../../lib/codemirror"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  "use strict";\n  var WRAP_CLASS = "CodeMirror-activeline";\n  var BACK_CLASS = "CodeMirror-activeline-background";\n\n  CodeMirror.defineOption("styleActiveLine", false, function(cm, val, old) {\n    var prev = old && old != CodeMirror.Init;\n    if (val && !prev) {\n      cm.state.activeLines = [];\n      updateActiveLines(cm, cm.listSelections());\n      cm.on("beforeSelectionChange", selectionChange);\n    } else if (!val && prev) {\n      cm.off("beforeSelectionChange", selectionChange);\n      clearActiveLines(cm);\n      delete cm.state.activeLines;\n    }\n  });\n\n  function clearActiveLines(cm) {\n    for (var i = 0; i < cm.state.activeLines.length; i++) {\n      cm.removeLineClass(cm.state.activeLines[i], "wrap", WRAP_CLASS);\n      cm.removeLineClass(cm.state.activeLines[i], "background", BACK_CLASS);\n    }\n  }\n\n  function sameArray(a, b) {\n    if (a.length != b.length) return false;\n    for (var i = 0; i < a.length; i++)\n      if (a[i] != b[i]) return false;\n    return true;\n  }\n\n  function updateActiveLines(cm, ranges) {\n    var active = [];\n    for (var i = 0; i < ranges.length; i++) {\n      var range = ranges[i];\n      if (!range.empty()) continue;\n      var line = cm.getLineHandleVisualStart(range.head.line);\n      if (active[active.length - 1] != line) active.push(line);\n    }\n    if (sameArray(cm.state.activeLines, active)) return;\n    cm.operation(function() {\n      clearActiveLines(cm);\n      for (var i = 0; i < active.length; i++) {\n        cm.addLineClass(active[i], "wrap", WRAP_CLASS);\n        cm.addLineClass(active[i], "background", BACK_CLASS);\n      }\n      cm.state.activeLines = active;\n    });\n  }\n\n  function selectionChange(cm, sel) {\n    updateActiveLines(cm, sel.ranges);\n  }\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/selection/active-line.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n// Because sometimes you need to mark the selected *text*.\n//\n// Adds an option \'styleSelectedText\' which, when enabled, gives\n// selected text the CSS class given as option value, or\n// "CodeMirror-selectedtext" when the value is not a string.\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/selection/mark-selection\',["../../lib/codemirror"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  "use strict";\n\n  CodeMirror.defineOption("styleSelectedText", false, function(cm, val, old) {\n    var prev = old && old != CodeMirror.Init;\n    if (val && !prev) {\n      cm.state.markedSelection = [];\n      cm.state.markedSelectionStyle = typeof val == "string" ? val : "CodeMirror-selectedtext";\n      reset(cm);\n      cm.on("cursorActivity", onCursorActivity);\n      cm.on("change", onChange);\n    } else if (!val && prev) {\n      cm.off("cursorActivity", onCursorActivity);\n      cm.off("change", onChange);\n      clear(cm);\n      cm.state.markedSelection = cm.state.markedSelectionStyle = null;\n    }\n  });\n\n  function onCursorActivity(cm) {\n    cm.operation(function() { update(cm); });\n  }\n\n  function onChange(cm) {\n    if (cm.state.markedSelection.length)\n      cm.operation(function() { clear(cm); });\n  }\n\n  var CHUNK_SIZE = 8;\n  var Pos = CodeMirror.Pos;\n  var cmp = CodeMirror.cmpPos;\n\n  function coverRange(cm, from, to, addAt) {\n    if (cmp(from, to) == 0) return;\n    var array = cm.state.markedSelection;\n    var cls = cm.state.markedSelectionStyle;\n    for (var line = from.line;;) {\n      var start = line == from.line ? from : Pos(line, 0);\n      var endLine = line + CHUNK_SIZE, atEnd = endLine >= to.line;\n      var end = atEnd ? to : Pos(endLine, 0);\n      var mark = cm.markText(start, end, {className: cls});\n      if (addAt == null) array.push(mark);\n      else array.splice(addAt++, 0, mark);\n      if (atEnd) break;\n      line = endLine;\n    }\n  }\n\n  function clear(cm) {\n    var array = cm.state.markedSelection;\n    for (var i = 0; i < array.length; ++i) array[i].clear();\n    array.length = 0;\n  }\n\n  function reset(cm) {\n    clear(cm);\n    var ranges = cm.listSelections();\n    for (var i = 0; i < ranges.length; i++)\n      coverRange(cm, ranges[i].from(), ranges[i].to());\n  }\n\n  function update(cm) {\n    if (!cm.somethingSelected()) return clear(cm);\n    if (cm.listSelections().length > 1) return reset(cm);\n\n    var from = cm.getCursor("start"), to = cm.getCursor("end");\n\n    var array = cm.state.markedSelection;\n    if (!array.length) return coverRange(cm, from, to);\n\n    var coverStart = array[0].find(), coverEnd = array[array.length - 1].find();\n    if (!coverStart || !coverEnd || to.line - from.line < CHUNK_SIZE ||\n        cmp(from, coverEnd.to) >= 0 || cmp(to, coverStart.from) <= 0)\n      return reset(cm);\n\n    while (cmp(from, coverStart.from) > 0) {\n      array.shift().clear();\n      coverStart = array[0].find();\n    }\n    if (cmp(from, coverStart.from) < 0) {\n      if (coverStart.to.line - from.line < CHUNK_SIZE) {\n        array.shift().clear();\n        coverRange(cm, from, coverStart.to, 0);\n      } else {\n        coverRange(cm, from, coverStart.from, 0);\n      }\n    }\n\n    while (cmp(to, coverEnd.to) < 0) {\n      array.pop().clear();\n      coverEnd = array[array.length - 1].find();\n    }\n    if (cmp(to, coverEnd.to) > 0) {\n      if (to.line - coverEnd.from.line < CHUNK_SIZE) {\n        array.pop().clear();\n        coverRange(cm, coverEnd.from, to);\n      } else {\n        coverRange(cm, coverEnd.to, to);\n      }\n    }\n  }\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/selection/mark-selection.js'),
eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n// A rough approximation of Sublime Text\'s keybindings\n// Depends on addon/search/searchcursor.js and optionally addon/dialog/dialogs.js\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../lib/codemirror"), require("../addon/search/searchcursor"), require("../addon/edit/matchbrackets"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/keymap/sublime\',["../lib/codemirror", "../addon/search/searchcursor", "../addon/edit/matchbrackets"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  "use strict";\n\n  var map = CodeMirror.keyMap.sublime = {fallthrough: "default"};\n  var cmds = CodeMirror.commands;\n  var Pos = CodeMirror.Pos;\n  var mac = CodeMirror.keyMap["default"] == CodeMirror.keyMap.macDefault;\n  var ctrl = mac ? "Cmd-" : "Ctrl-";\n\n  // This is not exactly Sublime\'s algorithm. I couldn\'t make heads or tails of that.\n  function findPosSubword(doc, start, dir) {\n    if (dir < 0 && start.ch == 0) return doc.clipPos(Pos(start.line - 1));\n    var line = doc.getLine(start.line);\n    if (dir > 0 && start.ch >= line.length) return doc.clipPos(Pos(start.line + 1, 0));\n    var state = "start", type;\n    for (var pos = start.ch, e = dir < 0 ? 0 : line.length, i = 0; pos != e; pos += dir, i++) {\n      var next = line.charAt(dir < 0 ? pos - 1 : pos);\n      var cat = next != "_" && CodeMirror.isWordChar(next) ? "w" : "o";\n      if (cat == "w" && next.toUpperCase() == next) cat = "W";\n      if (state == "start") {\n        if (cat != "o") { state = "in"; type = cat; }\n      } else if (state == "in") {\n        if (type != cat) {\n          if (type == "w" && cat == "W" && dir < 0) pos--;\n          if (type == "W" && cat == "w" && dir > 0) { type = "w"; continue; }\n          break;\n        }\n      }\n    }\n    return Pos(start.line, pos);\n  }\n\n  function moveSubword(cm, dir) {\n    cm.extendSelectionsBy(function(range) {\n      if (cm.display.shift || cm.doc.extend || range.empty())\n        return findPosSubword(cm.doc, range.head, dir);\n      else\n        return dir < 0 ? range.from() : range.to();\n    });\n  }\n\n  cmds[map["Alt-Left"] = "goSubwordLeft"] = function(cm) { moveSubword(cm, -1); };\n  cmds[map["Alt-Right"] = "goSubwordRight"] = function(cm) { moveSubword(cm, 1); };\n\n  var scrollLineCombo = mac ? "Ctrl-Alt-" : "Ctrl-";\n\n  cmds[map[scrollLineCombo + "Up"] = "scrollLineUp"] = function(cm) {\n    var info = cm.getScrollInfo();\n    if (!cm.somethingSelected()) {\n      var visibleBottomLine = cm.lineAtHeight(info.top + info.clientHeight, "local");\n      if (cm.getCursor().line >= visibleBottomLine)\n        cm.execCommand("goLineUp");\n    }\n    cm.scrollTo(null, info.top - cm.defaultTextHeight());\n  };\n  cmds[map[scrollLineCombo + "Down"] = "scrollLineDown"] = function(cm) {\n    var info = cm.getScrollInfo();\n    if (!cm.somethingSelected()) {\n      var visibleTopLine = cm.lineAtHeight(info.top, "local")+1;\n      if (cm.getCursor().line <= visibleTopLine)\n        cm.execCommand("goLineDown");\n    }\n    cm.scrollTo(null, info.top + cm.defaultTextHeight());\n  };\n\n  cmds[map["Shift-" + ctrl + "L"] = "splitSelectionByLine"] = function(cm) {\n    var ranges = cm.listSelections(), lineRanges = [];\n    for (var i = 0; i < ranges.length; i++) {\n      var from = ranges[i].from(), to = ranges[i].to();\n      for (var line = from.line; line <= to.line; ++line)\n        if (!(to.line > from.line && line == to.line && to.ch == 0))\n          lineRanges.push({anchor: line == from.line ? from : Pos(line, 0),\n                           head: line == to.line ? to : Pos(line)});\n    }\n    cm.setSelections(lineRanges, 0);\n  };\n\n  map["Shift-Tab"] = "indentLess";\n\n  cmds[map["Esc"] = "singleSelectionTop"] = function(cm) {\n    var range = cm.listSelections()[0];\n    cm.setSelection(range.anchor, range.head, {scroll: false});\n  };\n\n  cmds[map[ctrl + "L"] = "selectLine"] = function(cm) {\n    var ranges = cm.listSelections(), extended = [];\n    for (var i = 0; i < ranges.length; i++) {\n      var range = ranges[i];\n      extended.push({anchor: Pos(range.from().line, 0),\n                     head: Pos(range.to().line + 1, 0)});\n    }\n    cm.setSelections(extended);\n  };\n\n  map["Shift-" + ctrl + "K"] = "deleteLine";\n\n  function insertLine(cm, above) {\n    cm.operation(function() {\n      var len = cm.listSelections().length, newSelection = [], last = -1;\n      for (var i = 0; i < len; i++) {\n        var head = cm.listSelections()[i].head;\n        if (head.line <= last) continue;\n        var at = Pos(head.line + (above ? 0 : 1), 0);\n        cm.replaceRange("\\n", at, null, "+insertLine");\n        cm.indentLine(at.line, null, true);\n        newSelection.push({head: at, anchor: at});\n        last = head.line + 1;\n      }\n      cm.setSelections(newSelection);\n    });\n  }\n\n  cmds[map[ctrl + "Enter"] = "insertLineAfter"] = function(cm) { insertLine(cm, false); };\n\n  cmds[map["Shift-" + ctrl + "Enter"] = "insertLineBefore"] = function(cm) { insertLine(cm, true); };\n\n  function wordAt(cm, pos) {\n    var start = pos.ch, end = start, line = cm.getLine(pos.line);\n    while (start && CodeMirror.isWordChar(line.charAt(start - 1))) --start;\n    while (end < line.length && CodeMirror.isWordChar(line.charAt(end))) ++end;\n    return {from: Pos(pos.line, start), to: Pos(pos.line, end), word: line.slice(start, end)};\n  }\n\n  cmds[map[ctrl + "D"] = "selectNextOccurrence"] = function(cm) {\n    var from = cm.getCursor("from"), to = cm.getCursor("to");\n    var fullWord = cm.state.sublimeFindFullWord == cm.doc.sel;\n    if (CodeMirror.cmpPos(from, to) == 0) {\n      var word = wordAt(cm, from);\n      if (!word.word) return;\n      cm.setSelection(word.from, word.to);\n      fullWord = true;\n    } else {\n      var text = cm.getRange(from, to);\n      var query = fullWord ? new RegExp("\\\\b" + text + "\\\\b") : text;\n      var cur = cm.getSearchCursor(query, to);\n      if (cur.findNext()) {\n        cm.addSelection(cur.from(), cur.to());\n      } else {\n        cur = cm.getSearchCursor(query, Pos(cm.firstLine(), 0));\n        if (cur.findNext())\n          cm.addSelection(cur.from(), cur.to());\n      }\n    }\n    if (fullWord)\n      cm.state.sublimeFindFullWord = cm.doc.sel;\n  };\n\n  var mirror = "(){}[]";\n  function selectBetweenBrackets(cm) {\n    var pos = cm.getCursor(), opening = cm.scanForBracket(pos, -1);\n    if (!opening) return;\n    for (;;) {\n      var closing = cm.scanForBracket(pos, 1);\n      if (!closing) return;\n      if (closing.ch == mirror.charAt(mirror.indexOf(opening.ch) + 1)) {\n        cm.setSelection(Pos(opening.pos.line, opening.pos.ch + 1), closing.pos, false);\n        return true;\n      }\n      pos = Pos(closing.pos.line, closing.pos.ch + 1);\n    }\n  }\n\n  cmds[map["Shift-" + ctrl + "Space"] = "selectScope"] = function(cm) {\n    selectBetweenBrackets(cm) || cm.execCommand("selectAll");\n  };\n  cmds[map["Shift-" + ctrl + "M"] = "selectBetweenBrackets"] = function(cm) {\n    if (!selectBetweenBrackets(cm)) return CodeMirror.Pass;\n  };\n\n  cmds[map[ctrl + "M"] = "goToBracket"] = function(cm) {\n    cm.extendSelectionsBy(function(range) {\n      var next = cm.scanForBracket(range.head, 1);\n      if (next && CodeMirror.cmpPos(next.pos, range.head) != 0) return next.pos;\n      var prev = cm.scanForBracket(range.head, -1);\n      return prev && Pos(prev.pos.line, prev.pos.ch + 1) || range.head;\n    });\n  };\n\n  var swapLineCombo = mac ? "Cmd-Ctrl-" : "Shift-Ctrl-";\n\n  cmds[map[swapLineCombo + "Up"] = "swapLineUp"] = function(cm) {\n    var ranges = cm.listSelections(), linesToMove = [], at = cm.firstLine() - 1, newSels = [];\n    for (var i = 0; i < ranges.length; i++) {\n      var range = ranges[i], from = range.from().line - 1, to = range.to().line;\n      newSels.push({anchor: Pos(range.anchor.line - 1, range.anchor.ch),\n                    head: Pos(range.head.line - 1, range.head.ch)});\n      if (range.to().ch == 0 && !range.empty()) --to;\n      if (from > at) linesToMove.push(from, to);\n      else if (linesToMove.length) linesToMove[linesToMove.length - 1] = to;\n      at = to;\n    }\n    cm.operation(function() {\n      for (var i = 0; i < linesToMove.length; i += 2) {\n        var from = linesToMove[i], to = linesToMove[i + 1];\n        var line = cm.getLine(from);\n        cm.replaceRange("", Pos(from, 0), Pos(from + 1, 0), "+swapLine");\n        if (to > cm.lastLine())\n          cm.replaceRange("\\n" + line, Pos(cm.lastLine()), null, "+swapLine");\n        else\n          cm.replaceRange(line + "\\n", Pos(to, 0), null, "+swapLine");\n      }\n      cm.setSelections(newSels);\n      cm.scrollIntoView();\n    });\n  };\n\n  cmds[map[swapLineCombo + "Down"] = "swapLineDown"] = function(cm) {\n    var ranges = cm.listSelections(), linesToMove = [], at = cm.lastLine() + 1;\n    for (var i = ranges.length - 1; i >= 0; i--) {\n      var range = ranges[i], from = range.to().line + 1, to = range.from().line;\n      if (range.to().ch == 0 && !range.empty()) from--;\n      if (from < at) linesToMove.push(from, to);\n      else if (linesToMove.length) linesToMove[linesToMove.length - 1] = to;\n      at = to;\n    }\n    cm.operation(function() {\n      for (var i = linesToMove.length - 2; i >= 0; i -= 2) {\n        var from = linesToMove[i], to = linesToMove[i + 1];\n        var line = cm.getLine(from);\n        if (from == cm.lastLine())\n          cm.replaceRange("", Pos(from - 1), Pos(from), "+swapLine");\n        else\n          cm.replaceRange("", Pos(from, 0), Pos(from + 1, 0), "+swapLine");\n        cm.replaceRange(line + "\\n", Pos(to, 0), null, "+swapLine");\n      }\n      cm.scrollIntoView();\n    });\n  };\n\n  map[ctrl + "/"] = "toggleComment";\n\n  cmds[map[ctrl + "J"] = "joinLines"] = function(cm) {\n    var ranges = cm.listSelections(), joined = [];\n    for (var i = 0; i < ranges.length; i++) {\n      var range = ranges[i], from = range.from();\n      var start = from.line, end = range.to().line;\n      while (i < ranges.length - 1 && ranges[i + 1].from().line == end)\n        end = ranges[++i].to().line;\n      joined.push({start: start, end: end, anchor: !range.empty() && from});\n    }\n    cm.operation(function() {\n      var offset = 0, ranges = [];\n      for (var i = 0; i < joined.length; i++) {\n        var obj = joined[i];\n        var anchor = obj.anchor && Pos(obj.anchor.line - offset, obj.anchor.ch), head;\n        for (var line = obj.start; line <= obj.end; line++) {\n          var actual = line - offset;\n          if (line == obj.end) head = Pos(actual, cm.getLine(actual).length + 1);\n          if (actual < cm.lastLine()) {\n            cm.replaceRange(" ", Pos(actual), Pos(actual + 1, /^\\s*/.exec(cm.getLine(actual + 1))[0].length));\n            ++offset;\n          }\n        }\n        ranges.push({anchor: anchor || head, head: head});\n      }\n      cm.setSelections(ranges, 0);\n    });\n  };\n\n  cmds[map["Shift-" + ctrl + "D"] = "duplicateLine"] = function(cm) {\n    cm.operation(function() {\n      var rangeCount = cm.listSelections().length;\n      for (var i = 0; i < rangeCount; i++) {\n        var range = cm.listSelections()[i];\n        if (range.empty())\n          cm.replaceRange(cm.getLine(range.head.line) + "\\n", Pos(range.head.line, 0));\n        else\n          cm.replaceRange(cm.getRange(range.from(), range.to()), range.from());\n      }\n      cm.scrollIntoView();\n    });\n  };\n\n  map[ctrl + "T"] = "transposeChars";\n\n  function sortLines(cm, caseSensitive) {\n    var ranges = cm.listSelections(), toSort = [], selected;\n    for (var i = 0; i < ranges.length; i++) {\n      var range = ranges[i];\n      if (range.empty()) continue;\n      var from = range.from().line, to = range.to().line;\n      while (i < ranges.length - 1 && ranges[i + 1].from().line == to)\n        to = range[++i].to().line;\n      toSort.push(from, to);\n    }\n    if (toSort.length) selected = true;\n    else toSort.push(cm.firstLine(), cm.lastLine());\n\n    cm.operation(function() {\n      var ranges = [];\n      for (var i = 0; i < toSort.length; i += 2) {\n        var from = toSort[i], to = toSort[i + 1];\n        var start = Pos(from, 0), end = Pos(to);\n        var lines = cm.getRange(start, end, false);\n        if (caseSensitive)\n          lines.sort();\n        else\n          lines.sort(function(a, b) {\n            var au = a.toUpperCase(), bu = b.toUpperCase();\n            if (au != bu) { a = au; b = bu; }\n            return a < b ? -1 : a == b ? 0 : 1;\n          });\n        cm.replaceRange(lines, start, end);\n        if (selected) ranges.push({anchor: start, head: end});\n      }\n      if (selected) cm.setSelections(ranges, 0);\n    });\n  }\n\n  cmds[map["F9"] = "sortLines"] = function(cm) { sortLines(cm, true); };\n  cmds[map[ctrl + "F9"] = "sortLinesInsensitive"] = function(cm) { sortLines(cm, false); };\n\n  cmds[map["F2"] = "nextBookmark"] = function(cm) {\n    var marks = cm.state.sublimeBookmarks;\n    if (marks) while (marks.length) {\n      var current = marks.shift();\n      var found = current.find();\n      if (found) {\n        marks.push(current);\n        return cm.setSelection(found.from, found.to);\n      }\n    }\n  };\n\n  cmds[map["Shift-F2"] = "prevBookmark"] = function(cm) {\n    var marks = cm.state.sublimeBookmarks;\n    if (marks) while (marks.length) {\n      marks.unshift(marks.pop());\n      var found = marks[marks.length - 1].find();\n      if (!found)\n        marks.pop();\n      else\n        return cm.setSelection(found.from, found.to);\n    }\n  };\n\n  cmds[map[ctrl + "F2"] = "toggleBookmark"] = function(cm) {\n    var ranges = cm.listSelections();\n    var marks = cm.state.sublimeBookmarks || (cm.state.sublimeBookmarks = []);\n    for (var i = 0; i < ranges.length; i++) {\n      var from = ranges[i].from(), to = ranges[i].to();\n      var found = cm.findMarks(from, to);\n      for (var j = 0; j < found.length; j++) {\n        if (found[j].sublimeBookmark) {\n          found[j].clear();\n          for (var k = 0; k < marks.length; k++)\n            if (marks[k] == found[j])\n              marks.splice(k--, 1);\n          break;\n        }\n      }\n      if (j == found.length)\n        marks.push(cm.markText(from, to, {sublimeBookmark: true, clearWhenEmpty: false}));\n    }\n  };\n\n  cmds[map["Shift-" + ctrl + "F2"] = "clearBookmarks"] = function(cm) {\n    var marks = cm.state.sublimeBookmarks;\n    if (marks) for (var i = 0; i < marks.length; i++) marks[i].clear();\n    marks.length = 0;\n  };\n\n  cmds[map["Alt-F2"] = "selectBookmarks"] = function(cm) {\n    var marks = cm.state.sublimeBookmarks, ranges = [];\n    if (marks) for (var i = 0; i < marks.length; i++) {\n      var found = marks[i].find();\n      if (!found)\n        marks.splice(i--, 0);\n      else\n        ranges.push({anchor: found.from, head: found.to});\n    }\n    if (ranges.length)\n      cm.setSelections(ranges, 0);\n  };\n\n  map["Alt-Q"] = "wrapLines";\n\n  var cK = ctrl + "K ";\n\n  function modifyWordOrSelection(cm, mod) {\n    cm.operation(function() {\n      var ranges = cm.listSelections(), indices = [], replacements = [];\n      for (var i = 0; i < ranges.length; i++) {\n        var range = ranges[i];\n        if (range.empty()) { indices.push(i); replacements.push(""); }\n        else replacements.push(mod(cm.getRange(range.from(), range.to())));\n      }\n      cm.replaceSelections(replacements, "around", "case");\n      for (var i = indices.length - 1, at; i >= 0; i--) {\n        var range = ranges[indices[i]];\n        if (at && CodeMirror.cmpPos(range.head, at) > 0) continue;\n        var word = wordAt(cm, range.head);\n        at = word.from;\n        cm.replaceRange(mod(word.word), word.from, word.to);\n      }\n    });\n  }\n\n  map[cK + ctrl + "Backspace"] = "delLineLeft";\n\n  cmds[map["Backspace"] = "smartBackspace"] = function(cm) {\n    if (cm.somethingSelected()) return CodeMirror.Pass;\n\n    var cursor = cm.getCursor();\n    var toStartOfLine = cm.getRange({line: cursor.line, ch: 0}, cursor);\n    var column = CodeMirror.countColumn(toStartOfLine, null, cm.getOption("tabSize"));\n    var indentUnit = cm.getOption("indentUnit");\n\n    if (toStartOfLine && !/\\S/.test(toStartOfLine) && column % indentUnit == 0) {\n      var prevIndent = new Pos(cursor.line,\n        CodeMirror.findColumn(toStartOfLine, column - indentUnit, indentUnit));\n\n      // If no smart delete is happening (due to tab sizing) just do a regular delete\n      if (prevIndent.ch == cursor.ch) return CodeMirror.Pass;\n\n      return cm.replaceRange("", prevIndent, cursor, "+delete");\n    } else {\n      return CodeMirror.Pass;\n    }\n  };\n\n  cmds[map[cK + ctrl + "K"] = "delLineRight"] = function(cm) {\n    cm.operation(function() {\n      var ranges = cm.listSelections();\n      for (var i = ranges.length - 1; i >= 0; i--)\n        cm.replaceRange("", ranges[i].anchor, Pos(ranges[i].to().line), "+delete");\n      cm.scrollIntoView();\n    });\n  };\n\n  cmds[map[cK + ctrl + "U"] = "upcaseAtCursor"] = function(cm) {\n    modifyWordOrSelection(cm, function(str) { return str.toUpperCase(); });\n  };\n  cmds[map[cK + ctrl + "L"] = "downcaseAtCursor"] = function(cm) {\n    modifyWordOrSelection(cm, function(str) { return str.toLowerCase(); });\n  };\n\n  cmds[map[cK + ctrl + "Space"] = "setSublimeMark"] = function(cm) {\n    if (cm.state.sublimeMark) cm.state.sublimeMark.clear();\n    cm.state.sublimeMark = cm.setBookmark(cm.getCursor());\n  };\n  cmds[map[cK + ctrl + "A"] = "selectToSublimeMark"] = function(cm) {\n    var found = cm.state.sublimeMark && cm.state.sublimeMark.find();\n    if (found) cm.setSelection(cm.getCursor(), found);\n  };\n  cmds[map[cK + ctrl + "W"] = "deleteToSublimeMark"] = function(cm) {\n    var found = cm.state.sublimeMark && cm.state.sublimeMark.find();\n    if (found) {\n      var from = cm.getCursor(), to = found;\n      if (CodeMirror.cmpPos(from, to) > 0) { var tmp = to; to = from; from = tmp; }\n      cm.state.sublimeKilled = cm.getRange(from, to);\n      cm.replaceRange("", from, to);\n    }\n  };\n  cmds[map[cK + ctrl + "X"] = "swapWithSublimeMark"] = function(cm) {\n    var found = cm.state.sublimeMark && cm.state.sublimeMark.find();\n    if (found) {\n      cm.state.sublimeMark.clear();\n      cm.state.sublimeMark = cm.setBookmark(cm.getCursor());\n      cm.setCursor(found);\n    }\n  };\n  cmds[map[cK + ctrl + "Y"] = "sublimeYank"] = function(cm) {\n    if (cm.state.sublimeKilled != null)\n      cm.replaceSelection(cm.state.sublimeKilled, null, "paste");\n  };\n\n  map[cK + ctrl + "G"] = "clearBookmarks";\n  cmds[map[cK + ctrl + "C"] = "showInCenter"] = function(cm) {\n    var pos = cm.cursorCoords(null, "local");\n    cm.scrollTo(null, (pos.top + pos.bottom) / 2 - cm.getScrollInfo().clientHeight / 2);\n  };\n\n  cmds[map["Shift-Alt-Up"] = "selectLinesUpward"] = function(cm) {\n    cm.operation(function() {\n      var ranges = cm.listSelections();\n      for (var i = 0; i < ranges.length; i++) {\n        var range = ranges[i];\n        if (range.head.line > cm.firstLine())\n          cm.addSelection(Pos(range.head.line - 1, range.head.ch));\n      }\n    });\n  };\n  cmds[map["Shift-Alt-Down"] = "selectLinesDownward"] = function(cm) {\n    cm.operation(function() {\n      var ranges = cm.listSelections();\n      for (var i = 0; i < ranges.length; i++) {\n        var range = ranges[i];\n        if (range.head.line < cm.lastLine())\n          cm.addSelection(Pos(range.head.line + 1, range.head.ch));\n      }\n    });\n  };\n\n  function getTarget(cm) {\n    var from = cm.getCursor("from"), to = cm.getCursor("to");\n    if (CodeMirror.cmpPos(from, to) == 0) {\n      var word = wordAt(cm, from);\n      if (!word.word) return;\n      from = word.from;\n      to = word.to;\n    }\n    return {from: from, to: to, query: cm.getRange(from, to), word: word};\n  }\n\n  function findAndGoTo(cm, forward) {\n    var target = getTarget(cm);\n    if (!target) return;\n    var query = target.query;\n    var cur = cm.getSearchCursor(query, forward ? target.to : target.from);\n\n    if (forward ? cur.findNext() : cur.findPrevious()) {\n      cm.setSelection(cur.from(), cur.to());\n    } else {\n      cur = cm.getSearchCursor(query, forward ? Pos(cm.firstLine(), 0)\n                                              : cm.clipPos(Pos(cm.lastLine())));\n      if (forward ? cur.findNext() : cur.findPrevious())\n        cm.setSelection(cur.from(), cur.to());\n      else if (target.word)\n        cm.setSelection(target.from, target.to);\n    }\n  };\n  cmds[map[ctrl + "F3"] = "findUnder"] = function(cm) { findAndGoTo(cm, true); };\n  cmds[map["Shift-" + ctrl + "F3"] = "findUnderPrevious"] = function(cm) { findAndGoTo(cm,false); };\n  cmds[map["Alt-F3"] = "findAllUnder"] = function(cm) {\n    var target = getTarget(cm);\n    if (!target) return;\n    var cur = cm.getSearchCursor(target.query);\n    var matches = [];\n    var primaryIndex = -1;\n    while (cur.findNext()) {\n      matches.push({anchor: cur.from(), head: cur.to()});\n      if (cur.from().line <= target.from.line && cur.from().ch <= target.from.ch)\n        primaryIndex++;\n    }\n    cm.setSelections(matches, primaryIndex);\n  };\n\n  map["Shift-" + ctrl + "["] = "fold";\n  map["Shift-" + ctrl + "]"] = "unfold";\n  map[cK + ctrl + "0"] = map[cK + ctrl + "j"] = "unfoldAll";\n\n  map[ctrl + "I"] = "findIncremental";\n  map["Shift-" + ctrl + "I"] = "findIncrementalReverse";\n  map[ctrl + "H"] = "replace";\n  map["F3"] = "findNext";\n  map["Shift-F3"] = "findPrev";\n\n  CodeMirror.normalizeKeyMap(map);\n});\n\n//# sourceURL=/thirdparty/CodeMirror/keymap/sublime.js'),eval('/*\n * Copyright (c) 2012 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */\n/*global define */\n\n/**\n * Defines hooks to assist with module initialization.\n *\n * This module defines 3 methods for client modules to attach callbacks:\n *    - htmlReady - When the main application template is rendered\n *    - extensionsLoaded - When the extension manager has loaded all extensions\n *    - appReady - When Brackets completes loading all modules and extensions\n *\n * These are *not* jQuery events. Each method is similar to $(document).ready\n * in that it will call the handler immediately if brackets is already done\n * loading.\n */\ndefine(\'utils/AppInit\',[\'require\',\'exports\',\'module\'],function (require, exports, module) {\n    "use strict";\n\n    /*\n     * Fires when the base htmlContent/main-view.html is loaded\n     * @type {string}\n     * @const\n     */\n    var HTML_READY  = "htmlReady";\n\n    /*\n     * Fires when all extensions are loaded\n     * @type {string}\n     * @const\n     */\n    var APP_READY   = "appReady";\n\n    /*\n     * Fires after extensions have been loaded\n     * @type {string}\n     * @const\n     */\n    var EXTENSIONS_LOADED = "extensionsLoaded";\n\n    /*\n     * Map of each state\'s trigger\n     * @type {Object.<string, boolean>}\n     * @private\n     */\n    var _status      = { HTML_READY : false, APP_READY : false, EXTENSIONS_LOADED: false };\n\n    /*\n     * Map of callbacks to states\n     * @type {Object.<string, Array.<function()>>}\n     * @private\n     */\n    var _callbacks   = {};\n\n    _callbacks[HTML_READY]        = [];\n    _callbacks[APP_READY]         = [];\n    _callbacks[EXTENSIONS_LOADED] = [];\n\n\n    /*\n     * calls the specified handler inside a try/catch handler\n     * @param {function()} handler - the callback to call\n     * @private\n     */\n    function _callHandler(handler) {\n        try {\n            // TODO (issue 1034): We *could* use a $.Deferred for this, except deferred objects enter a broken\n            // state if any resolution callback throws an exception. Since third parties (e.g. extensions) may\n            // add callbacks to this, we need to be robust to exceptions\n            handler();\n        } catch (e) {\n            console.error("Exception when calling a \'brackets done loading\' handler: " + e);\n            console.log(e.stack);\n        }\n    }\n\n    /*\n     * dispatches the event by calling all handlers registered for that type\n     * @param {string} type - the event type to dispatch (APP_READY, EXTENSIONS_READY, HTML_READY)\n     * @private\n     */\n    function _dispatchReady(type) {\n        var i,\n            myHandlers = _callbacks[type];\n\n        // mark this status complete\n        _status[type] = true;\n\n        for (i = 0; i < myHandlers.length; i++) {\n            _callHandler(myHandlers[i]);\n        }\n\n        // clear all callbacks after being called\n        _callbacks[type] = [];\n    }\n\n    /*\n     * adds a callback to the list of functions to call for the specified event type\n     * @param {string} type - the event type to dispatch (APP_READY, EXTENSIONS_READY, HTML_READY)\n     * @param {function} handler - callback funciton to call when the event is triggered\n     * @private\n     */\n    function _addListener(type, handler) {\n        if (_status[type]) {\n            _callHandler(handler);\n        } else {\n            _callbacks[type].push(handler);\n        }\n    }\n\n    /**\n     * Adds a callback for the ready hook. Handlers are called after\n     * htmlReady is done, the initial project is loaded, and all extensions are\n     * loaded.\n     * @param {function} handler - callback function to call when the event is fired\n     */\n    function appReady(handler) {\n        _addListener(APP_READY, handler);\n    }\n\n    /**\n     * Adds a callback for the htmlReady hook. Handlers are called after the\n     * main application html template is rendered.\n     * @param {function} handler - callback function to call when the event is fired\n     */\n    function htmlReady(handler) {\n        _addListener(HTML_READY, handler);\n    }\n\n    /**\n     * Adds a callback for the extensionsLoaded hook. Handlers are called after the\n     * extensions have been loaded\n     * @param {function} handler - callback function to call when the event is fired\n     */\n    function extensionsLoaded(handler) {\n        _addListener(EXTENSIONS_LOADED, handler);\n    }\n\n    // Public API\n    exports.appReady = appReady;\n    exports.htmlReady = htmlReady;\n    exports.extensionsLoaded = extensionsLoaded;\n\n    exports.HTML_READY = HTML_READY;\n    exports.APP_READY = APP_READY;\n    exports.EXTENSIONS_LOADED = EXTENSIONS_LOADED;\n\n    // Unit Test API\n    exports._dispatchReady = _dispatchReady;\n});\n\n//# sourceURL=/utils/AppInit.js'),eval('/**\n * @license\n * lodash 3.10.0 (Custom Build) lodash.com/license | Underscore.js 1.8.3 underscorejs.org/LICENSE\n * Build: `lodash modern exports="amd"`\n */\n;(function(){function n(n,t){if(n!==t){var r=null===n,e=n===w,u=n===n,o=null===t,i=t===w,f=t===t;if(n>t&&!o||!u||r&&!i&&f||e&&f)return 1;if(n<t&&!r||!f||o&&!e&&u||i&&u)return-1}return 0}function t(n,t,r){for(var e=n.length,u=r?e:-1;r?u--:++u<e;)if(t(n[u],u,n))return u;return-1}function r(n,t,r){if(t!==t)return p(n,r);r-=1;for(var e=n.length;++r<e;)if(n[r]===t)return r;return-1}function e(n){return typeof n=="function"||false}function u(n){return null==n?"":n+""}function o(n,t){for(var r=-1,e=n.length;++r<e&&-1<t.indexOf(n.charAt(r)););\nreturn r}function i(n,t){for(var r=n.length;r--&&-1<t.indexOf(n.charAt(r)););return r}function f(t,r){return n(t.a,r.a)||t.b-r.b}function a(n){return Nn[n]}function c(n){return Tn[n]}function l(n,t,r){return t?n=Bn[n]:r&&(n=Dn[n]),"\\\\"+n}function s(n){return"\\\\"+Dn[n]}function p(n,t,r){var e=n.length;for(t+=r?0:-1;r?t--:++t<e;){var u=n[t];if(u!==u)return t}return-1}function h(n){return!!n&&typeof n=="object"}function _(n){return 160>=n&&9<=n&&13>=n||32==n||160==n||5760==n||6158==n||8192<=n&&(8202>=n||8232==n||8233==n||8239==n||8287==n||12288==n||65279==n);\n}function v(n,t){for(var r=-1,e=n.length,u=-1,o=[];++r<e;)n[r]===t&&(n[r]=z,o[++u]=r);return o}function g(n){for(var t=-1,r=n.length;++t<r&&_(n.charCodeAt(t)););return t}function y(n){for(var t=n.length;t--&&_(n.charCodeAt(t)););return t}function d(n){return Ln[n]}function m(_){function Nn(n){if(h(n)&&!(Oo(n)||n instanceof zn)){if(n instanceof Ln)return n;if(nu.call(n,"__chain__")&&nu.call(n,"__wrapped__"))return Mr(n)}return new Ln(n)}function Tn(){}function Ln(n,t,r){this.__wrapped__=n,this.__actions__=r||[],\nthis.__chain__=!!t}function zn(n){this.__wrapped__=n,this.__actions__=[],this.__dir__=1,this.__filtered__=false,this.__iteratees__=[],this.__takeCount__=Ru,this.__views__=[]}function Bn(){this.__data__={}}function Dn(n){var t=n?n.length:0;for(this.data={hash:gu(null),set:new lu};t--;)this.push(n[t])}function Mn(n,t){var r=n.data;return(typeof t=="string"||ge(t)?r.set.has(t):r.hash[t])?0:-1}function qn(n,t){var r=-1,e=n.length;for(t||(t=Be(e));++r<e;)t[r]=n[r];return t}function Pn(n,t){for(var r=-1,e=n.length;++r<e&&false!==t(n[r],r,n););\nreturn n}function Zn(n,t){for(var r=-1,e=n.length;++r<e;)if(!t(n[r],r,n))return false;return true}function Yn(n,t){for(var r=-1,e=n.length,u=-1,o=[];++r<e;){var i=n[r];t(i,r,n)&&(o[++u]=i)}return o}function Gn(n,t){for(var r=-1,e=n.length,u=Be(e);++r<e;)u[r]=t(n[r],r,n);return u}function Jn(n,t){for(var r=-1,e=t.length,u=n.length;++r<e;)n[u+r]=t[r];return n}function Xn(n,t,r,e){var u=-1,o=n.length;for(e&&o&&(r=n[++u]);++u<o;)r=t(r,n[u],u,n);return r}function Hn(n,t){for(var r=-1,e=n.length;++r<e;)if(t(n[r],r,n))return true;\nreturn false}function Qn(n,t,r,e){return n!==w&&nu.call(e,r)?n:t}function nt(n,t,r){for(var e=-1,u=zo(t),o=u.length;++e<o;){var i=u[e],f=n[i],a=r(f,t[i],i,n,t);(a===a?a===f:f!==f)&&(f!==w||i in n)||(n[i]=a)}return n}function tt(n,t){return null==t?n:et(t,zo(t),n)}function rt(n,t){for(var r=-1,e=null==n,u=!e&&Er(n),o=u?n.length:0,i=t.length,f=Be(i);++r<i;){var a=t[r];f[r]=u?Cr(a,o)?n[a]:w:e?w:n[a]}return f}function et(n,t,r){r||(r={});for(var e=-1,u=t.length;++e<u;){var o=t[e];r[o]=n[o]}return r}function ut(n,t,r){\nvar e=typeof n;return"function"==e?t===w?n:Bt(n,t,r):null==n?Fe:"object"==e?bt(n):t===w?ze(n):xt(n,t)}function ot(n,t,r,e,u,o,i){var f;if(r&&(f=u?r(n,e,u):r(n)),f!==w)return f;if(!ge(n))return n;if(e=Oo(n)){if(f=kr(n),!t)return qn(n,f)}else{var a=ru.call(n),c=a==K;if(a!=Z&&a!=B&&(!c||u))return Fn[a]?Rr(n,a,t):u?n:{};if(f=Ir(c?{}:n),!t)return tt(f,n)}for(o||(o=[]),i||(i=[]),u=o.length;u--;)if(o[u]==n)return i[u];return o.push(n),i.push(f),(e?Pn:_t)(n,function(e,u){f[u]=ot(e,t,r,u,n,o,i)}),f}function it(n,t,r){\nif(typeof n!="function")throw new Ge(L);return su(function(){n.apply(w,r)},t)}function ft(n,t){var e=n?n.length:0,u=[];if(!e)return u;var o=-1,i=xr(),f=i==r,a=f&&t.length>=F&&gu&&lu?new Dn(t):null,c=t.length;a&&(i=Mn,f=false,t=a);n:for(;++o<e;)if(a=n[o],f&&a===a){for(var l=c;l--;)if(t[l]===a)continue n;u.push(a)}else 0>i(t,a,0)&&u.push(a);return u}function at(n,t){var r=true;return Su(n,function(n,e,u){return r=!!t(n,e,u)}),r}function ct(n,t,r,e){var u=e,o=u;return Su(n,function(n,i,f){i=+t(n,i,f),(r(i,u)||i===e&&i===o)&&(u=i,\no=n)}),o}function lt(n,t){var r=[];return Su(n,function(n,e,u){t(n,e,u)&&r.push(n)}),r}function st(n,t,r,e){var u;return r(n,function(n,r,o){return t(n,r,o)?(u=e?r:n,false):void 0}),u}function pt(n,t,r,e){e||(e=[]);for(var u=-1,o=n.length;++u<o;){var i=n[u];h(i)&&Er(i)&&(r||Oo(i)||pe(i))?t?pt(i,t,r,e):Jn(e,i):r||(e[e.length]=i)}return e}function ht(n,t){Nu(n,t,Re)}function _t(n,t){return Nu(n,t,zo)}function vt(n,t){return Tu(n,t,zo)}function gt(n,t){for(var r=-1,e=t.length,u=-1,o=[];++r<e;){var i=t[r];\nve(n[i])&&(o[++u]=i)}return o}function yt(n,t,r){if(null!=n){r!==w&&r in Br(n)&&(t=[r]),r=0;for(var e=t.length;null!=n&&r<e;)n=n[t[r++]];return r&&r==e?n:w}}function dt(n,t,r,e,u,o){if(n===t)n=true;else if(null==n||null==t||!ge(n)&&!h(t))n=n!==n&&t!==t;else n:{var i=dt,f=Oo(n),a=Oo(t),c=D,l=D;f||(c=ru.call(n),c==B?c=Z:c!=Z&&(f=xe(n))),a||(l=ru.call(t),l==B?l=Z:l!=Z&&xe(t));var s=c==Z,a=l==Z,l=c==l;if(!l||f||s){if(!e&&(c=s&&nu.call(n,"__wrapped__"),a=a&&nu.call(t,"__wrapped__"),c||a)){n=i(c?n.value():n,a?t.value():t,r,e,u,o);\nbreak n}if(l){for(u||(u=[]),o||(o=[]),c=u.length;c--;)if(u[c]==n){n=o[c]==t;break n}u.push(n),o.push(t),n=(f?yr:mr)(n,t,i,r,e,u,o),u.pop(),o.pop()}else n=false}else n=dr(n,t,c)}return n}function mt(n,t,r){var e=t.length,u=e,o=!r;if(null==n)return!u;for(n=Br(n);e--;){var i=t[e];if(o&&i[2]?i[1]!==n[i[0]]:!(i[0]in n))return false}for(;++e<u;){var i=t[e],f=i[0],a=n[f],c=i[1];if(o&&i[2]){if(a===w&&!(f in n))return false}else if(i=r?r(a,c,f):w,i===w?!dt(c,a,r,true):!i)return false}return true}function wt(n,t){var r=-1,e=Er(n)?Be(n.length):[];\nreturn Su(n,function(n,u,o){e[++r]=t(n,u,o)}),e}function bt(n){var t=Ar(n);if(1==t.length&&t[0][2]){var r=t[0][0],e=t[0][1];return function(n){return null==n?false:n[r]===e&&(e!==w||r in Br(n))}}return function(n){return mt(n,t)}}function xt(n,t){var r=Oo(n),e=Wr(n)&&t===t&&!ge(t),u=n+"";return n=Dr(n),function(o){if(null==o)return false;var i=u;if(o=Br(o),!(!r&&e||i in o)){if(o=1==n.length?o:yt(o,Et(n,0,-1)),null==o)return false;i=Zr(n),o=Br(o)}return o[i]===t?t!==w||i in o:dt(t,o[i],w,true)}}function At(n,t,r,e,u){\nif(!ge(n))return n;var o=Er(t)&&(Oo(t)||xe(t)),i=o?w:zo(t);return Pn(i||t,function(f,a){if(i&&(a=f,f=t[a]),h(f)){e||(e=[]),u||(u=[]);n:{for(var c=a,l=e,s=u,p=l.length,_=t[c];p--;)if(l[p]==_){n[c]=s[p];break n}var p=n[c],v=r?r(p,_,c,n,t):w,g=v===w;g&&(v=_,Er(_)&&(Oo(_)||xe(_))?v=Oo(p)?p:Er(p)?qn(p):[]:me(_)||pe(_)?v=pe(p)?ke(p):me(p)?p:{}:g=false),l.push(_),s.push(v),g?n[c]=At(v,_,r,l,s):(v===v?v!==p:p===p)&&(n[c]=v)}}else c=n[a],l=r?r(c,f,a,n,t):w,(s=l===w)&&(l=f),l===w&&(!o||a in n)||!s&&(l===l?l===c:c!==c)||(n[a]=l);\n}),n}function jt(n){return function(t){return null==t?w:t[n]}}function kt(n){var t=n+"";return n=Dr(n),function(r){return yt(r,n,t)}}function It(n,t){for(var r=n?t.length:0;r--;){var e=t[r];if(e!=u&&Cr(e)){var u=e;pu.call(n,e,1)}}}function Rt(n,t){return n+yu(ku()*(t-n+1))}function Ot(n,t,r,e,u){return u(n,function(n,u,o){r=e?(e=false,n):t(r,n,u,o)}),r}function Et(n,t,r){var e=-1,u=n.length;for(t=null==t?0:+t||0,0>t&&(t=-t>u?0:u+t),r=r===w||r>u?u:+r||0,0>r&&(r+=u),u=t>r?0:r-t>>>0,t>>>=0,r=Be(u);++e<u;)r[e]=n[e+t];\nreturn r}function Ct(n,t){var r;return Su(n,function(n,e,u){return r=t(n,e,u),!r}),!!r}function Ut(n,t){var r=n.length;for(n.sort(t);r--;)n[r]=n[r].c;return n}function Wt(t,r,e){var u=wr(),o=-1;return r=Gn(r,function(n){return u(n)}),t=wt(t,function(n){return{a:Gn(r,function(t){return t(n)}),b:++o,c:n}}),Ut(t,function(t,r){var u;n:{for(var o=-1,i=t.a,f=r.a,a=i.length,c=e.length;++o<a;)if(u=n(i[o],f[o])){if(o>=c)break n;o=e[o],u*="asc"===o||true===o?1:-1;break n}u=t.b-r.b}return u})}function $t(n,t){\nvar r=0;return Su(n,function(n,e,u){r+=+t(n,e,u)||0}),r}function St(n,t){var e=-1,u=xr(),o=n.length,i=u==r,f=i&&o>=F,a=f&&gu&&lu?new Dn(void 0):null,c=[];a?(u=Mn,i=false):(f=false,a=t?[]:c);n:for(;++e<o;){var l=n[e],s=t?t(l,e,n):l;if(i&&l===l){for(var p=a.length;p--;)if(a[p]===s)continue n;t&&a.push(s),c.push(l)}else 0>u(a,s,0)&&((t||f)&&a.push(s),c.push(l))}return c}function Ft(n,t){for(var r=-1,e=t.length,u=Be(e);++r<e;)u[r]=n[t[r]];return u}function Nt(n,t,r,e){for(var u=n.length,o=e?u:-1;(e?o--:++o<u)&&t(n[o],o,n););\nreturn r?Et(n,e?0:o,e?o+1:u):Et(n,e?o+1:0,e?u:o)}function Tt(n,t){var r=n;r instanceof zn&&(r=r.value());for(var e=-1,u=t.length;++e<u;)var o=t[e],r=o.func.apply(o.thisArg,Jn([r],o.args));return r}function Lt(n,t,r){var e=0,u=n?n.length:e;if(typeof t=="number"&&t===t&&u<=Eu){for(;e<u;){var o=e+u>>>1,i=n[o];(r?i<=t:i<t)&&null!==i?e=o+1:u=o}return u}return zt(n,t,Fe,r)}function zt(n,t,r,e){t=r(t);for(var u=0,o=n?n.length:0,i=t!==t,f=null===t,a=t===w;u<o;){var c=yu((u+o)/2),l=r(n[c]),s=l!==w,p=l===l;\n(i?p||e:f?p&&s&&(e||null!=l):a?p&&(e||s):null==l?0:e?l<=t:l<t)?u=c+1:o=c}return xu(o,Ou)}function Bt(n,t,r){if(typeof n!="function")return Fe;if(t===w)return n;switch(r){case 1:return function(r){return n.call(t,r)};case 3:return function(r,e,u){return n.call(t,r,e,u)};case 4:return function(r,e,u,o){return n.call(t,r,e,u,o)};case 5:return function(r,e,u,o,i){return n.call(t,r,e,u,o,i)}}return function(){return n.apply(t,arguments)}}function Dt(n){var t=new ou(n.byteLength);return new hu(t).set(new hu(n)),\nt}function Mt(n,t,r){for(var e=r.length,u=-1,o=bu(n.length-e,0),i=-1,f=t.length,a=Be(f+o);++i<f;)a[i]=t[i];for(;++u<e;)a[r[u]]=n[u];for(;o--;)a[i++]=n[u++];return a}function qt(n,t,r){for(var e=-1,u=r.length,o=-1,i=bu(n.length-u,0),f=-1,a=t.length,c=Be(i+a);++o<i;)c[o]=n[o];for(i=o;++f<a;)c[i+f]=t[f];for(;++e<u;)c[i+r[e]]=n[o++];return c}function Pt(n,t){return function(r,e,u){var o=t?t():{};if(e=wr(e,u,3),Oo(r)){u=-1;for(var i=r.length;++u<i;){var f=r[u];n(o,f,e(f,u,r),r)}}else Su(r,function(t,r,u){\nn(o,t,e(t,r,u),u)});return o}}function Kt(n){return le(function(t,r){var e=-1,u=null==t?0:r.length,o=2<u?r[u-2]:w,i=2<u?r[2]:w,f=1<u?r[u-1]:w;for(typeof o=="function"?(o=Bt(o,f,5),u-=2):(o=typeof f=="function"?f:w,u-=o?1:0),i&&Ur(r[0],r[1],i)&&(o=3>u?w:o,u=1);++e<u;)(i=r[e])&&n(t,i,o);return t})}function Vt(n,t){return function(r,e){var u=r?Bu(r):0;if(!Sr(u))return n(r,e);for(var o=t?u:-1,i=Br(r);(t?o--:++o<u)&&false!==e(i[o],o,i););return r}}function Zt(n){return function(t,r,e){var u=Br(t);e=e(t);for(var o=e.length,i=n?o:-1;n?i--:++i<o;){\nvar f=e[i];if(false===r(u[f],f,u))break}return t}}function Yt(n,t){function r(){return(this&&this!==Kn&&this instanceof r?e:n).apply(t,arguments)}var e=Jt(n);return r}function Gt(n){return function(t){var r=-1;t=$e(Ce(t));for(var e=t.length,u="";++r<e;)u=n(u,t[r],r);return u}}function Jt(n){return function(){var t=arguments;switch(t.length){case 0:return new n;case 1:return new n(t[0]);case 2:return new n(t[0],t[1]);case 3:return new n(t[0],t[1],t[2]);case 4:return new n(t[0],t[1],t[2],t[3]);case 5:\nreturn new n(t[0],t[1],t[2],t[3],t[4]);case 6:return new n(t[0],t[1],t[2],t[3],t[4],t[5]);case 7:return new n(t[0],t[1],t[2],t[3],t[4],t[5],t[6])}var r=$u(n.prototype),t=n.apply(r,t);return ge(t)?t:r}}function Xt(n){function t(r,e,u){return u&&Ur(r,e,u)&&(e=w),r=gr(r,n,w,w,w,w,w,e),r.placeholder=t.placeholder,r}return t}function Ht(n,t){return le(function(r){var e=r[0];return null==e?e:(r.push(t),n.apply(w,r))})}function Qt(n,t){return function(r,e,u){if(u&&Ur(r,e,u)&&(e=w),e=wr(e,u,3),1==e.length){\nu=r=Oo(r)?r:zr(r);for(var o=e,i=-1,f=u.length,a=t,c=a;++i<f;){var l=u[i],s=+o(l);n(s,a)&&(a=s,c=l)}if(u=c,!r.length||u!==t)return u}return ct(r,e,n,t)}}function nr(n,r){return function(e,u,o){return u=wr(u,o,3),Oo(e)?(u=t(e,u,r),-1<u?e[u]:w):st(e,u,n)}}function tr(n){return function(r,e,u){return r&&r.length?(e=wr(e,u,3),t(r,e,n)):-1}}function rr(n){return function(t,r,e){return r=wr(r,e,3),st(t,r,n,true)}}function er(n){return function(){for(var t,r=arguments.length,e=n?r:-1,u=0,o=Be(r);n?e--:++e<r;){\nvar i=o[u++]=arguments[e];if(typeof i!="function")throw new Ge(L);!t&&Ln.prototype.thru&&"wrapper"==br(i)&&(t=new Ln([],true))}for(e=t?-1:r;++e<r;){var i=o[e],u=br(i),f="wrapper"==u?zu(i):w;t=f&&$r(f[0])&&f[1]==(E|k|R|C)&&!f[4].length&&1==f[9]?t[br(f[0])].apply(t,f[3]):1==i.length&&$r(i)?t[u]():t.thru(i)}return function(){var n=arguments,e=n[0];if(t&&1==n.length&&Oo(e)&&e.length>=F)return t.plant(e).value();for(var u=0,n=r?o[u].apply(this,n):e;++u<r;)n=o[u].call(this,n);return n}}}function ur(n,t){\nreturn function(r,e,u){return typeof e=="function"&&u===w&&Oo(r)?n(r,e):t(r,Bt(e,u,3))}}function or(n){return function(t,r,e){return(typeof r!="function"||e!==w)&&(r=Bt(r,e,3)),n(t,r,Re)}}function ir(n){return function(t,r,e){return(typeof r!="function"||e!==w)&&(r=Bt(r,e,3)),n(t,r)}}function fr(n){return function(t,r,e){var u={};return r=wr(r,e,3),_t(t,function(t,e,o){o=r(t,e,o),e=n?o:e,t=n?t:o,u[e]=t}),u}}function ar(n){return function(t,r,e){return t=u(t),(n?t:"")+pr(t,r,e)+(n?"":t)}}function cr(n){\nvar t=le(function(r,e){var u=v(e,t.placeholder);return gr(r,n,w,e,u)});return t}function lr(n,t){return function(r,e,u,o){var i=3>arguments.length;return typeof e=="function"&&o===w&&Oo(r)?n(r,e,u,i):Ot(r,wr(e,o,4),u,i,t)}}function sr(n,t,r,e,u,o,i,f,a,c){function l(){for(var m=arguments.length,b=m,j=Be(m);b--;)j[b]=arguments[b];if(e&&(j=Mt(j,e,u)),o&&(j=qt(j,o,i)),_||y){var b=l.placeholder,k=v(j,b),m=m-k.length;if(m<c){var I=f?qn(f):w,m=bu(c-m,0),E=_?k:w,k=_?w:k,C=_?j:w,j=_?w:j;return t|=_?R:O,t&=~(_?O:R),\ng||(t&=~(x|A)),j=[n,t,r,C,E,j,k,I,a,m],I=sr.apply(w,j),$r(n)&&Du(I,j),I.placeholder=b,I}}if(b=p?r:this,I=h?b[n]:n,f)for(m=j.length,E=xu(f.length,m),k=qn(j);E--;)C=f[E],j[E]=Cr(C,m)?k[C]:w;return s&&a<j.length&&(j.length=a),this&&this!==Kn&&this instanceof l&&(I=d||Jt(n)),I.apply(b,j)}var s=t&E,p=t&x,h=t&A,_=t&k,g=t&j,y=t&I,d=h?w:Jt(n);return l}function pr(n,t,r){return n=n.length,t=+t,n<t&&mu(t)?(t-=n,r=null==r?" ":r+"",Ue(r,vu(t/r.length)).slice(0,t)):""}function hr(n,t,r,e){function u(){for(var t=-1,f=arguments.length,a=-1,c=e.length,l=Be(c+f);++a<c;)l[a]=e[a];\nfor(;f--;)l[a++]=arguments[++t];return(this&&this!==Kn&&this instanceof u?i:n).apply(o?r:this,l)}var o=t&x,i=Jt(n);return u}function _r(n){var t=Pe[n];return function(n,r){return(r=r===w?0:+r||0)?(r=au(10,r),t(n*r)/r):t(n)}}function vr(n){return function(t,r,e,u){var o=wr(e);return null==e&&o===ut?Lt(t,r,n):zt(t,r,o(e,u,1),n)}}function gr(n,t,r,e,u,o,i,f){var a=t&A;if(!a&&typeof n!="function")throw new Ge(L);var c=e?e.length:0;if(c||(t&=~(R|O),e=u=w),c-=u?u.length:0,t&O){var l=e,s=u;e=u=w}var p=a?w:zu(n);\nreturn r=[n,t,r,e,u,l,s,o,i,f],p&&(e=r[1],t=p[1],f=e|t,u=t==E&&e==k||t==E&&e==C&&r[7].length<=p[8]||t==(E|C)&&e==k,(f<E||u)&&(t&x&&(r[2]=p[2],f|=e&x?0:j),(e=p[3])&&(u=r[3],r[3]=u?Mt(u,e,p[4]):qn(e),r[4]=u?v(r[3],z):qn(p[4])),(e=p[5])&&(u=r[5],r[5]=u?qt(u,e,p[6]):qn(e),r[6]=u?v(r[5],z):qn(p[6])),(e=p[7])&&(r[7]=qn(e)),t&E&&(r[8]=null==r[8]?p[8]:xu(r[8],p[8])),null==r[9]&&(r[9]=p[9]),r[0]=p[0],r[1]=f),t=r[1],f=r[9]),r[9]=null==f?a?0:n.length:bu(f-c,0)||0,(p?Lu:Du)(t==x?Yt(r[0],r[2]):t!=R&&t!=(x|R)||r[4].length?sr.apply(w,r):hr.apply(w,r),r);\n}function yr(n,t,r,e,u,o,i){var f=-1,a=n.length,c=t.length;if(a!=c&&(!u||c<=a))return false;for(;++f<a;){var l=n[f],c=t[f],s=e?e(u?c:l,u?l:c,f):w;if(s!==w){if(s)continue;return false}if(u){if(!Hn(t,function(n){return l===n||r(l,n,e,u,o,i)}))return false}else if(l!==c&&!r(l,c,e,u,o,i))return false}return true}function dr(n,t,r){switch(r){case M:case q:return+n==+t;case P:return n.name==t.name&&n.message==t.message;case V:return n!=+n?t!=+t:n==+t;case Y:case G:return n==t+""}return false}function mr(n,t,r,e,u,o,i){var f=zo(n),a=f.length,c=zo(t).length;\nif(a!=c&&!u)return false;for(c=a;c--;){var l=f[c];if(!(u?l in t:nu.call(t,l)))return false}for(var s=u;++c<a;){var l=f[c],p=n[l],h=t[l],_=e?e(u?h:p,u?p:h,l):w;if(_===w?!r(p,h,e,u,o,i):!_)return false;s||(s="constructor"==l)}return s||(r=n.constructor,e=t.constructor,!(r!=e&&"constructor"in n&&"constructor"in t)||typeof r=="function"&&r instanceof r&&typeof e=="function"&&e instanceof e)?true:false}function wr(n,t,r){var e=Nn.callback||Se,e=e===Se?ut:e;return r?e(n,t,r):e}function br(n){for(var t=n.name,r=Wu[t],e=r?r.length:0;e--;){\nvar u=r[e],o=u.func;if(null==o||o==n)return u.name}return t}function xr(n,t,e){var u=Nn.indexOf||Vr,u=u===Vr?r:u;return n?u(n,t,e):u}function Ar(n){n=Oe(n);for(var t=n.length;t--;){var r=n[t][1];n[t][2]=r===r&&!ge(r)}return n}function jr(n,t){var r=null==n?w:n[t];return ye(r)?r:w}function kr(n){var t=n.length,r=new n.constructor(t);return t&&"string"==typeof n[0]&&nu.call(n,"index")&&(r.index=n.index,r.input=n.input),r}function Ir(n){return n=n.constructor,typeof n=="function"&&n instanceof n||(n=Ve),\nnew n}function Rr(n,t,r){var e=n.constructor;switch(t){case J:return Dt(n);case M:case q:return new e(+n);case X:case H:case Q:case nn:case tn:case rn:case en:case un:case on:return t=n.buffer,new e(r?Dt(t):t,n.byteOffset,n.length);case V:case G:return new e(n);case Y:var u=new e(n.source,kn.exec(n));u.lastIndex=n.lastIndex}return u}function Or(n,t,r){return null==n||Wr(t,n)||(t=Dr(t),n=1==t.length?n:yt(n,Et(t,0,-1)),t=Zr(t)),t=null==n?n:n[t],null==t?w:t.apply(n,r)}function Er(n){return null!=n&&Sr(Bu(n));\n}function Cr(n,t){return n=typeof n=="number"||On.test(n)?+n:-1,t=null==t?Cu:t,-1<n&&0==n%1&&n<t}function Ur(n,t,r){if(!ge(r))return false;var e=typeof t;return("number"==e?Er(r)&&Cr(t,r.length):"string"==e&&t in r)?(t=r[t],n===n?n===t:t!==t):false}function Wr(n,t){var r=typeof n;return"string"==r&&dn.test(n)||"number"==r?true:Oo(n)?false:!yn.test(n)||null!=t&&n in Br(t)}function $r(n){var t=br(n);return t in zn.prototype?(t=Nn[t],n===t?true:(t=zu(t),!!t&&n===t[0])):false}function Sr(n){return typeof n=="number"&&-1<n&&0==n%1&&n<=Cu;\n}function Fr(n,t){return n===w?t:Eo(n,t,Fr)}function Nr(n,t){n=Br(n);for(var r=-1,e=t.length,u={};++r<e;){var o=t[r];o in n&&(u[o]=n[o])}return u}function Tr(n,t){var r={};return ht(n,function(n,e,u){t(n,e,u)&&(r[e]=n)}),r}function Lr(n){for(var t=Re(n),r=t.length,e=r&&n.length,u=!!e&&Sr(e)&&(Oo(n)||pe(n)),o=-1,i=[];++o<r;){var f=t[o];(u&&Cr(f,e)||nu.call(n,f))&&i.push(f)}return i}function zr(n){return null==n?[]:Er(n)?ge(n)?n:Ve(n):Ee(n)}function Br(n){return ge(n)?n:Ve(n)}function Dr(n){if(Oo(n))return n;\nvar t=[];return u(n).replace(mn,function(n,r,e,u){t.push(e?u.replace(An,"$1"):r||n)}),t}function Mr(n){return n instanceof zn?n.clone():new Ln(n.__wrapped__,n.__chain__,qn(n.__actions__))}function qr(n,t,r){return n&&n.length?((r?Ur(n,t,r):null==t)&&(t=1),Et(n,0>t?0:t)):[]}function Pr(n,t,r){var e=n?n.length:0;return e?((r?Ur(n,t,r):null==t)&&(t=1),t=e-(+t||0),Et(n,0,0>t?0:t)):[]}function Kr(n){return n?n[0]:w}function Vr(n,t,e){var u=n?n.length:0;if(!u)return-1;if(typeof e=="number")e=0>e?bu(u+e,0):e;else if(e)return e=Lt(n,t),\ne<u&&(t===t?t===n[e]:n[e]!==n[e])?e:-1;return r(n,t,e||0)}function Zr(n){var t=n?n.length:0;return t?n[t-1]:w}function Yr(n){return qr(n,1)}function Gr(n,t,e,u){if(!n||!n.length)return[];null!=t&&typeof t!="boolean"&&(u=e,e=Ur(n,t,u)?w:t,t=false);var o=wr();if((null!=e||o!==ut)&&(e=o(e,u,3)),t&&xr()==r){t=e;var i;e=-1,u=n.length;for(var o=-1,f=[];++e<u;){var a=n[e],c=t?t(a,e,n):a;e&&i===c||(i=c,f[++o]=a)}n=f}else n=St(n,e);return n}function Jr(n){if(!n||!n.length)return[];var t=-1,r=0;n=Yn(n,function(n){\nreturn Er(n)?(r=bu(n.length,r),true):void 0});for(var e=Be(r);++t<r;)e[t]=Gn(n,jt(t));return e}function Xr(n,t,r){return n&&n.length?(n=Jr(n),null==t?n:(t=Bt(t,r,4),Gn(n,function(n){return Xn(n,t,w,true)}))):[]}function Hr(n,t){var r=-1,e=n?n.length:0,u={};for(!e||t||Oo(n[0])||(t=[]);++r<e;){var o=n[r];t?u[o]=t[r]:o&&(u[o[0]]=o[1])}return u}function Qr(n){return n=Nn(n),n.__chain__=true,n}function ne(n,t,r){return t.call(r,n)}function te(n,t,r){var e=Oo(n)?Zn:at;return r&&Ur(n,t,r)&&(t=w),(typeof t!="function"||r!==w)&&(t=wr(t,r,3)),\ne(n,t)}function re(n,t,r){var e=Oo(n)?Yn:lt;return t=wr(t,r,3),e(n,t)}function ee(n,t,r,e){var u=n?Bu(n):0;return Sr(u)||(n=Ee(n),u=n.length),r=typeof r!="number"||e&&Ur(t,r,e)?0:0>r?bu(u+r,0):r||0,typeof n=="string"||!Oo(n)&&be(n)?r<=u&&-1<n.indexOf(t,r):!!u&&-1<xr(n,t,r)}function ue(n,t,r){var e=Oo(n)?Gn:wt;return t=wr(t,r,3),e(n,t)}function oe(n,t,r){if(r?Ur(n,t,r):null==t){n=zr(n);var e=n.length;return 0<e?n[Rt(0,e-1)]:w}r=-1,n=je(n);var e=n.length,u=e-1;for(t=xu(0>t?0:+t||0,e);++r<t;){var e=Rt(r,u),o=n[e];\nn[e]=n[r],n[r]=o}return n.length=t,n}function ie(n,t,r){var e=Oo(n)?Hn:Ct;return r&&Ur(n,t,r)&&(t=w),(typeof t!="function"||r!==w)&&(t=wr(t,r,3)),e(n,t)}function fe(n,t){var r;if(typeof t!="function"){if(typeof n!="function")throw new Ge(L);var e=n;n=t,t=e}return function(){return 0<--n&&(r=t.apply(this,arguments)),1>=n&&(t=w),r}}function ae(n,t,r){function e(t,r){r&&iu(r),a=p=h=w,t&&(_=ho(),c=n.apply(s,f),p||a||(f=s=w))}function u(){var n=t-(ho()-l);0>=n||n>t?e(h,a):p=su(u,n)}function o(){e(g,p);\n}function i(){if(f=arguments,l=ho(),s=this,h=g&&(p||!y),false===v)var r=y&&!p;else{a||y||(_=l);var e=v-(l-_),i=0>=e||e>v;i?(a&&(a=iu(a)),_=l,c=n.apply(s,f)):a||(a=su(o,e))}return i&&p?p=iu(p):p||t===v||(p=su(u,t)),r&&(i=true,c=n.apply(s,f)),!i||p||a||(f=s=w),c}var f,a,c,l,s,p,h,_=0,v=false,g=true;if(typeof n!="function")throw new Ge(L);if(t=0>t?0:+t||0,true===r)var y=true,g=false;else ge(r)&&(y=!!r.leading,v="maxWait"in r&&bu(+r.maxWait||0,t),g="trailing"in r?!!r.trailing:g);return i.cancel=function(){p&&iu(p),a&&iu(a),\n_=0,a=p=h=w},i}function ce(n,t){function r(){var e=arguments,u=t?t.apply(this,e):e[0],o=r.cache;return o.has(u)?o.get(u):(e=n.apply(this,e),r.cache=o.set(u,e),e)}if(typeof n!="function"||t&&typeof t!="function")throw new Ge(L);return r.cache=new ce.Cache,r}function le(n,t){if(typeof n!="function")throw new Ge(L);return t=bu(t===w?n.length-1:+t||0,0),function(){for(var r=arguments,e=-1,u=bu(r.length-t,0),o=Be(u);++e<u;)o[e]=r[t+e];switch(t){case 0:return n.call(this,o);case 1:return n.call(this,r[0],o);\ncase 2:return n.call(this,r[0],r[1],o)}for(u=Be(t+1),e=-1;++e<t;)u[e]=r[e];return u[t]=o,n.apply(this,u)}}function se(n,t){return n>t}function pe(n){return h(n)&&Er(n)&&nu.call(n,"callee")&&!cu.call(n,"callee")}function he(n,t,r,e){return e=(r=typeof r=="function"?Bt(r,e,3):w)?r(n,t):w,e===w?dt(n,t,r):!!e}function _e(n){return h(n)&&typeof n.message=="string"&&ru.call(n)==P}function ve(n){return ge(n)&&ru.call(n)==K}function ge(n){var t=typeof n;return!!n&&("object"==t||"function"==t)}function ye(n){\nreturn null==n?false:ve(n)?uu.test(Qe.call(n)):h(n)&&Rn.test(n)}function de(n){return typeof n=="number"||h(n)&&ru.call(n)==V}function me(n){var t;if(!h(n)||ru.call(n)!=Z||pe(n)||!(nu.call(n,"constructor")||(t=n.constructor,typeof t!="function"||t instanceof t)))return false;var r;return ht(n,function(n,t){r=t}),r===w||nu.call(n,r)}function we(n){return ge(n)&&ru.call(n)==Y}function be(n){return typeof n=="string"||h(n)&&ru.call(n)==G}function xe(n){return h(n)&&Sr(n.length)&&!!Sn[ru.call(n)]}function Ae(n,t){\nreturn n<t}function je(n){var t=n?Bu(n):0;return Sr(t)?t?qn(n):[]:Ee(n)}function ke(n){return et(n,Re(n))}function Ie(n){return gt(n,Re(n))}function Re(n){if(null==n)return[];ge(n)||(n=Ve(n));for(var t=n.length,t=t&&Sr(t)&&(Oo(n)||pe(n))&&t||0,r=n.constructor,e=-1,r=typeof r=="function"&&r.prototype===n,u=Be(t),o=0<t;++e<t;)u[e]=e+"";for(var i in n)o&&Cr(i,t)||"constructor"==i&&(r||!nu.call(n,i))||u.push(i);return u}function Oe(n){n=Br(n);for(var t=-1,r=zo(n),e=r.length,u=Be(e);++t<e;){var o=r[t];\nu[t]=[o,n[o]]}return u}function Ee(n){return Ft(n,zo(n))}function Ce(n){return(n=u(n))&&n.replace(En,a).replace(xn,"")}function Ue(n,t){var r="";if(n=u(n),t=+t,1>t||!n||!mu(t))return r;do t%2&&(r+=n),t=yu(t/2),n+=n;while(t);return r}function We(n,t,r){var e=n;return(n=u(n))?(r?Ur(e,t,r):null==t)?n.slice(g(n),y(n)+1):(t+="",n.slice(o(n,t),i(n,t)+1)):n}function $e(n,t,r){return r&&Ur(n,t,r)&&(t=w),n=u(n),n.match(t||Wn)||[]}function Se(n,t,r){return r&&Ur(n,t,r)&&(t=w),h(n)?Ne(n):ut(n,t)}function Fe(n){\nreturn n}function Ne(n){return bt(ot(n,true))}function Te(n,t,r){if(null==r){var e=ge(t),u=e?zo(t):w;((u=u&&u.length?gt(t,u):w)?u.length:e)||(u=false,r=t,t=n,n=this)}u||(u=gt(t,zo(t)));var o=true,e=-1,i=ve(n),f=u.length;false===r?o=false:ge(r)&&"chain"in r&&(o=r.chain);for(;++e<f;){r=u[e];var a=t[r];n[r]=a,i&&(n.prototype[r]=function(t){return function(){var r=this.__chain__;if(o||r){var e=n(this.__wrapped__);return(e.__actions__=qn(this.__actions__)).push({func:t,args:arguments,thisArg:n}),e.__chain__=r,e}return t.apply(n,Jn([this.value()],arguments));\n}}(a))}return n}function Le(){}function ze(n){return Wr(n)?jt(n):kt(n)}_=_?Vn.defaults(Kn.Object(),_,Vn.pick(Kn,$n)):Kn;var Be=_.Array,De=_.Date,Me=_.Error,qe=_.Function,Pe=_.Math,Ke=_.Number,Ve=_.Object,Ze=_.RegExp,Ye=_.String,Ge=_.TypeError,Je=Be.prototype,Xe=Ve.prototype,He=Ye.prototype,Qe=qe.prototype.toString,nu=Xe.hasOwnProperty,tu=0,ru=Xe.toString,eu=Kn._,uu=Ze("^"+Qe.call(nu).replace(/[\\\\^$.*+?()[\\]{}|]/g,"\\\\$&").replace(/hasOwnProperty|(function).*?(?=\\\\\\()| for .+?(?=\\\\\\])/g,"$1.*?")+"$"),ou=_.ArrayBuffer,iu=_.clearTimeout,fu=_.parseFloat,au=Pe.pow,cu=Xe.propertyIsEnumerable,lu=jr(_,"Set"),su=_.setTimeout,pu=Je.splice,hu=_.Uint8Array,_u=jr(_,"WeakMap"),vu=Pe.ceil,gu=jr(Ve,"create"),yu=Pe.floor,du=jr(Be,"isArray"),mu=_.isFinite,wu=jr(Ve,"keys"),bu=Pe.max,xu=Pe.min,Au=jr(De,"now"),ju=_.parseInt,ku=Pe.random,Iu=Ke.NEGATIVE_INFINITY,Ru=Ke.POSITIVE_INFINITY,Ou=4294967294,Eu=2147483647,Cu=9007199254740991,Uu=_u&&new _u,Wu={};\nNn.support={},Nn.templateSettings={escape:_n,evaluate:vn,interpolate:gn,variable:"",imports:{_:Nn}};var $u=function(){function n(){}return function(t){if(ge(t)){n.prototype=t;var r=new n;n.prototype=w}return r||{}}}(),Su=Vt(_t),Fu=Vt(vt,true),Nu=Zt(),Tu=Zt(true),Lu=Uu?function(n,t){return Uu.set(n,t),n}:Fe,zu=Uu?function(n){return Uu.get(n)}:Le,Bu=jt("length"),Du=function(){var n=0,t=0;return function(r,e){var u=ho(),o=S-(u-t);if(t=u,0<o){if(++n>=$)return r}else n=0;return Lu(r,e)}}(),Mu=le(function(n,t){\nreturn h(n)&&Er(n)?ft(n,pt(t,false,true)):[]}),qu=tr(),Pu=tr(true),Ku=le(function(n){for(var t=n.length,e=t,u=Be(l),o=xr(),i=o==r,f=[];e--;){var a=n[e]=Er(a=n[e])?a:[];u[e]=i&&120<=a.length&&gu&&lu?new Dn(e&&a):null}var i=n[0],c=-1,l=i?i.length:0,s=u[0];n:for(;++c<l;)if(a=i[c],0>(s?Mn(s,a):o(f,a,0))){for(e=t;--e;){var p=u[e];if(0>(p?Mn(p,a):o(n[e],a,0)))continue n}s&&s.push(a),f.push(a)}return f}),Vu=le(function(t,r){r=pt(r);var e=rt(t,r);return It(t,r.sort(n)),e}),Zu=vr(),Yu=vr(true),Gu=le(function(n){return St(pt(n,false,true));\n}),Ju=le(function(n,t){return Er(n)?ft(n,t):[]}),Xu=le(Jr),Hu=le(function(n){var t=n.length,r=2<t?n[t-2]:w,e=1<t?n[t-1]:w;return 2<t&&typeof r=="function"?t-=2:(r=1<t&&typeof e=="function"?(--t,e):w,e=w),n.length=t,Xr(n,r,e)}),Qu=le(function(n){return n=pt(n),this.thru(function(t){t=Oo(t)?t:[Br(t)];for(var r=n,e=-1,u=t.length,o=-1,i=r.length,f=Be(u+i);++e<u;)f[e]=t[e];for(;++o<i;)f[e++]=r[o];return f})}),no=le(function(n,t){return rt(n,pt(t))}),to=Pt(function(n,t,r){nu.call(n,r)?++n[r]:n[r]=1}),ro=nr(Su),eo=nr(Fu,true),uo=ur(Pn,Su),oo=ur(function(n,t){\nfor(var r=n.length;r--&&false!==t(n[r],r,n););return n},Fu),io=Pt(function(n,t,r){nu.call(n,r)?n[r].push(t):n[r]=[t]}),fo=Pt(function(n,t,r){n[r]=t}),ao=le(function(n,t,r){var e=-1,u=typeof t=="function",o=Wr(t),i=Er(n)?Be(n.length):[];return Su(n,function(n){var f=u?t:o&&null!=n?n[t]:w;i[++e]=f?f.apply(n,r):Or(n,t,r)}),i}),co=Pt(function(n,t,r){n[r?0:1].push(t)},function(){return[[],[]]}),lo=lr(Xn,Su),so=lr(function(n,t,r,e){var u=n.length;for(e&&u&&(r=n[--u]);u--;)r=t(r,n[u],u,n);return r},Fu),po=le(function(n,t){\nif(null==n)return[];var r=t[2];return r&&Ur(t[0],t[1],r)&&(t.length=1),Wt(n,pt(t),[])}),ho=Au||function(){return(new De).getTime()},_o=le(function(n,t,r){var e=x;if(r.length)var u=v(r,_o.placeholder),e=e|R;return gr(n,e,t,r,u)}),vo=le(function(n,t){t=t.length?pt(t):Ie(n);for(var r=-1,e=t.length;++r<e;){var u=t[r];n[u]=gr(n[u],x,n)}return n}),go=le(function(n,t,r){var e=x|A;if(r.length)var u=v(r,go.placeholder),e=e|R;return gr(t,e,n,r,u)}),yo=Xt(k),mo=Xt(I),wo=le(function(n,t){return it(n,1,t)}),bo=le(function(n,t,r){\nreturn it(n,t,r)}),xo=er(),Ao=er(true),jo=le(function(n,t){if(t=pt(t),typeof n!="function"||!Zn(t,e))throw new Ge(L);var r=t.length;return le(function(e){for(var u=xu(e.length,r);u--;)e[u]=t[u](e[u]);return n.apply(this,e)})}),ko=cr(R),Io=cr(O),Ro=le(function(n,t){return gr(n,C,w,w,w,pt(t))}),Oo=du||function(n){return h(n)&&Sr(n.length)&&ru.call(n)==D},Eo=Kt(At),Co=Kt(function(n,t,r){return r?nt(n,t,r):tt(n,t)}),Uo=Ht(Co,function(n,t){return n===w?t:n}),Wo=Ht(Eo,Fr),$o=rr(_t),So=rr(vt),Fo=or(Nu),No=or(Tu),To=ir(_t),Lo=ir(vt),zo=wu?function(n){\nvar t=null==n?w:n.constructor;return typeof t=="function"&&t.prototype===n||typeof n!="function"&&Er(n)?Lr(n):ge(n)?wu(n):[]}:Lr,Bo=fr(true),Do=fr(),Mo=le(function(n,t){if(null==n)return{};if("function"!=typeof t[0])return t=Gn(pt(t),Ye),Nr(n,ft(Re(n),t));var r=Bt(t[0],t[1],3);return Tr(n,function(n,t,e){return!r(n,t,e)})}),qo=le(function(n,t){return null==n?{}:"function"==typeof t[0]?Tr(n,Bt(t[0],t[1],3)):Nr(n,pt(t))}),Po=Gt(function(n,t,r){return t=t.toLowerCase(),n+(r?t.charAt(0).toUpperCase()+t.slice(1):t);\n}),Ko=Gt(function(n,t,r){return n+(r?"-":"")+t.toLowerCase()}),Vo=ar(),Zo=ar(true),Yo=Gt(function(n,t,r){return n+(r?"_":"")+t.toLowerCase()}),Go=Gt(function(n,t,r){return n+(r?" ":"")+(t.charAt(0).toUpperCase()+t.slice(1))}),Jo=le(function(n,t){try{return n.apply(w,t)}catch(r){return _e(r)?r:new Me(r)}}),Xo=le(function(n,t){return function(r){return Or(r,n,t)}}),Ho=le(function(n,t){return function(r){return Or(n,r,t)}}),Qo=_r("ceil"),ni=_r("floor"),ti=Qt(se,Iu),ri=Qt(Ae,Ru),ei=_r("round");return Nn.prototype=Tn.prototype,\nLn.prototype=$u(Tn.prototype),Ln.prototype.constructor=Ln,zn.prototype=$u(Tn.prototype),zn.prototype.constructor=zn,Bn.prototype["delete"]=function(n){return this.has(n)&&delete this.__data__[n]},Bn.prototype.get=function(n){return"__proto__"==n?w:this.__data__[n]},Bn.prototype.has=function(n){return"__proto__"!=n&&nu.call(this.__data__,n)},Bn.prototype.set=function(n,t){return"__proto__"!=n&&(this.__data__[n]=t),this},Dn.prototype.push=function(n){var t=this.data;typeof n=="string"||ge(n)?t.set.add(n):t.hash[n]=true;\n},ce.Cache=Bn,Nn.after=function(n,t){if(typeof t!="function"){if(typeof n!="function")throw new Ge(L);var r=n;n=t,t=r}return n=mu(n=+n)?n:0,function(){return 1>--n?t.apply(this,arguments):void 0}},Nn.ary=function(n,t,r){return r&&Ur(n,t,r)&&(t=w),t=n&&null==t?n.length:bu(+t||0,0),gr(n,E,w,w,w,w,t)},Nn.assign=Co,Nn.at=no,Nn.before=fe,Nn.bind=_o,Nn.bindAll=vo,Nn.bindKey=go,Nn.callback=Se,Nn.chain=Qr,Nn.chunk=function(n,t,r){t=(r?Ur(n,t,r):null==t)?1:bu(yu(t)||1,1),r=0;for(var e=n?n.length:0,u=-1,o=Be(vu(e/t));r<e;)o[++u]=Et(n,r,r+=t);\nreturn o},Nn.compact=function(n){for(var t=-1,r=n?n.length:0,e=-1,u=[];++t<r;){var o=n[t];o&&(u[++e]=o)}return u},Nn.constant=function(n){return function(){return n}},Nn.countBy=to,Nn.create=function(n,t,r){var e=$u(n);return r&&Ur(n,t,r)&&(t=w),t?tt(e,t):e},Nn.curry=yo,Nn.curryRight=mo,Nn.debounce=ae,Nn.defaults=Uo,Nn.defaultsDeep=Wo,Nn.defer=wo,Nn.delay=bo,Nn.difference=Mu,Nn.drop=qr,Nn.dropRight=Pr,Nn.dropRightWhile=function(n,t,r){return n&&n.length?Nt(n,wr(t,r,3),true,true):[]},Nn.dropWhile=function(n,t,r){\nreturn n&&n.length?Nt(n,wr(t,r,3),true):[]},Nn.fill=function(n,t,r,e){var u=n?n.length:0;if(!u)return[];for(r&&typeof r!="number"&&Ur(n,t,r)&&(r=0,e=u),u=n.length,r=null==r?0:+r||0,0>r&&(r=-r>u?0:u+r),e=e===w||e>u?u:+e||0,0>e&&(e+=u),u=r>e?0:e>>>0,r>>>=0;r<u;)n[r++]=t;return n},Nn.filter=re,Nn.flatten=function(n,t,r){var e=n?n.length:0;return r&&Ur(n,t,r)&&(t=false),e?pt(n,t):[]},Nn.flattenDeep=function(n){return n&&n.length?pt(n,true):[]},Nn.flow=xo,Nn.flowRight=Ao,Nn.forEach=uo,Nn.forEachRight=oo,Nn.forIn=Fo,\nNn.forInRight=No,Nn.forOwn=To,Nn.forOwnRight=Lo,Nn.functions=Ie,Nn.groupBy=io,Nn.indexBy=fo,Nn.initial=function(n){return Pr(n,1)},Nn.intersection=Ku,Nn.invert=function(n,t,r){r&&Ur(n,t,r)&&(t=w),r=-1;for(var e=zo(n),u=e.length,o={};++r<u;){var i=e[r],f=n[i];t?nu.call(o,f)?o[f].push(i):o[f]=[i]:o[f]=i}return o},Nn.invoke=ao,Nn.keys=zo,Nn.keysIn=Re,Nn.map=ue,Nn.mapKeys=Bo,Nn.mapValues=Do,Nn.matches=Ne,Nn.matchesProperty=function(n,t){return xt(n,ot(t,true))},Nn.memoize=ce,Nn.merge=Eo,Nn.method=Xo,Nn.methodOf=Ho,\nNn.mixin=Te,Nn.modArgs=jo,Nn.negate=function(n){if(typeof n!="function")throw new Ge(L);return function(){return!n.apply(this,arguments)}},Nn.omit=Mo,Nn.once=function(n){return fe(2,n)},Nn.pairs=Oe,Nn.partial=ko,Nn.partialRight=Io,Nn.partition=co,Nn.pick=qo,Nn.pluck=function(n,t){return ue(n,ze(t))},Nn.property=ze,Nn.propertyOf=function(n){return function(t){return yt(n,Dr(t),t+"")}},Nn.pull=function(){var n=arguments,t=n[0];if(!t||!t.length)return t;for(var r=0,e=xr(),u=n.length;++r<u;)for(var o=0,i=n[r];-1<(o=e(t,i,o));)pu.call(t,o,1);\nreturn t},Nn.pullAt=Vu,Nn.range=function(n,t,r){r&&Ur(n,t,r)&&(t=r=w),n=+n||0,r=null==r?1:+r||0,null==t?(t=n,n=0):t=+t||0;var e=-1;t=bu(vu((t-n)/(r||1)),0);for(var u=Be(t);++e<t;)u[e]=n,n+=r;return u},Nn.rearg=Ro,Nn.reject=function(n,t,r){var e=Oo(n)?Yn:lt;return t=wr(t,r,3),e(n,function(n,r,e){return!t(n,r,e)})},Nn.remove=function(n,t,r){var e=[];if(!n||!n.length)return e;var u=-1,o=[],i=n.length;for(t=wr(t,r,3);++u<i;)r=n[u],t(r,u,n)&&(e.push(r),o.push(u));return It(n,o),e},Nn.rest=Yr,Nn.restParam=le,\nNn.set=function(n,t,r){if(null==n)return n;var e=t+"";t=null!=n[e]||Wr(t,n)?[e]:Dr(t);for(var e=-1,u=t.length,o=u-1,i=n;null!=i&&++e<u;){var f=t[e];ge(i)&&(e==o?i[f]=r:null==i[f]&&(i[f]=Cr(t[e+1])?[]:{})),i=i[f]}return n},Nn.shuffle=function(n){return oe(n,Ru)},Nn.slice=function(n,t,r){var e=n?n.length:0;return e?(r&&typeof r!="number"&&Ur(n,t,r)&&(t=0,r=e),Et(n,t,r)):[]},Nn.sortBy=function(n,t,r){if(null==n)return[];r&&Ur(n,t,r)&&(t=w);var e=-1;return t=wr(t,r,3),n=wt(n,function(n,r,u){return{a:t(n,r,u),\nb:++e,c:n}}),Ut(n,f)},Nn.sortByAll=po,Nn.sortByOrder=function(n,t,r,e){return null==n?[]:(e&&Ur(t,r,e)&&(r=w),Oo(t)||(t=null==t?[]:[t]),Oo(r)||(r=null==r?[]:[r]),Wt(n,t,r))},Nn.spread=function(n){if(typeof n!="function")throw new Ge(L);return function(t){return n.apply(this,t)}},Nn.take=function(n,t,r){return n&&n.length?((r?Ur(n,t,r):null==t)&&(t=1),Et(n,0,0>t?0:t)):[]},Nn.takeRight=function(n,t,r){var e=n?n.length:0;return e?((r?Ur(n,t,r):null==t)&&(t=1),t=e-(+t||0),Et(n,0>t?0:t)):[]},Nn.takeRightWhile=function(n,t,r){\nreturn n&&n.length?Nt(n,wr(t,r,3),false,true):[]},Nn.takeWhile=function(n,t,r){return n&&n.length?Nt(n,wr(t,r,3)):[]},Nn.tap=function(n,t,r){return t.call(r,n),n},Nn.throttle=function(n,t,r){var e=true,u=true;if(typeof n!="function")throw new Ge(L);return false===r?e=false:ge(r)&&(e="leading"in r?!!r.leading:e,u="trailing"in r?!!r.trailing:u),ae(n,t,{leading:e,maxWait:+t,trailing:u})},Nn.thru=ne,Nn.times=function(n,t,r){if(n=yu(n),1>n||!mu(n))return[];var e=-1,u=Be(xu(n,4294967295));for(t=Bt(t,r,1);++e<n;)4294967295>e?u[e]=t(e):t(e);\nreturn u},Nn.toArray=je,Nn.toPlainObject=ke,Nn.transform=function(n,t,r,e){var u=Oo(n)||xe(n);return t=wr(t,e,4),null==r&&(u||ge(n)?(e=n.constructor,r=u?Oo(n)?new e:[]:$u(ve(e)?e.prototype:w)):r={}),(u?Pn:_t)(n,function(n,e,u){return t(r,n,e,u)}),r},Nn.union=Gu,Nn.uniq=Gr,Nn.unzip=Jr,Nn.unzipWith=Xr,Nn.values=Ee,Nn.valuesIn=function(n){return Ft(n,Re(n))},Nn.where=function(n,t){return re(n,bt(t))},Nn.without=Ju,Nn.wrap=function(n,t){return t=null==t?Fe:t,gr(t,R,w,[n],[])},Nn.xor=function(){for(var n=-1,t=arguments.length;++n<t;){\nvar r=arguments[n];if(Er(r))var e=e?Jn(ft(e,r),ft(r,e)):r}return e?St(e):[]},Nn.zip=Xu,Nn.zipObject=Hr,Nn.zipWith=Hu,Nn.backflow=Ao,Nn.collect=ue,Nn.compose=Ao,Nn.each=uo,Nn.eachRight=oo,Nn.extend=Co,Nn.iteratee=Se,Nn.methods=Ie,Nn.object=Hr,Nn.select=re,Nn.tail=Yr,Nn.unique=Gr,Te(Nn,Nn),Nn.add=function(n,t){return(+n||0)+(+t||0)},Nn.attempt=Jo,Nn.camelCase=Po,Nn.capitalize=function(n){return(n=u(n))&&n.charAt(0).toUpperCase()+n.slice(1)},Nn.ceil=Qo,Nn.clone=function(n,t,r,e){return t&&typeof t!="boolean"&&Ur(n,t,r)?t=false:typeof t=="function"&&(e=r,\nr=t,t=false),typeof r=="function"?ot(n,t,Bt(r,e,1)):ot(n,t)},Nn.cloneDeep=function(n,t,r){return typeof t=="function"?ot(n,true,Bt(t,r,1)):ot(n,true)},Nn.deburr=Ce,Nn.endsWith=function(n,t,r){n=u(n),t+="";var e=n.length;return r=r===w?e:xu(0>r?0:+r||0,e),r-=t.length,0<=r&&n.indexOf(t,r)==r},Nn.escape=function(n){return(n=u(n))&&hn.test(n)?n.replace(sn,c):n},Nn.escapeRegExp=function(n){return(n=u(n))&&bn.test(n)?n.replace(wn,l):n||"(?:)"},Nn.every=te,Nn.find=ro,Nn.findIndex=qu,Nn.findKey=$o,Nn.findLast=eo,\nNn.findLastIndex=Pu,Nn.findLastKey=So,Nn.findWhere=function(n,t){return ro(n,bt(t))},Nn.first=Kr,Nn.floor=ni,Nn.get=function(n,t,r){return n=null==n?w:yt(n,Dr(t),t+""),n===w?r:n},Nn.gt=se,Nn.gte=function(n,t){return n>=t},Nn.has=function(n,t){if(null==n)return false;var r=nu.call(n,t);if(!r&&!Wr(t)){if(t=Dr(t),n=1==t.length?n:yt(n,Et(t,0,-1)),null==n)return false;t=Zr(t),r=nu.call(n,t)}return r||Sr(n.length)&&Cr(t,n.length)&&(Oo(n)||pe(n))},Nn.identity=Fe,Nn.includes=ee,Nn.indexOf=Vr,Nn.inRange=function(n,t,r){\nreturn t=+t||0,r===w?(r=t,t=0):r=+r||0,n>=xu(t,r)&&n<bu(t,r)},Nn.isArguments=pe,Nn.isArray=Oo,Nn.isBoolean=function(n){return true===n||false===n||h(n)&&ru.call(n)==M},Nn.isDate=function(n){return h(n)&&ru.call(n)==q},Nn.isElement=function(n){return!!n&&1===n.nodeType&&h(n)&&!me(n)},Nn.isEmpty=function(n){return null==n?true:Er(n)&&(Oo(n)||be(n)||pe(n)||h(n)&&ve(n.splice))?!n.length:!zo(n).length},Nn.isEqual=he,Nn.isError=_e,Nn.isFinite=function(n){return typeof n=="number"&&mu(n)},Nn.isFunction=ve,Nn.isMatch=function(n,t,r,e){\nreturn r=typeof r=="function"?Bt(r,e,3):w,mt(n,Ar(t),r)},Nn.isNaN=function(n){return de(n)&&n!=+n},Nn.isNative=ye,Nn.isNull=function(n){return null===n},Nn.isNumber=de,Nn.isObject=ge,Nn.isPlainObject=me,Nn.isRegExp=we,Nn.isString=be,Nn.isTypedArray=xe,Nn.isUndefined=function(n){return n===w},Nn.kebabCase=Ko,Nn.last=Zr,Nn.lastIndexOf=function(n,t,r){var e=n?n.length:0;if(!e)return-1;var u=e;if(typeof r=="number")u=(0>r?bu(e+r,0):xu(r||0,e-1))+1;else if(r)return u=Lt(n,t,true)-1,n=n[u],(t===t?t===n:n!==n)?u:-1;\nif(t!==t)return p(n,u,true);for(;u--;)if(n[u]===t)return u;return-1},Nn.lt=Ae,Nn.lte=function(n,t){return n<=t},Nn.max=ti,Nn.min=ri,Nn.noConflict=function(){return Kn._=eu,this},Nn.noop=Le,Nn.now=ho,Nn.pad=function(n,t,r){n=u(n),t=+t;var e=n.length;return e<t&&mu(t)?(e=(t-e)/2,t=yu(e),e=vu(e),r=pr("",e,r),r.slice(0,t)+n+r):n},Nn.padLeft=Vo,Nn.padRight=Zo,Nn.parseInt=function(n,t,r){return(r?Ur(n,t,r):null==t)?t=0:t&&(t=+t),n=We(n),ju(n,t||(In.test(n)?16:10))},Nn.random=function(n,t,r){r&&Ur(n,t,r)&&(t=r=w);\nvar e=null==n,u=null==t;return null==r&&(u&&typeof n=="boolean"?(r=n,n=1):typeof t=="boolean"&&(r=t,u=true)),e&&u&&(t=1,u=false),n=+n||0,u?(t=n,n=0):t=+t||0,r||n%1||t%1?(r=ku(),xu(n+r*(t-n+fu("1e-"+((r+"").length-1))),t)):Rt(n,t)},Nn.reduce=lo,Nn.reduceRight=so,Nn.repeat=Ue,Nn.result=function(n,t,r){var e=null==n?w:n[t];return e===w&&(null==n||Wr(t,n)||(t=Dr(t),n=1==t.length?n:yt(n,Et(t,0,-1)),e=null==n?w:n[Zr(t)]),e=e===w?r:e),ve(e)?e.call(n):e},Nn.round=ei,Nn.runInContext=m,Nn.size=function(n){var t=n?Bu(n):0;\nreturn Sr(t)?t:zo(n).length},Nn.snakeCase=Yo,Nn.some=ie,Nn.sortedIndex=Zu,Nn.sortedLastIndex=Yu,Nn.startCase=Go,Nn.startsWith=function(n,t,r){return n=u(n),r=null==r?0:xu(0>r?0:+r||0,n.length),n.lastIndexOf(t,r)==r},Nn.sum=function(n,t,r){if(r&&Ur(n,t,r)&&(t=w),t=wr(t,r,3),1==t.length){n=Oo(n)?n:zr(n),r=n.length;for(var e=0;r--;)e+=+t(n[r])||0;n=e}else n=$t(n,t);return n},Nn.template=function(n,t,r){var e=Nn.templateSettings;r&&Ur(n,t,r)&&(t=r=w),n=u(n),t=nt(tt({},r||t),e,Qn),r=nt(tt({},t.imports),e.imports,Qn);\nvar o,i,f=zo(r),a=Ft(r,f),c=0;r=t.interpolate||Cn;var l="__p+=\'";r=Ze((t.escape||Cn).source+"|"+r.source+"|"+(r===gn?jn:Cn).source+"|"+(t.evaluate||Cn).source+"|$","g");var p="sourceURL"in t?"//# sourceURL="+t.sourceURL+"\\n":"";if(n.replace(r,function(t,r,e,u,f,a){return e||(e=u),l+=n.slice(c,a).replace(Un,s),r&&(o=true,l+="\'+__e("+r+")+\'"),f&&(i=true,l+="\';"+f+";\\n__p+=\'"),e&&(l+="\'+((__t=("+e+"))==null?\'\':__t)+\'"),c=a+t.length,t}),l+="\';",(t=t.variable)||(l="with(obj){"+l+"}"),l=(i?l.replace(fn,""):l).replace(an,"$1").replace(cn,"$1;"),\nl="function("+(t||"obj")+"){"+(t?"":"obj||(obj={});")+"var __t,__p=\'\'"+(o?",__e=_.escape":"")+(i?",__j=Array.prototype.join;function print(){__p+=__j.call(arguments,\'\')}":";")+l+"return __p}",t=Jo(function(){return qe(f,p+"return "+l).apply(w,a)}),t.source=l,_e(t))throw t;return t},Nn.trim=We,Nn.trimLeft=function(n,t,r){var e=n;return(n=u(n))?n.slice((r?Ur(e,t,r):null==t)?g(n):o(n,t+"")):n},Nn.trimRight=function(n,t,r){var e=n;return(n=u(n))?(r?Ur(e,t,r):null==t)?n.slice(0,y(n)+1):n.slice(0,i(n,t+"")+1):n;\n},Nn.trunc=function(n,t,r){r&&Ur(n,t,r)&&(t=w);var e=U;if(r=W,null!=t)if(ge(t)){var o="separator"in t?t.separator:o,e="length"in t?+t.length||0:e;r="omission"in t?u(t.omission):r}else e=+t||0;if(n=u(n),e>=n.length)return n;if(e-=r.length,1>e)return r;if(t=n.slice(0,e),null==o)return t+r;if(we(o)){if(n.slice(e).search(o)){var i,f=n.slice(0,e);for(o.global||(o=Ze(o.source,(kn.exec(o)||"")+"g")),o.lastIndex=0;n=o.exec(f);)i=n.index;t=t.slice(0,null==i?e:i)}}else n.indexOf(o,e)!=e&&(o=t.lastIndexOf(o),\n-1<o&&(t=t.slice(0,o)));return t+r},Nn.unescape=function(n){return(n=u(n))&&pn.test(n)?n.replace(ln,d):n},Nn.uniqueId=function(n){var t=++tu;return u(n)+t},Nn.words=$e,Nn.all=te,Nn.any=ie,Nn.contains=ee,Nn.eq=he,Nn.detect=ro,Nn.foldl=lo,Nn.foldr=so,Nn.head=Kr,Nn.include=ee,Nn.inject=lo,Te(Nn,function(){var n={};return _t(Nn,function(t,r){Nn.prototype[r]||(n[r]=t)}),n}(),false),Nn.sample=oe,Nn.prototype.sample=function(n){return this.__chain__||null!=n?this.thru(function(t){return oe(t,n)}):oe(this.value());\n},Nn.VERSION=b,Pn("bind bindKey curry curryRight partial partialRight".split(" "),function(n){Nn[n].placeholder=Nn}),Pn(["drop","take"],function(n,t){zn.prototype[n]=function(r){var e=this.__filtered__;if(e&&!t)return new zn(this);r=null==r?1:bu(yu(r)||0,0);var u=this.clone();return e?u.__takeCount__=xu(u.__takeCount__,r):u.__views__.push({size:r,type:n+(0>u.__dir__?"Right":"")}),u},zn.prototype[n+"Right"]=function(t){return this.reverse()[n](t).reverse()}}),Pn(["filter","map","takeWhile"],function(n,t){\nvar r=t+1,e=r!=T;zn.prototype[n]=function(n,t){var u=this.clone();return u.__iteratees__.push({iteratee:wr(n,t,1),type:r}),u.__filtered__=u.__filtered__||e,u}}),Pn(["first","last"],function(n,t){var r="take"+(t?"Right":"");zn.prototype[n]=function(){return this[r](1).value()[0]}}),Pn(["initial","rest"],function(n,t){var r="drop"+(t?"":"Right");zn.prototype[n]=function(){return this.__filtered__?new zn(this):this[r](1)}}),Pn(["pluck","where"],function(n,t){var r=t?"filter":"map",e=t?bt:ze;zn.prototype[n]=function(n){\nreturn this[r](e(n))}}),zn.prototype.compact=function(){return this.filter(Fe)},zn.prototype.reject=function(n,t){return n=wr(n,t,1),this.filter(function(t){return!n(t)})},zn.prototype.slice=function(n,t){n=null==n?0:+n||0;var r=this;return r.__filtered__&&(0<n||0>t)?new zn(r):(0>n?r=r.takeRight(-n):n&&(r=r.drop(n)),t!==w&&(t=+t||0,r=0>t?r.dropRight(-t):r.take(t-n)),r)},zn.prototype.takeRightWhile=function(n,t){return this.reverse().takeWhile(n,t).reverse()},zn.prototype.toArray=function(){return this.take(Ru);\n},_t(zn.prototype,function(n,t){var r=/^(?:filter|map|reject)|While$/.test(t),e=/^(?:first|last)$/.test(t),u=Nn[e?"take"+("last"==t?"Right":""):t];u&&(Nn.prototype[t]=function(){function t(n){return e&&i?u(n,1)[0]:u.apply(w,Jn([n],o))}var o=e?[1]:arguments,i=this.__chain__,f=this.__wrapped__,a=!!this.__actions__.length,c=f instanceof zn,l=o[0],s=c||Oo(f);return s&&r&&typeof l=="function"&&1!=l.length&&(c=s=false),l={func:ne,args:[t],thisArg:w},a=c&&!a,e&&!i?a?(f=f.clone(),f.__actions__.push(l),n.call(f)):u.call(w,this.value())[0]:!e&&s?(f=a?f:new zn(this),\nf=n.apply(f,o),f.__actions__.push(l),new Ln(f,i)):this.thru(t)})}),Pn("join pop push replace shift sort splice split unshift".split(" "),function(n){var t=(/^(?:replace|split)$/.test(n)?He:Je)[n],r=/^(?:push|sort|unshift)$/.test(n)?"tap":"thru",e=/^(?:join|pop|replace|shift)$/.test(n);Nn.prototype[n]=function(){var n=arguments;return e&&!this.__chain__?t.apply(this.value(),n):this[r](function(r){return t.apply(r,n)})}}),_t(zn.prototype,function(n,t){var r=Nn[t];if(r){var e=r.name;(Wu[e]||(Wu[e]=[])).push({\nname:t,func:r})}}),Wu[sr(w,A).name]=[{name:"wrapper",func:w}],zn.prototype.clone=function(){var n=new zn(this.__wrapped__);return n.__actions__=qn(this.__actions__),n.__dir__=this.__dir__,n.__filtered__=this.__filtered__,n.__iteratees__=qn(this.__iteratees__),n.__takeCount__=this.__takeCount__,n.__views__=qn(this.__views__),n},zn.prototype.reverse=function(){if(this.__filtered__){var n=new zn(this);n.__dir__=-1,n.__filtered__=true}else n=this.clone(),n.__dir__*=-1;return n},zn.prototype.value=function(){\nvar n,t=this.__wrapped__.value(),r=this.__dir__,e=Oo(t),u=0>r,o=e?t.length:0;n=o;for(var i=this.__views__,f=0,a=-1,c=i.length;++a<c;){var l=i[a],s=l.size;switch(l.type){case"drop":f+=s;break;case"dropRight":n-=s;break;case"take":n=xu(n,f+s);break;case"takeRight":f=bu(f,n-s)}}if(n={start:f,end:n},i=n.start,f=n.end,n=f-i,i=u?f:i-1,f=this.__iteratees__,a=f.length,c=0,l=xu(n,this.__takeCount__),!e||o<F||o==n&&l==n)return Tt(u&&e?t.reverse():t,this.__actions__);e=[];n:for(;n--&&c<l;){for(i+=r,u=-1,o=t[i];++u<a;){\nvar p=f[u],s=p.type,p=p.iteratee(o);if(s==T)o=p;else if(!p){if(s==N)continue n;break n}}e[c++]=o}return e},Nn.prototype.chain=function(){return Qr(this)},Nn.prototype.commit=function(){return new Ln(this.value(),this.__chain__)},Nn.prototype.concat=Qu,Nn.prototype.plant=function(n){for(var t,r=this;r instanceof Tn;){var e=Mr(r);t?u.__wrapped__=e:t=e;var u=e,r=r.__wrapped__}return u.__wrapped__=n,t},Nn.prototype.reverse=function(){function n(n){return r&&0>r.__dir__?n:n.reverse()}var t=this.__wrapped__;\nif(t instanceof zn){var r=t;return this.__actions__.length&&(r=new zn(this)),r=r.reverse(),r.__actions__.push({func:ne,args:[n],thisArg:w}),new Ln(r,this.__chain__)}return this.thru(n)},Nn.prototype.toString=function(){return this.value()+""},Nn.prototype.run=Nn.prototype.toJSON=Nn.prototype.valueOf=Nn.prototype.value=function(){return Tt(this.__wrapped__,this.__actions__)},Nn.prototype.collect=Nn.prototype.map,Nn.prototype.head=Nn.prototype.first,Nn.prototype.select=Nn.prototype.filter,Nn.prototype.tail=Nn.prototype.rest,\nNn}var w,b="3.10.0",x=1,A=2,j=4,k=8,I=16,R=32,O=64,E=128,C=256,U=30,W="...",$=150,S=16,F=200,N=1,T=2,L="Expected a function",z="__lodash_placeholder__",B="[object Arguments]",D="[object Array]",M="[object Boolean]",q="[object Date]",P="[object Error]",K="[object Function]",V="[object Number]",Z="[object Object]",Y="[object RegExp]",G="[object String]",J="[object ArrayBuffer]",X="[object Float32Array]",H="[object Float64Array]",Q="[object Int8Array]",nn="[object Int16Array]",tn="[object Int32Array]",rn="[object Uint8Array]",en="[object Uint8ClampedArray]",un="[object Uint16Array]",on="[object Uint32Array]",fn=/\\b__p\\+=\'\';/g,an=/\\b(__p\\+=)\'\'\\+/g,cn=/(__e\\(.*?\\)|\\b__t\\))\\+\'\';/g,ln=/&(?:amp|lt|gt|quot|#39|#96);/g,sn=/[&<>"\'`]/g,pn=RegExp(ln.source),hn=RegExp(sn.source),_n=/<%-([\\s\\S]+?)%>/g,vn=/<%([\\s\\S]+?)%>/g,gn=/<%=([\\s\\S]+?)%>/g,yn=/\\.|\\[(?:[^[\\]]*|(["\'])(?:(?!\\1)[^\\n\\\\]|\\\\.)*?\\1)\\]/,dn=/^\\w*$/,mn=/[^.[\\]]+|\\[(?:(-?\\d+(?:\\.\\d+)?)|(["\'])((?:(?!\\2)[^\\n\\\\]|\\\\.)*?)\\2)\\]/g,wn=/^[:!,]|[\\\\^$.*+?()[\\]{}|\\/]|(^[0-9a-fA-Fnrtuvx])|([\\n\\r\\u2028\\u2029])/g,bn=RegExp(wn.source),xn=/[\\u0300-\\u036f\\ufe20-\\ufe23]/g,An=/\\\\(\\\\)?/g,jn=/\\$\\{([^\\\\}]*(?:\\\\.[^\\\\}]*)*)\\}/g,kn=/\\w*$/,In=/^0[xX]/,Rn=/^\\[object .+?Constructor\\]$/,On=/^\\d+$/,En=/[\\xc0-\\xd6\\xd8-\\xde\\xdf-\\xf6\\xf8-\\xff]/g,Cn=/($^)/,Un=/[\'\\n\\r\\u2028\\u2029\\\\]/g,Wn=RegExp("[A-Z\\\\xc0-\\\\xd6\\\\xd8-\\\\xde]+(?=[A-Z\\\\xc0-\\\\xd6\\\\xd8-\\\\xde][a-z\\\\xdf-\\\\xf6\\\\xf8-\\\\xff]+)|[A-Z\\\\xc0-\\\\xd6\\\\xd8-\\\\xde]?[a-z\\\\xdf-\\\\xf6\\\\xf8-\\\\xff]+|[A-Z\\\\xc0-\\\\xd6\\\\xd8-\\\\xde]+|[0-9]+","g"),$n="Array ArrayBuffer Date Error Float32Array Float64Array Function Int8Array Int16Array Int32Array Math Number Object RegExp Set String _ clearTimeout isFinite parseFloat parseInt setTimeout TypeError Uint8Array Uint8ClampedArray Uint16Array Uint32Array WeakMap".split(" "),Sn={};\nSn[X]=Sn[H]=Sn[Q]=Sn[nn]=Sn[tn]=Sn[rn]=Sn[en]=Sn[un]=Sn[on]=true,Sn[B]=Sn[D]=Sn[J]=Sn[M]=Sn[q]=Sn[P]=Sn[K]=Sn["[object Map]"]=Sn[V]=Sn[Z]=Sn[Y]=Sn["[object Set]"]=Sn[G]=Sn["[object WeakMap]"]=false;var Fn={};Fn[B]=Fn[D]=Fn[J]=Fn[M]=Fn[q]=Fn[X]=Fn[H]=Fn[Q]=Fn[nn]=Fn[tn]=Fn[V]=Fn[Z]=Fn[Y]=Fn[G]=Fn[rn]=Fn[en]=Fn[un]=Fn[on]=true,Fn[P]=Fn[K]=Fn["[object Map]"]=Fn["[object Set]"]=Fn["[object WeakMap]"]=false;var Nn={"\\xc0":"A","\\xc1":"A","\\xc2":"A","\\xc3":"A","\\xc4":"A","\\xc5":"A","\\xe0":"a","\\xe1":"a","\\xe2":"a",\n"\\xe3":"a","\\xe4":"a","\\xe5":"a","\\xc7":"C","\\xe7":"c","\\xd0":"D","\\xf0":"d","\\xc8":"E","\\xc9":"E","\\xca":"E","\\xcb":"E","\\xe8":"e","\\xe9":"e","\\xea":"e","\\xeb":"e","\\xcc":"I","\\xcd":"I","\\xce":"I","\\xcf":"I","\\xec":"i","\\xed":"i","\\xee":"i","\\xef":"i","\\xd1":"N","\\xf1":"n","\\xd2":"O","\\xd3":"O","\\xd4":"O","\\xd5":"O","\\xd6":"O","\\xd8":"O","\\xf2":"o","\\xf3":"o","\\xf4":"o","\\xf5":"o","\\xf6":"o","\\xf8":"o","\\xd9":"U","\\xda":"U","\\xdb":"U","\\xdc":"U","\\xf9":"u","\\xfa":"u","\\xfb":"u","\\xfc":"u","\\xdd":"Y",\n"\\xfd":"y","\\xff":"y","\\xc6":"Ae","\\xe6":"ae","\\xde":"Th","\\xfe":"th","\\xdf":"ss"},Tn={"&":"&amp;","<":"&lt;",">":"&gt;",\'"\':"&quot;","\'":"&#39;","`":"&#96;"},Ln={"&amp;":"&","&lt;":"<","&gt;":">","&quot;":\'"\',"&#39;":"\'","&#96;":"`"},zn={"function":true,object:true},Bn={0:"x30",1:"x31",2:"x32",3:"x33",4:"x34",5:"x35",6:"x36",7:"x37",8:"x38",9:"x39",A:"x41",B:"x42",C:"x43",D:"x44",E:"x45",F:"x46",a:"x61",b:"x62",c:"x63",d:"x64",e:"x65",f:"x66",n:"x6e",r:"x72",t:"x74",u:"x75",v:"x76",x:"x78"},Dn={"\\\\":"\\\\",\n"\'":"\'","\\n":"n","\\r":"r","\\u2028":"u2028","\\u2029":"u2029"},Mn=zn[typeof module]&&module&&!module.nodeType&&module,qn=zn[typeof self]&&self&&self.Object&&self,Pn=zn[typeof window]&&window&&window.Object&&window,Kn=zn[typeof exports]&&exports&&!exports.nodeType&&exports&&Mn&&typeof global=="object"&&global&&global.Object&&global||Pn!==(this&&this.window)&&Pn||qn||this,Vn=m();typeof define=="function"&&typeof define.amd=="object"&&define.amd&& define(\'thirdparty/lodash\',[],function(){return Vn})}).call(this);\n//# sourceURL=/thirdparty/lodash.js'),
eval("/*\n * Copyright (c) 2014 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the \"Software\"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */\n/*global define, $ */\n\n/**\n * Implements a jQuery-like event dispatch pattern for non-DOM objects:\n *  - Listeners are attached via on()/one() & detached via off()\n *  - Listeners can use namespaces for easy removal\n *  - Listeners can attach to multiple events at once via a space-separated list\n *  - Events are fired via trigger()\n *  - The same listener can be attached twice, and will be called twice; but off() will detach all\n *    duplicate copies at once ('duplicate' means '===' equality - see http://jsfiddle.net/bf4p29g5/1/)\n *\n * But it has some important differences from jQuery's non-DOM event mechanism:\n *  - More robust to listeners that throw exceptions (other listeners will still be called, and\n *    trigger() will still return control to its caller).\n *  - Events can be marked deprecated, causing on() to issue warnings\n *  - Easier to debug, since the dispatch code is much simpler\n *  - Faster, for the same reason\n *  - Uses less memory, since $(nonDOMObj).on() leaks memory in jQuery\n *  - API is simplified:\n *      - Event handlers do not have 'this' set to the event dispatcher object\n *      - Event object passed to handlers only has 'type' and 'target' fields\n *      - trigger() uses a simpler argument-list signature (like Promise APIs), rather than requiring\n *        an Array arg and ignoring additional args\n *      - trigger() does not support namespaces\n *      - For simplicity, on() does not accept a map of multiple events -> multiple handlers, nor a\n *        missing arg standing in for a bare 'return false' handler.\n *\n * For now, Brackets uses a jQuery patch to ensure $(obj).on() and obj.on() (etc.) are identical\n * for any obj that has the EventDispatcher pattern. In the future, this may be deprecated.\n *\n * To add EventDispatcher methods to any object, call EventDispatcher.makeEventDispatcher(obj).\n */\ndefine('utils/EventDispatcher',['require','exports','module','thirdparty/lodash'],function (require, exports, module) {\n    \"use strict\";\n\n    var _ = require(\"thirdparty/lodash\");\n\n    var LEAK_WARNING_THRESHOLD = 15;\n\n\n    /**\n     * Split \"event.namespace\" string into its two parts; both parts are optional.\n     * @param {string} eventName Event name and/or trailing \".namespace\"\n     * @return {!{event:string, ns:string}} Uses \"\" for missing parts.\n     */\n    function splitNs(eventStr) {\n        var dot = eventStr.indexOf(\".\");\n        if (dot === -1) {\n            return { eventName: eventStr };\n        } else {\n            return { eventName: eventStr.substring(0, dot), ns: eventStr.substring(dot) };\n        }\n    }\n\n\n    // These functions are added as mixins to any object by makeEventDispatcher()\n\n    /**\n     * Adds the given handler function to 'events': a space-separated list of one or more event names, each\n     * with an optional \".namespace\" (used by off() - see below). If the handler is already listening to this\n     * event, a duplicate copy is added.\n     * @param {string} events\n     * @param {!function(!{type:string, target:!Object}, ...)} fn\n     */\n    var on = function (events, fn) {\n        var eventsList = events.split(/\\s+/).map(splitNs),\n            i;\n\n        if (!fn) {\n            throw new Error(\"EventListener.on() called with no listener fn for event '\" + events + \"'\");\n        }\n\n        // Check for deprecation warnings\n        if (this._deprecatedEvents) {\n            for (i = 0; i < eventsList.length; i++) {\n                var deprecation = this._deprecatedEvents[eventsList[i].eventName];\n                if (deprecation) {\n                    var message = \"Registering for deprecated event '\" + eventsList[i].eventName + \"'.\";\n                    if (typeof deprecation === \"string\") {\n                        message += \" Instead, use \" + deprecation + \".\";\n                    }\n                    console.warn(message, new Error().stack);\n                }\n            }\n        }\n\n        // Attach listener for each event clause\n        for (i = 0; i < eventsList.length; i++) {\n            var eventName = eventsList[i].eventName;\n            if (!this._eventHandlers) {\n                this._eventHandlers = {};\n            }\n            if (!this._eventHandlers[eventName]) {\n                this._eventHandlers[eventName] = [];\n            }\n            eventsList[i].handler = fn;\n            this._eventHandlers[eventName].push(eventsList[i]);\n\n            // Check for suspicious number of listeners being added to one object-event pair\n            if (this._eventHandlers[eventName].length > LEAK_WARNING_THRESHOLD) {\n                console.error(\"Possible memory leak: \" + this._eventHandlers[eventName].length + \" '\" + eventName + \"' listeners attached to\", this);\n            }\n        }\n\n        return this;  // for chaining\n    };\n\n    /**\n     * Removes one or more handler functions based on the space-separated 'events' list. Each item in\n     * 'events' can be: bare event name, bare .namespace, or event.namespace pair. This yields a set of\n     * matching handlers. If 'fn' is ommitted, all these handlers are removed. If 'fn' is provided,\n     * only handlers exactly equal to 'fn' are removed (there may still be >1, if duplicates were added).\n     * @param {string} events\n     * @param {?function(!{type:string, target:!Object}, ...)} fn\n     */\n    var off = function (events, fn) {\n        if (!this._eventHandlers) {\n            return this;\n        }\n\n        var eventsList = events.split(/\\s+/).map(splitNs),\n            i;\n\n        var removeAllMatches = function (eventRec, eventName) {\n            var handlerList = this._eventHandlers[eventName],\n                k;\n            if (!handlerList) {\n                return;\n            }\n\n            // Walk backwards so it's easy to remove items\n            for (k = handlerList.length - 1; k >= 0; k--) {\n                // Look at ns & fn only - doRemove() has already taken care of eventName\n                if (!eventRec.ns || eventRec.ns === handlerList[k].ns) {\n                    var handler = handlerList[k].handler;\n                    if (!fn || fn === handler || fn._eventOnceWrapper === handler) {\n                        handlerList.splice(k, 1);\n                    }\n                }\n            }\n            if (!handlerList.length) {\n                delete this._eventHandlers[eventName];\n            }\n        }.bind(this);\n\n        var doRemove = function (eventRec) {\n            if (eventRec.eventName) {\n                // If arg calls out an event name, look at that handler list only\n                removeAllMatches(eventRec, eventRec.eventName);\n            } else {\n                // If arg only gives a namespace, look at handler lists for all events\n                _.forEach(this._eventHandlers, function (handlerList, eventName) {\n                    removeAllMatches(eventRec, eventName);\n                });\n            }\n        }.bind(this);\n\n        // Detach listener for each event clause\n        // Each clause may be: bare eventname, bare .namespace, full eventname.namespace\n        for (i = 0; i < eventsList.length; i++) {\n            doRemove(eventsList[i]);\n        }\n\n        return this;  // for chaining\n    };\n\n    /**\n     * Attaches a handler so it's only called once (per event in the 'events' list).\n     * @param {string} events\n     * @param {?function(!{type:string, target:!Object}, ...)} fn\n     */\n    var one = function (events, fn) {\n        // Wrap fn in a self-detaching handler; saved on the original fn so off() can detect it later\n        if (!fn._eventOnceWrapper) {\n            fn._eventOnceWrapper = function (event) {\n                // Note: this wrapper is reused for all attachments of the same fn, so it shouldn't reference\n                // anything from the outer closure other than 'fn'\n                event.target.off(event.type, fn._eventOnceWrapper);\n                fn.apply(this, arguments);\n            };\n        }\n        return this.on(events, fn._eventOnceWrapper);\n    };\n\n    /**\n     * Invokes all handlers for the given event (in the order they were added).\n     * @param {string} eventName\n     * @param {*} ... Any additional args are passed to the event handler after the event object\n     */\n    var trigger = function (eventName) {\n        var event = { type: eventName, target: this },\n            handlerList = this._eventHandlers && this._eventHandlers[eventName],\n            i;\n\n        if (!handlerList) {\n            return;\n        }\n\n        // Use a clone of the list in case handlers call on()/off() while we're still in the loop\n        handlerList = handlerList.slice();\n\n        // Pass 'event' object followed by any additional args trigger() was given\n        var applyArgs = Array.prototype.slice.call(arguments, 1);\n        applyArgs.unshift(event);\n\n        for (i = 0; i < handlerList.length; i++) {\n            try {\n                // Call one handler\n                handlerList[i].handler.apply(null, applyArgs);\n            } catch (err) {\n                console.error(\"Exception in '\" + eventName + \"' listener on\", this, String(err), err.stack);\n                console.assert();  // causes dev tools to pause, just like an uncaught exception\n            }\n        }\n    };\n\n\n    /**\n     * Adds the EventDispatcher APIs to the given object: on(), one(), off(), and trigger(). May also be\n     * called on a prototype object - each instance will still behave independently.\n     * @param {!Object} obj Object to add event-dispatch methods to\n     */\n    function makeEventDispatcher(obj) {\n        $.extend(obj, {\n            on: on,\n            off: off,\n            one: one,\n            trigger: trigger,\n            _EventDispatcher: true\n        });\n        // Later, on() may add _eventHandlers: Object.<string, Array.<{event:string, namespace:?string,\n        //   handler:!function(!{type:string, target:!Object}, ...)}>> - map from eventName to an array\n        //   of handler records\n        // Later, markDeprecated() may add _deprecatedEvents: Object.<string, string|boolean> - map from\n        //   eventName to deprecation warning info\n    }\n\n    /**\n     * Utility for calling on() with an array of arguments to pass to event handlers (rather than a varargs\n     * list). makeEventDispatcher() must have previously been called on 'dispatcher'.\n     * @param {!Object} dispatcher\n     * @param {string} eventName\n     * @param {!Array.<*>} argsArray\n     */\n    function triggerWithArray(dispatcher, eventName, argsArray) {\n        var triggerArgs = [eventName].concat(argsArray);\n        dispatcher.trigger.apply(dispatcher, triggerArgs);\n    }\n\n    /**\n     * Utility for attaching an event handler to an object that has not YET had makeEventDispatcher() called\n     * on it, but will in the future. Once 'futureDispatcher' becomes a real event dispatcher, any handlers\n     * attached here will be retained.\n     *\n     * Useful with core modules that have circular dependencies (one module initially gets an empty copy of the\n     * other, with no on() API present yet). Unlike other strategies like waiting for htmlReady(), this helper\n     * guarantees you won't miss any future events, regardless of how soon the other module finishes init and\n     * starts calling trigger().\n     *\n     * @param {!Object} futureDispatcher\n     * @param {string} events\n     * @param {?function(!{type:string, target:!Object}, ...)} fn\n     */\n    function on_duringInit(futureDispatcher, events, fn) {\n        on.call(futureDispatcher, events, fn);\n    }\n\n    /**\n     * Mark a given event name as deprecated, such that on() will emit warnings when called with it.\n     * May be called before makeEventDispatcher(). May be called on a prototype where makeEventDispatcher()\n     * is called separately per instance (i.e. in the constructor). Should be called before clients have\n     * a chance to start calling on().\n     * @param {!Object} obj Event dispatcher object\n     * @param {string} eventName Name of deprecated event\n     * @param {string=} insteadStr Suggested thing to use instead\n     */\n    function markDeprecated(obj, eventName, insteadStr) {\n        // Mark event as deprecated - on() will emit warnings when called with this event\n        if (!obj._deprecatedEvents) {\n            obj._deprecatedEvents = {};\n        }\n        obj._deprecatedEvents[eventName] = insteadStr || true;\n    }\n\n\n    exports.makeEventDispatcher = makeEventDispatcher;\n    exports.triggerWithArray    = triggerWithArray;\n    exports.on_duringInit       = on_duringInit;\n    exports.markDeprecated      = markDeprecated;\n});\n\n//# sourceURL=/utils/EventDispatcher.js"),eval("/*\n * Copyright (c) 2012 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the \"Software\"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */\n/*global define, $, window */\n\n/**\n * Utilities for working with Deferred, Promise, and other asynchronous processes.\n */\ndefine('utils/Async',['require','exports','module'],function (require, exports, module) {\n    \"use strict\";\n\n    // Further ideas for Async utilities...\n    //  - Utilities for blocking UI until a Promise completes?\n    //  - A \"SuperDeferred\" could feature some very useful enhancements:\n    //     - API for cancellation (non guaranteed, best attempt)\n    //     - Easier way to add a timeout clause (withTimeout() wrapper below is more verbose)\n    //     - Encapsulate the task kickoff code so you can start it later, e.g. superDeferred.start()\n    //  - Deferred/Promise are unable to do anything akin to a 'finally' block. It'd be nice if we\n    //    could harvest exceptions across all steps of an async process and pipe them to a handler,\n    //    so that we don't leave UI-blocking overlays up forever, etc. But this is hard: we'd have\n    //    wrap every async callback (including low-level native ones that don't use [Super]Deferred)\n    //    to catch exceptions, and then understand which Deferred(s) the code *would* have resolved/\n    //    rejected had it run to completion.\n\n\n    /**\n     * Executes a series of tasks in parallel, returning a \"master\" Promise that is resolved once\n     * all the tasks have resolved. If one or more tasks fail, behavior depends on the failFast\n     * flag:\n     *   - If true, the master Promise is rejected as soon as the first task fails. The remaining\n     *     tasks continue to completion in the background.\n     *   - If false, the master Promise is rejected after all tasks have completed.\n     *\n     * If nothing fails:          (M = master promise; 1-4 = tasks; d = done; F = fail)\n     *  M  ------------d\n     *  1 >---d        .\n     *  2 >------d     .\n     *  3 >---------d  .\n     *  4 >------------d\n     *\n     * With failFast = false:\n     *  M  ------------F\n     *  1 >---d     .  .\n     *  2 >------d  .  .\n     *  3 >---------F  .\n     *  4 >------------d\n     *\n     * With failFast = true: -- equivalent to $.when()\n     *  M  ---------F\n     *  1 >---d     .\n     *  2 >------d  .\n     *  3 >---------F\n     *  4 >------------d   (#4 continues even though master Promise has failed)\n     * (Note: if tasks finish synchronously, the behavior is more like failFast=false because you\n     * won't get a chance to respond to the master Promise until after all items have been processed)\n     *\n     * To perform task-specific work after an individual task completes, attach handlers to each\n     * Promise before beginProcessItem() returns it.\n     *\n     * Note: don't use this if individual tasks (or their done/fail handlers) could ever show a user-\n     * visible dialog: because they run in parallel, you could show multiple dialogs atop each other.\n     *\n     * @param {!Array.<*>} items\n     * @param {!function(*, number):Promise} beginProcessItem\n     * @param {!boolean} failFast\n     * @return {$.Promise}\n     */\n    function doInParallel(items, beginProcessItem, failFast) {\n        var promises = [];\n        var masterDeferred = new $.Deferred();\n\n        if (items.length === 0) {\n            masterDeferred.resolve();\n\n        } else {\n            var numCompleted = 0;\n            var hasFailed = false;\n\n            items.forEach(function (item, i) {\n                var itemPromise = beginProcessItem(item, i);\n                promises.push(itemPromise);\n\n                itemPromise.fail(function () {\n                    if (failFast) {\n                        masterDeferred.reject();\n                    } else {\n                        hasFailed = true;\n                    }\n                });\n                itemPromise.always(function () {\n                    numCompleted++;\n                    if (numCompleted === items.length) {\n                        if (hasFailed) {\n                            masterDeferred.reject();\n                        } else {\n                            masterDeferred.resolve();\n                        }\n                    }\n                });\n            });\n\n        }\n\n        return masterDeferred.promise();\n    }\n\n    /**\n     * Executes a series of tasks in serial (task N does not begin until task N-1 has completed).\n     * Returns a \"master\" Promise that is resolved once all the tasks have resolved. If one or more\n     * tasks fail, behavior depends on the failAndStopFast flag:\n     *   - If true, the master Promise is rejected as soon as the first task fails. The remaining\n     *     tasks are never started (the serial sequence is stopped).\n     *   - If false, the master Promise is rejected after all tasks have completed.\n     *\n     * If nothing fails:\n     *  M  ------------d\n     *  1 >---d        .\n     *  2     >--d     .\n     *  3        >--d  .\n     *  4           >--d\n     *\n     * With failAndStopFast = false:\n     *  M  ------------F\n     *  1 >---d     .  .\n     *  2     >--d  .  .\n     *  3        >--F  .\n     *  4           >--d\n     *\n     * With failAndStopFast = true:\n     *  M  ---------F\n     *  1 >---d     .\n     *  2     >--d  .\n     *  3        >--F\n     *  4          (#4 never runs)\n     *\n     * To perform task-specific work after an individual task completes, attach handlers to each\n     * Promise before beginProcessItem() returns it.\n     *\n     * @param {!Array.<*>} items\n     * @param {!function(*, number):Promise} beginProcessItem\n     * @param {!boolean} failAndStopFast\n     * @return {$.Promise}\n     */\n    function doSequentially(items, beginProcessItem, failAndStopFast) {\n\n        var masterDeferred = new $.Deferred(),\n            hasFailed = false;\n\n        function doItem(i) {\n            if (i >= items.length) {\n                if (hasFailed) {\n                    masterDeferred.reject();\n                } else {\n                    masterDeferred.resolve();\n                }\n                return;\n            }\n\n            var itemPromise = beginProcessItem(items[i], i);\n\n            itemPromise.done(function () {\n                doItem(i + 1);\n            });\n            itemPromise.fail(function () {\n                if (failAndStopFast) {\n                    masterDeferred.reject();\n                    // note: we do NOT process any further items in this case\n                } else {\n                    hasFailed = true;\n                    doItem(i + 1);\n                }\n            });\n        }\n\n        doItem(0);\n\n        return masterDeferred.promise();\n    }\n\n    /**\n     * Executes a series of synchronous tasks sequentially spread over time-slices less than maxBlockingTime.\n     * Processing yields by idleTime between time-slices.\n     *\n     * @param {!Array.<*>} items\n     * @param {!function(*, number)} fnProcessItem  Function that synchronously processes one item\n     * @param {number=} maxBlockingTime\n     * @param {number=} idleTime\n     * @return {$.Promise}\n     */\n    function doSequentiallyInBackground(items, fnProcessItem, maxBlockingTime, idleTime) {\n\n        maxBlockingTime = maxBlockingTime || 15;\n        idleTime = idleTime || 30;\n\n        var sliceStartTime = (new Date()).getTime();\n\n        return doSequentially(items, function (item, i) {\n            var result = new $.Deferred();\n\n            // process the next item\n            fnProcessItem(item, i);\n\n            // if we've exhausted our maxBlockingTime\n            if ((new Date()).getTime() - sliceStartTime >= maxBlockingTime) {\n                //yield\n                window.setTimeout(function () {\n                    sliceStartTime = (new Date()).getTime();\n                    result.resolve();\n                }, idleTime);\n            } else {\n                //continue processing\n                result.resolve();\n            }\n\n            return result;\n        }, false);\n    }\n\n    /**\n     * Executes a series of tasks in serial (task N does not begin until task N-1 has completed).\n     * Returns a \"master\" Promise that is resolved when the first task has resolved. If all tasks\n     * fail, the master Promise is rejected.\n     *\n     * @param {!Array.<*>} items\n     * @param {!function(*, number):Promise} beginProcessItem\n     * @return {$.Promise}\n     */\n    function firstSequentially(items, beginProcessItem) {\n\n        var masterDeferred = new $.Deferred();\n\n        function doItem(i) {\n            if (i >= items.length) {\n                masterDeferred.reject();\n                return;\n            }\n\n            beginProcessItem(items[i], i)\n                .fail(function () {\n                    doItem(i + 1);\n                })\n                .done(function () {\n                    masterDeferred.resolve(items[i]);\n                });\n        }\n\n        doItem(0);\n        return masterDeferred.promise();\n    }\n\n    /**\n     * Executes a series of tasks in parallel, saving up error info from any that fail along the way.\n     * Returns a Promise that is only resolved/rejected once all tasks are complete. This is\n     * essentially a wrapper around doInParallel(..., false).\n     *\n     * If one or more tasks failed, the entire \"master\" promise is rejected at the end - with one\n     * argument: an array objects, one per failed task. Each error object contains:\n     *  - item -- the entry in items whose task failed\n     *  - error -- the first argument passed to the fail() handler when the task failed\n     *\n     * @param {!Array.<*>} items\n     * @param {!function(*, number):Promise} beginProcessItem\n     * @return {$.Promise}\n     */\n    function doInParallel_aggregateErrors(items, beginProcessItem) {\n        var errors = [];\n\n        var masterDeferred = new $.Deferred();\n\n        var parallelResult = doInParallel(\n            items,\n            function (item, i) {\n                var itemResult = beginProcessItem(item, i);\n                itemResult.fail(function (error) {\n                    errors.push({ item: item, error: error });\n                });\n                return itemResult;\n            },\n            false\n        );\n\n        parallelResult\n            .done(function () {\n                masterDeferred.resolve();\n            })\n            .fail(function () {\n                masterDeferred.reject(errors);\n            });\n\n        return masterDeferred.promise();\n    }\n\n    /** Value passed to fail() handlers that have been triggered due to withTimeout()'s timeout */\n    var ERROR_TIMEOUT = {};\n\n    /**\n     * Adds timeout-driven termination to a Promise: returns a new Promise that is resolved/rejected when\n     * the given original Promise is resolved/rejected, OR is resolved/rejected after the given delay -\n     * whichever happens first.\n     *\n     * If the original Promise is resolved/rejected first, done()/fail() handlers receive arguments\n     * piped from the original Promise. If the timeout occurs first instead, then resolve() or\n     * fail() (with Async.ERROR_TIMEOUT) is called based on value of resolveTimeout.\n     *\n     * @param {$.Promise} promise\n     * @param {number} timeout\n     * @param {boolean=} resolveTimeout If true, then resolve deferred on timeout, otherwise reject. Default is false.\n     * @return {$.Promise}\n     */\n    function withTimeout(promise, timeout, resolveTimeout) {\n        var wrapper = new $.Deferred();\n\n        var timer = window.setTimeout(function () {\n            if (resolveTimeout) {\n                wrapper.resolve();\n            } else {\n                wrapper.reject(ERROR_TIMEOUT);\n            }\n        }, timeout);\n        promise.always(function () {\n            window.clearTimeout(timer);\n        });\n\n        // If the wrapper was already rejected due to timeout, the Promise's calls to resolve/reject\n        // won't do anything\n        promise.then(wrapper.resolve, wrapper.reject);\n\n        return wrapper.promise();\n    }\n\n    /**\n     * Allows waiting for all the promises to be either resolved or rejected.\n     * Unlike $.when(), it does not call .fail() or .always() handlers on first\n     * reject. The caller should take all the precaution to make sure all the\n     * promises passed to this function are completed to avoid blocking.\n     *\n     * If failOnReject is set to true, promise returned by the function will be\n     * rejected if at least one of the promises was rejected. The default value\n     * is false, which will cause the call to this function to be always\n     * successfully resolved.\n     *\n     * If timeout is specified, the promise will be rejected on timeout as per\n     * Async.withTimeout.\n     *\n     * @param {!Array.<$.Promise>} promises Array of promises to wait for\n     * @param {boolean=} failOnReject       Whether to reject or not if one of the promises has been rejected.\n     * @param {number=} timeout             Number of milliseconds to wait until rejecting the promise\n     *\n     * @return {$.Promise} A Promise which will be resolved once all dependent promises are resolved.\n     *                     It is resolved with an array of results from the successfully resolved dependent promises.\n     *                     The resulting array may not be in the same order or contain as many items as there were\n     *                     promises to wait on and it will contain 'undefined' entries for those promises that resolve\n     *                     without a result.\n     *\n     */\n    function waitForAll(promises, failOnReject, timeout) {\n        var masterDeferred = new $.Deferred(),\n            results = [],\n            count = 0,\n            sawRejects = false;\n\n        if (!promises || promises.length === 0) {\n            masterDeferred.resolve();\n            return masterDeferred.promise();\n        }\n\n        // set defaults if needed\n        failOnReject = (failOnReject === undefined) ? false : true;\n\n        if (timeout !== undefined) {\n            withTimeout(masterDeferred, timeout);\n        }\n\n        promises.forEach(function (promise) {\n            promise\n                .fail(function (err) {\n                    sawRejects = true;\n                })\n                .done(function (result) {\n                    results.push(result);\n                })\n                .always(function () {\n                    count++;\n                    if (count === promises.length) {\n                        if (failOnReject && sawRejects) {\n                            masterDeferred.reject();\n                        } else {\n                            masterDeferred.resolve(results);\n                        }\n                    }\n                });\n        });\n\n        return masterDeferred.promise();\n    }\n\n    /**\n     * Chains a series of synchronous and asynchronous (jQuery promise-returning) functions\n     * together, using the result of each successive function as the argument(s) to the next.\n     * A promise is returned that resolves with the result of the final call if all calls\n     * resolve or return normally. Otherwise, if any of the functions reject or throw, the\n     * computation is halted immediately and the promise is rejected with this halting error.\n     *\n     * @param {Array.<function(*)>} functions Functions to be chained\n     * @param {?Array} args Arguments to call the first function with\n     * @return {jQuery.Promise} A promise that resolves with the result of the final call, or\n     *      rejects with the first error.\n     */\n    function chain(functions, args) {\n        var deferred = $.Deferred();\n\n        function chainHelper(index, args) {\n            if (functions.length === index) {\n                deferred.resolveWith(null, args);\n            } else {\n                var nextFunction = functions[index++];\n                try {\n                    var responseOrPromise = nextFunction.apply(null, args);\n                    if (responseOrPromise.hasOwnProperty(\"done\") &&\n                            responseOrPromise.hasOwnProperty(\"fail\")) {\n                        responseOrPromise.done(function () {\n                            chainHelper(index, arguments);\n                        });\n                        responseOrPromise.fail(function () {\n                            deferred.rejectWith(null, arguments);\n                        });\n                    } else {\n                        chainHelper(index, [responseOrPromise]);\n                    }\n                } catch (e) {\n                    deferred.reject(e);\n                }\n            }\n        }\n\n        chainHelper(0, args || []);\n\n        return deferred.promise();\n    }\n\n    /**\n     * Utility for converting a method that takes (error, callback) to one that returns a promise;\n     * useful for using FileSystem methods (or other Node-style API methods) in a promise-oriented\n     * workflow. For example, instead of\n     *\n     *      var deferred = new $.Deferred();\n     *      file.read(function (err, contents) {\n     *          if (err) {\n     *              deferred.reject(err);\n     *          } else {\n     *              // ...process the contents...\n     *              deferred.resolve();\n     *          }\n     *      }\n     *      return deferred.promise();\n     *\n     * you can just do\n     *\n     *      return Async.promisify(file, \"read\").then(function (contents) {\n     *          // ...process the contents...\n     *      });\n     *\n     * The object/method are passed as an object/string pair so that we can\n     * properly call the method without the caller having to deal with \"bind\" all the time.\n     *\n     * @param {Object} obj The object to call the method on.\n     * @param {string} method The name of the method. The method should expect the errback\n     *      as its last parameter.\n     * @param {...Object} varargs The arguments you would have normally passed to the method\n     *      (excluding the errback itself).\n     * @return {$.Promise} A promise that is resolved with the arguments that were passed to the\n     *      errback (not including the err argument) if err is null, or rejected with the err if\n     *      non-null.\n     */\n    function promisify(obj, method) {\n        var result = new $.Deferred(),\n            args = Array.prototype.slice.call(arguments, 2);\n        args.push(function (err) {\n            if (err) {\n                result.reject(err);\n            } else {\n                result.resolve.apply(result, Array.prototype.slice.call(arguments, 1));\n            }\n        });\n        obj[method].apply(obj, args);\n        return result.promise();\n    }\n\n    /**\n     * Creates a queue of async operations that will be executed sequentially. Operations can be added to the\n     * queue at any time. If the queue is empty and nothing is currently executing when an operation is added,\n     * it will execute immediately. Otherwise, it will execute when the last operation currently in the queue\n     * has finished.\n     * @constructor\n     */\n    function PromiseQueue() {\n        this._queue = [];\n    }\n\n    /**\n     * @private\n     * @type {Array.<function(): $.Promise>}\n     * The queue of operations to execute sequentially. Note that even if this array is empty, there might\n     * still be an operation we need to wait on; that operation's promise is stored in _curPromise.\n     */\n    PromiseQueue.prototype._queue = null;\n\n    /**\n     * @private\n     * @type {$.Promise}\n     * The promise we're currently waiting on, or null if there's nothing currently executing.\n     */\n    PromiseQueue.prototype._curPromise = null;\n\n    /**\n     * @type {number} The number of queued promises.\n     */\n    Object.defineProperties(PromiseQueue.prototype, {\n        \"length\": {\n            get: function () { return this._queue.length; },\n            set: function () { throw new Error(\"Cannot set length\"); }\n        }\n    });\n\n    /**\n     * Adds an operation to the queue. If nothing is currently executing, it will execute immediately (and\n     * the next operation added to the queue will wait for it to complete). Otherwise, it will wait until\n     * the last operation in the queue (or the currently executing operation if nothing is in the queue) is\n     * finished. The operation must return a promise that will be resolved or rejected when it's finished;\n     * the queue will continue with the next operation regardless of whether the current operation's promise\n     * is resolved or rejected.\n     * @param {function(): $.Promise} op The operation to add to the queue.\n     */\n    PromiseQueue.prototype.add = function (op) {\n        this._queue.push(op);\n\n        // If something is currently executing, then _doNext() will get called when it's done. If nothing\n        // is executing (in which case the queue should have been empty), we need to call _doNext() to kickstart\n        // the queue.\n        if (!this._curPromise) {\n            this._doNext();\n        }\n    };\n\n    /**\n     * Removes all pending promises from the queue.\n     */\n    PromiseQueue.prototype.removeAll = function () {\n        this._queue = [];\n    };\n\n    /**\n     * @private\n     * Pulls the next operation off the queue and executes it.\n     */\n    PromiseQueue.prototype._doNext = function () {\n        var self = this;\n        if (this._queue.length) {\n            var op = this._queue.shift();\n            this._curPromise = op();\n            this._curPromise.always(function () {\n                self._curPromise = null;\n                self._doNext();\n            });\n        }\n    };\n\n    // Define public API\n    exports.doInParallel        = doInParallel;\n    exports.doSequentially      = doSequentially;\n    exports.doSequentiallyInBackground   = doSequentiallyInBackground;\n    exports.doInParallel_aggregateErrors = doInParallel_aggregateErrors;\n    exports.firstSequentially   = firstSequentially;\n    exports.withTimeout         = withTimeout;\n    exports.waitForAll          = waitForAll;\n    exports.ERROR_TIMEOUT       = ERROR_TIMEOUT;\n    exports.chain               = chain;\n    exports.promisify           = promisify;\n    exports.PromiseQueue        = PromiseQueue;\n});\n\n//# sourceURL=/utils/Async.js"),
eval('/*\n * Copyright (c) 2012 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */\n/*global define, window */\n\ndefine(\'utils/UrlParams\',[\'require\',\'exports\',\'module\',\'thirdparty/lodash\'],function (require, exports, module) {\n    "use strict";\n\n    var _ = require("thirdparty/lodash");\n\n    /**\n     * Convert between URL querystring and name/value pairs. Decodes and encodes URL parameters.\n     */\n    function UrlParams() {\n        this._store = {};\n    }\n\n    /**\n     * Parse the window location by default. Optionally specify a URL to parse.\n     * @param {string} url\n     */\n    UrlParams.prototype.parse = function (url) {\n        var queryString = "",\n            urlParams,\n            p,\n            self = this;\n\n        self._store = {};\n\n        if (!url) {\n            queryString = window.document.location.search.substring(1);\n        } else if (url.indexOf("?") !== -1) {\n            queryString = url.substring(url.indexOf("?") + 1);\n        }\n\n        queryString = queryString.trimRight();\n\n        if (queryString) {\n            urlParams = queryString.split("&");\n\n            urlParams.forEach(function (param) {\n                p = param.split("=");\n                p[1] = p[1] || "";\n                self._store[decodeURIComponent(p[0])] = decodeURIComponent(p[1]);\n            });\n        }\n    };\n\n    /**\n     * Store a name/value string pair\n     * @param {!string} name\n     * @param {!string} value\n     */\n    UrlParams.prototype.put = function (name, value) {\n        this._store[name] = value;\n    };\n\n    /**\n     * Retrieve a value by name\n     * @param {!string} name\n     * @return {string}\n     */\n    UrlParams.prototype.get = function (name) {\n        return this._store[name];\n    };\n\n    /**\n     * Remove a name/value string pair\n     * @param {!string} name\n     */\n    UrlParams.prototype.remove = function (name) {\n        delete this._store[name];\n    };\n\n    /**\n     * Returns true if the parameter list is empty, else returns false.\n     * @return {boolean}\n     */\n    UrlParams.prototype.isEmpty = function (name) {\n        return _.isEmpty(this._store);\n    };\n\n    /**\n     * Encode name/value pairs as URI components.\n     * @return {string}\n     */\n    UrlParams.prototype.toString = function () {\n        var strs = [],\n            self = this;\n\n        _.forEach(self._store, function (value, key) {\n            strs.push(encodeURIComponent(key) + "=" + encodeURIComponent(value));\n        });\n\n        return strs.join("&");\n    };\n\n    // Define public API\n    exports.UrlParams = UrlParams;\n});\n\n//# sourceURL=/utils/UrlParams.js'),eval('/*\n * Copyright (c) 2012 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */\n/*global define, $ */\n\n /**\n  * Manages global application commands that can be called from menu items, key bindings, or subparts\n  * of the application.\n  *\n  * This module dispatches these event(s):\n  *    - commandRegistered  -- when a new command is registered\n  *    - beforeExecuteCommand -- before dispatching a command\n  */\ndefine(\'command/CommandManager\',[\'require\',\'exports\',\'module\',\'utils/EventDispatcher\'],function (require, exports, module) {\n    "use strict";\n\n    var EventDispatcher = require("utils/EventDispatcher");\n\n\n    /**\n     * Map of all registered global commands\n     * @type {Object.<commandID: string, Command>}\n     */\n    var _commands = {};\n\n    /**\n     * Temporary copy of commands map for restoring after testing\n     * TODO (issue #1039): implement separate require contexts for unit tests\n     * @type {Object.<commandID: string, Command>}\n     */\n    var _commandsOriginal = {};\n\n    /**\n     * Events:\n     * - enabledStateChange\n     * - checkedStateChange\n     * - keyBindingAdded\n     * - keyBindingRemoved\n     *\n     * @constructor\n     * @private\n     * @param {string} name - text that will be displayed in the UI to represent command\n     * @param {string} id\n     * @param {function} commandFn - the function that is called when the command is executed.\n     *\n     * TODO: where should this be triggered, The Command or Exports?\n     */\n    function Command(name, id, commandFn) {\n        this._name = name;\n        this._id = id;\n        this._commandFn = commandFn;\n        this._checked = undefined;\n        this._enabled = true;\n    }\n    EventDispatcher.makeEventDispatcher(Command.prototype);\n\n    /**\n     * Get command id\n     * @return {string}\n     */\n    Command.prototype.getID = function () {\n        return this._id;\n    };\n\n    /**\n     * Executes the command. Additional arguments are passed to the executing function\n     *\n     * @return {$.Promise} a jQuery promise that will be resolved when the command completes.\n     */\n    Command.prototype.execute = function () {\n        if (!this._enabled) {\n            return (new $.Deferred()).reject().promise();\n        }\n\n        var result = this._commandFn.apply(this, arguments);\n        if (!result) {\n            // If command does not return a promise, assume that it handled the\n            // command and return a resolved promise\n            return (new $.Deferred()).resolve().promise();\n        } else {\n            return result;\n        }\n    };\n\n    /**\n     * Is command enabled?\n     * @return {boolean}\n     */\n    Command.prototype.getEnabled = function () {\n        return this._enabled;\n    };\n\n    /**\n     * Sets enabled state of Command and dispatches "enabledStateChange"\n     * when the enabled state changes.\n     * @param {boolean} enabled\n     */\n    Command.prototype.setEnabled = function (enabled) {\n        var changed = this._enabled !== enabled;\n        this._enabled = enabled;\n\n        if (changed) {\n            this.trigger("enabledStateChange");\n        }\n    };\n\n    /**\n     * Sets enabled state of Command and dispatches "checkedStateChange"\n     * when the enabled state changes.\n     * @param {boolean} checked\n     */\n    Command.prototype.setChecked = function (checked) {\n        var changed = this._checked !== checked;\n        this._checked = checked;\n\n        if (changed) {\n            this.trigger("checkedStateChange");\n        }\n    };\n\n    /**\n     * Is command checked?\n     * @return {boolean}\n     */\n    Command.prototype.getChecked = function () {\n        return this._checked;\n    };\n\n    /**\n     * Sets the name of the Command and dispatches "nameChange" so that\n     * UI that reflects the command name can update.\n     *\n     * Note, a Command name can appear in either HTML or native UI\n     * so HTML tags should not be used. To add a Unicode character,\n     * use \\uXXXX instead of an HTML entity.\n     *\n     * @param {string} name\n     */\n    Command.prototype.setName = function (name) {\n        var changed = this._name !== name;\n        this._name = name;\n\n        if (changed) {\n            this.trigger("nameChange");\n        }\n    };\n\n    /**\n     * Get command name\n     * @return {string}\n     */\n    Command.prototype.getName = function () {\n        return this._name;\n    };\n\n\n\n    /**\n     * Registers a global command.\n     * @param {string} name - text that will be displayed in the UI to represent command\n     * @param {string} id - unique identifier for command.\n     *      Core commands in Brackets use a simple command title as an id, for example "open.file".\n     *      Extensions should use the following format: "author.myextension.mycommandname".\n     *      For example, "lschmitt.csswizard.format.css".\n     * @param {function(...)} commandFn - the function to call when the command is executed. Any arguments passed to\n     *     execute() (after the id) are passed as arguments to the function. If the function is asynchronous,\n     *     it must return a jQuery promise that is resolved when the command completes. Otherwise, the\n     *     CommandManager will assume it is synchronous, and return a promise that is already resolved.\n     * @return {?Command}\n     */\n    function register(name, id, commandFn) {\n        if (_commands[id]) {\n            console.log("Attempting to register an already-registered command: " + id);\n            return null;\n        }\n        if (!name || !id || !commandFn) {\n            console.error("Attempting to register a command with a missing name, id, or command function:" + name + " " + id);\n            return null;\n        }\n\n        var command = new Command(name, id, commandFn);\n        _commands[id] = command;\n\n        exports.trigger("commandRegistered", command);\n\n        return command;\n    }\n\n    /**\n     * Registers a global internal only command.\n     * @param {string} id - unique identifier for command.\n     *      Core commands in Brackets use a simple command title as an id, for example "app.abort_quit".\n     *      Extensions should use the following format: "author.myextension.mycommandname".\n     *      For example, "lschmitt.csswizard.format.css".\n     * @param {function(...)} commandFn - the function to call when the command is executed. Any arguments passed to\n     *     execute() (after the id) are passed as arguments to the function. If the function is asynchronous,\n     *     it must return a jQuery promise that is resolved when the command completes. Otherwise, the\n     *     CommandManager will assume it is synchronous, and return a promise that is already resolved.\n     * @return {?Command}\n     */\n    function registerInternal(id, commandFn) {\n        if (_commands[id]) {\n            console.log("Attempting to register an already-registered command: " + id);\n            return null;\n        }\n        if (!id || !commandFn) {\n            console.error("Attempting to register an internal command with a missing id, or command function: " + id);\n            return null;\n        }\n\n        var command = new Command(null, id, commandFn);\n        _commands[id] = command;\n\n        exports.trigger("commandRegistered", command);\n\n        return command;\n    }\n\n    /**\n     * Clear all commands for unit testing, but first make copy of commands so that\n     * they can be restored afterward\n     */\n    function _testReset() {\n        _commandsOriginal = _commands;\n        _commands = {};\n    }\n\n    /**\n     * Restore original commands after test and release copy\n     */\n    function _testRestore() {\n        _commands = _commandsOriginal;\n        _commandsOriginal = {};\n    }\n\n    /**\n     * Retrieves a Command object by id\n     * @param {string} id\n     * @return {Command}\n     */\n    function get(id) {\n        return _commands[id];\n    }\n\n    /**\n     * Returns the ids of all registered commands\n     * @return {Array.<string>}\n     */\n    function getAll() {\n        return Object.keys(_commands);\n    }\n\n    /**\n     * Looks up and runs a global command. Additional arguments are passed to the command.\n     *\n     * @param {string} id The ID of the command to run.\n     * @return {$.Promise} a jQuery promise that will be resolved when the command completes.\n     */\n    function execute(id) {\n        var command = _commands[id];\n\n        if (command) {\n            try {\n                exports.trigger("beforeExecuteCommand", id);\n            } catch (err) {\n                console.error(err);\n            }\n\n            return command.execute.apply(command, Array.prototype.slice.call(arguments, 1));\n        } else {\n            return (new $.Deferred()).reject().promise();\n        }\n    }\n\n    EventDispatcher.makeEventDispatcher(exports);\n\n    // Define public API\n    exports.register            = register;\n    exports.registerInternal    = registerInternal;\n    exports.execute             = execute;\n    exports.get                 = get;\n    exports.getAll              = getAll;\n    exports._testReset          = _testReset;\n    exports._testRestore        = _testRestore;\n});\n\n//# sourceURL=/command/CommandManager.js'),eval('/*\n * Copyright (c) 2014 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n/*global define, console */\n\n/**\n *  Utilities functions to display deprecation warning in the console.\n *\n */\ndefine(\'utils/DeprecationWarning\',[\'require\',\'exports\',\'module\',\'utils/EventDispatcher\'],function (require, exports, module) {\n    "use strict";\n\n    var EventDispatcher = require("utils/EventDispatcher");\n\n\n    var displayedWarnings = {};\n\n    /**\n     * Trim the stack so that it does not have the call to this module,\n     * and all the calls to require.js to load the extension that shows\n     * this deprecation warning.\n     */\n    function _trimStack(stack) {\n        var indexOfFirstRequireJSline;\n\n        // Remove everything in the stack up to the end of the line that shows this module file path\n        stack = stack.substr(stack.indexOf(")\\n") + 2);\n\n        // Find the very first line of require.js in the stack if the call is from an extension.\n        // Remove all those lines from the call stack.\n        indexOfFirstRequireJSline = stack.indexOf("requirejs/require.js");\n        if (indexOfFirstRequireJSline !== -1) {\n            indexOfFirstRequireJSline = stack.lastIndexOf(")", indexOfFirstRequireJSline) + 1;\n            stack = stack.substr(0, indexOfFirstRequireJSline);\n        }\n\n        return stack;\n    }\n\n    /**\n     * Show deprecation warning with the call stack if it\n     * has never been displayed before.\n     * @param {!string} message The deprecation message to be displayed.\n     * @param {boolean=} oncePerCaller If true, displays the message once for each unique call location.\n     *     If false (the default), only displays the message once no matter where it\'s called from.\n     *     Note that setting this to true can cause a slight performance hit (because it has to generate\n     *     a stack trace), so don\'t set this for functions that you expect to be called from performance-\n     *     sensitive code (e.g. tight loops).\n     * @param {number=} callerStackPos Only used if oncePerCaller=true. Overrides the `Error().stack` depth\n     *     where the client-code caller can be found. Only needed if extra shim layers are involved.\n     */\n    function deprecationWarning(message, oncePerCaller, callerStackPos) {\n        // If oncePerCaller isn\'t set, then only show the message once no matter who calls it.\n        if (!message || (!oncePerCaller && displayedWarnings[message])) {\n            return;\n        }\n\n        // Don\'t show the warning again if we\'ve already gotten it from the current caller.\n        // The true caller location is the fourth line in the stack trace:\n        // * 0 is the word "Error"\n        // * 1 is this function\n        // * 2 is the caller of this function (the one throwing the deprecation warning)\n        // * 3 is the actual caller of the deprecated function.\n        var stack = new Error().stack,\n            callerLocation = stack.split("\\n")[callerStackPos || 3];\n        if (oncePerCaller && displayedWarnings[message] && displayedWarnings[message][callerLocation]) {\n            return;\n        }\n\n        console.warn(message + "\\n" + _trimStack(stack));\n        if (!displayedWarnings[message]) {\n            displayedWarnings[message] = {};\n        }\n        displayedWarnings[message][callerLocation] = true;\n    }\n\n\n    /**\n     * Show a deprecation warning if there are listeners for the event\n     *\n     * ```\n     *    DeprecationWarning.deprecateEvent(exports,\n     *                                      MainViewManager,\n     *                                      "workingSetAdd",\n     *                                      "workingSetAdd",\n     *                                      "DocumentManager.workingSetAdd",\n     *                                      "MainViewManager.workingSetAdd");\n     * ```\n     *\n     * @param {Object} outbound - the object with the old event to dispatch\n     * @param {Object} inbound - the object with the new event to map to the old event\n     * @param {string} oldEventName - the name of the old event\n     * @param {string} newEventName - the name of the new event\n     * @param {string=} canonicalOutboundName - the canonical name of the old event\n     * @param {string=} canonicalInboundName - the canonical name of the new event\n     */\n    function deprecateEvent(outbound, inbound, oldEventName, newEventName, canonicalOutboundName, canonicalInboundName) {\n        // Mark deprecated so EventDispatcher.on() will emit warnings\n        EventDispatcher.markDeprecated(outbound, oldEventName, canonicalInboundName);\n\n        // create an event handler for the new event to listen for\n        inbound.on(newEventName, function () {\n            // Dispatch the event in case anyone is still listening\n            EventDispatcher.triggerWithArray(outbound, oldEventName, Array.prototype.slice.call(arguments, 1));\n        });\n    }\n\n\n    /**\n     * Create a deprecation warning and action for updated constants\n     * @param {!string} old Menu Id\n     * @param {!string} new Menu Id\n     */\n    function deprecateConstant(obj, oldId, newId) {\n        var warning     = "Use Menus." + newId + " instead of Menus." + oldId,\n            newValue    = obj[newId];\n\n        Object.defineProperty(obj, oldId, {\n            get: function () {\n                deprecationWarning(warning, true);\n                return newValue;\n            }\n        });\n    }\n\n    // Define public API\n    exports.deprecationWarning   = deprecationWarning;\n    exports.deprecateEvent       = deprecateEvent;\n    exports.deprecateConstant      = deprecateConstant;\n});\n\n//# sourceURL=/utils/DeprecationWarning.js'),eval('/*\n * Copyright (c) 2012 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */\n/*global define */\n\ndefine(\'command/Commands\',[\'require\',\'exports\',\'module\',\'utils/DeprecationWarning\'],function (require, exports, module) {\n    "use strict";\n\n    var DeprecationWarning = require("utils/DeprecationWarning");\n\n    /**\n     * List of constants for global command IDs.\n     */\n\n    // FILE\n    exports.FILE_NEW_UNTITLED           = "file.newDoc";                // DocumentCommandHandlers.js   handleFileNew()\n    exports.FILE_NEW                    = "file.newFile";               // DocumentCommandHandlers.js   handleFileNewInProject()\n    exports.FILE_NEW_FOLDER             = "file.newFolder";             // DocumentCommandHandlers.js   handleNewFolderInProject()\n    exports.FILE_OPEN                   = "file.open";                  // DocumentCommandHandlers.js   handleDocumentOpen()\n    exports.FILE_OPEN_FOLDER            = "file.openFolder";            // ProjectManager.js            openProject()\n    exports.FILE_SAVE                   = "file.save";                  // DocumentCommandHandlers.js   handleFileSave()\n    exports.FILE_SAVE_ALL               = "file.saveAll";               // DocumentCommandHandlers.js   handleFileSaveAll()\n    exports.FILE_SAVE_AS                = "file.saveAs";                // DocumentCommandHandlers.js   handleFileSaveAs()\n    exports.FILE_CLOSE                  = "file.close";                 // DocumentCommandHandlers.js   handleFileClose()\n    exports.FILE_CLOSE_ALL              = "file.close_all";             // DocumentCommandHandlers.js   handleFileCloseAll()\n    exports.FILE_CLOSE_LIST             = "file.close_list";            // DocumentCommandHandlers.js   handleFileCloseList()\n    exports.FILE_OPEN_DROPPED_FILES     = "file.openDroppedFiles";      // DragAndDrop.js               openDroppedFiles()\n    exports.FILE_LIVE_FILE_PREVIEW      = "file.liveFilePreview";       // LiveDevelopment/main.js      _handleGoLiveCommand()\n    exports.TOGGLE_LIVE_PREVIEW_MB_MODE = "file.toggleLivePreviewMB";   // LiveDevelopment/main.js      _toggleLivePreviewMultiBrowser()\n    exports.CMD_RELOAD_LIVE_PREVIEW     = "file.reloadLivePreview";     // LiveDevelopment/main.js      _handleReloadLivePreviewCommand()\n    exports.FILE_LIVE_HIGHLIGHT         = "file.previewHighlight";      // LiveDevelopment/main.js      _handlePreviewHighlightCommand()\n    exports.FILE_PROJECT_SETTINGS       = "file.projectSettings";       // ProjectManager.js            _projectSettings()\n    exports.FILE_RENAME                 = "file.rename";                // DocumentCommandHandlers.js   handleFileRename()\n    exports.FILE_DELETE                 = "file.delete";                // DocumentCommandHandlers.js   handleFileDelete()\n    exports.FILE_EXTENSION_MANAGER      = "file.extensionManager";      // ExtensionManagerDialog.js    _showDialog()\n    exports.FILE_REFRESH                = "file.refresh";               // ProjectManager.js            refreshFileTree()\n    exports.FILE_OPEN_PREFERENCES       = "file.openPreferences";       // PreferencesManager.js        _handleOpenPreferences()\n    exports.FILE_OPEN_KEYMAP            = "file.openKeyMap";            // KeyBindingManager.js         _openUserKeyMap()\n\n    // File shell callbacks - string must MATCH string in native code (appshell/command_callbacks.h)\n    exports.FILE_CLOSE_WINDOW           = "file.close_window";          // DocumentCommandHandlers.js   handleFileCloseWindow()\n    exports.FILE_QUIT                   = "file.quit";                  // DocumentCommandHandlers.js   handleFileQuit()\n\n    // EDIT\n    // File shell callbacks - string must MATCH string in native code (appshell/command_callbacks.h)\n    exports.EDIT_UNDO                   = "edit.undo";                  // EditorCommandHandlers.js     handleUndo()\n    exports.EDIT_REDO                   = "edit.redo";                  // EditorCommandHandlers.js     handleRedo()\n    exports.EDIT_CUT                    = "edit.cut";                   // EditorCommandHandlers.js     ignoreCommand()\n    exports.EDIT_COPY                   = "edit.copy";                  // EditorCommandHandlers.js     ignoreCommand()\n    exports.EDIT_PASTE                  = "edit.paste";                 // EditorCommandHandlers.js     ignoreCommand()\n    exports.EDIT_SELECT_ALL             = "edit.selectAll";             // EditorCommandHandlers.js     _handleSelectAll()\n\n    exports.EDIT_SELECT_LINE            = "edit.selectLine";            // EditorCommandHandlers.js     selectLine()\n    exports.EDIT_SPLIT_SEL_INTO_LINES   = "edit.splitSelIntoLines";     // EditorCommandHandlers.js     splitSelIntoLines()\n    exports.EDIT_ADD_CUR_TO_NEXT_LINE   = "edit.addCursorToNextLine";   // EditorCommandHandlers.js     addCursorToNextLine()\n    exports.EDIT_ADD_CUR_TO_PREV_LINE   = "edit.addCursorToPrevLine";   // EditorCommandHandlers.js     addCursorToPrevLine()\n    exports.EDIT_INDENT                 = "edit.indent";                // EditorCommandHandlers.js     indentText()\n    exports.EDIT_UNINDENT               = "edit.unindent";              // EditorCommandHandlers.js     unindentText()\n    exports.EDIT_DUPLICATE              = "edit.duplicate";             // EditorCommandHandlers.js     duplicateText()\n    exports.EDIT_DELETE_LINES           = "edit.deletelines";           // EditorCommandHandlers.js     deleteCurrentLines()\n    exports.EDIT_LINE_COMMENT           = "edit.lineComment";           // EditorCommandHandlers.js     lineComment()\n    exports.EDIT_BLOCK_COMMENT          = "edit.blockComment";          // EditorCommandHandlers.js     blockComment()\n    exports.EDIT_LINE_UP                = "edit.lineUp";                // EditorCommandHandlers.js     moveLineUp()\n    exports.EDIT_LINE_DOWN              = "edit.lineDown";              // EditorCommandHandlers.js     moveLineDown()\n    exports.EDIT_OPEN_LINE_ABOVE        = "edit.openLineAbove";         // EditorCommandHandlers.js     openLineAbove()\n    exports.EDIT_OPEN_LINE_BELOW        = "edit.openLineBelow";         // EditorCommandHandlers.js     openLineBelow()\n    exports.TOGGLE_CLOSE_BRACKETS       = "edit.autoCloseBrackets";     // EditorOptionHandlers.js      _getToggler()\n    exports.SHOW_CODE_HINTS             = "edit.showCodeHints";         // CodeHintManager.js           _startNewSession()\n\n    // FIND\n    exports.CMD_FIND                    = "cmd.find";                   // FindReplace.js               _launchFind()\n    exports.CMD_FIND_IN_FILES           = "cmd.findInFiles";            // FindInFilesUI.js             _showFindBar()\n    exports.CMD_FIND_IN_SUBTREE         = "cmd.findInSubtree";          // FindInFilesUI.js             _showFindBarForSubtree()\n    exports.CMD_FIND_NEXT               = "cmd.findNext";               // FindReplace.js               _findNext()\n    exports.CMD_FIND_PREVIOUS           = "cmd.findPrevious";           // FindReplace.js               _findPrevious()\n    exports.CMD_FIND_ALL_AND_SELECT     = "cmd.findAllAndSelect";       // FindReplace.js               _findAllAndSelect()\n    exports.CMD_ADD_NEXT_MATCH          = "cmd.addNextMatch";           // FindReplace.js               _expandAndAddNextToSelection()\n    exports.CMD_SKIP_CURRENT_MATCH      = "cmd.skipCurrentMatch";       // FindReplace.js               _skipCurrentMatch()\n    exports.CMD_REPLACE                 = "cmd.replace";                // FindReplace.js               _replace()\n    exports.CMD_REPLACE_IN_FILES        = "cmd.replaceInFiles";         // FindInFilesUI.js             _showReplaceBar()\n    exports.CMD_REPLACE_IN_SUBTREE      = "cmd.replaceInSubtree";       // FindInFilesUI.js             _showReplaceBarForSubtree()\n\n    // VIEW\n    exports.CMD_THEMES_OPEN_SETTINGS    = "view.themesOpenSetting";     // MenuCommands.js              Settings.open()\n    exports.VIEW_HIDE_SIDEBAR           = "view.toggleSidebar";         // SidebarView.js               toggle()\n    exports.VIEW_INCREASE_FONT_SIZE     = "view.increaseFontSize";      // ViewCommandHandlers.js       _handleIncreaseFontSize()\n    exports.VIEW_DECREASE_FONT_SIZE     = "view.decreaseFontSize";      // ViewCommandHandlers.js       _handleDecreaseFontSize()\n    exports.VIEW_RESTORE_FONT_SIZE      = "view.restoreFontSize";       // ViewCommandHandlers.js       _handleRestoreFontSize()\n    exports.VIEW_SCROLL_LINE_UP         = "view.scrollLineUp";          // ViewCommandHandlers.js       _handleScrollLineUp()\n    exports.VIEW_SCROLL_LINE_DOWN       = "view.scrollLineDown";        // ViewCommandHandlers.js       _handleScrollLineDown()\n    exports.VIEW_TOGGLE_INSPECTION      = "view.toggleCodeInspection";  // CodeInspection.js            toggleEnabled()\n    exports.TOGGLE_LINE_NUMBERS         = "view.toggleLineNumbers";     // EditorOptionHandlers.js      _getToggler()\n    exports.TOGGLE_ACTIVE_LINE          = "view.toggleActiveLine";      // EditorOptionHandlers.js      _getToggler()\n    exports.TOGGLE_WORD_WRAP            = "view.toggleWordWrap";        // EditorOptionHandlers.js      _getToggler()\n\n    exports.CMD_OPEN                        = "cmd.open";\n    exports.CMD_ADD_TO_WORKINGSET_AND_OPEN  = "cmd.addToWorkingSetAndOpen";          // DocumentCommandHandlers.js   handleOpenDocumentInNewPane()\n\n    // NAVIGATE\n    exports.NAVIGATE_NEXT_DOC           = "navigate.nextDoc";           // DocumentCommandHandlers.js   handleGoNextDoc()\n    exports.NAVIGATE_PREV_DOC           = "navigate.prevDoc";           // DocumentCommandHandlers.js   handleGoPrevDoc()\n    exports.NAVIGATE_NEXT_DOC_LIST_ORDER    = "navigate.nextDocListOrder";           // DocumentCommandHandlers.js   handleGoNextDocListOrder()\n    exports.NAVIGATE_PREV_DOC_LIST_ORDER    = "navigate.prevDocListOrder";           // DocumentCommandHandlers.js   handleGoPrevDocListOrder()\n    exports.NAVIGATE_SHOW_IN_FILE_TREE  = "navigate.showInFileTree";    // DocumentCommandHandlers.js   handleShowInTree()\n    exports.NAVIGATE_SHOW_IN_OS         = "navigate.showInOS";          // DocumentCommandHandlers.js   handleShowInOS()\n    exports.NAVIGATE_QUICK_OPEN         = "navigate.quickOpen";         // QuickOpen.js                 doFileSearch()\n    exports.NAVIGATE_JUMPTO_DEFINITION  = "navigate.jumptoDefinition";  // EditorManager.js             _doJumpToDef()\n    exports.NAVIGATE_GOTO_DEFINITION    = "navigate.gotoDefinition";    // QuickOpen.js                 doDefinitionSearch()\n    exports.NAVIGATE_GOTO_LINE          = "navigate.gotoLine";          // QuickOpen.js                 doGotoLine()\n    exports.NAVIGATE_GOTO_FIRST_PROBLEM = "navigate.gotoFirstProblem";  // CodeInspection.js            handleGotoFirstProblem()\n    exports.TOGGLE_QUICK_EDIT           = "navigate.toggleQuickEdit";   // EditorManager.js             _toggleInlineWidget()\n    exports.TOGGLE_QUICK_DOCS           = "navigate.toggleQuickDocs";   // EditorManager.js             _toggleInlineWidget()\n    exports.QUICK_EDIT_NEXT_MATCH       = "navigate.nextMatch";         // MultiRangeInlineEditor.js    _nextRange()\n    exports.QUICK_EDIT_PREV_MATCH       = "navigate.previousMatch";     // MultiRangeInlineEditor.js    _previousRange()\n    exports.CSS_QUICK_EDIT_NEW_RULE     = "navigate.newRule";           // CSSInlineEditor.js           _handleNewRule()\n\n    // HELP\n    exports.HELP_CHECK_FOR_UPDATE       = "help.checkForUpdate";        // HelpCommandHandlers.js       _handleCheckForUpdates()\n    exports.HELP_HOW_TO_USE_BRACKETS    = "help.howToUseBrackets";      // HelpCommandHandlers.js       _handleLinkMenuItem()\n    exports.HELP_SUPPORT                = "help.support";               // HelpCommandHandlers.js       _handleLinkMenuItem()\n    exports.HELP_SUGGEST                = "help.suggest";               // HelpCommandHandlers.js       _handleLinkMenuItem()\n    exports.HELP_RELEASE_NOTES          = "help.releaseNotes";          // HelpCommandHandlers.js       _handleLinkMenuItem()\n    exports.HELP_GET_INVOLVED           = "help.getInvolved";           // HelpCommandHandlers.js       _handleLinkMenuItem()\n    exports.HELP_SHOW_EXT_FOLDER        = "help.showExtensionsFolder";  // HelpCommandHandlers.js       _handleShowExtensionsFolder()\n    exports.HELP_HOMEPAGE               = "help.homepage";              // HelpCommandHandlers.js       _handleLinkMenuItem()\n    exports.HELP_TWITTER                = "help.twitter";               // HelpCommandHandlers.js       _handleLinkMenuItem()\n\n    // Working Set Configuration\n    exports.CMD_WORKINGSET_SORT_BY_ADDED  = "cmd.sortWorkingSetByAdded";     // WorkingSetSort.js       _handleSort()\n    exports.CMD_WORKINGSET_SORT_BY_NAME   = "cmd.sortWorkingSetByName";      // WorkingSetSort.js       _handleSort()\n    exports.CMD_WORKINGSET_SORT_BY_TYPE   = "cmd.sortWorkingSetByType";      // WorkingSetSort.js       _handleSort()\n    exports.CMD_WORKING_SORT_TOGGLE_AUTO  = "cmd.sortWorkingSetToggleAuto";  // WorkingSetSort.js       _handleToggleAutoSort()\n\n    // Split View\n    exports.CMD_SPLITVIEW_NONE          = "cmd.splitViewNone";          // SidebarView.js               _handleSplitNone()\n    exports.CMD_SPLITVIEW_VERTICAL      = "cmd.splitViewVertical";      // SidebarView.js               _handleSplitVertical()\n    exports.CMD_SPLITVIEW_HORIZONTAL    = "cmd.splitViewHorizontal";    // SidebarView.js               _handleSplitHorizontal()\n\n    // File shell callbacks - string must MATCH string in native code (appshell/command_callbacks.h)\n    exports.HELP_ABOUT                  = "help.about";                 // HelpCommandHandlers.js       _handleAboutDialog()\n\n    // APP\n    exports.APP_RELOAD                  = "app.reload";                 // DocumentCommandHandlers.js   handleReload()\n    exports.APP_RELOAD_WITHOUT_EXTS     = "app.reload_without_exts";    // DocumentCommandHandlers.js   handleReloadWithoutExts()\n\n    // File shell callbacks - string must MATCH string in native code (appshell/command_callbacks.h)\n    exports.APP_ABORT_QUIT              = "app.abort_quit";             // DocumentCommandHandlers.js   handleAbortQuit()\n    exports.APP_BEFORE_MENUPOPUP        = "app.before_menupopup";       // DocumentCommandHandlers.js   handleBeforeMenuPopup()\n\n    // ADD_TO_WORKING_SET is deprectated but we need a handler for it because the new command doesn\'t return the same result as the legacy command\n    exports.FILE_ADD_TO_WORKING_SET     = "file.addToWorkingSet";       // Deprecated through DocumentCommandHandlers.js handleFileAddToWorkingSet\n\n    // Show or Hide sidebar\n    exports.HIDE_SIDEBAR                = "view.hideSidebar";           // SidebarView.js               hide()\n    exports.SHOW_SIDEBAR                = "view.showSidebar";           // SidebarView.js               show()\n\n    // DEPRECATED: Working Set Commands\n    DeprecationWarning.deprecateConstant(exports, "SORT_WORKINGSET_BY_ADDED",   "CMD_WORKINGSET_SORT_BY_ADDED");\n    DeprecationWarning.deprecateConstant(exports, "SORT_WORKINGSET_BY_NAME",    "CMD_WORKINGSET_SORT_BY_NAME");\n    DeprecationWarning.deprecateConstant(exports, "SORT_WORKINGSET_BY_TYPE",    "CMD_WORKINGSET_SORT_BY_TYPE");\n    DeprecationWarning.deprecateConstant(exports, "SORT_WORKINGSET_AUTO",       "CMD_WORKING_SORT_TOGGLE_AUTO");\n});\n\n\n//# sourceURL=/command/Commands.js'),
eval('/*\n * Copyright (c) 2012 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */\n/*global define, $, window */\n\n /**\n  * This is JavaScript API exposed to the native shell when Brackets is run in a native shell rather than a browser.\n  */\ndefine(\'utils/ShellAPI\',[\'require\',\'exports\',\'module\',\'utils/AppInit\',\'command/CommandManager\',\'command/Commands\'],function (require, exports, module) {\n    "use strict";\n\n    // Load dependent modules\n    var AppInit        = require("utils/AppInit"),\n        CommandManager = require("command/CommandManager"),\n        Commands       = require("command/Commands");\n\n    var appReady = false; // Set to true after app is fully initialized\n\n    /**\n     * The native function BracketsShellAPI::DispatchBracketsJSCommand calls this function in order to enable\n     * calling Brackets commands from the native shell.\n     */\n    function executeCommand(eventName) {\n        // Temporary fix for #2616 - don\'t execute the command if a modal dialog is open.\n        // This should really be fixed with proper menu enabling.\n        if ($(".modal.instance").length || !appReady) {\n            // Another hack to fix issue #3219 so that all test windows are closed\n            // as before the fix for #3152 has been introduced. isBracketsTestWindow\n            // property is explicitly set in createTestWindowAndRun() in SpecRunnerUtils.js.\n            if (window.isBracketsTestWindow) {\n                return false;\n            }\n            // Return false for all commands except file.close_window command for\n            // which we have to return true (issue #3152).\n            return (eventName === Commands.FILE_CLOSE_WINDOW);\n        }\n\n        // Use E for Error so that uglify doesn\'t change this to simply Error()\n        var promise, E = Error, e = new E(), stackDepth = e.stack.split("\\n").length;\n\n        // This function should *only* be called as a top-level function. If the current\n        // stack depth is > 2, it is most likely because we are at a breakpoint.\n        if (stackDepth < 3) {\n            promise = CommandManager.execute(eventName);\n        } else {\n            console.error("Skipping command " + eventName + " because it looks like you are " +\n                          "at a breakpoint. If you are NOT at a breakpoint, please " +\n                          "file a bug and mention this comment. Stack depth = " + stackDepth + ".");\n        }\n        return (promise && promise.state() === "rejected") ? false : true;\n    }\n\n    AppInit.appReady(function () {\n        appReady = true;\n    });\n\n    exports.executeCommand = executeCommand;\n});\n\n//# sourceURL=/utils/ShellAPI.js'),eval('/*\n * Copyright (c) 2012 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */\n/*global define */\n\n/**\n * Initializes the global "brackets" variable and it\'s properties.\n * Modules should not access the global.brackets object until either\n * (a) the module requires this module, i.e. require("utils/Global") or\n * (b) the module receives a "appReady" callback from the utils/AppReady module.\n */\ndefine(\'utils/Global\',[\'require\',\'exports\',\'module\',\'text!config.json\',\'utils/UrlParams\',\'utils/ShellAPI\'],function (require, exports, module) {\n    "use strict";\n\n    var configJSON  = require("text!config.json"),\n        UrlParams   = require("utils/UrlParams").UrlParams;\n\n    // Define core brackets namespace if it isn\'t already defined\n    //\n    // We can\'t simply do \'brackets = {}\' to define it in the global namespace because\n    // we\'re in "use strict" mode. Most likely, \'window\' will always point to the global\n    // object when this code is running. However, in case it isn\'t (e.g. if we\'re running\n    // inside Node for CI testing) we use this trick to get the global object.\n    var Fn = Function, global = (new Fn("return this"))();\n    if (!global.brackets) {\n        global.brackets = {};\n    }\n\n    // Parse URL params\n    var params = new UrlParams();\n    params.parse();\n\n    // Parse src/config.json\n    try {\n        global.brackets.metadata = JSON.parse(configJSON);\n        global.brackets.config = global.brackets.metadata.config;\n    } catch (err) {\n        console.log(err);\n    }\n\n    // Uncomment the following line to force all low level file i/o routines to complete\n    // asynchronously. This should only be done for testing/debugging.\n    // NOTE: Make sure this line is commented out again before committing!\n    //brackets.forceAsyncCallbacks = true;\n\n    // Load native shell when brackets is run in a native shell rather than the browser\n    // TODO: (issue #266) load conditionally\n    global.brackets.shellAPI = require("utils/ShellAPI");\n\n    // Determine OS/platform\n    if (global.navigator.platform === "MacIntel" || global.navigator.platform === "MacPPC") {\n        global.brackets.platform = "mac";\n    } else if (global.navigator.platform.indexOf("Linux") >= 0) {\n        global.brackets.platform = "linux";\n    } else {\n        global.brackets.platform = "win";\n    }\n\n    global.brackets.inBrowser = !global.brackets.hasOwnProperty("fs");\n\n    // Are we in a desktop shell with a native menu bar?\n    var hasNativeMenus = params.get("hasNativeMenus");\n    if (hasNativeMenus) {\n        global.brackets.nativeMenus = (hasNativeMenus === "true");\n    } else {\n        global.brackets.nativeMenus = (!global.brackets.inBrowser && (global.brackets.platform !== "linux"));\n    }\n\n    // Locale-related APIs\n    global.brackets.isLocaleDefault = function () {\n        return !global.localStorage.getItem("locale");\n    };\n\n    global.brackets.getLocale = function () {\n        // By default use the locale that was determined in brackets.js\n        return params.get("testEnvironment") ? "en" : (global.localStorage.getItem("locale") || global.require.s.contexts._.config.locale);\n    };\n\n    global.brackets.setLocale = function (locale) {\n        if (locale) {\n            global.localStorage.setItem("locale", locale);\n        } else {\n            global.localStorage.removeItem("locale");\n        }\n    };\n\n    // Create empty app namespace if running in-browser\n    if (!global.brackets.app) {\n        global.brackets.app = {};\n    }\n\n    // Loading extensions requires creating new require.js contexts, which\n    // requires access to the global \'require\' object that always gets hidden\n    // by the \'require\' in the AMD wrapper. We store this in the brackets\n    // object here so that the ExtensionLoader doesn\'t have to have access to\n    // the global object.\n    global.brackets.libRequire = global.require;\n\n    // Also store our current require.js context (the one that loads brackets\n    // core modules) so that extensions can use it.\n    // Note: we change the name to "getModule" because this won\'t do exactly\n    // the same thing as \'require\' in AMD-wrapped modules. The extension will\n    // only be able to load modules that have already been loaded once.\n    global.brackets.getModule = require;\n\n    exports.global = global;\n});\n\n//# sourceURL=/utils/Global.js'),eval('/*\n * Copyright (c) 2013 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, regexp: true, indent: 4, maxerr: 50 */\n/*global define */\n\n/**\n * FileSystemError describes the errors that can occur when using the FileSystem, File,\n * and Directory modules.\n *\n * Error values are strings. Any "falsy" value: null, undefined or "" means "no error".\n */\ndefine(\'filesystem/FileSystemError\',[\'require\',\'exports\',\'module\'],function (require, exports, module) {\n    "use strict";\n\n    /**\n     * Enumerated File System Errors\n     * @enum {string}\n     */\n    module.exports = {\n        UNKNOWN                     : "Unknown",\n        INVALID_PARAMS              : "InvalidParams",\n        NOT_FOUND                   : "NotFound",\n        NOT_READABLE                : "NotReadable",\n        UNSUPPORTED_ENCODING        : "UnsupportedEncoding",\n        NOT_SUPPORTED               : "NotSupported",\n        NOT_WRITABLE                : "NotWritable",\n        OUT_OF_SPACE                : "OutOfSpace",\n        TOO_MANY_ENTRIES            : "TooManyEntries",\n        ALREADY_EXISTS              : "AlreadyExists",\n        CONTENTS_MODIFIED           : "ContentsModified",\n        ROOT_NOT_WATCHED            : "RootNotBeingWatched",\n        EXCEEDS_MAX_FILE_SIZE       : "ExceedsMaxFileSize",\n        NETWORK_DRIVE_NOT_SUPPORTED : "NetworkDriveNotSupported"\n\n        // FUTURE: Add remote connection errors: timeout, not logged in, connection err, etc.\n    };\n});\n\n//# sourceURL=/filesystem/FileSystemError.js'),eval('/*\n * Copyright (c) 2012 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n/* The hash code routne is taken from http://stackoverflow.com/questions/7616461/generate-a-hash-from-string-in-javascript-jquery\n   @CC wiki attribution: esmiralha\n*/\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, regexp: true, indent: 4, maxerr: 50, bitwise: true */\n/*global define, brackets */\n\n/**\n *  Utilities functions related to string manipulation\n *\n */\ndefine(\'utils/StringUtils\',[\'require\',\'exports\',\'module\',\'thirdparty/lodash\'],function (require, exports, module) {\n    "use strict";\n\n    var _ = require("thirdparty/lodash");\n\n    /**\n     * Format a string by replacing placeholder symbols with passed in arguments.\n     *\n     * Example: var formatted = StringUtils.format("Hello {0}", "World");\n     *\n     * @param {string} str The base string\n     * @param {...} Arguments to be substituted into the string\n     *\n     * @return {string} Formatted string\n     */\n    function format(str) {\n        // arguments[0] is the base string, so we need to adjust index values here\n        var args = [].slice.call(arguments, 1);\n        return str.replace(/\\{(\\d+)\\}/g, function (match, num) {\n            return typeof args[num] !== "undefined" ? args[num] : match;\n        });\n    }\n\n    function regexEscape(str) {\n        return str.replace(/([.?*+\\^$\\[\\]\\\\(){}|\\-])/g, "\\\\$1");\n    }\n\n    // Periods (aka "dots") are allowed in HTML identifiers, but jQuery interprets\n    // them as the start of a class selector, so they need to be escaped\n    function jQueryIdEscape(str) {\n        return str.replace(/\\./g, "\\\\.");\n    }\n\n    /**\n     * Splits the text by new line characters and returns an array of lines\n     * @param {string} text\n     * @return {Array.<string>} lines\n     */\n    function getLines(text) {\n        return text.split("\\n");\n    }\n\n    /**\n     * Returns a line number corresponding to an offset in some text. The text can\n     * be specified as a single string or as an array of strings that correspond to\n     * the lines of the string.\n     *\n     * Specify the text in lines when repeatedly calling the function on the same\n     * text in a loop. Use getLines() to divide the text into lines, then repeatedly call\n     * this function to compute a line number from the offset.\n     *\n     * @param {string | Array.<string>} textOrLines - string or array of lines from which\n     *      to compute the line number from the offset\n     * @param {number} offset\n     * @return {number} line number\n     */\n    function offsetToLineNum(textOrLines, offset) {\n        if (Array.isArray(textOrLines)) {\n            var lines = textOrLines,\n                total = 0,\n                line;\n            for (line = 0; line < lines.length; line++) {\n                if (total < offset) {\n                    // add 1 per line since /n were removed by splitting, but they needed to\n                    // contribute to the total offset count\n                    total += lines[line].length + 1;\n                } else if (total === offset) {\n                    return line;\n                } else {\n                    return line - 1;\n                }\n            }\n\n            // if offset is NOT over the total then offset is in the last line\n            if (offset <= total) {\n                return line - 1;\n            } else {\n                return undefined;\n            }\n        } else {\n            return textOrLines.substr(0, offset).split("\\n").length - 1;\n        }\n    }\n\n    /**\n     * Returns true if the given string starts with the given prefix.\n     * @param   {String} str\n     * @param   {String} prefix\n     * @return {Boolean}\n     */\n    function startsWith(str, prefix) {\n        return str.slice(0, prefix.length) === prefix;\n    }\n\n    /**\n     * Returns true if the given string ends with the given suffix.\n     *\n     * @param {string} str\n     * @param {string} suffix\n     */\n    function endsWith(str, suffix) {\n        return str.indexOf(suffix, str.length - suffix.length) !== -1;\n    }\n\n    function urlSort(a, b) {\n        var a2, b2;\n        function isFile(s) {\n            return ((s.lastIndexOf("/") + 1) < s.length);\n        }\n\n        if (brackets.platform === "win") {\n            // Windows: prepend folder names with a \'0\' and file names with a \'1\' so folders are listed first\n            a2 = ((isFile(a)) ? "1" : "0") + a.toLowerCase();\n            b2 = ((isFile(b)) ? "1" : "0") + b.toLowerCase();\n        } else {\n            a2 = a.toLowerCase();\n            b2 = b.toLowerCase();\n        }\n\n        if (a2 === b2) {\n            return 0;\n        } else {\n            return (a2 > b2) ? 1 : -1;\n        }\n    }\n\n    /**\n     * Return an escaped path or URL string that can be broken near path separators.\n     * @param {string} url the path or URL to format\n     * @return {string} the formatted path or URL\n     */\n    function breakableUrl(url) {\n        // This is for displaying in UI, so always want it escaped\n        var escUrl = _.escape(url);\n\n        // Inject zero-width space character (U+200B) near path separators (/) to allow line breaking there\n        return escUrl.replace(\n            new RegExp(regexEscape("/"), "g"),\n            "/" + "&#8203;"\n        );\n    }\n\n    /**\n     * Converts number of bytes into human readable format.\n     * If param bytes is negative it returns the number without any changes.\n     *\n     * @param {number} bytes     Number of bytes to convert\n     * @param {number} precision Number of digits after the decimal separator\n     * @return {string}\n     */\n    function prettyPrintBytes(bytes, precision) {\n        var kilobyte = 1024,\n            megabyte = kilobyte * 1024,\n            gigabyte = megabyte * 1024,\n            terabyte = gigabyte * 1024,\n            returnVal = bytes;\n\n        if ((bytes >= 0) && (bytes < kilobyte)) {\n            returnVal = bytes + " B";\n        } else if (bytes < megabyte) {\n            returnVal = (bytes / kilobyte).toFixed(precision) + " KB";\n        } else if (bytes < gigabyte) {\n            returnVal = (bytes / megabyte).toFixed(precision) + " MB";\n        } else if (bytes < terabyte) {\n            returnVal = (bytes / gigabyte).toFixed(precision) + " GB";\n        } else if (bytes >= terabyte) {\n            return (bytes / terabyte).toFixed(precision) + " TB";\n        }\n\n        return returnVal;\n    }\n\n    /**\n     * Truncate text to specified length.\n     * @param {string} str Text to be truncated.\n     * @param {number} len Length to which text should be truncated\n     * @return {?string} Returns truncated text only if it was changed\n     */\n    function truncate(str, len) {\n        // Truncate text to specified length\n        if (str.length > len) {\n            str = str.substr(0, len);\n\n            // To prevent awkwardly truncating in the middle of a word,\n            // attempt to truncate at the end of the last whole word\n            var lastSpaceChar = str.lastIndexOf(" ");\n            if (lastSpaceChar < len && lastSpaceChar > -1) {\n                str = str.substr(0, lastSpaceChar);\n            }\n            return str;\n        }\n    }\n\n    /**\n     * Computes a 32bit hash from the given string\n     * Taken from http://stackoverflow.com/questions/7616461/generate-a-hash-from-string-in-javascript-jquery\n     * @CC wiki attribution: esmiralha\n     * @param   {string}   str The string for which hash is to be computed\n     * @return {number} The 32-bit hash\n     */\n    function hashCode(str) {\n        var hash = 0, i, chr, len;\n        if (str.length === 0) {\n            return hash;\n        }\n        for (i = 0, len = str.length; i < len; i++) {\n            chr   = str.charCodeAt(i);\n            hash  = ((hash << 5) - hash) + chr;\n            hash |= 0; // Convert to 32bit integer\n        }\n        return hash;\n    }\n\n    // Define public API\n    exports.format              = format;\n    exports.regexEscape         = regexEscape;\n    exports.jQueryIdEscape      = jQueryIdEscape;\n    exports.getLines            = getLines;\n    exports.offsetToLineNum     = offsetToLineNum;\n    exports.urlSort             = urlSort;\n    exports.breakableUrl        = breakableUrl;\n    exports.startsWith          = startsWith;\n    exports.endsWith            = endsWith;\n    exports.prettyPrintBytes    = prettyPrintBytes;\n    exports.truncate            = truncate;\n    exports.hashCode            = hashCode;\n});\n\n//# sourceURL=/utils/StringUtils.js'),eval('/*\n * Copyright (c) 2012 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */\n/*global define, brackets */\n\n/**\n * This is a collection of utility functions for gathering performance data.\n */\ndefine(\'utils/PerfUtils\',[\'require\',\'exports\',\'module\',\'thirdparty/lodash\',\'utils/StringUtils\',\'utils/Global\'],function (require, exports, module) {\n    "use strict";\n\n    var _            = require("thirdparty/lodash"),\n        StringUtils  = require("utils/StringUtils");\n\n    // make sure the global brackets variable is loaded\n    require("utils/Global");\n\n    /**\n     * Flag to enable/disable performance data gathering. Default is true (enabled)\n     * @type {boolean} enabled\n     */\n    var enabled = brackets && !!brackets.app.getElapsedMilliseconds;\n\n    /**\n     * Peformance data is stored in this hash object. The key is the name of the\n     * test (passed to markStart/addMeasurement), and the value is the time, in\n     * milliseconds, that it took to run the test. If multiple runs of the same test\n     * are made, the value is an Array with each run stored as an entry in the Array.\n     */\n    var perfData = {};\n\n    /**\n     * Active tests. This is a hash of all tests that have had markStart() called,\n     * but have not yet had addMeasurement() called.\n     */\n    var activeTests = {};\n\n    /**\n     * Updatable tests. This is a hash of all tests that have had markStart() called,\n     * and have had updateMeasurement() called. Caller must explicitly remove tests\n     * from this list using finalizeMeasurement()\n     */\n    var updatableTests = {};\n\n    /**\n     * @private\n     * Keeps the track of measurements sequence number for re-entrant sequences with\n     * the same name currently running. Entries are created and deleted as needed.\n     */\n    var _reentTests = {};\n\n    /**\n     * @private\n     * A unique key to log performance data\n     *\n     * @param {(string|undefined)} id Unique ID for this measurement name\n     * @param {!string} name A short name for this measurement\n     * @param {?number} reent Sequence identifier for parallel tests of the same name\n     */\n    function PerfMeasurement(id, name, reent) {\n        this.name = name;\n        this.reent = reent;\n        if (id) {\n            this.id = id;\n        } else {\n            this.id = (reent) ? "[reent " + this.reent + "] " + name : name;\n        }\n    }\n\n    /**\n     * Override toString() to allow using PerfMeasurement as an array key without\n     * explicit conversion.\n     */\n    PerfMeasurement.prototype.toString = function () {\n        return this.name;\n    };\n\n    /**\n     * Create a new PerfMeasurement key. Adds itself to the module export.\n     * Can be accessed on the module, e.g. PerfUtils.MY_PERF_KEY.\n     *\n     * @param {!string} id Unique ID for this measurement name\n     * @param {!name} name A short name for this measurement\n     */\n    function createPerfMeasurement(id, name) {\n        var pm = new PerfMeasurement(id, name);\n        exports[id] = pm;\n\n        return pm;\n    }\n\n    /**\n     * @private\n     * Generates PerfMeasurements based on the name or array of names.\n     */\n    function _generatePerfMeasurements(name) {\n        // always convert it to array so that the rest of the routines could rely on it\n        var id = (!Array.isArray(name)) ? [name] : name;\n        // generate unique identifiers for each name\n        var i;\n        for (i = 0; i < id.length; i++) {\n            if (!(id[i] instanceof PerfMeasurement)) {\n                if (_reentTests[id[i]] === undefined) {\n                    _reentTests[id[i]] = 0;\n                } else {\n                    _reentTests[id[i]]++;\n                }\n                id[i] = new PerfMeasurement(undefined, id[i], _reentTests[id[i]]);\n            }\n        }\n        return id;\n    }\n\n    /**\n     * @private\n     * Helper function for markStart()\n     *\n     * @param {Object} id  Timer id.\n     * @param {number} time  Timer start time.\n     */\n    function _markStart(id, time) {\n        if (activeTests[id.id]) {\n            console.error("Recursive tests with the same id are not supported. Timer id: " + id.id);\n        }\n\n        activeTests[id.id] = { startTime: time };\n    }\n\n    /**\n     * Start a new named timer. The name should be as descriptive as possible, since\n     * this name will appear as an entry in the performance report.\n     * For example: "Open file: /Users/brackets/src/ProjectManager.js"\n     *\n     * Multiple timers can be opened simultaneously.\n     *\n     * Returns an opaque set of timer ids which can be stored and used for calling\n     * addMeasurement(). Since name is often creating via concatenating strings this\n     * return value allows clients to construct the name once.\n     *\n     * @param {(string|Array.<string>)} name  Single name or an Array of names.\n     * @return {(Object|Array.<Object>)} Opaque timer id or array of timer ids.\n     */\n    function markStart(name) {\n        if (!enabled) {\n            return;\n        }\n\n        var time = brackets.app.getElapsedMilliseconds();\n        var id = _generatePerfMeasurements(name);\n        var i;\n\n        for (i = 0; i < id.length; i++) {\n            _markStart(id[i], time);\n        }\n        return id.length > 1 ? id : id[0];\n    }\n\n    /**\n     * Stop a timer and add its measurements to the performance data.\n     *\n     * Multiple measurements can be stored for any given name. If there are\n     * multiple values for a name, they are stored in an Array.\n     *\n     * If markStart() was not called for the specified timer, the\n     * measured time is relative to app startup.\n     *\n     * @param {Object} id  Timer id.\n     */\n    function addMeasurement(id) {\n        if (!enabled) {\n            return;\n        }\n\n        if (!(id instanceof PerfMeasurement)) {\n            id = new PerfMeasurement(id, id);\n        }\n\n        var elapsedTime = brackets.app.getElapsedMilliseconds();\n\n        if (activeTests[id.id]) {\n            elapsedTime -= activeTests[id.id].startTime;\n            delete activeTests[id.id];\n        }\n\n        if (perfData[id]) {\n            // We have existing data, add to it\n            if (Array.isArray(perfData[id])) {\n                perfData[id].push(elapsedTime);\n            } else {\n                // Current data is a number, convert to Array\n                perfData[id] = [perfData[id], elapsedTime];\n            }\n        } else {\n            perfData[id] = elapsedTime;\n        }\n\n        if (id.reent !== undefined) {\n            if (_reentTests[id] === 0) {\n                delete _reentTests[id];\n            } else {\n                _reentTests[id]--;\n            }\n        }\n\n    }\n\n    /**\n     * This function is similar to addMeasurement(), but it allows timing the\n     * *last* event, when you don\'t know which event will be the last one.\n     *\n     * Tests that are in the activeTests list, have not yet been added, so add\n     * measurements to the performance data, and move test to updatableTests list.\n     * A test is moved to the updatable list so that it no longer passes isActive().\n     *\n     * Tests that are already in the updatableTests list are updated.\n     *\n     * Caller must explicitly remove test from the updatableTests list using\n     * finalizeMeasurement().\n     *\n     * If markStart() was not called for the specified timer, there is no way to\n     * determine if this is the first or subsequent call, so the measurement is\n     * not updatable, and it is handled in addMeasurement().\n     *\n     * @param {Object} id  Timer id.\n     */\n    function updateMeasurement(id) {\n        var elapsedTime = brackets.app.getElapsedMilliseconds();\n\n        if (updatableTests[id.id]) {\n            // update existing measurement\n            elapsedTime -= updatableTests[id].startTime;\n\n            // update\n            if (perfData[id] && Array.isArray(perfData[id])) {\n                // We have existing data and it\'s an array, so update the last entry\n                perfData[id][perfData[id].length - 1] = elapsedTime;\n            } else {\n                // No current data or a single entry, so set/update it\n                perfData[id] = elapsedTime;\n            }\n\n        } else {\n            // not yet in updatable list\n\n            if (activeTests[id.id]) {\n                // save startTime in updatable list before addMeasurement() deletes it\n                updatableTests[id.id] = { startTime: activeTests[id.id].startTime };\n            }\n\n            // let addMeasurement() handle the initial case\n            addMeasurement(id);\n        }\n    }\n\n    /**\n     * Remove timer from lists so next action starts a new measurement\n     *\n     * updateMeasurement may not have been called, so timer may be\n     * in either or neither list, but should never be in both.\n     *\n     * @param {Object} id  Timer id.\n     */\n    function finalizeMeasurement(id) {\n        if (activeTests[id.id]) {\n            delete activeTests[id.id];\n        }\n\n        if (updatableTests[id.id]) {\n            delete updatableTests[id.id];\n        }\n    }\n\n    /**\n     * Returns whether a timer is active or not, where "active" means that\n     * timer has been started with addMark(), but has not been added to perfdata\n     * with addMeasurement().\n     *\n     * @param {Object} id  Timer id.\n     * @return {boolean} Whether a timer is active or not.\n     */\n    function isActive(id) {\n        return (activeTests[id.id]) ? true : false;\n    }\n\n    /**\n     * return single value, or comma separated values for an array or return aggregated values with\n     * <min value, average, max value, standard deviation>\n     * @param   {Array}    entry          An array or a single value\n     * @param   {Boolean} aggregateStats If set, the returned value will be aggregated in the form -\n     *                                   <min(avg)max[standard deviation]>\n     * @return {String}   a single value, or comma separated values in an array or\n     *                     <min(avg)max[standard deviation]> if aggregateStats is set\n     */\n    function getValueAsString(entry, aggregateStats) {\n        if (!Array.isArray(entry)) {\n            return entry;\n        }\n\n        if (aggregateStats) {\n            var sum = 0,\n                avg,\n                min = _.min(entry),\n                max = _.max(entry),\n                sd,\n                variationSum = 0;\n\n            entry.forEach(function (value) {\n                sum += value;\n            });\n            avg = Math.round(sum / entry.length);\n            entry.forEach(function (value) {\n                variationSum += Math.pow(value - avg, 2);\n            });\n            sd = Math.round(Math.sqrt(variationSum / entry.length));\n            return min + "(" + avg + ")" + max + "[" + sd + "]";\n        } else {\n            return entry.join(", ");\n        }\n    }\n\n    /**\n     * Returns the performance data as a tab delimited string\n     * @return {string}\n     */\n    function getDelimitedPerfData() {\n        var result = "";\n        _.forEach(perfData, function (entry, testName) {\n            result += getValueAsString(entry) + "\\t" + testName + "\\n";\n        });\n\n        return result;\n    }\n\n    /**\n     * Returns the measured value for the given measurement name.\n     * @param {Object} id The measurement to retreive.\n     */\n    function getData(id) {\n        if (!id) {\n            return perfData;\n        }\n\n        return perfData[id];\n    }\n\n    /**\n     * Returns the Performance metrics to be logged for health report\n     * @return {Object} An object with the health data logs to be sent\n     */\n    function getHealthReport() {\n        var healthReport = {\n            projectLoadTimes : "",\n            fileOpenTimes : ""\n        };\n\n        _.forEach(perfData, function (entry, testName) {\n            if (StringUtils.startsWith(testName, "Application Startup")) {\n                healthReport.AppStartupTime = getValueAsString(entry);\n            } else if (StringUtils.startsWith(testName, "brackets module dependencies resolved")) {\n                healthReport.ModuleDepsResolved = getValueAsString(entry);\n            } else if (StringUtils.startsWith(testName, "Load Project")) {\n                healthReport.projectLoadTimes += ":" + getValueAsString(entry, true);\n            } else if (StringUtils.startsWith(testName, "Open File")) {\n                healthReport.fileOpenTimes += ":" + getValueAsString(entry, true);\n            }\n        });\n\n        return healthReport;\n    }\n\n    function searchData(regExp) {\n        var keys = Object.keys(perfData).filter(function (key) {\n            return regExp.test(key);\n        });\n\n        var datas = [];\n\n        keys.forEach(function (key) {\n            datas.push(perfData[key]);\n        });\n\n        return datas;\n    }\n\n    /**\n     * Clear all logs including metric data and active tests.\n     */\n    function clear() {\n        perfData = {};\n        activeTests = {};\n        updatableTests = {};\n        _reentTests = {};\n    }\n\n    // create performance measurement constants\n    createPerfMeasurement("INLINE_WIDGET_OPEN", "Open inline editor or docs");\n    createPerfMeasurement("INLINE_WIDGET_CLOSE", "Close inline editor or docs");\n\n    // extensions may create additional measurement constants during their lifecycle\n\n    exports.addMeasurement          = addMeasurement;\n    exports.finalizeMeasurement     = finalizeMeasurement;\n    exports.isActive                = isActive;\n    exports.markStart               = markStart;\n    exports.getData                 = getData;\n    exports.searchData              = searchData;\n    exports.updateMeasurement       = updateMeasurement;\n    exports.getDelimitedPerfData    = getDelimitedPerfData;\n    exports.createPerfMeasurement   = createPerfMeasurement;\n    exports.clear                   = clear;\n    exports.getHealthReport         = getHealthReport;\n});\n\n//# sourceURL=/utils/PerfUtils.js'),
eval('/**\n * @license RequireJS i18n 2.0.2 Copyright (c) 2010-2012, The Dojo Foundation All Rights Reserved.\n * Available via the MIT or new BSD license.\n * see: http://github.com/requirejs/i18n for details\n */\n/*jslint regexp: true */\n/*global require: false, navigator: false, define: false */\n\n/**\n * This plugin handles i18n! prefixed modules. It does the following:\n *\n * 1) A regular module can have a dependency on an i18n bundle, but the regular\n * module does not want to specify what locale to load. So it just specifies\n * the top-level bundle, like "i18n!nls/colors".\n *\n * This plugin will load the i18n bundle at nls/colors, see that it is a root/master\n * bundle since it does not have a locale in its name. It will then try to find\n * the best match locale available in that master bundle, then request all the\n * locale pieces for that best match locale. For instance, if the locale is "en-us",\n * then the plugin will ask for the "en-us", "en" and "root" bundles to be loaded\n * (but only if they are specified on the master bundle).\n *\n * Once all the bundles for the locale pieces load, then it mixes in all those\n * locale pieces into each other, then finally sets the context.defined value\n * for the nls/colors bundle to be that mixed in locale.\n *\n * 2) A regular module specifies a specific locale to load. For instance,\n * i18n!nls/fr-fr/colors. In this case, the plugin needs to load the master bundle\n * first, at nls/colors, then figure out what the best match locale is for fr-fr,\n * since maybe only fr or just root is defined for that locale. Once that best\n * fit is found, all of its locale pieces need to have their bundles loaded.\n *\n * Once all the bundles for the locale pieces load, then it mixes in all those\n * locale pieces into each other, then finally sets the context.defined value\n * for the nls/fr-fr/colors bundle to be that mixed in locale.\n */\n(function () {\n    \'use strict\';\n\n    //regexp for reconstructing the master bundle name from parts of the regexp match\n    //nlsRegExp.exec("foo/bar/baz/nls/en-ca/foo") gives:\n    //["foo/bar/baz/nls/en-ca/foo", "foo/bar/baz/nls/", "/", "/", "en-ca", "foo"]\n    //nlsRegExp.exec("foo/bar/baz/nls/foo") gives:\n    //["foo/bar/baz/nls/foo", "foo/bar/baz/nls/", "/", "/", "foo", ""]\n    //so, if match[5] is blank, it means this is the top bundle definition.\n    var nlsRegExp = /(^.*(^|\\/)nls(\\/|$))([^\\/]*)\\/?([^\\/]*)/;\n\n    //Helper function to avoid repeating code. Lots of arguments in the\n    //desire to stay functional and support RequireJS contexts without having\n    //to know about the RequireJS contexts.\n    function addPart(locale, master, needed, toLoad, prefix, suffix) {\n        if (master[locale]) {\n            needed.push(locale);\n            if (master[locale] === true || master[locale] === 1) {\n                toLoad.push(prefix + locale + \'/\' + suffix);\n            }\n        }\n    }\n\n    function addIfExists(req, locale, toLoad, prefix, suffix) {\n        var fullName = prefix + locale + \'/\' + suffix;\n        if (require._fileExists(req.toUrl(fullName + \'.js\'))) {\n            toLoad.push(fullName);\n        }\n    }\n\n    /**\n     * Simple function to mix in properties from source into target,\n     * but only if target does not already have a property of the same name.\n     * This is not robust in IE for transferring methods that match\n     * Object.prototype names, but the uses of mixin here seem unlikely to\n     * trigger a problem related to that.\n     */\n    function mixin(target, source, force) {\n        var prop;\n        for (prop in source) {\n            if (source.hasOwnProperty(prop) && (!target.hasOwnProperty(prop) || force)) {\n                target[prop] = source[prop];\n            } else if (typeof source[prop] === \'object\') {\n                mixin(target[prop], source[prop], force);\n            }\n        }\n    }\n\n    define(\'i18n\',[\'module\'], function (module) {\n        var masterConfig = module.config ? module.config() : {};\n\n        return {\n            version: \'2.0.1+\',\n            /**\n             * Called when a dependency needs to be loaded.\n             */\n            load: function (name, req, onLoad, config) {\n                config = config || {};\n\n                if (config.locale) {\n                    masterConfig.locale = config.locale;\n                }\n\n                var masterName,\n                    match = nlsRegExp.exec(name),\n                    prefix = match[1],\n                    locale = match[4],\n                    suffix = match[5],\n                    parts = locale.split("-"),\n                    toLoad = [],\n                    value = {},\n                    i, part, current = "";\n\n                //If match[5] is blank, it means this is the top bundle definition,\n                //so it does not have to be handled. Locale-specific requests\n                //will have a match[4] value but no match[5]\n                if (match[5]) {\n                    //locale-specific bundle\n                    prefix = match[1];\n                    masterName = prefix + suffix;\n                } else {\n                    //Top-level bundle.\n                    masterName = name;\n                    suffix = match[4];\n                    locale = masterConfig.locale;\n                    if (!locale) {\n                        locale = masterConfig.locale =\n                            typeof navigator === "undefined" ? "root" :\n                            (navigator.language ||\n                             navigator.userLanguage || "root").toLowerCase();\n                    }\n                    parts = locale.split("-");\n                }\n\n                if (config.isBuild) {\n                    //Check for existence of all locale possible files and\n                    //require them if exist.\n                    toLoad.push(masterName);\n                    addIfExists(req, "root", toLoad, prefix, suffix);\n                    for (i = 0; i < parts.length; i++) {\n                        part = parts[i];\n                        current += (current ? "-" : "") + part;\n                        addIfExists(req, current, toLoad, prefix, suffix);\n                    }\n\n                    req(toLoad, function () {\n                        onLoad();\n                    });\n                } else {\n                    //First, fetch the master bundle, it knows what locales are available.\n                    req([masterName], function (master) {\n                        //Figure out the best fit\n                        var needed = [],\n                            part;\n\n                        //Always allow for root, then do the rest of the locale parts.\n                        addPart("root", master, needed, toLoad, prefix, suffix);\n                        for (i = 0; i < parts.length; i++) {\n                            part = parts[i];\n                            current += (current ? "-" : "") + part;\n                            addPart(current, master, needed, toLoad, prefix, suffix);\n                        }\n\n                        //Load all the parts missing.\n                        req(toLoad, function () {\n                            var i, partBundle, part;\n                            for (i = needed.length - 1; i > -1 && needed[i]; i--) {\n                                part = needed[i];\n                                partBundle = master[part];\n                                if (partBundle === true || partBundle === 1) {\n                                    partBundle = req(prefix + part + \'/\' + suffix);\n                                }\n                                mixin(value, partBundle);\n                            }\n\n                            //All done, notify the loader.\n                            onLoad(value);\n                        });\n                    });\n                }\n            }\n        };\n    });\n}());\n\n//# sourceURL=/thirdparty/i18n/i18n.js'),eval('/*\n * Copyright (c) 2012 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */\n/*global define */\n\ndefine(\'nls/strings\',[\'require\',\'exports\',\'module\'],function (require, exports, module) {\n\n    "use strict";\n\n    // Code that needs to display user strings should call require("strings") to load\n    // src/strings.js. This file will dynamically load strings.js for the specified brackets.locale.\n    //\n    // See the README.md file in this folder for information on how to add a new translation for\n    // another language or locale.\n    //\n    // TODO: dynamically populate the local prefix list below?\n    module.exports = {\n        root: true,\n        "cs": true,\n        "da": true,\n        "de": true,\n        "el": true,\n        "en-gb": true,\n        "es": true,\n        "fa-ir": true,\n        "fi": true,\n        "fr": true,\n        "gl": true,\n        "hr": true,\n        "hu": true,\n        "id": true,\n        "it": true,\n        "ja": true,\n        "ko": true,\n        "nb": true,\n        "nl": true,\n        "pl": true,\n        "pt-br": true,\n        "pt-pt": true,\n        "ro": true,\n        "ru": true,\n        "sk": true,\n        "sr": true,\n        "sv": true,\n        "tr": true,\n        "uk": true,\n        "zh-cn": true,\n        "zh-tw": true\n    };\n});\n\n//# sourceURL=/nls/strings.js'),eval('/*\n * Copyright (c) 2012 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */\n/*global define */\n\ndefine(\'nls/root/strings\',{\n\n    /**\n     * Errors\n     */\n\n    // General file io error strings\n    "GENERIC_ERROR"                     : "(error {0})",\n    "NOT_FOUND_ERR"                     : "The file/directory could not be found.",\n    "NOT_READABLE_ERR"                  : "The file/directory could not be read.",\n    "EXCEEDS_MAX_FILE_SIZE"             : "Files larger than {0} MB cannot be opened in {APP_NAME}.",\n    "NO_MODIFICATION_ALLOWED_ERR"       : "The target directory cannot be modified.",\n    "NO_MODIFICATION_ALLOWED_ERR_FILE"  : "The permissions do not allow you to make modifications.",\n    "CONTENTS_MODIFIED_ERR"             : "The file has been modified outside of {APP_NAME}.",\n    "UNSUPPORTED_ENCODING_ERR"          : "{APP_NAME} currently only supports UTF-8 encoded text files.",\n    "FILE_EXISTS_ERR"                   : "The file or directory already exists.",\n    "FILE"                              : "file",\n    "FILE_TITLE"                        : "File",\n    "DIRECTORY"                         : "directory",\n    "DIRECTORY_TITLE"                   : "Directory",\n    "DIRECTORY_NAMES_LEDE"              : "Directory names",\n    "FILENAMES_LEDE"                    : "Filenames",\n    "FILENAME"                          : "Filename",\n    "DIRECTORY_NAME"                    : "Directory Name",\n\n    // Project error strings\n    "ERROR_LOADING_PROJECT"             : "Error Loading Project",\n    "OPEN_DIALOG_ERROR"                 : "An error occurred when showing the open file dialog. (error {0})",\n    "REQUEST_NATIVE_FILE_SYSTEM_ERROR"  : "An error occurred when trying to load the directory <span class=\'dialog-filename\'>{0}</span>. (error {1})",\n    "READ_DIRECTORY_ENTRIES_ERROR"      : "An error occurred when reading the contents of the directory <span class=\'dialog-filename\'>{0}</span>. (error {1})",\n\n    // File open/save error string\n    "ERROR_OPENING_FILE_TITLE"          : "Error Opening File",\n    "ERROR_OPENING_FILE"                : "An error occurred when trying to open the file <span class=\'dialog-filename\'>{0}</span>. {1}",\n    "ERROR_OPENING_FILES"               : "An error occurred when trying to open the following files:",\n    "ERROR_RELOADING_FILE_TITLE"        : "Error Reloading Changes From Disk",\n    "ERROR_RELOADING_FILE"              : "An error occurred when trying to reload the file <span class=\'dialog-filename\'>{0}</span>. {1}",\n    "ERROR_SAVING_FILE_TITLE"           : "Error Saving File",\n    "ERROR_SAVING_FILE"                 : "An error occurred when trying to save the file <span class=\'dialog-filename\'>{0}</span>. {1}",\n    "ERROR_RENAMING_FILE_TITLE"         : "Error Renaming {0}",\n    "ERROR_RENAMING_FILE"               : "An error occurred when trying to rename the {2} <span class=\'dialog-filename\'>{0}</span>. {1}",\n    "ERROR_DELETING_FILE_TITLE"         : "Error Deleting {0}",\n    "ERROR_DELETING_FILE"               : "An error occurred when trying to delete the {2} <span class=\'dialog-filename\'>{0}</span>. {1}",\n    "INVALID_FILENAME_TITLE"            : "Invalid {0}",\n    "INVALID_FILENAME_MESSAGE"          : "{0} cannot use any system reserved words, end with dots (.) or use any of the following characters: <code class=\'emphasized\'>{1}</code>",\n    "ENTRY_WITH_SAME_NAME_EXISTS"       : "A file or directory with the name <span class=\'dialog-filename\'>{0}</span> already exists.",\n    "ERROR_CREATING_FILE_TITLE"         : "Error Creating {0}",\n    "ERROR_CREATING_FILE"               : "An error occurred when trying to create the {0} <span class=\'dialog-filename\'>{1}</span>. {2}",\n    "ERROR_MIXED_DRAGDROP"              : "Cannot open a folder at the same time as opening other files.",\n\n    // User key map error strings\n    "ERROR_KEYMAP_TITLE"                : "Error Reading User Key Map",\n    "ERROR_KEYMAP_CORRUPT"              : "Your key map file is not valid JSON. The file will be opened so that you can correct the format.",\n    "ERROR_LOADING_KEYMAP"              : "Your key map file is not a valid UTF-8 encoded text file and cannot be loaded",\n    "ERROR_RESTRICTED_COMMANDS"         : "You cannot reassign shortcuts to these commands: {0}",\n    "ERROR_RESTRICTED_SHORTCUTS"        : "You cannot reassign these shortcuts: {0}",\n    "ERROR_MULTIPLE_SHORTCUTS"          : "You are reassigning multiple shortcuts to these commands: {0}",\n    "ERROR_DUPLICATE_SHORTCUTS"         : "You have multiple bindings of these shortcuts: {0}",\n    "ERROR_INVALID_SHORTCUTS"           : "These shortcuts are invalid: {0}",\n    "ERROR_NONEXISTENT_COMMANDS"        : "You are assigning shortcuts to nonexistent commands: {0}",\n\n    // Application preferences corrupt error strings\n    "ERROR_PREFS_CORRUPT_TITLE"         : "Error Reading Preferences",\n    "ERROR_PREFS_CORRUPT"               : "Your preferences file is not valid JSON. The file will be opened so that you can correct the format. You will need to restart {APP_NAME} for the changes to take effect.",\n    "ERROR_PROJ_PREFS_CORRUPT"          : "Your project preferences file is not valid JSON. The file will be opened so that you can correct the format. You will need to reload the project for the changes to take effect.",\n\n    // Application error strings\n    "ERROR_IN_BROWSER_TITLE"            : "Oops! {APP_NAME} Doesn\'t Run in Browsers Yet.",\n    "ERROR_IN_BROWSER"                  : "{APP_NAME} is built in HTML, but right now it runs as a desktop app so you can use it to edit local files. Please use the application shell in the <b>github.com/adobe/brackets-shell</b> repo to run {APP_NAME}.",\n\n    // ProjectManager max files error string\n    "ERROR_MAX_FILES_TITLE"             : "Error Indexing Files",\n    "ERROR_MAX_FILES"                   : "This project contains more than 30,000 files. Features that operate across multiple files may be disabled or behave as if the project is empty. <a href=\'https://github.com/adobe/brackets/wiki/Large-Projects\'>Read more about working with large projects</a>.",\n\n    // Live Preview error strings\n    "ERROR_LAUNCHING_BROWSER_TITLE"     : "Error Launching Browser",\n    "ERROR_CANT_FIND_CHROME"            : "The Google Chrome browser could not be found. Please make sure it is installed.",\n    "ERROR_LAUNCHING_BROWSER"           : "An error occurred when launching the browser. (error {0})",\n\n    "LIVE_DEVELOPMENT_ERROR_TITLE"      : "Live Preview Error",\n    "LIVE_DEVELOPMENT_RELAUNCH_TITLE"   : "Connecting to Browser",\n    "LIVE_DEVELOPMENT_ERROR_MESSAGE"    : "In order for Live Preview to connect, Chrome needs to be relaunched with remote debugging enabled.<br /><br />Would you like to relaunch Chrome and enable remote debugging?<br /><br />",\n    "LIVE_DEV_LOADING_ERROR_MESSAGE"    : "Unable to load Live Preview page.",\n    "LIVE_DEV_NEED_HTML_MESSAGE"        : "Open an HTML file or make sure there is an index.html file in your project in order to launch live preview.",\n    "LIVE_DEV_NEED_BASEURL_MESSAGE"     : "To launch live preview with a server-side file, you need to specify a Base URL for this project.",\n    "LIVE_DEV_SERVER_NOT_READY_MESSAGE" : "Error starting up the HTTP server for live preview files. Please try again.",\n    "LIVE_DEVELOPMENT_INFO_TITLE"       : "Welcome to Live Preview!",\n    "LIVE_DEVELOPMENT_INFO_MESSAGE"     : "Live Preview connects {APP_NAME} to your browser. It launches a preview of your HTML file in the browser, then updates the preview instantly as you edit your code.<br /><br />In this early version of {APP_NAME}, Live Preview only works with <strong>Google Chrome</strong> and updates live as you edit <strong>CSS or HTML files</strong>. Changes to JavaScript files are automatically reloaded when you save.<br /><br />(You\'ll only see this message once.)",\n    "LIVE_DEVELOPMENT_TROUBLESHOOTING"  : "For more information, see <a href=\'{0}\' title=\'{0}\'>Troubleshooting Live Preview connection errors</a>.",\n\n    "LIVE_DEV_STATUS_TIP_NOT_CONNECTED" : "Live Preview",\n    "LIVE_DEV_STATUS_TIP_PROGRESS1"     : "Live Preview: Connecting\\u2026",\n    "LIVE_DEV_STATUS_TIP_PROGRESS2"     : "Live Preview: Initializing\\u2026",\n    "LIVE_DEV_STATUS_TIP_CONNECTED"     : "Disconnect Live Preview",\n    "LIVE_DEV_STATUS_TIP_OUT_OF_SYNC"   : "Live Preview (save file to refresh)",\n    "LIVE_DEV_STATUS_TIP_SYNC_ERROR"    : "Live Preview (not updating due to syntax error)",\n\n    "LIVE_DEV_DETACHED_REPLACED_WITH_DEVTOOLS" : "Live Preview was canceled because the browser\'s developer tools were opened",\n    "LIVE_DEV_DETACHED_TARGET_CLOSED"          : "Live Preview was canceled because the page was closed in the browser",\n    "LIVE_DEV_NAVIGATED_AWAY"                  : "Live Preview was canceled because the browser navigated to a page that is not part of the current project",\n    "LIVE_DEV_CLOSED_UNKNOWN_REASON"           : "Live Preview was canceled for an unknown reason ({0})",\n\n    "SAVE_CLOSE_TITLE"                  : "Save Changes",\n    "SAVE_CLOSE_MESSAGE"                : "Do you want to save the changes you made in the document <span class=\'dialog-filename\'>{0}</span>?",\n    "SAVE_CLOSE_MULTI_MESSAGE"          : "Do you want to save your changes to the following files?",\n    "EXT_MODIFIED_TITLE"                : "External Changes",\n    "CONFIRM_FOLDER_DELETE_TITLE"       : "Confirm Delete",\n    "CONFIRM_FOLDER_DELETE"             : "Are you sure you want to delete the folder <span class=\'dialog-filename\'>{0}</span>?",\n    "FILE_DELETED_TITLE"                : "File Deleted",\n    "EXT_MODIFIED_WARNING"              : "<span class=\'dialog-filename\'>{0}</span> has been modified on disk outside of {APP_NAME}.<br /><br />Do you want to save the file and overwrite those changes?",\n    "EXT_MODIFIED_MESSAGE"              : "<span class=\'dialog-filename\'>{0}</span> has been modified on disk outside of {APP_NAME}, but also has unsaved changes in {APP_NAME}.<br /><br />Which version do you want to keep?",\n    "EXT_DELETED_MESSAGE"               : "<span class=\'dialog-filename\'>{0}</span> has been deleted on disk outside of {APP_NAME}, but has unsaved changes in {APP_NAME}.<br /><br />Do you want to keep your changes?",\n\n    // Generic dialog/button labels\n    "DONE"                              : "Done",\n    "OK"                                : "OK",\n    "CANCEL"                            : "Cancel",\n    "DONT_SAVE"                         : "Don\'t Save",\n    "SAVE"                              : "Save",\n    "SAVE_AS"                           : "Save As\\u2026",\n    "SAVE_AND_OVERWRITE"                : "Overwrite",\n    "DELETE"                            : "Delete",\n    "BUTTON_YES"                        : "Yes",\n    "BUTTON_NO"                         : "No",\n\n    // Find, Replace, Find in Files\n    "FIND_MATCH_INDEX"                  : "{0} of {1}",\n    "FIND_NO_RESULTS"                   : "No results",\n    "FIND_QUERY_PLACEHOLDER"            : "Find\\u2026",\n    "REPLACE_PLACEHOLDER"               : "Replace with\\u2026",\n    "BUTTON_REPLACE_ALL"                : "Batch\\u2026",\n    "BUTTON_REPLACE_ALL_IN_FILES"       : "Replace\\u2026",\n    "BUTTON_REPLACE"                    : "Replace",\n    "BUTTON_NEXT"                       : "\\u25B6",\n    "BUTTON_PREV"                       : "\\u25C0",\n    "BUTTON_NEXT_HINT"                  : "Next Match",\n    "BUTTON_PREV_HINT"                  : "Previous Match",\n    "BUTTON_CASESENSITIVE_HINT"         : "Match Case",\n    "BUTTON_REGEXP_HINT"                : "Regular Expression",\n    "REPLACE_WITHOUT_UNDO_WARNING_TITLE": "Replace Without Undo",\n    "REPLACE_WITHOUT_UNDO_WARNING"      : "Because more than {0} files need to be changed, {APP_NAME} will modify unopened files on disk.<br />You won\'t be able to undo replacements in those files.",\n    "BUTTON_REPLACE_WITHOUT_UNDO"       : "Replace Without Undo",\n\n    "OPEN_FILE"                         : "Open File",\n    "SAVE_FILE_AS"                      : "Save File",\n    "CHOOSE_FOLDER"                     : "Choose a folder",\n\n    "RELEASE_NOTES"                     : "Release Notes",\n    "NO_UPDATE_TITLE"                   : "You\'re Up to Date!",\n    "NO_UPDATE_MESSAGE"                 : "You are running the latest version of {APP_NAME}.",\n\n    // Find and Replace\n    "FIND_REPLACE_TITLE_LABEL"          : "Replace",\n    "FIND_REPLACE_TITLE_WITH"           : "with",\n    "FIND_TITLE_LABEL"                  : "Found",\n    "FIND_TITLE_SUMMARY"                : "&mdash; {0} {1} {2} in {3}",\n\n    // Find in Files\n    "FIND_NUM_FILES"                    : "{0} {1}",\n    "FIND_IN_FILES_SCOPED"              : "in <span class=\'dialog-filename\'>{0}</span>",\n    "FIND_IN_FILES_NO_SCOPE"            : "in project",\n    "FIND_IN_FILES_ZERO_FILES"          : "Filter excludes all files {0}",\n    "FIND_IN_FILES_FILE"                : "file",\n    "FIND_IN_FILES_FILES"               : "files",\n    "FIND_IN_FILES_MATCH"               : "match",\n    "FIND_IN_FILES_MATCHES"             : "matches",\n    "FIND_IN_FILES_MORE_THAN"           : "Over ",\n    "FIND_IN_FILES_PAGING"              : "{0}&mdash;{1}",\n    "FIND_IN_FILES_FILE_PATH"           : "<span class=\'dialog-filename\'>{0}</span> {2} <span class=\'dialog-path\'>{1}</span>", // We should use normal dashes on Windows instead of em dash eventually\n    "FIND_IN_FILES_EXPAND_COLLAPSE"     : "Ctrl/Cmd click to expand/collapse all",\n    "FIND_IN_FILES_INDEXING"            : "Indexing for Instant Search\\u2026",\n    "REPLACE_IN_FILES_ERRORS_TITLE"     : "Replace Errors",\n    "REPLACE_IN_FILES_ERRORS"           : "The following files weren\'t modified because they changed after the search or couldn\'t be written.",\n\n    "ERROR_FETCHING_UPDATE_INFO_TITLE"  : "Error Getting Update Info",\n    "ERROR_FETCHING_UPDATE_INFO_MSG"    : "There was a problem getting the latest update information from the server. Please make sure you are connected to the Internet and try again.",\n\n    // File exclusion filters\n    "NEW_FILE_FILTER"                   : "New Exclusion Set\\u2026",\n    "CLEAR_FILE_FILTER"                 : "Don\'t Exclude Files",\n    "NO_FILE_FILTER"                    : "No Files Excluded",\n    "EXCLUDE_FILE_FILTER"               : "Exclude {0}",\n    "EDIT_FILE_FILTER"                  : "Edit\\u2026",\n    "FILE_FILTER_DIALOG"                : "Edit Exclusion Set",\n    "FILE_FILTER_INSTRUCTIONS"          : "Exclude files and folders matching any of the following strings / substrings or <a href=\'{0}\' title=\'{0}\'>wildcards</a>. Enter each string on a new line.",\n    "FILTER_NAME_PLACEHOLDER"           : "Name this exclusion set (optional)",\n    "FILE_FILTER_CLIPPED_SUFFIX"        : "and {0} more",\n    "FILTER_COUNTING_FILES"             : "Counting files\\u2026",\n    "FILTER_FILE_COUNT"                 : "Allows {0} of {1} files {2}",\n    "FILTER_FILE_COUNT_ALL"             : "Allows all {0} files {1}",\n\n    // Quick Edit\n    "ERROR_QUICK_EDIT_PROVIDER_NOT_FOUND"   : "No Quick Edit available for current cursor position",\n    "ERROR_CSSQUICKEDIT_BETWEENCLASSES"     : "CSS Quick Edit: place cursor on a single class name",\n    "ERROR_CSSQUICKEDIT_CLASSNOTFOUND"      : "CSS Quick Edit: incomplete class attribute",\n    "ERROR_CSSQUICKEDIT_IDNOTFOUND"         : "CSS Quick Edit: incomplete id attribute",\n    "ERROR_CSSQUICKEDIT_UNSUPPORTEDATTR"    : "CSS Quick Edit: place cursor in tag, class, or id",\n    "ERROR_TIMINGQUICKEDIT_INVALIDSYNTAX"   : "CSS Timing Function Quick Edit: invalid syntax",\n    "ERROR_JSQUICKEDIT_FUNCTIONNOTFOUND"    : "JS Quick Edit: place cursor in function name",\n\n    // Quick Docs\n    "ERROR_QUICK_DOCS_PROVIDER_NOT_FOUND"   : "No Quick Docs available for current cursor position",\n\n    /**\n     * ProjectManager\n     */\n    "PROJECT_LOADING"   : "Loading\\u2026",\n    "UNTITLED"          : "Untitled",\n    "WORKING_FILES"     : "Working Files",\n\n    /**\n     * MainViewManager\n     */\n    "TOP"               : "Top",\n    "BOTTOM"            : "Bottom",\n    "LEFT"              : "Left",\n    "RIGHT"             : "Right",\n\n    "CMD_SPLITVIEW_NONE"        : "No Split",\n    "CMD_SPLITVIEW_VERTICAL"    : "Vertical Split",\n    "CMD_SPLITVIEW_HORIZONTAL"  : "Horizontal Split",\n    "SPLITVIEW_MENU_TOOLTIP"    : "Split the editor vertically or horizontally",\n    "GEAR_MENU_TOOLTIP"         : "Configure Working Set",\n\n    "SPLITVIEW_INFO_TITLE"              : "Already Open",\n    "SPLITVIEW_MULTIPANE_WARNING"       : "The file is already open in another pane. {APP_NAME} will soon support opening the same file in more than one pane. Until then, the file will be shown in the pane it\'s already open in.<br /><br />(You\'ll only see this message once.)",\n\n    /**\n     * Keyboard modifiers and special key names\n     */\n    "KEYBOARD_CTRL"         : "Ctrl",\n    "KEYBOARD_SHIFT"        : "Shift",\n    "KEYBOARD_SPACE"        : "Space",\n    "KEYBOARD_PAGE_UP"      : "Page Up",\n    "KEYBOARD_PAGE_DOWN"    : "Page Down",\n    "KEYBOARD_HOME"         : "Home",\n    "KEYBOARD_END"          : "End",\n    "KEYBOARD_INSERT"       : "Insert",\n    "KEYBOARD_DELETE"       : "Delete",\n\n    /**\n     * StatusBar strings\n     */\n    "STATUSBAR_CURSOR_POSITION"             : "Line {0}, Column {1}",\n    "STATUSBAR_SELECTION_CH_SINGULAR"       : " \\u2014 Selected {0} column",\n    "STATUSBAR_SELECTION_CH_PLURAL"         : " \\u2014 Selected {0} columns",\n    "STATUSBAR_SELECTION_LINE_SINGULAR"     : " \\u2014 Selected {0} line",\n    "STATUSBAR_SELECTION_LINE_PLURAL"       : " \\u2014 Selected {0} lines",\n    "STATUSBAR_SELECTION_MULTIPLE"          : " \\u2014 {0} selections",\n    "STATUSBAR_INDENT_TOOLTIP_SPACES"       : "Click to switch indentation to spaces",\n    "STATUSBAR_INDENT_TOOLTIP_TABS"         : "Click to switch indentation to tabs",\n    "STATUSBAR_INDENT_SIZE_TOOLTIP_SPACES"  : "Click to change number of spaces used when indenting",\n    "STATUSBAR_INDENT_SIZE_TOOLTIP_TABS"    : "Click to change tab character width",\n    "STATUSBAR_SPACES"                      : "Spaces:",\n    "STATUSBAR_TAB_SIZE"                    : "Tab Size:",\n    "STATUSBAR_LINE_COUNT_SINGULAR"         : "\\u2014 {0} Line",\n    "STATUSBAR_LINE_COUNT_PLURAL"           : "\\u2014 {0} Lines",\n    "STATUSBAR_USER_EXTENSIONS_DISABLED"    : "Extensions Disabled",\n    "STATUSBAR_INSERT"                      : "INS",\n    "STATUSBAR_OVERWRITE"                   : "OVR",\n    "STATUSBAR_INSOVR_TOOLTIP"              : "Click to toggle cursor between Insert (INS) and Overwrite (OVR) modes",\n    "STATUSBAR_LANG_TOOLTIP"                : "Click to change file type",\n    "STATUSBAR_CODE_INSPECTION_TOOLTIP"     : "{0}. Click to toggle report panel.",\n    "STATUSBAR_DEFAULT_LANG"                : "(default)",\n    "STATUSBAR_SET_DEFAULT_LANG"            : "Set as Default for .{0} Files",\n\n    // CodeInspection: errors/warnings\n    "ERRORS_PANEL_TITLE_MULTIPLE"           : "{0} Problems",\n    "SINGLE_ERROR"                          : "1 {0} Problem",\n    "MULTIPLE_ERRORS"                       : "{1} {0} Problems",\n    "NO_ERRORS"                             : "No {0} problems found - good job!",\n    "NO_ERRORS_MULTIPLE_PROVIDER"           : "No problems found - good job!",\n    "LINT_DISABLED"                         : "Linting is disabled",\n    "NO_LINT_AVAILABLE"                     : "No linter available for {0}",\n    "NOTHING_TO_LINT"                       : "Nothing to lint",\n    "LINTER_TIMED_OUT"                      : "{0} has timed out after waiting for {1} ms",\n    "LINTER_FAILED"                         : "{0} terminated with error: {1}",\n\n    /**\n     * Command Name Constants\n     */\n\n    // File menu commands\n    "FILE_MENU"                           : "File",\n    "CMD_FILE_NEW_UNTITLED"               : "New",\n    "CMD_FILE_NEW"                        : "New File",\n    "CMD_FILE_NEW_FOLDER"                 : "New Folder",\n    "CMD_FILE_OPEN"                       : "Open\\u2026",\n    "CMD_ADD_TO_WORKING_SET"              : "Open To Working Set",\n    "CMD_OPEN_DROPPED_FILES"              : "Open Dropped Files",\n    "CMD_OPEN_FOLDER"                     : "Open Folder\\u2026",\n    "CMD_FILE_CLOSE"                      : "Close",\n    "CMD_FILE_CLOSE_ALL"                  : "Close All",\n    "CMD_FILE_CLOSE_LIST"                 : "Close List",\n    "CMD_FILE_CLOSE_OTHERS"               : "Close Others",\n    "CMD_FILE_CLOSE_ABOVE"                : "Close Others Above",\n    "CMD_FILE_CLOSE_BELOW"                : "Close Others Below",\n    "CMD_FILE_SAVE"                       : "Save",\n    "CMD_FILE_SAVE_ALL"                   : "Save All",\n    "CMD_FILE_SAVE_AS"                    : "Save As\\u2026",\n    "CMD_LIVE_FILE_PREVIEW"               : "Live Preview",\n    "CMD_TOGGLE_LIVE_PREVIEW_MB_MODE"     : "Enable Experimental Live Preview",\n    "CMD_RELOAD_LIVE_PREVIEW"             : "Force Reload Live Preview",\n    "CMD_PROJECT_SETTINGS"                : "Project Settings\\u2026",\n    "CMD_FILE_RENAME"                     : "Rename",\n    "CMD_FILE_DELETE"                     : "Delete",\n    "CMD_INSTALL_EXTENSION"               : "Install Extension\\u2026",\n    "CMD_EXTENSION_MANAGER"               : "Extension Manager\\u2026",\n    "CMD_FILE_REFRESH"                    : "Refresh File Tree",\n    "CMD_QUIT"                            : "Quit",\n    // Used in native File menu on Windows\n    "CMD_EXIT"                            : "Exit",\n\n    // Edit menu commands\n    "EDIT_MENU"                           : "Edit",\n    "CMD_UNDO"                            : "Undo",\n    "CMD_REDO"                            : "Redo",\n    "CMD_CUT"                             : "Cut",\n    "CMD_COPY"                            : "Copy",\n    "CMD_PASTE"                           : "Paste",\n    "CMD_SELECT_ALL"                      : "Select All",\n    "CMD_SELECT_LINE"                     : "Select Line",\n    "CMD_SPLIT_SEL_INTO_LINES"            : "Split Selection into Lines",\n    "CMD_ADD_CUR_TO_NEXT_LINE"            : "Add Cursor to Next Line",\n    "CMD_ADD_CUR_TO_PREV_LINE"            : "Add Cursor to Previous Line",\n    "CMD_INDENT"                          : "Indent",\n    "CMD_UNINDENT"                        : "Unindent",\n    "CMD_DUPLICATE"                       : "Duplicate",\n    "CMD_DELETE_LINES"                    : "Delete Line",\n    "CMD_COMMENT"                         : "Toggle Line Comment",\n    "CMD_BLOCK_COMMENT"                   : "Toggle Block Comment",\n    "CMD_LINE_UP"                         : "Move Line Up",\n    "CMD_LINE_DOWN"                       : "Move Line Down",\n    "CMD_OPEN_LINE_ABOVE"                 : "Open Line Above",\n    "CMD_OPEN_LINE_BELOW"                 : "Open Line Below",\n    "CMD_TOGGLE_CLOSE_BRACKETS"           : "Auto Close Braces",\n    "CMD_SHOW_CODE_HINTS"                 : "Show Code Hints",\n\n    // Search menu commands\n    "FIND_MENU"                           : "Find",\n    "CMD_FIND"                            : "Find",\n    "CMD_FIND_NEXT"                       : "Find Next",\n    "CMD_FIND_PREVIOUS"                   : "Find Previous",\n    "CMD_FIND_ALL_AND_SELECT"             : "Find All and Select",\n    "CMD_ADD_NEXT_MATCH"                  : "Add Next Match to Selection",\n    "CMD_SKIP_CURRENT_MATCH"              : "Skip and Add Next Match",\n    "CMD_FIND_IN_FILES"                   : "Find in Files",\n    "CMD_FIND_IN_SUBTREE"                 : "Find in\\u2026",\n    "CMD_REPLACE"                         : "Replace",\n    "CMD_REPLACE_IN_FILES"                : "Replace in Files",\n    "CMD_REPLACE_IN_SUBTREE"              : "Replace in\\u2026",\n\n    // View menu commands\n    "VIEW_MENU"                           : "View",\n    "CMD_HIDE_SIDEBAR"                    : "Hide Sidebar",\n    "CMD_SHOW_SIDEBAR"                    : "Show Sidebar",\n    "CMD_TOGGLE_SIDEBAR"                  : "Toggle Sidebar",\n    "CMD_TOGGLE_PANELS"                   : "Toggle Panels",\n    "CMD_TOGGLE_PURE_CODE"                : "No Distractions",\n    "CMD_INCREASE_FONT_SIZE"              : "Increase Font Size",\n    "CMD_DECREASE_FONT_SIZE"              : "Decrease Font Size",\n    "CMD_RESTORE_FONT_SIZE"               : "Restore Font Size",\n    "CMD_SCROLL_LINE_UP"                  : "Scroll Line Up",\n    "CMD_SCROLL_LINE_DOWN"                : "Scroll Line Down",\n    "CMD_TOGGLE_LINE_NUMBERS"             : "Line Numbers",\n    "CMD_TOGGLE_ACTIVE_LINE"              : "Highlight Active Line",\n    "CMD_TOGGLE_WORD_WRAP"                : "Word Wrap",\n    "CMD_LIVE_HIGHLIGHT"                  : "Live Preview Highlight",\n    "CMD_VIEW_TOGGLE_INSPECTION"          : "Lint Files on Save",\n    "CMD_WORKINGSET_SORT_BY_ADDED"        : "Sort by Added",\n    "CMD_WORKINGSET_SORT_BY_NAME"         : "Sort by Name",\n    "CMD_WORKINGSET_SORT_BY_TYPE"         : "Sort by Type",\n    "CMD_WORKING_SORT_TOGGLE_AUTO"        : "Automatic Sort",\n    "CMD_THEMES"                          : "Themes\\u2026",\n\n    // Navigate menu commands\n    "NAVIGATE_MENU"                       : "Navigate",\n    "CMD_QUICK_OPEN"                      : "Quick Open",\n    "CMD_GOTO_LINE"                       : "Go to Line",\n    "CMD_GOTO_DEFINITION"                 : "Quick Find Definition",\n    "CMD_GOTO_FIRST_PROBLEM"              : "Go to First Problem",\n    "CMD_TOGGLE_QUICK_EDIT"               : "Quick Edit",\n    "CMD_TOGGLE_QUICK_DOCS"               : "Quick Docs",\n    "CMD_QUICK_EDIT_PREV_MATCH"           : "Previous Match",\n    "CMD_QUICK_EDIT_NEXT_MATCH"           : "Next Match",\n    "CMD_CSS_QUICK_EDIT_NEW_RULE"         : "New Rule",\n    "CMD_NEXT_DOC"                        : "Next Document",\n    "CMD_PREV_DOC"                        : "Previous Document",\n    "CMD_NEXT_DOC_LIST_ORDER"             : "Next Document in List",\n    "CMD_PREV_DOC_LIST_ORDER"             : "Previous Document in List",\n    "CMD_SHOW_IN_TREE"                    : "Show in File Tree",\n    "CMD_SHOW_IN_EXPLORER"                : "Show in Explorer",\n    "CMD_SHOW_IN_FINDER"                  : "Show in Finder",\n    "CMD_SHOW_IN_OS"                      : "Show in OS",\n\n    // Help menu commands\n    "HELP_MENU"                           : "Help",\n    "CMD_CHECK_FOR_UPDATE"                : "Check for Updates",\n    "CMD_HOW_TO_USE_BRACKETS"             : "How to Use {APP_NAME}",\n    "CMD_SUPPORT"                         : "{APP_NAME} Support",\n    "CMD_SUGGEST"                         : "Suggest a Feature",\n    "CMD_RELEASE_NOTES"                   : "Release Notes",\n    "CMD_GET_INVOLVED"                    : "Get Involved",\n    "CMD_SHOW_EXTENSIONS_FOLDER"          : "Show Extensions Folder",\n    "CMD_HEALTH_DATA_STATISTICS"          : "Health Report",\n    "CMD_HOMEPAGE"                        : "{APP_TITLE} Homepage",\n    "CMD_TWITTER"                         : "{TWITTER_NAME} on Twitter",\n    "CMD_ABOUT"                           : "About {APP_TITLE}",\n    "CMD_OPEN_PREFERENCES"                : "Open Preferences File",\n    "CMD_OPEN_KEYMAP"                     : "Open User Key Map",\n\n    // Strings for main-view.html\n    "EXPERIMENTAL_BUILD"                   : "experimental build",\n    "RELEASE_BUILD"                        : "build",\n    "DEVELOPMENT_BUILD"                    : "development build",\n    "RELOAD_FROM_DISK"                     : "Reload from Disk",\n    "KEEP_CHANGES_IN_EDITOR"               : "Keep Changes in Editor",\n    "CLOSE_DONT_SAVE"                      : "Close (Don\'t Save)",\n    "RELAUNCH_CHROME"                      : "Relaunch Chrome",\n    "ABOUT"                                : "About",\n    "CLOSE"                                : "Close",\n    "ABOUT_TEXT_LINE1"                     : "Release {VERSION_MAJOR}.{VERSION_MINOR} {BUILD_TYPE} {VERSION}",\n    "ABOUT_TEXT_BUILD_TIMESTAMP"           : "build timestamp: ",\n    "ABOUT_TEXT_LINE3"                     : "Notices, terms and conditions pertaining to third party software are located at <a href=\'{ADOBE_THIRD_PARTY}\'>{ADOBE_THIRD_PARTY}</a> and incorporated by reference herein.",\n    "ABOUT_TEXT_LINE4"                     : "Documentation and source at <a href=\'https://github.com/adobe/brackets/\'>https://github.com/adobe/brackets/</a>",\n    "ABOUT_TEXT_LINE5"                     : "Made with \\u2764 and JavaScript by:",\n    "ABOUT_TEXT_LINE6"                     : "Lots of people (but we\'re having trouble loading that data right now).",\n    "ABOUT_TEXT_WEB_PLATFORM_DOCS"         : "Web Platform Docs and the Web Platform graphical logo are licensed under a Creative Commons Attribution license, <a href=\'{WEB_PLATFORM_DOCS_LICENSE}\'>CC-BY 3.0 Unported</a>.",\n    "UPDATE_NOTIFICATION_TOOLTIP"          : "There\'s a new build of {APP_NAME} available! Click here for details.",\n    "UPDATE_AVAILABLE_TITLE"               : "Update Available",\n    "UPDATE_MESSAGE"                       : "Hey, there\'s a new build of {APP_NAME} available. Here are some of the new features:",\n    "GET_IT_NOW"                           : "Get it now!",\n    "PROJECT_SETTINGS_TITLE"               : "Project Settings for: {0}",\n    "PROJECT_SETTING_BASE_URL"             : "Live Preview Base URL",\n    "PROJECT_SETTING_BASE_URL_HINT"        : "To use a local server, enter a URL like http://localhost:8000/",\n    "BASEURL_ERROR_INVALID_PROTOCOL"       : "The {0} protocol isn\'t supported by Live Preview&mdash;please use http: or https: .",\n    "BASEURL_ERROR_SEARCH_DISALLOWED"      : "The base URL can\'t contain search parameters like \\"{0}\\".",\n    "BASEURL_ERROR_HASH_DISALLOWED"        : "The base URL can\'t contain hashes like \\"{0}\\".",\n    "BASEURL_ERROR_INVALID_CHAR"           : "Special characters like \'{0}\' must be %-encoded.",\n    "BASEURL_ERROR_UNKNOWN_ERROR"          : "Unknown error parsing Base URL",\n\n    // Strings for Pane.js\n    "EMPTY_VIEW_HEADER"                    : "<em>Open a file while this pane has focus</em>",\n    "FLIPVIEW_BTN_TOOLTIP"                 : "Flip this view to {0} pane",\n\n    // Strings for themes-settings.html and themes-general.html\n    "CURRENT_THEME"                        : "Current Theme",\n    "USE_THEME_SCROLLBARS"                 : "Use Theme Scrollbars",\n    "FONT_SIZE"                            : "Font Size",\n    "FONT_FAMILY"                          : "Font Family",\n    "THEMES_SETTINGS"                      : "Themes Settings",\n\n    // CSS Quick Edit\n    "BUTTON_NEW_RULE"                      : "New Rule",\n\n    // Extension Management strings\n    "INSTALL"                              : "Install",\n    "UPDATE"                               : "Update",\n    "REMOVE"                               : "Remove",\n    "DISABLE"                              : "Disable",\n    "ENABLE"                               : "Enable",\n    "OVERWRITE"                            : "Overwrite",\n    "CANT_REMOVE_DEV"                      : "Extensions in the \\"dev\\" folder must be manually deleted.",\n    "CANT_UPDATE"                          : "The update isn\'t compatible with this version of {APP_NAME}.",\n    "CANT_UPDATE_DEV"                      : "Extensions in the \\"dev\\" folder can\'t be updated automatically.",\n    "INSTALL_EXTENSION_TITLE"              : "Install Extension",\n    "UPDATE_EXTENSION_TITLE"               : "Update Extension",\n    "INSTALL_EXTENSION_LABEL"              : "Extension URL",\n    "INSTALL_EXTENSION_HINT"               : "URL of the extension\'s zip file or GitHub repo",\n    "INSTALLING_FROM"                      : "Installing extension from {0}\\u2026",\n    "INSTALL_SUCCEEDED"                    : "Installation successful!",\n    "INSTALL_FAILED"                       : "Installation failed.",\n    "CANCELING_INSTALL"                    : "Canceling\\u2026",\n    "CANCELING_HUNG"                       : "Canceling the install is taking a long time. An internal error may have occurred.",\n    "INSTALL_CANCELED"                     : "Installation canceled.",\n    "VIEW_COMPLETE_DESCRIPTION"            : "View complete description",\n    "VIEW_TRUNCATED_DESCRIPTION"           : "View truncated description",\n    // These must match the error codes in ExtensionsDomain.Errors.* :\n    "INVALID_ZIP_FILE"                     : "The downloaded content is not a valid zip file.",\n    "INVALID_PACKAGE_JSON"                 : "The package.json file is not valid (error was: {0}).",\n    "MISSING_PACKAGE_NAME"                 : "The package.json file doesn\'t specify a package name.",\n    "BAD_PACKAGE_NAME"                     : "{0} is an invalid package name.",\n    "MISSING_PACKAGE_VERSION"              : "The package.json file doesn\'t specify a package version.",\n    "INVALID_VERSION_NUMBER"               : "The package version number ({0}) is invalid.",\n    "INVALID_BRACKETS_VERSION"             : "The {APP_NAME} compatibility string ({0}) is invalid.",\n    "DISALLOWED_WORDS"                     : "The words ({1}) are not allowed in the {0} field.",\n    "API_NOT_COMPATIBLE"                   : "The extension isn\'t compatible with this version of {APP_NAME}. It\'s installed in your disabled extensions folder.",\n    "MISSING_MAIN"                         : "The package has no main.js file.",\n    "EXTENSION_ALREADY_INSTALLED"          : "Installing this package will overwrite a previously installed extension. Overwrite the old extension?",\n    "EXTENSION_SAME_VERSION"               : "This package is the same version as the one that is currently installed. Overwrite the existing installation?",\n    "EXTENSION_OLDER_VERSION"              : "This package is version {0} which is older than the currently installed ({1}). Overwrite the existing installation?",\n    "DOWNLOAD_ID_IN_USE"                   : "Internal error: download ID already in use.",\n    "NO_SERVER_RESPONSE"                   : "Cannot connect to server.",\n    "BAD_HTTP_STATUS"                      : "File not found on server (HTTP {0}).",\n    "CANNOT_WRITE_TEMP"                    : "Unable to save download to temp file.",\n    "ERROR_LOADING"                        : "The extension encountered an error while starting up.",\n    "MALFORMED_URL"                        : "The URL is invalid. Please check that you entered it correctly.",\n    "UNSUPPORTED_PROTOCOL"                 : "The URL must be an http or https URL.",\n    "UNKNOWN_ERROR"                        : "Unknown internal error.",\n    // For NOT_FOUND_ERR, see generic strings above\n    "EXTENSION_MANAGER_TITLE"              : "Extension Manager",\n    "EXTENSION_MANAGER_ERROR_LOAD"         : "Unable to access the extension registry. Please try again later.",\n    "INSTALL_EXTENSION_DRAG"               : "Drag .zip here or",\n    "INSTALL_EXTENSION_DROP"               : "Drop .zip to install",\n    "INSTALL_EXTENSION_DROP_ERROR"         : "Install/Update aborted due to the following errors:",\n    "INSTALL_FROM_URL"                     : "Install from URL\\u2026",\n    "INSTALL_EXTENSION_VALIDATING"         : "Validating\\u2026",\n    "EXTENSION_AUTHOR"                     : "Author",\n    "EXTENSION_DATE"                       : "Date",\n    "EXTENSION_INCOMPATIBLE_NEWER"         : "This extension requires a newer version of {APP_NAME}.",\n    "EXTENSION_INCOMPATIBLE_OLDER"         : "This extension currently only works with older versions of {APP_NAME}.",\n    "EXTENSION_LATEST_INCOMPATIBLE_NEWER"  : "Version {0} of this extension requires a newer version of {APP_NAME}. But you can install the earlier version {1}.",\n    "EXTENSION_LATEST_INCOMPATIBLE_OLDER"  : "Version {0} of this extension only works with older versions of {APP_NAME}. But you can install the earlier version {1}.",\n    "EXTENSION_NO_DESCRIPTION"             : "No description",\n    "EXTENSION_MORE_INFO"                  : "More info\\u2026",\n    "EXTENSION_ERROR"                      : "Extension error",\n    "EXTENSION_KEYWORDS"                   : "Keywords",\n    "EXTENSION_TRANSLATED_USER_LANG"       : "Translated into {0} languages, including yours",\n    "EXTENSION_TRANSLATED_GENERAL"         : "Translated into {0} languages",\n    "EXTENSION_TRANSLATED_LANGS"           : "This extension has been translated into these languages: {0}",\n    "EXTENSION_INSTALLED"                  : "Installed",\n    "EXTENSION_UPDATE_INSTALLED"           : "This extension update has been downloaded and will be installed after {APP_NAME} reloads.",\n    "EXTENSION_SEARCH_PLACEHOLDER"         : "Search",\n    "EXTENSION_MORE_INFO_LINK"             : "More",\n    "BROWSE_EXTENSIONS"                    : "Browse Extensions",\n    "EXTENSION_MANAGER_REMOVE"             : "Remove Extension",\n    "EXTENSION_MANAGER_REMOVE_ERROR"       : "Unable to remove one or more extensions: {0}. {APP_NAME} will still reload.",\n    "EXTENSION_MANAGER_UPDATE"             : "Update Extension",\n    "EXTENSION_MANAGER_UPDATE_ERROR"       : "Unable to update one or more extensions: {0}. {APP_NAME} will still reload.",\n    "EXTENSION_MANAGER_DISABLE"            : "Disable Extension",\n    "EXTENSION_MANAGER_DISABLE_ERROR"      : "Unable to disable one or more extensions: {0}. {APP_NAME} will still reload.",\n    "MARKED_FOR_REMOVAL"                   : "Marked for removal",\n    "UNDO_REMOVE"                          : "Undo",\n    "MARKED_FOR_UPDATE"                    : "Marked for update",\n    "UNDO_UPDATE"                          : "Undo",\n    "MARKED_FOR_DISABLING"                 : "Marked for disabling",\n    "UNDO_DISABLE"                         : "Undo",\n    "CHANGE_AND_RELOAD_TITLE"              : "Change Extensions",\n    "CHANGE_AND_RELOAD_MESSAGE"            : "To update, remove or disable the marked extensions, {APP_NAME} will need to reload. You\'ll be prompted to save unsaved changes.",\n    "REMOVE_AND_RELOAD"                    : "Remove Extensions and Reload",\n    "CHANGE_AND_RELOAD"                    : "Change Extensions and Reload",\n    "UPDATE_AND_RELOAD"                    : "Update Extensions and Reload",\n    "DISABLE_AND_RELOAD"                   : "Disable Extensions and Reload",\n    "PROCESSING_EXTENSIONS"                : "Processing extension changes\\u2026",\n    "EXTENSION_NOT_INSTALLED"              : "Couldn\'t remove extension {0} because it wasn\'t installed.",\n    "NO_EXTENSIONS"                        : "No extensions installed yet.<br>Click on the Available tab above to get started.",\n    "NO_EXTENSION_MATCHES"                 : "No extensions match your search.",\n    "REGISTRY_SANITY_CHECK_WARNING"        : "NOTE: These extensions may come from different authors than {APP_NAME} itself. Extensions are not reviewed and have full local privileges. Be cautious when installing extensions from an unknown source.",\n    "EXTENSIONS_INSTALLED_TITLE"           : "Installed",\n    "EXTENSIONS_AVAILABLE_TITLE"           : "Available",\n    "EXTENSIONS_THEMES_TITLE"              : "Themes",\n    "EXTENSIONS_UPDATES_TITLE"             : "Updates",\n\n    "INLINE_EDITOR_NO_MATCHES"             : "No matches available.",\n    "INLINE_EDITOR_HIDDEN_MATCHES"         : "All matches are collapsed. Expand the files listed at right to view matches.",\n    "CSS_QUICK_EDIT_NO_MATCHES"            : "There are no existing CSS rules that match your selection.<br> Click \\"New Rule\\" to create one.",\n    "CSS_QUICK_EDIT_NO_STYLESHEETS"        : "There are no stylesheets in your project.<br>Create one to add CSS rules.",\n\n    // Custom Viewers\n    "IMAGE_VIEWER_LARGEST_ICON"            : "largest",\n\n    /**\n     * Unit names\n     */\n    "UNIT_PIXELS"                          : "pixels",\n\n    // extensions/default/DebugCommands\n    "DEBUG_MENU"                                : "Debug",\n    "ERRORS"                                    : "Errors",\n    "CMD_SHOW_DEV_TOOLS"                        : "Show Developer Tools",\n    "CMD_REFRESH_WINDOW"                        : "Reload With Extensions",\n    "CMD_RELOAD_WITHOUT_USER_EXTS"              : "Reload Without Extensions",\n    "CMD_NEW_BRACKETS_WINDOW"                   : "New {APP_NAME} Window",\n    "CMD_LAUNCH_SCRIPT_MAC"                     : "Install Command Line Shortcut",\n    "CMD_SWITCH_LANGUAGE"                       : "Switch Language",\n    "CMD_RUN_UNIT_TESTS"                        : "Run Tests",\n    "CMD_SHOW_PERF_DATA"                        : "Show Performance Data",\n    "CMD_ENABLE_NODE_DEBUGGER"                  : "Enable Node Debugger",\n    "CMD_LOG_NODE_STATE"                        : "Log Node State to Console",\n    "CMD_RESTART_NODE"                          : "Restart Node",\n    "CMD_SHOW_ERRORS_IN_STATUS_BAR"             : "Show Errors in Status Bar",\n    "CMD_OPEN_BRACKETS_SOURCE"                  : "Open {APP_NAME} Source",\n\n    "CREATING_LAUNCH_SCRIPT_TITLE"              : "{APP_NAME} Command Line Shortcut",\n    "ERROR_CREATING_LAUNCH_SCRIPT"              : "An error occurred while installing the command line shortcut. Please try <a href=\'https://github.com/adobe/brackets/wiki/Command-Line-Arguments#troubleshooting\'>these troubleshooting suggestions</a>.<br/><br/>Reason: {0}",\n    "ERROR_CLTOOLS_RMFAILED"                    : "Unable to remove existing <code>/usr/local/bin/brackets</code> symlink.",\n    "ERROR_CLTOOLS_MKDIRFAILED"                 : "Unable to create <code>/usr/local/bin</code> directory.",\n    "ERROR_CLTOOLS_LNFAILED"                    : "Unable to create <code>/usr/local/bin/brackets</code> symlink.",\n    "ERROR_CLTOOLS_SERVFAILED"                  : "Internal error.",\n    "ERROR_CLTOOLS_NOTSUPPORTED"                : "Command line shortcut is not supported on this OS.",\n    "LAUNCH_SCRIPT_CREATE_SUCCESS"              : "Success! Now you can easily launch {APP_NAME} from the command line: <code>brackets myFile.txt</code> to open a file or <code>brackets myFolder</code> to switch projects. <br/><br/><a href=\'https://github.com/adobe/brackets/wiki/Command-Line-Arguments\'>Learn more</a> about using {APP_NAME} from the command line.",\n\n    "LANGUAGE_TITLE"                            : "Switch Language",\n    "LANGUAGE_MESSAGE"                          : "Language:",\n    "LANGUAGE_SUBMIT"                           : "Reload {APP_NAME}",\n    "LANGUAGE_CANCEL"                           : "Cancel",\n    "LANGUAGE_SYSTEM_DEFAULT"                   : "System Default",\n\n    // extensions/default/HealthData\n    "HEALTH_DATA_NOTIFICATION"                  : "Health Report Preferences",\n    "HEALTH_FIRST_POPUP_TITLE"                  : "{APP_NAME} Health Report",\n    "HEALTH_DATA_DO_TRACK"                      : "Share anonymous information on how I use {APP_NAME}",\n    "HEALTH_DATA_NOTIFICATION_MESSAGE"          : "In order to improve {APP_NAME}, we periodically send limited, <strong>anonymous</strong> statistics to Adobe about how you use {APP_NAME}. This information helps prioritize features, find bugs, and spot usability issues.<br><br>You can see your data or choose not to share data by selecting <strong>Help > Health Report</strong>.<br><br><a href=\'https://github.com/adobe/brackets/wiki/Health-Data\'>Learn more about {APP_NAME} Health Report</a>",\n    "HEALTH_DATA_PREVIEW"                       : "{APP_NAME} Health Report",\n    "HEALTH_DATA_PREVIEW_INTRO"                 : "<p>In order to improve {APP_NAME}, we periodically send limited, <strong>anonymous</strong> statistics to Adobe about how you use {APP_NAME}. This information helps prioritize features, find bugs, and spot usability issues. <a href=\'https://github.com/adobe/brackets/wiki/Health-Data\'>Learn more about {APP_NAME} Health Report</a> and how it benefits the {APP_NAME} community while protecting your privacy.</p><p>Below is a preview of the data that will be sent in your next Health Report <em>if</em> it is enabled.</p>",\n\n    // extensions/default/InlineTimingFunctionEditor\n    "INLINE_TIMING_EDITOR_TIME"                 : "Time",\n    "INLINE_TIMING_EDITOR_PROGRESSION"          : "Progression",\n    "BEZIER_EDITOR_INFO"                        : "<kbd>↑</kbd><kbd>↓</kbd><kbd>←</kbd><kbd>→</kbd> Move selected point<br><kbd class=\'text\'>Shift</kbd> Move by ten units<br><kbd class=\'text\'>Tab</kbd> Switch points",\n    "STEPS_EDITOR_INFO"                         : "<kbd>↑</kbd><kbd>↓</kbd> Increase or decrease steps<br><kbd>←</kbd><kbd>→</kbd> \'Start\' or \'End\'",\n    "INLINE_TIMING_EDITOR_INVALID"              : "The old value <code>{0}</code> is not valid, so the displayed function was changed to <code>{1}</code>. The document will be updated with the first edit.",\n\n    // extensions/default/InlineColorEditor\n    "COLOR_EDITOR_CURRENT_COLOR_SWATCH_TIP"     : "Current Color",\n    "COLOR_EDITOR_ORIGINAL_COLOR_SWATCH_TIP"    : "Original Color",\n    "COLOR_EDITOR_RGBA_BUTTON_TIP"              : "RGBa Format",\n    "COLOR_EDITOR_HEX_BUTTON_TIP"               : "Hex Format",\n    "COLOR_EDITOR_HSLA_BUTTON_TIP"              : "HSLa Format",\n    "COLOR_EDITOR_USED_COLOR_TIP_SINGULAR"      : "{0} (Used {1} time)",\n    "COLOR_EDITOR_USED_COLOR_TIP_PLURAL"        : "{0} (Used {1} times)",\n\n    // extensions/default/JavaScriptCodeHints\n    "CMD_JUMPTO_DEFINITION"                     : "Jump to Definition",\n    "CMD_SHOW_PARAMETER_HINT"                   : "Show Parameter Hint",\n    "NO_ARGUMENTS"                              : "<no parameters>",\n    "DETECTED_EXCLUSION_TITLE"                  : "JavaScript File Inference Problem",\n    "DETECTED_EXCLUSION_INFO"                   : "{APP_NAME} ran into trouble processing <span class=\'dialog-filename\'>{0}</span>.<br><br>This file will no longer be processed for code hints, Jump to Definition or Quick Edit. To re-enable this file, open <code>.brackets.json</code> in your project and edit <code>jscodehints.detectedExclusions</code>.<br><br>This is likely a {APP_NAME} bug. If you can provide a copy of this file, please <a href=\'https://github.com/adobe/brackets/wiki/How-to-Report-an-Issue\'>file a bug</a> with a link to the file named here.",\n\n    // extensions/default/JSLint\n    "JSLINT_NAME"                               : "JSLint",\n\n    // extensions/default/QuickView\n    "CMD_ENABLE_QUICK_VIEW"                     : "Quick View on Hover",\n\n    // extensions/default/RecentProjects\n    "CMD_TOGGLE_RECENT_PROJECTS"                : "Recent Projects",\n\n    // extensions/default/WebPlatformDocs\n    "DOCS_MORE_LINK"                            : "Read more",\n\n    // extensions/default/CodeFolding\n    "COLLAPSE_ALL"                  : "Collapse All",\n    "EXPAND_ALL"                    : "Expand All",\n    "COLLAPSE_CURRENT"              : "Collapse Current",\n    "EXPAND_CURRENT"                : "Expand Current",\n\n    // Descriptions of core preferences\n    "DESCRIPTION_CLOSE_BRACKETS"                     : "true to automatically close braces, brackets and parentheses",\n    "DESCRIPTION_CLOSE_OTHERS_ABOVE"                 : "false to remove the \\"Close Others Above\\" from the Working Files context menu",\n    "DESCRIPTION_CLOSE_OTHERS_BELOW"                 : "false to remove the \\"Close Others Below\\" from the Working Files context menu",\n    "DESCRIPTION_CLOSE_OTHERS"                       : "false to remove the \\"Close Others\\" from the Working Files context menu",\n    "DESCRIPTION_CLOSE_TAGS"                         : "Sets the tag closing options",\n    "DESCRIPTION_CLOSE_TAGS_DONT_CLOSE_TAGS"         : "An array of tags that should not be auto-closed",\n    "DESCRIPTION_CLOSE_TAGS_WHEN_OPENING"            : "Close when > of opening tag is typed",\n    "DESCRIPTION_CLOSE_TAGS_WHEN_CLOSING"            : "Close when / of closing tag is typed",\n    "DESCRIPTION_CLOSE_TAGS_INDENT_TAGS"             : "An array of tags that when opened has a blank line",\n    "DESCRIPTION_CODE_FOLDING_ALWAY_USE_INDENT_FOLD" : "true to always generate collapsible section markers when indent level changes",\n    "DESCRIPTION_CODE_FOLDING_ENABLED"               : "true to enable code folding",\n    "DESCRIPTION_CODE_FOLDING_HIDE_UNTIL_MOUSEOVER"  : "true to make Section-collapsing markers visible only when you move the mouse over the gutter",\n    "DESCRIPTION_CODE_FOLDING_MAX_FOLD_LEVEL"        : "Limits how many levels deep Collapse All applies",\n    "DESCRIPTION_CODE_FOLDING_MIN_FOLD_SIZE"         : "Minimum lines before a collapsible section icon appears",\n    "DESCRIPTION_CODE_FOLDING_SAVE_FOLD_STATES"      : "true to remember collapsed sections if you close and reopen a file or project",\n    "DESCRIPTION_CODE_FOLDING_MAKE_SELECTIONS_FOLDABLE": "true to enable code folding on selected text in the editor",\n    "DESCRIPTION_ATTR_HINTS"                         : "Enable/disable HTML attribute hints",\n    "DESCRIPTION_CSS_PROP_HINTS"                     : "Enable/disable CSS/LESS/SCSS property hints",\n    "DESCRIPTION_JS_HINTS"                           : "Enable/disable JavaScript code hints",\n    "DESCRIPTION_JS_HINTS_TYPE_DETAILS"              : "Enable/disable datatype details in JavaScript code hints",\n    "DESCRIPTION_PREF_HINTS"                         : "Enable/disable Preferences code hints",\n    "DESCRIPTION_SPECIAL_CHAR_HINTS"                 : "Enable/disable HTML entity hints",\n    "DESCRIPTION_SVG_HINTS"                          : "Enable/disable SVG code hints",\n    "DESCRIPTION_HTML_TAG_HINTS"                     : "Enable/disable HTML tag hints",\n    "DESCRIPTION_URL_CODE_HINTS"                     : "Enable/disable URL hints in HTML & CSS/LESS/SCSS",\n    "DESCRIPTION_DRAG_DROP_TEXT"                     : "Enable/disable Drag & Drop functionality",\n    "DESCRIPTION_HEALTH_DATA_TRACKING"               : "Enable the Health Data Tracking",\n    "DESCRIPTION_HIGHLIGHT_MATCHES"                  : "Enables automatic highlighting of matching strings throughout the document",\n    "DESCRIPTION_HIGHLIGHT_MATCHES_SHOW_TOKEN"       : "Highlight all strings that match the token the cursor is currently in (no selection needed)",\n    "DESCRIPTION_HIGHLIGHT_MATCHES_WORDS_ONLY"       : "Highlight only when selection is a complete token",\n    "DESCRIPTION_INSERT_HINT_ON_TAB"                 : "true to insert the currently selected code hint on tab",\n    "DESCRIPTION_NO_HINTS_ON_DOT"                    : "true to not automatically show JS code hints when . is typed",\n    "DESCRIPTION_JSLINT_OPTIONS"                     : "An object with the default options for JSLint",\n    "DESCRIPTION_JSLINT_OPTIONS_ASS"                 : "true to allow assignment expressions",\n    "DESCRIPTION_JSLINT_OPTIONS_BITWISE"             : "true to allow bitwise operators",\n    "DESCRIPTION_JSLINT_OPTIONS_BROWSER"             : "true if standard browser globals should be predefined",\n    "DESCRIPTION_JSLINT_OPTIONS_CLOSURE"             : "true to allow Google Closure idioms",\n    "DESCRIPTION_JSLINT_OPTIONS_CONTINUE"            : "true to allow \\"continue\\" statement",\n    "DESCRIPTION_JSLINT_OPTIONS_COUCH"               : "true if CouchDB globals should be predefined",\n    "DESCRIPTION_JSLINT_OPTIONS_DEBUG"               : "true to allow debugger statements",\n    "DESCRIPTION_JSLINT_OPTIONS_DEVEL"               : "true if browser globals useful in development should be predefined",\n    "DESCRIPTION_JSLINT_OPTIONS_EQEQ"                : "true to allow == and !=",\n    "DESCRIPTION_JSLINT_OPTIONS_ES6"                 : "true if ES6 globals should be predefined",\n    "DESCRIPTION_JSLINT_OPTIONS_EVIL"                : "true to allow eval",\n    "DESCRIPTION_JSLINT_OPTIONS_FORIN"               : "true to allow unfiltered \\"for ... in\\"",\n    "DESCRIPTION_JSLINT_OPTIONS_INDENT"              : "Set a specific tab width",\n    "DESCRIPTION_JSLINT_OPTIONS_MAXERR"              : "The maximum number of warnings reported",\n    "DESCRIPTION_JSLINT_OPTIONS_MAXLEN"              : "The maximum number of characters in a line",\n    "DESCRIPTION_JSLINT_OPTIONS_NEWCAP"              : "true to allow uncapitalized constructors",\n    "DESCRIPTION_JSLINT_OPTIONS_NODE"                : "true if Node.js globals should be predefined",\n    "DESCRIPTION_JSLINT_OPTIONS_NOMEN"               : "true to allow dangling underscore in identifiers",\n    "DESCRIPTION_JSLINT_OPTIONS_PASSFAIL"            : "true to stop on first error",\n    "DESCRIPTION_JSLINT_OPTIONS_PLUSPLUS"            : "true to allow ++ and --",\n    "DESCRIPTION_JSLINT_OPTIONS_REGEXP"              : "true to allow . and [^...]. in RegExp",\n    "DESCRIPTION_JSLINT_OPTIONS_RHINO"               : "true if Rhino globals should be predefined",\n    "DESCRIPTION_JSLINT_OPTIONS_SLOPPY"              : "true to allow missing `use strict` pragma",\n    "DESCRIPTION_JSLINT_OPTIONS_STUPID"              : "true if blocking (\'...Sync\') methods can be used.",\n    "DESCRIPTION_JSLINT_OPTIONS_SUB"                 : "true to allow inefficient subscripting",\n    "DESCRIPTION_JSLINT_OPTIONS_TODO"                : "true to allow TODO comments",\n    "DESCRIPTION_JSLINT_OPTIONS_UNPARAM"             : "true to allow unused parameters",\n    "DESCRIPTION_JSLINT_OPTIONS_VARS"                : "true to allow more than 1 vars in a function",\n    "DESCRIPTION_JSLINT_OPTIONS_WHITE"               : "true to ignore white-space rules",\n    "DESCRIPTION_LANGUAGE"                           : "Language specific settings",\n    "DESCRIPTION_LANGUAGE_FILE_EXTENSIONS"           : "Additional mappings from file extension to language name",\n    "DESCRIPTION_LANGUAGE_FILE_NAMES"                : "Additional mappings from file name to language name",\n    "DESCRIPTION_LINTING_ENABLED"                    : "true to enable Code Inspection",\n    "DESCRIPTION_ASYNC_TIMEOUT"                      : "The time in milliseconds after which asynchronous linters time out",\n    "DESCRIPTION_LINTING_PREFER"                     : "Array of linters to run first",\n    "DESCRIPTION_LIVE_DEV_MULTIBROWSER"              : "true to enable experimental Live Preview",\n    "DESCRIPTION_USE_PREFERED_ONLY"                  : "true to run providers specified in linting.prefer only",\n    "DESCRIPTION_MAX_CODE_HINTS"                     : "Maximum code hints displayed at once",\n    "DESCRIPTION_PATH"                               : "Path specific settings",\n    "DESCRIPTION_PROXY"                              : "The URL of the proxy server used for extension installation",\n    "DESCRIPTION_SCROLL_PAST_END"                    : "true to enable scrolling beyond the end of the document",\n    "DESCRIPTION_SHOW_CODE_HINTS"                    : "false to disable all code hints",\n    "DESCRIPTION_SHOW_CURSOR_WHEN_SELECTING"         : "Keeps the blinking cursor visible when you have a text selection",\n    "DESCRIPTION_SHOW_LINE_NUMBERS"                  : "true to show line numbers in a “gutter” to the left of the code",\n    "DESCRIPTION_SMART_INDENT"                       : "Automatically indent when creating a new block",\n    "DESCRIPTION_SOFT_TABS"                          : "false to turn off soft tabs behavior",\n    "DESCRIPTION_SORT_DIRECTORIES_FIRST"             : "true to sort the directories first in the project tree",\n    "DESCRIPTION_SPACE_UNITS"                        : "Number of spaces to use for space-based indentation",\n    "DESCRIPTION_STATIC_SERVER_PORT"                 : "Port number that the built-in server should use for Live Preview",\n    "DESCRIPTION_STYLE_ACTIVE_LINE"                  : "true to highlight background color of the line the cursor is on",\n    "DESCRIPTION_TAB_SIZE"                           : "Number of spaces to display for tabs",\n    "DESCRIPTION_USE_TAB_CHAR"                       : "true to use tabs instead of spaces",\n    "DESCRIPTION_UPPERCASE_COLORS"                   : "true to generate uppercase hex colors in Inline Color Editor",\n    "DESCRIPTION_WORD_WRAP"                          : "Wrap lines that exceed the viewport width",\n    "DESCRIPTION_DETECTED_EXCLUSIONS"                : "A list of files that have been detected to cause Tern to run out of control",\n    "DESCRIPTION_INFERENCE_TIMEOUT"                  : "The amount of time after which Tern will time out when trying to understand files",\n    "DESCRIPTION_SHOW_ERRORS_IN_STATUS_BAR"          : "true to show errors in status bar",\n    "DESCRIPTION_QUICK_VIEW_ENABLED"                 : "true to enable Quick View",\n    "DESCRIPTION_EXTENSION_LESS_IMAGE_PREVIEW"       : "true to show image previews for URLs missing extensions",\n    "DESCRIPTION_THEME"                              : "Select a {APP_NAME} theme",\n    "DESCRIPTION_USE_THEME_SCROLLBARS"               : "true to allow custom scroll bars",\n    "DESCRIPTION_LINTING_COLLAPSED"                  : "true to collapse linting panel",\n    "DESCRIPTION_FONT_FAMILY"                        : "Change font family",\n    "DESCRIPTION_FONT_SIZE"                          : "Change font size; e.g. 13px",\n    "DESCRIPTION_FIND_IN_FILES_NODE"                 : "true to enable node based search",\n    "DESCRIPTION_FIND_IN_FILES_INSTANT"              : "true to enable instant search",\n    "DESCRIPTION_FONT_SMOOTHING"                     : "Mac-only: \\"subpixel-antialiased\\" to enable sub-pixel antialiasing or \\"antialiased\\" for gray scale antialiasing",\n    "DESCRIPTION_OPEN_PREFS_IN_SPLIT_VIEW"           : "false to disable opening preferences file in split view",\n    "DESCRIPTION_OPEN_USER_PREFS_IN_SECOND_PANE"     : "false to open user preferences file in left/top pane",\n    "DESCRIPTION_MERGE_PANES_WHEN_LAST_FILE_CLOSED"  : "true to collapse panes after the last file from the pane is closed via pane header close button",\n    "DESCRIPTION_SHOW_PANE_HEADER_BUTTONS"           : "Toggle when to show the close and flip-view buttons on the header.",\n    "DEFAULT_PREFERENCES_JSON_HEADER_COMMENT"        : "/*\\n * This is a read-only file with the preferences supported\\n * by {APP_NAME}.\\n * Use this file as a reference to modify your preferences\\n * file \\"brackets.json\\" opened in the other pane.\\n * For more information on how to use preferences inside\\n * {APP_NAME}, refer to the web page at https://github.com/adobe/brackets/wiki/How-to-Use-Brackets#preferences\\n */",\n    "DEFAULT_PREFERENCES_JSON_DEFAULT"               : "Default",\n    "DESCRIPTION_PURE_CODING_SURFACE"                : "true to enable code only mode and hide all other UI elements in {APP_NAME}"\n});\n\n//# sourceURL=/nls/root/strings.js'),
eval('/*\n * Copyright (c) 2013 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */\n/*global define */\n\ndefine(\'nls/urls\',[\'require\',\'exports\',\'module\'],function (require, exports, module) {\n\n    "use strict";\n\n    // Registry for languages that have specific per-language URLs or file paths that we use\n    // elsewhere in Brackets.\n    //\n    // TODO: dynamically populate the local prefix list below?\n    module.exports = {\n        root: true,\n        "cs": true,\n        "da": true,\n        "de": true,\n        "es": true,\n        "fa-ir": true,\n        "fi": true,\n        "fr": true,\n        "hr": true,\n        "id": true,\n        "it": true,\n        "ja": true,\n        "ko": true,\n        "nb": true,\n        "pl": true,\n        "pt-br": true,\n        "pt-pt": true,\n        "ru": true,\n        "sv": true,\n        "zh-cn": true,\n        "zh-tw": true,\n        "tr": true\n    };\n});\n\n//# sourceURL=/nls/urls.js'),eval('/*\n * Copyright (c) 2012 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */\n/*global define */\n\ndefine(\'nls/root/urls\',{\n    // Relative to the samples folder\n    "GETTING_STARTED"           : "root/Getting Started",\n    "ADOBE_THIRD_PARTY"         : "http://www.adobe.com/go/thirdparty/",\n    "WEB_PLATFORM_DOCS_LICENSE" : "http://creativecommons.org/licenses/by/3.0/"\n});\n\n//# sourceURL=/nls/root/urls.js'),eval("/*\n * Copyright (c) 2012 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the \"Software\"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */\n/*global define */\n\ndefine('nls/strings-app',['require','exports','module'],function (require, exports, module) {\n\n    \"use strict\";\n\n    // Code that needs to display user strings should call require(\"strings\") to load\n    // src/strings.js. This file will dynamically load strings.js for the specified brackets.locale.\n    //\n    // See the README.md file in this folder for information on how to add a new translation for\n    // another language or locale.\n    //\n    // TODO: dynamically populate the local prefix list below?\n    module.exports = {\n        root: true\n    };\n});\n\n//# sourceURL=/nls/strings-app.js"),eval('/*\n * Copyright (c) 2013 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */\n/*global define */\n\ndefine(\'nls/root/strings-app\',{\n    // product-specific strings\n    "APP_NAME"                             : "Brackets",\n\n    // Self locales (used by Debug > Switch Language)\n    "LOCALE_CS"                                 : "čeština",\n    "LOCALE_DA"                                 : "Dansk",\n    "LOCALE_DE"                                 : "Deutsch",\n    "LOCALE_EL"                                 : "Ελληνικά",\n    "LOCALE_EN"                                 : "English (US)",\n    "LOCALE_EN_GB"                              : "English (UK)",\n    "LOCALE_ES"                                 : "español",\n    "LOCALE_FA_IR"                              : "فارسی",\n    "LOCALE_FI"                                 : "suomi",\n    "LOCALE_FR"                                 : "français",\n    "LOCALE_GL"                                 : "galego",\n    "LOCALE_HR"                                 : "hrvatski",\n    "LOCALE_HU"                                 : "magyar",\n    "LOCALE_ID"                                 : "Bahasa Indonesia",\n    "LOCALE_IT"                                 : "italiano",\n    "LOCALE_JA"                                 : "日本語",\n    "LOCALE_KO"                                 : "한국어",\n    "LOCALE_NB"                                 : "norsk",\n    "LOCALE_NL"                                 : "Nederlands",\n    "LOCALE_PL"                                 : "polski",\n    "LOCALE_PT_BR"                              : "português (BR)",\n    "LOCALE_PT_PT"                              : "português (PT)",\n    "LOCALE_RO"                                 : "română",\n    "LOCALE_RU"                                 : "русский",\n    "LOCALE_SK"                                 : "slovenčina",\n    "LOCALE_SR"                                 : "Српски",\n    "LOCALE_SV"                                 : "svenska",\n    "LOCALE_TR"                                 : "Türkçe",\n    "LOCALE_UK"                                 : "Українська",\n    "LOCALE_ZH_CN"                              : "简体中文",\n    "LOCALE_ZH_TW"                              : "繁體中文"\n});\n\n//# sourceURL=/nls/root/strings-app.js'),eval('/*\n * Copyright (c) 2012 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */\n/*global $, define, brackets, window */\n\n/**\n * This file provides the interface to user visible strings in Brackets. Code that needs\n * to display strings should should load this module by calling `var Strings = require("strings")`.\n * The i18n plugin will dynamically load the strings for the right locale and populate\n * the exports variable. See src\\nls\\strings.js for the master file of English strings.\n */\ndefine(\'strings\',[\'require\',\'exports\',\'module\',\'thirdparty/lodash\',\'i18n!nls/strings\',\'i18n!nls/urls\',\'i18n!nls/strings-app\',\'utils/StringUtils\',\'utils/Global\'],function (require, exports, module) {\n    "use strict";\n\n    var _ = require("thirdparty/lodash");\n\n    var strings     = require("i18n!nls/strings"),\n        urls        = require("i18n!nls/urls"),\n        stringsApp  = require("i18n!nls/strings-app"),\n        StringUtils = require("utils/StringUtils");\n\n    // make sure the global brackets variable is loaded\n    require("utils/Global");\n\n    // Add URLs as additional globals\n    var additionalGlobals = $.extend({}, urls),\n        parsedVersion = /([0-9]+)\\.([0-9]+)\\.([0-9]+)/.exec(brackets.metadata.version);\n\n    additionalGlobals.APP_NAME      = brackets.metadata.name || strings.APP_NAME;\n    additionalGlobals.APP_TITLE     = brackets.config.app_title || strings.APP_NAME;\n    additionalGlobals.TWITTER_NAME  = brackets.config.twitter_name;\n    additionalGlobals.VERSION       = brackets.metadata.version;\n    additionalGlobals.VERSION_MAJOR = parsedVersion[1];\n    additionalGlobals.VERSION_MINOR = parsedVersion[2];\n    additionalGlobals.VERSION_PATCH = parsedVersion[3];\n\n    var isDevBuild = !StringUtils.endsWith(decodeURI(window.location.pathname), "/www/index.html");\n    if (isDevBuild) {\n        additionalGlobals.BUILD_TYPE = strings.DEVELOPMENT_BUILD;\n    } else {\n        var isReleaseBuild = (brackets.platform === "mac" || brackets.platform === "win");\n        additionalGlobals.BUILD_TYPE = (isReleaseBuild ? strings.RELEASE_BUILD : strings.EXPERIMENTAL_BUILD);\n    }\n\n    // Insert application strings\n    _.forEach(strings, function (value, key) {\n        _.forEach(additionalGlobals, function (item, name) {\n            strings[key] = strings[key].replace(new RegExp("{" + name + "}", "g"), additionalGlobals[name]);\n        });\n    });\n\n    // Append or overlay additional, product-specific strings\n    _.forEach(stringsApp, function (value, key) {\n        _.forEach(additionalGlobals, function (item, name) {\n            stringsApp[key] = stringsApp[key].replace(new RegExp("{" + name + "}", "g"), additionalGlobals[name]);\n        });\n        strings[key] = stringsApp[key];\n    });\n\n    module.exports = strings;\n\n});\n\n//# sourceURL=/strings.js'),eval('/*\n * Copyright (c) 2012 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, regexp: true, indent: 4, maxerr: 50 */\n/*global define, $, brackets, unescape, window */\n\n/**\n * Set of utilities for working with files and text content.\n */\ndefine(\'file/FileUtils\',[\'require\',\'exports\',\'module\',\'utils/Global\',\'filesystem/FileSystemError\',\'utils/DeprecationWarning\',\'language/LanguageManager\',\'utils/PerfUtils\',\'strings\',\'utils/StringUtils\'],function (require, exports, module) {\n    "use strict";\n\n    require("utils/Global");\n\n    var FileSystemError     = require("filesystem/FileSystemError"),\n        DeprecationWarning  = require("utils/DeprecationWarning"),\n        LanguageManager     = require("language/LanguageManager"),\n        PerfUtils           = require("utils/PerfUtils"),\n        Strings             = require("strings"),\n        StringUtils         = require("utils/StringUtils");\n\n    // These will be loaded asynchronously\n    var DocumentCommandHandlers, LiveDevelopmentUtils;\n\n    /**\n     * @const {Number} Maximium file size (in megabytes)\n     *   (for display strings)\n     *   This must be a hard-coded value since this value\n     *   tells how low-level APIs should behave which cannot\n     *   have a load order dependency on preferences manager\n     */\n    var MAX_FILE_SIZE_MB = 16;\n\n    /**\n     * @const {Number} Maximium file size (in bytes)\n     *   This must be a hard-coded value since this value\n     *   tells how low-level APIs should behave which cannot\n     *   have a load order dependency on preferences manager\n     */\n    var MAX_FILE_SIZE = MAX_FILE_SIZE_MB * 1024 * 1024;\n\n\n    /**\n     * Asynchronously reads a file as UTF-8 encoded text.\n     * @param {!File} file File to read\n     * @return {$.Promise} a jQuery promise that will be resolved with the\n     *  file\'s text content plus its timestamp, or rejected with a FileSystemError string\n     *  constant if the file can not be read.\n     */\n    function readAsText(file) {\n        var result = new $.Deferred();\n\n        // Measure performance\n        var perfTimerName = PerfUtils.markStart("readAsText:\\t" + file.fullPath);\n        result.always(function () {\n            PerfUtils.addMeasurement(perfTimerName);\n        });\n\n        // Read file\n        file.read(function (err, data, stat) {\n            if (!err) {\n                result.resolve(data, stat.mtime);\n            } else {\n                result.reject(err);\n            }\n        });\n\n        return result.promise();\n    }\n\n    /**\n     * Asynchronously writes a file as UTF-8 encoded text.\n     * @param {!File} file File to write\n     * @param {!string} text\n     * @param {boolean=} allowBlindWrite Indicates whether or not CONTENTS_MODIFIED\n     *      errors---which can be triggered if the actual file contents differ from\n     *      the FileSystem\'s last-known contents---should be ignored.\n     * @return {$.Promise} a jQuery promise that will be resolved when\n     * file writing completes, or rejected with a FileSystemError string constant.\n     */\n    function writeText(file, text, allowBlindWrite) {\n        var result = new $.Deferred(),\n            options = {};\n\n        if (allowBlindWrite) {\n            options.blind = true;\n        }\n\n        file.write(text, options, function (err) {\n            if (!err) {\n                result.resolve();\n            } else {\n                result.reject(err);\n            }\n        });\n\n        return result.promise();\n    }\n\n    /**\n     * Line endings\n     * @enum {string}\n     */\n    var LINE_ENDINGS_CRLF = "CRLF",\n        LINE_ENDINGS_LF   = "LF";\n\n    /**\n     * Returns the standard line endings for the current platform\n     * @return {LINE_ENDINGS_CRLF|LINE_ENDINGS_LF}\n     */\n    function getPlatformLineEndings() {\n        return brackets.platform === "win" ? LINE_ENDINGS_CRLF : LINE_ENDINGS_LF;\n    }\n\n    /**\n     * Scans the first 1000 chars of the text to determine how it encodes line endings. Returns\n     * null if usage is mixed or if no line endings found.\n     * @param {!string} text\n     * @return {null|LINE_ENDINGS_CRLF|LINE_ENDINGS_LF}\n     */\n    function sniffLineEndings(text) {\n        var subset = text.substr(0, 1000);  // (length is clipped to text.length)\n        var hasCRLF = /\\r\\n/.test(subset);\n        var hasLF = /[^\\r]\\n/.test(subset);\n\n        if ((hasCRLF && hasLF) || (!hasCRLF && !hasLF)) {\n            return null;\n        } else {\n            return hasCRLF ? LINE_ENDINGS_CRLF : LINE_ENDINGS_LF;\n        }\n    }\n\n    /**\n     * Translates any line ending types in the given text to the be the single form specified\n     * @param {!string} text\n     * @param {null|LINE_ENDINGS_CRLF|LINE_ENDINGS_LF} lineEndings\n     * @return {string}\n     */\n    function translateLineEndings(text, lineEndings) {\n        if (lineEndings !== LINE_ENDINGS_CRLF && lineEndings !== LINE_ENDINGS_LF) {\n            lineEndings = getPlatformLineEndings();\n        }\n\n        var eolStr = (lineEndings === LINE_ENDINGS_CRLF ? "\\r\\n" : "\\n");\n        var findAnyEol = /\\r\\n|\\r|\\n/g;\n\n        return text.replace(findAnyEol, eolStr);\n    }\n\n    /**\n     * @param {!FileSystemError} name\n     * @return {!string} User-friendly, localized error message\n     */\n    function getFileErrorString(name) {\n        // There are a few error codes that we have specific error messages for. The rest are\n        // displayed with a generic "(error N)" message.\n        var result;\n\n        if (name === FileSystemError.NOT_FOUND) {\n            result = Strings.NOT_FOUND_ERR;\n        } else if (name === FileSystemError.NOT_READABLE) {\n            result = Strings.NOT_READABLE_ERR;\n        } else if (name === FileSystemError.NOT_WRITABLE) {\n            result = Strings.NO_MODIFICATION_ALLOWED_ERR_FILE;\n        } else if (name === FileSystemError.CONTENTS_MODIFIED) {\n            result = Strings.CONTENTS_MODIFIED_ERR;\n        } else if (name === FileSystemError.UNSUPPORTED_ENCODING) {\n            result = Strings.UNSUPPORTED_ENCODING_ERR;\n        } else if (name === FileSystemError.EXCEEDS_MAX_FILE_SIZE) {\n            result = StringUtils.format(Strings.EXCEEDS_MAX_FILE_SIZE, MAX_FILE_SIZE_MB);\n        } else {\n            result = StringUtils.format(Strings.GENERIC_ERROR, name);\n        }\n\n        return result;\n    }\n\n    /**\n     * Shows an error dialog indicating that the given file could not be opened due to the given error\n     * @deprecated Use DocumentCommandHandlers.showFileOpenError() instead\n     *\n     * @param {!FileSystemError} name\n     * @return {!Dialog}\n     */\n    function showFileOpenError(name, path) {\n        DeprecationWarning.deprecationWarning("FileUtils.showFileOpenError() has been deprecated. " +\n                                              "Please use DocumentCommandHandlers.showFileOpenError() instead.");\n        return DocumentCommandHandlers.showFileOpenError(name, path);\n    }\n\n    /**\n     * Creates an HTML string for a list of files to be reported on, suitable for use in a dialog.\n     * @param {Array.<string>} Array of filenames or paths to display.\n     */\n    function makeDialogFileList(paths) {\n        var result = "<ul class=\'dialog-list\'>";\n        paths.forEach(function (path) {\n            result += "<li><span class=\'dialog-filename\'>";\n            result += StringUtils.breakableUrl(path);\n            result += "</span></li>";\n        });\n        result += "</ul>";\n        return result;\n    }\n\n    /**\n     * Convert a URI path to a native path.\n     * On both platforms, this unescapes the URI\n     * On windows, URI paths start with a "/", but have a drive letter ("C:"). In this\n     * case, remove the initial "/".\n     * @param {!string} path\n     * @return {string}\n     */\n    function convertToNativePath(path) {\n        path = unescape(path);\n        if (path.indexOf(":") !== -1 && path[0] === "/") {\n            return path.substr(1);\n        }\n\n        return path;\n    }\n\n    /**\n     * Convert a Windows-native path to use Unix style slashes.\n     * On Windows, this converts "C:\\foo\\bar\\baz.txt" to "C:/foo/bar/baz.txt".\n     * On Mac, this does nothing, since Mac paths are already in Unix syntax.\n     * (Note that this does not add an initial forward-slash. Internally, our\n     * APIs generally use the "C:/foo/bar/baz.txt" style for "native" paths.)\n     * @param {string} path A native-style path.\n     * @return {string} A Unix-style path.\n     */\n    function convertWindowsPathToUnixPath(path) {\n        if (brackets.platform === "win") {\n            path = path.replace(/\\\\/g, "/");\n        }\n        return path;\n    }\n\n    /**\n     * Removes the trailing slash from a path, if it has one.\n     * Warning: this differs from the format of most paths used in Brackets! Use paths ending in "/"\n     * normally, as this is the format used by Directory.fullPath.\n     *\n     * @param {string} path\n     * @return {string}\n     */\n    function stripTrailingSlash(path) {\n        if (path && path[path.length - 1] === "/") {\n            return path.slice(0, -1);\n        } else {\n            return path;\n        }\n    }\n\n    /**\n     * Get the name of a file or a directory, removing any preceding path.\n     * @param {string} fullPath full path to a file or directory\n     * @return {string} Returns the base name of a file or the name of a\n     * directory\n     */\n    function getBaseName(fullPath) {\n        var lastSlash = fullPath.lastIndexOf("/");\n        if (lastSlash === fullPath.length - 1) {  // directory: exclude trailing "/" too\n            return fullPath.slice(fullPath.lastIndexOf("/", fullPath.length - 2) + 1, -1);\n        } else {\n            return fullPath.slice(lastSlash + 1);\n        }\n    }\n\n    /**\n     * Returns a native absolute path to the \'brackets\' source directory.\n     * Note that this only works when run in brackets/src/index.html, so it does\n     * not work for unit tests (which is run from brackets/test/SpecRunner.html)\n     *\n     * WARNING: unlike most paths in Brackets, this path EXCLUDES the trailing "/".\n     * @return {string}\n     */\n    function getNativeBracketsDirectoryPath() {\n        var pathname = decodeURI(window.location.pathname);\n        var directory = pathname.substr(0, pathname.lastIndexOf("/"));\n        return convertToNativePath(directory);\n    }\n\n    /**\n     * Given the module object passed to JS module define function,\n     * convert the path to a native absolute path.\n     * Returns a native absolute path to the module folder.\n     *\n     * WARNING: unlike most paths in Brackets, this path EXCLUDES the trailing "/".\n     * @return {string}\n     */\n    function getNativeModuleDirectoryPath(module) {\n        var path;\n\n        if (module && module.uri) {\n            path = decodeURI(module.uri);\n\n            // Remove module name and trailing slash from path.\n            path = path.substr(0, path.lastIndexOf("/"));\n        }\n        return path;\n    }\n\n    /**\n     * Get the file extension (excluding ".") given a path OR a bare filename.\n     * Returns "" for names with no extension. If the name starts with ".", the\n     * full remaining text is considered the extension.\n     *\n     * @param {string} fullPath full path to a file or directory\n     * @return {string} Returns the extension of a filename or empty string if\n     * the argument is a directory or a filename with no extension\n     */\n    function getFileExtension(fullPath) {\n        var baseName = getBaseName(fullPath),\n            idx      = baseName.lastIndexOf(".");\n\n        if (idx === -1) {\n            return "";\n        }\n\n        return baseName.substr(idx + 1);\n    }\n\n    /**\n     * Get the file extension (excluding ".") given a path OR a bare filename.\n     * Returns "" for names with no extension.\n     * If the only `.` in the file is the first character,\n     * returns "" as this is not considered an extension.\n     * This method considers known extensions which include `.` in them.\n     * @deprecated Use LanguageManager.getCompoundFileExtension() instead\n     *\n     * @param {string} fullPath full path to a file or directory\n     * @return {string} Returns the extension of a filename or empty string if\n     * the argument is a directory or a filename with no extension\n     */\n    function getSmartFileExtension(fullPath) {\n        DeprecationWarning.deprecationWarning("FileUtils.getSmartFileExtension() has been deprecated. " +\n                                              "Please use LanguageManager.getCompoundFileExtension() instead.");\n        return LanguageManager.getCompoundFileExtension(fullPath);\n    }\n\n    /**\n     * Computes filename as relative to the basePath. For example:\n     * basePath: /foo/bar/, filename: /foo/bar/baz.txt\n     * returns: baz.txt\n     *\n     * The net effect is that the common prefix is stripped away. If basePath is not\n     * a prefix of filename, then undefined is returned.\n     *\n     * @param {string} basePath Path against which we\'re computing the relative path\n     * @param {string} filename Full path to the file for which we are computing a relative path\n     * @return {string} relative path\n     */\n    function getRelativeFilename(basePath, filename) {\n        if (!filename || filename.substr(0, basePath.length) !== basePath) {\n            return;\n        }\n\n        return filename.substr(basePath.length);\n    }\n\n    /**\n     * Determine if file extension is a static html file extension.\n     * @param {string} filePath could be a path, a file name or just a file extension\n     * @return {boolean} Returns true if fileExt is in the list\n     */\n    function isStaticHtmlFileExt(filePath) {\n        DeprecationWarning.deprecationWarning("FileUtils.isStaticHtmlFileExt() has been deprecated. " +\n                                              "Please use LiveDevelopmentUtils.isStaticHtmlFileExt() instead.");\n        return LiveDevelopmentUtils.isStaticHtmlFileExt(filePath);\n    }\n\n    /**\n     * Get the parent directory of a file. If a directory is passed, the SAME directory is returned.\n     * @param {string} fullPath full path to a file or directory\n     * @return {string} Returns the path to the parent directory of a file or the path of a directory,\n     *                  including trailing "/"\n     */\n    function getDirectoryPath(fullPath) {\n        return fullPath.substr(0, fullPath.lastIndexOf("/") + 1);\n    }\n\n    /**\n     * Get the parent folder of the given file/folder path. Differs from getDirectoryPath() when \'fullPath\'\n     * is a directory itself: returns its parent instead of the original path. (Note: if you already have a\n     * FileSystemEntry, it\'s faster to use entry.parentPath instead).\n     * @param {string} fullPath full path to a file or directory\n     * @return {string} Path of containing folder (including trailing "/"); or "" if path was the root\n     */\n    function getParentPath(fullPath) {\n        if (fullPath === "/") {\n            return "";\n        }\n        return fullPath.substring(0, fullPath.lastIndexOf("/", fullPath.length - 2) + 1);\n    }\n\n    /**\n     * Get the file name without the extension. Returns "" if name starts with "."\n     * @param {string} filename File name of a file or directory, without preceding path\n     * @return {string} Returns the file name without the extension\n     */\n    function getFilenameWithoutExtension(filename) {\n        var index = filename.lastIndexOf(".");\n        return index === -1 ? filename : filename.slice(0, index);\n    }\n\n    /**\n     * @private\n     * OS-specific helper for `compareFilenames()`\n     * @return {Function} The OS-specific compare function\n     */\n    var _cmpNames = (function () {\n        if (brackets.platform === "win") {\n            // Use this function on Windows\n            return function (filename1, filename2, lang) {\n                var f1 = getFilenameWithoutExtension(filename1),\n                    f2 = getFilenameWithoutExtension(filename2);\n                return f1.localeCompare(f2, lang, {numeric: true});\n            };\n        }\n\n        // Use this function other OSes\n        return function (filename1, filename2, lang) {\n            return filename1.localeCompare(filename2, lang, {numeric: true});\n        };\n    }());\n\n    /**\n     * Compares 2 filenames in lowercases. In Windows it compares the names without the\n     * extension first and then the extensions to fix issue #4409\n     * @param {string} filename1\n     * @param {string} filename2\n     * @param {boolean} extFirst If true it compares the extensions first and then the file names.\n     * @return {number} The result of the compare function\n     */\n    function compareFilenames(filename1, filename2, extFirst) {\n        var lang = brackets.getLocale();\n\n        filename1 = filename1.toLocaleLowerCase();\n        filename2 = filename2.toLocaleLowerCase();\n\n        function cmpExt() {\n            var ext1 = getFileExtension(filename1),\n                ext2 = getFileExtension(filename2);\n            return ext1.localeCompare(ext2, lang, {numeric: true});\n        }\n\n        function cmpNames() {\n            return _cmpNames(filename1, filename2, lang);\n        }\n\n        return extFirst ? (cmpExt() || cmpNames()) : (cmpNames() || cmpExt());\n    }\n\n    /**\n     * Compares two paths segment-by-segment, used for sorting. When two files share a path prefix,\n     * the less deeply nested one is sorted earlier in the list. Sorts files within the same parent\n     * folder based on `compareFilenames()`.\n     * @param {string} path1\n     * @param {string} path2\n     * @return {number} -1, 0, or 1 depending on whether path1 is less than, equal to, or greater than\n     *     path2 according to this ordering.\n     */\n    function comparePaths(path1, path2) {\n        var entryName1, entryName2,\n            pathParts1 = path1.split("/"),\n            pathParts2 = path2.split("/"),\n            length     = Math.min(pathParts1.length, pathParts2.length),\n            folders1   = pathParts1.length - 1,\n            folders2   = pathParts2.length - 1,\n            index      = 0;\n\n        while (index < length) {\n            entryName1 = pathParts1[index];\n            entryName2 = pathParts2[index];\n\n            if (entryName1 !== entryName2) {\n                if (index < folders1 && index < folders2) {\n                    return entryName1.toLocaleLowerCase().localeCompare(entryName2.toLocaleLowerCase());\n                } else if (index >= folders1 && index >= folders2) {\n                    return compareFilenames(entryName1, entryName2);\n                }\n                return (index >= folders1 && index < folders2) ? -1 : 1;\n            }\n            index++;\n        }\n        return 0;\n    }\n\n    /**\n     * @param {string} path Native path in the format used by FileSystemEntry.fullPath\n     * @return {string} URI-encoded version suitable for appending to \'file:///`. It\'s not safe to use encodeURI()\n     *     directly since it doesn\'t escape chars like "#".\n     */\n    function encodeFilePath(path) {\n        var pathArray = path.split("/");\n        pathArray = pathArray.map(function (subPath) {\n            return encodeURIComponent(subPath);\n        });\n        return pathArray.join("/");\n    }\n\n    // Asynchronously load DocumentCommandHandlers\n    // This avoids a temporary circular dependency created\n    // by relocating showFileOpenError() until deprecation is over\n    require(["document/DocumentCommandHandlers"], function (dchModule) {\n        DocumentCommandHandlers = dchModule;\n    });\n\n    // Asynchronously load LiveDevelopmentUtils\n    // This avoids a temporary circular dependency created\n    // by relocating isStaticHtmlFileExt() until deprecation is over\n    require(["LiveDevelopment/LiveDevelopmentUtils"], function (lduModule) {\n        LiveDevelopmentUtils = lduModule;\n    });\n\n    // Define public API\n    exports.LINE_ENDINGS_CRLF              = LINE_ENDINGS_CRLF;\n    exports.LINE_ENDINGS_LF                = LINE_ENDINGS_LF;\n    exports.getPlatformLineEndings         = getPlatformLineEndings;\n    exports.sniffLineEndings               = sniffLineEndings;\n    exports.translateLineEndings           = translateLineEndings;\n    exports.showFileOpenError              = showFileOpenError;\n    exports.getFileErrorString             = getFileErrorString;\n    exports.makeDialogFileList             = makeDialogFileList;\n    exports.readAsText                     = readAsText;\n    exports.writeText                      = writeText;\n    exports.convertToNativePath            = convertToNativePath;\n    exports.convertWindowsPathToUnixPath   = convertWindowsPathToUnixPath;\n    exports.getNativeBracketsDirectoryPath = getNativeBracketsDirectoryPath;\n    exports.getNativeModuleDirectoryPath   = getNativeModuleDirectoryPath;\n    exports.stripTrailingSlash             = stripTrailingSlash;\n    exports.isStaticHtmlFileExt            = isStaticHtmlFileExt;\n    exports.getDirectoryPath               = getDirectoryPath;\n    exports.getParentPath                  = getParentPath;\n    exports.getBaseName                    = getBaseName;\n    exports.getRelativeFilename            = getRelativeFilename;\n    exports.getFilenameWithoutExtension    = getFilenameWithoutExtension;\n    exports.getFileExtension               = getFileExtension;\n    exports.getSmartFileExtension          = getSmartFileExtension;\n    exports.compareFilenames               = compareFilenames;\n    exports.comparePaths                   = comparePaths;\n    exports.MAX_FILE_SIZE                  = MAX_FILE_SIZE;\n    exports.encodeFilePath                 = encodeFilePath;\n});\n\n//# sourceURL=/file/FileUtils.js'),
eval('define(\'text!language/languages.json\',[],function () { return \'{\\n    "unknown": {\\n        "name": "Text",\\n        "mode": ["null", "text/plain"]\\n    },\\n    \\n    "groovy": {\\n        "name": "Groovy",\\n        "mode": "groovy",\\n        "fileExtensions": ["groovy"],\\n        "blockComment": ["/*", "*/"],\\n        "lineComment": ["//"]\\n    },\\n   \\n    "properties": {\\n        "name": "Properties",\\n        "mode": ["properties", "text/x-properties"],\\n        "fileExtensions": ["ini", "properties"]\\n    },\\n\\n    "css": {\\n        "name": "CSS",\\n        "mode": "css",\\n        "fileExtensions": ["css", "css.erb"],\\n        "blockComment": ["/*", "*/"]\\n    },\\n\\n    "scss": {\\n        "name": "SCSS",\\n        "mode": ["css", "text/x-scss"],\\n        "fileExtensions": ["scss", "scss.erb"],\\n        "blockComment": ["/*", "*/"],\\n        "lineComment": ["//"]\\n    },\\n\\n    "stylus": {\\n        "name": "Stylus",\\n        "mode": ["stylus", "text/x-styl"],\\n        "fileExtensions": ["styl"],\\n        "blockComment": ["/*", "*/"],\\n        "lineComment": ["//"]\\n    },\\n\\n    "html": {\\n        "name": "HTML",\\n        "mode": ["htmlmixed", "text/x-brackets-html"],\\n        "fileExtensions": ["html", "htm", "shtm", "shtml", "xhtml", "cfm", "cfml", "cfc", "dhtml", "xht", "tpl", "twig", "kit", "jsp", "aspx", "ascx", "asp", "master", "cshtml", "vbhtml"],\\n        "blockComment": ["<!--", "-->"]\\n    },\\n    \\n    "ejs": {\\n        "name": "EJS",\\n        "mode": ["htmlembedded", "application/x-ejs"],\\n        "fileExtensions": ["ejs", "dust"],\\n        "blockComment": ["<!--", "-->"]\\n    },\\n    \\n    "erb_html": {\\n        "name": "Embedded Ruby",\\n        "mode": ["htmlembedded", "application/x-erb"],\\n        "fileExtensions": ["erb", "html.erb", "htm.erb"],\\n        "blockComment": ["<!--", "-->"]\\n    },\\n\\n    "javascript": {\\n        "name": "JavaScript",\\n        "mode": "javascript",\\n        "fileExtensions": ["js", "jsx", "js.erb", "jsm", "_js"],\\n        "blockComment": ["/*", "*/"],\\n        "lineComment": ["//"]\\n    },\\n\\n    "dart": {\\n        "name": "Dart",\\n        "mode": ["dart", "application/dart"],\\n        "fileExtensions": ["dart"],\\n        "blockComment": ["/*", "*/"],\\n        "lineComment": ["//"]\\n    },\\n\\n    "vbscript": {\\n        "name": "VBScript",\\n        "mode": "vbscript",\\n        "fileExtensions": ["vbs"],\\n        "lineComment": ["\\\'", "REM"]\\n    },\\n\\n    "vb": {\\n        "name": "VB",\\n        "mode": ["vb", "text/x-vb"],\\n        "fileExtensions": ["vb"],\\n        "lineComment": ["\\\'"]\\n    },\\n\\n    "json": {\\n        "name": "JSON",\\n        "mode": ["javascript", "application/json"],\\n        "fileExtensions": ["json"],\\n        "fileNames": [".jshintrc", ".bowerrc"]\\n    },\\n\\n    "xml": {\\n        "name": "XML",\\n        "mode": "xml",\\n        "fileExtensions": ["xml", "wxs", "wxl", "wsdl", "rss", "atom", "rdf", "xslt", "xsl", "xul", "xsd", "xbl", "mathml", "config", "plist", "xaml"],\\n        "blockComment": ["<!--", "-->"]\\n    },\\n\\n    "svg": {\\n        "name": "SVG",\\n        "mode": ["xml", "image/svg+xml"],\\n        "fileExtensions": ["svg"],\\n        "blockComment": ["<!--", "-->"]\\n    },\\n\\n    "php": {\\n        "name": "PHP",\\n        "mode": "php",\\n        "fileExtensions": ["php", "php3", "php4", "php5", "phtm", "phtml", "ctp"],\\n        "blockComment": ["/*", "*/"],\\n        "lineComment": ["//", "#"]\\n    },\\n\\n    "c": {\\n        "name": "C",\\n        "mode": ["clike", "text/x-csrc"],\\n        "fileExtensions": ["c", "h", "i"],\\n        "blockComment": ["/*", "*/"],\\n        "lineComment": ["//"]\\n    },\\n\\n    "cpp": {\\n        "name": "C++",\\n        "mode": ["clike", "text/x-c++src"],\\n        "fileExtensions": ["cc", "cp", "cpp", "c++", "cxx", "hh", "hpp", "hxx", "h++", "ii", "ino"],\\n        "blockComment": ["/*", "*/"],\\n        "lineComment": ["//"]\\n    },\\n\\n    "csharp": {\\n        "name": "C#",\\n        "mode": ["clike", "text/x-csharp"],\\n        "fileExtensions": ["cs", "asax", "ashx"],\\n        "blockComment": ["/*", "*/"],\\n        "lineComment": ["//"]\\n    },\\n\\n    "java": {\\n        "name": "Java",\\n        "mode": ["clike", "text/x-java"],\\n        "fileExtensions": ["java"],\\n        "blockComment": ["/*", "*/"],\\n        "lineComment": ["//"]\\n    },\\n\\n    "scala": {\\n        "name": "Scala",\\n        "mode": ["clike", "text/x-scala"],\\n        "fileExtensions": ["scala", "sbt"],\\n        "blockComment": ["/*", "*/"],\\n        "lineComment": ["//"]\\n    },\\n\\n    "coffeescript": {\\n        "name": "CoffeeScript",\\n        "mode": "coffeescript",\\n        "fileExtensions": ["coffee", "cf", "cson", "_coffee"],\\n        "fileNames": ["Cakefile"],\\n        "blockComment": ["###", "###"],\\n        "lineComment": ["#"]\\n    },\\n\\n    "clojure": {\\n        "name": "Clojure",\\n        "mode": "clojure",\\n        "fileExtensions": ["clj", "cljs", "cljx"],\\n        "lineComment": [";", ";;"]\\n    },\\n\\n    "perl": {\\n        "name": "Perl",\\n        "mode": "perl",\\n        "fileExtensions": ["pl", "pm", "t"],\\n        "lineComment": ["#"]\\n    },\\n\\n    "ruby": {\\n        "name": "Ruby",\\n        "mode": "ruby",\\n        "fileExtensions": ["rb", "ru", "gemspec", "rake"],\\n        "fileNames": ["Gemfile", "Rakefile", "Guardfile", "Vagrantfile"],\\n        "lineComment": ["#"]\\n    },\\n\\n    "python": {\\n        "name": "Python",\\n        "mode": "python",\\n        "fileExtensions": ["py", "pyw", "wsgi"],\\n        "lineComment": ["#"]\\n    },\\n\\n    "sass": {\\n        "name": "SASS",\\n        "mode": "sass",\\n        "fileExtensions": ["sass"],\\n        "blockComment": ["/*", "*/"],\\n        "lineComment": ["//"]\\n    },\\n\\n    "lua": {\\n        "name": "Lua",\\n        "mode": "lua",\\n        "fileExtensions": ["lua"],\\n        "blockComment": ["--[[", "]]"],\\n        "lineComment": ["--"]\\n    },\\n\\n    "sql": {\\n        "name": "SQL",\\n        "mode": ["sql", "text/x-mysql"],\\n        "fileExtensions": ["sql"]\\n    },\\n\\n    "diff": {\\n        "name": "Diff",\\n        "mode": "diff",\\n        "fileExtensions": ["diff", "patch"]\\n    },\\n\\n    "markdown": {\\n        "name": "Markdown",\\n        "mode": "markdown",\\n        "fileExtensions": ["md", "markdown", "mdown", "mkdn"],\\n        "blockComment": ["<!--", "-->"]\\n    },\\n\\n    "gfm": {\\n        "name": "Markdown (GitHub)",\\n        "mode": "gfm"\\n    },\\n\\n    "yaml": {\\n        "name": "YAML",\\n        "mode": "yaml",\\n        "fileExtensions": ["yaml", "yml"],\\n        "lineComment": ["#"]\\n    },\\n\\n    "hx": {\\n        "name": "Haxe",\\n        "mode": "haxe",\\n        "fileExtensions": ["hx"],\\n        "blockComment": ["/*", "*/"],\\n        "lineComment": ["//"]\\n    },\\n\\n    "bash": {\\n        "name": "Bash",\\n        "mode": ["shell", "text/x-sh"],\\n        "fileExtensions": ["sh", "command", "bash"],\\n        "lineComment": ["#"]\\n    },\\n  \\n    "image": {\\n        "name": "Image",\\n        "fileExtensions": ["gif", "png", "jpe", "jpeg", "jpg", "ico", "bmp", "webp"],\\n        "isBinary": true\\n    },\\n    \\n    "audio": {\\n        "name": "Audio",\\n        "fileExtensions": ["mp3", "wav", "aif", "aiff", "ogg"],\\n        "isBinary": true\\n    },\\n    \\n    "binary": {\\n        "name": "Other Binary",\\n        "fileExtensions": [\\n            "a", "ai", "avi", "bin", "cab", "com", "db", "dll", "dmg",\\n            "doc", "docx", "dot", "dotx", "dsym", "dylib", "egg", "epub", "eot",\\n            "exe", "flv", "gz", "gzip", "htmz", "htmlz", "ipch", "iso", "jar",\\n            "jsz", "lib", "mpeg", "mpg", "mp4", "msi", "node", "o", "obj", "odc",\\n            "odb", "odf", "odg", "odp", "ods", "odt", "otf", "pak", "pdb", "pdf",\\n            "pdi", "ppt", "pptx", "psd", "rar", "sdf", "so", "sqlite", "suo", "svgz",\\n            "swf", "tar", "tif", "tiff", "ttf", "woff", "xls", "xlsx", "zip"\\n        ],\\n        "isBinary": true\\n    },\\n\\n    "haskell": {\\n        "name": "Haskell",\\n        "mode": "haskell",\\n        "fileExtensions": ["hs"],\\n        "blockComment": ["{-", "-}"],\\n        "lineComment": ["--"]\\n    },\\n    \\n    "turtle": {\\n        "name": "RDF Turtle",\\n        "mode": "turtle",\\n        "fileExtensions": ["ttl"],\\n        "lineComment": ["#"]\\n    }\\n}\\n\';});\n\n//# sourceURL=/text!language/languages.json'),eval('/*\n * Copyright (c) 2012 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */\n/*global define, $ */\n/*unittests: LanguageManager*/\n\n/**\n * LanguageManager provides access to the languages supported by Brackets\n *\n * To find out which languages we support by default, have a look at languages.json.\n *\n * To get access to an existing language, call getLanguage():\n *\n *     var language = LanguageManager.getLanguage("<id>");\n *\n * To define your own languages, call defineLanguage():\n *\n *     LanguageManager.defineLanguage("haskell", {\n *         name: "Haskell",\n *         mode: "haskell",\n *         fileExtensions: ["hs"],\n *         blockComment: ["{-", "-}"],\n *         lineComment: ["--"]\n *     });\n *\n * To use that language and its related mode, wait for the returned promise to be resolved:\n *\n *     LanguageManager.defineLanguage("haskell", definition).done(function (language) {\n *         console.log("Language " + language.getName() + " is now available!");\n *     });\n *\n * The extension can also contain dots:\n *\n *     LanguageManager.defineLanguage("literatecoffeescript", {\n *         name: "Literate CoffeeScript",\n *         mode: "coffeescript",\n *         fileExtensions: ["litcoffee", "coffee.md"]\n *     });\n *\n * You can also specify file names:\n *\n *     LanguageManager.defineLanguage("makefile", {\n *         name: "Make",\n *         mode: ["null", "text/plain"],\n *         fileNames: ["Makefile"]\n *     });\n *\n * You can combine file names and extensions, or not define them at all.\n *\n * You can also refine an existing language:\n *\n *     var language = LanguageManager.getLanguage("haskell");\n *     language.setLineCommentSyntax(["--"]);\n *     language.setBlockCommentSyntax("{-", "-}");\n *     language.addFileExtension("lhs");\n *\n * Some CodeMirror modes define variations of themselves. They are called MIME modes.\n * To find existing MIME modes, search for "CodeMirror.defineMIME" in thirdparty/CodeMirror/mode\n * For instance, C++, C# and Java all use the clike (C-like) mode with different settings and a different MIME name.\n * You can refine the mode definition by specifying the MIME mode as well:\n *\n *     LanguageManager.defineLanguage("csharp", {\n *         name: "C#",\n *         mode: ["clike", "text/x-csharp"],\n *         ...\n *     });\n *\n * Defining the base mode is still necessary to know which file to load.\n * However, language.getMode() will return just the MIME mode if one was\n * specified.\n *\n * If you need to configure a mode, you can just create a new MIME mode and use that:\n *\n *     CodeMirror.defineMIME("text/x-brackets-html", {\n *         "name": "htmlmixed",\n *         "scriptTypes": [{"matches": /\\/x-handlebars-template|\\/x-mustache/i,\n *                        "mode": null}]\n *     });\n *\n *     LanguageManager.defineLanguage("html", {\n *         name: "HTML",\n *         mode: ["htmlmixed", "text/x-brackets-html"],\n *         ...\n *     });\n *\n * If a mode is not shipped with our CodeMirror distribution, you need to first load it yourself.\n * If the mode is part of our CodeMirror distribution, it gets loaded automatically.\n *\n * You can also defines binary file types, i.e. Brackets supports image files by default,\n * such as *.jpg, *.png etc.\n * Binary files do not require mode because modes are specific to CodeMirror, which\n * only handles text based file types.\n * To register a binary language the isBinary flag must be set, i.e.\n *\n *     LanguageManager.defineLanguage("audio", {\n *         name: "Audio",\n *         fileExtensions: ["mp3", "wav", "aif", "aiff", "ogg"],\n *         isBinary: true\n *     });\n *\n *\n * LanguageManager dispatches two events:\n *\n *  - languageAdded -- When any new Language is added. 2nd arg is the new Language.\n *  - languageModified -- When the attributes of a Language change, or when the Language gains or loses\n *          file extension / filename mappings. 2nd arg is the modified Language.\n */\ndefine(\'language/LanguageManager\',[\'require\',\'exports\',\'module\',\'thirdparty/CodeMirror/lib/codemirror\',\'utils/EventDispatcher\',\'utils/Async\',\'file/FileUtils\',\'strings\',\'text!language/languages.json\',\'thirdparty/lodash\'],function (require, exports, module) {\n    "use strict";\n\n\n    // Dependencies\n    var CodeMirror            = require("thirdparty/CodeMirror/lib/codemirror"),\n        EventDispatcher       = require("utils/EventDispatcher"),\n        Async                 = require("utils/Async"),\n        FileUtils             = require("file/FileUtils"),\n        Strings               = require("strings"),\n        _defaultLanguagesJSON = require("text!language/languages.json"),\n        _                     = require("thirdparty/lodash"),\n\n        // PreferencesManager is loaded near the end of the file\n        PreferencesManager;\n\n    // State\n    var _fallbackLanguage               = null,\n        _pendingLanguages               = {},\n        _languages                      = {},\n        _baseFileExtensionToLanguageMap = {},\n        _fileExtensionToLanguageMap     = Object.create(_baseFileExtensionToLanguageMap),\n        _fileNameToLanguageMap          = {},\n        _filePathToLanguageMap          = {},\n        _modeToLanguageMap              = {},\n        _ready;\n\n    // Constants\n\n    var _EXTENSION_MAP_PREF = "language.fileExtensions",\n        _NAME_MAP_PREF      = "language.fileNames";\n\n    // Tracking for changes to mappings made by preferences\n    var _prefState = {};\n\n    _prefState[_EXTENSION_MAP_PREF] = {\n        last: {},\n        overridden: {},\n        add: "addFileExtension",\n        remove: "removeFileExtension",\n        get: "getLanguageForExtension"\n    };\n\n    _prefState[_NAME_MAP_PREF] = {\n        last: {},\n        overridden: {},\n        add: "addFileName",\n        remove: "removeFileName",\n        get: "getLanguageForPath"\n    };\n\n    // Helper functions\n\n    /**\n     * Checks whether value is a non-empty string. Reports an error otherwise.\n     * If no deferred is passed, console.error is called.\n     * Otherwise the deferred is rejected with the error message.\n     * @param {*}                value         The value to validate\n     * @param {!string}          description   A helpful identifier for value\n     * @param {?jQuery.Deferred} deferred      A deferred to reject with the error message in case of an error\n     * @return {boolean} True if the value is a non-empty string, false otherwise\n     */\n    function _validateNonEmptyString(value, description, deferred) {\n        var reportError = deferred ? deferred.reject : console.error;\n\n        // http://stackoverflow.com/questions/1303646/check-whether-variable-is-number-or-string-in-javascript\n        if (Object.prototype.toString.call(value) !== "[object String]") {\n            reportError(description + " must be a string");\n            return false;\n        }\n        if (value === "") {\n            reportError(description + " must not be empty");\n            return false;\n        }\n        return true;\n    }\n\n    /**\n     * Monkey-patch CodeMirror to prevent modes from being overwritten by extensions.\n     * We may rely on the tokens provided by some of these modes.\n     */\n    function _patchCodeMirror() {\n        var _original_CodeMirror_defineMode = CodeMirror.defineMode;\n        function _wrapped_CodeMirror_defineMode(name) {\n            if (CodeMirror.modes[name]) {\n                console.error("There already is a CodeMirror mode with the name \\"" + name + "\\"");\n                return;\n            }\n            _original_CodeMirror_defineMode.apply(CodeMirror, arguments);\n        }\n        CodeMirror.defineMode = _wrapped_CodeMirror_defineMode;\n    }\n\n    /**\n     * Adds a global mode-to-language association.\n     * @param {!string} mode The mode to associate the language with\n     * @param {!Language} language The language to associate with the mode\n     */\n    function _setLanguageForMode(mode, language) {\n        if (_modeToLanguageMap[mode]) {\n            console.warn("CodeMirror mode \\"" + mode + "\\" is already used by language " + _modeToLanguageMap[mode]._name + " - cannot fully register language " + language._name +\n                         " using the same mode. Some features will treat all content with this mode as language " + _modeToLanguageMap[mode]._name);\n            return;\n        }\n\n        _modeToLanguageMap[mode] = language;\n    }\n\n    /**\n     * Resolves a language ID to a Language object.\n     * File names have a higher priority than file extensions.\n     * @param {!string} id Identifier for this language: lowercase letters, digits, and _ separators (e.g. "cpp", "foo_bar", "c99")\n     * @return {Language} The language with the provided identifier or undefined\n     */\n    function getLanguage(id) {\n        return _languages[id];\n    }\n\n    /**\n     * Resolves a file extension to a Language object.\n     * *Warning:* it is almost always better to use getLanguageForPath(), since Language can depend\n     * on file name and even full path. Use this API only if no relevant file/path exists.\n     * @param {!string} extension Extension that language should be resolved for\n     * @return {?Language} The language for the provided extension or null if none exists\n     */\n    function getLanguageForExtension(extension) {\n        return _fileExtensionToLanguageMap[extension.toLowerCase()];\n    }\n\n    /**\n     * Resolves a file path to a Language object.\n     * @param {!string} path Path to the file to find a language for\n     * @param {?boolean} ignoreOverride If set to true will cause the lookup to ignore any\n     *      overrides and return default binding. By default override is not ignored.\n     *\n     * @return {Language} The language for the provided file type or the fallback language\n     */\n    function getLanguageForPath(path, ignoreOverride) {\n        var fileName,\n            language = _filePathToLanguageMap[path],\n            extension,\n            parts;\n\n        // if there\'s an override, return it\n        if (!ignoreOverride && language) {\n            return language;\n        }\n\n        fileName = FileUtils.getBaseName(path).toLowerCase();\n        language = _fileNameToLanguageMap[fileName];\n\n        // If no language was found for the file name, use the file extension instead\n        if (!language) {\n            // Split the file name into parts:\n            //   "foo.coffee.md"   => ["foo", "coffee", "md"]\n            //   ".profile.bak"    => ["", "profile", "bak"]\n            //   "1. Vacation.txt" => ["1", " Vacation", "txt"]\n            parts = fileName.split(".");\n\n            // A leading dot does not indicate a file extension, but marks the file as hidden => remove it\n            if (parts[0] === "") {\n                // ["", "profile", "bak"] => ["profile", "bak"]\n                parts.shift();\n            }\n\n            // The first part is assumed to be the title, not the extension => remove it\n            //   ["foo", "coffee", "md"]   => ["coffee", "md"]\n            //   ["profile", "bak"]        => ["bak"]\n            //   ["1", " Vacation", "txt"] => [" Vacation", "txt"]\n            parts.shift();\n\n            // Join the remaining parts into a file extension until none are left or a language was found\n            while (!language && parts.length) {\n                // First iteration:\n                //   ["coffee", "md"]     => "coffee.md"\n                //   ["bak"]              => "bak"\n                //   [" Vacation", "txt"] => " Vacation.txt"\n                // Second iteration (assuming no language was found for "coffee.md"):\n                //   ["md"]  => "md"\n                //   ["txt"] => "txt"\n                extension = parts.join(".");\n                language  = _fileExtensionToLanguageMap[extension];\n                // Remove the first part\n                // First iteration:\n                //   ["coffee", "md"]     => ["md"]\n                //   ["bak"]              => []\n                //   [" Vacation", "txt"] => ["txt"]\n                // Second iteration:\n                //   ["md"]  => []\n                //   ["txt"] => []\n                parts.shift();\n            }\n        }\n\n        return language || _fallbackLanguage;\n    }\n\n    /**\n     * Returns a map of all the languages currently defined in the LanguageManager. The key to\n     * the map is the language id and the value is the language object.\n     *\n     * @return {Object.<string, Language>} A map containing all of the\n     *      languages currently defined.\n     */\n    function getLanguages() {\n        return $.extend({}, _languages); // copy to prevent modification\n    }\n\n    /**\n     * Resolves a CodeMirror mode to a Language object.\n     * @param {!string} mode CodeMirror mode\n     * @return {Language} The language for the provided mode or the fallback language\n     */\n    function _getLanguageForMode(mode) {\n        var language = _modeToLanguageMap[mode];\n        if (language) {\n            return language;\n        }\n\n        // In case of unsupported languages\n        console.log("Called LanguageManager._getLanguageForMode with a mode for which no language has been registered:", mode);\n        return _fallbackLanguage;\n    }\n\n    /**\n     * @private\n     * Notify listeners when a language is added\n     * @param {!Language} language The new language\n     */\n    function _triggerLanguageAdded(language) {\n        // finally, store language to _language map\n        _languages[language.getId()] = language;\n        exports.trigger("languageAdded", language);\n    }\n\n    /**\n     * @private\n     * Notify listeners when a language is modified\n     * @param {!Language} language The modified language\n     */\n    function _triggerLanguageModified(language) {\n        exports.trigger("languageModified", language);\n    }\n\n    /**\n     * Adds a language mapping for the specified fullPath. If language is falsy (null or undefined), the mapping\n     * is removed. The override is NOT persisted across Brackets sessions.\n     *\n     * @param {!fullPath} fullPath absolute path of the file\n     * @param {?object} language language to associate the file with or falsy value to remove any existing override\n     */\n    function setLanguageOverrideForPath(fullPath, language) {\n        var oldLang = getLanguageForPath(fullPath);\n        if (!language) {\n            delete _filePathToLanguageMap[fullPath];\n        } else {\n            _filePathToLanguageMap[fullPath] = language;\n        }\n        var newLang = getLanguageForPath(fullPath);\n\n        // Old language changed since this path is no longer mapped to it\n        _triggerLanguageModified(oldLang);\n        // New language changed since a path is now mapped to it that wasn\'t before\n        _triggerLanguageModified(newLang);\n    }\n\n    /**\n     * Resets all the language overrides for file paths. Used by unit tests only.\n     */\n    function _resetPathLanguageOverrides() {\n        _filePathToLanguageMap = {};\n    }\n\n    /**\n     * Get the file extension (excluding ".") given a path OR a bare filename.\n     * Returns "" for names with no extension.\n     * If the only `.` in the file is the first character,\n     * returns "" as this is not considered an extension.\n     * This method considers known extensions which include `.` in them.\n     *\n     * @param {string} fullPath full path to a file or directory\n     * @return {string} Returns the extension of a filename or empty string if\n     * the argument is a directory or a filename with no extension\n     */\n    function getCompoundFileExtension(fullPath) {\n        var baseName = FileUtils.getBaseName(fullPath),\n            parts = baseName.split(".");\n\n        // get rid of file name\n        parts.shift();\n        if (baseName[0] === ".") {\n            // if starts with a `.`, then still consider it as file name\n            parts.shift();\n        }\n\n        var extension = [parts.pop()], // last part is always an extension\n            i = parts.length;\n        while (i--) {\n            if (getLanguageForExtension(parts[i])) {\n                extension.unshift(parts[i]);\n            } else {\n                break;\n            }\n        }\n        return extension.join(".");\n    }\n\n\n\n    /**\n     * Model for a language.\n     * @constructor\n     */\n    function Language() {\n        this._fileExtensions    = [];\n        this._fileNames         = [];\n        this._modeToLanguageMap = {};\n        this._lineCommentSyntax = [];\n    }\n\n\n    /**\n     * Identifier for this language\n     * @type {string}\n     */\n    Language.prototype._id = null;\n\n    /**\n     * Human-readable name of this language\n     * @type {string}\n     */\n    Language.prototype._name = null;\n\n    /**\n     * CodeMirror mode for this language\n     * @type {string}\n     */\n    Language.prototype._mode = null;\n\n    /**\n     * File extensions that use this language\n     * @type {Array.<string>}\n     */\n    Language.prototype._fileExtensions = null;\n\n    /**\n     * File names for extensionless files that use this language\n     * @type {Array.<string>}\n     */\n    Language.prototype._fileNames = null;\n\n    /**\n     * Line comment syntax\n     * @type {Array.<string>}\n     */\n    Language.prototype._lineCommentSyntax = null;\n\n    /**\n     * Which language to use for what CodeMirror mode\n     * @type {Object.<string,Language>}\n     */\n    Language.prototype._modeToLanguageMap = null;\n\n    /**\n     * Block comment syntax\n     * @type {{ prefix: string, suffix: string }}\n     */\n    Language.prototype._blockCommentSyntax = null;\n\n    /**\n     * Whether or not the language is binary\n     * @type {boolean}\n     */\n    Language.prototype._isBinary = false;\n\n    /**\n     * Returns the identifier for this language.\n     * @return {string} The identifier\n     */\n    Language.prototype.getId = function () {\n        return this._id;\n    };\n\n    /**\n     * Sets the identifier for this language or prints an error to the console.\n     * @param {!string} id Identifier for this language: lowercase letters, digits, and _ separators (e.g. "cpp", "foo_bar", "c99")\n     * @return {boolean} Whether the ID was valid and set or not\n     */\n    Language.prototype._setId = function (id) {\n        if (!_validateNonEmptyString(id, "Language ID")) {\n            return false;\n        }\n        // Make sure the ID is a string that can safely be used universally by the computer - as a file name, as an object key, as part of a URL, etc.\n        // Hence we use "_" instead of "." since the latter often has special meaning\n        if (!id.match(/^[a-z0-9]+(_[a-z0-9]+)*$/)) {\n            console.error("Invalid language ID \\"" + id + "\\": Only groups of lower case letters and numbers are allowed, separated by underscores.");\n            return false;\n        }\n\n        this._id = id;\n        return true;\n    };\n\n    /**\n     * Returns the human-readable name of this language.\n     * @return {string} The name\n     */\n    Language.prototype.getName = function () {\n        return this._name;\n    };\n\n    /**\n     * Sets the human-readable name of this language or prints an error to the console.\n     * @param {!string} name Human-readable name of the language, as it\'s commonly referred to (e.g. "C++")\n     * @return {boolean} Whether the name was valid and set or not\n     */\n    Language.prototype._setName = function (name) {\n        if (!_validateNonEmptyString(name, "name")) {\n            return false;\n        }\n\n        this._name = name;\n        return true;\n    };\n\n    /**\n     * Returns the CodeMirror mode for this language.\n     * @return {string} The mode\n     */\n    Language.prototype.getMode = function () {\n        return this._mode;\n    };\n\n    /**\n     * Loads a mode and sets it for this language.\n     *\n     * @param {(string|Array.<string>)} mode  CodeMirror mode (e.g. "htmlmixed"), optionally paired with a MIME mode defined by\n     *      that mode (e.g. ["clike", "text/x-c++src"]). Unless the mode is located in thirdparty/CodeMirror/mode/<name>/<name>.js,\n     *      you need to first load it yourself.\n     * @return {$.Promise} A promise object that will be resolved when the mode is loaded and set\n     */\n    Language.prototype._loadAndSetMode = function (mode) {\n        var result      = new $.Deferred(),\n            self        = this,\n            mimeMode; // Mode can be an array specifying a mode plus a MIME mode defined by that mode ["clike", "text/x-c++src"]\n\n        if (Array.isArray(mode)) {\n            if (mode.length !== 2) {\n                result.reject("Mode must either be a string or an array containing two strings");\n                return result.promise();\n            }\n            mimeMode = mode[1];\n            mode = mode[0];\n        }\n\n        // mode must not be empty. Use "null" (the string "null") mode for plain text\n        if (!_validateNonEmptyString(mode, "mode", result)) {\n            result.reject();\n            return result.promise();\n        }\n\n        var finish = function () {\n            if (!CodeMirror.modes[mode]) {\n                result.reject("CodeMirror mode \\"" + mode + "\\" is not loaded");\n                return;\n            }\n\n            if (mimeMode) {\n                var modeConfig = CodeMirror.mimeModes[mimeMode];\n\n                if (!modeConfig) {\n                    result.reject("CodeMirror MIME mode \\"" + mimeMode + "\\" not found");\n                    return;\n                }\n            }\n\n            // This mode is now only about what to tell CodeMirror\n            // The base mode was only necessary to load the proper mode file\n            self._mode = mimeMode || mode;\n            self._wasModified();\n\n            result.resolve(self);\n        };\n\n        if (CodeMirror.modes[mode]) {\n            finish();\n        } else {\n            require(["thirdparty/CodeMirror/mode/" + mode + "/" + mode], finish);\n        }\n\n        return result.promise();\n    };\n\n    /**\n     * Returns an array of file extensions for this language.\n     * @return {Array.<string>} File extensions used by this language\n     */\n    Language.prototype.getFileExtensions = function () {\n        // Use concat to create a copy of this array, preventing external modification\n        return this._fileExtensions.concat();\n    };\n\n    /**\n     * Returns an array of file names for extensionless files that use this language.\n     * @return {Array.<string>} Extensionless file names used by this language\n     */\n    Language.prototype.getFileNames = function () {\n        // Use concat to create a copy of this array, preventing external modification\n        return this._fileNames.concat();\n    };\n\n    /**\n     * Adds one or more file extensions to this language.\n     * @param {!string|Array.<string>} extension A file extension (or array thereof) used by this language\n     */\n    Language.prototype.addFileExtension = function (extension) {\n        if (Array.isArray(extension)) {\n            extension.forEach(this._addFileExtension.bind(this));\n        } else {\n            this._addFileExtension(extension);\n        }\n    };\n    Language.prototype._addFileExtension = function (extension) {\n        // Remove a leading dot if present\n        if (extension.charAt(0) === ".") {\n            extension = extension.substr(1);\n        }\n\n        // Make checks below case-INsensitive\n        extension = extension.toLowerCase();\n\n        if (this._fileExtensions.indexOf(extension) === -1) {\n            this._fileExtensions.push(extension);\n\n            var language = _fileExtensionToLanguageMap[extension];\n            if (language) {\n                console.warn("Cannot register file extension \\"" + extension + "\\" for " + this._name + ", it already belongs to " + language._name);\n            } else {\n                _fileExtensionToLanguageMap[extension] = this;\n            }\n\n            this._wasModified();\n        }\n    };\n\n    /**\n     * Unregisters one or more file extensions from this language.\n     * @param {!string|Array.<string>} extension File extension (or array thereof) to stop using for this language\n     */\n    Language.prototype.removeFileExtension = function (extension) {\n        if (Array.isArray(extension)) {\n            extension.forEach(this._removeFileExtension.bind(this));\n        } else {\n            this._removeFileExtension(extension);\n        }\n    };\n    Language.prototype._removeFileExtension = function (extension) {\n        // Remove a leading dot if present\n        if (extension.charAt(0) === ".") {\n            extension = extension.substr(1);\n        }\n\n        // Make checks below case-INsensitive\n        extension = extension.toLowerCase();\n\n        var index = this._fileExtensions.indexOf(extension);\n        if (index !== -1) {\n            this._fileExtensions.splice(index, 1);\n\n            delete _fileExtensionToLanguageMap[extension];\n\n            this._wasModified();\n        }\n    };\n\n    /**\n     * Adds one or more file names to the language which is used to match files that don\'t have extensions like "Makefile" for example.\n     * @param {!string|Array.<string>} extension An extensionless file name (or array thereof) used by this language\n     */\n    Language.prototype.addFileName = function (name) {\n        if (Array.isArray(name)) {\n            name.forEach(this._addFileName.bind(this));\n        } else {\n            this._addFileName(name);\n        }\n    };\n    Language.prototype._addFileName = function (name) {\n        // Make checks below case-INsensitive\n        name = name.toLowerCase();\n\n        if (this._fileNames.indexOf(name) === -1) {\n            this._fileNames.push(name);\n\n            var language = _fileNameToLanguageMap[name];\n            if (language) {\n                console.warn("Cannot register file name \\"" + name + "\\" for " + this._name + ", it already belongs to " + language._name);\n            } else {\n                _fileNameToLanguageMap[name] = this;\n            }\n\n            this._wasModified();\n        }\n    };\n\n    /**\n     * Unregisters one or more file names from this language.\n     * @param {!string|Array.<string>} extension An extensionless file name (or array thereof) used by this language\n     */\n    Language.prototype.removeFileName = function (name) {\n        if (Array.isArray(name)) {\n            name.forEach(this._removeFileName.bind(this));\n        } else {\n            this._removeFileName(name);\n        }\n    };\n    Language.prototype._removeFileName = function (name) {\n        // Make checks below case-INsensitive\n        name = name.toLowerCase();\n\n        var index = this._fileNames.indexOf(name);\n        if (index !== -1) {\n            this._fileNames.splice(index, 1);\n\n            delete _fileNameToLanguageMap[name];\n\n            this._wasModified();\n        }\n    };\n\n    /**\n     * Returns whether the line comment syntax is defined for this language.\n     * @return {boolean} Whether line comments are supported\n     */\n    Language.prototype.hasLineCommentSyntax = function () {\n        return this._lineCommentSyntax.length > 0;\n    };\n\n    /**\n     * Returns an array of prefixes to use for line comments.\n     * @return {Array.<string>} The prefixes\n     */\n    Language.prototype.getLineCommentPrefixes = function () {\n        return this._lineCommentSyntax;\n    };\n\n    /**\n     * Sets the prefixes to use for line comments in this language or prints an error to the console.\n     * @param {!(string|Array.<string>)} prefix Prefix string or an array of prefix strings\n     *   to use for line comments (e.g. "//" or ["//", "#"])\n     * @return {boolean} Whether the syntax was valid and set or not\n     */\n    Language.prototype.setLineCommentSyntax = function (prefix) {\n        var prefixes = Array.isArray(prefix) ? prefix : [prefix];\n        var i;\n\n        if (prefixes.length) {\n            this._lineCommentSyntax = [];\n            for (i = 0; i < prefixes.length; i++) {\n                _validateNonEmptyString(String(prefixes[i]), Array.isArray(prefix) ? "prefix[" + i + "]" : "prefix");\n\n                this._lineCommentSyntax.push(prefixes[i]);\n            }\n            this._wasModified();\n        } else {\n            console.error("The prefix array should not be empty");\n        }\n\n        return true;\n    };\n\n    /**\n     * Returns whether the block comment syntax is defined for this language.\n     * @return {boolean} Whether block comments are supported\n     */\n    Language.prototype.hasBlockCommentSyntax = function () {\n        return Boolean(this._blockCommentSyntax);\n    };\n\n    /**\n     * Returns the prefix to use for block comments.\n     * @return {string} The prefix\n     */\n    Language.prototype.getBlockCommentPrefix = function () {\n        return this._blockCommentSyntax && this._blockCommentSyntax.prefix;\n    };\n\n    /**\n     * Returns the suffix to use for block comments.\n     * @return {string} The suffix\n     */\n    Language.prototype.getBlockCommentSuffix = function () {\n        return this._blockCommentSyntax && this._blockCommentSyntax.suffix;\n    };\n\n    /**\n     * Sets the prefix and suffix to use for blocks comments in this language or prints an error to the console.\n     * @param {!string} prefix Prefix string to use for block comments (e.g. "<!--")\n     * @param {!string} suffix Suffix string to use for block comments (e.g. "-->")\n     * @return {boolean} Whether the syntax was valid and set or not\n     */\n    Language.prototype.setBlockCommentSyntax = function (prefix, suffix) {\n        if (!_validateNonEmptyString(prefix, "prefix") || !_validateNonEmptyString(suffix, "suffix")) {\n            return false;\n        }\n\n        this._blockCommentSyntax = { prefix: prefix, suffix: suffix };\n        this._wasModified();\n\n        return true;\n    };\n\n    /**\n     * Returns either a language associated with the mode or the fallback language.\n     * Used to disambiguate modes used by multiple languages.\n     * @param {!string} mode The mode to associate the language with\n     * @return {Language} This language if it uses the mode, or whatever {@link #_getLanguageForMode} returns\n     */\n    Language.prototype.getLanguageForMode = function (mode) {\n        if (mode === this._mode) {\n            return this;\n        }\n        return this._modeToLanguageMap[mode] || _getLanguageForMode(mode);\n    };\n\n    /**\n     * Overrides a mode-to-language association for this particular language only or prints an error to the console.\n     * Used to disambiguate modes used by multiple languages.\n     * @param {!string} mode The mode to associate the language with\n     * @param {!Language} language The language to associate with the mode\n     * @return {boolean} Whether the mode-to-language association was valid and set or not\n     * @private\n     */\n    Language.prototype._setLanguageForMode = function (mode, language) {\n        if (mode === this._mode && language !== this) {\n            console.error("A language must always map its mode to itself");\n            return false;\n        }\n\n        this._modeToLanguageMap[mode] = language;\n        this._wasModified();\n\n        return true;\n    };\n\n    /**\n     * Determines whether this is the fallback language or not\n     * @return {boolean} True if this is the fallback language, false otherwise\n     */\n    Language.prototype.isFallbackLanguage = function () {\n        return this === _fallbackLanguage;\n    };\n\n    /**\n     * Trigger the "languageModified" event if this language is registered already\n     * @see #_triggerLanguageModified\n     * @private\n     */\n    Language.prototype._wasModified = function () {\n        if (_languages[this._id]) {\n            _triggerLanguageModified(this);\n        }\n    };\n\n    /**\n     * Indicates whether or not the language is binary (e.g., image or audio).\n     * @return {boolean}\n     */\n    Language.prototype.isBinary = function () {\n        return this._isBinary;\n    };\n\n    /**\n     * Sets whether or not the language is binary\n     * @param {!boolean} isBinary\n     */\n    Language.prototype._setBinary = function (isBinary) {\n        this._isBinary = isBinary;\n    };\n\n    /**\n     * Defines a language.\n     *\n     * @param {!string}               id                        Unique identifier for this language: lowercase letters, digits, and _ separators (e.g. "cpp", "foo_bar", "c99")\n     * @param {!Object}               definition                An object describing the language\n     * @param {!string}               definition.name           Human-readable name of the language, as it\'s commonly referred to (e.g. "C++")\n     * @param {Array.<string>}        definition.fileExtensions List of file extensions used by this language (e.g. ["php", "php3"] or ["coffee.md"] - may contain dots)\n     * @param {Array.<string>}        definition.fileNames      List of exact file names (e.g. ["Makefile"] or ["package.json]). Higher precedence than file extension.\n     * @param {Array.<string>}        definition.blockComment   Array with two entries defining the block comment prefix and suffix (e.g. ["<!--", "-->"])\n     * @param {(string|Array.<string>)} definition.lineComment  Line comment prefixes (e.g. "//" or ["//", "#"])\n     * @param {(string|Array.<string>)} definition.mode         CodeMirror mode (e.g. "htmlmixed"), optionally with a MIME mode defined by that mode ["clike", "text/x-c++src"]\n     *                                                          Unless the mode is located in thirdparty/CodeMirror/mode/<name>/<name>.js, you need to first load it yourself.\n     *\n     * @return {$.Promise} A promise object that will be resolved with a Language object\n     **/\n    function defineLanguage(id, definition) {\n        var result = new $.Deferred();\n\n        if (_pendingLanguages[id]) {\n            result.reject("Language \\"" + id + "\\" is waiting to be resolved.");\n            return result.promise();\n        }\n        if (_languages[id]) {\n            result.reject("Language \\"" + id + "\\" is already defined");\n            return result.promise();\n        }\n\n        var language       = new Language(),\n            name           = definition.name,\n            fileExtensions = definition.fileExtensions,\n            fileNames      = definition.fileNames,\n            blockComment   = definition.blockComment,\n            lineComment    = definition.lineComment,\n            i,\n            l;\n\n        function _finishRegisteringLanguage() {\n            if (fileExtensions) {\n                for (i = 0, l = fileExtensions.length; i < l; i++) {\n                    language.addFileExtension(fileExtensions[i]);\n                }\n            }\n            // register language file names after mode has loaded\n            if (fileNames) {\n                for (i = 0, l = fileNames.length; i < l; i++) {\n                    language.addFileName(fileNames[i]);\n                }\n            }\n\n            language._setBinary(!!definition.isBinary);\n\n            // store language to language map\n            _languages[language.getId()] = language;\n        }\n\n        if (!language._setId(id) || !language._setName(name) ||\n                (blockComment && !language.setBlockCommentSyntax(blockComment[0], blockComment[1])) ||\n                (lineComment && !language.setLineCommentSyntax(lineComment))) {\n            result.reject();\n            return result.promise();\n        }\n\n\n        if (definition.isBinary) {\n            // add file extensions and store language to language map\n            _finishRegisteringLanguage();\n\n            result.resolve(language);\n            // Not notifying DocumentManager via event LanguageAdded, because DocumentManager\n            // does not care about binary files.\n        } else {\n            // track languages that are currently loading\n            _pendingLanguages[id] = language;\n\n            language._loadAndSetMode(definition.mode).done(function () {\n\n                // globally associate mode to language\n                _setLanguageForMode(language.getMode(), language);\n\n                // add file extensions and store language to language map\n                _finishRegisteringLanguage();\n\n                // fire an event to notify DocumentManager of the new language\n                _triggerLanguageAdded(language);\n\n                result.resolve(language);\n            }).fail(function (error) {\n                console.error(error);\n                result.reject(error);\n            }).always(function () {\n                // delete from pending languages after success and failure\n                delete _pendingLanguages[id];\n            });\n        }\n\n        return result.promise();\n    }\n\n    /**\n     * @private\n     *\n     * If a default file extension or name was overridden by a pref, restore it.\n     *\n     * @param {string} name Extension or filename that should be restored\n     * @param {{overridden: string, add: string}} prefState object for the pref that is currently being updated\n     */\n    function _restoreOverriddenDefault(name, state) {\n        if (state.overridden[name]) {\n            var language = getLanguage(state.overridden[name]);\n            language[state.add](name);\n            delete state.overridden[name];\n        }\n    }\n\n    /**\n     * @private\n     *\n     * Updates extension and filename mappings from languages based on the current preferences values.\n     *\n     * The preferences look like this in a prefs file:\n     *\n     * Map *.foo to javascript, *.vm to html\n     *\n     *     "language.fileExtensions": {\n     *         "foo": "javascript",\n     *         "vm": "html"\n     *     }\n     *\n     * Map "Gemfile" to ruby:\n     *\n     *     "language.fileNames": {\n     *         "Gemfile": "ruby"\n     *     }\n     */\n    function _updateFromPrefs(pref) {\n        var newMapping = PreferencesManager.get(pref),\n            newNames = Object.keys(newMapping),\n            state = _prefState[pref],\n            last = state.last,\n            overridden = state.overridden;\n\n        // Look for added and changed names (extensions or filenames)\n        newNames.forEach(function (name) {\n            var language;\n            if (newMapping[name] !== last[name]) {\n                if (last[name]) {\n                    language = getLanguage(last[name]);\n                    if (language) {\n                        language[state.remove](name);\n\n                        // If this name that was previously mapped was overriding a default\n                        // restore it now.\n                        _restoreOverriddenDefault(name, state);\n                    }\n                }\n\n                language = exports[state.get](name);\n                if (language) {\n                    language[state.remove](name);\n\n                    // We\'re removing a name that was defined in Brackets or an extension,\n                    // so keep track of how it used to be mapped.\n                    if (!overridden[name]) {\n                        overridden[name] = language.getId();\n                    }\n                }\n                language = getLanguage(newMapping[name]);\n                if (language) {\n                    language[state.add](name);\n                }\n            }\n        });\n\n        // Look for removed names (extensions or filenames)\n        _.difference(Object.keys(last), newNames).forEach(function (name) {\n            var language = getLanguage(last[name]);\n            if (language) {\n                language[state.remove](name);\n                _restoreOverriddenDefault(name, state);\n            }\n        });\n        state.last = newMapping;\n    }\n\n\n    EventDispatcher.makeEventDispatcher(exports);\n\n    // Prevent modes from being overwritten by extensions\n    _patchCodeMirror();\n\n    // Define a custom MIME mode here instead of putting it directly into languages.json\n    // because JSON files can\'t contain regular expressions. Also, all other modes so\n    // far were strings, so we spare us the trouble of allowing more complex mode values.\n    CodeMirror.defineMIME("text/x-brackets-html", {\n        "name": "htmlmixed",\n        "scriptTypes": [{"matches": /\\/x-handlebars|\\/x-mustache|\\/ng-template$|^text\\/html$/i,\n                       "mode": null}]\n    });\n\n    // Define SVG MIME type so an SVG language can be defined for SVG-specific code hints.\n    // Currently, SVG uses XML mode so it has generic XML syntax highlighting. This can\n    // be removed when SVG gets its own CodeMirror mode with SVG syntax highlighting.\n    CodeMirror.defineMIME("image/svg+xml", "xml");\n\n    // Load the default languages\n    _defaultLanguagesJSON = JSON.parse(_defaultLanguagesJSON);\n    _ready = Async.doInParallel(Object.keys(_defaultLanguagesJSON), function (key) {\n        return defineLanguage(key, _defaultLanguagesJSON[key]);\n    }, false);\n\n    // Get the object for HTML\n    _ready.always(function () {\n        var html = getLanguage("html");\n\n        // The htmlmixed mode uses the xml mode internally for the HTML parts, so we map it to HTML\n        html._setLanguageForMode("xml", html);\n\n        // Currently we override the above mentioned "xml" in TokenUtils.getModeAt, instead returning "html".\n        // When the CSSInlineEditor and the hint providers are no longer based on modes, this can be changed.\n        // But for now, we need to associate this madeup "html" mode with our HTML language object.\n        _setLanguageForMode("html", html);\n\n        // Similarly, the php mode uses clike internally for the PHP parts\n        var php = getLanguage("php");\n        php._setLanguageForMode("clike", php);\n\n        // Similar hack to the above for dealing with SCSS/CSS.\n        var scss = getLanguage("scss");\n        scss._setLanguageForMode("css", scss);\n\n        // The fallback language for unknown modes and file extensions\n        _fallbackLanguage = getLanguage("unknown");\n\n        // There is a circular dependency between FileUtils and LanguageManager which\n        // was introduced in 254b01e2f2eebea4416026d0f40d017b8ca6dbc9\n        // and may be preventing us from importing PreferencesManager (which also\n        // depends on FileUtils) here. Using the async form of require fixes this.\n        require(["preferences/PreferencesManager"], function (pm) {\n            PreferencesManager = pm;\n            pm.definePreference(_EXTENSION_MAP_PREF, "object", {}, {\n                description: Strings.DESCRIPTION_LANGUAGE_FILE_EXTENSIONS\n            }).on("change", function () {\n                _updateFromPrefs(_EXTENSION_MAP_PREF);\n            });\n            pm.definePreference(_NAME_MAP_PREF, "object", {}, {\n                description: Strings.DESCRIPTION_LANGUAGE_FILE_NAMES\n            }).on("change", function () {\n                _updateFromPrefs(_NAME_MAP_PREF);\n            });\n            _updateFromPrefs(_EXTENSION_MAP_PREF);\n            _updateFromPrefs(_NAME_MAP_PREF);\n        });\n    });\n\n    // Private for unit tests\n    exports._EXTENSION_MAP_PREF         = _EXTENSION_MAP_PREF;\n    exports._NAME_MAP_PREF              = _NAME_MAP_PREF;\n    exports._resetPathLanguageOverrides = _resetPathLanguageOverrides;\n\n    // Public methods\n    exports.ready                       = _ready;\n    exports.defineLanguage              = defineLanguage;\n    exports.getLanguage                 = getLanguage;\n    exports.getLanguageForExtension     = getLanguageForExtension;\n    exports.getLanguageForPath          = getLanguageForPath;\n    exports.getLanguages                = getLanguages;\n    exports.setLanguageOverrideForPath  = setLanguageOverrideForPath;\n    exports.getCompoundFileExtension    = getCompoundFileExtension;\n});\n\n//# sourceURL=/language/LanguageManager.js'),
eval('/*\n * Copyright (c) 2013 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */\n/*global define */\n\ndefine(\'widgets/DefaultDialogs\',[\'require\',\'exports\',\'module\'],function (require, exports, module) {\n    "use strict";\n\n    /**\n     * List of constants for the default dialogs IDs.\n     */\n    exports.DIALOG_ID_ERROR             = "error-dialog";\n    exports.DIALOG_ID_INFO              = "error-dialog"; // uses the same template for now--could be different in future\n    exports.DIALOG_ID_SAVE_CLOSE        = "save-close-dialog";\n    exports.DIALOG_ID_EXT_CHANGED       = "ext-changed-dialog";\n    exports.DIALOG_ID_EXT_DELETED       = "ext-deleted-dialog";\n    exports.DIALOG_ID_LIVE_DEVELOPMENT  = "live-development-error-dialog";\n    exports.DIALOG_ID_CHANGE_EXTENSIONS = "change-marked-extensions";\n});\n\n//# sourceURL=/widgets/DefaultDialogs.js'),eval("/*\n * Copyright (c) 2013 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the \"Software\"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, regexp: true, indent: 4, maxerr: 50 */\n/*global define */\n\ndefine('filesystem/WatchedRoot',['require','exports','module'],function (require, exports, module) {\n    \"use strict\";\n\n    /*\n     * Represents file or directory structure watched by the FileSystem. If the\n     * entry is a directory, all children (that pass the supplied filter function)\n     * are also watched. A WatchedRoot object begins and ends its life in the\n     * INACTIVE state. While in the process of starting up watchers, the WatchedRoot\n     * is in the STARTING state. When watchers are ready, the WatchedRoot enters\n     * the ACTIVE state.\n     *\n     * See the FileSystem class for more details.\n     *\n     * @constructor\n     * @param {File|Directory} entry\n     * @param {function(string, string):boolean} filter\n     */\n    function WatchedRoot(entry, filter) {\n        this.entry = entry;\n        this.filter = filter;\n    }\n\n    // Status constants\n    WatchedRoot.INACTIVE = 0;\n    WatchedRoot.STARTING = 1;\n    WatchedRoot.ACTIVE = 2;\n\n    /**\n     * @type {File|Directory}\n     */\n    WatchedRoot.prototype.entry = null;\n\n    /**\n     * @type {function(string, string):boolean}\n     */\n    WatchedRoot.prototype.filter = null;\n\n    /**\n     * @type {number}\n     */\n    WatchedRoot.prototype.status = WatchedRoot.INACTIVE;\n\n\n    // Export this class\n    module.exports = WatchedRoot;\n});\n\n//# sourceURL=/filesystem/WatchedRoot.js"),eval('/*\n * Copyright (c) 2013 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, regexp: true, indent: 4, maxerr: 50 */\n/*global define */\n\n/*\n * To ensure cache coherence, current and future asynchronous state-changing\n * operations of FileSystemEntry and its subclasses should implement the\n * following high-level sequence of steps:\n *\n * 1. Block external filesystem change events;\n * 2. Execute the low-level state-changing operation;\n * 3. Update the internal filesystem state, including caches;\n * 4. Apply the callback;\n * 5. Fire an appropriate internal change notification; and\n * 6. Unblock external change events.\n *\n * Note that because internal filesystem state is updated first, both the original\n * caller and the change notification listeners observe filesystem state that is\n * current w.r.t. the operation. Furthermore, because external change events are\n * blocked before the operation begins, listeners will only receive the internal\n * change event for the operation and not additional (or possibly inconsistent)\n * external change events.\n *\n * State-changing operations that block external filesystem change events must\n * take care to always subsequently unblock the external change events in all\n * control paths. It is safe to assume, however, that the underlying impl will\n * always apply the callback with some value.\n\n * Caches should be conservative. Consequently, the entry\'s cached data should\n * always be cleared if the underlying impl\'s operation fails. This is the case\n * event for read-only operations because an unexpected failure implies that the\n * system is in an unknown state. The entry should communicate this by failing\n * where appropriate, and should not use the cache to hide failure.\n *\n * Only watched entries should make use of cached data because change events are\n * only expected for such entries, and change events are used to granularly\n * invalidate out-of-date caches.\n *\n * By convention, callbacks are optional for asynchronous, state-changing\n * operations, but required for read-only operations. The first argument to the\n * callback should always be a nullable error string from FileSystemError.\n */\ndefine(\'filesystem/FileSystemEntry\',[\'require\',\'exports\',\'module\',\'filesystem/FileSystemError\',\'filesystem/WatchedRoot\'],function (require, exports, module) {\n    "use strict";\n\n    var FileSystemError = require("filesystem/FileSystemError"),\n        WatchedRoot     = require("filesystem/WatchedRoot");\n\n    var VISIT_DEFAULT_MAX_DEPTH = 100,\n        VISIT_DEFAULT_MAX_ENTRIES = 30000;\n\n    /* Counter to give every entry a unique id */\n    var nextId = 0;\n\n    /**\n     * Model for a file system entry. This is the base class for File and Directory,\n     * and is never used directly.\n     *\n     * See the File, Directory, and FileSystem classes for more details.\n     *\n     * @constructor\n     * @param {string} path The path for this entry.\n     * @param {FileSystem} fileSystem The file system associated with this entry.\n     */\n    function FileSystemEntry(path, fileSystem) {\n        this._setPath(path);\n        this._fileSystem = fileSystem;\n        this._id = nextId++;\n    }\n\n    // Add "fullPath", "name", "parent", "id", "isFile" and "isDirectory" getters\n    Object.defineProperties(FileSystemEntry.prototype, {\n        "fullPath": {\n            get: function () { return this._path; },\n            set: function () { throw new Error("Cannot set fullPath"); }\n        },\n        "name": {\n            get: function () { return this._name; },\n            set: function () { throw new Error("Cannot set name"); }\n        },\n        "parentPath": {\n            get: function () { return this._parentPath; },\n            set: function () { throw new Error("Cannot set parentPath"); }\n        },\n        "id": {\n            get: function () { return this._id; },\n            set: function () { throw new Error("Cannot set id"); }\n        },\n        "isFile": {\n            get: function () { return this._isFile; },\n            set: function () { throw new Error("Cannot set isFile"); }\n        },\n        "isDirectory": {\n            get: function () { return this._isDirectory; },\n            set: function () { throw new Error("Cannot set isDirectory"); }\n        },\n        "_impl": {\n            get: function () { return this._fileSystem._impl; },\n            set: function () { throw new Error("Cannot set _impl"); }\n        }\n    });\n\n    /**\n     * Cached stat object for this file.\n     * @type {?FileSystemStats}\n     */\n    FileSystemEntry.prototype._stat = null;\n\n    /**\n     * Parent file system.\n     * @type {!FileSystem}\n     */\n    FileSystemEntry.prototype._fileSystem = null;\n\n    /**\n     * The path of this entry.\n     * @type {string}\n     */\n    FileSystemEntry.prototype._path = null;\n\n    /**\n     * The name of this entry.\n     * @type {string}\n     */\n    FileSystemEntry.prototype._name = null;\n\n    /**\n     * The parent of this entry.\n     * @type {string}\n     */\n    FileSystemEntry.prototype._parentPath = null;\n\n    /**\n     * Whether or not the entry is a file\n     * @type {boolean}\n     */\n    FileSystemEntry.prototype._isFile = false;\n\n    /**\n     * Whether or not the entry is a directory\n     * @type {boolean}\n     */\n    FileSystemEntry.prototype._isDirectory = false;\n\n    /**\n     * Cached copy of this entry\'s watched root\n     * @type {entry: File|Directory, filter: function(FileSystemEntry):boolean, active: boolean}\n     */\n    FileSystemEntry.prototype._watchedRoot = undefined;\n\n    /**\n     * Cached result of _watchedRoot.filter(this.name, this.parentPath).\n     * @type {boolean}\n     */\n    FileSystemEntry.prototype._watchedRootFilterResult = undefined;\n\n    /**\n     * Determines whether or not the entry is watched.\n     * @param {boolean=} relaxed If falsey, the method will only return true if\n     *      the watched root is fully active. If true, the method will return\n     *      true if the watched root is either starting up or fully active.\n     * @return {boolean}\n     */\n    FileSystemEntry.prototype._isWatched = function (relaxed) {\n        var watchedRoot = this._watchedRoot,\n            filterResult = this._watchedRootFilterResult;\n\n        if (!watchedRoot) {\n            watchedRoot = this._fileSystem._findWatchedRootForPath(this._path);\n\n            if (watchedRoot) {\n                this._watchedRoot = watchedRoot;\n                if (watchedRoot.entry !== this) { // avoid creating entries for root\'s parent\n                    var parentEntry = this._fileSystem.getDirectoryForPath(this._parentPath);\n                    if (parentEntry._isWatched() === false) {\n                        filterResult = false;\n                    } else {\n                        filterResult = watchedRoot.filter(this._name, this._parentPath);\n                    }\n                } else { // root itself is watched\n                    filterResult = true;\n                }\n                this._watchedRootFilterResult = filterResult;\n            }\n        }\n\n        if (watchedRoot) {\n            if (watchedRoot.status === WatchedRoot.ACTIVE ||\n                    (relaxed && watchedRoot.status === WatchedRoot.STARTING)) {\n                return filterResult;\n            } else {\n                // We had a watched root, but it\'s no longer active, so it must now be invalid.\n                this._watchedRoot = undefined;\n                this._watchedRootFilterResult = false;\n                this._clearCachedData();\n            }\n        }\n        return false;\n    };\n\n    /**\n     * Update the path for this entry\n     * @private\n     * @param {String} newPath\n     */\n    FileSystemEntry.prototype._setPath = function (newPath) {\n        var parts = newPath.split("/");\n        if (this.isDirectory) {\n            parts.pop(); // Remove the empty string after last trailing "/"\n        }\n        this._name = parts[parts.length - 1];\n        parts.pop(); // Remove name\n\n        if (parts.length > 0) {\n            this._parentPath = parts.join("/") + "/";\n        } else {\n            // root directories have no parent path\n            this._parentPath = null;\n        }\n\n        this._path = newPath;\n\n        var watchedRoot = this._watchedRoot;\n        if (watchedRoot) {\n            if (newPath.indexOf(watchedRoot.entry.fullPath) === 0) {\n                // Update watchedRootFilterResult\n                this._watchedRootFilterResult = watchedRoot.filter(this._name, this._parentPath);\n            } else {\n                // The entry was moved outside of the watched root\n                this._watchedRoot = null;\n                this._watchedRootFilterResult = false;\n            }\n        }\n    };\n\n    /**\n     * Clear any cached data for this entry\n     * @private\n     */\n    FileSystemEntry.prototype._clearCachedData = function () {\n        this._stat = undefined;\n    };\n\n    /**\n     * Helpful toString for debugging purposes\n     */\n    FileSystemEntry.prototype.toString = function () {\n        return "[" + (this.isDirectory ? "Directory " : "File ") + this._path + "]";\n    };\n\n    /**\n     * Check to see if the entry exists on disk. Note that there will NOT be an\n     * error returned if the file does not exist on the disk; in that case the\n     * error parameter will be null and the boolean will be false. The error\n     * parameter will only be truthy when an unexpected error was encountered\n     * during the test, in which case the state of the entry should be considered\n     * unknown.\n     *\n     * @param {function (?string, boolean)} callback Callback with a FileSystemError\n     *      string or a boolean indicating whether or not the file exists.\n     */\n    FileSystemEntry.prototype.exists = function (callback) {\n        if (this._stat) {\n            callback(null, true);\n            return;\n        }\n\n        this._impl.exists(this._path, function (err, exists) {\n            if (err) {\n                this._clearCachedData();\n                callback(err);\n                return;\n            }\n\n            if (!exists) {\n                this._clearCachedData();\n            }\n\n            callback(null, exists);\n        }.bind(this));\n    };\n\n    /**\n     * Returns the stats for the entry.\n     *\n     * @param {function (?string, FileSystemStats=)} callback Callback with a\n     *      FileSystemError string or FileSystemStats object.\n     */\n    FileSystemEntry.prototype.stat = function (callback) {\n        if (this._stat) {\n            callback(null, this._stat);\n            return;\n        }\n\n        this._impl.stat(this._path, function (err, stat) {\n            if (err) {\n                this._clearCachedData();\n                callback(err);\n                return;\n            }\n\n            if (this._isWatched()) {\n                this._stat = stat;\n            }\n\n            callback(null, stat);\n        }.bind(this));\n    };\n\n    /**\n     * Rename this entry.\n     *\n     * @param {string} newFullPath New path & name for this entry.\n     * @param {function (?string)=} callback Callback with a single FileSystemError\n     *      string parameter.\n     */\n    FileSystemEntry.prototype.rename = function (newFullPath, callback) {\n        callback = callback || function () {};\n\n        // Block external change events until after the write has finished\n        this._fileSystem._beginChange();\n\n        this._impl.rename(this._path, newFullPath, function (err) {\n            var oldFullPath = this._path;\n\n            try {\n                if (err) {\n                    this._clearCachedData();\n                    callback(err);\n                    return;\n                }\n\n                // Update internal filesystem state\n                this._fileSystem._handleRename(this._path, newFullPath, this.isDirectory);\n\n                try {\n                    // Notify the caller\n                    callback(null);\n                } finally {\n                    // Notify rename listeners\n                    this._fileSystem._fireRenameEvent(oldFullPath, newFullPath);\n                }\n            } finally {\n                // Unblock external change events\n                this._fileSystem._endChange();\n            }\n        }.bind(this));\n    };\n\n    /**\n     * Permanently delete this entry. For Directories, this will delete the directory\n     * and all of its contents. For reversible delete, see moveToTrash().\n     *\n     * @param {function (?string)=} callback Callback with a single FileSystemError\n     *      string parameter.\n     */\n    FileSystemEntry.prototype.unlink = function (callback) {\n        callback = callback || function () {};\n\n        // Block external change events until after the write has finished\n        this._fileSystem._beginChange();\n\n        this._clearCachedData();\n        this._impl.unlink(this._path, function (err) {\n            var parent = this._fileSystem.getDirectoryForPath(this.parentPath);\n\n            // Update internal filesystem state\n            this._fileSystem._handleDirectoryChange(parent, function (added, removed) {\n                try {\n                    // Notify the caller\n                    callback(err);\n                } finally {\n                    if (parent._isWatched()) {\n                        // Notify change listeners\n                        this._fileSystem._fireChangeEvent(parent, added, removed);\n                    }\n\n                    // Unblock external change events\n                    this._fileSystem._endChange();\n                }\n            }.bind(this));\n        }.bind(this));\n    };\n\n    /**\n     * Move this entry to the trash. If the underlying file system doesn\'t support move\n     * to trash, the item is permanently deleted.\n     *\n     * @param {function (?string)=} callback Callback with a single FileSystemError\n     *      string parameter.\n     */\n    FileSystemEntry.prototype.moveToTrash = function (callback) {\n        if (!this._impl.moveToTrash) {\n            this.unlink(callback);\n            return;\n        }\n\n        callback = callback || function () {};\n\n        // Block external change events until after the write has finished\n        this._fileSystem._beginChange();\n\n        this._clearCachedData();\n        this._impl.moveToTrash(this._path, function (err) {\n            var parent = this._fileSystem.getDirectoryForPath(this.parentPath);\n\n            // Update internal filesystem state\n            this._fileSystem._handleDirectoryChange(parent, function (added, removed) {\n                try {\n                    // Notify the caller\n                    callback(err);\n                } finally {\n                    if (parent._isWatched()) {\n                        // Notify change listeners\n                        this._fileSystem._fireChangeEvent(parent, added, removed);\n                    }\n\n                    // Unblock external change events\n                    this._fileSystem._endChange();\n                }\n            }.bind(this));\n        }.bind(this));\n    };\n\n    /**\n     * Private helper function for FileSystemEntry.visit that requires sanitized options.\n     *\n     * @private\n     * @param {FileSystemStats} stats - the stats for this entry\n     * @param {{string: boolean}} visitedPaths - the set of fullPaths that have already been visited\n     * @param {function(FileSystemEntry): boolean} visitor - A visitor function, which is\n     *      applied to descendent FileSystemEntry objects. If the function returns false for\n     *      a particular Directory entry, that directory\'s descendents will not be visited.\n     * @param {{maxDepth: number, maxEntriesCounter: {value: number}, sortList: boolean}} options\n     * @param {function(?string)=} callback Callback with single FileSystemError string parameter.\n     */\n    FileSystemEntry.prototype._visitHelper = function (stats, visitedPaths, visitor, options, callback) {\n        var maxDepth = options.maxDepth,\n            maxEntriesCounter = options.maxEntriesCounter,\n            sortList = options.sortList;\n\n        if (maxEntriesCounter.value-- <= 0 || maxDepth-- < 0) {\n            // The outer FileSystemEntry.visit call is responsible for applying\n            // the main callback to FileSystemError.TOO_MANY_FILES in this case\n            callback(null);\n            return;\n        }\n\n        if (this.isDirectory) {\n            var visitedPath = stats.realPath || this.fullPath;\n\n            if (visitedPaths.hasOwnProperty(visitedPath)) {\n                // Link cycle detected\n                callback(null);\n                return;\n            }\n\n            visitedPaths[visitedPath] = true;\n        }\n\n        if (!visitor(this) || this.isFile) {\n            callback(null);\n            return;\n        }\n\n        this.getContents(function (err, entries, entriesStats) {\n            if (err) {\n                callback(err);\n                return;\n            }\n\n            var counter = entries.length;\n            if (counter === 0) {\n                callback(null);\n                return;\n            }\n\n            function helperCallback(err) {\n                if (--counter === 0) {\n                    callback(null);\n                }\n            }\n\n            var nextOptions = {\n                maxDepth: maxDepth,\n                maxEntriesCounter: maxEntriesCounter,\n                sortList : sortList\n            };\n\n            //sort entries if required\n            function compareFilesWithIndices(index1, index2) {\n                return entries[index1]._name.toLocaleLowerCase().localeCompare(entries[index2]._name.toLocaleLowerCase());\n            }\n            if (sortList) {\n                var fileIndexes = [], i = 0;\n                for (i = 0; i < entries.length; i++) {\n                    fileIndexes[i] = i;\n                }\n                fileIndexes.sort(compareFilesWithIndices);\n                fileIndexes.forEach(function (fileIndex) {\n                    var stats = entriesStats[fileIndexes[fileIndex]];\n                    entries[fileIndexes[fileIndex]]._visitHelper(stats, visitedPaths, visitor, nextOptions, helperCallback);\n                });\n            } else {\n                entries.forEach(function (entry, index) {\n                    var stats = entriesStats[index];\n                    entry._visitHelper(stats, visitedPaths, visitor, nextOptions, helperCallback);\n                });\n            }\n        }.bind(this));\n    };\n\n    /**\n     * Visit this entry and its descendents with the supplied visitor function.\n     * Correctly handles symbolic link cycles and options can be provided to limit\n     * search depth and total number of entries visited. No particular traversal\n     * order is guaranteed; instead of relying on such an order, it is preferable\n     * to use the visit function to build a list of visited entries, sort those\n     * entries as desired, and then process them. Whenever possible, deep\n     * filesystem traversals should use this method.\n     *\n     * @param {function(FileSystemEntry): boolean} visitor - A visitor function, which is\n     *      applied to this entry and all descendent FileSystemEntry objects. If the function returns\n     *      false for a particular Directory entry, that directory\'s descendents will not be visited.\n     * @param {{maxDepth: number=, maxEntries: number=}=} options\n     * @param {function(?string)=} callback Callback with single FileSystemError string parameter.\n     */\n    FileSystemEntry.prototype.visit = function (visitor, options, callback) {\n        if (typeof options === "function") {\n            callback = options;\n            options = {};\n        } else {\n            if (options === undefined) {\n                options = {};\n            }\n\n            callback = callback || function () {};\n        }\n\n        if (options.maxDepth === undefined) {\n            options.maxDepth = VISIT_DEFAULT_MAX_DEPTH;\n        }\n\n        if (options.maxEntries === undefined) {\n            options.maxEntries = VISIT_DEFAULT_MAX_ENTRIES;\n        }\n\n        options.maxEntriesCounter = { value: options.maxEntries };\n\n        this.stat(function (err, stats) {\n            if (err) {\n                callback(err);\n                return;\n            }\n\n            this._visitHelper(stats, {}, visitor, options, function (err) {\n                if (callback) {\n                    if (err) {\n                        callback(err);\n                        return;\n                    }\n\n                    if (options.maxEntriesCounter.value < 0) {\n                        callback(FileSystemError.TOO_MANY_ENTRIES);\n                        return;\n                    }\n\n                    callback(null);\n                }\n            }.bind(this));\n        }.bind(this));\n    };\n\n    // Export this class\n    module.exports = FileSystemEntry;\n});\n\n//# sourceURL=/filesystem/FileSystemEntry.js'),eval('/*\n * Copyright (c) 2013 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, regexp: true, indent: 4, maxerr: 50 */\n/*global define */\n\ndefine(\'filesystem/Directory\',[\'require\',\'exports\',\'module\',\'filesystem/FileSystemEntry\'],function (require, exports, module) {\n    "use strict";\n\n    var FileSystemEntry = require("filesystem/FileSystemEntry");\n\n    /*\n     * Model for a file system Directory.\n     *\n     * This class should *not* be instantiated directly. Use FileSystem.getDirectoryForPath,\n     * FileSystem.resolve, or Directory.getContents to create an instance of this class.\n     *\n     * Note: Directory.fullPath always has a trailing slash.\n     *\n     * See the FileSystem class for more details.\n     *\n     * @constructor\n     * @param {!string} fullPath The full path for this Directory.\n     * @param {!FileSystem} fileSystem The file system associated with this Directory.\n     */\n    function Directory(fullPath, fileSystem) {\n        this._isDirectory = true;\n        FileSystemEntry.call(this, fullPath, fileSystem);\n    }\n\n    Directory.prototype = Object.create(FileSystemEntry.prototype);\n    Directory.prototype.constructor = Directory;\n    Directory.prototype.parentClass = FileSystemEntry.prototype;\n\n    /**\n     * The contents of this directory. This "private" property is used by FileSystem.\n     * @type {Array<FileSystemEntry>}\n     */\n    Directory.prototype._contents = null;\n\n    /**\n     * The stats for the contents of this directory, such that this._contentsStats[i]\n     * corresponds to this._contents[i].\n     * @type {Array.<FileSystemStats>}\n     */\n    Directory.prototype._contentsStats = null;\n\n    /**\n     * The stats errors for the contents of this directory.\n     * @type {object.<string: string>} fullPaths are mapped to FileSystemError strings\n     */\n    Directory.prototype._contentsStatsErrors = null;\n\n    /**\n     * Clear any cached data for this directory. By default, we clear the contents\n     * of immediate children as well, because in some cases file watchers fail\n     * provide precise change notifications. (Sometimes, like after a "git\n     * checkout", they just report that some directory has changed when in fact\n     * many of the file within the directory have changed.\n     *\n     * @private\n     * @param {boolean=} preserveImmediateChildren\n     */\n    Directory.prototype._clearCachedData = function (preserveImmediateChildren) {\n        FileSystemEntry.prototype._clearCachedData.apply(this);\n\n        if (!preserveImmediateChildren) {\n            if (this._contents) {\n                this._contents.forEach(function (child) {\n                    child._clearCachedData(true);\n                });\n            } else {\n                // No cached _contents, but child entries may still exist.\n                // Scan the full index to catch all of them.\n                var dirPath = this.fullPath;\n                this._fileSystem._index.visitAll(function (entry) {\n                    if (entry.parentPath === dirPath) {\n                        entry._clearCachedData(true);\n                    }\n                });\n            }\n        }\n\n        this._contents = undefined;\n        this._contentsStats = undefined;\n        this._contentsStatsErrors = undefined;\n    };\n\n    /**\n     * Apply each callback in a list to the provided arguments. Callbacks\n     * can throw without preventing other callbacks from being applied.\n     *\n     * @private\n     * @param {Array.<function>} callbacks The callbacks to apply\n     * @param {Array} args The arguments to which each callback is applied\n     */\n    function _applyAllCallbacks(callbacks, args) {\n        if (callbacks.length > 0) {\n            var callback = callbacks.pop();\n            try {\n                callback.apply(undefined, args);\n            } finally {\n                _applyAllCallbacks(callbacks, args);\n            }\n        }\n    }\n\n    /**\n     * Read the contents of a Directory. If this Directory is under a watch root,\n     * the listing will exclude any items filtered out by the watch root\'s filter\n     * function.\n     *\n     * @param {Directory} directory Directory whose contents you want to get\n     * @param {function (?string, Array.<FileSystemEntry>=, Array.<FileSystemStats>=, Object.<string, string>=)} callback\n     *          Callback that is passed an error code or the stat-able contents\n     *          of the directory along with the stats for these entries and a\n     *          fullPath-to-FileSystemError string map of unstat-able entries\n     *          and their stat errors. If there are no stat errors then the last\n     *          parameter shall remain undefined.\n     */\n    Directory.prototype.getContents = function (callback) {\n        if (this._contentsCallbacks) {\n            // There is already a pending call for this directory\'s contents.\n            // Push the new callback onto the stack and return.\n            this._contentsCallbacks.push(callback);\n            return;\n        }\n\n        // Return cached contents if the directory is watched\n        if (this._contents) {\n            callback(null, this._contents, this._contentsStats, this._contentsStatsErrors);\n            return;\n        }\n\n        this._contentsCallbacks = [callback];\n\n        this._impl.readdir(this.fullPath, function (err, names, stats) {\n            var contents = [],\n                contentsStats = [],\n                contentsStatsErrors;\n\n            if (err) {\n                this._clearCachedData();\n            } else {\n                // Use the "relaxed" parameter to _isWatched because it\'s OK to\n                // cache data even while watchers are still starting up\n                var watched = this._isWatched(true);\n\n                names.forEach(function (name, index) {\n                    var entryPath = this.fullPath + name;\n\n                    if (this._fileSystem._indexFilter(entryPath, name)) {\n                        var entryStats = stats[index],\n                            entry;\n\n                        // Note: not all entries necessarily have associated stats.\n                        if (typeof entryStats === "string") {\n                            // entryStats is an error string\n                            if (contentsStatsErrors === undefined) {\n                                contentsStatsErrors = {};\n                            }\n                            contentsStatsErrors[entryPath] = entryStats;\n                        } else {\n                            // entryStats is a FileSystemStats object\n                            if (entryStats.isFile) {\n                                entry = this._fileSystem.getFileForPath(entryPath);\n                            } else {\n                                entry = this._fileSystem.getDirectoryForPath(entryPath);\n                            }\n\n                            if (watched) {\n                                entry._stat = entryStats;\n                            }\n\n                            contents.push(entry);\n                            contentsStats.push(entryStats);\n                        }\n                    }\n                }, this);\n\n                if (watched) {\n                    this._contents = contents;\n                    this._contentsStats = contentsStats;\n                    this._contentsStatsErrors = contentsStatsErrors;\n                }\n            }\n\n            // Reset the callback list before we begin calling back so that\n            // synchronous reentrant calls are handled correctly.\n            var currentCallbacks = this._contentsCallbacks;\n\n            this._contentsCallbacks = null;\n\n            // Invoke all saved callbacks\n            var callbackArgs = [err, contents, contentsStats, contentsStatsErrors];\n            _applyAllCallbacks(currentCallbacks, callbackArgs);\n        }.bind(this));\n    };\n\n    /**\n     * Create a directory\n     *\n     * @param {function (?string, FileSystemStats=)=} callback Callback resolved with a\n     *      FileSystemError string or the stat object for the created directory.\n     */\n    Directory.prototype.create = function (callback) {\n        callback = callback || function () {};\n\n        // Block external change events until after the write has finished\n        this._fileSystem._beginChange();\n\n        this._impl.mkdir(this._path, function (err, stat) {\n            if (err) {\n                this._clearCachedData();\n                try {\n                    callback(err);\n                    return;\n                } finally {\n                    // Unblock external change events\n                    this._fileSystem._endChange();\n                }\n            }\n\n            var parent = this._fileSystem.getDirectoryForPath(this.parentPath);\n\n            // Update internal filesystem state\n            if (this._isWatched()) {\n                this._stat = stat;\n            }\n\n            this._fileSystem._handleDirectoryChange(parent, function (added, removed) {\n                try {\n                    callback(null, stat);\n                } finally {\n                    if (parent._isWatched()) {\n                        this._fileSystem._fireChangeEvent(parent, added, removed);\n                    }\n                    // Unblock external change events\n                    this._fileSystem._endChange();\n                }\n            }.bind(this));\n        }.bind(this));\n    };\n\n    // Export this class\n    module.exports = Directory;\n});\n\n//# sourceURL=/filesystem/Directory.js'),
eval("/*\n * Copyright (c) 2013 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the \"Software\"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, regexp: true, indent: 4, maxerr: 50 */\n/*global define */\n\ndefine('filesystem/File',['require','exports','module','filesystem/FileSystemEntry'],function (require, exports, module) {\n    \"use strict\";\n\n    var FileSystemEntry = require(\"filesystem/FileSystemEntry\");\n\n\n    /*\n     * Model for a File.\n     *\n     * This class should *not* be instantiated directly. Use FileSystem.getFileForPath,\n     * FileSystem.resolve, or Directory.getContents to create an instance of this class.\n     *\n     * See the FileSystem class for more details.\n     *\n     * @constructor\n     * @param {!string} fullPath The full path for this File.\n     * @param {!FileSystem} fileSystem The file system associated with this File.\n     */\n    function File(fullPath, fileSystem) {\n        this._isFile = true;\n        FileSystemEntry.call(this, fullPath, fileSystem);\n    }\n\n    File.prototype = Object.create(FileSystemEntry.prototype);\n    File.prototype.constructor = File;\n    File.prototype.parentClass = FileSystemEntry.prototype;\n\n    /**\n     * Cached contents of this file. This value is nullable but should NOT be undefined.\n     * @private\n     * @type {?string}\n     */\n    File.prototype._contents = null;\n\n    /**\n     * Consistency hash for this file. Reads and writes update this value, and\n     * writes confirm the hash before overwriting existing files. The type of\n     * this object is dependent on the FileSystemImpl; the only constraint is\n     * that === can be used as an equality relation on hashes.\n     * @private\n     * @type {?object}\n     */\n    File.prototype._hash = null;\n\n    /**\n     * Clear any cached data for this file. Note that this explicitly does NOT\n     * clear the file's hash.\n     * @private\n     */\n    File.prototype._clearCachedData = function () {\n        FileSystemEntry.prototype._clearCachedData.apply(this);\n        this._contents = null;\n    };\n\n    /**\n     * Read a file.\n     *\n     * @param {Object=} options Currently unused.\n     * @param {function (?string, string=, FileSystemStats=)} callback Callback that is passed the\n     *              FileSystemError string or the file's contents and its stats.\n     */\n    File.prototype.read = function (options, callback) {\n        if (typeof (options) === \"function\") {\n            callback = options;\n            options = {};\n        }\n\n        // We don't need to check isWatched() here because contents are only saved\n        // for watched files. Note that we need to explicitly test this._contents\n        // for a default value; otherwise it could be the empty string, which is\n        // falsey.\n        if (this._contents !== null && this._stat) {\n            callback(null, this._contents, this._stat);\n            return;\n        }\n\n        var watched = this._isWatched();\n        if (watched) {\n            options.stat = this._stat;\n        }\n\n        this._impl.readFile(this._path, options, function (err, data, stat) {\n            if (err) {\n                this._clearCachedData();\n                callback(err);\n                return;\n            }\n\n            // Always store the hash\n            this._hash = stat._hash;\n\n            // Only cache data for watched files\n            if (watched) {\n                this._stat = stat;\n                this._contents = data;\n            }\n\n            callback(err, data, stat);\n        }.bind(this));\n    };\n\n    /**\n     * Write a file.\n     *\n     * @param {string} data Data to write.\n     * @param {object=} options Currently unused.\n     * @param {function (?string, FileSystemStats=)=} callback Callback that is passed the\n     *              FileSystemError string or the file's new stats.\n     */\n    File.prototype.write = function (data, options, callback) {\n        if (typeof options === \"function\") {\n            callback = options;\n            options = {};\n        } else {\n            if (options === undefined) {\n                options = {};\n            }\n\n            callback = callback || function () {};\n        }\n\n        // Request a consistency check if the write is not blind\n        if (!options.blind) {\n            options.expectedHash = this._hash;\n            options.expectedContents = this._contents;\n        }\n\n        // Block external change events until after the write has finished\n        this._fileSystem._beginChange();\n\n        this._impl.writeFile(this._path, data, options, function (err, stat, created) {\n            if (err) {\n                this._clearCachedData();\n                try {\n                    callback(err);\n                    return;\n                } finally {\n                    // Always unblock external change events\n                    this._fileSystem._endChange();\n                }\n            }\n\n            // Always store the hash\n            this._hash = stat._hash;\n\n            // Only cache data for watched files\n            if (this._isWatched()) {\n                this._stat = stat;\n                this._contents = data;\n            }\n\n            if (created) {\n                var parent = this._fileSystem.getDirectoryForPath(this.parentPath);\n                this._fileSystem._handleDirectoryChange(parent, function (added, removed) {\n                    try {\n                        // Notify the caller\n                        callback(null, stat);\n                    } finally {\n                        if (parent._isWatched()) {\n                            // If the write succeeded and the parent directory is watched,\n                            // fire a synthetic change event\n                            this._fileSystem._fireChangeEvent(parent, added, removed);\n\n                        }\n                        // Always unblock external change events\n                        this._fileSystem._endChange();\n                    }\n                }.bind(this));\n            } else {\n                try {\n                    // Notify the caller\n                    callback(null, stat);\n                } finally {\n                    // existing file modified\n                    this._fileSystem._fireChangeEvent(this);\n\n                    // Always unblock external change events\n                    this._fileSystem._endChange();\n                }\n            }\n        }.bind(this));\n    };\n\n    // Export this class\n    module.exports = File;\n});\n\n//# sourceURL=/filesystem/File.js"),eval("/*\n * Copyright (c) 2013 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the \"Software\"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, regexp: true, indent: 4, maxerr: 50 */\n/*global define */\n\n/**\n * FileIndex is an internal module used by FileSystem to maintain an index of all files and directories.\n *\n * This module is *only* used by FileSystem, and should not be called directly.\n */\ndefine('filesystem/FileIndex',['require','exports','module'],function (require, exports, module) {\n    \"use strict\";\n\n    /**\n     * @constructor\n     */\n    function FileIndex() {\n        this._index = {};\n    }\n\n    /**\n     * Master index\n     *\n     * @type {Object.<string, File|Directory>} Maps a fullPath to a File or Directory object\n     */\n    FileIndex.prototype._index = null;\n\n    /**\n     * Clear the file index cache.\n     */\n    FileIndex.prototype.clear = function () {\n        this._index = {};\n    };\n\n    /**\n     * Visits every entry in the entire index; no stopping condition.\n     * @param {!function(FileSystemEntry, string):void} Called with an entry and its fullPath\n     */\n    FileIndex.prototype.visitAll = function (visitor) {\n        var path;\n        for (path in this._index) {\n            if (this._index.hasOwnProperty(path)) {\n                visitor(this._index[path], path);\n            }\n        }\n    };\n\n    /**\n     * Add an entry.\n     *\n     * @param {FileSystemEntry} entry The entry to add.\n     */\n    FileIndex.prototype.addEntry = function (entry) {\n        this._index[entry.fullPath] = entry;\n    };\n\n    /**\n     * Remove an entry.\n     *\n     * @param {FileSystemEntry} entry The entry to remove.\n     */\n    FileIndex.prototype.removeEntry = function (entry) {\n        var path = entry.fullPath,\n            property;\n\n        function replaceMember(property) {\n            var member = entry[property];\n            if (typeof member === \"function\") {\n                entry[property] = function () {\n                    console.warn(\"FileSystemEntry used after being removed from index: \", path);\n                    return member.apply(entry, arguments);\n                };\n            }\n        }\n\n        delete this._index[path];\n\n        for (property in entry) {\n            if (entry.hasOwnProperty(property)) {\n                replaceMember(property);\n            }\n        }\n    };\n\n    /**\n     * Notify the index that an entry has been renamed. This updates\n     * all affected entries in the index.\n     *\n     * @param {string} oldPath\n     * @param {string} newPath\n     * @param {boolean} isDirectory\n     */\n    FileIndex.prototype.entryRenamed = function (oldPath, newPath, isDirectory) {\n        var path,\n            renameMap = {};\n\n        // Find all entries affected by the rename and put into a separate map.\n        for (path in this._index) {\n            if (this._index.hasOwnProperty(path)) {\n                // See if we have a match. For directories, see if the path\n                // starts with the old name. This is safe since paths always end\n                // with '/'. For files, see if there is an exact match between\n                // the path and the old name.\n                if (isDirectory ? path.indexOf(oldPath) === 0 : path === oldPath) {\n                    renameMap[path] = newPath + path.substr(oldPath.length);\n                }\n            }\n        }\n\n        // Do the rename.\n        for (path in renameMap) {\n            if (renameMap.hasOwnProperty(path)) {\n                var item = this._index[path];\n\n                // Sanity check to make sure the item and path still match\n                console.assert(item.fullPath === path);\n\n                delete this._index[path];\n                this._index[renameMap[path]] = item;\n                item._setPath(renameMap[path]);\n            }\n        }\n    };\n\n    /**\n     * Returns the cached entry for the specified path, or undefined\n     * if the path has not been cached.\n     *\n     * @param {string} path The path of the entry to return.\n     * @return {File|Directory} The entry for the path, or undefined if it hasn't\n     *              been cached yet.\n     */\n    FileIndex.prototype.getEntry = function (path) {\n        return this._index[path];\n    };\n\n    // Export public API\n    module.exports = FileIndex;\n});\n\n//# sourceURL=/filesystem/FileIndex.js"),eval('/*\n * Copyright (c) 2013 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, regexp: true, indent: 4, maxerr: 50 */\n/*global define */\n\n/**\n * The FileSystemStats represents a particular FileSystemEntry\'s stats.\n */\ndefine(\'filesystem/FileSystemStats\',[\'require\',\'exports\',\'module\'],function (require, exports, module) {\n    "use strict";\n\n    /**\n     * @constructor\n     * @param {{isFile: boolean, mtime: Date, size: Number, realPath: ?string, hash: object}} options\n     */\n    function FileSystemStats(options) {\n        var isFile = options.isFile;\n\n        this._isFile = isFile;\n        this._isDirectory = !isFile;\n        this._mtime = options.mtime;\n        this._size = options.size;\n        this._hash = options.hash;\n\n        var realPath = options.realPath;\n        if (realPath) {\n            if (!isFile && realPath[realPath.length - 1] !== "/") {\n                realPath += "/";\n            }\n\n            this._realPath = realPath;\n        }\n    }\n\n    // Add "isFile", "isDirectory", "mtime" and "size" getters\n    Object.defineProperties(FileSystemStats.prototype, {\n        "isFile": {\n            get: function () { return this._isFile; },\n            set: function () { throw new Error("Cannot set isFile"); }\n        },\n        "isDirectory": {\n            get: function () { return this._isDirectory; },\n            set: function () { throw new Error("Cannot set isDirectory"); }\n        },\n        "mtime": {\n            get: function () { return this._mtime; },\n            set: function () { throw new Error("Cannot set mtime"); }\n        },\n        "size": {\n            get: function () { return this._size; },\n            set: function () { throw new Error("Cannot set size"); }\n        },\n        "realPath": {\n            get: function () { return this._realPath; },\n            set: function () { throw new Error("Cannot set realPath"); }\n        }\n    });\n\n    /**\n     * Whether or not this is a stats object for a file\n     * @type {boolean}\n     */\n    FileSystemStats.prototype._isFile = false;\n\n    /**\n     * Whether or not this is a stats object for a directory\n     * @type {boolean}\n     */\n    FileSystemStats.prototype._isDirectory = false;\n\n    /**\n     * Modification time for a file\n     * @type {Date}\n     */\n    FileSystemStats.prototype._mtime = null;\n\n    /**\n     * Size in bytes of a file\n     * @type {Number}\n     */\n    FileSystemStats.prototype._size = null;\n\n    /**\n     * Consistency hash for a file\n     * @type {object}\n     */\n    FileSystemStats.prototype._hash = null;\n\n    /**\n     * The canonical path of this file or directory ONLY if it is a symbolic link,\n     * and null otherwise.\n     *\n     * @type {?string}\n     */\n    FileSystemStats.prototype._realPath = null;\n\n    module.exports = FileSystemStats;\n});\n\n//# sourceURL=/filesystem/FileSystemStats.js'),eval('/*\n * Copyright (c) 2013 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4,\nmaxerr: 50, browser: true */\n/*global $, define, brackets, WebSocket, ArrayBuffer, Uint32Array */\n\ndefine(\'utils/NodeConnection\',[\'require\',\'exports\',\'module\',\'utils/EventDispatcher\'],function (require, exports, module) {\n    "use strict";\n\n    var EventDispatcher = require("utils/EventDispatcher");\n\n\n    /**\n     * Connection attempts to make before failing\n     * @type {number}\n     */\n    var CONNECTION_ATTEMPTS = 10;\n\n    /**\n     * Milliseconds to wait before a particular connection attempt is considered failed.\n     * NOTE: It\'s okay for the connection timeout to be long because the\n     * expected behavior of WebSockets is to send a "close" event as soon\n     * as they realize they can\'t connect. So, we should rarely hit the\n     * connection timeout even if we try to connect to a port that isn\'t open.\n     * @type {number}\n     */\n    var CONNECTION_TIMEOUT  = 10000; // 10 seconds\n\n    /**\n     * Milliseconds to wait before retrying connecting\n     * @type {number}\n     */\n    var RETRY_DELAY         = 500;   // 1/2 second\n\n    /**\n     * Maximum value of the command ID counter\n     * @type  {number}\n     */\n    var MAX_COUNTER_VALUE = 4294967295; // 2^32 - 1\n\n    /**\n     * @private\n     * Helper function to auto-reject a deferred after a given amount of time.\n     * If the deferred is resolved/rejected manually, then the timeout is\n     * automatically cleared.\n     */\n    function setDeferredTimeout(deferred, delay) {\n        var timer = setTimeout(function () {\n            deferred.reject("timeout");\n        }, delay);\n        deferred.always(function () { clearTimeout(timer); });\n    }\n\n    /**\n     * @private\n     * Helper function to attempt a single connection to the node server\n     */\n    function attemptSingleConnect() {\n        var deferred = $.Deferred();\n        var port = null;\n        var ws = null;\n        setDeferredTimeout(deferred, CONNECTION_TIMEOUT);\n\n        brackets.app.getNodeState(function (err, nodePort) {\n            if (!err && nodePort && deferred.state() !== "rejected") {\n                port = nodePort;\n                ws = new WebSocket("ws://localhost:" + port);\n\n                // Expect ArrayBuffer objects from Node when receiving binary\n                // data instead of DOM Blobs, which are the default.\n                ws.binaryType = "arraybuffer";\n\n                // If the server port isn\'t open, we get a close event\n                // at some point in the future (and will not get an onopen\n                // event)\n                ws.onclose = function () {\n                    deferred.reject("WebSocket closed");\n                };\n\n                ws.onopen = function () {\n                    // If we successfully opened, remove the old onclose\n                    // handler (which was present to detect failure to\n                    // connect at all).\n                    ws.onclose = null;\n                    deferred.resolveWith(null, [ws, port]);\n                };\n            } else {\n                deferred.reject("brackets.app.getNodeState error: " + err);\n            }\n        });\n\n        return deferred.promise();\n    }\n\n    /**\n     * Provides an interface for interacting with the node server.\n     * @constructor\n     */\n    function NodeConnection() {\n        this.domains = {};\n        this._registeredModules = [];\n        this._pendingInterfaceRefreshDeferreds = [];\n        this._pendingCommandDeferreds = [];\n    }\n    EventDispatcher.makeEventDispatcher(NodeConnection.prototype);\n\n    /**\n     * @type {Object}\n     * Exposes the domains registered with the server. This object will\n     * have a property for each registered domain. Each of those properties\n     * will be an object containing properties for all the commands in that\n     * domain. So, myConnection.base.enableDebugger would point to the function\n     * to call to enable the debugger.\n     *\n     * This object is automatically replaced every time the API changes (based\n     * on the base:newDomains event from the server). Therefore, code that\n     * uses this object should not keep their own pointer to the domain property.\n     */\n    NodeConnection.prototype.domains = null;\n\n    /**\n     * @private\n     * @type {Array.<string>}\n     * List of module pathnames that should be re-registered if there is\n     * a disconnection/connection (i.e. if the server died).\n     */\n    NodeConnection.prototype._registeredModules = null;\n\n    /**\n     * @private\n     * @type {WebSocket}\n     * The connection to the server\n     */\n    NodeConnection.prototype._ws = null;\n\n    /**\n     * @private\n     * @type {?number}\n     * The port the WebSocket is currently connected to\n     */\n    NodeConnection.prototype._port = null;\n\n    /**\n     * @private\n     * @type {number}\n     * Unique ID for commands\n     */\n    NodeConnection.prototype._commandCount = 1;\n\n    /**\n     * @private\n     * @type {boolean}\n     * Whether to attempt reconnection if connection fails\n     */\n    NodeConnection.prototype._autoReconnect = false;\n\n    /**\n     * @private\n     * @type {Array.<jQuery.Deferred>}\n     * List of deferred objects that should be resolved pending\n     * a successful refresh of the API\n     */\n    NodeConnection.prototype._pendingInterfaceRefreshDeferreds = null;\n\n    /**\n     * @private\n     * @type {Array.<jQuery.Deferred>}\n     * Array (indexed on command ID) of deferred objects that should be\n     * resolved/rejected with the response of commands.\n     */\n    NodeConnection.prototype._pendingCommandDeferreds = null;\n\n    /**\n     * @private\n     * @return {number} The next command ID to use. Always representable as an\n     * unsigned 32-bit integer.\n     */\n    NodeConnection.prototype._getNextCommandID = function () {\n        var nextID;\n\n        if (this._commandCount > MAX_COUNTER_VALUE) {\n            nextID = this._commandCount = 0;\n        } else {\n            nextID = this._commandCount++;\n        }\n\n        return nextID;\n    };\n\n    /**\n     * @private\n     * Helper function to do cleanup work when a connection fails\n     */\n    NodeConnection.prototype._cleanup = function () {\n        // clear out the domains, since we may get different ones\n        // on the next connection\n        this.domains = {};\n\n        // shut down the old connection if there is one\n        if (this._ws && this._ws.readyState !== WebSocket.CLOSED) {\n            try {\n                this._ws.close();\n            } catch (e) { }\n        }\n        var failedDeferreds = this._pendingInterfaceRefreshDeferreds\n            .concat(this._pendingCommandDeferreds);\n        failedDeferreds.forEach(function (d) {\n            d.reject("cleanup");\n        });\n        this._pendingInterfaceRefreshDeferreds = [];\n        this._pendingCommandDeferreds = [];\n\n        this._ws = null;\n        this._port = null;\n    };\n\n    /**\n     * Connect to the node server. After connecting, the NodeConnection\n     * object will trigger a "close" event when the underlying socket\n     * is closed. If the connection is set to autoReconnect, then the\n     * event will also include a jQuery promise for the connection.\n     *\n     * @param {boolean} autoReconnect Whether to automatically try to\n     *    reconnect to the server if the connection succeeds and then\n     *    later disconnects. Note if this connection fails initially, the\n     *    autoReconnect flag is set to false. Future calls to connect()\n     *    can reset it to true\n     * @return {jQuery.Promise} Promise that resolves/rejects when the\n     *    connection succeeds/fails\n     */\n    NodeConnection.prototype.connect = function (autoReconnect) {\n        var self = this;\n        self._autoReconnect = autoReconnect;\n        var deferred = $.Deferred();\n        var attemptCount = 0;\n        var attemptTimestamp = null;\n\n        // Called after a successful connection to do final setup steps\n        function registerHandlersAndDomains(ws, port) {\n            // Called if we succeed at the final setup\n            function success() {\n                self._ws.onclose = function () {\n                    if (self._autoReconnect) {\n                        var $promise = self.connect(true);\n                        self.trigger("close", $promise);\n                    } else {\n                        self._cleanup();\n                        self.trigger("close");\n                    }\n                };\n                deferred.resolve();\n            }\n            // Called if we fail at the final setup\n            function fail(err) {\n                self._cleanup();\n                deferred.reject(err);\n            }\n\n            self._ws = ws;\n            self._port = port;\n            self._ws.onmessage = self._receive.bind(self);\n\n            // refresh the current domains, then re-register any\n            // "autoregister" modules\n            self._refreshInterface().then(\n                function () {\n                    if (self._registeredModules.length > 0) {\n                        self.loadDomains(self._registeredModules, false).then(\n                            success,\n                            fail\n                        );\n                    } else {\n                        success();\n                    }\n                },\n                fail\n            );\n        }\n\n        // Repeatedly tries to connect until we succeed or until we\'ve\n        // failed CONNECTION_ATTEMPT times. After each attempt, waits\n        // at least RETRY_DELAY before trying again.\n        function doConnect() {\n            attemptCount++;\n            attemptTimestamp = new Date();\n            attemptSingleConnect().then(\n                registerHandlersAndDomains, // succeded\n                function () { // failed this attempt, possibly try again\n                    if (attemptCount < CONNECTION_ATTEMPTS) { //try again\n                        // Calculate how long we should wait before trying again\n                        var now = new Date();\n                        var delay = Math.max(\n                            RETRY_DELAY - (now - attemptTimestamp),\n                            1\n                        );\n                        setTimeout(doConnect, delay);\n                    } else { // too many attempts, give up\n                        deferred.reject("Max connection attempts reached");\n                    }\n                }\n            );\n        }\n\n        // Start the connection process\n        self._cleanup();\n        doConnect();\n\n        return deferred.promise();\n    };\n\n    /**\n     * Determines whether the NodeConnection is currently connected\n     * @return {boolean} Whether the NodeConnection is connected.\n     */\n    NodeConnection.prototype.connected = function () {\n        return !!(this._ws && this._ws.readyState === WebSocket.OPEN);\n    };\n\n    /**\n     * Explicitly disconnects from the server. Note that even if\n     * autoReconnect was set to true at connection time, the connection\n     * will not reconnect after this call. Reconnection can be manually done\n     * by calling connect() again.\n     */\n    NodeConnection.prototype.disconnect = function () {\n        this._autoReconnect = false;\n        this._cleanup();\n    };\n\n    /**\n     * Load domains into the server by path\n     * @param {Array.<string>} List of absolute paths to load\n     * @param {boolean} autoReload Whether to auto-reload the domains if the server\n     *    fails and restarts. Note that the reload is initiated by the\n     *    client, so it will only happen after the client reconnects.\n     * @return {jQuery.Promise} Promise that resolves after the load has\n     *    succeeded and the new API is availale at NodeConnection.domains,\n     *    or that rejects on failure.\n     */\n    NodeConnection.prototype.loadDomains = function (paths, autoReload) {\n        var deferred = $.Deferred();\n        setDeferredTimeout(deferred, CONNECTION_TIMEOUT);\n        var pathArray = paths;\n        if (!Array.isArray(paths)) {\n            pathArray = [paths];\n        }\n\n        if (autoReload) {\n            Array.prototype.push.apply(this._registeredModules, pathArray);\n        }\n\n        if (this.domains.base && this.domains.base.loadDomainModulesFromPaths) {\n            this.domains.base.loadDomainModulesFromPaths(pathArray).then(\n                function (success) { // command call succeeded\n                    if (!success) {\n                        // response from commmand call was "false" so we know\n                        // the actual load failed.\n                        deferred.reject("loadDomainModulesFromPaths failed");\n                    }\n                    // if the load succeeded, we wait for the API refresh to\n                    // resolve the deferred.\n                },\n                function (reason) { // command call failed\n                    deferred.reject("Unable to load one of the modules: " + pathArray + (reason ? ", reason: " + reason : ""));\n                }\n            );\n\n            this._pendingInterfaceRefreshDeferreds.push(deferred);\n        } else {\n            deferred.reject("this.domains.base is undefined");\n        }\n\n        return deferred.promise();\n    };\n\n    /**\n     * @private\n     * Sends a message over the WebSocket. Automatically JSON.stringifys\n     * the message if necessary.\n     * @param {Object|string} m Object to send. Must be JSON.stringify-able.\n     */\n    NodeConnection.prototype._send = function (m) {\n        if (this.connected()) {\n\n            // Convert the message to a string\n            var messageString = null;\n            if (typeof m === "string") {\n                messageString = m;\n            } else {\n                try {\n                    messageString = JSON.stringify(m);\n                } catch (stringifyError) {\n                    console.error("[NodeConnection] Unable to stringify message in order to send: " + stringifyError.message);\n                }\n            }\n\n            // If we succeded in making a string, try to send it\n            if (messageString) {\n                try {\n                    this._ws.send(messageString);\n                } catch (sendError) {\n                    console.error("[NodeConnection] Error sending message: " + sendError.message);\n                }\n            }\n        } else {\n            console.error("[NodeConnection] Not connected to node, unable to send.");\n        }\n    };\n\n    /**\n     * @private\n     * Handler for receiving events on the WebSocket. Parses the message\n     * and dispatches it appropriately.\n     * @param {WebSocket.Message} message Message object from WebSocket\n     */\n    NodeConnection.prototype._receive = function (message) {\n        var responseDeferred = null;\n        var data = message.data;\n        var m;\n\n        if (message.data instanceof ArrayBuffer) {\n            // The first four bytes encode the command ID as an unsigned 32-bit integer\n            if (data.byteLength < 4) {\n                console.error("[NodeConnection] received malformed binary message");\n                return;\n            }\n\n            var header = data.slice(0, 4),\n                body = data.slice(4),\n                headerView = new Uint32Array(header),\n                id = headerView[0];\n\n            // Unpack the binary message into a commandResponse\n            m = {\n                type: "commandResponse",\n                message: {\n                    id: id,\n                    response: body\n                }\n            };\n        } else {\n            try {\n                m = JSON.parse(data);\n            } catch (e) {\n                console.error("[NodeConnection] received malformed message", message, e.message);\n                return;\n            }\n        }\n\n        switch (m.type) {\n        case "event":\n            if (m.message.domain === "base" && m.message.event === "newDomains") {\n                this._refreshInterface();\n            }\n\n            // Event type "domain:event"\n            EventDispatcher.triggerWithArray(this, m.message.domain + ":" + m.message.event,\n                                             m.message.parameters);\n            break;\n        case "commandResponse":\n            responseDeferred = this._pendingCommandDeferreds[m.message.id];\n            if (responseDeferred) {\n                responseDeferred.resolveWith(this, [m.message.response]);\n                delete this._pendingCommandDeferreds[m.message.id];\n            }\n            break;\n        case "commandProgress":\n            responseDeferred = this._pendingCommandDeferreds[m.message.id];\n            if (responseDeferred) {\n                responseDeferred.notifyWith(this, [m.message.message]);\n            }\n            break;\n        case "commandError":\n            responseDeferred = this._pendingCommandDeferreds[m.message.id];\n            if (responseDeferred) {\n                responseDeferred.rejectWith(\n                    this,\n                    [m.message.message, m.message.stack]\n                );\n                delete this._pendingCommandDeferreds[m.message.id];\n            }\n            break;\n        case "error":\n            console.error("[NodeConnection] received error: " +\n                            m.message.message);\n            break;\n        default:\n            console.error("[NodeConnection] unknown event type: " + m.type);\n        }\n    };\n\n    /**\n     * @private\n     * Helper function for refreshing the interface in the "domain" property.\n     * Automatically called when the connection receives a base:newDomains\n     * event from the server, and also called at connection time.\n     */\n    NodeConnection.prototype._refreshInterface = function () {\n        var deferred = $.Deferred();\n        var self = this;\n\n        var pendingDeferreds = this._pendingInterfaceRefreshDeferreds;\n        this._pendingInterfaceRefreshDeferreds = [];\n        deferred.then(\n            function () {\n                pendingDeferreds.forEach(function (d) { d.resolve(); });\n            },\n            function (err) {\n                pendingDeferreds.forEach(function (d) { d.reject(err); });\n            }\n        );\n\n        function refreshInterfaceCallback(spec) {\n            function makeCommandFunction(domainName, commandSpec) {\n                return function () {\n                    var deferred = $.Deferred();\n                    var parameters = Array.prototype.slice.call(arguments, 0);\n                    var id = self._getNextCommandID();\n                    self._pendingCommandDeferreds[id] = deferred;\n                    self._send({id: id,\n                               domain: domainName,\n                               command: commandSpec.name,\n                               parameters: parameters\n                               });\n                    return deferred;\n                };\n            }\n\n            // TODO: Don\'t replace the domain object every time. Instead, merge.\n            self.domains = {};\n            self.domainEvents = {};\n            spec.forEach(function (domainSpec) {\n                self.domains[domainSpec.domain] = {};\n                domainSpec.commands.forEach(function (commandSpec) {\n                    self.domains[domainSpec.domain][commandSpec.name] =\n                        makeCommandFunction(domainSpec.domain, commandSpec);\n                });\n                self.domainEvents[domainSpec.domain] = {};\n                domainSpec.events.forEach(function (eventSpec) {\n                    var parameters = eventSpec.parameters;\n                    self.domainEvents[domainSpec.domain][eventSpec.name] = parameters;\n                });\n            });\n            deferred.resolve();\n        }\n\n        if (this.connected()) {\n            $.getJSON("http://localhost:" + this._port + "/api")\n                .done(refreshInterfaceCallback)\n                .fail(function (err) { deferred.reject(err); });\n        } else {\n            deferred.reject("Attempted to call _refreshInterface when not connected.");\n        }\n\n        return deferred.promise();\n    };\n\n    /**\n     * @private\n     * Get the default timeout value\n     * @return {number} Timeout value in milliseconds\n     */\n    NodeConnection._getConnectionTimeout = function () {\n        return CONNECTION_TIMEOUT;\n    };\n\n    module.exports = NodeConnection;\n\n});\n\n//# sourceURL=/utils/NodeConnection.js'),
eval('/*\n * Copyright (c) 2013 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, regexp: true, indent: 4, maxerr: 50 */\n/*global define, $ */\n\ndefine(\'utils/NodeDomain\',[\'require\',\'exports\',\'module\',\'utils/NodeConnection\',\'utils/EventDispatcher\'],function (require, exports, module) {\n    "use strict";\n\n    var NodeConnection = require("utils/NodeConnection"),\n        EventDispatcher = require("utils/EventDispatcher");\n\n    // Used to remove all listeners at once when the connection drops\n    var EVENT_NAMESPACE = ".NodeDomainEvent";\n\n    /**\n     * Provides a simple abstraction for executing the commands of a single\n     * domain loaded via a NodeConnection. Automatically handles connection\n     * management and domain loading, and exposes each command in the domain as\n     * a promise-returning method that can safely be called regardless of the\n     * current status of the underlying connection. Example usage:\n     *\n     *     var myDomain = new NodeDomain("someDomain", "/path/to/SomeDomainDef.js"),\n     *         $result = myDomain.exec("someCommand", arg1, arg2);\n     *\n     *     $result.done(function (value) {\n     *         // the command succeeded!\n     *     });\n     *\n     *     $result.fail(function (err) {\n     *         // the command failed; act accordingly!\n     *     });\n     *\n     * To handle domain events, just listen for the event on the domain:\n     *\n     *     myDomain.on("someEvent", someHandler);\n     *\n     * @constructor\n     * @param {string} domainName Name of the registered Node Domain\n     * @param {string} domainPath Full path of the JavaScript Node domain specification\n     */\n    function NodeDomain(domainName, domainPath) {\n        var connection = new NodeConnection();\n\n        this.connection = connection;\n        this._domainName = domainName;\n        this._domainPath = domainPath;\n        this._domainLoaded = false;\n        this._load = this._load.bind(this);\n        this._connectionPromise = connection.connect(true)\n            .then(this._load);\n\n        connection.on("close", function (event, promise) {\n            this.connection.off(EVENT_NAMESPACE);\n            this._domainLoaded = false;\n            this._connectionPromise = promise.then(this._load);\n        }.bind(this));\n    }\n    EventDispatcher.makeEventDispatcher(NodeDomain.prototype);\n\n    /**\n     * The underlying Node connection object for this domain.\n     *\n     * @type {NodeConnection}\n     */\n    NodeDomain.prototype.connection = null;\n\n    /**\n     * A promise that is resolved once the NodeConnection is connected and the\n     * domain has been loaded.\n     *\n     * @type {?jQuery.Promise}\n     * @private\n     */\n    NodeDomain.prototype._connectionPromise = null;\n\n    /**\n     * The name of this domain.\n     *\n     * @type {string}\n     * @private\n     */\n    NodeDomain.prototype._domainName = null;\n\n    /**\n     * The path at which the Node definition of this domain resides.\n     *\n     * @type {string}\n     * @private\n     */\n    NodeDomain.prototype._domainPath = null;\n\n    /**\n     * Whether or not the domain has been successfully loaded.\n     *\n     * @type {boolean}\n     * @private\n     */\n    NodeDomain.prototype._domainLoaded = false;\n\n    /**\n     * Loads the domain via the underlying connection object and exposes the\n     * domain\'s commands as methods on this object. Assumes the underlying\n     * connection has already been opened.\n     *\n     * @return {jQuery.Promise} Resolves once the domain is been loaded.\n     * @private\n     */\n    NodeDomain.prototype._load = function () {\n        var connection = this.connection;\n        return connection.loadDomains(this._domainPath, true)\n            .done(function () {\n                this._domainLoaded = true;\n                this._connectionPromise = null;\n\n                var eventNames = Object.keys(connection.domainEvents[this._domainName]);\n                eventNames.forEach(function (domainEvent) {\n                    var connectionEvent = this._domainName + ":" + domainEvent + EVENT_NAMESPACE;\n\n                    connection.on(connectionEvent, function () {\n                        var params = Array.prototype.slice.call(arguments, 1);\n                        EventDispatcher.triggerWithArray(this, domainEvent, params);\n                    }.bind(this));\n                }, this);\n            }.bind(this))\n            .fail(function (err) {\n                console.error("[NodeDomain] Error loading domain \\"" + this._domainName + "\\": " + err);\n            }.bind(this));\n    };\n\n    /**\n     * Synchronously determine whether the domain is ready; i.e., whether the\n     * connection is open and the domain is loaded.\n     *\n     * @return {boolean} Whether or not the domain is currently ready.\n     */\n    NodeDomain.prototype.ready = function () {\n        return this._domainLoaded && this.connection.connected();\n    };\n\n    /**\n     * Get a promise that resolves when the connection is open and the domain\n     * is loaded.\n     *\n     * @return {jQuery.Promise}\n     */\n    NodeDomain.prototype.promise = function () {\n        if (this._connectionPromise) {\n            return this._connectionPromise;\n        } else {\n            var deferred = new $.Deferred();\n\n            if (this.ready()) {\n                deferred.resolve();\n            } else {\n                deferred.reject();\n            }\n\n            return deferred.promise();\n        }\n    };\n\n    /**\n     * Applies the named command from the domain to a list of parameters, which\n     * are passed as extra arguments to this method. If the connection is open\n     * and the domain is loaded, the function is applied immediately. Otherwise\n     * the function is applied as soon as the connection has been opened and the\n     * domain has finished loading.\n     *\n     * @param {string} name The name of the domain command to execute\n     * @return {jQuery.Promise} Resolves with the result of the command\n     */\n    NodeDomain.prototype.exec = function (name) {\n        var connection = this.connection,\n            params = Array.prototype.slice.call(arguments, 1),\n            execConnected = function () {\n                var domain  = connection.domains[this._domainName],\n                    fn      = domain && domain[name],\n                    execResult;\n\n                if (fn) {\n                    execResult = fn.apply(domain, params);\n                } else {\n                    execResult = new $.Deferred().reject().promise();\n                }\n                return execResult;\n            }.bind(this);\n\n        var result;\n        if (this.ready()) {\n            result = execConnected();\n        } else if (this._connectionPromise) {\n            result = this._connectionPromise.then(execConnected);\n        } else {\n            result = new $.Deferred.reject().promise();\n        }\n        return result;\n    };\n\n    module.exports = NodeDomain;\n});\n\n//# sourceURL=/utils/NodeDomain.js'),eval('/*\n * Copyright (c) 2013 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, regexp: true, indent: 4, maxerr: 50 */\n/*global define, appshell, window */\n\ndefine(\'fileSystemImpl\',[\'require\',\'exports\',\'module\',\'file/FileUtils\',\'filesystem/FileSystemStats\',\'filesystem/FileSystemError\',\'utils/NodeDomain\'],function (require, exports, module) {\n    "use strict";\n\n    var FileUtils           = require("file/FileUtils"),\n        FileSystemStats     = require("filesystem/FileSystemStats"),\n        FileSystemError     = require("filesystem/FileSystemError"),\n        NodeDomain          = require("utils/NodeDomain");\n\n    /**\n     * @const\n     */\n    var FILE_WATCHER_BATCH_TIMEOUT = 200;   // 200ms - granularity of file watcher changes\n\n    /**\n     * Callback to notify FileSystem of watcher changes\n     * @type {?function(string, FileSystemStats=)}\n     */\n    var _changeCallback;\n\n    /**\n     * Callback to notify FileSystem if watchers stop working entirely\n     * @type {?function()}\n     */\n    var _offlineCallback;\n\n    /** Timeout used to batch up file watcher changes (setTimeout() return value) */\n    var _changeTimeout;\n\n    /**\n     * Pending file watcher changes - map from fullPath to flag indicating whether we need to pass stats\n     * to _changeCallback() for this path.\n     * @type {!Object.<string, boolean>}\n     */\n    var _pendingChanges = {};\n\n    var _bracketsPath   = FileUtils.getNativeBracketsDirectoryPath(),\n        _modulePath     = FileUtils.getNativeModuleDirectoryPath(module),\n        _nodePath       = "node/FileWatcherDomain",\n        _domainPath     = [_bracketsPath, _modulePath, _nodePath].join("/"),\n        _nodeDomain     = new NodeDomain("fileWatcher", _domainPath);\n\n    var _isRunningOnWindowsXP = window.navigator.userAgent.indexOf("Windows NT 5.") >= 0;\n\n\n    // If the connection closes, notify the FileSystem that watchers have gone offline.\n    _nodeDomain.connection.on("close", function (event, promise) {\n        if (_offlineCallback) {\n            _offlineCallback();\n        }\n    });\n\n    /**\n     * Enqueue a file change event for eventual reporting back to the FileSystem.\n     *\n     * @param {string} changedPath The path that was changed\n     * @param {boolean} needsStats Whether or not the eventual change event should include stats\n     * @private\n     */\n    function _enqueueChange(changedPath, needsStats) {\n        _pendingChanges[changedPath] = _pendingChanges[changedPath] || needsStats;\n\n        if (!_changeTimeout) {\n            _changeTimeout = window.setTimeout(function () {\n                if (_changeCallback) {\n                    Object.keys(_pendingChanges).forEach(function (path) {\n                        var needsStats = _pendingChanges[path];\n                        if (needsStats) {\n                            exports.stat(path, function (err, stats) {\n                                if (err) {\n                                    // warning has been removed due to spamming the console - see #7332\n                                    // console.warn("Unable to stat changed path: ", path, err);\n                                    return;\n                                }\n                                _changeCallback(path, stats);\n                            });\n                        } else {\n                            _changeCallback(path);\n                        }\n                    });\n                }\n\n                _changeTimeout = null;\n                _pendingChanges = {};\n            }, FILE_WATCHER_BATCH_TIMEOUT);\n        }\n    }\n\n    /**\n     * Event handler for the Node fileWatcher domain\'s change event.\n     *\n     * @param {jQuery.Event} The underlying change event\n     * @param {string} path The path that is reported to have changed\n     * @param {string} event The type of the event: either "change" or "rename"\n     * @param {string=} filename The name of the file that changed.\n     * @private\n     */\n    function _fileWatcherChange(evt, path, event, filename) {\n        var change;\n\n        if (event === "change") {\n            // Only register change events if filename is passed\n            if (filename) {\n                // an existing file was modified; stats are needed\n                change = path + filename;\n                _enqueueChange(change, true);\n            }\n        } else if (event === "rename") {\n            // a new file was created; no stats are needed\n            change = path;\n            _enqueueChange(change, false);\n        }\n    }\n\n    // Setup the change handler. This only needs to happen once.\n    _nodeDomain.on("change", _fileWatcherChange);\n\n    /**\n     * Convert appshell error codes to FileSystemError values.\n     *\n     * @param {?number} err An appshell error code\n     * @return {?string} A FileSystemError string, or null if there was no error code.\n     * @private\n     */\n    function _mapError(err) {\n        if (!err) {\n            return null;\n        }\n\n        switch (err) {\n        case appshell.fs.ERR_INVALID_PARAMS:\n            return FileSystemError.INVALID_PARAMS;\n        case appshell.fs.ERR_NOT_FOUND:\n            return FileSystemError.NOT_FOUND;\n        case appshell.fs.ERR_CANT_READ:\n            return FileSystemError.NOT_READABLE;\n        case appshell.fs.ERR_CANT_WRITE:\n            return FileSystemError.NOT_WRITABLE;\n        case appshell.fs.ERR_UNSUPPORTED_ENCODING:\n            return FileSystemError.UNSUPPORTED_ENCODING;\n        case appshell.fs.ERR_OUT_OF_SPACE:\n            return FileSystemError.OUT_OF_SPACE;\n        case appshell.fs.ERR_FILE_EXISTS:\n            return FileSystemError.ALREADY_EXISTS;\n        }\n        return FileSystemError.UNKNOWN;\n    }\n\n    /**\n     * Convert a callback to one that transforms its first parameter from an\n     * appshell error code to a FileSystemError string.\n     *\n     * @param {function(?number)} cb A callback that expects an appshell error code\n     * @return {function(?string)} A callback that expects a FileSystemError string\n     * @private\n     */\n    function _wrap(cb) {\n        return function (err) {\n            var args = Array.prototype.slice.call(arguments);\n            args[0] = _mapError(args[0]);\n            cb.apply(null, args);\n        };\n    }\n\n    /**\n     * Display an open-files dialog to the user and call back asynchronously with\n     * either a FileSystmError string or an array of path strings, which indicate\n     * the entry or entries selected.\n     *\n     * @param {boolean} allowMultipleSelection\n     * @param {boolean} chooseDirectories\n     * @param {string} title\n     * @param {string} initialPath\n     * @param {Array.<string>=} fileTypes\n     * @param {function(?string, Array.<string>=)} callback\n     */\n    function showOpenDialog(allowMultipleSelection, chooseDirectories, title, initialPath, fileTypes, callback) {\n        appshell.fs.showOpenDialog(allowMultipleSelection, chooseDirectories, title, initialPath, fileTypes, _wrap(callback));\n    }\n\n    /**\n     * Display a save-file dialog and call back asynchronously with either a\n     * FileSystemError string or the path to which the user has chosen to save\n     * the file. If the dialog is cancelled, the path string will be empty.\n     *\n     * @param {string} title\n     * @param {string} initialPath\n     * @param {string} proposedNewFilename\n     * @param {function(?string, string=)} callback\n     */\n    function showSaveDialog(title, initialPath, proposedNewFilename, callback) {\n        appshell.fs.showSaveDialog(title, initialPath, proposedNewFilename, _wrap(callback));\n    }\n\n    /**\n     * Stat the file or directory at the given path, calling back\n     * asynchronously with either a FileSystemError string or the entry\'s\n     * associated FileSystemStats object.\n     *\n     * @param {string} path\n     * @param {function(?string, FileSystemStats=)} callback\n     */\n    function stat(path, callback) {\n        appshell.fs.stat(path, function (err, stats) {\n            if (err) {\n                callback(_mapError(err));\n            } else {\n                var options = {\n                    isFile: stats.isFile(),\n                    mtime: stats.mtime,\n                    size: stats.size,\n                    realPath: stats.realPath,\n                    hash: stats.mtime.getTime()\n                };\n\n                var fsStats = new FileSystemStats(options);\n\n                callback(null, fsStats);\n            }\n        });\n    }\n\n    /**\n     * Determine whether a file or directory exists at the given path by calling\n     * back asynchronously with either a FileSystemError string or a boolean,\n     * which is true if the file exists and false otherwise. The error will never\n     * be FileSystemError.NOT_FOUND; in that case, there will be no error and the\n     * boolean parameter will be false.\n     *\n     * @param {string} path\n     * @param {function(?string, boolean)} callback\n     */\n    function exists(path, callback) {\n        stat(path, function (err) {\n            if (err) {\n                if (err === FileSystemError.NOT_FOUND) {\n                    callback(null, false);\n                } else {\n                    callback(err);\n                }\n                return;\n            }\n\n            callback(null, true);\n        });\n    }\n\n    /**\n     * Read the contents of the directory at the given path, calling back\n     * asynchronously either with a FileSystemError string or an array of\n     * FileSystemEntry objects along with another consistent array, each index\n     * of which either contains a FileSystemStats object for the corresponding\n     * FileSystemEntry object in the second parameter or a FileSystemError\n     * string describing a stat error.\n     *\n     * @param {string} path\n     * @param {function(?string, Array.<FileSystemEntry>=, Array.<string|FileSystemStats>=)} callback\n     */\n    function readdir(path, callback) {\n        appshell.fs.readdir(path, function (err, contents) {\n            if (err) {\n                callback(_mapError(err));\n                return;\n            }\n\n            var count = contents.length;\n            if (!count) {\n                callback(null, [], []);\n                return;\n            }\n\n            var stats = [];\n            contents.forEach(function (val, idx) {\n                stat(path + "/" + val, function (err, stat) {\n                    stats[idx] = err || stat;\n                    count--;\n                    if (count <= 0) {\n                        callback(null, contents, stats);\n                    }\n                });\n            });\n        });\n    }\n\n    /**\n     * Create a directory at the given path, and call back asynchronously with\n     * either a FileSystemError string or a stats object for the newly created\n     * directory. The octal mode parameter is optional; if unspecified, the mode\n     * of the created directory is implementation dependent.\n     *\n     * @param {string} path\n     * @param {number=} mode The base-eight mode of the newly created directory.\n     * @param {function(?string, FileSystemStats=)=} callback\n     */\n    function mkdir(path, mode, callback) {\n        if (typeof mode === "function") {\n            callback = mode;\n            mode = parseInt("0755", 8);\n        }\n        appshell.fs.makedir(path, mode, function (err) {\n            if (err) {\n                callback(_mapError(err));\n            } else {\n                stat(path, function (err, stat) {\n                    callback(err, stat);\n                });\n            }\n        });\n    }\n\n    /**\n     * Rename the file or directory at oldPath to newPath, and call back\n     * asynchronously with a possibly null FileSystemError string.\n     *\n     * @param {string} oldPath\n     * @param {string} newPath\n     * @param {function(?string)=} callback\n     */\n    function rename(oldPath, newPath, callback) {\n        appshell.fs.rename(oldPath, newPath, _wrap(callback));\n    }\n\n    /**\n     * Read the contents of the file at the given path, calling back\n     * asynchronously with either a FileSystemError string, or with the data and\n     * the FileSystemStats object associated with the read file. The options\n     * parameter can be used to specify an encoding (default "utf8"), and also\n     * a cached stats object that the implementation is free to use in order\n     * to avoid an additional stat call.\n     *\n     * Note: if either the read or the stat call fails then neither the read data\n     * nor stat will be passed back, and the call should be considered to have failed.\n     * If both calls fail, the error from the read call is passed back.\n     *\n     * @param {string} path\n     * @param {{encoding: string=, stat: FileSystemStats=}} options\n     * @param {function(?string, string=, FileSystemStats=)} callback\n     */\n    function readFile(path, options, callback) {\n        var encoding = options.encoding || "utf8";\n\n        // callback to be executed when the call to stat completes\n        //  or immediately if a stat object was passed as an argument\n        function doReadFile(stat) {\n            if (stat.size > (FileUtils.MAX_FILE_SIZE)) {\n                callback(FileSystemError.EXCEEDS_MAX_FILE_SIZE);\n            } else {\n                appshell.fs.readFile(path, encoding, function (_err, _data) {\n                    if (_err) {\n                        callback(_mapError(_err));\n                    } else {\n                        callback(null, _data, stat);\n                    }\n                });\n            }\n        }\n\n        if (options.stat) {\n            doReadFile(options.stat);\n        } else {\n            exports.stat(path, function (_err, _stat) {\n                if (_err) {\n                    callback(_err);\n                } else {\n                    doReadFile(_stat);\n                }\n            });\n        }\n    }\n    /**\n     * Write data to the file at the given path, calling back asynchronously with\n     * either a FileSystemError string or the FileSystemStats object associated\n     * with the written file and a boolean that indicates whether the file was\n     * created by the write (true) or not (false). If no file exists at the\n     * given path, a new file will be created. The options parameter can be used\n     * to specify an encoding (default "utf8"), an octal mode (default\n     * unspecified and implementation dependent), and a consistency hash, which\n     * is used to the current state of the file before overwriting it. If a\n     * consistency hash is provided but does not match the hash of the file on\n     * disk, a FileSystemError.CONTENTS_MODIFIED error is passed to the callback.\n     *\n     * @param {string} path\n     * @param {string} data\n     * @param {{encoding : string=, mode : number=, expectedHash : object=, expectedContents : string=}} options\n     * @param {function(?string, FileSystemStats=, boolean)} callback\n     */\n    function writeFile(path, data, options, callback) {\n        var encoding = options.encoding || "utf8";\n\n        function _finishWrite(created) {\n            appshell.fs.writeFile(path, data, encoding, function (err) {\n                if (err) {\n                    callback(_mapError(err));\n                } else {\n                    stat(path, function (err, stat) {\n                        callback(err, stat, created);\n                    });\n                }\n            });\n        }\n\n        stat(path, function (err, stats) {\n            if (err) {\n                switch (err) {\n                case FileSystemError.NOT_FOUND:\n                    _finishWrite(true);\n                    break;\n                default:\n                    callback(err);\n                }\n                return;\n            }\n\n            if (options.hasOwnProperty("expectedHash") && options.expectedHash !== stats._hash) {\n                console.error("Blind write attempted: ", path, stats._hash, options.expectedHash);\n\n                if (options.hasOwnProperty("expectedContents")) {\n                    appshell.fs.readFile(path, encoding, function (_err, _data) {\n                        if (_err || _data !== options.expectedContents) {\n                            callback(FileSystemError.CONTENTS_MODIFIED);\n                            return;\n                        }\n\n                        _finishWrite(false);\n                    });\n                    return;\n                } else {\n                    callback(FileSystemError.CONTENTS_MODIFIED);\n                    return;\n                }\n            }\n\n            _finishWrite(false);\n        });\n    }\n\n    /**\n     * Unlink (i.e., permanently delete) the file or directory at the given path,\n     * calling back asynchronously with a possibly null FileSystemError string.\n     * Directories will be unlinked even when non-empty.\n     *\n     * @param {string} path\n     * @param {function(string)=} callback\n     */\n    function unlink(path, callback) {\n        appshell.fs.unlink(path, function (err) {\n            callback(_mapError(err));\n        });\n    }\n\n    /**\n     * Move the file or directory at the given path to a system dependent trash\n     * location, calling back asynchronously with a possibly null FileSystemError\n     * string. Directories will be moved even when non-empty.\n     *\n     * @param {string} path\n     * @param {function(string)=} callback\n     */\n    function moveToTrash(path, callback) {\n        appshell.fs.moveToTrash(path, function (err) {\n            callback(_mapError(err));\n        });\n    }\n\n    /**\n     * Initialize file watching for this filesystem, using the supplied\n     * changeCallback to provide change notifications. The first parameter of\n     * changeCallback specifies the changed path (either a file or a directory);\n     * if this parameter is null, it indicates that the implementation cannot\n     * specify a particular changed path, and so the callers should consider all\n     * paths to have changed and to update their state accordingly. The second\n     * parameter to changeCallback is an optional FileSystemStats object that\n     * may be provided in case the changed path already exists and stats are\n     * readily available. The offlineCallback will be called in case watchers\n     * are no longer expected to function properly. All watched paths are\n     * cleared when the offlineCallback is called.\n     *\n     * @param {function(?string, FileSystemStats=)} changeCallback\n     * @param {function()=} offlineCallback\n     */\n    function initWatchers(changeCallback, offlineCallback) {\n        _changeCallback = changeCallback;\n        _offlineCallback = offlineCallback;\n\n        if (_isRunningOnWindowsXP && _offlineCallback) {\n            _offlineCallback();\n        }\n    }\n\n    /**\n     * Start providing change notifications for the file or directory at the\n     * given path, calling back asynchronously with a possibly null FileSystemError\n     * string when the initialization is complete. Notifications are provided\n     * using the changeCallback function provided by the initWatchers method.\n     * Note that change notifications are only provided recursively for directories\n     * when the recursiveWatch property of this module is true.\n     *\n     * @param {string} path\n     * @param {function(?string)=} callback\n     */\n    function watchPath(path, callback) {\n        if (_isRunningOnWindowsXP) {\n            callback(FileSystemError.NOT_SUPPORTED);\n            return;\n        }\n        appshell.fs.isNetworkDrive(path, function (err, isNetworkDrive) {\n            if (err || isNetworkDrive) {\n                if (isNetworkDrive) {\n                    callback(FileSystemError.NETWORK_DRIVE_NOT_SUPPORTED);\n                } else {\n                    callback(FileSystemError.UNKNOWN);\n                }\n                return;\n            }\n            _nodeDomain.exec("watchPath", path)\n                .then(callback, callback);\n        });\n    }\n    /**\n     * Stop providing change notifications for the file or directory at the\n     * given path, calling back asynchronously with a possibly null FileSystemError\n     * string when the operation is complete.\n     *\n     * @param {string} path\n     * @param {function(?string)=} callback\n     */\n    function unwatchPath(path, callback) {\n        _nodeDomain.exec("unwatchPath", path)\n            .then(callback, callback);\n    }\n\n    /**\n     * Stop providing change notifications for all previously watched files and\n     * directories, optionally calling back asynchronously with a possibly null\n     * FileSystemError string when the operation is complete.\n     *\n     * @param {function(?string)=} callback\n     */\n    function unwatchAll(callback) {\n        _nodeDomain.exec("unwatchAll")\n            .then(callback, callback);\n    }\n\n\n    // Export public API\n    exports.showOpenDialog  = showOpenDialog;\n    exports.showSaveDialog  = showSaveDialog;\n    exports.exists          = exists;\n    exports.readdir         = readdir;\n    exports.mkdir           = mkdir;\n    exports.rename          = rename;\n    exports.stat            = stat;\n    exports.readFile        = readFile;\n    exports.writeFile       = writeFile;\n    exports.unlink          = unlink;\n    exports.moveToTrash     = moveToTrash;\n    exports.initWatchers    = initWatchers;\n    exports.watchPath       = watchPath;\n    exports.unwatchPath     = unwatchPath;\n    exports.unwatchAll      = unwatchAll;\n\n    /**\n     * Indicates whether or not recursive watching notifications are supported\n     * by the watchPath call. Currently, only Darwin supports recursive watching.\n     *\n     * @type {boolean}\n     */\n    exports.recursiveWatch = (appshell.platform === "mac" || appshell.platform === "win");\n\n    /**\n     * Indicates whether or not the filesystem should expect and normalize UNC\n     * paths. If set, then //server/directory/ is a normalized path; otherwise the\n     * filesystem will normalize it to /server/directory. Currently, UNC path\n     * normalization only occurs on Windows.\n     *\n     * @type {boolean}\n     */\n    exports.normalizeUNCPaths = appshell.platform === "win";\n});\n\n//# sourceURL=/filesystem/impls/appshell/AppshellFileSystem.js'),
eval('/*\n * Copyright (c) 2013 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, regexp: true, indent: 4, maxerr: 50 */\n/*global define */\n\n/**\n * FileSystem is a model object representing a complete file system. This object creates\n * and manages File and Directory instances, dispatches events when the file system changes,\n * and provides methods for showing \'open\' and \'save\' dialogs.\n *\n * FileSystem automatically initializes when loaded. It depends on a pluggable "impl" layer, which\n * it loads itself but must be designated in the require.config() that loads FileSystem. For details\n * see: https://github.com/adobe/brackets/wiki/File-System-Implementations\n *\n * There are three ways to get File or Directory instances:\n *    * Use FileSystem.resolve() to convert a path to a File/Directory object. This will only\n *      succeed if the file/directory already exists.\n *    * Use FileSystem.getFileForPath()/FileSystem.getDirectoryForPath() if you know the\n *      file/directory already exists, or if you want to create a new entry.\n *    * Use Directory.getContents() to return all entries for the specified Directory.\n *\n * All paths passed *to* FileSystem APIs must be in the following format:\n *    * The path separator is "/" regardless of platform\n *    * Paths begin with "/" on Mac/Linux and "c:/" (or some other drive letter) on Windows\n *\n * All paths returned *from* FileSystem APIs additionally meet the following guarantees:\n *    * No ".." segments\n *    * No consecutive "/"s\n *    * Paths to a directory always end with a trailing "/"\n * (Because FileSystem normalizes paths automatically, paths passed *to* FileSystem do not need\n * to meet these requirements)\n *\n * FileSystem dispatches the following events:\n * (NOTE: attach to these events via `FileSystem.on()` - not `$(FileSystem).on()`)\n *\n * __change__ - Sent whenever there is a change in the file system. The handler\n *   is passed up to three arguments: the changed entry and, if that changed entry\n *   is a Directory, a list of entries added to the directory and a list of entries\n *   removed from the Directory. The entry argument can be:\n *   *  a File - the contents of the file have changed, and should be reloaded.\n *   *  a Directory - an immediate child of the directory has been added, removed,\n *      or renamed/moved. Not triggered for "grandchildren".\n *      - If the added & removed arguments are null, we don\'t know what was added/removed:\n *        clients should assume the whole subtree may have changed.\n *      - If the added & removed arguments are 0-length, there\'s no net change in the set\n *        of files but a file may have been replaced: clients should assume the contents\n *        of any immediate child file may have changed.\n *   *  null - a \'wholesale\' change happened, and you should assume everything may\n *      have changed.\n *   For changes made externally, there may be a significant delay before a "change" event\n *   is dispatched.\n *\n * __rename__ - Sent whenever a File or Directory is renamed. All affected File and Directory\n *   objects have been updated to reflect the new path by the time this event is dispatched.\n *   This event should be used to trigger any UI updates that may need to occur when a path\n *   has changed. Note that these events will only be sent for rename operations that happen\n *   within the filesystem. If a file is renamed externally, a change event on the parent\n *   directory will be sent instead.\n *\n * FileSystem may perform caching. But it guarantees:\n *    * File contents & metadata - reads are guaranteed to be up to date (cached data is not used\n *      without first veryifying it is up to date).\n *    * Directory structure / file listing - reads may return cached data immediately, which may not\n *      reflect external changes made recently. (However, changes made via FileSystem itself are always\n *      reflected immediately, as soon as the change operation\'s callback signals success).\n *\n * The FileSystem doesn\'t directly read or write contents--this work is done by a low-level\n * implementation object. This allows client code to use the FileSystem API without having to\n * worry about the underlying storage, which could be a local filesystem or a remote server.\n */\ndefine(\'filesystem/FileSystem\',[\'require\',\'exports\',\'module\',\'filesystem/Directory\',\'filesystem/File\',\'filesystem/FileIndex\',\'filesystem/FileSystemError\',\'filesystem/WatchedRoot\',\'utils/EventDispatcher\',\'fileSystemImpl\'],function (require, exports, module) {\n    "use strict";\n\n    var Directory       = require("filesystem/Directory"),\n        File            = require("filesystem/File"),\n        FileIndex       = require("filesystem/FileIndex"),\n        FileSystemError = require("filesystem/FileSystemError"),\n        WatchedRoot     = require("filesystem/WatchedRoot"),\n        EventDispatcher = require("utils/EventDispatcher");\n\n    /**\n     * The FileSystem is not usable until init() signals its callback.\n     * @constructor\n     */\n    function FileSystem() {\n        // Create a file index\n        this._index = new FileIndex();\n\n        // Initialize the set of watched roots\n        this._watchedRoots = {};\n\n        // Initialize the watch/unwatch request queue\n        this._watchRequests = [];\n\n        // Initialize the queue of pending external changes\n        this._externalChanges = [];\n    }\n    EventDispatcher.makeEventDispatcher(FileSystem.prototype);\n\n    /**\n     * The low-level file system implementation used by this object.\n     * This is set in the init() function and cannot be changed.\n     */\n    FileSystem.prototype._impl = null;\n\n    /**\n     * The FileIndex used by this object. This is initialized in the constructor.\n     */\n    FileSystem.prototype._index = null;\n\n    /**\n     * Refcount of any pending filesystem mutation operations (e.g., writes,\n     * unlinks, etc.). Used to ensure that external change events aren\'t processed\n     * until after index fixups, operation-specific callbacks, and internal change\n     * events are complete. (This is important for distinguishing rename from\n     * an unrelated delete-add pair).\n     * @type {number}\n     */\n    FileSystem.prototype._activeChangeCount = 0;\n\n    // For unit testing only\n    FileSystem.prototype._getActiveChangeCount = function () {\n        return this._activeChangeCount;\n    };\n\n    /**\n     * Queue of arguments with which to invoke _handleExternalChanges(); triggered\n     * once _activeChangeCount drops to zero.\n     * @type {!Array.<{path:?string, stat:FileSystemStats=}>}\n     */\n    FileSystem.prototype._externalChanges = null;\n\n    /** Process all queued watcher results, by calling _handleExternalChange() on each */\n    FileSystem.prototype._triggerExternalChangesNow = function () {\n        this._externalChanges.forEach(function (info) {\n            this._handleExternalChange(info.path, info.stat);\n        }, this);\n        this._externalChanges.length = 0;\n    };\n\n    /**\n     * Receives a result from the impl\'s watcher callback, and either processes it\n     * immediately (if _activeChangeCount is 0) or otherwise stores it for later\n     * processing.\n     * @param {?string} path The fullPath of the changed entry\n     * @param {FileSystemStats=} stat An optional stat object for the changed entry\n     */\n    FileSystem.prototype._enqueueExternalChange = function (path, stat) {\n        this._externalChanges.push({path: path, stat: stat});\n        if (!this._activeChangeCount) {\n            this._triggerExternalChangesNow();\n        }\n    };\n\n\n    /**\n     * The queue of pending watch/unwatch requests.\n     * @type {Array.<{fn: function(), cb: function()}>}\n     */\n    FileSystem.prototype._watchRequests = null;\n\n    /**\n     * Dequeue and process all pending watch/unwatch requests\n     */\n    FileSystem.prototype._dequeueWatchRequest = function () {\n        if (this._watchRequests.length > 0) {\n            var request = this._watchRequests[0];\n\n            request.fn.call(null, function () {\n                // Apply the given callback\n                var callbackArgs = arguments;\n                try {\n                    request.cb.apply(null, callbackArgs);\n                } finally {\n                    // Process the remaining watch/unwatch requests\n                    this._watchRequests.shift();\n                    this._dequeueWatchRequest();\n                }\n            }.bind(this));\n        }\n    };\n\n    /**\n     * Enqueue a new watch/unwatch request.\n     *\n     * @param {function()} fn - The watch/unwatch request function.\n     * @param {callback()} cb - The callback for the provided watch/unwatch\n     *      request function.\n     */\n    FileSystem.prototype._enqueueWatchRequest = function (fn, cb) {\n        // Enqueue the given watch/unwatch request\n        this._watchRequests.push({fn: fn, cb: cb});\n\n        // Begin processing the queue if it is not already being processed\n        if (this._watchRequests.length === 1) {\n            this._dequeueWatchRequest();\n        }\n    };\n\n    /**\n     * The set of watched roots, encoded as a mapping from full paths to WatchedRoot\n     * objects which contain a file entry, filter function, and an indication of\n     * whether the watched root is inactive, starting up or fully active.\n     *\n     * @type {Object.<string, WatchedRoot>}\n     */\n    FileSystem.prototype._watchedRoots = null;\n\n    /**\n     * Finds a parent watched root for a given path, or returns null if a parent\n     * watched root does not exist.\n     *\n     * @param {string} fullPath The child path for which a parent watched root is to be found\n     * @return {?{entry: FileSystemEntry, filter: function(string) boolean}} The parent\n     *      watched root, if it exists, or null.\n     */\n    FileSystem.prototype._findWatchedRootForPath = function (fullPath) {\n        var watchedRoot = null;\n\n        Object.keys(this._watchedRoots).some(function (watchedPath) {\n            if (fullPath.indexOf(watchedPath) === 0) {\n                watchedRoot = this._watchedRoots[watchedPath];\n                return true;\n            }\n        }, this);\n\n        return watchedRoot;\n    };\n\n    /**\n     * Helper function to watch or unwatch a filesystem entry beneath a given\n     * watchedRoot.\n     *\n     * @private\n     * @param {FileSystemEntry} entry - The FileSystemEntry to watch. Must be a\n     *      non-strict descendent of watchedRoot.entry.\n     * @param {WatchedRoot} watchedRoot - See FileSystem._watchedRoots.\n     * @param {function(?string)} callback - A function that is called once the\n     *      watch is complete, possibly with a FileSystemError string.\n     * @param {boolean} shouldWatch - Whether the entry should be watched (true)\n     *      or unwatched (false).\n     */\n    FileSystem.prototype._watchOrUnwatchEntry = function (entry, watchedRoot, callback, shouldWatch) {\n        var impl = this._impl,\n            recursiveWatch = impl.recursiveWatch,\n            commandName = shouldWatch ? "watchPath" : "unwatchPath";\n\n        if (recursiveWatch) {\n            // The impl can watch the entire subtree with one call on the root (we also fall into this case for\n            // unwatch, although that never requires us to do the recursion - see similar final case below)\n            if (entry !== watchedRoot.entry) {\n                // Watch and unwatch calls to children of the watched root are\n                // no-ops if the impl supports recursiveWatch\n                callback(null);\n            } else {\n                // The impl will handle finding all subdirectories to watch.\n                this._enqueueWatchRequest(function (requestCb) {\n                    impl[commandName].call(impl, entry.fullPath, requestCb);\n                }.bind(this), callback);\n            }\n        } else if (shouldWatch) {\n            // The impl can\'t handle recursive watch requests, so it\'s up to the\n            // filesystem to recursively watch all subdirectories.\n            this._enqueueWatchRequest(function (requestCb) {\n                // First construct a list of entries to watch or unwatch\n                var entriesToWatch = [];\n\n                var visitor = function (child) {\n                    if (watchedRoot.filter(child.name, child.parentPath)) {\n                        if (child.isDirectory || child === watchedRoot.entry) {\n                            entriesToWatch.push(child);\n                        }\n                        return true;\n                    }\n                    return false;\n                };\n\n                entry.visit(visitor, function (err) {\n                    if (err) {\n                        // Unexpected error\n                        requestCb(err);\n                        return;\n                    }\n\n                    // Then watch or unwatched all these entries\n                    var count = entriesToWatch.length;\n                    if (count === 0) {\n                        requestCb(null);\n                        return;\n                    }\n\n                    var watchCallback = function () {\n                        if (--count === 0) {\n                            requestCb(null);\n                        }\n                    };\n\n                    entriesToWatch.forEach(function (entry) {\n                        impl.watchPath(entry.fullPath, watchCallback);\n                    });\n                });\n            }, callback);\n        } else {\n            // Unwatching never requires enumerating the subfolders (which is good, since after a\n            // delete/rename we may be unable to do so anyway)\n            this._enqueueWatchRequest(function (requestCb) {\n                impl.unwatchPath(entry.fullPath, requestCb);\n            }, callback);\n        }\n    };\n\n    /**\n     * Watch a filesystem entry beneath a given watchedRoot.\n     *\n     * @private\n     * @param {FileSystemEntry} entry - The FileSystemEntry to watch. Must be a\n     *      non-strict descendent of watchedRoot.entry.\n     * @param {WatchedRoot} watchedRoot - See FileSystem._watchedRoots.\n     * @param {function(?string)} callback - A function that is called once the\n     *      watch is complete, possibly with a FileSystemError string.\n     */\n    FileSystem.prototype._watchEntry = function (entry, watchedRoot, callback) {\n        this._watchOrUnwatchEntry(entry, watchedRoot, callback, true);\n    };\n\n    /**\n     * Unwatch a filesystem entry beneath a given watchedRoot.\n     *\n     * @private\n     * @param {FileSystemEntry} entry - The FileSystemEntry to watch. Must be a\n     *      non-strict descendent of watchedRoot.entry.\n     * @param {WatchedRoot} watchedRoot - See FileSystem._watchedRoots.\n     * @param {function(?string)} callback - A function that is called once the\n     *      watch is complete, possibly with a FileSystemError string.\n     */\n    FileSystem.prototype._unwatchEntry = function (entry, watchedRoot, callback) {\n        this._watchOrUnwatchEntry(entry, watchedRoot, function (err) {\n            // Make sure to clear cached data for all unwatched entries because\n            // entries always return cached data if it exists!\n            this._index.visitAll(function (child) {\n                if (child.fullPath.indexOf(entry.fullPath) === 0) {\n                    // \'true\' so entry doesn\'t try to clear its immediate childrens\' caches too. That would be redundant\n                    // with the visitAll() here, and could be slow if we\'ve already cleared its parent (#7150).\n                    child._clearCachedData(true);\n                }\n            }.bind(this));\n\n            callback(err);\n        }.bind(this), false);\n    };\n\n    /**\n     * Initialize this FileSystem instance.\n     *\n     * @param {FileSystemImpl} impl The back-end implementation for this\n     *      FileSystem instance.\n     */\n    FileSystem.prototype.init = function (impl) {\n        console.assert(!this._impl, "This FileSystem has already been initialized!");\n\n        var changeCallback = this._enqueueExternalChange.bind(this),\n            offlineCallback = this._unwatchAll.bind(this);\n\n        this._impl = impl;\n        this._impl.initWatchers(changeCallback, offlineCallback);\n    };\n\n    /**\n     * Close a file system. Clear all caches, indexes, and file watchers.\n     */\n    FileSystem.prototype.close = function () {\n        this._impl.unwatchAll();\n        this._index.clear();\n    };\n\n    /**\n     * Returns true if the given path should be automatically added to the index & watch list when one of its ancestors\n     * is a watch-root. (Files are added automatically when the watch-root is first established, or later when a new\n     * directory is created and its children enumerated).\n     *\n     * Entries explicitly created via FileSystem.getFile/DirectoryForPath() are *always* added to the index regardless\n     * of this filtering - but they will not be watched if the watch-root\'s filter excludes them.\n     *\n     * @param {string} path Full path\n     * @param {string} name Name portion of the path\n     */\n    FileSystem.prototype._indexFilter = function (path, name) {\n        var parentRoot = this._findWatchedRootForPath(path);\n\n        if (parentRoot) {\n            return parentRoot.filter(name, path);\n        }\n\n        // It might seem more sensible to return false (exclude) for files outside the watch roots, but\n        // that would break usage of appFileSystem for \'system\'-level things like enumerating extensions.\n        // (Or in general, Directory.getContents() for any Directory outside the watch roots).\n        return true;\n    };\n\n    /**\n     * Indicates that a filesystem-mutating operation has begun. As long as there\n     * are changes taking place, change events from the external watchers are\n     * blocked and queued, to be handled once changes have finished. This is done\n     * because for mutating operations that originate from within the filesystem,\n     * synthetic change events are fired that do not depend on external file\n     * watchers, and we prefer the former over the latter for the following\n     * reasons: 1) there is no delay; and 2) they may have higher fidelity ---\n     * e.g., a rename operation can be detected as such, instead of as a nearly\n     * simultaneous addition and deletion.\n     *\n     * All operations that mutate the file system MUST begin with a call to\n     * _beginChange and must end with a call to _endChange.\n     */\n    FileSystem.prototype._beginChange = function () {\n        this._activeChangeCount++;\n        //console.log("> beginChange  -> " + this._activeChangeCount);\n    };\n\n    /**\n     * Indicates that a filesystem-mutating operation has completed. See\n     * FileSystem._beginChange above.\n     */\n    FileSystem.prototype._endChange = function () {\n        this._activeChangeCount--;\n        //console.log("< endChange    -> " + this._activeChangeCount);\n\n        if (this._activeChangeCount < 0) {\n            console.error("FileSystem _activeChangeCount has fallen below zero!");\n        }\n\n        if (!this._activeChangeCount) {\n            this._triggerExternalChangesNow();\n        }\n    };\n\n    /**\n     * Determines whether or not the supplied path is absolute, as opposed to relative.\n     *\n     * @param {!string} fullPath\n     * @return {boolean} True if the fullPath is absolute and false otherwise.\n     */\n    FileSystem.isAbsolutePath = function (fullPath) {\n        return (fullPath[0] === "/" || (fullPath[1] === ":" && fullPath[2] === "/"));\n    };\n\n    function _ensureTrailingSlash(path) {\n        if (path[path.length - 1] !== "/") {\n            path += "/";\n        }\n\n        return path;\n    }\n\n    /*\n     * Matches continguous groups of forward slashes\n     * @const\n     */\n    var _DUPLICATED_SLASH_RE = /\\/{2,}/g;\n\n    /**\n     * Returns a canonical version of the path: no duplicated "/"es, no ".."s,\n     * and directories guaranteed to end in a trailing "/"\n     * @param {!string} path  Absolute path, using "/" as path separator\n     * @param {boolean=} isDirectory\n     * @return {!string}\n     */\n    FileSystem.prototype._normalizePath = function (path, isDirectory) {\n\n        if (!FileSystem.isAbsolutePath(path)) {\n            throw new Error("Paths must be absolute: \'" + path + "\'");  // expect only absolute paths\n        }\n\n        var isUNCPath = this._impl.normalizeUNCPaths && path.search(_DUPLICATED_SLASH_RE) === 0;\n\n        // Remove duplicated "/"es\n        path = path.replace(_DUPLICATED_SLASH_RE, "/");\n\n        // Remove ".." segments\n        if (path.indexOf("..") !== -1) {\n            var segments = path.split("/"),\n                i;\n            for (i = 1; i < segments.length; i++) {\n                if (segments[i] === "..") {\n                    if (i < 2) {\n                        throw new Error("Invalid absolute path: \'" + path + "\'");\n                    }\n                    segments.splice(i - 1, 2);\n                    i -= 2; // compensate so we start on the right index next iteration\n                }\n            }\n            path = segments.join("/");\n        }\n\n        if (isDirectory) {\n            // Make sure path DOES include trailing slash\n            path = _ensureTrailingSlash(path);\n        }\n\n        if (isUNCPath) {\n            // Restore the leading double slash that was removed previously\n            path = "/" + path;\n        }\n\n        return path;\n    };\n\n    /**\n     * This method adds an entry for a file in the file Index. Files on disk are added\n     * to the file index either on load or on open. This method is primarily needed to add\n     * in memory files to the index\n     *\n     * @param {File} The fileEntry which needs to be added\n     * @param {String} The full path to the file\n     */\n    FileSystem.prototype.addEntryForPathIfRequired = function (fileEntry, path) {\n        var entry = this._index.getEntry(path);\n\n        if (!entry) {\n            this._index.addEntry(fileEntry);\n        }\n    };\n\n    /**\n     * Return a (strict subclass of a) FileSystemEntry object for the specified\n     * path using the provided constuctor. For now, the provided constructor\n     * should be either File or Directory.\n     *\n     * @private\n     * @param {function(string, FileSystem)} EntryConstructor Constructor with\n     *      which to initialize new FileSystemEntry objects.\n     * @param {string} path Absolute path of file.\n     * @return {File|Directory} The File or Directory object. This file may not\n     *      yet exist on disk.\n     */\n    FileSystem.prototype._getEntryForPath = function (EntryConstructor, path) {\n        var isDirectory = EntryConstructor === Directory;\n        path = this._normalizePath(path, isDirectory);\n        var entry = this._index.getEntry(path);\n\n        if (!entry) {\n            entry = new EntryConstructor(path, this);\n            this._index.addEntry(entry);\n        }\n\n        return entry;\n    };\n\n    /**\n     * Return a File object for the specified path.\n     *\n     * @param {string} path Absolute path of file.\n     *\n     * @return {File} The File object. This file may not yet exist on disk.\n     */\n    FileSystem.prototype.getFileForPath = function (path) {\n        return this._getEntryForPath(File, path);\n    };\n\n    /**\n     * Return a Directory object for the specified path.\n     *\n     * @param {string} path Absolute path of directory.\n     *\n     * @return {Directory} The Directory object. This directory may not yet exist on disk.\n     */\n    FileSystem.prototype.getDirectoryForPath = function (path) {\n        return this._getEntryForPath(Directory, path);\n    };\n\n    /**\n     * Resolve a path.\n     *\n     * @param {string} path The path to resolve\n     * @param {function (?string, FileSystemEntry=, FileSystemStats=)} callback Callback resolved\n     *      with a FileSystemError string or with the entry for the provided path.\n     */\n    FileSystem.prototype.resolve = function (path, callback) {\n        var normalizedPath = this._normalizePath(path, false),\n            item = this._index.getEntry(normalizedPath);\n\n        if (!item) {\n            normalizedPath = _ensureTrailingSlash(normalizedPath);\n            item = this._index.getEntry(normalizedPath);\n        }\n\n        if (item) {\n            item.stat(function (err, stat) {\n                if (err) {\n                    callback(err);\n                    return;\n                }\n\n                callback(null, item, stat);\n            });\n        } else {\n            this._impl.stat(path, function (err, stat) {\n                if (err) {\n                    callback(err);\n                    return;\n                }\n\n                if (stat.isFile) {\n                    item = this.getFileForPath(path);\n                } else {\n                    item = this.getDirectoryForPath(path);\n                }\n\n                if (item._isWatched()) {\n                    item._stat = stat;\n                }\n\n                callback(null, item, stat);\n            }.bind(this));\n        }\n    };\n\n    /**\n     * Show an "Open" dialog and return the file(s)/directories selected by the user.\n     *\n     * @param {boolean} allowMultipleSelection Allows selecting more than one file at a time\n     * @param {boolean} chooseDirectories Allows directories to be opened\n     * @param {string} title The title of the dialog\n     * @param {string} initialPath The folder opened inside the window initially. If initialPath\n     *                          is not set, or it doesn\'t exist, the window would show the last\n     *                          browsed folder depending on the OS preferences\n     * @param {?Array.<string>} fileTypes (Currently *ignored* except on Mac - https://trello.com/c/430aXkpq)\n     *                          List of extensions that are allowed to be opened, without leading ".".\n     *                          Null or empty array allows all files to be selected. Not applicable\n     *                          when chooseDirectories = true.\n     * @param {function (?string, Array.<string>=)} callback Callback resolved with a FileSystemError\n     *                          string or the selected file(s)/directories. If the user cancels the\n     *                          open dialog, the error will be falsy and the file/directory array will\n     *                          be empty.\n     */\n    FileSystem.prototype.showOpenDialog = function (allowMultipleSelection,\n                            chooseDirectories,\n                            title,\n                            initialPath,\n                            fileTypes,\n                            callback) {\n\n        this._impl.showOpenDialog(allowMultipleSelection, chooseDirectories, title, initialPath, fileTypes, callback);\n    };\n\n    /**\n     * Show a "Save" dialog and return the path of the file to save.\n     *\n     * @param {string} title The title of the dialog.\n     * @param {string} initialPath The folder opened inside the window initially. If initialPath\n     *                          is not set, or it doesn\'t exist, the window would show the last\n     *                          browsed folder depending on the OS preferences.\n     * @param {string} proposedNewFilename Provide a new file name for the user. This could be based on\n     *                          on the current file name plus an additional suffix\n     * @param {function (?string, string=)} callback Callback that is resolved with a FileSystemError\n     *                          string or the name of the file to save. If the user cancels the save,\n     *                          the error will be falsy and the name will be empty.\n     */\n    FileSystem.prototype.showSaveDialog = function (title, initialPath, proposedNewFilename, callback) {\n        this._impl.showSaveDialog(title, initialPath, proposedNewFilename, callback);\n    };\n\n    /**\n     * Fire a rename event. Clients listen for these events using FileSystem.on.\n     *\n     * @param {string} oldPath The entry\'s previous fullPath\n     * @param {string} newPath The entry\'s current fullPath\n     */\n    FileSystem.prototype._fireRenameEvent = function (oldPath, newPath) {\n        this.trigger("rename", oldPath, newPath);\n    };\n\n    /**\n     * Fire a change event. Clients listen for these events using FileSystem.on.\n     *\n     * @param {File|Directory} entry The entry that has changed\n     * @param {Array<File|Directory>=} added If the entry is a directory, this\n     *      is a set of new entries in the directory.\n     * @param {Array<File|Directory>=} removed If the entry is a directory, this\n     *      is a set of removed entries from the directory.\n     */\n    FileSystem.prototype._fireChangeEvent = function (entry, added, removed) {\n        this.trigger("change", entry, added, removed);\n    };\n\n    /**\n     * @private\n     * Notify the system when an entry name has changed.\n     *\n     * @param {string} oldFullPath\n     * @param {string} newFullPath\n     * @param {boolean} isDirectory\n     */\n    FileSystem.prototype._handleRename = function (oldFullPath, newFullPath, isDirectory) {\n        // Update all affected entries in the index\n        this._index.entryRenamed(oldFullPath, newFullPath, isDirectory);\n    };\n\n    /**\n     * Notify the filesystem that the given directory has changed. Updates the filesystem\'s\n     * internal state as a result of the change, and calls back with the set of added and\n     * removed entries. Mutating FileSystemEntry operations should call this method before\n     * applying the operation\'s callback, and pass along the resulting change sets in the\n     * internal change event.\n     *\n     * @param {Directory} directory The directory that has changed.\n     * @param {function(Array<File|Directory>=, Array<File|Directory>=)} callback\n     *      The callback that will be applied to a set of added and a set of removed\n     *      FileSystemEntry objects.\n     */\n    FileSystem.prototype._handleDirectoryChange = function (directory, callback) {\n        var oldContents = directory._contents;\n\n        directory._clearCachedData();\n        directory.getContents(function (err, contents) {\n            var addedEntries = oldContents && contents.filter(function (entry) {\n                return oldContents.indexOf(entry) === -1;\n            });\n\n            var removedEntries = oldContents && oldContents.filter(function (entry) {\n                return contents.indexOf(entry) === -1;\n            });\n\n            // If directory is not watched, clear children\'s caches manually.\n            var watchedRoot = this._findWatchedRootForPath(directory.fullPath);\n            if (!watchedRoot || !watchedRoot.filter(directory.name, directory.parentPath)) {\n                this._index.visitAll(function (entry) {\n                    if (entry.fullPath.indexOf(directory.fullPath) === 0) {\n                        // Passing \'true\' for a similar reason as in _unwatchEntry() - see #7150\n                        entry._clearCachedData(true);\n                    }\n                }.bind(this));\n\n                callback(addedEntries, removedEntries);\n                return;\n            }\n\n            var addedCounter = addedEntries ? addedEntries.length : 0,\n                removedCounter = removedEntries ? removedEntries.length : 0,\n                counter = addedCounter + removedCounter;\n\n            if (counter === 0) {\n                callback(addedEntries, removedEntries);\n                return;\n            }\n\n            var watchOrUnwatchCallback = function (err) {\n                if (err) {\n                    console.error("FileSystem error in _handleDirectoryChange after watch/unwatch entries: " + err);\n                }\n\n                if (--counter === 0) {\n                    callback(addedEntries, removedEntries);\n                }\n            };\n\n            if (addedEntries) {\n                addedEntries.forEach(function (entry) {\n                    this._watchEntry(entry, watchedRoot, watchOrUnwatchCallback);\n                }, this);\n            }\n\n            if (removedEntries) {\n                removedEntries.forEach(function (entry) {\n                    this._unwatchEntry(entry, watchedRoot, watchOrUnwatchCallback);\n                }, this);\n            }\n        }.bind(this));\n    };\n\n    /**\n     * @private\n     * Processes a result from the file/directory watchers. Watch results are sent from the low-level implementation\n     * whenever a directory or file is changed.\n     *\n     * @param {string} path The path that changed. This could be a file or a directory.\n     * @param {FileSystemStats=} stat Optional stat for the item that changed. This param is not always\n     *         passed.\n     */\n    FileSystem.prototype._handleExternalChange = function (path, stat) {\n\n        if (!path) {\n            // This is a "wholesale" change event; clear all caches\n            this._index.visitAll(function (entry) {\n                // Passing \'true\' for a similar reason as in _unwatchEntry() - see #7150\n                entry._clearCachedData(true);\n            });\n\n            this._fireChangeEvent(null);\n            return;\n        }\n\n        path = this._normalizePath(path, false);\n\n        var entry = this._index.getEntry(path);\n        if (entry) {\n            var oldStat = entry._stat;\n            if (entry.isFile) {\n                // Update stat and clear contents, but only if out of date\n                if (!(stat && oldStat && stat.mtime.getTime() === oldStat.mtime.getTime())) {\n                    entry._clearCachedData();\n                    entry._stat = stat;\n                    this._fireChangeEvent(entry);\n                }\n            } else {\n                this._handleDirectoryChange(entry, function (added, removed) {\n                    entry._stat = stat;\n\n                    if (entry._isWatched()) {\n                        // We send a change even if added & removed are both zero-length. Something may still have changed,\n                        // e.g. a file may have been quickly removed & re-added before we got a chance to reread the directory\n                        // listing.\n                        this._fireChangeEvent(entry, added, removed);\n                    }\n                }.bind(this));\n            }\n        }\n    };\n\n    /**\n     * Clears all cached content. Because of the performance implications of this, this should only be used if\n     * there is a suspicion that the file system has not been updated through the normal file watchers\n     * mechanism.\n     */\n    FileSystem.prototype.clearAllCaches = function () {\n        this._handleExternalChange(null);\n    };\n\n    /**\n     * Start watching a filesystem root entry.\n     *\n     * @param {FileSystemEntry} entry - The root entry to watch. If entry is a directory,\n     *      all subdirectories that aren\'t explicitly filtered will also be watched.\n     * @param {function(string): boolean} filter - Returns true if a particular item should\n     *      be watched, given its name (not full path). Items that are ignored are also\n     *      filtered from Directory.getContents() results within this subtree.\n     * @param {function(?string)=} callback - A function that is called when the watch has\n     *      completed. If the watch fails, the function will have a non-null FileSystemError\n     *      string parametr.\n     */\n    FileSystem.prototype.watch = function (entry, filter, callback) {\n        var fullPath = entry.fullPath;\n\n        callback = callback || function () {};\n\n        var watchingParentRoot = this._findWatchedRootForPath(fullPath);\n        if (watchingParentRoot &&\n                (watchingParentRoot.status === WatchedRoot.STARTING ||\n                 watchingParentRoot.status === WatchedRoot.ACTIVE)) {\n            callback("A parent of this root is already watched");\n            return;\n        }\n\n        var watchingChildRoot = Object.keys(this._watchedRoots).some(function (path) {\n            var watchedRoot = this._watchedRoots[path],\n                watchedPath = watchedRoot.entry.fullPath;\n\n            return watchedPath.indexOf(fullPath) === 0;\n        }, this);\n\n        if (watchingChildRoot &&\n                (watchingChildRoot.status === WatchedRoot.STARTING ||\n                 watchingChildRoot.status === WatchedRoot.ACTIVE)) {\n            callback("A child of this root is already watched");\n            return;\n        }\n\n        var watchedRoot = new WatchedRoot(entry, filter);\n\n        this._watchedRoots[fullPath] = watchedRoot;\n\n        // Enter the STARTING state early to indiate that watched Directory\n        // objects may cache their contents. See FileSystemEntry._isWatched.\n        watchedRoot.status = WatchedRoot.STARTING;\n\n        this._watchEntry(entry, watchedRoot, function (err) {\n            if (err) {\n                console.warn("Failed to watch root: ", entry.fullPath, err);\n                delete this._watchedRoots[fullPath];\n                callback(err);\n                return;\n            }\n\n            watchedRoot.status = WatchedRoot.ACTIVE;\n\n            callback(null);\n        }.bind(this));\n    };\n\n    /**\n     * Stop watching a filesystem root entry.\n     *\n     * @param {FileSystemEntry} entry - The root entry to stop watching. The unwatch will\n     *      if the entry is not currently being watched.\n     * @param {function(?string)=} callback - A function that is called when the unwatch has\n     *      completed. If the unwatch fails, the function will have a non-null FileSystemError\n     *      string parameter.\n     */\n    FileSystem.prototype.unwatch = function (entry, callback) {\n        var fullPath = entry.fullPath,\n            watchedRoot = this._watchedRoots[fullPath];\n\n        callback = callback || function () {};\n\n        if (!watchedRoot) {\n            callback(FileSystemError.ROOT_NOT_WATCHED);\n            return;\n        }\n\n        // Mark this as inactive, but don\'t delete the entry until the unwatch is complete.\n        // This is useful for making sure we don\'t try to concurrently watch overlapping roots.\n        watchedRoot.status = WatchedRoot.INACTIVE;\n\n        this._unwatchEntry(entry, watchedRoot, function (err) {\n            delete this._watchedRoots[fullPath];\n\n            this._index.visitAll(function (child) {\n                if (child.fullPath.indexOf(entry.fullPath) === 0) {\n                    this._index.removeEntry(child);\n                }\n            }.bind(this));\n\n            if (err) {\n                console.warn("Failed to unwatch root: ", entry.fullPath, err);\n                callback(err);\n                return;\n            }\n\n            callback(null);\n        }.bind(this));\n    };\n\n    /**\n     * Unwatch all watched roots. Calls unwatch on the underlying impl for each\n     * watched root and ignores errors.\n     * @private\n     */\n    FileSystem.prototype._unwatchAll = function () {\n        console.warn("File watchers went offline!");\n\n        Object.keys(this._watchedRoots).forEach(function (path) {\n            var watchedRoot = this._watchedRoots[path];\n\n            watchedRoot.status = WatchedRoot.INACTIVE;\n            delete this._watchedRoots[path];\n            this._unwatchEntry(watchedRoot.entry, watchedRoot, function () {\n                console.warn("Watching disabled for", watchedRoot.entry.fullPath);\n            });\n        }, this);\n\n        // Fire a wholesale change event, clearing all caches and request that\n        // clients manually update their state.\n        this._handleExternalChange(null);\n    };\n\n\n    // The singleton instance\n    var _instance;\n\n    function _wrap(func) {\n        return function () {\n            return func.apply(_instance, arguments);\n        };\n    }\n\n    // Export public methods as proxies to the singleton instance\n    exports.init = _wrap(FileSystem.prototype.init);\n    exports.close = _wrap(FileSystem.prototype.close);\n    exports.shouldShow = _wrap(FileSystem.prototype.shouldShow);\n    exports.getFileForPath = _wrap(FileSystem.prototype.getFileForPath);\n    exports.addEntryForPathIfRequired = _wrap(FileSystem.prototype.addEntryForPathIfRequired);\n    exports.getDirectoryForPath = _wrap(FileSystem.prototype.getDirectoryForPath);\n    exports.resolve = _wrap(FileSystem.prototype.resolve);\n    exports.showOpenDialog = _wrap(FileSystem.prototype.showOpenDialog);\n    exports.showSaveDialog = _wrap(FileSystem.prototype.showSaveDialog);\n    exports.watch = _wrap(FileSystem.prototype.watch);\n    exports.unwatch = _wrap(FileSystem.prototype.unwatch);\n    exports.clearAllCaches = _wrap(FileSystem.prototype.clearAllCaches);\n\n    // Static public utility methods\n    exports.isAbsolutePath = FileSystem.isAbsolutePath;\n\n    // For testing only\n    exports._getActiveChangeCount = _wrap(FileSystem.prototype._getActiveChangeCount);\n\n    /**\n     * Add an event listener for a FileSystem event.\n     *\n     * @param {string} event The name of the event\n     * @param {function} handler The handler for the event\n     */\n    exports.on = function (event, handler) {\n        _instance.on(event, handler);\n    };\n\n    /**\n     * Remove an event listener for a FileSystem event.\n     *\n     * @param {string} event The name of the event\n     * @param {function} handler The handler for the event\n     */\n    exports.off = function (event, handler) {\n        _instance.off(event, handler);\n    };\n\n    // Export the FileSystem class as "private" for unit testing only.\n    exports._FileSystem = FileSystem;\n\n    // Create the singleton instance\n    _instance = new FileSystem();\n\n    // Initialize the singleton instance\n    _instance.init(require("fileSystemImpl"));\n});\n\n//# sourceURL=/filesystem/FileSystem.js'),
eval('/*\n * Copyright (c) 2012 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */\n/*global define  */\n\n/**\n * Utilities module to provide constants for keyCodes\n */\ndefine(\'utils/KeyEvent\',{\n    DOM_VK_CANCEL: 3,\n    DOM_VK_HELP: 6,\n    DOM_VK_BACK_SPACE: 8,\n    DOM_VK_TAB: 9,\n    DOM_VK_CLEAR: 12,\n    DOM_VK_RETURN: 13,\n    DOM_VK_ENTER: 14,\n    DOM_VK_SHIFT: 16,\n    DOM_VK_CONTROL: 17,\n    DOM_VK_ALT: 18,\n    DOM_VK_PAUSE: 19,\n    DOM_VK_CAPS_LOCK: 20,\n    DOM_VK_ESCAPE: 27,\n    DOM_VK_SPACE: 32,\n    DOM_VK_PAGE_UP: 33,\n    DOM_VK_PAGE_DOWN: 34,\n    DOM_VK_END: 35,\n    DOM_VK_HOME: 36,\n    DOM_VK_LEFT: 37,\n    DOM_VK_UP: 38,\n    DOM_VK_RIGHT: 39,\n    DOM_VK_DOWN: 40,\n    DOM_VK_PRINTSCREEN: 44,\n    DOM_VK_INSERT: 45,\n    DOM_VK_DELETE: 46,\n    DOM_VK_0: 48,\n    DOM_VK_1: 49,\n    DOM_VK_2: 50,\n    DOM_VK_3: 51,\n    DOM_VK_4: 52,\n    DOM_VK_5: 53,\n    DOM_VK_6: 54,\n    DOM_VK_7: 55,\n    DOM_VK_8: 56,\n    DOM_VK_9: 57,\n    DOM_VK_A: 65,\n    DOM_VK_B: 66,\n    DOM_VK_C: 67,\n    DOM_VK_D: 68,\n    DOM_VK_E: 69,\n    DOM_VK_F: 70,\n    DOM_VK_G: 71,\n    DOM_VK_H: 72,\n    DOM_VK_I: 73,\n    DOM_VK_J: 74,\n    DOM_VK_K: 75,\n    DOM_VK_L: 76,\n    DOM_VK_M: 77,\n    DOM_VK_N: 78,\n    DOM_VK_O: 79,\n    DOM_VK_P: 80,\n    DOM_VK_Q: 81,\n    DOM_VK_R: 82,\n    DOM_VK_S: 83,\n    DOM_VK_T: 84,\n    DOM_VK_U: 85,\n    DOM_VK_V: 86,\n    DOM_VK_W: 87,\n    DOM_VK_X: 88,\n    DOM_VK_Y: 89,\n    DOM_VK_Z: 90,\n    DOM_VK_CONTEXT_MENU: 93,\n    DOM_VK_NUMPAD0: 96,\n    DOM_VK_NUMPAD1: 97,\n    DOM_VK_NUMPAD2: 98,\n    DOM_VK_NUMPAD3: 99,\n    DOM_VK_NUMPAD4: 100,\n    DOM_VK_NUMPAD5: 101,\n    DOM_VK_NUMPAD6: 102,\n    DOM_VK_NUMPAD7: 103,\n    DOM_VK_NUMPAD8: 104,\n    DOM_VK_NUMPAD9: 105,\n    DOM_VK_MULTIPLY: 106,\n    DOM_VK_ADD: 107,\n    DOM_VK_SEPARATOR: 108,\n    DOM_VK_SUBTRACT: 109,\n    DOM_VK_DECIMAL: 110,\n    DOM_VK_DIVIDE: 111,\n    DOM_VK_F1: 112,\n    DOM_VK_F2: 113,\n    DOM_VK_F3: 114,\n    DOM_VK_F4: 115,\n    DOM_VK_F5: 116,\n    DOM_VK_F6: 117,\n    DOM_VK_F7: 118,\n    DOM_VK_F8: 119,\n    DOM_VK_F9: 120,\n    DOM_VK_F10: 121,\n    DOM_VK_F11: 122,\n    DOM_VK_F12: 123,\n    DOM_VK_F13: 124,\n    DOM_VK_F14: 125,\n    DOM_VK_F15: 126,\n    DOM_VK_F16: 127,\n    DOM_VK_F17: 128,\n    DOM_VK_F18: 129,\n    DOM_VK_F19: 130,\n    DOM_VK_F20: 131,\n    DOM_VK_F21: 132,\n    DOM_VK_F22: 133,\n    DOM_VK_F23: 134,\n    DOM_VK_F24: 135,\n    DOM_VK_NUM_LOCK: 144,\n    DOM_VK_SCROLL_LOCK: 145,\n    DOM_VK_SEMICOLON: 186,\n    DOM_VK_EQUALS: 187,\n    DOM_VK_COMMA: 188,\n    DOM_VK_DASH: 189,\n    DOM_VK_PERIOD: 190,\n    DOM_VK_SLASH: 191,\n    DOM_VK_BACK_QUOTE: 192,\n    DOM_VK_OPEN_BRACKET: 219,\n    DOM_VK_BACK_SLASH: 220,\n    DOM_VK_CLOSE_BRACKET: 221,\n    DOM_VK_QUOTE: 222,\n    DOM_VK_META: 224\n\n});\n\n//# sourceURL=/utils/KeyEvent.js'),eval('define(\'text!base-config/keyboard.json\',[],function () { return \'{\\n    "file.newDoc":  [\\n        "Ctrl-N"\\n    ],\\n    "file.open":  [\\n        "Ctrl-O"\\n    ],\\n    "file.close":  [\\n        "Ctrl-W"\\n    ],\\n    "file.openFolder": [\\n        "Ctrl-Alt-O"\\n    ],\\n    "file.close_all":  [\\n        "Ctrl-Shift-W"\\n    ],\\n    "file.save":  [\\n        "Ctrl-S"\\n    ],\\n    "file.saveAll":  [\\n        "Ctrl-Alt-S"\\n    ],\\n    "file.saveAs":  [\\n        "Ctrl-Shift-S"\\n    ],    \\n    "file.liveFilePreview":  [\\n        "Ctrl-Alt-P"\\n    ],\\n    "file.reloadLivePreview": [\\n        {\\n            "key": "Ctrl-Shift-R"\\n        }\\n    ],\\n    "file.previewHighlight":  [\\n        "Ctrl-Shift-C"\\n    ],\\n    "file.quit":  [\\n        "Ctrl-Q"\\n    ],\\n    "edit.undo": [\\n        "Ctrl-Z"\\n    ],\\n    "edit.redo": [\\n        {\\n            "key": "Ctrl-Y"\\n        },\\n        {\\n            "key": "Cmd-Shift-Z",\\n            "platform": "mac"\\n        }\\n    ],\\n    "edit.cut": [\\n        "Ctrl-X"\\n    ],\\n    "edit.copy": [\\n        "Ctrl-C"\\n    ],\\n    "edit.paste": [\\n        "Ctrl-V"\\n    ],\\n    "edit.selectAll":  [\\n        "Ctrl-A"\\n    ],\\n    "edit.selectLine":  [\\n        {\\n            "key": "Ctrl-L"\\n        },\\n        {\\n            "key": "Ctrl-L",\\n            "platform": "mac"\\n        }\\n    ],\\n    "edit.splitSelIntoLines": [\\n        {\\n           "key": "Ctrl-Alt-L"\\n        },\\n        {\\n           "key":"Ctrl-Shift-L",\\n           "platform": "linux"\\n        }\\n    ],\\n    "edit.addCursorToPrevLine": [\\n        {\\n            "key": "Shift-Alt-Up",\\n            "displayKey": "Shift-Alt-↑"\\n        }\\n    ],\\n    "edit.addCursorToNextLine": [\\n        {\\n            "key": "Shift-Alt-Down",\\n            "displayKey": "Shift-Alt-↓"\\n        }\\n    ],\\n    "edit.indent":  [\\n        {\\n            "key": "Ctrl-]"\\n        }\\n    ],\\n    "edit.unindent":  [\\n        {\\n            "key": "Ctrl-["\\n        }\\n    ],\\n    "edit.duplicate":  [\\n        "Ctrl-D"\\n    ],\\n    "edit.deletelines":  [\\n        "Ctrl-Shift-D"\\n    ],\\n    "edit.lineUp":  [\\n        {\\n            "key": "Ctrl-Shift-Up",\\n            "displayKey": "Ctrl-Shift-↑"\\n        },\\n        {\\n            "key": "Cmd-Ctrl-Up",\\n            "displayKey": "Cmd-Ctrl-↑",\\n            "platform": "mac"\\n        }\\n    ],\\n    "edit.lineDown":  [\\n        {\\n            "key": "Ctrl-Shift-Down",\\n            "displayKey": "Ctrl-Shift-↓"\\n        },\\n        {\\n            "key": "Cmd-Ctrl-Down",\\n            "displayKey": "Cmd-Ctrl-↓",\\n            "platform": "mac"\\n        }\\n    ],\\n    "edit.openLineAbove":  [\\n        "Ctrl-Shift-Enter"\\n    ],\\n    "edit.openLineBelow":  [\\n        "Ctrl-Enter"\\n    ],\\n    "edit.lineComment":  [\\n        "Ctrl-/"\\n    ],\\n    "edit.blockComment":  [\\n        {\\n            "key": "Ctrl-Shift-/"\\n        },\\n        {\\n            "key": "Cmd-Opt-/",\\n            "platform": "mac"\\n        }\\n    ],\\n    "edit.showCodeHints":  [\\n        {\\n            "key": "Ctrl-Space"\\n        },\\n        {\\n            "key": "Ctrl-Space",\\n            "platform": "mac"\\n        }\\n    ],\\n    "cmd.find":  [\\n        "Ctrl-F"\\n    ],\\n    "cmd.findInFiles":  [\\n        "Ctrl-Shift-F"\\n    ],\\n    "cmd.replaceInFiles":  [\\n        {\\n            "key": "Ctrl-Shift-H"\\n        },\\n        {\\n            "key": "Cmd-Opt-Shift-F",\\n            "platform": "mac"\\n        }\\n    ],\\n    "cmd.findNext":  [\\n        {\\n            "key": "F3"\\n        },\\n        {\\n            "key": "Cmd-G",\\n            "platform": "mac"\\n        }\\n    ],\\n    "cmd.findPrevious":  [\\n        {\\n            "key": "Shift-F3"\\n        },\\n        {\\n            "key": "Cmd-Shift-G",\\n            "platform": "mac"\\n        }\\n    ],\\n    "cmd.findAllAndSelect": [\\n        {\\n            "key": "Alt-F3"\\n        },\\n        {\\n            "key": "Cmd-Ctrl-G",\\n            "platform": "mac"\\n        }\\n    ],\\n    "cmd.addNextMatch": [\\n        {\\n            "key": "Ctrl-B"\\n        }\\n    ],\\n    "cmd.skipCurrentMatch": [\\n        {\\n            "key": "Ctrl-Shift-B"\\n        }\\n    ],\\n    "cmd.replace":  [\\n        {\\n            "key": "Ctrl-H"\\n        },\\n        {\\n            "key": "Cmd-Opt-F",\\n            "platform": "mac"\\n        }\\n    ],\\n    "view.toggleSidebar":  [\\n        {   \\n            "key" : "Ctrl-Alt-H"\\n        },\\n        {\\n            "key": "Cmd-Shift-H",\\n            "platform": "mac"\\n        }\\n    ],\\n    "view.increaseFontSize":  [\\n        {\\n            "key": "Ctrl-=",\\n            "displayKey": "Ctrl-+"\\n        },\\n        {\\n            "key": "Ctrl-+"\\n        }\\n    ],\\n    "view.decreaseFontSize":  [\\n        {\\n            "key": "Ctrl--",\\n            "displayKey": "Ctrl-−"\\n        }\\n    ],\\n    "view.restoreFontSize":  [\\n        "Ctrl-0"\\n    ],\\n    "view.scrollLineUp":  [\\n        {\\n            "key": "Ctrl-Up",\\n            "displayKey": "Ctrl-\\\\u2191"\\n        },\\n        {\\n            "key": "Ctrl-Opt-Up",\\n            "displayKey": "Ctrl-Opt-\\\\u2191",\\n            "platform": "mac"\\n        }\\n    ],\\n    "view.scrollLineDown":  [\\n        {\\n            "key": "Ctrl-Down",\\n            "displayKey": "Ctrl-\\\\u2193"\\n        },\\n        {\\n            "key": "Ctrl-Opt-Down",\\n            "displayKey": "Ctrl-Opt-\\\\u2193",\\n            "platform": "mac"\\n        }\\n    ],\\n    "navigate.quickOpen":  [\\n        "Ctrl-Shift-O"\\n    ],\\n    "navigate.gotoLine":  [\\n        {\\n            "key": "Ctrl-G"\\n        },\\n        {\\n            "key": "Cmd-L",\\n            "platform": "mac"\\n        }\\n    ],\\n    "navigate.gotoDefinition":  [\\n        "Ctrl-T"\\n    ],\\n    "navigate.jumptoDefinition":  [\\n        "Ctrl-J"\\n    ],\\n    "navigate.gotoFirstProblem":  [\\n        {\\n            "key": "F8"\\n        },\\n        {\\n            "key": "Cmd-\\\'",\\n            "platform": "mac"\\n        }\\n    ],\\n    "navigate.nextDoc":  [\\n        {\\n            "key": "Ctrl-Tab"\\n        },\\n        {\\n            "key": "Ctrl-Tab",\\n            "platform": "mac"\\n        },\\n        {\\n            "key": "Cmd-Shift-]",\\n            "platform": "mac"\\n        }\\n    ],\\n    "navigate.prevDoc":  [\\n        {\\n            "key": "Ctrl-Shift-Tab"\\n        },\\n        {\\n            "key": "Ctrl-Shift-Tab",\\n            "platform": "mac"\\n        },\\n        {\\n            "key": "Cmd-Shift-[",\\n            "platform": "mac"\\n        }\\n    ],\\n    "navigate.nextDocListOrder":  [\\n        {\\n            "key": "Ctrl-PageDown"\\n        }\\n    ],\\n    "navigate.prevDocListOrder":  [\\n        {\\n            "key": "Ctrl-PageUp"\\n        }\\n    ],\\n    "navigate.toggleQuickEdit":  [\\n        "Ctrl-E"\\n    ],\\n    "navigate.toggleQuickDocs":  [\\n        "Ctrl-K"\\n    ],\\n    "navigate.previousMatch":  [\\n        {\\n            "key": "Alt-Up",\\n            "displayKey": "Alt-↑"\\n        }\\n    ],\\n    "navigate.nextMatch":  [\\n        {\\n            "key": "Alt-Down",\\n            "displayKey": "Alt-↓"\\n        }\\n    ],\\n    "navigate.newRule":  [\\n        "Ctrl-Alt-N"\\n    ],\\n    "file.rename":  [\\n        "F2"\\n    ],\\n    "help.support": [\\n        "F1"\\n    ]\\n}\\n\';});\n\n//# sourceURL=/text!base-config/keyboard.json'),eval('/*\n * Copyright (c) 2012 Adobe Systems Incorporated. All rights reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining a\n * copy of this software and associated documentation files (the "Software"),\n * to deal in the Software without restriction, including without limitation\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\n * and/or sell copies of the Software, and to permit persons to whom the\n * Software is furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n * DEALINGS IN THE SOFTWARE.\n *\n */\n\n\n/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50, regexp: true */\n/*global define, $, brackets, window */\n/*unittests: KeyBindingManager */\n\n/**\n * Manages the mapping of keyboard inputs to commands.\n */\ndefine(\'command/KeyBindingManager\',[\'require\',\'exports\',\'module\',\'utils/Global\',\'utils/AppInit\',\'command/Commands\',\'command/CommandManager\',\'widgets/DefaultDialogs\',\'utils/EventDispatcher\',\'filesystem/FileSystem\',\'filesystem/FileSystemError\',\'file/FileUtils\',\'utils/KeyEvent\',\'strings\',\'utils/StringUtils\',\'utils/UrlParams\',\'thirdparty/lodash\',\'text!base-config/keyboard.json\'],function (require, exports, module) {\n    "use strict";\n\n    require("utils/Global");\n\n    var AppInit             = require("utils/AppInit"),\n        Commands            = require("command/Commands"),\n        CommandManager      = require("command/CommandManager"),\n        DefaultDialogs      = require("widgets/DefaultDialogs"),\n        EventDispatcher     = require("utils/EventDispatcher"),\n        FileSystem          = require("filesystem/FileSystem"),\n        FileSystemError     = require("filesystem/FileSystemError"),\n        FileUtils           = require("file/FileUtils"),\n        KeyEvent            = require("utils/KeyEvent"),\n        Strings             = require("strings"),\n        StringUtils         = require("utils/StringUtils"),\n        UrlParams           = require("utils/UrlParams").UrlParams,\n        _                   = require("thirdparty/lodash");\n\n    var KeyboardPrefs       = JSON.parse(require("text!base-config/keyboard.json"));\n\n    var KEYMAP_FILENAME     = "keymap.json",\n        _userKeyMapFilePath = brackets.app.getApplicationSupportDirectory() + "/" + KEYMAP_FILENAME;\n\n    /**\n     * @private\n     * Maps normalized shortcut descriptor to key binding info.\n     * @type {!Object.<string, {commandID: string, key: string, displayKey: string}>}\n     */\n    var _keyMap            = {},    // For the actual key bindings including user specified ones\n        // For the default factory key bindings, cloned from _keyMap after all extensions are loaded.\n        _defaultKeyMap     = {};\n\n    /**\n     * @typedef {{shortcut: !string,\n     *            commandID: ?string}} UserKeyBinding\n     */\n\n    /**\n     * @private\n     * Maps shortcut descriptor to a command id.\n     * @type {UserKeyBinding}\n     */\n    var _customKeyMap      = {},\n        _customKeyMapCache = {};\n\n    /**\n     * @private\n     * Maps commandID to the list of shortcuts that are bound to it.\n     * @type {!Object.<string, Array.<{key: string, displayKey: string}>>}\n     */\n    var _commandMap  = {};\n\n    /**\n     * @private\n     * An array of command ID for all the available commands including the commands\n     * of installed extensions.\n     * @type {Array.<string>}\n     */\n    var _allCommands = [];\n\n    /**\n     * @private\n     * Maps key names to the corresponding unicode symols\n     * @type {{key: string, displayKey: string}}\n     */\n    var _displayKeyMap        = { "up":    "\\u2191",\n                                  "down":  "\\u2193",\n                                  "left":  "\\u2190",\n                                  "right": "\\u2192",\n                                  "-":     "\\u2212" };\n\n    var _specialCommands      = [Commands.EDIT_UNDO, Commands.EDIT_REDO, Commands.EDIT_SELECT_ALL,\n                                 Commands.EDIT_CUT, Commands.EDIT_COPY, Commands.EDIT_PASTE],\n        _reservedShortcuts    = ["Ctrl-Z", "Ctrl-Y", "Ctrl-A", "Ctrl-X", "Ctrl-C", "Ctrl-V"],\n        _macReservedShortcuts = ["Cmd-,", "Cmd-H", "Cmd-Alt-H", "Cmd-M", "Cmd-Shift-Z", "Cmd-Q"],\n        _keyNames             = ["Up", "Down", "Left", "Right", "Backspace", "Enter", "Space", "Tab",\n                                 "PageUp", "PageDown", "Home", "End", "Insert", "Delete"];\n\n    /**\n     * @private\n     * Flag to show key binding errors in the key map file. Default is true and\n     * it will be set to false when reloading without extensions. This flag is not\n     * used to suppress errors in loading or parsing the key map file. So if the key\n     * map file is corrupt, then the error dialog still shows up.\n     *\n     * @type {boolean}\n     */\n    var _showErrors = true;\n\n    /**\n     * @private\n     * Allow clients to toggle key binding\n     * @type {boolean}\n     */\n    var _enabled = true;\n\n    /**\n     * @private\n     * Stack of registered global keydown hooks.\n     * @type {Array.<function(Event): boolean>}\n     */\n    var _globalKeydownHooks = [];\n\n    /**\n     * @private\n     * Forward declaration for JSLint.\n     * @type {Function}\n     */\n    var _loadUserKeyMap;\n\n    /**\n     * @private\n     * States of Ctrl key down detection\n     * @enum {number}\n     */\n    var CtrlDownStates = {\n        "NOT_YET_DETECTED"    : 0,\n        "DETECTED"            : 1,\n        "DETECTED_AND_IGNORED": 2   // For consecutive ctrl keydown events while a Ctrl key is being hold down\n    };\n\n    /**\n     * @private\n     * Flags used to determine whether right Alt key is pressed. When it is pressed,\n     * the following two keydown events are triggered in that specific order.\n     *\n     *    1. _ctrlDown - flag used to record { ctrlKey: true, keyIdentifier: "Control", ... } keydown event\n     *    2. _altGrDown - flag used to record { ctrlKey: true, altKey: true, keyIdentifier: "Alt", ... } keydown event\n     *\n     * @type {CtrlDownStates|boolean}\n     */\n    var _ctrlDown = CtrlDownStates.NOT_YET_DETECTED,\n        _altGrDown = false;\n\n    /**\n     * @private\n     * Used to record the timeStamp property of the last keydown event.\n     * @type {number}\n     */\n    var _lastTimeStamp;\n\n    /**\n     * @private\n     * Used to record the keyIdentifier property of the last keydown event.\n     * @type {string}\n     */\n    var _lastKeyIdentifier;\n\n    /*\n     * @private\n     * Constant used for checking the interval between Control keydown event and Alt keydown event.\n     * If the right Alt key is down we get Control keydown followed by Alt keydown within 30 ms. if\n     * the user is pressing Control key and then Alt key, the interval will be larger than 30 ms.\n     * @type {number}\n     */\n    var MAX_INTERVAL_FOR_CTRL_ALT_KEYS = 30;\n\n    /**\n     * @private\n     * Forward declaration for JSLint.\n     * @type {Function}\n     */\n    var _onCtrlUp;\n\n    /**\n     * @private\n     * Resets all the flags and removes _onCtrlUp event listener.\n     *\n     */\n    function _quitAltGrMode() {\n        _enabled = true;\n        _ctrlDown = CtrlDownStates.NOT_YET_DETECTED;\n        _altGrDown = false;\n        _lastTimeStamp = null;\n        _lastKeyIdentifier = null;\n        $(window).off("keyup", _onCtrlUp);\n    }\n\n    /**\n     * @private\n     * Detects the release of AltGr key by checking all keyup events\n     * until we receive one with ctrl key code. Once detected, reset\n     * all the flags and also remove this event listener.\n     *\n     * @param {!KeyboardEvent} e keyboard event object\n     */\n    _onCtrlUp = function (e) {\n        var key = e.keyCode || e.which;\n        if (_altGrDown && key === KeyEvent.DOM_VK_CONTROL) {\n            _quitAltGrMode();\n        }\n    };\n\n    /**\n     * @private\n     * Detects whether AltGr key is pressed. When it is pressed, the first keydown event has\n     * ctrlKey === true with keyIdentifier === "Control". The next keydown event with\n     * altKey === true, ctrlKey === true and keyIdentifier === "Alt" is sent within 30 ms. Then\n     * the next keydown event with altKey === true, ctrlKey === true and keyIdentifier === "Control"\n     * is sent. If the user keep holding AltGr key down, then the second and third\n     * keydown events are repeatedly sent out alternately. If the user is also holding down Ctrl\n     * key, then either keyIdentifier === "Control" or keyIdentifier === "Alt" is repeatedly sent\n     * but not alternately.\n     *\n     * Once we detect the AltGr key down, then disable KeyBindingManager and set up a keyup\n     * event listener to detect the release of the altGr key so that we can re-enable KeyBindingManager.\n     * When we detect the addition of Ctrl key besides AltGr key, we also quit AltGr mode and re-enable\n     * KeyBindingManager.\n     *\n     * @param {!KeyboardEvent} e keyboard event object\n     */\n    function _detectAltGrKeyDown(e) {\n        if (brackets.platform !== "win") {\n            return;\n        }\n\n        if (!_altGrDown) {\n            if (_ctrlDown !== CtrlDownStates.DETECTED_AND_IGNORED && e.ctrlKey && e.keyIdentifier === "Control") {\n                _ctrlDown = CtrlDownStates.DETECTED;\n            } else if (e.repeat && e.ctrlKey && e.keyIdentifier === "Control") {\n                // We get here if the user is holding down left/right Control key. Set it to false\n                // so that we don\'t misidentify the combination of Ctrl and Alt keys as AltGr key.\n                _ctrlDown = CtrlDownStates.DETECTED_AND_IGNORED;\n            } else if (_ctrlDown === CtrlDownStates.DETECTED && e.altKey && e.ctrlKey && e.keyIdentifier === "Alt" &&\n                        (e.timeStamp - _lastTimeStamp) < MAX_INTERVAL_FOR_CTRL_ALT_KEYS) {\n                _altGrDown = true;\n                _lastKeyIdentifier = "Alt";\n                _enabled = false;\n                $(window).on("keyup", _onCtrlUp);\n            } else {\n                // Reset _ctrlDown so that we can start over in detecting the two key events\n                // required for AltGr key.\n                _ctrlDown = CtrlDownStates.NOT_YET_DETECTED;\n            }\n            _lastTimeStamp = e.timeStamp;\n        } else if (e.keyIdentifier === "Control" || e.keyIdentifier === "Alt") {\n            // If the user is NOT holding down AltGr key or is also pressing Ctrl key,\n            // then _lastKeyIdentifier will be the same as keyIdentifier in the current\n            // key event. So we need to quit AltGr mode to re-enable KBM.\n            if (e.altKey && e.ctrlKey && e.keyIdentifier === _lastKeyIdentifier) {\n                _quitAltGrMode();\n            } else {\n                _lastKeyIdentifier = e.keyIdentifier;\n            }\n        }\n    }\n\n    /**\n     * @private\n     */\n    function _reset() {\n        _keyMap = {};\n        _defaultKeyMap = {};\n        _customKeyMap = {};\n        _customKeyMapCache = {};\n        _commandMap = {};\n        _globalKeydownHooks = [];\n        _userKeyMapFilePath = brackets.app.getApplicationSupportDirectory() + "/" + KEYMAP_FILENAME;\n    }\n\n    /**\n     * @private\n     * Initialize an empty keymap as the current keymap. It overwrites the current keymap if there is one.\n     * builds the keyDescriptor string from the given parts\n     * @param {boolean} hasCtrl Is Ctrl key enabled\n     * @param {boolean} hasAlt Is Alt key enabled\n     * @param {boolean} hasShift Is Shift key enabled\n     * @param {string} key The key that\'s pressed\n     * @return {string} The normalized key descriptor\n     */\n    function _buildKeyDescriptor(hasMacCtrl, hasCtrl, hasAlt, hasShift, key) {\n        if (!key) {\n            console.log("KeyBindingManager _buildKeyDescriptor() - No key provided!");\n            return "";\n        }\n\n        var keyDescriptor = [];\n\n        if (hasMacCtrl) {\n            keyDescriptor.push("Ctrl");\n        }\n        if (hasAlt) {\n            keyDescriptor.push("Alt");\n        }\n        if (hasShift) {\n            keyDescriptor.push("Shift");\n        }\n\n        if (hasCtrl) {\n            // Windows display Ctrl first, Mac displays Command symbol last\n            if (brackets.platform === "mac") {\n                keyDescriptor.push("Cmd");\n            } else {\n                keyDescriptor.unshift("Ctrl");\n            }\n        }\n\n        keyDescriptor.push(key);\n\n        return keyDescriptor.join("-");\n    }\n\n\n    /**\n     * normalizes the incoming key descriptor so the modifier keys are always specified in the correct order\n     * @param {string} The string for a key descriptor, can be in any order, the result will be Ctrl-Alt-Shift-<Key>\n     * @return {string} The normalized key descriptor or null if the descriptor invalid\n     */\n    function normalizeKeyDescriptorString(origDescriptor) {\n        var hasMacCtrl = false,\n            hasCtrl = false,\n            hasAlt = false,\n            hasShift = false,\n            key = "",\n            error = false;\n\n        function _compareModifierString(left, right) {\n            if (!left || !right) {\n                return false;\n            }\n            left = left.trim().toLowerCase();\n            right = right.trim().toLowerCase();\n\n            return (left.length > 0 && left === right);\n        }\n\n        origDescriptor.split("-").forEach(function parseDescriptor(ele, i, arr) {\n            if (_compareModifierString("ctrl", ele)) {\n                if (brackets.platform === "mac") {\n                    hasMacCtrl = true;\n                } else {\n                    hasCtrl = true;\n                }\n            } else if (_compareModifierString("cmd", ele)) {\n                if (brackets.platform === "mac") {\n                    hasCtrl = true;\n                } else {\n                    error = true;\n                }\n            } else if (_compareModifierString("alt", ele)) {\n                hasAlt = true;\n            } else if (_compareModifierString("opt", ele)) {\n                if (brackets.platform === "mac") {\n                    hasAlt = true;\n                } else {\n                    error = true;\n                }\n            } else if (_compareModifierString("shift", ele)) {\n                hasShift = true;\n            } else if (key.length > 0) {\n                console.log("KeyBindingManager normalizeKeyDescriptorString() - Multiple keys defined. Using key: " + key + " from: " + origDescriptor);\n                error = true;\n            } else {\n                key = ele;\n            }\n        });\n\n        if (error) {\n            return null;\n        }\n\n        // Check to see if the binding is for "-".\n        if (key === "" && origDescriptor.search(/^.+--$/) !== -1) {\n            key = "-";\n        }\n\n        // \'+\' char is valid if it\'s the only key. Keyboard shortcut strings should use\n        // unicode characters (unescaped). Keyboard shortcut display strings may use\n        // unicode escape sequences (e.g. \\u20AC euro sign)\n        if ((key.indexOf("+")) >= 0 && (key.length > 1)) {\n            return null;\n        }\n\n        // Ensure that the first letter of the key name is in upper case and the rest are\n        // in lower case. i.e. \'a\' => \'A\' and \'up\' => \'Up\'\n        if (/^[a-z]/i.test(key)) {\n            key = _.capitalize(key.toLowerCase());\n        }\n\n        // Also make sure that the second word of PageUp/PageDown has the first letter in upper case.\n        if (/^Page/.test(key)) {\n            key = key.replace(/(up|down)$/, function (match, p1) {\n                return _.capitalize(p1);\n            });\n        }\n\n        // No restriction on single character key yet, but other key names are restricted to either\n        // Function keys or those listed in _keyNames array.\n        if (key.length > 1 && !/F\\d+/.test(key) &&\n                _keyNames.indexOf(key) === -1) {\n            return null;\n        }\n\n        return _buildKeyDescriptor(hasMacCtrl, hasCtrl, hasAlt, hasShift, key);\n    }\n\n    /**\n     * @private\n     * Looks for keycodes that have os-inconsistent keys and fixes them.\n     * @param {number} The keycode from the keyboard event.\n     * @param {string} The current best guess at what the key is.\n     * @return {string} If the key is OS-inconsistent, the correct key; otherwise, the original key.\n     **/\n    function _mapKeycodeToKey(keycode, key) {\n        // If keycode represents one of the digit keys (0-9), then return the corresponding digit\n        // by subtracting KeyEvent.DOM_VK_0 from keycode. ie. [48-57] --> [0-9]\n        if (keycode >= KeyEvent.DOM_VK_0 && keycode <= KeyEvent.DOM_VK_9) {\n            return String(keycode - KeyEvent.DOM_VK_0);\n        // Do the same with the numpad numbers\n        // by subtracting KeyEvent.DOM_VK_NUMPAD0 from keycode. ie. [96-105] --> [0-9]\n        } else if (keycode >= KeyEvent.DOM_VK_NUMPAD0 && keycode <= KeyEvent.DOM_VK_NUMPAD9) {\n            return String(keycode - KeyEvent.DOM_VK_NUMPAD0);\n        }\n\n\n        switch (keycode) {\n        case KeyEvent.DOM_VK_SEMICOLON:\n            return ";";\n        case KeyEvent.DOM_VK_EQUALS:\n            return "=";\n        case KeyEvent.DOM_VK_COMMA:\n            return ",";\n        case KeyEvent.DOM_VK_SUBTRACT:\n        case KeyEvent.DOM_VK_DASH:\n            return "-";\n        case KeyEvent.DOM_VK_ADD:\n            return "+";\n        case KeyEvent.DOM_VK_DECIMAL:\n        case KeyEvent.DOM_VK_PERIOD:\n            return ".";\n        case KeyEvent.DOM_VK_DIVIDE:\n        case KeyEvent.DOM_VK_SLASH:\n            return "/";\n        case KeyEvent.DOM_VK_BACK_QUOTE:\n            return "`";\n        case KeyEvent.DOM_VK_OPEN_BRACKET:\n            return "[";\n        case KeyEvent.DOM_VK_BACK_SLASH:\n            return "\\\\";\n        case KeyEvent.DOM_VK_CLOSE_BRACKET:\n            return "]";\n        case KeyEvent.DOM_VK_QUOTE:\n            return "\'";\n        default:\n            return key;\n        }\n    }\n\n    /**\n     * Takes a keyboard event and translates it into a key in a key map\n     */\n    function _translateKeyboardEvent(event) {\n        var hasMacCtrl = (brackets.platform === "mac") ? (event.ctrlKey) : false,\n            hasCtrl = (brackets.platform !== "mac") ? (event.ctrlKey) : (event.metaKey),\n            hasAlt = (event.altKey),\n            hasShift = (event.shiftKey),\n            key = String.fromCharCode(event.keyCode);\n\n        //From the W3C, if we can get the KeyboardEvent.keyIdentifier then look here\n        //As that will let us use keys like then function keys "F5" for commands. The\n        //full set of values we can use is here\n        //http://www.w3.org/TR/2007/WD-DOM-Level-3-Events-20071221/keyset.html#KeySet-Set\n        var ident = event.keyIdentifier;\n        if (ident) {\n            if (ident.charAt(0) === "U" && ident.charAt(1) === "+") {\n                //This is a unicode code point like "U+002A", get the