/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.compiler;

import com.intellij.rt.compiler.JavacResourcesReader;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

public class JavacRunner {
    static /* synthetic */ Class array$Ljava$lang$String;

    public static void main(String[] args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException, IOException {
        String[] newArgs;
        if (!JavacResourcesReader.dumpPatterns()) {
            return;
        }
        String versionString = args[0];
        Class<?> aClass = Class.forName(args[1]);
        Method mainMethod = aClass.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = JavacRunner.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        if (versionString.indexOf("1.1") > -1) {
            int idx;
            Vector<String> arguments = new Vector<String>();
            boolean isClasspath = false;
            for (idx = 3; idx < args.length; ++idx) {
                String arg = args[idx];
                if (arg.startsWith("@") && !isClasspath) {
                    String path = arg.substring(1);
                    JavacRunner.addFilesToCompile(arguments, path);
                    continue;
                }
                isClasspath = "-classpath".equals(arg) || "-cp".equals(arg) || "-bootclasspath".equals(arg);
                arguments.addElement(arg);
            }
            newArgs = new String[arguments.size()];
            for (idx = 0; idx < newArgs.length; ++idx) {
                newArgs[idx] = (String)arguments.elementAt(idx);
            }
        } else {
            newArgs = new String[args.length - 2];
            System.arraycopy(args, 2, newArgs, 0, newArgs.length);
        }
        JavacRunner.expandClasspath(newArgs);
        try {
            mainMethod.invoke(null, new Object[]{newArgs});
        }
        catch (Throwable e) {
            System.err.print(e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFilesToCompile(Vector arguments, String path) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(new File(path)));
            String filePath = reader.readLine();
            while (filePath != null) {
                arguments.addElement(filePath.replace('/', File.separatorChar));
                filePath = reader.readLine();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static void expandClasspath(String[] args) throws IOException {
        for (int idx = 0; idx < args.length; ++idx) {
            String cpValue;
            String arg = args[idx];
            if (!"-classpath".equals(arg) && !"-cp".equals(arg) && !"-bootclasspath".equals(arg) || !(cpValue = args[idx + 1]).startsWith("@")) continue;
            args[idx + 1] = JavacRunner.readClasspath(cpValue.substring(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readClasspath(String filePath) throws IOException {
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(new File(filePath))));
        try {
            String string = JavacRunner.readString(in);
            return string;
        }
        finally {
            in.close();
        }
    }

    private static String readString(DataInput stream) throws IOException {
        int length = stream.readInt();
        if (length == -1) {
            return null;
        }
        char[] chars = new char[length];
        byte[] bytes = new byte[length * 2];
        stream.readFully(bytes);
        int i = 0;
        int i2 = 0;
        while (i < length) {
            chars[i] = (char)((bytes[i2] << 8) + (bytes[i2 + 1] & 0xFF));
            ++i;
            i2 += 2;
        }
        return new String(chars);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

