/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.remote;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc2.SvnRemoteOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnGetProperties;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnRemoteGetRevisionProperties
extends SvnRemoteOperationRunner<SVNProperties, SvnGetProperties> {
    @Override
    public boolean isApplicable(SvnGetProperties operation, SvnWcGeneration wcGeneration) throws SVNException {
        return operation.isRevisionProperties();
    }

    @Override
    protected SVNProperties run() throws SVNException {
        SVNRevision revision = ((SvnGetProperties)this.getOperation()).getRevision();
        if (!revision.isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Valid revision have to be specified to fetch revision property");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        SvnRepositoryAccess access = this.getRepositoryAccess();
        Structure<SvnRepositoryAccess.RepositoryInfo> repositoryInfo = access.createRepositoryFor(((SvnGetProperties)this.getOperation()).getFirstTarget(), SVNRevision.HEAD, SVNRevision.HEAD, null);
        SVNRepository repository = (SVNRepository)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.repository);
        repositoryInfo.release();
        Structure<SvnRepositoryAccess.RevisionsPair> revPair = access.getRevisionNumber(repository, ((SvnGetProperties)this.getOperation()).getFirstTarget(), ((SvnGetProperties)this.getOperation()).getRevision(), null);
        long revNumber = revPair.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        ((SvnGetProperties)this.getOperation()).setRevisionNumber(revNumber);
        SVNProperties revisionProperties = repository.getRevisionProperties(revNumber, null);
        if (revisionProperties != null) {
            ((SvnGetProperties)this.getOperation()).receive(((SvnGetProperties)this.getOperation()).getFirstTarget(), revisionProperties);
        }
        return revisionProperties;
    }
}

