/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import java.util.Set;
import org.jetbrains.plugins.gradle.config.DelegatingGradleSettingsListenerAdapter;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.settings.GradleSystemSettings;

@State(name="GradleSettings", storages={@Storage(file="$PROJECT_FILE$"), @Storage(file="$PROJECT_CONFIG_DIR$/gradle.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class GradleSettings
extends AbstractExternalSystemSettings<GradleSettings, GradleProjectSettings, GradleSettingsListener>
implements PersistentStateComponent<MyState> {
    private final GradleSystemSettings mySystemSettings = GradleSystemSettings.getInstance();

    public GradleSettings(Project project) {
        super(GradleSettingsListener.TOPIC, project);
    }

    public static GradleSettings getInstance(Project project) {
        return (GradleSettings)((Object)ServiceManager.getService((Project)project, GradleSettings.class));
    }

    public void subscribe(ExternalSystemSettingsListener<GradleProjectSettings> listener) {
        this.getProject().getMessageBus().connect((Disposable)this.getProject()).subscribe(GradleSettingsListener.TOPIC, (Object)new DelegatingGradleSettingsListenerAdapter(listener));
    }

    protected void copyExtraSettingsFrom(GradleSettings settings) {
    }

    public MyState getState() {
        MyState state = new MyState();
        this.fillState(state);
        return state;
    }

    public void loadState(MyState state) {
        super.loadState((AbstractExternalSystemSettings.State)state);
    }

    public String getServiceDirectoryPath() {
        return this.mySystemSettings.getServiceDirectoryPath();
    }

    public void setServiceDirectoryPath(String newPath) {
        String myServiceDirectoryPath = this.mySystemSettings.getServiceDirectoryPath();
        if (!Comparing.equal((String)myServiceDirectoryPath, (String)newPath)) {
            this.mySystemSettings.setServiceDirectoryPath(newPath);
            ((GradleSettingsListener)this.getPublisher()).onServiceDirectoryPathChange(myServiceDirectoryPath, newPath);
        }
    }

    public String getGradleVmOptions() {
        return this.mySystemSettings.getGradleVmOptions();
    }

    public void setGradleVmOptions(String gradleVmOptions) {
        String myGradleVmOptions = this.mySystemSettings.getGradleVmOptions();
        if (!Comparing.equal((String)myGradleVmOptions, (String)gradleVmOptions)) {
            this.mySystemSettings.setGradleVmOptions(gradleVmOptions);
            ((GradleSettingsListener)this.getPublisher()).onGradleVmOptionsChange(myGradleVmOptions, gradleVmOptions);
        }
    }

    public boolean isOfflineWork() {
        return this.mySystemSettings.isOfflineWork();
    }

    public void setOfflineWork(boolean isOfflineWork) {
        this.mySystemSettings.setOfflineWork(isOfflineWork);
    }

    protected void checkSettings(GradleProjectSettings old, GradleProjectSettings current) {
        if (!Comparing.equal((String)old.getGradleHome(), (String)current.getGradleHome())) {
            ((GradleSettingsListener)this.getPublisher()).onGradleHomeChange(old.getGradleHome(), current.getGradleHome(), current.getExternalProjectPath());
        }
        if (old.getDistributionType() != current.getDistributionType()) {
            ((GradleSettingsListener)this.getPublisher()).onGradleDistributionTypeChange(current.getDistributionType(), current.getExternalProjectPath());
        }
    }

    public static class MyState
    implements AbstractExternalSystemSettings.State<GradleProjectSettings> {
        private Set<GradleProjectSettings> myProjectSettings = ContainerUtilRt.newTreeSet();

        @AbstractCollection(surroundWithTag=false, elementTypes={GradleProjectSettings.class})
        public Set<GradleProjectSettings> getLinkedExternalProjectsSettings() {
            return this.myProjectSettings;
        }

        public void setLinkedExternalProjectsSettings(Set<GradleProjectSettings> settings) {
            if (settings != null) {
                this.myProjectSettings.addAll(settings);
            }
        }
    }
}

