/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import java.io.IOException;
import java.io.OutputStream;

public class OutputWrapper
extends OutputStream {
    private final ExternalSystemTaskNotificationListener myListener;
    private final ExternalSystemTaskId myTaskId;
    private StringBuilder myBuffer;
    private final boolean myStdOut;

    public OutputWrapper(ExternalSystemTaskNotificationListener listener, ExternalSystemTaskId taskId, boolean stdOut) {
        this.myListener = listener;
        this.myTaskId = taskId;
        this.myStdOut = stdOut;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.myBuffer == null) {
            this.myBuffer = new StringBuilder();
        }
        char c = (char)b;
        this.myBuffer.append(Character.toString(c));
        if (c == '\n') {
            this.doFlush();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int start = off;
        int maxOffset = off + len;
        for (int i = off; i < maxOffset; ++i) {
            if (b[i] != 10) continue;
            if (this.myBuffer == null) {
                this.myBuffer = new StringBuilder();
            }
            this.myBuffer.append(new String(b, start, i - start + 1));
            this.doFlush();
            start = i + 1;
        }
        if (start < maxOffset) {
            if (this.myBuffer == null) {
                this.myBuffer = new StringBuilder();
            }
            this.myBuffer.append(new String(b, start, maxOffset - start));
        }
    }

    private void doFlush() {
        if (this.myBuffer == null) {
            return;
        }
        this.myListener.onTaskOutput(this.myTaskId, this.myBuffer.toString(), this.myStdOut);
        this.myBuffer.setLength(0);
    }
}

