/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.externalSystem.JavaProjectData;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemDebugEnvironment;
import com.intellij.openapi.util.KeyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.idea.BasicIdeaProject;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.util.GradleVersion;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.remote.impl.GradleLibraryNamesMixer;
import org.jetbrains.plugins.gradle.service.execution.UnsupportedCancellationToken;
import org.jetbrains.plugins.gradle.service.project.BaseGradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.project.GradleImportCustomizer;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.settings.ClassHolder;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

public class GradleProjectResolver
implements ExternalSystemProjectResolver<GradleExecutionSettings> {
    private static final Logger LOG = Logger.getInstance((String)("#" + GradleProjectResolver.class.getName()));
    private final GradleExecutionHelper myHelper;
    private final GradleLibraryNamesMixer myLibraryNamesMixer = new GradleLibraryNamesMixer();
    private final MultiMap<ExternalSystemTaskId, CancellationTokenSource> myCancellationMap = MultiMap.create();

    public GradleProjectResolver() {
        this(new GradleExecutionHelper());
    }

    public GradleProjectResolver(GradleExecutionHelper helper) {
        this.myHelper = helper;
    }

    public DataNode<ProjectData> resolveProjectInfo(ExternalSystemTaskId id, String projectPath, boolean isPreviewMode, GradleExecutionSettings settings, ExternalSystemTaskNotificationListener listener) throws ExternalSystemException, IllegalArgumentException, IllegalStateException {
        if (settings != null) {
            this.myHelper.ensureInstalledWrapper(id, projectPath, settings, listener);
        }
        GradleProjectResolverExtension projectResolverChain = GradleProjectResolver.createProjectResolverChain(settings);
        DataNode<ProjectData> resultProjectDataNode = this.myHelper.execute(projectPath, settings, new ProjectConnectionDataNodeFunction(id, projectPath, settings, listener, isPreviewMode, projectResolverChain, false));
        String buildSrcProjectPath = projectPath + "/buildSrc";
        this.handleBuildSrcProject(resultProjectDataNode, new ProjectConnectionDataNodeFunction(id, buildSrcProjectPath, settings, listener, isPreviewMode, projectResolverChain, true));
        return resultProjectDataNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelTask(ExternalSystemTaskId id, ExternalSystemTaskNotificationListener listener) {
        MultiMap<ExternalSystemTaskId, CancellationTokenSource> multiMap = this.myCancellationMap;
        synchronized (multiMap) {
            for (CancellationTokenSource cancellationTokenSource : this.myCancellationMap.get((Object)id)) {
                cancellationTokenSource.cancel();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private DataNode<ProjectData> doResolveProjectInfo(ProjectResolverContext resolverCtx, GradleProjectResolverExtension projectResolverChain, boolean isBuildSrcProject) throws IllegalArgumentException, IllegalStateException {
        IdeaProject ideaProject;
        ProjectImportAction.AllModels allModels;
        ProjectImportAction projectImportAction = new ProjectImportAction(resolverCtx.isPreviewMode());
        ArrayList<KeyValue<String, String>> extraJvmArgs = new ArrayList<KeyValue<String, String>>();
        ArrayList commandLineArgs = ContainerUtil.newArrayList();
        HashSet toolingExtensionClasses = ContainerUtil.newHashSet();
        GradleImportCustomizer importCustomizer = GradleImportCustomizer.get();
        for (GradleProjectResolverExtension resolverExtension = projectResolverChain; resolverExtension != null; resolverExtension = resolverExtension.getNext()) {
            resolverExtension.setProjectResolverContext(resolverCtx);
            resolverExtension.preImportCheck();
            projectImportAction.addExtraProjectModelClasses(resolverExtension.getExtraProjectModelClasses());
            if (importCustomizer == null || importCustomizer.useExtraJvmArgs()) {
                extraJvmArgs.addAll(resolverExtension.getExtraJvmArgs());
            }
            commandLineArgs.addAll(resolverExtension.getExtraCommandLineArgs());
            toolingExtensionClasses.addAll(resolverExtension.getToolingExtensionsClasses());
        }
        ParametersList parametersList = new ParametersList();
        for (KeyValue keyValue : extraJvmArgs) {
            parametersList.addProperty((String)keyValue.getKey(), (String)keyValue.getValue());
        }
        BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(resolverCtx.getConnection());
        Object var11_12 = null;
        if (buildEnvironment != null) {
            GradleVersion gradleVersion = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
        }
        BuildActionExecuter buildActionExecutor = resolverCtx.getConnection().action((BuildAction)projectImportAction);
        File initScript = GradleExecutionHelper.generateInitScript(isBuildSrcProject, toolingExtensionClasses);
        if (initScript != null) {
            ContainerUtil.addAll((Collection)commandLineArgs, (Object[])new String[]{"--init-script", initScript.getAbsolutePath()});
        }
        GradleExecutionHelper.prepare((LongRunningOperation)buildActionExecutor, resolverCtx.getExternalSystemTaskId(), resolverCtx.getSettings(), resolverCtx.getListener(), parametersList.getParameters(), commandLineArgs, resolverCtx.getConnection());
        CancellationTokenSource cancellationTokenSource = GradleConnector.newCancellationTokenSource();
        try {
            buildActionExecutor.withCancellationToken(cancellationTokenSource.token());
            MultiMap<ExternalSystemTaskId, CancellationTokenSource> multiMap = this.myCancellationMap;
            synchronized (multiMap) {
                void var11_14;
                this.myCancellationMap.putValue((Object)resolverCtx.getExternalSystemTaskId(), (Object)cancellationTokenSource);
                if (var11_14 != null && var11_14.compareTo(GradleVersion.version((String)"2.1")) < 0) {
                    this.myCancellationMap.putValue((Object)resolverCtx.getExternalSystemTaskId(), (Object)new UnsupportedCancellationToken());
                }
            }
            allModels = (ProjectImportAction.AllModels)buildActionExecutor.run();
            if (allModels == null) {
                throw new IllegalStateException("Unable to get project model for the project: " + resolverCtx.getProjectPath());
            }
        }
        catch (UnsupportedVersionException unsupportedVersionException) {
            Class aClass = resolverCtx.isPreviewMode() ? BasicIdeaProject.class : IdeaProject.class;
            ModelBuilder<BasicIdeaProject> modelBuilder = this.myHelper.getModelBuilder(aClass, resolverCtx.getExternalSystemTaskId(), resolverCtx.getSettings(), resolverCtx.getConnection(), resolverCtx.getListener(), parametersList.getParameters());
            ideaProject = (IdeaProject)modelBuilder.get();
            allModels = new ProjectImportAction.AllModels(ideaProject);
        }
        finally {
            MultiMap<ExternalSystemTaskId, CancellationTokenSource> unsupportedVersionException = this.myCancellationMap;
            synchronized (unsupportedVersionException) {
                this.myCancellationMap.remove((Object)resolverCtx.getExternalSystemTaskId(), (Object)cancellationTokenSource);
            }
        }
        allModels.setBuildEnvironment(buildEnvironment);
        resolverCtx.setModels(allModels);
        ProjectData projectData = projectResolverChain.createProject();
        DataNode projectDataNode = new DataNode(ProjectKeys.PROJECT, (Object)projectData, null);
        JavaProjectData javaProjectData = projectResolverChain.createJavaProjectData();
        projectDataNode.createChild(JavaProjectData.KEY, (Object)javaProjectData);
        ideaProject = resolverCtx.getModels().getIdeaProject();
        projectResolverChain.populateProjectExtraModels(ideaProject, (DataNode<ProjectData>)projectDataNode);
        DomainObjectSet gradleModules = ideaProject.getModules();
        if (gradleModules == null || gradleModules.isEmpty()) {
            throw new IllegalStateException("No modules found for the target project: " + ideaProject);
        }
        HashMap moduleMap = ContainerUtilRt.newHashMap();
        for (IdeaModule gradleModule : gradleModules) {
            String moduleName;
            if (gradleModule == null) continue;
            if (ExternalSystemDebugEnvironment.DEBUG_ORPHAN_MODULES_PROCESSING) {
                LOG.info(String.format("Importing module data: %s", gradleModule));
            }
            if ((moduleName = gradleModule.getName()) == null) {
                throw new IllegalStateException("Module with undefined name detected: " + gradleModule);
            }
            ModuleData moduleData = projectResolverChain.createModule(gradleModule, projectData);
            Pair previouslyParsedModule = (Pair)moduleMap.get(moduleName);
            if (previouslyParsedModule != null) {
                throw new IllegalStateException(String.format("Modules with duplicate name (%s) detected: '%s' and '%s'", moduleName, moduleData, previouslyParsedModule));
            }
            DataNode moduleDataNode = projectDataNode.createChild(ProjectKeys.MODULE, (Object)moduleData);
            moduleMap.put(moduleName, Pair.create((Object)moduleDataNode, (Object)gradleModule));
            if (!StringUtil.equals((CharSequence)moduleData.getLinkedExternalProjectPath(), (CharSequence)projectData.getLinkedExternalProjectPath())) continue;
            projectData.setGroup(moduleData.getGroup());
            projectData.setVersion(moduleData.getVersion());
        }
        ArrayList allTasks = ContainerUtil.newArrayList();
        for (Pair pair : moduleMap.values()) {
            DataNode moduleDataNode = (DataNode)pair.first;
            IdeaModule ideaModule = (IdeaModule)pair.second;
            projectResolverChain.populateModuleExtraModels(ideaModule, (DataNode<ModuleData>)moduleDataNode);
            projectResolverChain.populateModuleContentRoots(ideaModule, (DataNode<ModuleData>)moduleDataNode);
            projectResolverChain.populateModuleCompileOutputSettings(ideaModule, (DataNode<ModuleData>)moduleDataNode);
            projectResolverChain.populateModuleDependencies(ideaModule, (DataNode<ModuleData>)moduleDataNode, (DataNode<ProjectData>)projectDataNode);
            if (isBuildSrcProject) continue;
            Collection<TaskData> moduleTasks = projectResolverChain.populateModuleTasks(ideaModule, (DataNode<ModuleData>)moduleDataNode, (DataNode<ProjectData>)projectDataNode);
            allTasks.addAll(moduleTasks);
        }
        Collection libraries = ExternalSystemApiUtil.getChildren((DataNode)projectDataNode, (Key)ProjectKeys.LIBRARY);
        this.myLibraryNamesMixer.mixNames(libraries);
        return projectDataNode;
    }

    private void handleBuildSrcProject(DataNode<ProjectData> resultProjectDataNode, final ProjectConnectionDataNodeFunction projectConnectionDataNodeFunction) {
        DataNode moduleDataNode;
        if (projectConnectionDataNodeFunction.myIsPreviewMode || !new File(projectConnectionDataNodeFunction.myProjectPath).isDirectory()) {
            return;
        }
        DataNode buildSrcModuleDataNode = ExternalSystemApiUtil.find(resultProjectDataNode, (Key)ProjectKeys.MODULE, (BooleanFunction)new BooleanFunction<DataNode<ModuleData>>(){

            public boolean fun(DataNode<ModuleData> node) {
                return projectConnectionDataNodeFunction.myProjectPath.equals(((ModuleData)node.getData()).getLinkedExternalProjectPath());
            }
        });
        if (buildSrcModuleDataNode != null) {
            return;
        }
        DataNode<ProjectData> buildSrcProjectDataDataNode = this.myHelper.execute(projectConnectionDataNodeFunction.myProjectPath, projectConnectionDataNodeFunction.mySettings, projectConnectionDataNodeFunction);
        if (buildSrcProjectDataDataNode != null && (moduleDataNode = ExternalSystemApiUtil.find(buildSrcProjectDataDataNode, (Key)ProjectKeys.MODULE, (BooleanFunction)new BooleanFunction<DataNode<ModuleData>>(){

            public boolean fun(DataNode<ModuleData> node) {
                return projectConnectionDataNodeFunction.myProjectPath.equals(((ModuleData)node.getData()).getLinkedExternalProjectPath());
            }
        })) != null) {
            for (DataNode libraryDataNode : ExternalSystemApiUtil.findAll(buildSrcProjectDataDataNode, (Key)ProjectKeys.LIBRARY)) {
                resultProjectDataNode.createChild(libraryDataNode.getKey(), libraryDataNode.getData());
            }
            DataNode newModuleDataNode = resultProjectDataNode.createChild(ProjectKeys.MODULE, moduleDataNode.getData());
            for (DataNode node : moduleDataNode.getChildren()) {
                if (ProjectKeys.MODULE.equals((Object)node.getKey()) || ProjectKeys.MODULE_DEPENDENCY.equals((Object)node.getKey())) continue;
                newModuleDataNode.createChild(node.getKey(), node.getData());
            }
        }
    }

    public static GradleProjectResolverExtension createProjectResolverChain(GradleExecutionSettings settings) {
        GradleProjectResolverExtension projectResolverChain;
        if (settings != null) {
            List<ClassHolder<? extends GradleProjectResolverExtension>> extensionClasses = settings.getResolverExtensions();
            ArrayDeque<GradleProjectResolverExtension> extensions = new ArrayDeque<GradleProjectResolverExtension>();
            for (ClassHolder<? extends GradleProjectResolverExtension> holder : extensionClasses) {
                GradleProjectResolverExtension extension;
                try {
                    extension = holder.getTargetClass().newInstance();
                }
                catch (Throwable e) {
                    throw new IllegalArgumentException(String.format("Can't instantiate project resolve extension for class '%s'", holder.getTargetClassName()), e);
                }
                GradleProjectResolverExtension previous = (GradleProjectResolverExtension)extensions.peekLast();
                if (previous != null) {
                    previous.setNext(extension);
                    if (previous.getNext() != extension) {
                        throw new AssertionError((Object)("Illegal next resolver got, current resolver class is " + previous.getClass().getName()));
                    }
                }
                extensions.add(extension);
            }
            GradleProjectResolverExtension resolverExtension = projectResolverChain = (GradleProjectResolverExtension)extensions.peekFirst();
            assert (resolverExtension != null);
            while (resolverExtension.getNext() != null) {
                resolverExtension = resolverExtension.getNext();
            }
            if (!(resolverExtension instanceof BaseGradleProjectResolverExtension)) {
                throw new AssertionError((Object)("Illegal last resolver got of class " + resolverExtension.getClass().getName()));
            }
        } else {
            projectResolverChain = new BaseGradleProjectResolverExtension();
        }
        return projectResolverChain;
    }

    private class ProjectConnectionDataNodeFunction
    implements Function<ProjectConnection, DataNode<ProjectData>> {
        private final ExternalSystemTaskId myId;
        private final String myProjectPath;
        private final GradleExecutionSettings mySettings;
        private final ExternalSystemTaskNotificationListener myListener;
        private final boolean myIsPreviewMode;
        private final GradleProjectResolverExtension myProjectResolverChain;
        private final boolean myIsBuildSrcProject;

        public ProjectConnectionDataNodeFunction(ExternalSystemTaskId id, String projectPath, GradleExecutionSettings settings, ExternalSystemTaskNotificationListener listener, boolean isPreviewMode, GradleProjectResolverExtension projectResolverChain, boolean isBuildSrcProject) {
            this.myId = id;
            this.myProjectPath = projectPath;
            this.mySettings = settings;
            this.myListener = listener;
            this.myIsPreviewMode = isPreviewMode;
            this.myProjectResolverChain = projectResolverChain;
            this.myIsBuildSrcProject = isBuildSrcProject;
        }

        public DataNode<ProjectData> fun(ProjectConnection connection) {
            try {
                return GradleProjectResolver.this.doResolveProjectInfo(new ProjectResolverContext(this.myId, this.myProjectPath, this.mySettings, connection, this.myListener, this.myIsPreviewMode), this.myProjectResolverChain, this.myIsBuildSrcProject);
            }
            catch (RuntimeException e) {
                LOG.info("Gradle project resolve error", (Throwable)e);
                throw this.myProjectResolverChain.getUserFriendlyError(e, this.myProjectPath, null);
            }
        }
    }
}

