/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.integrations.maven;

import com.intellij.CommonBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.indices.MavenRepositoriesConfigurable;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.plugins.gradle.integrations.maven.MavenRepositoriesHolder;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class ImportMavenRepositoriesTask
implements Runnable {
    private static final String UNINDEXED_MAVEN_REPOSITORIES_NOTIFICATION_GROUP = "Unindexed maven repositories gradle detection";
    private final MavenRemoteRepository mavenCentralRemoteRepository;
    private final Project myProject;

    public ImportMavenRepositoriesTask(Project project) {
        this.myProject = project;
        this.mavenCentralRemoteRepository = new MavenRemoteRepository("central", null, "http://repo1.maven.org/maven2/", null, null, null);
    }

    @Override
    public void run() {
        if (this.myProject.isDisposed()) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        ArrayList psiFileList = ContainerUtil.newArrayList();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            PsiFile psiFile;
            VirtualFile virtualFile;
            String buildScript;
            String modulePath;
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module) || (modulePath = ExternalSystemApiUtil.getExternalProjectPath((Module)module)) == null || StringUtil.isEmpty((String)(buildScript = FileUtil.findFileInProvidedPath((String)modulePath, (String[])new String[]{"build.gradle"}))) || (virtualFile = localFileSystem.refreshAndFindFileByPath(buildScript)) == null || (psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile)) == null) continue;
            psiFileList.add(psiFile);
        }
        final PsiFile[] psiFiles = (PsiFile[])ArrayUtil.toObjectArray((Collection)psiFileList, PsiFile.class);
        Set mavenRemoteRepositories = (Set)new ReadAction<Set<MavenRemoteRepository>>(){

            protected void run(Result<Set<MavenRemoteRepository>> result) throws Throwable {
                HashSet myRemoteRepositories = ContainerUtil.newHashSet();
                for (PsiFile psiFile : psiFiles) {
                    ArrayList repositoriesBlocks = ContainerUtil.newArrayList();
                    repositoriesBlocks.addAll(ImportMavenRepositoriesTask.findClosableBlocks((PsiElement)psiFile, new String[]{"repositories"}));
                    for (GrClosableBlock closableBlock : ImportMavenRepositoriesTask.findClosableBlocks((PsiElement)psiFile, new String[]{"buildscript", "subprojects", "allprojects", "project", "configure"})) {
                        repositoriesBlocks.addAll(ImportMavenRepositoriesTask.findClosableBlocks((PsiElement)closableBlock, new String[]{"repositories"}));
                    }
                    for (GrClosableBlock repositoriesBlock : repositoriesBlocks) {
                        myRemoteRepositories.addAll(ImportMavenRepositoriesTask.this.findMavenRemoteRepositories(repositoriesBlock));
                    }
                }
                result.setResult((Object)myRemoteRepositories);
            }
        }.execute().getResultObject();
        if (mavenRemoteRepositories == null || mavenRemoteRepositories.isEmpty()) {
            return;
        }
        MavenRepositoriesHolder.getInstance(this.myProject).update(mavenRemoteRepositories);
        MavenProjectIndicesManager.getInstance((Project)this.myProject).scheduleUpdateIndicesList((Consumer)new Consumer<List<MavenIndex>>(){

            public void consume(List<MavenIndex> indexes) {
                if (ImportMavenRepositoriesTask.this.myProject.isDisposed()) {
                    return;
                }
                List repositoriesWithEmptyIndex = ContainerUtil.mapNotNull(indexes, (Function)new Function<MavenIndex, String>(){

                    public String fun(MavenIndex index) {
                        return index.getUpdateTimestamp() == -1L && MavenRepositoriesHolder.getInstance(ImportMavenRepositoriesTask.this.myProject).contains(index.getRepositoryPathOrUrl()) ? index.getRepositoryPathOrUrl() : null;
                    }
                });
                if (!repositoriesWithEmptyIndex.isEmpty()) {
                    NotificationData notificationData = new NotificationData(GradleBundle.message("gradle.integrations.maven.notification.not_updated_repository.title", new Object[0]), "\n<br>" + GradleBundle.message("gradle.integrations.maven.notification.not_updated_repository.text", StringUtil.join((Collection)repositoriesWithEmptyIndex, (String)"<br>")), NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
                    notificationData.setBalloonNotification(true);
                    notificationData.setBalloonGroup(ImportMavenRepositoriesTask.UNINDEXED_MAVEN_REPOSITORIES_NOTIFICATION_GROUP);
                    notificationData.setListener("#open", (NotificationListener)new NotificationListener.Adapter(){

                        protected void hyperlinkActivated(Notification notification, HyperlinkEvent e) {
                            ShowSettingsUtil.getInstance().showSettingsDialog(ImportMavenRepositoriesTask.this.myProject, MavenRepositoriesConfigurable.class);
                        }
                    });
                    notificationData.setListener("#disable", (NotificationListener)new NotificationListener.Adapter(){

                        protected void hyperlinkActivated(Notification notification, HyperlinkEvent e) {
                            int result = Messages.showYesNoDialog((Project)ImportMavenRepositoriesTask.this.myProject, (String)"Notification will be disabled for all projects.\n\nSettings | Appearance & Behavior | Notifications | Unindexed maven repositories gradle detection\ncan be used to configure the notification.", (String)"Unindexed Maven Repositories Gradle Detection", (String)"Disable Notification", (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon());
                            if (result == 0) {
                                NotificationsConfigurationImpl.getInstanceImpl().changeSettings(ImportMavenRepositoriesTask.UNINDEXED_MAVEN_REPOSITORIES_NOTIFICATION_GROUP, NotificationDisplayType.NONE, false, false);
                                notification.hideBalloon();
                            }
                        }
                    });
                    ExternalSystemNotificationManager.getInstance((Project)ImportMavenRepositoriesTask.this.myProject).showNotification(GradleConstants.SYSTEM_ID, notificationData);
                }
            }
        });
    }

    private static Collection<? extends GrClosableBlock> findClosableBlocks(PsiElement element, final String ... blockNames) {
        List methodCalls = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)element, GrMethodCall.class);
        return ContainerUtil.mapNotNull((Collection)methodCalls, (Function)new Function<GrMethodCall, GrClosableBlock>(){

            public GrClosableBlock fun(GrMethodCall call) {
                if (call == null || call.getClosureArguments().length != 1) {
                    return null;
                }
                GrExpression expression = call.getInvokedExpression();
                return ArrayUtil.contains((String)expression.getText(), (String[])blockNames) ? call.getClosureArguments()[0] : null;
            }
        });
    }

    private Collection<? extends MavenRemoteRepository> findMavenRemoteRepositories(GrClosableBlock repositoriesBlock) {
        HashSet myRemoteRepositories = ContainerUtil.newHashSet();
        block0: for (GrMethodCall repo : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)repositoriesBlock, GrMethodCall.class)) {
            GrExpression expression;
            GrAssignmentExpression statement;
            List assignmentExpressionList;
            String textUri;
            URI urlArgumentValue;
            String expressionText = repo.getInvokedExpression().getText();
            if ("mavenCentral".equals(expressionText)) {
                myRemoteRepositories.add(this.mavenCentralRemoteRepository);
                continue;
            }
            if ("mavenRepo".equals(expressionText)) {
                for (GrNamedArgument namedArgument : repo.getNamedArguments()) {
                    if (!"url".equals(namedArgument.getLabelName())) continue;
                    urlArgumentValue = ImportMavenRepositoriesTask.resolveUriFromSimpleExpression(namedArgument.getExpression());
                    if (urlArgumentValue == null) continue block0;
                    textUri = urlArgumentValue.toString();
                    myRemoteRepositories.add(new MavenRemoteRepository(textUri, null, textUri, null, null, null));
                    continue block0;
                }
                continue;
            }
            if (!"maven".equals(expressionText) || repo.getClosureArguments().length <= 0) continue;
            List applicationStatementList = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)repo.getClosureArguments()[0], GrApplicationStatement.class);
            if (!applicationStatementList.isEmpty()) {
                URI urlArgumentValue2;
                GrApplicationStatement statement2 = (GrApplicationStatement)applicationStatementList.get(0);
                if (statement2 == null) continue;
                GrExpression expression2 = statement2.getInvokedExpression();
                if ("url".equals(expression2.getText()) && (urlArgumentValue2 = ImportMavenRepositoriesTask.resolveUriFromSimpleExpression(statement2.getExpressionArguments()[0])) != null) {
                    String textUri2 = urlArgumentValue2.toString();
                    myRemoteRepositories.add(new MavenRemoteRepository(textUri2, null, textUri2, null, null, null));
                }
            }
            if ((assignmentExpressionList = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)repo.getClosureArguments()[0], GrAssignmentExpression.class)).isEmpty() || (statement = (GrAssignmentExpression)assignmentExpressionList.get(0)) == null || !"url".equals((expression = statement.getLValue()).getText()) || (urlArgumentValue = ImportMavenRepositoriesTask.resolveUriFromSimpleExpression(statement.getRValue())) == null) continue;
            textUri = urlArgumentValue.toString();
            myRemoteRepositories.add(new MavenRemoteRepository(textUri, null, textUri, null, null, null));
        }
        return myRemoteRepositories;
    }

    private static URI resolveUriFromSimpleExpression(GrExpression expression) {
        if (expression == null) {
            return null;
        }
        try {
            URI uri;
            if (expression instanceof PsiLiteral && (uri = new URI(String.valueOf(((PsiLiteral)PsiLiteral.class.cast(expression)).getValue()))).getScheme() != null && StringUtil.startsWith((CharSequence)uri.getScheme(), (CharSequence)"http")) {
                return uri;
            }
        }
        catch (URISyntaxException ignored) {
            // empty catch block
        }
        try {
            PsiReference reference = expression.getReference();
            if (reference == null) {
                return null;
            }
            PsiElement element = reference.resolve();
            if (element instanceof GrVariable) {
                List grLiterals = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)element, GrLiteral.class);
                if (grLiterals.isEmpty()) {
                    return null;
                }
                URI uri = new URI(String.valueOf(((GrLiteral)grLiterals.get(0)).getValue()));
                if (uri.getScheme() != null && StringUtil.startsWith((CharSequence)"http", (CharSequence)uri.getScheme())) {
                    return uri;
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }
}

