/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.testframework.sm.runner.ui.SMRootTestProxyFormatter;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.TestTreeRenderer;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemExecuteTaskTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleConsoleProperties;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleUrlProvider;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AfterSuiteEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AfterTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.BeforeSuiteEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.BeforeTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.ConfigurationErrorEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.OnOutputEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.ReportLocationEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventType;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.XmlXpathHelper;

public class GradleTestsExecutionConsoleManager
implements ExternalSystemExecutionConsoleManager<ExternalSystemRunConfiguration> {
    private static final Logger LOG = Logger.getInstance(GradleTestsExecutionConsoleManager.class);
    private Map<String, SMTestProxy> testsMap = ContainerUtil.newHashMap();
    private StringBuilder myBuffer = new StringBuilder();
    private final GradleUrlProvider myUrlProvider = new GradleUrlProvider();
    private SMTRunnerConsoleView myExecutionConsole;

    public ProjectSystemId getExternalSystemId() {
        return GradleConstants.SYSTEM_ID;
    }

    public Map<String, SMTestProxy> getTestsMap() {
        return this.testsMap;
    }

    public GradleUrlProvider getUrlProvider() {
        return this.myUrlProvider;
    }

    public SMTRunnerConsoleView getExecutionConsole() {
        return this.myExecutionConsole;
    }

    public ExecutionConsole attachExecutionConsole(ExternalSystemTask task, Project project, ExternalSystemRunConfiguration configuration, Executor executor, ExecutionEnvironment env, ProcessHandler processHandler) throws ExecutionException {
        GradleConsoleProperties properties = new GradleConsoleProperties(configuration, executor);
        this.myExecutionConsole = (SMTRunnerConsoleView)SMTestRunnerConnectionUtil.createAndAttachConsole((String)configuration.getSettings().getExternalSystemId().getReadableName(), (ProcessHandler)processHandler, (TestConsoleProperties)properties, (ExecutionEnvironment)env);
        TestTreeRenderer originalRenderer = (TestTreeRenderer)ObjectUtils.tryCast((Object)this.myExecutionConsole.getResultsViewer().getTreeView().getCellRenderer(), TestTreeRenderer.class);
        if (originalRenderer != null) {
            originalRenderer.setAdditionalRootFormatter(new SMRootTestProxyFormatter(){

                public void format(SMTestProxy.SMRootTestProxy testProxy, TestTreeRenderer renderer) {
                    TestStateInfo.Magnitude magnitude = testProxy.getMagnitudeInfo();
                    if (magnitude == TestStateInfo.Magnitude.RUNNING_INDEX) {
                        renderer.clear();
                        renderer.append(GradleBundle.message("gradle.test.runner.ui.tests.tree.presentation.labels.waiting.tests", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else if (!testProxy.isInProgress() && testProxy.isEmptySuite()) {
                        renderer.clear();
                        renderer.append(GradleBundle.message("gradle.test.runner.ui.tests.tree.presentation.labels.no.tests.were.found", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
            });
        }
        return this.myExecutionConsole;
    }

    public void onOutput(String text, Key processOutputType) {
        if (StringUtil.endsWith((CharSequence)text, (CharSequence)"<ijLogEol/>\n")) {
            this.myBuffer.append(StringUtil.trimEnd((String)text, (String)"<ijLogEol/>\n")).append('\n');
            return;
        }
        this.myBuffer.append(text);
        String trimmedText = this.myBuffer.toString().trim();
        this.myBuffer.setLength(0);
        if (!StringUtil.startsWith((CharSequence)trimmedText, (CharSequence)"<ijLog>") || !StringUtil.endsWith((CharSequence)trimmedText, (CharSequence)"</ijLog>")) {
            if (text.trim().isEmpty()) {
                return;
            }
            this.myExecutionConsole.print(text, ConsoleViewContentType.getConsoleViewType((Key)processOutputType));
            return;
        }
        try {
            XmlXpathHelper xml = new XmlXpathHelper(trimmedText);
            TestEventType eventType = TestEventType.fromValue(xml.queryXml("/ijLog/event/@type"));
            AbstractTestEvent testEvent = null;
            switch (eventType) {
                case CONFIGURATION_ERROR: {
                    testEvent = new ConfigurationErrorEvent(this);
                    break;
                }
                case REPORT_LOCATION: {
                    testEvent = new ReportLocationEvent(this);
                    break;
                }
                case BEFORE_TEST: {
                    testEvent = new BeforeTestEvent(this);
                    break;
                }
                case ON_OUTPUT: {
                    testEvent = new OnOutputEvent(this);
                    break;
                }
                case AFTER_TEST: {
                    testEvent = new AfterTestEvent(this);
                    break;
                }
                case BEFORE_SUITE: {
                    testEvent = new BeforeSuiteEvent(this);
                    break;
                }
                case AFTER_SUITE: {
                    testEvent = new AfterSuiteEvent(this);
                    break;
                }
            }
            if (testEvent != null) {
                testEvent.process(xml);
            }
        }
        catch (XmlXpathHelper.XmlParserException e) {
            LOG.error("Gradle test events parser error", (Throwable)e);
        }
    }

    public boolean isApplicableFor(ExternalSystemTask task) {
        if (task instanceof ExternalSystemExecuteTaskTask) {
            ExternalSystemExecuteTaskTask taskTask = (ExternalSystemExecuteTaskTask)task;
            if (!StringUtil.equals((CharSequence)taskTask.getExternalSystemId().getId(), (CharSequence)GradleConstants.SYSTEM_ID.getId())) {
                return false;
            }
            return ContainerUtil.find((Iterable)taskTask.getTasksToExecute(), (Condition)new Condition<ExternalTaskPojo>(){

                public boolean value(ExternalTaskPojo pojo) {
                    return "test".equals(pojo.getName());
                }
            }) != null;
        }
        return false;
    }

    public AnAction[] getRestartActions() {
        return new AnAction[0];
    }
}

