/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.config;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.compiler.options.CompileStepBeforeRunNoErrorCheck;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.psi.search.ExternalModuleBuildGlobalSearchScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import icons.GradleIcons;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.plugins.gradle.execution.GradleTaskLocation;
import org.jetbrains.plugins.gradle.service.GradleBuildClasspathManager;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.extensions.GroovyRunnableScriptType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;

public class GradleScriptType
extends GroovyRunnableScriptType {
    private static final Pattern MAIN_CLASS_NAME_PATTERN = Pattern.compile("\nSTARTER_MAIN_CLASS=(.*)\n");
    public static final GradleScriptType INSTANCE = new GradleScriptType();

    private GradleScriptType() {
        super("gradle");
    }

    public Icon getScriptIcon() {
        return GradleIcons.Gradle;
    }

    public boolean isConfigurationByLocation(GroovyScriptRunConfiguration existing, Location location) {
        String params = existing.getScriptParameters();
        if (params == null) {
            return false;
        }
        List<String> tasks = GradleScriptType.getTasksTarget(location);
        if (tasks == null) {
            return false;
        }
        String s = StringUtil.join(tasks, (String)" ");
        return params.startsWith(s + " ") || params.equals(s);
    }

    public void tuneConfiguration(GroovyFile file, GroovyScriptRunConfiguration configuration, Location location) {
        List<String> tasks = GradleScriptType.getTasksTarget(location);
        if (tasks != null) {
            String s = StringUtil.join(tasks, (String)" ");
            configuration.setScriptParameters(s);
            configuration.setName("gradle:" + s);
        }
        RunManagerEx.disableTasks((Project)file.getProject(), (RunConfiguration)configuration, (Key[])new Key[]{CompileStepBeforeRun.ID, CompileStepBeforeRunNoErrorCheck.ID});
    }

    private static List<String> getTasksTarget(Location location) {
        if (location instanceof GradleTaskLocation) {
            return ((GradleTaskLocation)location).getTasks();
        }
        PsiElement parent = location.getPsiElement();
        while (parent.getParent() != null && !(parent.getParent() instanceof PsiFile)) {
            parent = parent.getParent();
        }
        if (GradleScriptType.isCreateTaskMethod(parent)) {
            GrExpression[] arguments = ((GrMethodCallExpression)parent).getExpressionArguments();
            if (arguments.length > 0 && arguments[0] instanceof GrLiteral && ((GrLiteral)arguments[0]).getValue() instanceof String) {
                return Collections.singletonList((String)((GrLiteral)arguments[0]).getValue());
            }
        } else if (parent instanceof GrApplicationStatement) {
            PsiElement shiftExpression = parent.getChildren()[1].getChildren()[0];
            if (GradleResolverUtil.isLShiftElement(shiftExpression)) {
                PsiElement shiftiesChild = shiftExpression.getChildren()[0];
                if (shiftiesChild instanceof GrReferenceExpression) {
                    return Collections.singletonList(shiftiesChild.getText());
                }
                if (shiftiesChild instanceof GrMethodCallExpression) {
                    return Collections.singletonList(shiftiesChild.getChildren()[0].getText());
                }
            } else if (shiftExpression instanceof GrMethodCallExpression) {
                return Collections.singletonList(shiftExpression.getChildren()[0].getText());
            }
        }
        return null;
    }

    private static boolean isCreateTaskMethod(PsiElement parent) {
        return parent instanceof GrMethodCallExpression && PsiUtil.isMethodCall((GrMethodCall)((GrMethodCallExpression)parent), (String)"createTask");
    }

    public GroovyScriptRunner getRunner() {
        return new GroovyScriptRunner(){

            public boolean shouldRefreshAfterFinish() {
                return true;
            }

            public boolean isValidModule(Module module) {
                GradleInstallationManager libraryManager = (GradleInstallationManager)ServiceManager.getService(GradleInstallationManager.class);
                return libraryManager.isGradleSdk(OrderEnumerator.orderEntries((Module)module).getAllLibrariesAndSdkClassesRoots());
            }

            public boolean ensureRunnerConfigured(Module module, RunProfile profile, Executor executor, Project project) throws ExecutionException {
                GroovyScriptRunConfiguration configuration;
                String parameters;
                if (project == null || !(profile instanceof GroovyScriptRunConfiguration) || (parameters = (configuration = (GroovyScriptRunConfiguration)profile).getScriptParameters()) != null) {
                    // empty if block
                }
                GradleInstallationManager libraryManager = (GradleInstallationManager)ServiceManager.getService(GradleInstallationManager.class);
                return true;
            }

            public void configureCommandLine(JavaParameters params, Module module, boolean tests, VirtualFile script, GroovyScriptRunConfiguration configuration) throws CantRunException {
                Project project = configuration.getProject();
                String scriptParameters = configuration.getScriptParameters();
                GradleInstallationManager libraryManager = (GradleInstallationManager)ServiceManager.getService(GradleInstallationManager.class);
                if (module == null) {
                    throw new CantRunException("Target module is undefined");
                }
                String rootProjectPath = module.getOptionValue("external.root.project.path");
                if (StringUtil.isEmpty((String)rootProjectPath)) {
                    throw new CantRunException(String.format("Module '%s' is not backed by gradle", module.getName()));
                }
                VirtualFile gradleHome = libraryManager.getGradleHome(module, project, rootProjectPath);
                if (gradleHome == null) {
                    throw new CantRunException("Gradle home can not be found");
                }
                params.setMainClass(GradleScriptType.findMainClass(gradleHome, script, project));
                File[] groovyJars = GroovyConfigUtils.getGroovyAllJars((String)(gradleHome.getPath() + "/lib/"));
                if (groovyJars.length > 0) {
                    params.getClassPath().add(groovyJars[0].getAbsolutePath());
                } else {
                    VirtualFile groovyJar = 1.findGroovyJar((Module)module);
                    if (groovyJar != null) {
                        params.getClassPath().add(groovyJar);
                    }
                }
                String userDefinedClasspath = System.getProperty("gradle.launcher.classpath");
                if (StringUtil.isNotEmpty((String)userDefinedClasspath)) {
                    params.getClassPath().add(userDefinedClasspath);
                } else {
                    List<VirtualFile> roots = libraryManager.getClassRoots(project);
                    if (roots != null) {
                        params.getClassPath().addVirtualFiles(roots);
                    }
                }
                params.getVMParametersList().addParametersString(configuration.getVMParameters());
                params.getVMParametersList().add("-Dgradle.home=" + FileUtil.toSystemDependentName((String)gradleHome.getPath()));
                1.setToolsJar((JavaParameters)params);
                String scriptPath = configuration.getScriptPath();
                if (scriptPath == null) {
                    throw new CantRunException("Target script or gradle project path is undefined");
                }
                if (new File(scriptPath).isFile()) {
                    params.getProgramParametersList().add("--build-file");
                } else {
                    params.getProgramParametersList().add("--project-dir");
                }
                params.getProgramParametersList().add(FileUtil.toSystemDependentName((String)scriptPath));
                params.getProgramParametersList().addParametersString(configuration.getProgramParameters());
                params.getProgramParametersList().addParametersString(scriptParameters);
            }
        };
    }

    private static String findMainClass(VirtualFile gradleHome, VirtualFile script, Project project) {
        PsiFile grFile;
        String userDefined = System.getProperty("gradle.launcher.class");
        if (StringUtil.isNotEmpty((String)userDefined)) {
            return userDefined;
        }
        VirtualFile launcher = gradleHome.findFileByRelativePath("bin/gradle");
        if (launcher == null) {
            launcher = gradleHome.findFileByRelativePath("bin/gradle.bat");
        }
        if (launcher != null) {
            try {
                String candidate;
                String text = StringUtil.convertLineSeparators((String)VfsUtilCore.loadText((VirtualFile)launcher));
                Matcher matcher = MAIN_CLASS_NAME_PATTERN.matcher(text);
                if (matcher.find() && StringUtil.isNotEmpty((String)(candidate = matcher.group(1)))) {
                    return candidate;
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        if (script != null && (grFile = PsiManager.getInstance((Project)project).findFile(script)) != null && JavaPsiFacade.getInstance((Project)project).findClass("org.gradle.BootstrapMain", grFile.getResolveScope()) != null) {
            return "org.gradle.BootstrapMain";
        }
        return "org.gradle.launcher.GradleMain";
    }

    public GlobalSearchScope patchResolveScope(GroovyFile file, GlobalSearchScope baseScope) {
        if (!FileUtilRt.extensionEquals((String)file.getName(), (String)"gradle")) {
            return baseScope;
        }
        GlobalSearchScope result = GlobalSearchScope.EMPTY_SCOPE;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module != null) {
            String modulePath;
            String externalSystemId = module.getOptionValue("external.system.id");
            if (!GradleConstants.SYSTEM_ID.toString().equals(externalSystemId)) {
                return baseScope;
            }
            for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                if (!(entry instanceof JdkOrderEntry)) continue;
                GlobalSearchScope scopeForSdk = LibraryScopeCache.getInstance((Project)module.getProject()).getScopeForSdk((JdkOrderEntry)entry);
                result = result.uniteWith(scopeForSdk);
            }
            if (result == GlobalSearchScope.EMPTY_SCOPE) {
                result = baseScope;
            }
            if ((modulePath = module.getOptionValue("external.linked.project.path")) == null) {
                return result;
            }
            List<VirtualFile> files = GradleBuildClasspathManager.getInstance(file.getProject()).getModuleClasspathEntries(modulePath);
            result = new ExternalModuleBuildGlobalSearchScope(module.getProject(), result.uniteWith((GlobalSearchScope)new NonClasspathDirectoriesScope(files)), modulePath);
        }
        return result;
    }
}

