/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.KeyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import icons.GradleIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.plugins.gradle.codeInsight.actions.AddGradleDslPluginActionHandler;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleDocumentationBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;

public class AddGradleDslPluginAction
extends CodeInsightAction {
    public static final String ID = "AddGradleDslPluginAction";
    static final ThreadLocal<String> TEST_THREAD_LOCAL = new ThreadLocal();
    private final KeyValue[] myPlugins;

    public AddGradleDslPluginAction() {
        this.getTemplatePresentation().setDescription(GradleBundle.message("gradle.codeInsight.action.apply_plugin.description", new Object[0]));
        this.getTemplatePresentation().setText(GradleBundle.message("gradle.codeInsight.action.apply_plugin.text", new Object[0]));
        this.getTemplatePresentation().setIcon(GradleIcons.GradlePlugin);
        List plugins = StringUtil.split((String)"java,groovy,idea,eclipse,scala,antlr,application,ear,jetty,maven,osgi,war,announce,build-announcements,checkstyle,codenarc,eclipse-wtp,findbugs,jdepend,pmd,project-report,signing,sonar", (String)",");
        this.myPlugins = new KeyValue[plugins.size()];
        ContainerUtil.map2Array((Collection)plugins, (Object[])this.myPlugins, (Function)new Function<String, KeyValue>(){

            public KeyValue fun(String o) {
                return AddGradleDslPluginAction.createPluginKey(o);
            }
        });
        Arrays.sort(this.myPlugins, new Comparator<KeyValue>(){

            @Override
            public int compare(KeyValue o1, KeyValue o2) {
                return String.valueOf(o1.getKey()).compareTo(String.valueOf(o2.getKey()));
            }
        });
    }

    protected CodeInsightActionHandler getHandler() {
        return new AddGradleDslPluginActionHandler(this.myPlugins);
    }

    protected boolean isValidForFile(Project project, Editor editor, PsiFile file) {
        if (file instanceof PsiCompiledElement) {
            return false;
        }
        if (!GroovyFileType.GROOVY_FILE_TYPE.equals(file.getFileType())) {
            return false;
        }
        return !"settings.gradle".equals(file.getName()) && file.getName().endsWith("gradle");
    }

    private static KeyValue<String, String> createPluginKey(String pluginName) {
        String description = GradleDocumentationBundle.messageOrDefault(String.format("gradle.documentation.org.gradle.api.Project.apply.plugin.%s.non-html", pluginName), "", new Object[0]);
        return KeyValue.create((Object)pluginName, (Object)description);
    }
}

